% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-SurvData.R
\name{SurvData}
\alias{SurvData}
\alias{survData}
\alias{survData.data.frame}
\title{Creates a data set for survival analysis}
\usage{
survData(data, ...)

\method{survData}{data.frame}(data, ...)
}
\arguments{
\item{data}{a \code{data.frame} containing the following four columns:
\itemize{
\item \code{replicate}: a vector of any class \code{numeric}, \code{character} or \code{factor} for replicate
identification. A given replicate value should identify the same group of
individuals followed in time
\item \code{conc}: a vector of class \code{numeric} with tested concentrations
(positive values, may contain NAs)
\item \code{time}: a vector of class \code{integer} with time points, minimal value must be 0
\item \code{Nsurv}: a vector of class \code{integer} providing the number of
alive individuals at each time point for each concentration and each replicate
(may contain NAs)
}}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
A dataframe of class \code{survData} and column \code{replicate} as \code{factor}.
}
\description{
This function creates a \code{SurvData} object from experimental data
provided as a \code{data.frame}. The resulting object
can then be used for plotting and model fitting. It can also be used
to generate \emph{individual-time} estimates.

The \code{x} argument describes experimental results from a survival
toxicity test. Each line of the \code{data.frame}
corresponds to one experimental measurement, that is a number of alive
individuals at a given concentration at a given time point and in a given replicate.
Note that either the concentration
or the number of alive individuals may be missing. The data set is inferred
to be under constant exposure if the concentration is constant for each
replicate and systematically available. The function \code{survData} fails if
\code{x} does not meet the
expected requirements. Please run \code{\link{survDataCheck}} to ensure
\code{x} is well-formed.
}
\seealso{
\code{\link{survDataCheck}}
}
\keyword{transformation}
