% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_questions.R
\name{generate_question_body}
\alias{generate_question_body}
\title{Generate the question body}
\usage{
generate_question_body(
  type,
  answer,
  a_values,
  fb_correct,
  fb_incorrect,
  fb_partially,
  orientation,
  fb_answer,
  fb_a_values,
  image,
  image_alt,
  fraction
)
}
\arguments{
\item{type}{A string, the question type.}

\item{answer}{A string or vector, the correct answer(s) for the question.}

\item{a_values}{A vector, additional answers for the question.}

\item{fb_correct}{A string, feedback for correct answers.}

\item{fb_incorrect}{A string, feedback for incorrect answers.}

\item{fb_partially}{A string, feedback for partially correct answers.}

\item{orientation}{A string, 'v' or 'h'.}

\item{fb_answer}{A string, answer feedback.}

\item{fb_a_values}{A vector, rest of answer feedback.}

\item{image}{Path to an image file associated with the question.}

\item{image_alt}{Alternative text describing the image for accessibility.}

\item{fraction}{A number between 0 and 1.}
}
\value{
A string containing the question body in XML format.
}
\description{
Creates the body of the question based on its type and additional parameters
such as feedback and orientation.
}
\keyword{internal}
