% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation_stages.R
\name{match}
\alias{match}
\alias{match.mongopipe}
\alias{field}
\alias{field.mongopipe}
\alias{lookup}
\alias{lookup.mongopipe}
\alias{unwind}
\alias{unwind.mongopipe}
\alias{limit}
\alias{limit.mongopipe}
\alias{project}
\alias{project.mongopipe}
\title{Pipeline Stages}
\usage{
match(x, ...)

\method{match}{mongopipe}(x, ...)

field(x, ...)

\method{field}{mongopipe}(x, ...)

lookup(x, ...)

\method{lookup}{mongopipe}(x, from, local_field = from, foreign_field = "_id", as = from, ...)

unwind(x, ...)

\method{unwind}{mongopipe}(x, field, ...)

limit(x, ...)

\method{limit}{mongopipe}(x, limit, ...)

project(x, ...)

\method{project}{mongopipe}(x, ...)
}
\arguments{
\item{x}{Object of class \code{mongopipe}}

\item{...}{list object}

\item{from}{Collection to join}

\item{local_field}{Field from the input documents}

\item{foreign_field}{Field from the documents of the "from" collection}

\item{as}{Name of output array field (Default: \code{from})}

\item{field}{Field to unwind.}

\item{limit}{Integer to limit the number of documents.}
}
\value{
Object of type mongopipe.
}
\description{
These functions translate R code to json readable by Mongodb.
}
