% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{List}
\alias{List}
\title{The List Monad}
\description{
The \code{list} built-in type is a monad with element-wise function application
as \code{\link[=fmap]{fmap()}} and flattening as \code{\link[=join]{join()}}. It follows that \verb{\%>>\%} is a map
operator and \verb{\%>-\%} is a "flat map" operator. The methods are implemented
as wrappers to the \href{https://purrr.tidyverse.org/}{purrr} package.
}
\examples{
\dontshow{if (requireNamespace("purrr", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# The fmap operator corresponds to purrr::map().
list(1, 2) \%>>\% `+`(1)

# The bind operator is a "flat map" that combines output lists.
list(1, 2) \%>-\% \(x) list(x * 2, x / 2)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[purrr:map]{purrr::map()}} which implements \code{\link[=fmap]{fmap()}} for \code{list}.

\code{\link[purrr:list_flatten]{purrr::list_flatten()}} which implements \code{\link[=join]{join()}} for \code{list}.

Other monads: 
\code{\link{Maybe}}
}
\concept{monads}
