% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultipleTables-method-exported.R
\name{MultipleTables.create}
\alias{MultipleTables.create}
\title{Create an object of class \code{MultipleTables}.}
\usage{
MultipleTables.create(data = NULL, measure = NULL, model = NULL)
}
\arguments{
\item{data}{a data frame that contains \code{y1}, \code{n1}, \code{y2}, \code{n2} of multiple tables.}

\item{measure}{a character string specifying a measure. Options are
\code{OR}, \code{RR}, and \code{RD}. \code{OR} is odds
ratio, \code{RR} is relative risk, and \code{RD} is risk difference.}

\item{model}{a character string specifying the model. Options are
\code{Independent} and \code{Sarmanov}. \code{Independent} is
independent beta-binomial model. \code{Sarmanov}is Sarmanov beta-binomial model.}
}
\value{
An object is returned, inheriting from class \code{MultipleTables}.
Objects of this class contain the meta-data for generic functions: \code{MultipleTables.modelFit},
 \code{MultipleTables.summary}, and \code{MultipleTables.plot}.
 The following valuesof the object must be non-null under \code{MultipleTables.create}.
 \item{measure}{the value of \code{measure} argument.}
 \item{model}{the value of \code{model} argument.}
 \item{data}{a data matrix with rows being \code{y1}, \code{n1}, \code{y2}, and \code{n2}.}
}
\description{
Create an object of class \code{MultipleTables}, which is
a components list of exact posterior inference based on multiple 2x2 tables.
}
\examples{
\donttest{
 library(mmeta)
 library(ggplot2)
 ## Analyze the dataset colorectal to conduct exact inference of the odds ratios
 data(colorectal)
 colorectal['study_name'] <- colorectal['studynames']
 multiple_tables_obj <- MultipleTables.create(data=colorectal, measure='OR', model= 'Sarmanov')
 }
}
\seealso{
\code{MultipleTables.modelFit}, \code{MultipleTables.summary}, and \code{MultipleTables.plot}.
}
