% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.welch.R
\name{test.welch}
\alias{test.welch}
\title{Welch's Test}
\usage{
test.welch(formula, data, alternative = c("two.sided", "less", "greater"),
           posthoc = FALSE, conf.level = 0.95, hypo = TRUE, descript = TRUE,
           effsize = FALSE, weighted = FALSE, ref = NULL, correct = FALSE,
           digits = 2, p.digits = 3, as.na = NULL, plot = FALSE, bar = TRUE,
           point = FALSE, ci = TRUE, jitter = FALSE, adjust = TRUE,
           point.size = 3, errorbar.width = 0.1, jitter.size = 1.25,
           jitter.width = 0.05, jitter.height = 0, jitter.alpha = 0.1,
           xlab = NULL, ylab = "y", ylim = NULL, ybreaks = ggplot2::waiver(),
           title = NULL, subtitle = "Confidence Interval", filename = NULL,
           width = NA, height = NA, units = c("in", "cm", "mm", "px"),
           dpi = 600, write = NULL, append = TRUE, check = TRUE, output = TRUE)
}
\arguments{
\item{formula}{a formula of the form \code{y ~ group} where \code{y} is
a numeric variable giving the data values and \code{group}
a numeric variable, character variable or factor with two
or more than two values or factor levels giving the
corresponding groups.}

\item{data}{a matrix or data frame containing the variables in the
formula \code{formula}.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"}
or \code{"less"}. Note that this argument is only used when
conducting Welch's two-sample t-test.}

\item{posthoc}{logical: if \code{TRUE}, Games-Howell post hoc test for
multiple comparison is conducted when performing Welch's
ANOVA.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence
level of the interval.}

\item{hypo}{logical: if \code{TRUE} (default), null and alternative hypothesis
are shown on the console.}

\item{descript}{logical: if \code{TRUE} (default), descriptive statistics are shown
on the console.}

\item{effsize}{logical: if \code{TRUE}, effect size measure Cohen's d for
Welch's two-sample t-test (see \code{\link{cohens.d}}),
\eqn{\eta^2} and \eqn{\omega^2} for Welch's ANOVA and
Cohen's d for the post hoc tests are shown on the console.}

\item{weighted}{logical: if \code{TRUE}, the weighted pooled standard
deviation is used to compute Cohen's d.}

\item{ref}{a numeric value or character string indicating the reference
group. The standard deviation of the reference group is used
to standardized the mean difference to compute Cohen's d.}

\item{correct}{logical: if \code{TRUE}, correction factor to remove positive
bias in small samples is used.}

\item{digits}{an integer value indicating the number of decimal places
to be used for displaying descriptive statistics and
confidence interval.}

\item{p.digits}{an integer value indicating the number of decimal places
to be used for displaying the \emph{p}-value.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis.}

\item{plot}{logical: if \code{TRUE}, a plot showing error bars for
confidence intervals is drawn.}

\item{bar}{logical: if \code{TRUE} (default), bars representing means
for each groups are drawn.}

\item{point}{logical: if \code{TRUE}, points representing means for
each groups are drawn.}

\item{ci}{logical: if \code{TRUE} (default), error bars representing
confidence intervals are drawn.}

\item{jitter}{logical: if \code{TRUE}, jittered data points are drawn.}

\item{adjust}{logical: if \code{TRUE} (default), difference-adjustment
for the confidence intervals is applied.}

\item{point.size}{a numeric value indicating the \code{size} aesthetic for
the point representing the mean value.}

\item{errorbar.width}{a numeric value indicating the horizontal bar width of
the error bar.}

\item{jitter.size}{a numeric value indicating the \code{size} aesthetic
for the jittered data points.}

\item{jitter.width}{a numeric value indicating the amount of horizontal jitter.}

\item{jitter.height}{a numeric value indicating the amount of vertical jitter.}

\item{jitter.alpha}{ a numeric value between 0 and 1 for specifying the
\code{alpha} argument in the \code{geom_jitter}
function for controlling the opacity of the jittered
data points.}

\item{xlab}{a character string specifying the labels for the x-axis.}

\item{ylab}{a character string specifying the labels for the y-axis.}

\item{ylim}{a numeric vector of length two specifying limits of the
limits of the y-axis.}

\item{ybreaks}{a numeric vector specifying the points at which tick-marks
are drawn at the y-axis.}

\item{title}{a character string specifying the text for the title of
the plot.}

\item{subtitle}{a character string specifying the text for the subtitle of
the plot.}

\item{filename}{a character string indicating the \code{filename}
argument including the file extension in the \code{ggsave}
function. Note that one of \code{".eps"}, \code{".ps"},
\code{".tex"}, \code{".pdf"} (default),
\code{".jpeg"}, \code{".tiff"}, \code{".png"},
\code{".bmp"}, \code{".svg"} or \code{".wmf"} needs
to be specified as file extension in the \code{filename}
argument. Note that plots can only be saved when
\code{plot = TRUE}.}

\item{width}{a numeric value indicating the \code{width} argument
(default is the size of the current graphics device)
in the \code{ggsave} function.}

\item{height}{a numeric value indicating the \code{height} argument
(default is the size of the current graphics device)
in the \code{ggsave} function.}

\item{units}{a character string indicating the \code{units} argument
(default is \code{in}) in the \code{ggsave} function.}

\item{dpi}{a numeric value indicating the \code{dpi} argument
(default is \code{600}) in the \code{ggsave} function.}

\item{write}{a character string naming a text file with file extension
\code{".txt"} (e.g., \code{"Output.txt"}) for writing the
output into a text file.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:

\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{sample}}{type of sample, i.e., one-, two-, or paired sample}
\item{\code{data}}{data frame with the outcome and grouping variable}
\item{\code{formula}}{formula}
\item{\code{args}}{specification of function arguments}
\item{\code{plot}}{ggplot2 object for plotting the results}
\item{\code{result}}{result table}
}
\description{
This function performs Welch's two-sample t-test and Welch's ANOVA including
Games-Howell post hoc test for multiple comparison and provides descriptive
statistics, effect size measures, and a plot showing bars representing means
for each group and error bars for difference-adjusted confidence intervals.
}
\details{
\describe{
\item{\strong{Effect Size Measure}}{By default, Cohen's d based on the non-weighted
standard deviation (i.e., \code{weighted = FALSE}) which does not assume homogeneity
of variance is computed (see Delacre et al., 2021) when requesting an effect size
measure (i.e., \code{effsize = TRUE}). Cohen's d based on the pooled standard
deviation assuming equality of variances between groups can be requested by
specifying \code{weighted = TRUE}.}
}
}
\examples{
#----------------------------------------------------------------------------
# Two-Sample Design

# Example 1a: Two-sided two-sample Welch-test
test.welch(mpg ~ vs, data = mtcars)

# Example 1b: One-sided two-sample Welch-test
test.welch(mpg ~ vs, data = mtcars, alternative = "greater")

# Example 1c: Two-sided two-sample Welch-test, print Cohen's d
test.welch(mpg ~ vs, data = mtcars, effsize = TRUE)

# Example 1d: Two-sided two-sample Welch-test, plot results
test.welch(mpg ~ vs, data = mtcars, plot = TRUE)

#----------------------------------------------------------------------------
# Multiple-Sample Design

# Example 2a: Welch's ANOVA
test.welch(mpg ~ gear, data = mtcars)

# Example 2b: Welch's ANOVA, Games-Howell post hoc test
test.welch(mpg ~ gear, data = mtcars, posthoc = TRUE)

# Example 2c: Welch's ANOVA, print eta-squared and omega-squared
test.welch(mpg ~ gear, data = mtcars, effsize = TRUE)

# Example 2d: Welch's ANOVA, plot results
test.welch(mpg ~ gear, data = mtcars, plot = TRUE)

\dontrun{
# Example 2e: Welch's ANOVA, save plot
test.welch(mpg ~ gear, data = mtcars, plot = TRUE,
           filename = "Multiple-sample_Welch-test.png", width = 6, height = 5)
}
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology
- Using R and SPSS}. John Wiley & Sons.

Delacre, M., Lakens, D., Ley, C., Liu, L., & Leys, C. (2021). Why Hedges' g*s
based on the non-pooled standard deviation should be reported with Welch's t-test.
https://doi.org/10.31234/osf.io/tu6mp
}
\seealso{
\code{\link{test.t}}, \code{\link{test.z}}, \code{\link{test.levene}},
\code{\link{aov.b}}, \code{\link{cohens.d}}, \code{\link{ci.mean.diff}},
\code{\link{ci.mean}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
