% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ok.R
\name{ok}
\alias{ok}
\title{Class of Ordinary Kriging}
\usage{
ok(model, beta = NULL)
}
\arguments{
\item{model}{a kriging model object from \code{DiceKriging::km-class}}

\item{beta}{the trend of the model}
}
\value{
An object of S3 class 'ok' containing
              \item{Kinv}{the inverse of the covariance matrix of the data}
             \item{beta}{the estimated coefficient of the trend}
             \item{y_centred}{the data centred according to the estimated trend}
             \item{sigma_beta}{the standard deviation of the estimation of beta}
             \item{xi}{the kriging predictor}
             \item{updateSd}{a function to calculate the updated kriging variance when
             \code{Xnew} points are added to the Design of Experiments}
             \item{updateSdfast}{a function to calculate the update kriging variance
             when the SUR criterion is minimised over a population which is also the one
             used to estimate it.}
}
\description{
An implementation of Ordinary Kriging based upon a km-class object that should be
faster than usual predict method.
}
\details{
The Ordinary Kriging is a special case of kriging where the trend is supposed to be
and unknown constant. Consequently some linear algebra operations can be reduced by knowning
that the vector of parameter \code{beta} is indeed a real.

The ok class defines three functions: \code{xi} the kriging predictor, \code{updateSd} and
\code{updateSdfast} two methods for updating the kriging variance when some poitns are
virtually added to the model. These two last functions differ in their implementation: the
first one allows for the user to specify which are the predicted points and which are the
added points. The second one outputs a matrix where the kriging variances of all the points
is updated when each one is iteratively added the the Design of Experiments.

The faster between looping \code{updateSd} and using \code{updateSdfast} is indeed problem
dependent (depending on parallel computer, size of the data, etc.) and should be
benchmark by the user.
}
\examples{
# Generate a dataset
X <- data.frame(x1 = rnorm(10), x2 = rnorm(10))
y <- cos(sqrt(rowSums(X^2)))

# Learn a model
krig <- DiceKriging::km(design=X, response=y)

# Create Ordinary Kriging object
OK <- ok(krig)

# Microbenchmark
# create a dataset
X = data.frame(x1 = rnorm(100), x2 = rnorm(100))
microbenchmark::microbenchmark(OK$xi(t(X)), predict(krig, X, type="UK"))

# Check identical results
X <- rnorm(2)
OK$xi(X)[c('mean', 'sd')]
predict(krig, data.frame(x1=X[1], x2=X[2]), type="UK")[c('mean', 'sd')]

}
\author{
Clement WALTER \email{clementwalter@icloud.com}
}
