% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genHarmonic.R
\name{genharmonic}
\alias{genharmonic}
\title{genharmonic function}
\usage{
genharmonic(
  df,
  tname,
  base,
  num,
  sinfun = sin,
  cosfun = cos,
  sname = "s",
  cname = "c",
  power = FALSE
)
}
\arguments{
\item{df}{a data frame}

\item{tname}{a character string, the name of the time variable. Note this variable will be converted using the function as.numeric}

\item{base}{the period of the first harmonic e.g. for harmonics at the sub-weekly level, one might set base=7 if time is measured in days}

\item{num}{the number of harmonic terms to return}

\item{sinfun}{function to compute sin-like components in model. Default is sin, but alternatives include sintri, or any other periodic function defined on [0,2pi]}

\item{cosfun}{function to compute sin-like components in model. Default is cos, but alternatives include costri, or any other periodic function defined on [0,2pi] offset to sinfun by pi/2}

\item{sname}{the prefix of the sin terms, default 's' returns variables 's1', 's2', 's3' etc.}

\item{cname}{the prefix of the cos terms, default 's' returns variables 's1', 's2', 's3' etc.}

\item{power}{logical, if FALSE (the default) it will return the standard Fourier series with sub-harmonics at 1, 1/2, 1/3, 1/4 of the base periodicicy. If TRUE, a power series will be used instead, with harmonics 1, 1/2, 1/4, 1/8 etc. of the base frequency.}
}
\value{
a data frame with the time variable in numeric form and the harmonic components
}
\description{
A function to create harmonic terms ready for a harmonic regression model to be fitted.
}
