% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{pdf_rotate}
\alias{pdf_rotate}
\title{Modify global transformation matrix with additional rotation}
\usage{
pdf_rotate(doc, rads, x = 0, y = 0)
}
\arguments{
\item{doc}{A \code{pdf_doc} object created by \code{\link{create_pdf}()}}

\item{rads}{rotation angle in radians}

\item{x, y}{location to rotate around}
}
\value{
\code{pdf_doc}
}
\description{
Global transformations are cumulative, and these is no operation to reset
the global transformation.
For local transformations use the \code{tf} argument for individual objects.
}
\examples{
doc <- create_pdf() |>
   pdf_rotate(rads = pi)
}
\seealso{
Other transform functions: 
\code{\link{pdf_scale}()},
\code{\link{pdf_translate}()},
\code{\link{tf_rotate}()},
\code{\link{tf_scale}()},
\code{\link{tf_translate}()}

Other global transform functions: 
\code{\link{pdf_scale}()},
\code{\link{pdf_translate}()}
}
\concept{global transform functions}
\concept{transform functions}
