% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipping.R
\name{clip_polygon}
\alias{clip_polygon}
\title{Define a clipping polygon for use as a \code{clip} argument}
\usage{
clip_polygon(xs, ys, id = NULL, rule = "winding")
}
\arguments{
\item{xs, ys}{vertex coordinates. Note: polygon will automatically be closed}

\item{id}{A numeric vector used to separate vertices into multiple polygons.
All vertices with the same id belong to the same polygon. Default: NULL
means that all vertices belong to a single polygon.}

\item{rule}{fill rule. 'winding' or 'evenodd'.  Default: 'winding'}
}
\value{
clipping polygon specification
}
\description{
Define a clipping polygon for use as a \code{clip} argument
}
\examples{
doc <- create_pdf() |>
   pdf_rect(0, 0, 100, 100, clip = clip_polygon(xs = c(0, 100, 100), 
   ys = c(0, 0, 100)))
}
\seealso{
Other clipping functions: 
\code{\link{clip_rect}()},
\code{\link{pdf_clip_polygon}()},
\code{\link{pdf_clip_rect}()}
}
\concept{clipping functions}
