% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mild.R
\name{mild}
\alias{mild}
\title{Create a mild object}
\usage{
mild(bag_label, bag_name, instance_name)
}
\arguments{
\item{bag_label}{The bag label or response, recorded as 0 = negative, 1 =
positive.}

\item{bag_name}{A unique bag identifier for each instance.}

\item{instance_name}{A unique instance identifier for each sample.}
}
\value{
An object of class \code{mild}.  Currently, no methods are implemented for
this.
}
\description{
Create a \code{mild} object, usually used as a response variable in a model
formula.
}
\examples{

mil_data <- generate_mild_df(positive_degree = 3, nbag = 10)
with(mil_data, head(mild(bag_label, bag_name, instance_name)))
df <- get_all_vars(mild(bag_label, bag_name) ~ X1 + X2, data = mil_data)
head(df)

}
\seealso{
Other multiple instance formula helper functions: 
\code{\link{mi}()}
}
\author{
Sean Kent
}
\concept{multiple instance formula helper functions}
