% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelectorRandom.R
\name{dict_selectors_random}
\alias{dict_selectors_random}
\alias{SelectorRandom}
\title{Random Selector}
\description{
Random selector that disregards fitness and individual values and selects individuals randomly. Depending on the configuration parameter \code{replace},
it samples with or without replacement.
}
\section{Configuration Parameters}{

\itemize{
\item \code{sample_unique} :: \code{character(1)}\cr
Whether to sample individuals globally unique (\code{"global"}), unique within groups (\code{"groups"}), or not unique at all (\code{"no"}, sample with replacement).
This is done with best effort; if \code{group_size} (when \code{sample_unique} is \code{"groups"}) or \code{n_select} (when \code{sample_unique} is \code{"global"})
is greater than \code{nrow(values)}, then individuals are selected with as few repeats as possible. Initialized to \code{"groups"}.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Domain]{Domain}} classes are: \code{\link[paradox:Domain]{p_lgl}} ('ParamLgl'), \code{\link[paradox:Domain]{p_int}} ('ParamInt'), \code{\link[paradox:Domain]{p_dbl}} ('ParamDbl'), \code{\link[paradox:Domain]{p_fct}} ('ParamFct')
}

\section{Dictionary}{

This \code{\link{Selector}} can be created with the short access form \code{\link[=sel]{sel()}}
(\code{\link[=sels]{sels()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_selectors}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
sel("random")
sels("random")  # takes vector IDs, returns list of Selectors

# long form:
dict_selectors$get("random")
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
sr = sel("random")
p = ps(x = p_dbl(-5, 5))
# dummy data; note that SelectorRandom does not depend on data content
data = data.frame(x = rep(0, 5))
fitnesses = c(1, 5, 2, 3, 0)

sr$prime(p)

sr$operate(data, fitnesses, 2)
sr$operate(data, fitnesses, 2)
sr$operate(data, fitnesses, 2)

sr$operate(data, fitnesses, 4)
sr$operate(data, fitnesses, 4)
sr$operate(data, fitnesses, 4)
}
\seealso{
Other selectors: 
\code{\link{Selector}},
\code{\link{SelectorScalar}},
\code{\link{dict_selectors_best}},
\code{\link{dict_selectors_maybe}},
\code{\link{dict_selectors_null}},
\code{\link{dict_selectors_proxy}},
\code{\link{dict_selectors_sequential}},
\code{\link{dict_selectors_tournament}}
}
\concept{selectors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Selector]{miesmuschel::Selector}} -> \code{SelectorRandom}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SelectorRandom-new}{\code{SelectorRandom$new()}}
\item \href{#method-SelectorRandom-clone}{\code{SelectorRandom$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SelectorRandom-new"></a>}}
\if{latex}{\out{\hypertarget{method-SelectorRandom-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{SelectorRandom} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SelectorRandom$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SelectorRandom-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SelectorRandom-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SelectorRandom$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
