% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_r_methods.R
\name{forecast.midas_r}
\alias{forecast.midas_r}
\alias{forecast}
\title{Forecast MIDAS regression}
\usage{
\method{forecast}{midas_r}(
  object,
  newdata = NULL,
  se = FALSE,
  level = c(80, 95),
  fan = FALSE,
  npaths = 999,
  method = c("static", "dynamic"),
  insample = get_estimation_sample(object),
  show_progress = TRUE,
  add_ts_info = FALSE,
  ...
)
}
\arguments{
\item{object}{midas_r object}

\item{newdata}{a named list containing future values of mixed frequency regressors. The default is \code{NULL}, meaning that only in-sample data is used.}

\item{se}{logical, if \code{TRUE}, the prediction intervals are calculated}

\item{level}{confidence level for prediction intervals}

\item{fan}{if TRUE, level is set to seq(50,99,by=1). This is suitable for fan plots}

\item{npaths}{the number of samples for simulating prediction intervals}

\item{method}{the forecasting method, either \code{"static"} or \code{"dynamic"}}

\item{insample}{a list containing the historic mixed frequency data}

\item{show_progress}{logical, if \code{TRUE}, the progress bar is shown if \code{se = TRUE}}

\item{add_ts_info}{logical, if \code{TRUE}, the forecast is cast as \code{ts} object. Some attempts are made to guess the correct start, by assuming that the response variable is a \code{ts} object of \code{frequency} 1. If \code{FALSE}, then the result is simply a numeric vector.}

\item{...}{additional arguments to \code{simulate.midas_r}}
}
\value{
an object of class \code{"forecast"}, a list containing following elements:

\item{method}{the name of forecasting method: MIDAS regression, static or dynamic}
\item{model}{original object of class \code{midas_r}}
\item{mean}{point forecasts}
\item{lower}{lower limits for prediction intervals}
\item{upper}{upper limits for prediction intervals}
\item{fitted}{fitted values, one-step forecasts}
\item{residuals}{residuals from the fitted model}
\item{x}{the original response variable}

The methods \code{print}, \code{summary} and \code{plot} from package \code{forecast} can be used on the object.
}
\description{
Forecasts MIDAS regression given the future values of regressors. For dynamic models (with lagged response variable) there is an option to calculate dynamic forecast, when forecasted values of response variable are substituted into the lags of response variable.
}
\details{
Given future values of regressors this function combines the historical values used in the fitting the MIDAS regression model and calculates the forecasts.
}
\examples{
data("USrealgdp")
data("USunempr")

y <- diff(log(USrealgdp))
x <- window(diff(USunempr), start = 1949)
trend <- 1:length(y)

##24 high frequency lags of x included
mr <- midas_r(y ~ trend + fmls(x, 23, 12, nealmon), start = list(x = rep(0, 3)))

##Forecast horizon
h <- 3
##Declining unemployment
xn <- rep(-0.1, 12*h)
##New trend values
trendn <- length(y) + 1:h

##Static forecasts combining historic and new high frequency data
forecast(mr, list(trend = trendn, x = xn), method = "static")

##Dynamic AR* model
mr.dyn <- midas_r(y ~ trend + mls(y, 1:2, 1, "*")
                   + fmls(x, 11, 12, nealmon),
                  start = list(x = rep(0, 3)))

forecast(mr.dyn, list(trend = trendn, x = xn), method = "dynamic")

##Use print, summary and plot methods from package forecast

fmr <- forecast(mr, list(trend = trendn, x = xn), method = "static")
fmr
summary(fmr)
plot(fmr)
}
\author{
Vaidotas Zemlys
}
