% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fracplot.R
\name{fracplot}
\alias{fracplot}
\alias{plot_mfp}
\title{Plot response functions from a fitted \code{mfp2} object}
\usage{
fracplot(
  model,
  terms = NULL,
  partial_only = FALSE,
  type = c("terms", "contrasts"),
  ref = NULL,
  terms_seq = c("data", "equidistant"),
  alpha = 0.05,
  color_points = "#AAAAAA",
  color_line = "#000000",
  color_fill = "#000000",
  shape = 1,
  size_points = 1,
  linetype = "solid",
  linewidth = 1,
  alpha_fill = 0.1
)

plot_mfp(...)
}
\arguments{
\item{model}{fitted \code{mfp2} model.}

\item{terms}{character vector with variable names to be plotted.}

\item{partial_only}{a logical value indicating whether only the partial
predictor (component) is drawn (\code{TRUE}), or also component-plus-residual
(\code{FALSE}, the default). Only used if \code{type = "terms"}. See below for details.}

\item{type, ref, terms_seq}{arguments of \code{\link[=predict.mfp2]{predict.mfp2()}}. Only
\code{type = "terms"} and \code{type = "contrasts"} are supported by this function.}

\item{alpha}{\code{alpha} argument of \code{\link[=predict.mfp2]{predict.mfp2()}}.}

\item{color_line, linetype, linewidth}{\code{ggplot2} properties of line for
partial predictor.}

\item{color_fill, alpha_fill}{\code{ggplot2} properties of ribbon for confidence
interval.}

\item{shape, size_points, color_points}{\code{ggplot2} properties of drawn
data points.}

\item{...}{used in alias \code{plot_mfp} to pass arguments.}
}
\value{
A list of \code{ggplot2} plot objects, one for each term requested. Can be
drawn as individual plots or facetted / combined easily using e.g.
\code{patchwork::wrap_plots} and further customized.
}
\description{
Plots the partial linear predictors with confidence limits
against the selected covariate(s) of interest.
}
\details{
The confidence limits of the partial linear predictors or contrasts are
obtained from the variance–covariance matrix of the final fitted model,
which takes into account the uncertainty in estimating the model parameters
but not the FP powers. This can lead to narrow confidence intervals. A simple
way to obtain more realistic confidence intervals within the FP is by using
bootstrap, which is not currently implemented. See Royston and Sauerbrei (2008)
chapter 4.9.2 for guidance on conducting bootstrapping within
the FP class.

The component-plus-residual, is the partial linear predictor plus residuals,
where deviance residuals are used in generalized linear regression models,
while martingale residuals are used in Cox models, as done in Stata mfp program.
This kind of plot is only available if \code{type = "terms"}.
}
\section{Functions}{
\itemize{
\item \code{plot_mfp()}: Alias for fracplot.

}}
\examples{

# Gaussian response
data("prostate")
x = as.matrix(prostate[,2:8])
y = as.numeric(prostate$lpsa)
# default interface
fit = mfp2(x, y, verbose = FALSE)
fracplot(fit) # generate plots

}
\seealso{
\code{\link[=predict.mfp2]{predict.mfp2()}}
}
