% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{create_dummy_variables}
\alias{create_dummy_variables}
\title{Simple function to create dummy variables for ordinal and nominal variables}
\usage{
create_dummy_variables(
  data,
  var_ordinal = NULL,
  var_nominal = NULL,
  drop_variables = FALSE
)
}
\arguments{
\item{data}{A dataframe containing the ordinal variable.}

\item{var_ordinal}{Names of ordinal variables in the data for which dummy variables should be created.}

\item{var_nominal}{Names of nominal variables in the data for which dummy variables should be created.}

\item{drop_variables}{Specifies whether to drop the original variables after dummy variables have
been created. The default value is FALSE, and the original variables are kept in the data.}
}
\value{
A dataframe with new dummy variables.
}
\description{
Simple function to create dummy variables for ordinal and nominal variables
}
\details{
This function creates dummy variables based on ordinal and categorical coding described in
the Royston and Sauerbrei (2008) book (Chapter 3, Table 3.5). It uses the levels of
the categorical variable if they exist; otherwise, it will extract the unique values of the
variable, sort them, and use them as levels. We recommend that the user sets the levels of
categorical variables and specifies their reference group. You can use the factor() function in
base R. If the levels are 1, 2, and 3, then 1 will be the reference group. On the other hand,
if the levels are 3, 2, and 1, then 3 will be the reference group. In brief, the first
level will be taken as the reference group.
}
\examples{
data("gbsg")
# create dummy variable for grade using ordinal coding
gbsg <- create_dummy_variables(gbsg, var_ordinal = "grade", drop_variables = TRUE)
head(gbsg)

}
