#' A small toy data set created from a feature table in MetaboScape style
#'
#' The raw feature table is also included.
#' This tibble can be reproduced with `metamorphr::read_featuretable(system.file("extdata", "toy_metaboscape.csv", package = "metamorphr"), metadata_cols = 2:5)`.
#'
#'
#' @format ## `toy_metaboscape`
#' A data frame with 110 rows and 8 columns:
#' \describe{
#'   \item{UID}{A unique identifier for each Feature. This column is automatically generated by `metamorphr::read_featuretable()` when the feature table is imported.}
#'   \item{Feature}{A label given to each Feature for easier identification. The column of the original feature table that is used to generate the Feature column is specified with the `label_col` argument of `metamorphr::read_featuretable()`.}
#'   \item{Sample}{Sample name. Column names in the original feature table.}
#'   \item{Intensity}{Measured intensity (or area).}
#'   \item{RT}{Retention time. Feature metadata and therefore not really necessary.}
#'   \item{m/z}{Mass over charge. Feature metadata and therefore not really necessary.}
#'   \item{Name}{Feature name. Feature metadata and therefore not really necessary.}
#'   \item{Formula}{Chemical formula. Feature metadata and therefore not really necessary.}
#'   ...
#' }
#' @source This data set contains fictional data!
"toy_metaboscape"


#' Sample metadata for the fictional dataset `toy_metaboscape`
#'
#' Data was generated with `metamorphr::create_metadata_skeleton()` and can be reproduced with
#' `metamorphr::toy_metaboscape %>% create_metadata_skeleton()`.'
#'
#' @format ## `toy_metaboscape_metadata`
#' A data frame with 11 rows and 5 columns:
#' \describe{
#'   \item{Sample}{The sample name}
#'   \item{Group}{To which group does the samples belong? For example a treatment or a background. Note that additional columns with additional grouping information can be freely added if necessary.}
#'   \item{Replicate}{The replicate.}
#'   \item{Batch}{The batch in which the samples were prepared or measured.}
#'   \item{Factor}{A sample-specific factor, for example dry weight or protein content.}
#'   ...
#' }
#' @source This data set contains fictional data!
"toy_metaboscape_metadata"


#' A small toy data set containing MSn spectra
#'
#' Data was generated with `metamorphr::read_mgf()` and can be reproduced with
#' This tibble can be reproduced with `metamorphr::read_mgf(system.file("extdata", "toy_mgf.mgf", package = "metamorphr"))`.
#'
#' @format ## `toy_mgf`
#' A data frame with 3 rows and 5 columns:
#' \describe{
#'   \item{VARIABLEONE}{A fictional variable.}
#'   \item{VARIABLETWO}{A fictional variable.}
#'   \item{VARIABLETHREE}{A fictional variable.}
#'   \item{PEPMASS}{The precursor ion m/z.}
#'   \item{MSn}{A list column containing MSn spectra.}
#'   ...
#' }
#' @source This data set contains fictional data!
"toy_mgf"


#' A tibble containing the NIST standard atomic weights
#'
#' @description
#' The data set contains the atomic weights of the elements and their isotopes.
#' It is used to calculate the exact mass in \code{\link[metamorphr]{formula_to_mass}} but can also be used as a reference.
#'
#'  description
#'
#' @format ## `atoms`
#' A data frame with 442 rows and 7 columns:
#' \describe{
#'   \item{Number}{The atomic number of the element in the periodic table.}
#'   \item{Element}{The element.}
#'   \item{Isotope}{The mass number of the specific isotope.}
#'   \item{Symbol}{The atomic symbol. Either only the letter (for standard isotopes) or the mass number followed by the symbol (for special isotopes).}
#'   \item{Weight}{The monoisotopic mass of the isotope.}
#'   \item{Composition}{The fraction of the isotope in the naturally occuring element.}
#'   \item{Standard_Weight}{The standard atomic weight of the element. It is the sum of the product of the `Weight` and `Composition` column for each element. Where no composition is available, the weight of the IUPAC "ATOMIC WEIGHTS OF THE ELEMENTS 2023" table was used. See the Source section for more information.}
#'   ...
#' }
#' @source The table was retrieved from the National Institute of Standards and Technology (NIST) at https://physics.nist.gov/cgi-bin/Compositions/stand_alone.pl, accesed in October 2025, and enriched with data from the IUPAC "ATOMIC WEIGHTS OF THE ELEMENTS 2023" table at https://iupac.qmul.ac.uk/AtWt/, accesed in October 2025
"atoms"
