% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metagam_package.R
\docType{package}
\name{metagam-package}
\alias{metagam-package}
\title{metagam: Meta-analysis of generalized additive models.}
\description{
The main functions in the metagam package are described below.
}
\section{Stripping rawdata}{
 The function \code{\link{strip_rawdata}} takes a
  fit produced by functions in packages \code{mgcv} or \code{gamm4} and
  removes all individual participants data.
}

\section{Meta-analysis}{
 The function \code{\link{metagam}} takes a list of
  fits produced by \code{\link{strip_rawdata}} and computes meta-analytic
  fits.
}

\section{Plotting}{
 The functions \code{\link{plot_dominance}} and
  \code{\link{plot_heterogeneity}} can be used to study the meta-analytic fit
  computed by \code{\link{strip_rawdata}}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://lifebrain.github.io/metagam/}
  \item \url{https://github.com/Lifebrain/metagam}
  \item Report bugs at \url{https://github.com/Lifebrain/metagam/issues}
}

}
\author{
\strong{Maintainer}: Oystein Sorensen \email{oystein.sorensen@psykologi.uio.no} (\href{https://orcid.org/0000-0003-0724-3542}{ORCID})

Authors:
\itemize{
  \item Andreas M. Brandmaier \email{brandmaier@mpib-berlin.mpg.de} (\href{https://orcid.org/0000-0001-8765-6982}{ORCID})
  \item Athanasia Mo Mowinckel \email{a.m.mowinckel@psykologi.uio.no} (\href{https://orcid.org/0000-0002-5756-0223}{ORCID})
}

}
