% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REmrt_SSS.R
\name{REmrt_SSS}
\alias{REmrt_SSS}
\title{A function to fit the tree with look-ahead option}
\usage{
REmrt_SSS(
  mf,
  maxL,
  minbucket,
  minsplit,
  cp,
  lookahead,
  alpha.endcut = 0.02,
  a = 50,
  multi.start = T,
  n.starts = 3
)
}
\arguments{
\item{mf}{the data.frame to grow the tree}

\item{maxL}{the maximum number of splits}

\item{minbucket}{the minimum number of the studies in a terminal node}

\item{minsplit}{the minimal number of studies in a parent node to be split}

\item{cp}{the stopping rule for decrease of between-subgroups Q. Any split that does not decrease the between-subgroups Q is not attempted.}

\item{lookahead}{an argument indicating whether to apply the "look-ahead" strategy when fitting the tree}

\item{alpha.endcut}{parameter used in the splitting algorithm to avoid the endcut preference problem.}

\item{a}{parameter used in the sss to determine the slope of the logistic function that replaces the indicator function.}

\item{multi.start}{boolean indicating whether multiple starts must be used}

\item{n.starts}{number of multiple starts}
}
\value{
a list including a tree, the split points, the data, and the nodes after each split
}
\description{
A function to fit the tree with look-ahead option
}
\keyword{internal}
