% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnet_site_info.R
\name{mnet_site_info}
\alias{mnet_site_info}
\title{Download Mesonet site and soil information for all Mesonet sites}
\usage{
mnet_site_info(
  url = "https://api.mesonet.org/index.php/export/station_location_soil_information",
  file_cache = NULL,
  clear_cache = FALSE
)
}
\arguments{
\item{url}{the url to the page on the Oklahoma Mesonet website where site
and soil information are stored}

\item{file_cache}{a character string providing a path to the local Mesonet
file cache. If NULL, the function will search for the local file cache and
if not found will prompt the user to create one.}

\item{clear_cache}{whether to clear cached copy of site and soil
information and re-download}
}
\value{
a data frame containing site and soil information. See Details for
definition of variable descriptions.
}
\description{
Downloads a table of Mesonet site and soil information from the Oklahoma
Mesonet website.
}
\details{
Variable descriptions for Mesonet site and soil information.\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   stnm \tab Station Number \cr
   stid \tab Station Identifier \cr
   name \tab Station Name \cr
   city \tab Nearest Incorporated Town \cr
   rang \tab Range From Town To Station \cr
   cdir \tab Compass Direction From Town To Station \cr
   cnty \tab County \cr
   nlat \tab North Latitude \cr
   elon \tab East Longitude \cr
   elev \tab Elevation In Meters \cr
   cdiv \tab Oklahoma Climate Division \cr
   clas \tab Station Class \cr
   wcr05 \tab 5 cm Residual Water Content (cm3/cm3) \cr
   wcs05 \tab 5 cm Saturated Water Content (cm3/cm3) \cr
   a05 \tab 5 cm Alpha Constant (1/kPa) \cr
   n05 \tab 5 cm N Constant (dimensionless) \cr
   bulk5 \tab 5 cm Soil Bulk Density (g/cm3) \cr
   grav5 \tab 5 cm Soil Percentage Gravel \cr
   sand5 \tab 5 cm Soil Percentage Sand \cr
   silt5 \tab 5 cm Soil Percentage Silt \cr
   clay5 \tab 5 cm Soil Percentage Clay \cr
   text5 \tab 5 cm Soil Texture Class \cr
   wcr25 \tab 25 cm Residual Water Content (cm3/cm3) \cr
   wcs25 \tab 25 cm Saturated Water Content (cm3/cm3) \cr
   a25 \tab 25 cm Alpha Constant \cr
   n25 \tab 25 cm N Constant \cr
   bulk25 \tab 25 cm Soil Bulk Density \cr
   grav25 \tab 25 cm Soil Percentage Gravel \cr
   sand25 \tab 25 cm Soil Percentage Sand \cr
   silt25 \tab 25 cm Soil Percentage Silt \cr
   clay25 \tab 25 cm Soil Percentage Clay \cr
   text25 \tab 25 cm Soil Texture Class \cr
   wcr60 \tab 60 cm Residual Water Content (cm3/cm3) \cr
   wcs60 \tab 60 cm Saturated Water Content (cm3/cm3) \cr
   a60 \tab 60 cm Alpha Constant \cr
   n60 \tab 60 cm N Constant \cr
   bulk60 \tab 60 cm Soil Bulk Density \cr
   grab60 \tab 60 cm Soil Percentage Gravel \cr
   sand60 \tab 60 cm Soil Percentage Sand \cr
   silt60 \tab 60 cm Soil Percentage Silt \cr
   clay60 \tab 60 cm Soil Percentage Clay \cr
   text60 \tab 60 cm Soil Texture Class \cr
   wcr75 \tab 75 cm Residual Water Content (cm3/cm3) \cr
   wcs75 \tab 75 cm Saturated Water Content (cm3/cm3) \cr
   a75 \tab 75 cm Alpha Constant \cr
   n75 \tab 75 cm N Constant \cr
   bulk75 \tab 75 cm Soil Bulk Density \cr
   grav75 \tab 75 cm Soil Percentage Gravel \cr
   sand75 \tab 75 cm Soil Percentage Sand \cr
   silt75 \tab 75 cm Soil Percentage Silt \cr
   clay75 \tab 75 cm Soil Percentage Clay \cr
   text75 \tab 75 cm Soil Texture Class \cr
   datc \tab Date Commissioned \cr
   datd \tab Date De-Commissioned \cr
}
}
\examples{

\dontshow{
  mesonet_cache_dir <- mnet_test_cache(site_info = TRUE)
  previous_options <- options(.mesonet_cache = mesonet_cache_dir)
}

mnet_site_info()

\dontshow{
  unlink(mesonet_cache_dir, recursive = TRUE)
  options(previous_options)
}

}
