% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_fit.R
\name{coef}
\alias{coef}
\alias{coef,market_fit-method}
\alias{coefficients,market_fit-method}
\title{Market fit coefficients}
\usage{
\S4method{coef}{market_fit}(object)

\S4method{coefficients}{market_fit}(object)
}
\arguments{
\item{object}{A fitted model object.}
}
\value{
A named vector of estimated model coefficients.
}
\description{
Returns the coefficients of the fitted market model.
}
\section{Methods (by class)}{
\itemize{
\item \code{coef(market_fit)}: Estimated coefficients.

\item \code{coefficients(market_fit)}: Estimated coefficients alias.

}}
\examples{
\donttest{
# estimate a model using the houses dataset
fit <- diseq_deterministic_adjustment(
  HS | RM | ID | TREND ~
    RM + TREND + W + CSHS + L1RM + L2RM + MONTH |
      RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses(),
  correlated_shocks = FALSE,
  estimation_options = list(control = list(maxit = 1e+6))
)

# access the estimated coefficients
coef(fit)
coefficients(fit)
}
}
