% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maq.R
\name{predict.maq}
\alias{predict.maq}
\title{Predict treatment allocation.}
\usage{
\method{predict}{maq}(object, spend, type = c("matrix", "vector"), ...)
}
\arguments{
\item{object}{A maq object.}

\item{spend}{The spend level B.}

\item{type}{If "matrix" (Default), then return a matrix where the i-th entry equals
\eqn{\pi_B(X_i)} as described above.
If "vector", then \eqn{\pi_B(X_i)} is instead encoded taking values in the set \{0, 1, ..., K\}.
If the allocation is fractional at the given B, this option returns the policy corresponding
to the previous/lower value of the spend path, at which point the policy is integer-valued, but
incurs a cost less than B in expectation.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A matrix with row i equal to \eqn{\pi_B(X_i)}. If \code{type = "vector"} then an
n-length vector with elements equal to the arm (from 0 to K) that is assigned at the given spend B
(note: if the treatment allocation contains a fractional entry at the given B, then the returned
vector is the policy at the nearest spend B' in the solution path where the allocation is
integer-valued but incurs a cost B' < B).
}
\description{
Get an estimate of the policy \eqn{\pi_B(X_i)} at a spend level B.
\eqn{\pi_B(X_i)} is a K-dimensional vector where the k-th element is 1 if assigning the k-th
arm to unit i is optimal at a given spend B, and 0 otherwise (with all entries 0 if the
control arm is assigned).
Depending on the value of B, \eqn{\pi_B(X_j)} might be fractional for at most one unit j.
There are two such cases - the first one is when there is not sufficient budget left to assign j an
initial arm. The second is if there is not sufficient budget to upgrade unit j from arm k to k'.
In these cases \eqn{\pi_B(X_j)} takes on one, or two fractional values, respectively,
representing an assignment probability of a given arm.
}
\examples{
\donttest{
# Generate some toy data and fit a solution path.
n <- 10
K <- 4
reward <- matrix(rnorm(n * K), n, K)
cost <- matrix(runif(n * K), n, K)
DR.scores <- reward + rnorm(n)
path <- maq(reward, cost, DR.scores)

# Get the treatment allocation matrix
pi.mat <- predict(path, 0.1)
pi.mat
# pi.mat might have fractional entries for a single unit but satisfies
# the budget in expectation exactly.
sum(cost * pi.mat) / n

# Get the treatment allocation instead encoded in the set \{0, 1, ..., K\}.
pi.vec <- predict(path, 0.1, type = "vector")
pi.vec
# If a unit has a fractional entry, then pi.vec will incur a cost slightly
# lower than 0.1.
sum(cost[cbind(1:n, pi.vec)]) / n

# Retrieve the underlying solution path.
data.path <- summary(path)
# If we predict at a spend level on this grid, say entry 5,
# then the policy is integer-valued:
spend <- data.path$spend[5]
predict(path, spend)
predict(path, spend, type = "vector")
}

}
