% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_mangroves_area.R
\docType{data}
\name{mangroves_area}
\alias{mangroves_area}
\alias{calc_mangroves_area}
\title{Calculate mangrove extent based on Global Mangrove Watch (GMW)}
\usage{
calc_mangroves_area()
}
\value{
A function that returns an indicator tibble with mangroves as variable
and corresponding areas (in ha) as value.
}
\description{
This function allows to efficiently calculate area of mangrove from
Global Mangrove Watch - World Conservation Monitoring Centre (WCMC)
for polygons. For each polygon, the area of the mangrove (in hectare)
for desired year is returned.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{gmw}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "shell_beach_protected_area_41057_B.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_gmw(years = c(1996, 2016))) \%>\%
  calc_indicators(calc_mangroves_area()) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
