% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_landcover.R
\name{landcover}
\alias{landcover}
\alias{calc_landcover}
\title{Calculate area of different landcover classes}
\usage{
calc_landcover()
}
\value{
A function that returns an indicator tibble with landcover classes
as variables and corresponding areas (in ha) as value.
}
\description{
The land cover data shows us how much of the region is covered by forests,
rivers, wetlands, barren land, or urban infrastructure thus allowing the
observation of land cover dynamics over a period of time. This function
allows to efficiently calculate area of different landcover classes for
polygons. For each polygon, the area of the classes in hectare(ha) is
returned.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{esalandcover}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_esalandcover(years = 2016:2017)) \%>\%
  calc_indicators(calc_landcover()) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
