% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codes.R
\name{codes}
\alias{codes}
\title{Retrieve codes for either a India state or district}
\usage{
codes(state, district = c())
}
\arguments{
\item{state}{The state(s) for which to obtain a code(s).
 Can be entered as either a state abbreviation or full name (case-insensitive).

 `state` can be entered as either a single state or a vector of states.
 If `state` is a vector, `district` must be omitted.}

\item{district}{The county for which to obtain a code.
Can be entered with or without "district" (case-insensitive).}
}
\value{
The code(s) of given \code{state} or \code{district}.

If only states are entered, a vector of length equal to the number of states
is returned. If any states are not found or are invalid, `NA` is returned in their place.

If a state and district are entered, a single value with the code
for the given district is returned. If the district is invalid for the given
state, an error is thrown.

If both `state` and `district` are omitted, the entire list of available
codes are returned, sorted by the state's abbreviation.
}
\description{
Each state and district has a unique two and five digit code
  code respectively. Use this function to obtain the code for a state or
  district.
}
\details{
State and district codes are two and five digit codes, respectively.
  They uniquely identify all states and districts within India. The state and
  district codes is merged into one code with 5 digits. The first two digits
  of the five digit district codes correspond to the state that the district
  belongs to.
}
\note{
A \code{state} must be included when searching for \code{district},
 otherwise multiple results may be returned for duplicate district names.
}
\examples{
codes()
codes("AP")
codes("Tamil Nadu")

codes(c("AP", "WB", "TN"))

codes("WB", district = "Kolkata")
codes(state = "Uttarakhand", district = "Nainital")
codes(state = "RJ", district = "Pratapgarh")
}
\seealso{
[code_info()]
}
