% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental.R
\name{data_dict_update}
\alias{data_dict_update}
\title{Update a data dictionary from a dataset}
\usage{
data_dict_update(data_dict = NULL, dataset, cols = names(dataset))
}
\arguments{
\item{data_dict}{A list of data frame(s) representing metadata of the input
dataset. Automatically generated if not provided.}

\item{dataset}{A dataset object.}

\item{cols}{An optional character string specifying the name(s) or
position(s) of the column(s) for which meta data will be updated. All by
default.}
}
\value{
A list of data frame(s) identifying a data dictionary.
}
\description{
Updates a data dictionary from a dataset, creating a new data dictionary with
updated content, from variables selected in the dataset. Any previous other
meta data will be preserved. The new data dictionary can be applied to the
dataset using \code{\link[=data_dict_apply]{data_dict_apply()}}.
}
\details{
A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.

A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

library(dplyr)

# use madshapR_examples provided by the package
dataset   <- madshapR_examples$`dataset_example`
data_dict <- as_data_dict_mlstr(madshapR_examples$`data_dictionary_example`)
dataset <- data_dict_apply(dataset,data_dict)

# the data dictionary contains no categorical variable.

# create a category in the dataset
dataset   <- dataset \%>\% mutate(gndr = as_category(gndr, labels = c("coucou" = 1),na_values = 2))
new_data_dict <- data_dict_update(data_dict, dataset, "gndr")

head(dataset)

}

}
\seealso{
\code{\link[=data_dict_apply]{data_dict_apply()}},\code{\link[=data_dict_extract]{data_dict_extract()}}
}
