% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-unit_checks.R
\name{check_data_dict_missing_categories}
\alias{check_data_dict_missing_categories}
\title{Assess categorical variables for non-Boolean values in 'missing' column}
\usage{
check_data_dict_missing_categories(data_dict)
}
\arguments{
\item{data_dict}{A list of data frame(s) representing metadata to be evaluated.}
}
\value{
A data frame providing categorical values which 'missing' column is not a
boolean.
}
\description{
Generates a data frame report of any categorical variables with non-Boolean
(or compatible with boolean) values in the 'missing' column of the
'Categories' element.
This report can be used to help assess data structure, presence of fields,
coherence across elements, and taxonomy or data dictionary formats.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

# use madshapR_examples provided by the package
data_dict <- madshapR_examples$`data_dictionary_example - errors`
check_data_dict_missing_categories(data_dict)

}

}
