% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_bind.R
\name{l_bind_context}
\alias{l_bind_context}
\title{Add a context binding}
\usage{
l_bind_context(widget, event, callback)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{event}{a vector with one or more of the following events: \code{'add'},
\code{'delete'}, \code{'relabel'}}

\item{callback}{callback function is an R function which is called by the Tcl
interpreter if the event of interest happens. Note that in loon the 
callback functions support different optional arguments depending on the
binding type, read the details for more information}
}
\value{
context binding id
}
\description{
Creates a binding that evaluates a callback for particular changes in the
collection of contexts of a display.
}
\details{
Bindings, callbacks, and binding substitutions are described in detail in
loon's documentation webpage, i.e. run \code{l_help("learn_R_bind")}
}
\seealso{
\code{\link{l_bind_context_ids}}, \code{\link{l_bind_context_get}},
  \code{\link{l_bind_context_delete}}, \code{\link{l_bind_context_reorder}}
}
