% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlognPareto.R
\name{dlognPareto}
\alias{dlognPareto}
\title{Density of the lognormal-Pareto spliced distribution}
\usage{
dlognPareto(x, sigma, xmin, alpha)
}
\arguments{
\item{x}{vector (nx1): points where the function is evaluated.}

\item{sigma}{positive real: log-standard deviation of the truncated
lognormal distribution.}

\item{xmin}{positive real: scale parameter of the Pareto distribution.}

\item{alpha}{positive real: shape parameterof the Pareto distribution.}
}
\value{
ysim (n x 1) vector: numerical values of the
truncated lognormal-Pareto spliced distribution at x.
}
\description{
This function evaluates the density of the continuous and
differentiable version of the truncated lognormal-Pareto spliced
distribution proposed by Scollnik (2007).
}
\details{
To get a continuous and differentiable density, it is necessary to enforce constraints that reduce the number
of free parameters of the model; in particular, the mixing weight and the log-mean of the lognormal distirbution are
functions of the reamining parameters. See Scollnik (2007) for details.
}
\examples{
ysim <- dlognPareto(seq(0,20,length.out=500),1,5,2)
}
\references{
{
\insertRef{scoll07}{lognGPD}
}
}
