% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlognGPD.R
\name{dlognGPD}
\alias{dlognGPD}
\title{Density of the lognormal-GPD mixture}
\usage{
dlognGPD(x, p, mu, sigma, xi, beta)
}
\arguments{
\item{x}{vector (nx1): points where the function is evaluated.}

\item{p}{real, 0<p<1: prior probability}

\item{mu}{real: log-mean of the truncated lognormal distribution.}

\item{sigma}{positive real: log-standard deviation of the truncated
lognormal distribution.}

\item{xi}{real: shape parameter of the generalized Pareto distribution.}

\item{beta}{positive real: scale parameter of the generalized Pareto distribution.}
}
\value{
ydens (n x 1) vector: numerical values of the
lognormal - generalized Pareto mixture at x.
}
\description{
This function evaluates the lognormal-GPD mixture density function.
}
\examples{
ydens <- dlognGPD(seq(0,20,length.out=500),.9,0,1,0.5,2)

}
