% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locus.R
\name{locus}
\alias{locus}
\title{Create locus object for plotting}
\usage{
locus(
  data = NULL,
  gene = NULL,
  xrange = NULL,
  seqname = NULL,
  flank = NULL,
  fix_window = NULL,
  ens_db,
  chrom = NULL,
  pos = NULL,
  p = NULL,
  yvar = NULL,
  labs = NULL,
  index_snp = NULL,
  LD = NULL,
  std_filter = TRUE
)
}
\arguments{
\item{data}{Dataset (data.frame or data.table) to use for plot. We recommend
that tibbles are converted to a normal data.frame. If unspecified or
\code{NULL}, gene track information alone is returned.}

\item{gene}{Optional character value specifying which gene to view. Either
\code{gene}, or \code{xrange} plus \code{seqname}, or \code{index_snp} must be specified.}

\item{xrange}{Optional vector of genomic position range for the x axis.}

\item{seqname}{Optional, specifies which chromosome to plot.}

\item{flank}{Single value or vector with 2 values for how much flanking
region left and right of the gene to show. Defaults to 100kb.}

\item{fix_window}{Optional alternative to \code{flank}, which allows users to
specify a fixed genomic window centred on the specified gene. Both \code{flank}
and \code{fix_window} cannot be specified simultaneously.}

\item{ens_db}{Either a character string which specifies which Ensembl
database package (version 86 and earlier for Homo sapiens) to query for
gene and exon positions (see \code{ensembldb} Bioconductor package). Or an
\code{ensembldb} object which can be obtained from the AnnotationHub database.
See the vignette and the \code{AnnotationHub} Bioconductor package for how to
create this object.}

\item{chrom}{Determines which column in \code{data} contains chromosome
information. If \code{NULL} tries to autodetect the column.}

\item{pos}{Determines which column in \code{data} contains position information.
If \code{NULL} tries to autodetect the column.}

\item{p}{Determines which column in \code{data} contains SNP p-values.
If \code{NULL} tries to autodetect the column.}

\item{yvar}{Specifies column in \code{data} for plotting on the y axis as an
alternative to specifying p-values. Both \code{p} and \code{yvar} cannot be specified
simultaneously.}

\item{labs}{Determines which column in \code{data} contains SNP rs IDs.
If \code{NULL} tries to autodetect the column.}

\item{index_snp}{Specifies the index SNP. If not specified, the SNP with the
lowest P value is selected. Can be used to specify locus region instead of
specifying \code{gene}, or \code{seqname} and \code{xrange}.}

\item{LD}{Optional character value to specify which column in \code{data} contains
LD information.}

\item{std_filter}{Logical, whether standard filters on chromosomes 1-22, X &
Y, and filtering of genes to only those whose transcript ids start with
"ENS" are applied. For users with novel genome assemblies, this probably
needs to be set to \code{FALSE}.}
}
\value{
Returns a list object of class 'locus' ready for plotting,
containing:
\item{seqname}{chromosome value}
\item{xrange}{vector of genomic position range}
\item{gene}{gene name}
\item{ens_db}{Ensembl or AnnotationHub database}
\item{ens_version}{Ensembl database version}
\item{organism}{Ensembl database organism}
\item{genome}{Ensembl data genome build}
\item{chrom}{column name in \code{data} containing chromosome information}
\item{pos}{column name in \code{data} containing position}
\item{p}{column name in \code{data} containing p-value}
\item{yvar}{column name in \code{data} to be plotted on y axis as alternative to
\code{p}}
\item{labs}{column name in \code{data} containing SNP IDs}
\item{index_snp}{id of the most significant SNP}
\item{data}{the subset of GWAS data to be plotted}
\item{TX}{dataframe of transcript annotations}
\item{EX}{\code{GRanges} object of exon annotations}
If \code{data} is \code{NULL} when \code{locus()} is called then gene track information
alone is returned.
}
\description{
Creates object of class 'locus' for genomic locus plot similar to
\code{locuszoom}.
}
\details{
This is an R version of \code{locuszoom} (http://locuszoom.org) for generating
publication ready Manhattan plots of gene loci. It references Ensembl
databases using the \code{ensembldb} Bioconductor package framework for annotating
genes and exons in the locus.
}
\examples{
## Bioconductor package EnsDb.Hsapiens.v75 is needed for these examples
if(require(EnsDb.Hsapiens.v75)) {
data(SLE_gwas_sub)
loc <- locus(SLE_gwas_sub, gene = 'UBE2L3', flank = 1e5,
             ens_db = "EnsDb.Hsapiens.v75")
summary(loc)
locus_plot(loc)
loc2 <- locus(SLE_gwas_sub, gene = 'STAT4', flank = 1e5,
              ens_db = "EnsDb.Hsapiens.v75")
locus_plot(loc2)
}
}
\seealso{
\code{\link[=locus_plot]{locus_plot()}} \code{\link[=locus_ggplot]{locus_ggplot()}} \code{\link[=locus_plotly]{locus_plotly()}}
}
