% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output-fxns.R
\name{plot.litfit}
\alias{plot.litfit}
\title{Plot Decomposition Trajectory and Curve Fit}
\usage{
\method{plot}{litfit}(x, formulae.cex = 1, ...)
}
\arguments{
\item{x}{A \code{litfit} object.}

\item{formulae.cex}{Size scaling factor for the formula display on the plot.}

\item{...}{Additional arguments passed to \code{\link[graphics]{plot.default}}.}
}
\value{
A plot visualizing the data and curve fit from a \code{litfit} object.
The result is returned invisibly.
}
\description{
Plot a Litter Decomposition Trajectory with Curve Fit
}
\details{
Visualizes the litter decomposition trajectory data and its curve fit
derived from a \code{litfit} object. This function is designed to provide
a quick visual check on the adequacy of model fitting.

The plot displays data points from the \code{litfit} object along with
the curve fit. The formula for the fit is displayed on the plot.
}
\examples{
fit <- fit_litter(
  time=c(0,1,2,3,4,5,6),
  mass.remaining=c(1,0.9,1.01,0.4,0.6,0.2,0.01),
  'neg.exp',
  iters=250
)
plot(fit)

}
\seealso{
\code{\link{fit_litter}} for generating \code{litfit} objects.
}
\author{
Will Cornwell
}
