% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{setItems}
\alias{setItems}
\title{Set the items of a graph2d}
\usage{
setItems(id, data)
}
\arguments{
\item{id}{graph2d id or a \code{linevis} object (the output from \code{linevis()})}

\item{data}{A dataframe containing the item data to use.}
}
\value{
None, side-effect is Javascript call
}
\description{
Set the items of a graph2d
}
\examples{
\dontrun{
linevis(data.frame(start = Sys.Date(), content = "Today")) \%>\%
  setItems(data.frame(start = Sys.Date() - 1, content = "yesterday"))
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    linevisOutput("graph2d"),
    actionButton("btn", "Change the data to yesterday")
  ),
  server = function(input, output) {
    output$graph2d <- renderLinevis(
      linevis(data.frame(start = Sys.Date(), content = "Today"))
    )
    observeEvent(input$btn, {
      setItems("graph2d",
               data.frame(start = Sys.Date() - 1, content = "yesterday"))
    })
  }
)
}
}
