% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6_group.R
\name{Group}
\alias{Group}
\title{R6 Class representing a LimeSurvey group}
\description{
R6 Class representing a LimeSurvey group

R6 Class representing a LimeSurvey group
}
\details{
A group is mostly just a container for questions.
}
\examples{
myGroup <- limonaid::Group$new(
  group_name = "My Group"
);
myGroup$add_question(
  "testQuestion1",
  questionTexts = "First question",
  type="free text (short)"
);
myGroup$add_question(
  "testQuestion2",
  questionTexts = "Second question",
  type="radio"
);
myGroup$questions$testQuestion2$add_answer_option(
  "option1",
  "First option"
);
myGroup$questions$testQuestion2$add_answer_option(
  "option2",
  "Second option"
);

cat(as.character(myGroup$export_to_lsg()));

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{group_name}}{The group name / title / label}

\item{\code{description}}{The group description}

\item{\code{grelevance}}{The relevance equation for the group}

\item{\code{group_order}}{The group order (in the survey)}

\item{\code{randomization_group}}{The randomization group (that the group is a part of)}

\item{\code{language}}{The language of the group; or primary language, if there are multiple languages.}

\item{\code{additional_languages}}{Any additional languages for the title and description elements.}

\item{\code{id}}{The identifier of the group (a unique number in a survey)}

\item{\code{sid}}{The identifier of the survey that this group belongs to}

\item{\code{otherOptions}}{Any additional options, stored as a named list
by assigning \code{as.list(...)}.}

\item{\code{questions}}{The questions in this group}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Group-new}{\code{Group$new()}}
\item \href{#method-Group-add_question}{\code{Group$add_question()}}
\item \href{#method-Group-export_to_lsg}{\code{Group$export_to_lsg()}}
\item \href{#method-Group-clone}{\code{Group$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Group-new"></a>}}
\if{latex}{\out{\hypertarget{method-Group-new}{}}}
\subsection{Method \code{new()}}{
Create a new group object. Most of this text comes directly
from the TSV manual page at
\url{https://www.limesurvey.org/manual/Tab_Separated_Value_survey_structure}, so
please see that page for more details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Group$new(
  group_name = "",
  description = "",
  grelevance = 1,
  group_order = 1,
  randomization_group = NULL,
  language = "en",
  additional_languages = "",
  id = NULL,
  sid = NULL,
  new_id_fun = NULL,
  uqid = NULL,
  repo_url = "https://operationalizations.com/questionnaires/json",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group_name}}{The title of the group (if there are multiple languages,
a named vector where every element is the title in another language and
every element's name is the language code).}

\item{\code{description}}{The description of the group (if there are multiple
languages, a named vector where every element is the title in another
language and every element's name is the language code).}

\item{\code{grelevance}}{The group's relevance equation}

\item{\code{group_order}}{The group order (if the group is part of a survey)}

\item{\code{randomization_group}}{The group's randomization group}

\item{\code{language}}{The group's only or primary language}

\item{\code{additional_languages}}{Any additional languages}

\item{\code{id}}{Optionally, the id of the group.}

\item{\code{sid}}{Optionally, the identifier of the survey that this group
belongs to.}

\item{\code{new_id_fun}}{A function to set identifiers (for XML exports, which
mirrors MySQL tables and so needs identifiers). By default, new question
objects receive this function from the group containing them; and groups
receive it from the survey containing them. This ensures that identifiers
are always unique in a survey (despite question objects not being able
to 'see' anything in the group containing them, and group objects not
being able to 'see' anything in the survey containing them; because they
'received' this function from the parent object, and it 'bubbles down'
through groups to the questions, those functions still get and set a
private identifier property in the 'top-most' object).}

\item{\code{uqid}}{A Unique Questionnaire Identifier (UQID) to import a
questionnaire and populate the group with it.}

\item{\code{repo_url}}{The URL to a repo serving the questionnaire with the
UQID in JSON.}

\item{\code{...}}{Any additional options, stored as a named list in the
\code{otherOptions} property by assigning \code{as.list(...)}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Group} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Group-add_question"></a>}}
\if{latex}{\out{\hypertarget{method-Group-add_question}{}}}
\subsection{Method \code{add_question()}}{
Add a question to a group object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Group$add_question(
  code,
  type = NULL,
  lsType = NULL,
  question_order = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{code}}{The question code.}

\item{\code{type}}{The question type.}

\item{\code{lsType}}{The question type, as LimeSurvey question type.}

\item{\code{question_order}}{The question order; automatically filled if left
empty; starts counting at 0.}

\item{\code{...}}{Additional arguments are used to create the Question using
\code{Question$new}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly, the \code{thisQuestion} object that was just added. Note
that you can further modify this, which will modify the question object
"in" the survey group as well. This allows you to pipe the question
creation on to, for example, add answer options.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Group-export_to_lsg"></a>}}
\if{latex}{\out{\hypertarget{method-Group-export_to_lsg}{}}}
\subsection{Method \code{export_to_lsg()}}{
Export the group as an LSG (xml) file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Group$export_to_lsg(
  file = NULL,
  preventOverwriting = limonaid::opts$get("preventOverwriting"),
  encoding = limonaid::opts$get("encoding"),
  silent = limonaid::opts$get("silent"),
  backupLanguage = self$language
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{The filename to which to save the file.}

\item{\code{preventOverwriting}}{Whether to prevent overwriting.}

\item{\code{encoding}}{The encoding to use}

\item{\code{silent}}{Whether to be silent or chatty.}

\item{\code{backupLanguage}}{The language to get content from if not from
the primary langage.}

\item{\code{parallel}}{Whether to work serially or in parallel.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly, the \code{Survey} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Group-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Group-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Group$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
