% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_plot_residuals.R
\name{mle_plot_residuals}
\alias{mle_plot_residuals}
\title{Plots Residuals vs. Predicted MLE}
\usage{
mle_plot_residuals(
  x,
  yvar,
  lab_residuals = "Residuals",
  lab_predicted = "Predicted",
  ...
)
}
\arguments{
\item{x}{List with the results of the simulated annealing algorithm for Maximum
Likelihood Estimation. See \code{\link[likelihood:anneal]{likelihood::anneal()}}}

\item{yvar}{The name of the column that contains the dependent variable
(the “observed” value). This column must be present in the \code{source_data}
of the \code{x} (results) list}

\item{lab_residuals}{The text for the residual axis lab (y-axis)}

\item{lab_predicted}{The text for the predicted axis lab (x-axis)}

\item{...}{other ggplot2 parameters}
}
\value{
A \code{ggplot} object displaying the residuals vs. predicted values,
with a horizontal line at zero.
}
\description{
Plots residuals (observed - residuals) values \emph{vs.} predicted values. The
predicted values are obtained from the model with the parameters values
estimated by maximum likelihood estimation using simulated annealing.
}
