# OceanOptics ProcSpec

    Code
      lr_parse_procspec(test.file("tampered_procspec.zip"), verify_checksum = TRUE)
    Condition
      Error:
      ! The file has been modified since its creation by the spectrometer. This means data integrity may be compromised and it is unclear how much you can trust your results.
      To bypass the warning, use 'check = FALSE'

---

    Code
      lr_parse_procspec(test.file("procspec_files", "OceanOptics_Linux.ProcSpec"),
      verify_checksum = TRUE)
    Output
      $data
               wl    dark   white   scope  processed
      1    176.36 32822.8 32822.8 32822.8     0.0000
      2    176.58 32822.8 32822.8 32822.8     0.0000
      3    176.80 32822.8 32822.8 32822.8     0.0000
      4    177.02  1483.5  1517.5  1496.7    38.5542
      5    177.24  1492.2  1506.5  1511.0   131.4286
      6    177.47  1965.6  1934.1  1976.3   -33.7662
      7    177.69  1894.8  1869.0  1889.0    22.2222
      8    177.91  2016.4  1995.5  1989.8   127.4510
      9    178.13  1887.0  1890.3  1921.0  1037.5000
      10   178.35  1918.9  1913.2  1943.5  -428.5714
      11   178.57  1950.1  1925.1  1947.6     9.8361
      12   178.79  1866.9  1873.1  1889.5   366.6667
      13   179.01  1910.3  1910.8  1923.0  3100.0000
      14   179.23  1873.1  1866.5  1868.6    68.7500
      15   179.46  1899.7  1894.0  1955.0  -964.2857
      16   179.68  1875.9  1874.3  1852.2  1450.0000
      17   179.90  1824.7  1838.7  1820.6   -29.4118
      18   180.12  1856.3  1835.0  1793.2   296.1538
      19   180.34  1917.7  1915.7  1939.4 -1060.0000
      20   180.56  1823.9  1805.1  1860.8  -195.6522
      21   180.78  1937.0  1985.7  1972.2    72.2689
      22   181.00  1810.8  1823.1  1835.4   200.0000
      23   181.22  1894.8  1901.3  1933.7   593.7500
      24   181.44  1848.1  1884.5  1852.2    11.2360
      25   181.66  1918.1  1904.6  1918.5    -3.0303
      26   181.89  1907.5  1943.9  1934.9    75.2809
      27   182.11  1848.1  1839.5  1881.7  -390.4762
      28   182.33  1886.2  1921.4  1892.7    18.6047
      29   182.55  2027.5  2039.0  2075.0   414.2857
      30   182.77  1988.6  2001.7  1977.5   -84.3750
      31   182.99  2031.2  1972.6  2007.8    39.8601
      32   183.21  1751.4  1767.4  1750.2    -7.6923
      33   183.43  1868.2  1869.8  1862.0  -375.0000
      34   183.65  1808.8  1821.5  1836.2   216.1290
      35   183.87  1774.4  1803.0  1801.0    92.8571
      36   184.09  1955.0  1982.4  1938.2   -61.1940
      37   184.31  1923.9  1951.7  1942.7    67.6471
      38   184.53  1801.0  1789.9  1814.5  -122.2222
      39   184.76  1884.5  1895.6  1907.9   211.1111
      40   184.98  1863.7  1858.3  1852.2   215.3846
      41   185.20  1996.0  1926.7  1967.3    41.4201
      42   185.42  1998.0  1972.2  2036.1  -147.6190
      43   185.64  1893.6  1906.2  1936.1   335.4839
      44   185.86  1940.2  1990.6  2001.3   121.1382
      45   186.08  2112.3  2083.2  2133.6   -73.2394
      46   186.30  1866.5  1885.8  1897.2   159.5745
      47   186.52  1783.4  1770.7  1819.0  -280.6452
      48   186.74  1944.8  1925.9  1973.0  -150.0000
      49   186.96  1934.1  1927.1  1937.4   -47.0588
      50   187.18  1881.3  1846.9  1886.6   -15.4762
      51   187.40  1884.5  1844.8  1875.5    22.6804
      52   187.62  2006.6  1974.2  1984.1    69.6203
      53   187.84  1968.9  1971.0  1992.7  1160.0000
      54   188.06  1905.4  1894.8  1891.9   126.9231
      55   188.28  1903.8  1855.1  1882.1    44.5378
      56   188.51  1973.0  1973.8  1995.1  2700.0000
      57   188.73  1970.6  2003.3  2021.3   155.0000
      58   188.95  1996.4  1968.1  1972.2    85.5072
      59   189.17  1889.0  1913.6  1883.7   -21.6667
      60   189.39  1934.9  1941.5  1951.7   256.2500
      61   189.61  1901.3  1913.2  1932.9   265.5172
      62   189.83  1928.4  1909.9  1919.4    48.8889
      63   190.05  1879.6  1906.7  1933.7   200.0000
      64   190.27  1982.0  1973.4  2015.6  -390.4762
      65   190.49  1942.7  1963.6  1943.9     5.8824
      66   190.71  1808.4  1805.9  1748.6  2433.3333
      67   190.93  1876.3  1876.8  1849.3 -6600.0000
      68   191.15  1813.3  1831.3  1807.1   -34.0909
      69   191.37  1914.4  1912.4  1969.7 -2700.0000
      70   191.59  1909.1  1919.8  1930.8   203.8462
      71   191.81  1949.3  1939.0  1952.1   -28.0000
      72   192.03  1915.3  1921.8  1909.9   -81.2500
      73   192.25  1918.1  1901.3  1964.0  -273.1707
      74   192.47  1869.8  1884.5  1875.9    41.6667
      75   192.69  1823.5  1832.1  1836.6   152.3810
      76   192.91  1917.7  1944.8  1924.7    25.7576
      77   193.13  1920.6  1889.0  1918.1     7.7922
      78   193.35  1824.3  1845.2  1828.4    19.6078
      79   193.57  1919.4  1939.0  1968.1   247.9167
      80   193.79  1832.1  1793.2  1819.4    32.6316
      81   194.01  1957.0  2004.1  2003.3    98.2609
      82   194.23  1894.0  1888.6  1909.9  -300.0000
      83   194.45  1900.9  1869.0  1891.1    30.7692
      84   194.67  1982.4  1970.6  1983.3    -6.8966
      85   194.89  1846.9  1812.5  1842.8    11.9048
      86   195.11  1882.1  1890.3  1897.6   190.0000
      87   195.33  1805.1  1807.5  1839.5  1400.0000
      88   195.55  1837.4  1848.5  1858.3   188.8889
      89   195.77  1912.4  1934.9  1943.1   136.3636
      90   195.99  1885.4  1873.5  1876.8    72.4138
      91   196.21  1821.9  1840.3  1841.9   108.8889
      92   196.43  1920.2  1935.3  1971.0   335.1351
      93   196.65  1832.1  1875.9  1873.5    94.3925
      94   196.87  2009.5  1987.8  2015.6   -28.3019
      95   197.09  1874.7  1868.6  1866.5   133.3333
      96   197.31  1980.4  1949.7  1984.9   -14.6667
      97   197.53  1950.5  1937.8  1980.0  -232.2581
      98   197.75  1892.3  1903.0  1916.9   230.7692
      99   197.97  1928.4  1971.4  1942.7    33.3333
      100  198.19  1968.1  1965.2  2000.9 -1142.8571
      101  198.41  2052.5  2070.9  2061.9    51.1111
      102  198.63  1862.0  1876.8  1864.9    19.4444
      103  198.85  1927.5  1916.5  1947.2  -177.7778
      104  199.07  1980.0  1999.2  1977.5   -12.7660
      105  199.29  1819.0  1853.0  1849.7    90.3614
      106  199.51  1862.0  1874.7  1848.9  -103.2258
      107  199.73  1955.0  1979.2  1990.6   147.4576
      108  199.95  1829.2  1806.3  1806.3   100.0000
      109  200.17  1893.1  1915.3  1917.7   111.1111
      110  200.39  1913.6  1957.9  1978.3   146.2963
      111  200.61  1944.3  1986.1  2001.3   136.2745
      112  200.83  1822.3  1834.6  1890.7   556.6667
      113  201.05  1937.8  1935.3  1938.2   -16.6667
      114  201.27  1871.8  1887.4  1899.3   176.3158
      115  201.49  1855.5  1855.1  1853.4   500.0000
      116  201.71  1972.2  1975.9  2001.7   800.0000
      117  201.93  1980.8  1997.2  1988.6    47.5000
      118  202.15  1846.0  1851.8  1860.8   257.1429
      119  202.37  1891.5  1894.4  1903.8   428.5714
      120  202.59  1922.6  1955.0  1952.5    92.4051
      121  202.81  1870.2  1901.3  1862.4   -25.0000
      122  203.03  1977.9  1984.1  1983.7    93.3333
      123  203.25  1873.1  1931.6  1892.7    33.5664
      124  203.47  1864.1  1889.0  1922.6   234.4262
      125  203.69  1863.7  1879.6  1914.4   317.9487
      126  203.91  1912.4  1926.7  1924.3    82.8571
      127  204.13  1798.1  1803.0  1799.3    25.0000
      128  204.35  1812.9  1845.6  1846.4   102.5000
      129  204.57  2027.9  2031.2  2011.5  -500.0000
      130  204.79  1834.2  1868.2  1851.4    50.6024
      131  205.01  1894.4  1864.9  1919.4   -84.7222
      132  205.23  1952.9  1993.5  1991.0    93.9394
      133  205.45  1898.9  1882.9  1915.7  -105.1282
      134  205.67  1777.6  1786.2  1815.3   438.0952
      135  205.89  1885.8  1874.7  1870.2   140.7407
      136  206.10  1961.1  1922.2  1978.7   -45.2632
      137  206.32  1817.0  1803.0  1805.9    79.4118
      138  206.54  1783.4  1830.5  1806.7    49.5652
      139  206.76  1865.3  1829.2  1867.3    -5.6818
      140  206.98  1881.7  1907.5  1889.9    31.7460
      141  207.20  1856.3  1882.5  1877.2    79.6875
      142  207.42  1921.4  1920.6  1915.3   750.0000
      143  207.64  1840.7  1882.5  1835.0   -13.7255
      144  207.86  1836.2  1882.1  1890.7   118.7500
      145  208.08  2069.3  2063.1  2122.5  -866.6667
      146  208.30  1836.6  1832.9  1825.1   311.1111
      147  208.52  1814.1  1826.4  1810.0   -33.3333
      148  208.74  1975.5  1967.3  1978.3   -35.0000
      149  208.96  1947.6  1947.6  1988.6     0.0000
      150  209.18  1769.0  1802.2  1796.1    81.4815
      151  209.40  1979.6  1994.3  2041.0   416.6667
      152  209.62  1857.5  1857.9  1853.4 -1000.0000
      153  209.83  1879.2  1905.0  1948.0   266.6667
      154  210.05  1956.2  1905.8  1934.1    43.9024
      155  210.27  1857.9  1833.3  1829.7   115.0000
      156  210.49  1853.8  1897.2  1856.3     5.6604
      157  210.71  1843.6  1846.9  1848.1   137.5000
      158  210.93  1931.6  1957.4  1934.5    11.1111
      159  211.15  1848.1  1879.6  1864.1    50.6494
      160  211.37  1831.3  1807.9  1841.9   -45.6140
      161  211.59  1850.5  1836.2  1893.6  -300.0000
      162  211.81  1792.0  1826.0  1819.0    79.5181
      163  212.03  1911.6  1852.2  1853.4    97.9310
      164  212.25  1930.4  1920.6  1948.0  -179.1667
      165  212.47  1875.9  1864.5  1875.9     0.0000
      166  212.68  1920.6  1939.8  1969.3   253.1915
      167  212.90  1966.0  1970.6  1952.9  -290.9091
      168  213.12  1873.1  1905.0  1880.4    23.0769
      169  213.34  1925.5  1969.7  2022.6   219.4444
      170  213.56  1810.4  1860.0  1846.0    71.9008
      171  213.78  1834.2  1822.3  1806.3   234.4828
      172  214.00  1978.3  2009.9  2019.3   129.8701
      173  214.22  1815.3  1832.9  1830.5    86.0465
      174  214.44  1890.3  1918.5  1906.2    56.5217
      175  214.66  1907.1  1919.8  1921.8   116.1290
      176  214.88  1869.0  1904.6  1869.0     0.0000
      177  215.09  1888.6  1926.7  1918.9    79.5699
      178  215.31  1716.6  1738.7  1719.5    12.9630
      179  215.53  1909.5  1888.6  1969.7  -288.2353
      180  215.75  1970.1  1954.6  1950.1   128.9474
      181  215.97  1817.0  1816.5  1813.7   800.0000
      182  216.19  1931.2  1918.9  1937.4   -50.0000
      183  216.41  1934.1  1931.6  1921.4   516.6667
      184  216.63  1828.4  1892.3  1877.6    76.9231
      185  216.85  1958.3  1980.0  2036.5   360.3774
      186  217.06  1962.0  1967.7  1991.4   514.2857
      187  217.28  1816.1  1827.2  1832.1   144.4444
      188  217.50  1798.1  1836.6  1853.4   143.6170
      189  217.72  1971.8  1973.4  2005.8  2075.0000
      190  217.94  1971.8  1960.3  1966.5    46.4286
      191  218.16  1895.6  1866.1  1866.5    98.6111
      192  218.38  1846.9  1857.1  1836.6  -100.0000
      193  218.60  1846.0  1873.5  1844.0    -7.4627
      194  218.82  1885.0  1900.5  1925.1   257.8947
      195  219.03  1860.4  1865.3  1906.2   933.3333
      196  219.25  1902.6  1885.4  1921.4  -109.5238
      197  219.47  1912.4  1925.9  1933.3   154.5455
      198  219.69  1823.5  1864.5  1834.2    26.0000
      199  219.91  1989.4  1996.4  2012.7   335.2941
      200  220.13  2009.9  2026.7  2073.0   375.6098
      201  220.35  1906.2  1925.9  1927.1   106.2500
      202  220.57  1876.8  1896.4  1896.4   100.0000
      203  220.78  1940.2  1966.5  1989.0   185.9375
      204  221.00  1941.9  1914.4  1957.4   -56.7164
      205  221.22  1933.7  1971.0  1959.1    68.1319
      206  221.44  1875.1  1899.3  1883.7    35.5932
      207  221.66  1860.4  1919.4  1900.1    67.3611
      208  221.88  2016.8  2033.6  2041.8   148.7805
      209  222.10  1793.6  1826.4  1803.0    28.7500
      210  222.31  1820.6  1845.2  1861.2   165.0000
      211  222.53  1781.3  1796.9  1844.4   405.2632
      212  222.75  1803.9  1846.9  1841.5    87.6190
      213  222.97  1795.2  1875.9  1885.8   112.1827
      214  223.19  1894.4  1875.1  1902.6   -42.5532
      215  223.41  1910.8  1934.5  1953.8   181.0345
      216  223.63  1829.7  1858.7  1891.5   212.6761
      217  223.84  2054.1  2068.0  2082.4   202.9412
      218  224.06  1785.4  1837.8  1836.2    96.8750
      219  224.28  1878.4  1876.8  1950.5 -4400.0000
      220  224.50  1918.9  1959.1  1992.7   183.6735
      221  224.72  1866.1  1904.2  1890.7    64.5161
      222  224.94  1840.7  1832.5  1812.5   345.0000
      223  225.16  1928.0  1946.8  1982.8   291.3043
      224  225.37  2041.0  2046.7  2048.0   121.4286
      225  225.59  1878.0  1893.6  1923.9   294.7368
      226  225.81  1887.0  1930.0  1923.0    83.8095
      227  226.03  1898.1  1922.6  1939.0   166.6667
      228  226.25  1968.9  2019.3  2012.3    86.1789
      229  226.47  1842.4  1860.8  1851.0    46.6667
      230  226.68  1899.3  1892.7  1882.9   250.0000
      231  226.90  1948.8  1943.5  1956.6  -146.1538
      232  227.12  1830.9  1892.3  1894.0   102.6667
      233  227.34  1934.1  1987.8  1991.4   106.8702
      234  227.56  1847.7  1887.4  1845.6    -5.1546
      235  227.78  1947.6  1929.6  1929.2   102.2727
      236  227.99  1861.6  1915.3  1920.6   109.9237
      237  228.21  1887.4  1905.4  1926.3   215.9091
      238  228.43  1977.5  1991.4  2005.4   200.0000
      239  228.65  1932.9  1932.1  1942.3 -1150.0000
      240  228.87  1925.1  1938.6  1956.2   230.3030
      241  229.09  1853.8  1855.9  1881.3  1340.0000
      242  229.30  1921.0  1960.3  1968.5   120.8333
      243  229.52  1811.2  1805.5  1848.1  -642.8571
      244  229.74  1910.8  1926.7  1960.7   312.8205
      245  229.96  1975.5  2006.6  2018.5   138.1579
      246  230.18  1897.6  1945.6  1941.9    92.3077
      247  230.39  1874.7  1896.8  1921.4   211.1111
      248  230.61  1931.2  1909.5  1954.2  -105.6604
      249  230.83  1882.1  1931.6  1926.3    89.2562
      250  231.05  1783.0  1834.6  1831.7    94.4444
      251  231.27  1952.1  2003.3  1986.1    66.4000
      252  231.49  1886.2  1889.0  1880.9  -185.7143
      253  231.70  1909.9  1989.4  2002.9   117.0103
      254  231.92  1891.1  1927.1  1935.7   123.8636
      255  232.14  1847.7  1875.5  1906.7   211.7647
      256  232.36  1820.2  1875.1  1897.2   140.2985
      257  232.58  1988.2  2068.9  2053.3    80.7107
      258  232.79  1781.3  1836.2  1862.4   147.7612
      259  233.01  1888.6  1915.7  1948.4   221.2121
      260  233.23  1872.7  1941.5  1928.4    80.9524
      261  233.45  1894.8  1933.3  1912.4    45.7447
      262  233.67  1821.1  1846.4  1847.3   103.2258
      263  233.88  1842.8  1934.1  1930.8    96.4126
      264  234.10  2002.1  2077.5  2094.3   122.2826
      265  234.32  1979.6  2066.0  2040.6    70.6161
      266  234.54  1895.6  1959.1  2009.9   180.0000
      267  234.75  1873.5  1938.6  1970.1   148.4277
      268  234.97  1927.5  1979.2  2002.9   146.0317
      269  235.19  1970.1  2080.7  2124.2   139.2593
      270  235.41  1850.5  1960.3  1976.3   114.5522
      271  235.63  1890.7  1943.1  1954.6   121.8750
      272  235.84  2003.7  2090.2  2136.9   154.0284
      273  236.06  1802.6  1918.5  1918.1    99.6466
      274  236.28  1948.4  2034.5  2059.8   129.5238
      275  236.50  1853.0  1962.0  1994.3   129.6992
      276  236.72  1837.0  1896.4  1918.5   137.2414
      277  236.93  1860.8  1946.0  2004.6   168.7500
      278  237.15  1942.3  2073.8  2096.7   117.4455
      279  237.37  1839.5  1963.6  2004.1   132.6733
      280  237.59  1941.9  2100.8  2106.5   103.6082
      281  237.80  1834.6  1976.7  1987.8   107.7810
      282  238.02  1880.9  2041.0  2098.3   135.8056
      283  238.24  1817.0  1966.9  2009.1   128.1421
      284  238.46  1923.9  2093.4  2143.8   129.7101
      285  238.67  1968.9  2195.8  2199.5   101.6245
      286  238.89  1950.1  2130.7  2186.8   131.0658
      287  239.11  1847.3  2056.2  2092.2   117.2549
      288  239.33  1810.4  2048.4  2058.6   104.3029
      289  239.55  1839.5  2066.8  2133.6   129.3694
      290  239.76  1927.5  2152.0  2188.0   116.0584
      291  239.98  1832.9  2104.5  2135.2   111.3122
      292  240.20  1887.8  2145.9  2180.3   113.3333
      293  240.42  1874.7  2090.2  2140.5   123.3840
      294  240.63  1882.5  2139.3  2168.0   111.1643
      295  240.85  1855.5  2082.4  2161.0   134.6570
      296  241.07  1898.1  2207.3  2237.6   109.8013
      297  241.29  1932.5  2251.9  2311.7   118.7179
      298  241.50  1773.5  2105.7  2168.0   118.7423
      299  241.72  1920.2  2206.9  2262.2   119.2857
      300  241.94  1874.3  2217.5  2283.9   119.3317
      301  242.16  2042.2  2365.0  2415.0   115.4822
      302  242.37  1833.8  2183.5  2245.8   117.7986
      303  242.59  1880.0  2245.4  2333.5   124.1031
      304  242.81  1767.8  2173.3  2236.4   115.5556
      305  243.03  1941.9  2337.6  2412.1   118.8406
      306  243.24  1846.0  2191.7  2305.6   132.9384
      307  243.46  1939.4  2367.9  2442.4   117.3996
      308  243.68  1964.8  2411.7  2476.8   114.5738
      309  243.90  1819.4  2269.6  2350.7   118.0164
      310  244.11  1827.2  2304.0  2441.6   128.8660
      311  244.33  1847.3  2324.0  2446.9   125.7732
      312  244.55  1863.7  2390.0  2470.3   115.2529
      313  244.76  1861.2  2347.0  2473.1   125.9696
      314  244.98  1889.9  2426.8  2519.8   117.3150
      315  245.20  1853.8  2394.1  2486.6   117.1342
      316  245.42  1929.2  2463.3  2554.2   117.0245
      317  245.63  1848.5  2396.9  2480.5   115.2353
      318  245.85  1783.0  2386.3  2519.0   121.9959
      319  246.07  1896.0  2454.7  2628.8   131.1584
      320  246.29  1903.8  2523.1  2626.7   116.7328
      321  246.50  1909.9  2501.4  2697.2   133.1025
      322  246.72  1938.2  2512.9  2676.7   128.5103
      323  246.94  1878.0  2476.0  2677.1   133.6301
      324  247.15  1844.8  2458.4  2640.2   129.6395
      325  247.37  1973.0  2663.6  2828.2   123.8434
      326  247.59  1862.0  2539.5  2718.5   126.4208
      327  247.81  1939.8  2625.5  2800.8   125.5675
      328  248.02  1868.6  2557.9  2742.2   126.7380
      329  248.24  1972.2  2670.6  2850.8   125.8065
      330  248.46  1895.2  2588.6  2788.5   128.8246
      331  248.67  1881.7  2609.9  2775.8   122.7784
      332  248.89  1931.6  2675.5  2894.2   129.4053
      333  249.11  1906.2  2738.1  2940.5   124.3230
      334  249.33  1928.4  2746.3  2904.8   119.3791
      335  249.54  1889.9  2712.3  2895.4   122.2610
      336  249.76  1869.8  2636.6  2907.7   135.3632
      337  249.98  1809.6  2657.0  2872.9   125.4712
      338  250.19  1904.6  2708.6  2983.9   134.2333
      339  250.41  1890.3  2785.2  3037.5   128.1922
      340  250.63  1932.9  2820.5  3014.2   121.8274
      341  250.84  1850.5  2752.1  3003.6   127.8964
      342  251.06  1871.4  2814.7  3058.0   125.7924
      343  251.28  1880.9  2840.5  3040.4   120.8280
      344  251.50  1790.7  2765.6  2975.3   121.5126
      345  251.71  1892.3  2866.3  3062.9   120.1850
      346  251.93  1904.2  2942.5  3142.8   119.2899
      347  252.15  1864.9  2874.1  3096.9   122.0779
      348  252.36  1863.2  2877.4  3135.4   125.4443
      349  252.58  2012.7  3099.8  3364.8   124.3783
      350  252.80  1835.8  2917.5  3110.9   117.8720
      351  253.01  1969.3  3039.2  3305.0   124.8469
      352  253.23  1926.7  3072.8  3356.6   124.7677
      353  253.45  1872.3  3031.0  3244.8   118.4517
      354  253.66  1930.4  3040.0  3344.7   127.4640
      355  253.88  1897.6  2998.2  3327.9   129.9591
      356  254.10  1824.7  3022.0  3321.0   124.9743
      357  254.31  1925.1  3126.0  3394.3   122.3397
      358  254.53  1778.0  3021.2  3282.1   120.9885
      359  254.75  1963.2  3155.5  3457.4   125.3178
      360  254.97  1974.2  3205.9  3550.4   127.9681
      361  255.18  1882.5  3141.6  3470.1   126.0898
      362  255.40  1835.8  3098.6  3388.2   122.9322
      363  255.62  1776.0  3017.1  3271.8   120.5281
      364  255.83  1847.7  3171.5  3410.7   118.0693
      365  256.05  1926.3  3198.1  3492.6   123.1562
      366  256.27  1851.4  3090.8  3427.5   127.1646
      367  256.48  1868.2  3117.4  3395.5   122.2623
      368  256.70  1920.6  3256.3  3614.7   126.8323
      369  256.92  1897.6  3272.2  3550.4   120.2324
      370  257.13  1921.8  3219.4  3564.7   126.6098
      371  257.35  1783.4  3095.7  3523.7   132.6155
      372  257.57  1983.3  3285.4  3611.8   125.0708
      373  257.78  1866.9  3255.9  3638.8   127.5730
      374  258.00  2018.5  3394.7  3794.1   129.0179
      375  258.21  1966.9  3353.8  3719.9   126.4028
      376  258.43  1946.4  3321.0  3679.0   126.0429
      377  258.65  1892.7  3326.3  3716.2   127.2000
      378  258.86  1901.3  3314.8  3623.3   121.8198
      379  259.08  1940.7  3375.9  3735.9   125.0856
      380  259.30  1937.4  3405.4  3823.6   128.4877
      381  259.51  1976.7  3454.1  3794.1   123.0108
      382  259.73  1797.7  3300.1  3639.7   122.6009
      383  259.95  1946.0  3441.4  3846.9   127.1159
      384  260.16  1917.3  3473.4  3834.2   123.1903
      385  260.38  2002.9  3534.8  3955.4   127.4599
      386  260.60  1831.7  3372.6  3775.2   126.1297
      387  260.81  1914.4  3470.9  3846.9   124.1579
      388  261.03  1906.7  3495.1  3871.1   123.6720
      389  261.25  1776.4  3373.0  3812.1   127.5013
      390  261.46  1860.0  3448.8  3867.8   126.3728
      391  261.68  1821.5  3464.3  3829.7   122.2388
      392  261.89  1850.5  3552.0  4010.7   126.9620
      393  262.11  1881.7  3482.4  3876.8   124.6418
      394  262.33  1851.4  3487.7  3917.4   126.2578
      395  262.54  1775.6  3386.5  3900.2   131.8841
      396  262.76  1887.8  3537.7  3993.9   127.6564
      397  262.98  1937.4  3595.8  4021.8   125.6854
      398  263.19  1826.0  3508.2  3993.5   128.8532
      399  263.41  1834.6  3450.4  3918.2   128.9480
      400  263.62  1883.7  3550.4  4001.7   127.0828
      401  263.84  1882.9  3605.2  4012.0   123.6147
      402  264.06  1822.7  3569.2  3929.6   120.6379
      403  264.27  1892.7  3538.9  3958.3   125.4790
      404  264.49  1900.5  3579.8  4050.9   128.0488
      405  264.71  1871.8  3545.0  4022.2   128.5190
      406  264.92  1901.3  3627.0  4056.6   124.8991
      407  265.14  1989.8  3682.2  4145.5   127.3717
      408  265.35  1945.6  3654.0  4135.7   128.1947
      409  265.57  1895.2  3536.8  4029.2   129.9900
      410  265.79  1851.0  3485.2  4043.1   134.1353
      411  266.00  1849.7  3571.2  4002.1   125.0297
      412  266.22  2007.4  3711.3  4218.4   129.7596
      413  266.43  1835.8  3526.6  3989.0   127.3498
      414  266.65  1845.2  3565.5  4037.4   127.4286
      415  266.87  1826.8  3596.6  3982.5   121.8005
      416  267.08  1780.5  3506.1  3965.3   126.6081
      417  267.30  1801.4  3563.9  4005.8   125.0755
      418  267.51  1927.5  3724.0  4241.8   128.8190
      419  267.73  1845.2  3648.3  4086.9   124.3299
      420  267.95  2016.4  3785.5  4272.9   127.5527
      421  268.16  1821.1  3613.0  4063.6   125.1429
      422  268.38  1884.1  3743.7  4164.7   122.6432
      423  268.59  1875.5  3715.4  4200.0   126.3357
      424  268.81  1923.0  3753.1  4204.5   124.6643
      425  269.03  1924.7  3708.5  4243.0   129.9656
      426  269.24  1862.8  3650.3  4165.6   128.8268
      427  269.46  1930.4  3845.7  4281.1   122.7331
      428  269.67  1882.5  3731.8  4259.4   128.5271
      429  269.89  1852.2  3794.5  4228.2   122.3323
      430  270.11  1813.7  3727.7  4243.0   126.9206
      431  270.32  1929.6  3904.7  4368.3   123.4757
      432  270.54  1862.0  3777.7  4256.9   125.0160
      433  270.75  2063.9  4010.3  4597.7   130.1768
      434  270.97  1869.8  3751.9  4327.4   130.5767
      435  271.19  1890.7  3869.8  4359.3   124.7310
      436  271.40  1837.4  3859.6  4348.7   124.1847
      437  271.62  1803.4  3766.2  4273.7   125.8556
      438  271.83  1754.3  3797.8  4345.8   126.8190
      439  272.05  1768.2  3740.0  4330.2   129.9335
      440  272.26  1916.5  3935.0  4460.1   126.0146
      441  272.48  1962.0  3912.8  4462.9   128.1965
      442  272.70  1932.1  3969.8  4587.9   130.3317
      443  272.91  1907.9  3916.5  4503.5   129.2210
      444  273.13  1928.4  4005.0  4539.9   125.7594
      445  273.34  1946.4  4020.6  4590.3   127.4684
      446  273.56  1849.3  3937.0  4545.3   129.1348
      447  273.77  1860.8  3974.3  4549.8   127.2287
      448  273.99  2008.6  4088.2  4696.0   129.2299
      449  274.21  2034.9  4102.9  4705.4   129.1345
      450  274.42  2013.2  4027.9  4657.9   131.2665
      451  274.64  1837.4  3937.4  4474.0   125.5510
      452  274.85  1902.2  3984.5  4555.9   127.4390
      453  275.07  1843.2  3927.2  4431.8   124.2138
      454  275.28  1825.1  3898.9  4452.3   126.6838
      455  275.50  1919.4  4025.5  4603.0   127.4212
      456  275.71  1821.5  3919.4  4453.9   125.4783
      457  275.93  1822.3  3866.2  4476.5   129.8597
      458  276.15  1894.4  3975.1  4514.5   125.9252
      459  276.36  1851.0  3971.0  4497.3   124.8261
      460  276.58  1966.5  4079.6  4655.9   127.2727
      461  276.79  1860.8  3942.7  4604.7   131.7922
      462  277.01  1871.4  3973.1  4528.1   126.4081
      463  277.22  1930.0  3940.7  4555.1   130.5561
      464  277.44  2045.5  4207.8  4805.4   127.6378
      465  277.65  1942.7  4063.2  4638.2   127.1200
      466  277.87  1911.6  3985.8  4573.5   128.3373
      467  278.08  1851.8  3984.9  4546.5   126.3249
      468  278.30  2023.8  4190.6  4868.4   131.2854
      469  278.52  1881.7  4068.9  4614.5   124.9438
      470  278.73  1903.8  4034.5  4568.2   125.0481
      471  278.95  1884.1  4007.9  4592.0   127.5024
      472  279.16  1835.4  4015.7  4608.7   127.2027
      473  279.38  1894.8  4015.2  4623.9   128.7039
      474  279.59  1918.1  4109.9  4758.3   129.5833
      475  279.81  1782.6  3975.5  4631.7   129.9216
      476  280.02  1953.8  4207.8  4837.7   127.9484
      477  280.24  1985.3  4209.0  4841.0   128.4214
      478  280.45  1865.7  4156.6  4693.1   123.4221
      479  280.67  1859.6  4107.8  4786.5   130.1876
      480  280.88  1920.6  4215.9  4827.5   126.6417
      481  281.10  1991.4  4288.0  4940.1   128.3931
      482  281.31  1885.8  4309.7  4987.2   127.9486
      483  281.53  1934.9  4233.6  4811.9   125.1604
      484  281.74  1934.1  4256.5  4970.4   130.7407
      485  281.96  1856.3  4202.4  4862.7   128.1425
      486  282.17  1885.0  4231.1  4882.4   127.7584
      487  282.39  1939.4  4347.8  5016.3   127.7551
      488  282.60  1808.8  4222.9  4945.8   129.9457
      489  282.82  1891.1  4315.5  4927.4   125.2408
      490  283.04  1902.2  4313.8  5064.2   131.1141
      491  283.25  1948.0  4390.4  5108.9   129.4147
      492  283.47  1911.2  4368.7  5006.1   125.9333
      493  283.68  1942.7  4446.5  5118.3   126.8281
      494  283.90  1894.8  4465.8  5148.6   126.5573
      495  284.11  1941.9  4403.5  5029.8   125.4409
      496  284.33  1828.4  4319.2  5010.6   127.7586
      497  284.54  1857.9  4337.6  5034.3   128.0971
      498  284.76  1858.7  4313.0  5051.5   130.0901
      499  284.97  1937.8  4441.6  5174.8   129.2819
      500  285.19  1882.9  4349.5  5060.9   128.8442
      501  285.40  1951.7  4435.5  5120.3   127.5726
      502  285.62  1995.1  4524.0  5163.7   125.2996
      503  285.83  1853.4  4404.8  5072.0   126.1519
      504  286.05  1920.6  4379.0  5031.9   126.5578
      505  286.26  1861.2  4398.6  5038.8   125.2300
      506  286.48  1922.2  4391.7  5160.9   131.1494
      507  286.69  1933.7  4453.1  5139.2   127.2313
      508  286.91  1843.6  4338.0  4982.3   125.8292
      509  287.12  2023.0  4507.6  5209.2   128.2394
      510  287.33  1871.0  4319.6  5010.2   128.2034
      511  287.55  1822.3  4364.2  5031.9   126.2649
      512  287.76  1939.8  4459.2  5171.5   128.2718
      513  287.98  1935.7  4466.2  5166.2   127.6627
      514  288.19  1999.2  4510.0  5217.8   128.1892
      515  288.41  1778.9  4218.8  4879.1   127.0606
      516  288.62  1892.7  4391.7  5116.2   128.9952
      517  288.84  1919.4  4448.2  5128.1   126.8869
      518  289.05  1789.5  4256.1  5004.4   130.3388
      519  289.27  1776.8  4375.7  5084.3   127.2656
      520  289.48  1922.2  4376.1  5147.4   131.4305
      521  289.70  1830.5  4342.9  5128.5   131.2683
      522  289.91  1934.5  4572.3  5325.1   128.5404
      523  290.13  1815.7  4369.5  5020.4   125.4852
      524  290.34  1878.8  4566.2  5293.2   127.0538
      525  290.56  1903.8  4475.2  5170.3   127.0309
      526  290.77  1869.0  4580.1  5280.5   125.8347
      527  290.99  1841.5  4426.1  5167.4   128.6846
      528  291.20  1837.4  4476.9  5143.7   125.2638
      529  291.41  1843.6  4492.4  5207.6   126.9986
      530  291.63  1857.1  4575.6  5294.0   126.4276
      531  291.84  1875.1  4546.1  5272.3   127.1891
      532  292.06  1933.7  4624.7  5350.5   126.9711
      533  292.27  1856.7  4546.5  5343.6   129.6330
      534  292.49  1847.7  4547.7  5297.3   127.7609
      535  292.70  2018.5  4747.6  5525.0   128.4857
      536  292.92  1859.6  4738.2  5533.2   127.6181
      537  293.13  1929.2  4752.1  5449.6   124.7098
      538  293.35  1803.0  4706.2  5454.2   125.7619
      539  293.56  1918.1  4728.4  5534.8   128.6984
      540  293.77  1804.3  4657.5  5459.9   128.1223
      541  293.99  1939.8  4821.3  5636.8   128.3014
      542  294.20  1801.0  4664.0  5432.4   126.8383
      543  294.42  1871.4  4772.2  5679.0   131.2624
      544  294.63  1905.4  4863.5  5618.0   125.5054
      545  294.85  1975.5  4940.1  5656.5   124.1641
      546  295.06  1805.9  4794.3  5647.1   128.5362
      547  295.28  1833.3  4825.0  5670.4   128.2585
      548  295.49  1771.1  4734.5  5564.3   128.0028
      549  295.70  1991.4  4973.7  5757.2   126.2739
      550  295.92  1839.1  4945.0  5720.8   124.9769
      551  296.13  1985.3  4937.2  5740.9   127.2235
      552  296.35  1958.3  4993.8  5755.6   125.0978
      553  296.56  1886.6  4931.5  5753.6   126.9976
      554  296.78  1858.7  4862.3  5717.1   128.4604
      555  296.99  1830.5  4924.1  5760.5   127.0356
      556  297.20  1848.1  4830.7  5766.3   131.3650
      557  297.42  1960.7  5045.0  5910.8   128.0744
      558  297.63  1865.3  4890.5  5810.5   130.4089
      559  297.85  1844.8  4837.3  5652.8   127.2516
      560  298.06  1829.7  4832.8  5711.4   129.2553
      561  298.28  1882.5  4973.3  5840.4   128.0546
      562  298.49  1778.0  4773.4  5630.3   128.6066
      563  298.70  1819.0  4908.6  5756.4   127.4427
      564  298.92  1946.0  5040.9  5829.3   125.4764
      565  299.13  1960.3  4982.3  5899.0   130.3334
      566  299.35  1963.6  4977.4  5768.3   126.2435
      567  299.56  1940.7  4980.7  5755.2   125.4783
      568  299.77  1795.7  4862.7  5746.2   128.8061
      569  299.99  1874.3  4908.2  5708.5   126.3805
      570  300.20  1865.3  4876.2  5770.4   129.6966
      571  300.42  1856.7  4906.1  5795.3   129.1605
      572  300.63  1919.4  4965.5  5774.0   126.5430
      573  300.85  1978.7  4970.8  5784.3   127.1869
      574  301.06  1949.7  5016.3  5769.9   124.5759
      575  301.27  1887.4  4983.9  5810.9   126.7063
      576  301.49  1866.5  4909.0  5745.8   127.5040
      577  301.70  1923.9  5003.6  5762.2   124.6309
      578  301.92  1968.5  5056.4  5879.3   126.6481
      579  302.13  1862.8  4881.5  5719.2   127.7476
      580  302.34  1892.7  4930.7  5758.5   127.2482
      581  302.56  1967.3  5022.4  5861.3   127.4568
      582  302.77  1808.8  4949.9  5767.1   126.0138
      583  302.99  1845.2  4937.7  5803.9   128.0132
      584  303.20  1903.4  4968.0  5842.0   128.5218
      585  303.41  1903.0  4960.2  5826.5   128.3360
      586  303.63  1881.3  5117.1  5892.8   123.9747
      587  303.84  1812.5  4949.9  5754.0   125.6266
      588  304.05  1809.6  4938.5  5881.8   130.1479
      589  304.27  1884.1  5030.6  5885.9   127.1804
      590  304.48  1875.5  5127.3  5942.4   125.0661
      591  304.70  1792.0  5028.2  5883.0   126.4144
      592  304.91  1952.9  5133.0  6039.9   128.5162
      593  305.12  1937.8  5086.3  5902.2   125.9139
      594  305.34  1786.6  5037.6  5889.1   126.1938
      595  305.55  1848.5  5071.2  5893.6   125.5211
      596  305.77  1781.3  4995.4  5874.4   127.3480
      597  305.98  1948.8  5210.0  6067.7   126.2999
      598  306.19  1795.7  5083.5  5964.1   126.7846
      599  306.41  1916.9  5225.2  6057.5   125.1579
      600  306.62  1802.2  5126.1  5950.2   124.7936
      601  306.83  1963.2  5215.8  6073.5   126.3695
      602  307.05  1853.4  5255.9  6154.1   126.3994
      603  307.26  1806.3  5136.3  6093.5   128.7454
      604  307.47  1959.5  5328.4  6141.0   124.1216
      605  307.69  1974.2  5319.0  6168.9   125.4102
      606  307.90  1797.7  5167.4  6076.7   126.9843
      607  308.12  1864.5  5206.3  6043.1   125.0398
      608  308.33  1869.4  5371.0  6182.8   123.1840
      609  308.54  2025.4  5438.2  6277.8   124.6039
      610  308.76  1776.8  5172.3  6096.0   127.2014
      611  308.97  1926.7  5359.1  6295.5   127.2792
      612  309.18  1930.0  5465.6  6349.9   125.0116
      613  309.40  1815.7  5180.1  6198.4   130.2654
      614  309.61  1899.3  5337.8  6288.9   127.6593
      615  309.82  1816.1  5256.3  6228.3   128.2534
      616  310.04  1837.4  5230.5  6181.6   128.0299
      617  310.25  1964.8  5425.1  6293.4   125.0947
      618  310.46  1790.7  5320.6  6271.3   126.9320
      619  310.68  1866.9  5339.9  6360.2   129.3785
      620  310.89  1894.8  5332.5  6238.9   126.3672
      621  311.11  1809.6  5314.9  6243.0   126.4781
      622  311.32  1841.1  5317.3  6228.3   126.2048
      623  311.53  1839.9  5257.5  6225.0   128.3078
      624  311.75  1951.3  5407.0  6340.5   127.0120
      625  311.96  1925.1  5404.2  6279.1   125.1472
      626  312.17  1878.0  5364.4  6213.1   124.3421
      627  312.39  1861.2  5355.4  6273.3   126.2689
      628  312.60  1917.3  5309.6  6201.2   126.2859
      629  312.81  1948.4  5389.0  6327.4   127.2738
      630  313.03  1979.2  5466.0  6410.1   127.0762
      631  313.24  1929.2  5330.9  6114.4   123.0343
      632  313.45  1866.1  5283.8  6192.2   126.5820
      633  313.67  1943.5  5369.0  6270.1   126.3063
      634  313.88  1875.9  5292.0  6172.6   125.7794
      635  314.09  1899.3  5330.5  6232.8   126.2982
      636  314.31  1855.5  5287.0  6223.0   127.2738
      637  314.52  1907.1  5246.5  6169.3   127.6340
      638  314.73  1880.0  5303.4  6169.7   125.3051
      639  314.95  1858.3  5325.9  6216.0   125.6674
      640  315.16  2024.2  5359.5  6214.4   125.6294
      641  315.37  1964.4  5374.7  6175.4   123.4807
      642  315.58  1855.5  5194.9  6135.3   128.1614
      643  315.80  1782.6  5106.4  5963.7   125.7917
      644  316.01  1811.2  5183.0  6094.3   127.0287
      645  316.22  1868.6  5171.5  6116.1   128.5962
      646  316.44  1851.8  5244.4  6105.4   125.3773
      647  316.65  1961.1  5210.4  6117.7   127.9213
      648  316.86  1853.8  5233.4  6101.7   125.6939
      649  317.08  1939.0  5223.1  6097.6   126.6276
      650  317.29  1890.7  5159.7  5924.8   123.4056
      651  317.50  1867.3  5005.6  5891.2   128.2172
      652  317.72  1837.0  5049.5  5876.4   125.7427
      653  317.93  1962.8  5167.8  5942.0   124.1534
      654  318.14  1896.4  5085.5  5905.9   125.7257
      655  318.35  1946.8  5122.4  5968.6   126.6477
      656  318.57  1868.2  5006.9  5859.2   127.1565
      657  318.78  1942.3  5137.1  5971.5   126.1154
      658  318.99  2002.9  5270.7  6055.4   124.0160
      659  319.21  1805.1  5033.5  5881.8   126.2751
      660  319.42  1980.0  5280.9  6147.6   126.2564
      661  319.63  1868.6  4976.6  5883.0   129.1645
      662  319.85  1762.5  5097.0  5994.4   126.9132
      663  320.06  1845.6  5128.5  5989.1   126.2133
      664  320.27  1858.7  5118.7  5991.5   126.7747
      665  320.48  1742.0  5111.3  5909.2   123.6810
      666  320.70  1860.8  5183.4  6077.6   126.9107
      667  320.91  1915.3  5269.4  6090.2   124.4719
      668  321.12  1903.4  5231.7  6078.4   125.4369
      669  321.34  1850.5  5325.9  6201.7   125.1974
      670  321.55  1848.1  5308.3  6196.7   125.6747
      671  321.76  1862.8  5206.3  6067.7   125.7626
      672  321.97  1919.8  5293.2  6105.4   124.0772
      673  322.19  1888.2  5325.1  6227.9   126.2662
      674  322.40  1877.2  5404.2  6222.1   123.1913
      675  322.61  1920.6  5209.2  6143.5   128.4095
      676  322.83  1882.1  5364.9  6270.1   125.9908
      677  323.04  1872.7  5334.5  6217.2   125.4969
      678  323.25  1836.2  5350.5  6250.8   125.6177
      679  323.46  1941.1  5499.2  6431.4   126.2001
      680  323.68  1911.6  5517.6  6430.2   125.3067
      681  323.89  1823.1  5349.3  6297.1   126.8788
      682  324.10  1806.7  5335.0  6264.3   126.3408
      683  324.31  1942.3  5669.2  6526.1   122.9915
      684  324.53  1857.1  5670.4  6596.1   124.2750
      685  324.74  1958.7  5677.8  6642.4   125.9361
      686  324.95  1939.0  5738.4  6697.3   125.2372
      687  325.16  1966.9  5724.5  6759.1   127.5343
      688  325.38  1911.2  5777.3  6803.8   126.5494
      689  325.59  1911.6  5872.8  6912.3   126.2434
      690  325.80  1891.1  5724.5  6741.9   126.5413
      691  326.01  1937.8  5777.3  6761.6   125.6347
      692  326.23  1965.6  5888.3  6819.3   123.7339
      693  326.44  1897.6  5754.0  6743.1   125.6506
      694  326.65  1841.1  5685.2  6670.6   125.6367
      695  326.86  1958.3  5538.9  6486.7   126.4699
      696  327.08  1926.3  5604.1  6467.9   123.4881
      697  327.29  1878.8  5583.2  6451.9   123.4520
      698  327.50  1877.6  5528.7  6510.9   126.9015
      699  327.71  1925.5  5596.3  6557.6   126.1884
      700  327.93  1729.3  5314.1  6194.7   124.5658
      701  328.14  1819.0  5435.7  6383.5   126.2061
      702  328.35  1845.2  5434.5  6340.5   125.2425
      703  328.56  1894.0  5487.3  6469.5   127.3339
      704  328.78  1906.7  5493.1  6393.3   125.1028
      705  328.99  2031.2  5635.2  6566.2   125.8325
      706  329.20  1815.7  5489.4  6314.3   122.4551
      707  329.41  1889.5  5486.9  6357.7   124.2059
      708  329.63  1900.5  5549.6  6449.5   124.6605
      709  329.84  1870.2  5440.6  6351.2   125.5019
      710  330.05  1940.2  5482.8  6388.4   125.5636
      711  330.26  1845.6  5416.1  6302.4   124.8251
      712  330.48  1750.2  5338.6  6263.5   125.7733
      713  330.69  1823.5  5408.7  6340.5   125.9911
      714  330.90  1869.4  5496.7  6389.7   124.6161
      715  331.11  1775.6  5331.7  6320.0   127.7931
      716  331.32  1799.3  5403.0  6295.0   124.7556
      717  331.54  1943.1  5423.0  6391.7   127.8366
      718  331.75  1868.2  5280.1  6182.0   126.4346
      719  331.96  1895.2  5492.2  6365.5   124.2769
      720  332.17  1976.3  5529.9  6442.9   125.6916
      721  332.39  1771.9  5297.7  6204.9   125.7319
      722  332.60  1788.7  5371.0  6266.0   124.9828
      723  332.81  1882.1  5414.4  6281.9   124.5594
      724  333.02  1812.5  5343.2  6216.4   124.7332
      725  333.23  1798.1  5263.7  6134.5   125.1271
      726  333.45  1801.8  5369.0  6183.2   122.8270
      727  333.66  1922.2  5443.5  6268.4   123.4268
      728  333.87  1874.7  5310.0  6329.5   129.6769
      729  334.08  1851.8  5436.1  6239.3   122.4089
      730  334.29  1949.3  5388.2  6196.3   123.4993
      731  334.51  1890.3  5466.0  6358.1   124.9485
      732  334.72  1930.4  5365.3  6234.8   125.3160
      733  334.93  1874.3  5416.9  6325.4   125.6446
      734  335.14  1894.4  5447.6  6360.2   125.6830
      735  335.35  1797.3  5298.1  6186.1   125.3656
      736  335.57  1802.6  5405.0  6334.4   125.7987
      737  335.78  1865.7  5440.2  6287.3   123.6966
      738  335.99  1819.8  5423.8  6353.6   125.7984
      739  336.20  1771.1  5321.0  6264.3   126.5721
      740  336.41  1836.6  5371.0  6285.2   125.8663
      741  336.63  1931.2  5569.2  6460.9   124.5102
      742  336.84  1816.1  5450.9  6386.4   125.7381
      743  337.05  1873.1  5514.4  6439.6   125.4106
      744  337.26  1983.3  5639.3  6629.7   127.0894
      745  337.47  1797.3  5429.6  6373.7   125.9923
      746  337.69  1966.9  5649.9  6604.3   125.9119
      747  337.90  1844.4  5522.1  6508.9   126.8293
      748  338.11  1927.5  5555.3  6506.4   126.2166
      749  338.32  2031.6  5570.9  6583.0   128.5962
      750  338.53  1812.9  5445.5  6420.0   126.8238
      751  338.74  1855.1  5502.1  6480.2   126.8194
      752  338.96  1948.8  5699.9  6573.6   123.2911
      753  339.17  2052.1  5773.2  6676.0   124.2598
      754  339.38  1975.9  5711.8  6662.0   125.4358
      755  339.59  1921.8  5644.6  6576.8   125.0413
      756  339.80  1901.7  5652.8  6608.4   125.4750
      757  340.01  1957.0  5708.1  6662.0   125.4313
      758  340.23  1947.6  5692.9  6597.3   124.1470
      759  340.44  1795.2  5489.4  6399.5   124.6369
      760  340.65  1913.6  5720.8  6615.8   123.5073
      761  340.86  1895.2  5637.6  6631.7   126.5623
      762  341.07  1882.9  5712.6  6594.5   123.0267
      763  341.28  1887.4  5602.8  6571.1   126.0611
      764  341.50  1911.6  5680.2  6698.9   127.0297
      765  341.71  1871.0  5620.0  6564.1   125.1830
      766  341.92  1926.7  5767.9  6702.6   124.3335
      767  342.13  1839.1  5733.9  6734.1   125.6809
      768  342.34  1821.5  5714.2  6639.9   123.7795
      769  342.55  1823.1  5621.7  6572.3   125.0270
      770  342.77  1789.9  5622.1  6554.7   124.3373
      771  342.98  1912.8  5731.0  6676.8   124.7694
      772  343.19  1894.8  5708.5  6657.9   124.8953
      773  343.40  1911.6  5759.3  6755.0   125.8782
      774  343.61  1823.5  5739.6  6695.2   124.4012
      775  343.82  1888.2  5698.3  6649.3   124.9624
      776  344.03  1766.6  5648.7  6568.2   123.6864
      777  344.25  1945.2  5795.3  6716.1   123.9149
      778  344.46  1787.1  5618.8  6565.8   124.7141
      779  344.67  2052.5  5860.1  6871.3   126.5598
      780  344.88  1874.7  5688.8  6663.3   125.5477
      781  345.09  1942.3  5788.0  6751.7   125.0612
      782  345.30  1818.6  5685.2  6614.9   124.0466
      783  345.51  1925.1  5790.4  6743.6   124.6583
      784  345.73  1895.2  5772.8  6775.1   125.8477
      785  345.94  1887.0  5698.3  6649.3   124.9543
      786  346.15  1911.6  5822.8  6745.2   123.5836
      787  346.36  1859.1  5632.3  6583.4   125.2063
      788  346.57  1930.0  5710.1  6741.1   127.2727
      789  346.78  1802.6  5727.8  6613.7   122.5712
      790  346.99  1804.3  5698.7  6685.0   125.3260
      791  347.21  2027.1  5803.5  6755.8   125.2169
      792  347.42  1915.7  5595.1  6577.3   126.6949
      793  347.63  1904.6  5618.0  6519.1   124.2665
      794  347.84  1945.2  5749.1  6667.0   124.1305
      795  348.05  1856.3  5612.7  6570.7   125.5043
      796  348.26  1832.5  5573.8  6501.5   124.7975
      797  348.47  1814.5  5519.3  6517.0   126.9320
      798  348.68  1830.9  5541.0  6529.7   126.6505
      799  348.89  1915.7  5648.7  6554.7   124.2704
      800  349.11  1895.2  5638.1  6529.3   123.8127
      801  349.32  1925.5  5553.3  6483.5   125.6407
      802  349.53  1778.0  5401.3  6333.5   125.7291
      803  349.74  1917.7  5562.3  6440.5   124.0953
      804  349.95  1776.8  5456.2  6342.1   124.0788
      805  350.16  1911.6  5589.3  6375.3   121.3721
      806  350.37  1769.0  5497.6  6365.5   123.2780
      807  350.58  1939.4  5561.5  6501.1   125.9414
      808  350.79  1934.5  5586.9  6488.8   124.6944
      809  351.01  1932.5  5514.0  6416.7   125.2059
      810  351.22  2004.6  5561.9  6505.6   126.5285
      811  351.43  1866.1  5410.3  6325.8   125.8292
      812  351.64  1907.9  5557.4  6469.9   125.0056
      813  351.85  1914.4  5514.4  6390.9   124.3486
      814  352.06  1838.7  5486.1  6337.2   123.3352
      815  352.27  1825.6  5470.9  6324.5   123.4157
      816  352.48  1842.8  5553.7  6366.7   121.9095
      817  352.69  1971.0  5551.2  6445.0   124.9628
      818  352.90  1948.0  5379.2  6314.3   127.2532
      819  353.12  1927.5  5494.3  6341.7   123.7598
      820  353.33  1894.8  5467.3  6348.7   124.6732
      821  353.54  1864.1  5381.7  6332.3   127.0261
      822  353.75  1955.0  5488.1  6423.2   126.4665
      823  353.96  1882.9  5449.6  6361.0   125.5512
      824  354.17  1839.5  5410.3  6329.0   125.7284
      825  354.38  1911.2  5567.6  6482.2   125.0140
      826  354.59  1853.0  5426.7  6298.7   124.4011
      827  354.80  1962.0  5500.4  6353.6   124.1116
      828  355.01  1837.0  5418.5  6297.9   124.5540
      829  355.22  1900.1  5448.4  6338.1   125.0721
      830  355.43  1779.7  5512.7  6272.9   120.3643
      831  355.64  2009.5  5509.9  6425.3   126.1526
      832  355.86  1989.0  5576.2  6407.7   123.1788
      833  356.07  1949.7  5616.8  6431.9   122.2272
      834  356.28  1854.6  5552.5  6363.9   121.9428
      835  356.49  1772.3  5339.5  6173.4   123.3781
      836  356.70  1845.2  5523.8  6417.5   124.2957
      837  356.91  1994.3  5611.8  6479.4   123.9810
      838  357.12  1851.0  5509.9  6462.2   126.0271
      839  357.33  1846.4  5404.6  6306.9   125.3597
      840  357.54  1901.7  5614.3  6513.4   124.2167
      841  357.75  1872.3  5526.6  6426.9   124.6357
      842  357.96  1800.6  5345.2  6350.3   128.3568
      843  358.17  1938.6  5587.7  6416.3   122.7074
      844  358.38  1883.7  5505.3  6416.3   125.1527
      845  358.59  1902.6  5455.0  6470.8   128.5945
      846  358.80  1935.7  5617.2  6494.1   123.8206
      847  359.02  1837.0  5489.4  6388.0   124.6047
      848  359.23  1792.8  5470.5  6386.8   124.9137
      849  359.44  1946.0  5558.2  6472.4   125.3090
      850  359.65  1788.7  5482.0  6421.6   125.4408
      851  359.86  2096.7  5799.4  6715.7   124.7456
      852  360.07  1846.9  5555.7  6485.1   125.0580
      853  360.28  1795.7  5485.3  6321.7   122.6687
      854  360.49  1798.1  5525.8  6406.9   123.6348
      855  360.70  1910.8  5644.2  6636.6   126.5826
      856  360.91  1800.2  5644.6  6532.2   123.0876
      857  361.12  1875.9  5525.8  6480.2   126.1475
      858  361.33  1846.4  5603.7  6504.8   123.9834
      859  361.54  1880.4  5627.0  6508.9   123.5378
      860  361.75  1926.3  5639.7  6531.8   124.0238
      861  361.96  1839.5  5674.9  6540.8   122.5758
      862  362.17  1889.9  5690.9  6611.7   124.2241
      863  362.38  1853.8  5611.4  6575.6   125.6595
      864  362.59  1922.2  5849.0  6779.2   123.6883
      865  362.80  1973.8  5645.0  6584.2   125.5830
      866  363.01  1831.3  5621.7  6493.7   123.0063
      867  363.22  1867.3  5647.1  6560.1   124.1547
      868  363.43  1801.4  5516.4  6429.4   124.5755
      869  363.64  1950.9  5741.7  6629.3   123.4144
      870  363.85  1851.4  5567.2  6541.2   126.2125
      871  364.06  1855.5  5760.5  6628.0   122.2152
      872  364.27  1843.6  5695.4  6621.9   124.0536
      873  364.48  1895.6  5774.0  6705.0   124.0046
      874  364.69  1789.9  5605.7  6571.1   125.3006
      875  364.90  1815.7  5564.7  6443.7   123.4459
      876  365.11  1864.9  5695.0  6705.0   126.3715
      877  365.33  1878.0  5751.1  6721.4   125.0529
      878  365.54  1869.0  5716.7  6596.9   122.8763
      879  365.75  1909.1  5717.5  6602.7   123.2416
      880  365.96  1918.9  5696.2  6607.2   124.1162
      881  366.17  1837.4  5666.7  6608.0   124.5802
      882  366.38  1835.0  5643.4  6569.9   124.3278
      883  366.59  1851.0  5660.2  6467.1   121.1828
      884  366.80  1790.7  5529.9  6481.0   125.4354
      885  367.01  1949.7  5819.1  6781.2   124.8650
      886  367.22  1836.2  5533.2  6417.9   123.9309
      887  367.43  1848.5  5555.7  6556.8   127.0025
      888  367.64  1907.1  5658.9  6531.4   123.2533
      889  367.85  1869.8  5621.7  6609.6   126.3319
      890  368.06  1832.9  5447.2  6397.4   126.2919
      891  368.27  1767.0  5536.9  6411.4   123.1964
      892  368.48  1983.7  5792.5  6615.8   121.6152
      893  368.69  1812.9  5310.0  6345.0   129.5971
      894  368.90  1826.8  5491.8  6402.8   124.8547
      895  369.11  1796.1  5495.5  6390.9   124.2028
      896  369.32  1950.9  5645.4  6528.1   123.8914
      897  369.53  1851.8  5458.2  6372.9   125.3606
      898  369.74  1828.8  5461.9  6224.2   120.9808
      899  369.94  1891.5  5438.2  6295.5   124.1714
      900  370.15  1833.3  5445.5  6237.3   121.9186
      901  370.36  1973.0  5608.2  6515.0   124.9465
      902  370.57  1822.3  5309.6  6123.4   123.3380
      903  370.78  1891.1  5519.3  6356.1   123.0639
      904  370.99  1833.3  5396.0  6346.7   126.6843
      905  371.20  1922.2  5555.7  6406.5   123.4134
      906  371.41  1923.5  5522.1  6383.9   123.9472
      907  371.62  1838.7  5424.7  6262.7   123.3695
      908  371.83  1811.6  5381.2  6211.9   123.2702
      909  372.04  1837.0  5298.9  6193.5   125.8400
      910  372.25  1864.1  5458.2  6275.0   122.7236
      911  372.46  1885.8  5373.9  6242.2   124.8943
      912  372.67  1869.0  5326.4  6175.9   124.5705
      913  372.88  1989.4  5535.7  6389.7   124.0818
      914  373.09  1814.5  5275.2  6065.3   122.8311
      915  373.30  1847.3  5313.3  6240.6   126.7549
      916  373.51  1880.0  5300.6  6126.7   124.1528
      917  373.72  1896.0  5426.3  6350.8   126.1863
      918  373.93  1835.4  5443.9  6340.9   124.8581
      919  374.14  1888.6  5421.0  6279.9   124.3159
      920  374.35  1881.3  5364.4  6220.5   124.5767
      921  374.56  1987.3  5482.4  6354.8   124.9619
      922  374.77  1895.2  5465.6  6320.9   123.9532
      923  374.98  1821.9  5422.6  6217.6   122.0794
      924  375.19  1978.7  5488.1  6325.4   123.8562
      925  375.40  1950.9  5492.2  6456.8   127.2380
      926  375.61  1884.1  5463.6  6357.7   124.9800
      927  375.82  1912.8  5545.1  6435.1   124.5038
      928  376.03  1851.0  5489.4  6329.0   123.0778
      929  376.23  1925.5  5504.1  6399.9   125.0315
      930  376.44  1855.1  5544.3  6352.4   121.9052
      931  376.65  1912.8  5440.6  6289.7   124.0683
      932  376.86  1838.3  5483.2  6339.7   123.4970
      933  377.07  1930.4  5525.0  6465.8   126.1737
      934  377.28  1903.0  5567.6  6455.2   124.2204
      935  377.49  1799.8  5520.5  6395.8   123.5249
      936  377.70  1980.0  5581.5  6472.4   124.7356
      937  377.91  1873.9  5527.1  6409.3   124.1507
      938  378.12  1791.2  5513.5  6396.2   123.7126
      939  378.33  1815.7  5560.6  6417.5   122.8809
      940  378.54  1812.9  5463.2  6335.2   123.8891
      941  378.75  1983.7  5630.3  6501.5   123.8908
      942  378.96  1863.7  5534.0  6460.5   125.2427
      943  379.17  1880.4  5529.5  6456.0   125.3901
      944  379.37  1833.3  5559.0  6417.9   123.0541
      945  379.58  1878.8  5486.9  6457.2   126.8930
      946  379.79  1867.3  5503.3  6388.4   124.3438
      947  380.00  1814.1  5463.6  6329.0   123.7149
      948  380.21  1808.8  5470.9  6373.7   124.6505
      949  380.42  1930.0  5569.2  6432.3   123.7141
      950  380.63  1828.4  5503.7  6402.0   124.4400
      951  380.84  1866.1  5530.7  6463.0   125.4387
      952  381.05  1876.8  5477.9  6435.5   126.5924
      953  381.26  1941.9  5569.2  6403.2   122.9901
      954  381.47  1806.3  5323.5  6259.8   126.6216
      955  381.68  2015.2  5684.3  6513.4   122.5943
      956  381.89  1932.9  5590.5  6430.2   122.9563
      957  382.09  1888.6  5413.6  6257.4   123.9368
      958  382.30  2046.7  5597.1  6503.1   125.5192
      959  382.51  1959.9  5511.9  6386.8   124.6310
      960  382.72  1896.4  5485.7  6398.7   125.4365
      961  382.93  1832.5  5399.7  6322.1   125.8583
      962  383.14  1738.3  5325.1  6129.6   122.4278
      963  383.35  1868.2  5510.3  6427.3   125.1799
      964  383.56  1892.3  5418.9  6277.8   124.3554
      965  383.77  1874.3  5499.6  6347.9   123.3985
      966  383.98  1875.5  5397.2  6216.4   123.2612
      967  384.18  1901.7  5507.0  6427.3   125.5283
      968  384.39  1925.9  5511.5  6298.3   121.9443
      969  384.60  1912.0  5521.7  6416.3   124.7816
      970  384.81  1839.9  5414.4  6179.5   121.4048
      971  385.02  1829.2  5353.8  6198.0   123.9512
      972  385.23  1866.5  5403.0  6130.8   120.5814
      973  385.44  1859.1  5485.7  6346.2   123.7294
      974  385.65  1798.9  5466.8  6339.7   123.7968
      975  385.86  1844.0  5393.9  6212.3   123.0530
      976  386.06  1871.8  5522.6  6469.1   125.9284
      977  386.27  2006.6  5528.3  6372.0   123.9591
      978  386.48  1885.0  5493.1  6337.2   123.3965
      979  386.69  1942.7  5507.0  6371.6   124.2588
      980  386.90  1796.1  5320.2  6193.1   124.7675
      981  387.11  1824.7  5557.4  6439.2   123.6256
      982  387.32  1936.1  5484.1  6317.6   123.4934
      983  387.53  1850.5  5472.2  6301.6   122.9021
      984  387.73  1853.0  5389.4  6280.3   125.1911
      985  387.94  1998.4  5572.1  6377.4   122.5330
      986  388.15  2016.4  5533.6  6382.7   124.1411
      987  388.36  1886.6  5446.4  6245.5   122.4485
      988  388.57  2002.9  5526.2  6398.7   124.7617
      989  388.78  1934.5  5492.7  6318.0   123.1956
      990  388.99  1938.6  5469.3  6340.1   124.6636
      991  389.20  1783.0  5221.5  6129.6   126.4086
      992  389.40  2147.9  5629.9  6416.7   122.5973
      993  389.61  1847.7  5345.2  6207.8   124.6633
      994  389.82  1850.5  5349.7  6172.2   123.5046
      995  390.03  1735.4  5364.0  6230.3   123.8740
      996  390.24  1937.8  5494.7  6348.7   124.0097
      997  390.45  1912.4  5276.0  6202.1   127.5329
      998  390.66  1916.5  5481.2  6333.1   123.8998
      999  390.86  1826.4  5344.8  6160.7   123.1898
      1000 391.07  1793.2  5276.0  6163.2   125.4734
      1001 391.28  1780.5  5396.0  6275.4   124.3231
      1002 391.49  1823.9  5422.2  6204.5   121.7416
      1003 391.70  1785.8  5325.9  6212.7   125.0492
      1004 391.91  1815.7  5377.1  6209.0   123.3583
      1005 392.12  2025.4  5511.1  6391.7   125.2644
      1006 392.32  1810.0  5246.1  6112.0   125.1997
      1007 392.53  1843.2  5408.7  6338.1   126.0655
      1008 392.74  1866.1  5391.5  6357.3   127.3963
      1009 392.95  1911.6  5472.2  6371.6   125.2617
      1010 393.16  1784.6  5286.2  6140.2   124.3888
      1011 393.37  1794.4  5278.4  6168.5   125.5467
      1012 393.57  1903.8  5341.9  6183.2   124.4699
      1013 393.78  1803.4  5345.6  6208.6   124.3640
      1014 393.99  1866.9  5449.2  6296.3   123.6451
      1015 394.20  1887.0  5442.7  6212.3   121.6450
      1016 394.41  1905.8  5410.7  6280.3   124.8101
      1017 394.62  1905.0  5297.3  6159.5   125.4166
      1018 394.82  1839.9  5394.8  6225.0   123.3552
      1019 395.03  1807.9  5371.4  6213.1   123.6207
      1020 395.24  1881.3  5402.5  6197.6   122.5776
      1021 395.45  1865.3  5310.0  6110.3   123.2342
      1022 395.66  1836.6  5317.3  6205.8   125.5237
      1023 395.87  1867.7  5343.6  6262.7   126.4436
      1024 396.07  1946.0  5382.5  6216.4   124.2670
      1025 396.28  1880.0  5436.5  6239.8   122.5844
      1026 396.49  1880.0  5546.3  6356.9   122.1093
      1027 396.70  1832.9  5341.1  6205.3   124.6351
      1028 396.91  1823.5  5328.8  6169.3   123.9776
      1029 397.11  1875.1  5471.8  6275.0   122.3323
      1030 397.32  1762.1  5211.3  6075.9   125.0683
      1031 397.53  1791.2  5396.0  6275.0   124.3836
      1032 397.74  1840.3  5424.7  6285.2   124.0087
      1033 397.95  1875.5  5408.3  6291.8   125.0087
      1034 398.16  1939.4  5387.8  6228.7   124.3853
      1035 398.36  2031.2  5583.6  6448.2   124.3399
      1036 398.57  1862.8  5407.9  6295.9   125.0491
      1037 398.78  1852.6  5298.9  6201.2   126.1826
      1038 398.99  1887.0  5382.9  6194.7   123.2220
      1039 399.20  1787.1  5292.8  6170.5   125.0380
      1040 399.40  1796.1  5150.2  5961.6   124.1910
      1041 399.61  1954.6  5480.4  6279.5   122.6650
      1042 399.82  1844.0  5284.6  6132.4   124.6429
      1043 400.03  1812.0  5259.6  6058.3   123.1674
      1044 400.24  1973.4  5312.0  6066.9   122.6107
      1045 400.44  1777.6  5182.2  5899.8   121.0780
      1046 400.65  1904.6  5222.3  6019.8   124.0370
      1047 400.86  1934.5  5398.4  6179.1   122.5375
      1048 401.07  1784.6  5245.7  6120.6   125.2781
      1049 401.27  1890.7  5308.3  6143.9   124.4487
      1050 401.48  1854.2  5142.0  6016.1   126.5853
      1051 401.69  1808.4  5093.7  5845.3   122.8774
      1052 401.90  1929.6  5309.2  6241.0   127.5724
      1053 402.11  1812.0  5162.9  6023.5   125.6815
      1054 402.31  1910.3  5262.1  6116.5   125.4919
      1055 402.52  1946.4  5319.4  6103.8   123.2544
      1056 402.73  1812.0  5145.3  5935.0   123.6913
      1057 402.94  1840.3  5210.4  5984.6   122.9703
      1058 403.15  1918.1  5239.1  6060.3   124.7287
      1059 403.35  1796.9  5171.5  5955.9   123.2431
      1060 403.56  1954.6  5386.6  6149.2   122.2222
      1061 403.77  1823.1  5220.3  6012.4   123.3181
      1062 403.98  1868.2  5255.9  6076.3   124.2171
      1063 404.18  1812.0  5184.6  5965.3   123.1479
      1064 404.39  1886.2  5250.6  6090.2   124.9574
      1065 404.60  1858.7  5173.6  6025.5   125.7012
      1066 404.81  1948.8  5256.7  6089.0   125.1610
      1067 405.01  1738.3  5241.2  5985.8   121.2582
      1068 405.22  1790.3  5211.7  6051.3   124.5421
      1069 405.43  1949.3  5307.5  6073.9   122.8199
      1070 405.64  1861.6  5313.3  6100.9   122.8195
      1071 405.85  1820.6  5170.3  6001.8   124.8227
      1072 406.05  1963.6  5263.3  6137.4   126.4896
      1073 406.26  1938.2  5252.6  6078.8   124.9259
      1074 406.47  1938.2  5276.8  6093.9   124.4755
      1075 406.68  1893.1  5235.0  6005.5   123.0543
      1076 406.88  2011.5  5424.3  6219.3   123.2957
      1077 407.09  1851.0  5217.8  6029.6   124.1119
      1078 407.30  1791.2  5040.5  5881.8   125.8918
      1079 407.51  1765.3  4996.2  5828.9   125.7733
      1080 407.71  1938.6  5308.3  6113.2   123.8848
      1081 407.92  1806.7  4938.1  5724.9   125.1275
      1082 408.13  1775.2  5037.2  5813.8   123.8071
      1083 408.34  1857.1  5084.7  5884.2   124.7716
      1084 408.54  1792.8  4992.9  5849.4   126.7631
      1085 408.75  1816.5  4970.8  5773.2   125.4383
      1086 408.96  2020.1  5366.5  6211.5   125.2509
      1087 409.16  1877.6  5153.5  5966.1   124.8062
      1088 409.37  1900.9  5185.0  5866.2   120.7408
      1089 409.58  1964.0  5156.0  5946.1   124.7530
      1090 409.79  1929.2  5270.2  6010.8   122.1650
      1091 409.99  1842.4  5108.9  5868.2   123.2476
      1092 410.20  1971.4  5226.0  6010.4   124.1002
      1093 410.41  1834.2  5009.7  5729.4   122.6622
      1094 410.62  1823.9  4943.4  5697.0   124.1597
      1095 410.82  1884.1  5173.6  5921.5   122.7369
      1096 411.03  1982.8  5223.1  6051.3   125.5593
      1097 411.24  1833.3  5067.9  5851.9   124.2371
      1098 411.45  1964.0  5216.6  5928.9   121.8990
      1099 411.65  1846.4  5013.4  5851.9   126.4744
      1100 411.86  1882.1  5109.3  5810.9   121.7413
      1101 412.07  1814.9  5200.6  5863.7   119.5863
      1102 412.27  1955.8  5177.7  5910.4   122.7435
      1103 412.48  1894.8  5140.8  5917.8   123.9369
      1104 412.69  1867.7  5048.7  5820.7   124.2725
      1105 412.90  1943.9  5274.3  6116.5   125.2859
      1106 413.10  1909.5  5103.5  5917.4   125.4809
      1107 413.31  1842.8  5097.0  5861.7   123.4991
      1108 413.52  1888.2  5103.9  5883.4   124.2390
      1109 413.72  1759.2  4946.3  5693.8   123.4546
      1110 413.93  1786.2  5045.4  5800.3   123.1620
      1111 414.14  1778.5  4886.9  5676.2   125.3920
      1112 414.35  1912.8  5030.2  5738.8   122.7303
      1113 414.55  1887.8  5112.5  5953.0   126.0638
      1114 414.76  1844.4  4999.5  5754.4   123.9257
      1115 414.97  1877.6  5071.6  5888.3   125.5707
      1116 415.17  1828.0  4983.5  5777.3   125.1558
      1117 415.38  1942.7  5033.1  5809.7   125.1292
      1118 415.59  1806.7  4941.7  5617.6   121.5574
      1119 415.79  1873.9  5036.8  5788.4   123.7633
      1120 416.00  2002.5  5065.0  5919.4   127.8989
      1121 416.21  1964.8  5097.0  5823.6   123.1986
      1122 416.41  1749.8  4868.0  5597.9   123.4073
      1123 416.62  1749.8  4759.9  5392.7   121.0233
      1124 416.83  1946.0  5100.7  5888.3   124.9675
      1125 417.04  1975.5  5071.6  5788.0   123.1380
      1126 417.24  1816.5  4859.4  5595.5   124.1890
      1127 417.45  1871.4  4914.3  5553.3   120.9988
      1128 417.66  1948.0  5002.0  5678.2   122.1432
      1129 417.86  1821.1  4971.2  5679.8   122.4938
      1130 418.07  1819.4  4872.1  5544.7   122.0314
      1131 418.28  1865.7  4978.6  5699.9   123.1711
      1132 418.48  1993.1  5052.3  5873.2   126.8309
      1133 418.69  1851.0  4904.1  5665.5   124.9396
      1134 418.90  1949.3  5103.1  5997.3   128.3506
      1135 419.10  1873.1  5089.2  5874.8   124.4269
      1136 419.31  1836.6  5053.6  5806.0   123.3894
      1137 419.52  1793.2  5054.8  5874.8   125.1413
      1138 419.72  1805.9  5070.4  5788.8   122.0075
      1139 419.93  1767.4  5071.6  5905.1   125.2262
      1140 420.14  1944.3  5277.6  6114.4   125.1044
      1141 420.34  1936.6  5286.6  6061.2   123.1202
      1142 420.55  1821.1  5053.6  5892.8   125.9630
      1143 420.76  1971.4  5356.7  6213.9   125.3237
      1144 420.96  1847.3  5159.2  5960.0   124.1776
      1145 421.17  1902.2  5202.7  6084.9   126.7312
      1146 421.38  1865.7  5239.5  6048.9   123.9893
      1147 421.58  1946.0  5332.9  6132.4   123.6062
      1148 421.79  1939.8  5361.2  6142.7   122.8421
      1149 422.00  1847.7  5370.6  6181.2   123.0090
      1150 422.20  1856.7  5146.5  5969.8   125.0249
      1151 422.41  1842.4  5307.5  6028.0   120.7920
      1152 422.62  1771.1  5142.4  6049.3   126.8983
      1153 422.82  1928.0  5309.6  6170.5   125.4603
      1154 423.03  1890.3  5113.4  6041.1   128.7838
      1155 423.24  1893.1  5248.9  6019.8   122.9708
      1156 423.44  1787.9  5080.2  5920.7   125.5287
      1157 423.65  1904.2  5137.1  5906.8   123.8059
      1158 423.85  1942.3  5206.8  6035.4   125.3827
      1159 424.06  1866.5  5172.8  5963.7   123.9222
      1160 424.27  1965.6  5244.8  5979.2   122.3957
      1161 424.47  1907.5  5156.8  5942.0   124.1649
      1162 424.68  1967.7  5217.0  6074.3   126.3835
      1163 424.89  1958.7  5252.2  6087.0   125.3451
      1164 425.09  1947.6  5155.6  5899.4   123.1869
      1165 425.30  1887.0  5032.7  5790.0   124.0755
      1166 425.51  1830.9  5051.1  5800.7   123.2765
      1167 425.71  1832.5  5073.2  5773.2   121.6001
      1168 425.92  1909.9  5042.1  5826.9   125.0556
      1169 426.12  2059.8  5290.7  6038.2   123.1364
      1170 426.33  1829.7  4990.5  5786.3   125.1782
      1171 426.54  1800.6  4993.8  5595.9   118.8558
      1172 426.74  1866.1  5059.7  5837.9   124.3683
      1173 426.95  1870.2  5113.8  5901.0   124.2707
      1174 427.16  1826.4  4916.4  5609.0   122.4152
      1175 427.36  1848.1  5259.2  6124.2   125.3602
      1176 427.57  1895.2  5097.0  5855.6   123.6920
      1177 427.77  1902.2  5292.8  6102.1   123.8705
      1178 427.98  1962.4  5258.0  6105.8   125.7271
      1179 428.19  1830.1  5240.8  6174.2   127.3688
      1180 428.39  1827.6  5182.2  6016.9   124.8840
      1181 428.60  1951.7  5296.5  6134.9   125.0674
      1182 428.81  1876.8  5353.4  6182.4   123.8454
      1183 429.01  1837.0  5144.5  5928.9   123.7152
      1184 429.22  1920.2  5298.1  6098.4   123.6935
      1185 429.42  1838.3  5187.1  6038.6   125.4281
      1186 429.63  1935.7  5341.5  6187.3   124.8346
      1187 429.84  1910.3  5315.7  6170.1   125.0902
      1188 430.04  1792.4  5400.5  6195.5   122.0343
      1189 430.25  1973.0  5427.1  6204.1   122.4950
      1190 430.45  1884.1  5202.3  6070.6   126.1696
      1191 430.66  1796.5  5425.5  6271.3   123.3070
      1192 430.87  1800.6  5063.8  5933.4   126.6474
      1193 431.07  1862.0  5174.0  5944.0   123.2501
      1194 431.28  1896.0  5240.8  6109.9   125.9858
      1195 431.48  1793.6  5135.1  6006.7   126.0848
      1196 431.69  1868.2  5268.6  6059.1   123.2474
      1197 431.90  1873.1  5085.9  5790.8   121.9403
      1198 432.10  1889.5  5378.0  6207.4   123.7760
      1199 432.31  1813.7  5106.8  5897.7   124.0174
      1200 432.51  1878.0  5256.3  5988.7   121.6780
      1201 432.72  1943.5  5173.6  5992.8   125.3614
      1202 432.92  1830.1  5239.1  6043.6   123.5973
      1203 433.13  1883.3  5101.9  5837.5   122.8557
      1204 433.34  1915.3  5124.8  5982.5   126.7228
      1205 433.54  1925.9  5225.6  5973.5   122.6663
      1206 433.75  1820.2  5102.3  5899.8   124.2980
      1207 433.95  1966.5  5147.8  5892.8   123.4196
      1208 434.16  1923.9  5271.1  6089.0   124.4371
      1209 434.37  1796.5  5040.5  5819.1   124.0025
      1210 434.57  1968.1  5183.8  5958.8   124.0988
      1211 434.78  1925.1  5127.7  5947.3   125.5915
      1212 434.98  1812.0  5136.3  5992.4   125.7516
      1213 435.19  1826.8  5105.2  5853.1   122.8136
      1214 435.39  1848.9  5208.8  6017.3   124.0644
      1215 435.60  1836.2  5045.8  5788.4   123.1368
      1216 435.81  1942.7  5224.0  5996.9   123.5551
      1217 436.01  1811.6  5029.0  5746.2   122.2915
      1218 436.22  1905.4  5014.7  5715.5   122.5398
      1219 436.42  1880.0  5105.6  5863.3   123.4921
      1220 436.63  1873.1  5154.7  5944.8   124.0764
      1221 436.83  1947.6  5181.8  5978.4   124.6327
      1222 437.04  1888.2  5141.6  5930.1   124.2352
      1223 437.24  1809.6  5022.4  5855.6   125.9306
      1224 437.45  1825.6  5064.2  5868.7   124.8388
      1225 437.66  1900.5  4996.6  5727.8   123.6142
      1226 437.86  1794.0  4946.7  5588.5   120.3586
      1227 438.07  1912.4  5141.2  5939.9   124.7368
      1228 438.27  1883.3  5026.1  5816.6   125.1531
      1229 438.48  1939.0  5036.8  5764.2   123.4827
      1230 438.68  1854.6  5065.0  5835.9   124.0112
      1231 438.89  1880.0  5162.9  5876.0   121.7218
      1232 439.09  1907.1  5139.2  5901.8   123.5965
      1233 439.30  1825.1  5165.0  5902.2   122.0751
      1234 439.50  1913.2  5051.5  5763.8   122.6964
      1235 439.71  1804.7  5124.4  5924.4   124.0962
      1236 439.92  1910.3  5128.9  5883.4   123.4411
      1237 440.12  1846.0  5157.2  5930.9   123.3671
      1238 440.33  1830.5  5034.3  5840.4   125.1598
      1239 440.53  2000.5  5373.9  6141.0   122.7416
      1240 440.74  1800.2  5165.8  6011.2   125.1187
      1241 440.94  1919.4  5239.1  6078.8   125.2930
      1242 441.15  1957.9  5288.3  6071.8   123.5272
      1243 441.35  1853.4  5237.9  6013.7   122.9215
      1244 441.56  1877.6  5275.2  6020.2   121.9289
      1245 441.76  1851.8  5325.1  6218.9   125.7311
      1246 441.97  1897.2  5302.6  6175.4   125.6315
      1247 442.17  1861.6  5396.0  6263.5   124.5451
      1248 442.38  1865.7  5208.0  6066.1   125.6740
      1249 442.58  1919.8  5308.3  6108.3   123.6069
      1250 442.79  1890.3  5202.3  5994.8   123.9302
      1251 443.00  1863.2  5250.6  6073.0   124.2805
      1252 443.20  1846.4  5289.1  6100.1   123.5574
      1253 443.41  1880.4  5170.3  5985.8   124.7883
      1254 443.61  1819.4  5155.6  5956.3   124.0025
      1255 443.82  1923.0  5291.5  6053.4   122.6167
      1256 444.02  1860.8  5136.7  5951.8   124.8812
      1257 444.23  1755.9  5131.8  5908.8   123.0163
      1258 444.43  1866.9  5163.7  5970.2   124.4627
      1259 444.64  1931.2  5213.3  5978.4   123.3121
      1260 444.84  1937.8  5184.6  6078.8   127.5388
      1261 445.05  1833.3  5057.3  5826.9   123.8724
      1262 445.25  1935.7  5162.5  5954.3   124.5367
      1263 445.46  1890.3  5120.7  6028.8   128.1095
      1264 445.66  1810.8  4980.7  5815.0   126.3212
      1265 445.87  1868.2  5018.3  5763.0   123.6380
      1266 446.07  1857.1  5001.5  5756.4   124.0068
      1267 446.28  1964.8  5141.2  5914.5   124.3456
      1268 446.48  1846.0  5156.8  5866.2   121.4277
      1269 446.69  1819.4  4902.4  5697.9   125.8005
      1270 446.89  1873.1  5020.8  5748.2   123.1100
      1271 447.10  1845.2  4959.4  5767.5   125.9503
      1272 447.30  1937.0  5052.7  5739.6   122.0455
      1273 447.51  1892.3  4962.6  5670.4   123.0523
      1274 447.71  1887.4  5026.5  5763.8   123.4864
      1275 447.92  1887.0  4907.3  5635.2   124.0982
      1276 448.12  1859.1  4924.1  5647.1   123.5868
      1277 448.33  1921.8  4827.9  5504.5   123.2840
      1278 448.53  1802.6  4699.7  5389.4   123.8089
      1279 448.73  1886.6  4812.7  5491.8   123.2083
      1280 448.94  2017.7  4989.3  5753.6   125.7202
      1281 449.14  1859.1  4769.7  5473.4   124.1768
      1282 449.35  1853.0  4769.7  5407.9   121.8789
      1283 449.55  1874.3  4654.6  5380.0   126.0902
      1284 449.76  1961.1  4788.6  5468.1   124.0330
      1285 449.96  1916.9  4768.9  5503.7   125.7648
      1286 450.17  1967.7  4762.3  5496.7   126.2788
      1287 450.37  1858.3  4745.1  5413.6   123.1555
      1288 450.58  2002.1  4784.1  5427.1   123.1154
      1289 450.78  1819.4  4629.2  5244.4   121.8950
      1290 450.99  1780.9  4543.6  5214.1   124.2698
      1291 451.19  1930.0  4619.8  5331.7   126.4657
      1292 451.40  1821.1  4526.8  5193.2   124.6291
      1293 451.60  1873.5  4623.1  5202.7   121.0785
      1294 451.81  1880.0  4669.4  5322.3   123.4068
      1295 452.01  1855.5  4575.6  5194.5   122.7526
      1296 452.21  1917.7  4613.7  5191.2   121.4221
      1297 452.42  1857.9  4543.2  5173.6   123.4747
      1298 452.62  1839.1  4426.5  5044.1   123.8721
      1299 452.83  1869.8  4546.1  5165.4   123.1405
      1300 453.03  1929.2  4529.3  5178.9   124.9842
      1301 453.24  1903.0  4456.0  5132.2   126.4880
      1302 453.44  1962.0  4541.6  5152.3   123.6742
      1303 453.65  1813.3  4403.5  5009.3   123.3871
      1304 453.85  2044.3  4612.4  5243.6   124.5774
      1305 454.06  1948.0  4451.1  5015.1   122.5331
      1306 454.26  1890.7  4417.9  5043.3   124.7488
      1307 454.46  1973.4  4559.2  5187.1   124.2832
      1308 454.67  1916.5  4471.1  5000.3   120.7151
      1309 454.87  1900.9  4553.0  5084.7   120.0463
      1310 455.08  1951.7  4549.4  5190.0   124.6610
      1311 455.28  1916.9  4404.8  5046.2   125.7820
      1312 455.49  1867.3  4512.9  5176.9   125.0968
      1313 455.69  2040.2  4532.6  5179.3   125.9491
      1314 455.89  1887.4  4505.1  5045.0   120.6228
      1315 456.10  1785.0  4388.4  4949.1   121.5387
      1316 456.30  2026.3  4568.6  5214.1   125.3907
      1317 456.51  1893.6  4514.5  5150.2   124.2538
      1318 456.71  1833.8  4434.3  5097.8   125.5158
      1319 456.92  1880.9  4492.4  5093.3   123.0082
      1320 457.12  1930.0  4616.9  5184.2   121.1128
      1321 457.32  1832.1  4545.3  5073.6   119.4746
      1322 457.53  1911.2  4543.2  5196.9   124.8366
      1323 457.73  1900.9  4581.3  5179.7   122.3258
      1324 457.94  1955.0  4700.1  5286.2   121.3518
      1325 458.14  1814.5  4529.3  5135.5   122.3295
      1326 458.35  1867.3  4485.1  5138.4   124.9570
      1327 458.55  1881.7  4507.6  5118.7   123.2725
      1328 458.75  1949.7  4643.2  5245.3   122.3540
      1329 458.96  1968.5  4558.8  5214.1   125.3004
      1330 459.16  1785.0  4416.6  5081.8   125.2763
      1331 459.37  1840.7  4524.0  5153.9   123.4773
      1332 459.57  1789.1  4404.0  5088.4   126.1748
      1333 459.77  1989.0  4500.6  5110.9   124.2988
      1334 459.98  1880.0  4460.1  5070.8   123.6704
      1335 460.18  1864.9  4472.4  5146.1   125.8404
      1336 460.39  1931.2  4557.5  5159.2   122.9102
      1337 460.59  1814.9  4405.6  5025.7   123.9368
      1338 460.79  1752.7  4376.9  5007.3   124.0206
      1339 461.00  1761.7  4296.2  4863.5   122.3820
      1340 461.20  1850.5  4452.7  5072.0   123.7998
      1341 461.41  1934.9  4474.0  5149.8   126.6172
      1342 461.61  1889.5  4422.4  5098.2   126.6818
      1343 461.81  1864.9  4417.5  5020.8   123.6361
      1344 462.02  1879.2  4441.2  5003.2   121.9345
      1345 462.22  1972.2  4623.5  5209.2   122.0918
      1346 462.43  1916.9  4537.5  5171.5   124.1951
      1347 462.63  1798.1  4404.8  5002.0   122.9101
      1348 462.83  1976.7  4541.2  5182.6   125.0120
      1349 463.04  1889.9  4525.6  5146.5   123.5587
      1350 463.24  1872.7  4605.9  5260.0   123.9323
      1351 463.45  1901.7  4635.4  5271.9   123.2844
      1352 463.65  1817.8  4618.2  5195.7   120.6231
      1353 463.85  1929.6  4692.7  5323.5   122.8283
      1354 464.06  1799.8  4563.3  5199.0   123.0028
      1355 464.26  2043.5  4743.1  5471.8   126.9914
      1356 464.46  1880.4  4656.7  5339.9   124.6090
      1357 464.67  1959.1  4743.5  5370.6   122.5213
      1358 464.87  1923.5  4700.1  5347.2   123.3073
      1359 465.08  1847.3  4535.0  5248.5   126.5468
      1360 465.28  1909.5  4680.0  5385.3   125.4583
      1361 465.48  1866.5  4626.4  5304.6   124.5770
      1362 465.69  1868.2  4646.4  5231.3   121.0526
      1363 465.89  1871.4  4534.2  5212.5   125.4730
      1364 466.09  1994.3  4733.7  5473.0   126.9886
      1365 466.30  1981.2  4641.9  5315.3   125.3079
      1366 466.50  1829.2  4490.8  5105.2   123.0840
      1367 466.71  1880.9  4542.4  5169.9   123.5765
      1368 466.91  1930.4  4591.1  5246.1   124.6151
      1369 467.11  1941.9  4587.4  5218.6   123.8582
      1370 467.32  1906.7  4485.5  5105.6   124.0470
      1371 467.52  1831.3  4444.9  5027.8   122.3006
      1372 467.72  1841.1  4369.5  5020.4   125.7411
      1373 467.93  1807.9  4325.3  4928.2   123.9505
      1374 468.13  1901.7  4471.1  5050.3   122.5410
      1375 468.33  1839.9  4300.3  4852.0   122.4238
      1376 468.54  1887.8  4437.9  5048.7   123.9480
      1377 468.74  2058.6  4481.0  5029.0   122.6243
      1378 468.94  1945.2  4430.2  5008.1   123.2570
      1379 469.15  1928.8  4292.5  4905.7   125.9400
      1380 469.35  1850.5  4241.8  4827.9   124.5118
      1381 469.55  1839.1  4240.5  4868.4   126.1470
      1382 469.76  1898.1  4288.0  4864.7   124.1302
      1383 469.96  1919.4  4334.7  4905.7   123.6391
      1384 470.17  1910.8  4233.2  4785.3   123.7743
      1385 470.37  2004.6  4382.2  4955.3   124.0999
      1386 470.57  1932.5  4269.2  4848.8   124.8028
      1387 470.78  1866.9  4258.5  4791.8   122.2983
      1388 470.98  1927.1  4358.9  4965.9   124.9621
      1389 471.18  1933.7  4338.8  4913.1   123.8760
      1390 471.39  1932.1  4315.1  4890.5   124.1492
      1391 471.59  1948.8  4437.9  4976.2   121.6225
      1392 471.79  1823.1  4334.7  4879.9   121.7058
      1393 471.99  1812.0  4286.8  4866.0   123.4028
      1394 472.20  1864.1  4406.4  4956.1   121.6208
      1395 472.40  1814.5  4353.6  4954.4   123.6651
      1396 472.60  1823.5  4340.9  4918.4   122.9418
      1397 472.81  1901.3  4425.7  5051.9   124.8093
      1398 473.01  1853.4  4599.7  5107.6   118.4937
      1399 473.21  1984.1  4569.4  5225.2   125.3644
      1400 473.42  2029.9  4700.5  5326.8   123.4509
      1401 473.62  1969.3  4632.1  5323.5   125.9652
      1402 473.82  1889.0  4595.6  5318.6   126.7100
      1403 474.03  2042.6  4719.7  5400.9   125.4437
      1404 474.23  1817.4  4596.9  5268.6   124.1674
      1405 474.43  1924.7  4681.7  5328.8   123.4735
      1406 474.64  1753.5  4514.5  5196.9   124.7144
      1407 474.84  1898.5  4684.1  5403.0   125.8050
      1408 475.04  1908.7  4714.0  5383.7   123.8721
      1409 475.25  1916.9  4708.3  5388.6   124.3727
      1410 475.45  1794.4  4710.3  5394.3   123.4584
      1411 475.65  1839.5  4705.0  5396.8   124.1424
      1412 475.85  1767.0  4743.9  5401.7   122.0969
      1413 476.06  1927.1  4794.7  5549.6   126.3248
      1414 476.26  1950.9  4834.0  5540.2   124.4921
      1415 476.46  1853.4  4778.3  5514.8   125.1785
      1416 476.67  1879.2  4813.5  5490.2   123.0597
      1417 476.87  1933.3  4875.4  5570.5   123.6252
      1418 477.07  1854.6  4890.5  5554.1   121.8564
      1419 477.28  1841.1  4867.6  5525.8   121.7485
      1420 477.48  1920.6  4965.9  5617.6   121.3988
      1421 477.68  1946.4  4986.0  5651.2   121.8838
      1422 477.88  1892.7  4973.7  5686.4   123.1321
      1423 478.09  1871.8  4977.4  5722.8   124.0042
      1424 478.29  1866.5  4989.7  5654.0   121.2721
      1425 478.49  1957.4  5150.6  5854.7   122.0498
      1426 478.70  1801.0  4986.4  5648.3   120.7792
      1427 478.90  1940.2  5074.5  5805.2   123.3142
      1428 479.10  1830.5  5008.9  5784.3   124.3943
      1429 479.30  1949.3  5164.6  5935.8   123.9873
      1430 479.51  1887.8  5076.5  5847.8   124.1875
      1431 479.71  1812.0  5030.6  5682.7   120.2596
      1432 479.91  1921.4  5202.3  5920.3   121.8851
      1433 480.11  1900.1  5201.8  5990.7   123.8928
      1434 480.32  1922.2  5244.8  5900.2   119.7239
      1435 480.52  1988.6  5343.6  6088.6   122.2073
      1436 480.72  1908.7  5128.5  5992.8   126.8414
      1437 480.93  1868.2  5171.1  5908.4   122.3214
      1438 481.13  1766.6  5028.6  5894.1   126.5319
      1439 481.33  1811.2  5224.4  5971.1   121.8769
      1440 481.53  1968.1  5297.7  6107.0   124.3080
      1441 481.74  1915.7  5377.1  6157.0   122.5299
      1442 481.94  1835.0  5394.3  6205.3   122.7848
      1443 482.14  1913.6  5553.3  6392.1   123.0475
      1444 482.34  1855.5  5673.3  6590.8   124.0318
      1445 482.55  1885.0  5850.6  6904.5   126.5751
      1446 482.75  1880.9  6114.0  7115.1   123.6478
      1447 482.95  1919.8  6319.2  7312.9   122.5864
      1448 483.15  1905.0  6571.5  7801.1   126.3495
      1449 483.36  1785.4  6765.7  7935.5   123.4888
      1450 483.56  1942.3  7331.7  8515.9   121.9714
      1451 483.76  1774.0  7242.4  8522.4   123.4065
      1452 483.96  1889.0  7539.4  8908.3   124.2262
      1453 484.17  1916.1  7760.6  9139.3   123.5896
      1454 484.37  1861.2  7797.4  9256.8   124.5843
      1455 484.57  1905.8  7998.5  9409.6   123.1597
      1456 484.77  1880.4  8057.1  9513.2   123.5743
      1457 484.98  1952.9  8140.3  9647.6   124.3612
      1458 485.18  1861.2  8119.8  9713.1   125.4581
      1459 485.38  1923.5  8188.6  9754.9   125.0000
      1460 485.58  1858.3  8320.5  9866.3   123.9209
      1461 485.79  1965.2  8293.9  9716.8   122.4840
      1462 485.99  1713.7  8110.8  9660.7   124.2285
      1463 486.19  1912.8  8179.2  9678.7   123.9297
      1464 486.39  1956.6  8304.5  9725.8   122.3900
      1465 486.59  1781.7  7858.1  9362.5   124.7590
      1466 486.80  1922.2  7860.5  9261.3   123.5895
      1467 487.00  1875.1  7547.2  8894.7   123.7579
      1468 487.20  1921.4  7467.3  8709.2   122.3929
      1469 487.40  1900.5  7216.2  8433.5   122.9003
      1470 487.61  1912.8  7033.1  8317.6   125.0860
      1471 487.81  1847.3  6830.8  7915.8   121.7720
      1472 488.01  1910.3  6664.1  7751.2   122.8675
      1473 488.21  1905.0  6565.4  7647.9   123.2290
      1474 488.41  1907.5  6383.1  7381.7   122.3117
      1475 488.62  1907.1  6261.5  7348.1   124.9553
      1476 488.82  1839.5  6078.0  7134.7   124.9324
      1477 489.02  1841.5  6054.6  7034.0   123.2452
      1478 489.22  1957.4  6015.7  6994.6   124.1219
      1479 489.43  1853.4  5886.3  6829.2   123.3801
      1480 489.63  1970.1  5926.8  6813.2   122.4017
      1481 489.83  1881.7  5719.2  6560.9   121.9340
      1482 490.03  1900.9  5626.2  6565.4   125.2117
      1483 490.23  1755.1  5498.8  6335.2   122.3414
      1484 490.44  1778.9  5518.5  6406.5   123.7459
      1485 490.64  1934.9  5473.0  6345.4   124.6585
      1486 490.84  1928.4  5486.1  6313.9   123.2673
      1487 491.04  1859.1  5373.1  6191.4   123.2894
      1488 491.24  1862.8  5358.7  6144.7   122.4839
      1489 491.45  1982.8  5355.8  6206.6   125.2216
      1490 491.65  1946.8  5356.7  6217.6   125.2492
      1491 491.85  1891.9  5228.9  6014.9   123.5547
      1492 492.05  2070.1  5434.9  6196.7   122.6415
      1493 492.25  1908.7  5241.6  6025.1   123.5099
      1494 492.45  1879.6  5225.6  5962.9   122.0345
      1495 492.66  1855.5  5115.8  5928.5   124.9246
      1496 492.86  1818.6  5156.0  5944.8   123.6377
      1497 493.06  1944.8  5217.4  5985.8   123.4793
      1498 493.26  1975.1  5304.6  6025.5   121.6509
      1499 493.46  1875.1  5236.2  5999.7   122.7151
      1500 493.67  2058.6  5430.8  6201.7   122.8592
      1501 493.87  1787.5  5097.4  5833.0   122.2250
      1502 494.07  1932.5  5196.5  5997.3   124.5326
      1503 494.27  1793.2  5094.5  5883.4   123.8958
      1504 494.47  1807.1  5131.4  5919.0   123.6939
      1505 494.67  1919.8  5220.3  5975.2   122.8717
      1506 494.88  1893.6  5161.7  5928.5   123.4616
      1507 495.08  1942.7  5244.0  6034.1   123.9330
      1508 495.28  1892.7  5185.9  5940.7   122.9229
      1509 495.48  1878.0  5187.5  5866.2   120.5074
      1510 495.68  1804.3  5107.2  5829.7   121.8750
      1511 495.89  1837.0  5122.0  5946.5   125.0998
      1512 496.09  1824.7  5120.7  5824.4   121.3496
      1513 496.29  1900.9  5174.8  5894.5   121.9817
      1514 496.49  1955.4  5256.3  6037.0   123.6506
      1515 496.69  1898.9  5128.5  5948.1   125.3773
      1516 496.89  1770.3  5071.2  5835.1   123.1418
      1517 497.09  1915.7  5187.9  6028.0   125.6728
      1518 497.30  1932.5  5232.2  6013.7   123.6842
      1519 497.50  1912.0  5177.7  5994.0   124.9969
      1520 497.70  1912.4  5131.4  5913.3   124.2906
      1521 497.90  1998.0  5259.6  6002.6   122.7804
      1522 498.10  1903.0  5096.2  5885.5   124.7178
      1523 498.30  2076.2  5412.0  6208.2   123.8703
      1524 498.51  1909.5  5198.2  5910.4   121.6590
      1525 498.71  1860.0  5202.3  5942.0   122.1324
      1526 498.91  1794.8  5072.4  5906.3   125.4436
      1527 499.11  1984.1  5232.2  6034.5   124.7037
      1528 499.31  1926.7  5230.1  5971.5   122.4427
      1529 499.51  1936.6  5288.3  6106.6   124.4165
      1530 499.71  1898.1  5242.0  6002.2   122.7340
      1531 499.92  1847.3  5118.7  5894.5   123.7135
      1532 500.12  1893.6  5217.0  6094.3   126.3988
      1533 500.32  1881.3  5170.3  6028.0   126.0772
      1534 500.52  1881.7  5221.9  5991.9   123.0533
      1535 500.72  1783.0  5049.9  5874.0   125.2257
      1536 500.92  1969.7  5321.4  6109.5   123.5122
      1537 501.12  1960.7  5271.1  6058.7   123.7936
      1538 501.32  1717.8  5084.7  5857.2   122.9440
      1539 501.53  1830.9  5188.7  5943.2   122.4689
      1540 501.73  1945.2  5271.9  6101.7   124.9446
      1541 501.93  1930.8  5280.9  6028.0   122.3010
      1542 502.13  1803.0  5110.9  5959.2   125.6439
      1543 502.33  1738.7  5112.1  5840.4   121.5881
      1544 502.53  1861.6  5170.7  5955.1   123.7034
      1545 502.73  1909.9  5174.8  5961.2   124.0873
      1546 502.93  1772.7  5038.8  5799.0   123.2756
      1547 503.14  1887.4  5165.4  5915.8   122.8914
      1548 503.34  1805.1  5124.8  5919.9   123.9482
      1549 503.54  1881.3  5124.8  5903.9   124.0182
      1550 503.74  1981.6  5183.4  5972.3   124.6386
      1551 503.94  1762.1  5074.5  5795.8   121.7757
      1552 504.14  1913.2  5144.5  5941.6   124.6673
      1553 504.34  1923.0  5091.7  5817.9   122.9188
      1554 504.54  1799.3  5006.5  5753.6   123.2950
      1555 504.74  1873.5  5047.8  5774.9   122.9032
      1556 504.95  1929.2  5109.3  5804.8   121.8702
      1557 505.15  2029.1  5185.5  5888.7   122.2813
      1558 505.35  1887.8  4991.7  5724.9   123.6210
      1559 505.55  1851.4  4975.7  5756.4   124.9869
      1560 505.75  1890.7  4936.8  5711.0   125.4135
      1561 505.95  1888.2  5008.1  5723.7   122.9355
      1562 506.15  1883.3  4931.5  5691.7   124.9395
      1563 506.35  1894.8  4946.7  5676.6   123.9163
      1564 506.55  1864.1  4921.3  5568.8   121.1817
      1565 506.75  1924.3  4936.8  5710.6   125.6832
      1566 506.95  1850.5  4839.8  5562.3   124.1710
      1567 507.16  1978.7  4956.5  5697.4   124.8831
      1568 507.36  1928.0  4926.2  5644.6   123.9617
      1569 507.56  1970.1  4912.7  5678.2   126.0161
      1570 507.76  1832.5  4868.0  5521.7   121.5356
      1571 507.96  2002.5  4915.5  5597.1   123.3971
      1572 508.16  1818.2  4813.1  5463.6   121.7177
      1573 508.36  1873.5  4834.0  5543.9   123.9762
      1574 508.56  1921.0  4836.9  5502.9   122.8403
      1575 508.76  1823.9  4727.5  5484.5   126.0686
      1576 508.96  1881.7  4841.0  5533.6   123.4048
      1577 509.16  2020.1  4942.6  5646.7   124.0925
      1578 509.36  1837.0  4696.4  5425.9   125.5121
      1579 509.57  1964.4  4827.9  5517.2   124.0738
      1580 509.77  1834.2  4715.7  5422.2   124.5203
      1581 509.97  1850.1  4730.4  5391.5   122.9522
      1582 510.17  1862.8  4716.1  5385.7   123.4711
      1583 510.37  1822.7  4705.8  5416.5   124.6484
      1584 510.57  1857.9  4691.1  5339.1   122.8712
      1585 510.77  1806.3  4670.2  5344.0   123.5269
      1586 510.97  1855.9  4657.5  5394.3   126.3012
      1587 511.17  1854.6  4659.1  5407.9   126.6978
      1588 511.37  1947.6  4752.1  5500.0   126.6686
      1589 511.57  1966.5  4748.8  5459.1   125.5263
      1590 511.77  1882.9  4674.7  5328.4   123.4155
      1591 511.97  1847.3  4711.1  5321.0   121.2958
      1592 512.17  1956.2  4730.4  5369.8   123.0474
      1593 512.37  1955.8  4761.9  5357.9   121.2378
      1594 512.57  1828.0  4585.0  5235.0   123.5775
      1595 512.78  1870.6  4626.4  5273.5   123.4839
      1596 512.98  1861.6  4590.3  5262.9   124.6473
      1597 513.18  1772.3  4537.1  5217.0   124.5926
      1598 513.38  1850.5  4625.5  5220.7   121.4465
      1599 513.58  1902.6  4638.6  5272.3   123.1587
      1600 513.78  1962.4  4673.5  5310.4   123.4930
      1601 513.98  1940.7  4616.5  5222.7   122.6542
      1602 514.18  2040.6  4774.6  5379.2   122.1124
      1603 514.38  1823.5  4480.5  5116.6   123.9402
      1604 514.58  1728.9  4337.6  5087.2   128.7329
      1605 514.78  1844.4  4492.0  5125.7   123.9325
      1606 514.98  1952.5  4579.3  5267.8   126.2124
      1607 515.18  1926.3  4595.6  5244.0   124.2903
      1608 515.38  1854.2  4519.9  5173.2   124.5083
      1609 515.58  1825.1  4490.8  5154.7   124.9078
      1610 515.78  1801.0  4435.9  5078.1   124.3743
      1611 515.98  1908.7  4583.4  5182.6   122.4043
      1612 516.18  1909.1  4567.8  5181.4   123.0781
      1613 516.38  1978.7  4631.7  5233.0   122.6648
      1614 516.58  1833.3  4550.6  5184.2   123.3193
      1615 516.78  1783.0  4423.6  5056.4   123.9646
      1616 516.98  1776.4  4459.7  5065.4   122.5767
      1617 517.18  1888.6  4501.0  5221.5   127.5792
      1618 517.38  1800.6  4478.9  5137.1   124.5756
      1619 517.58  1875.1  4512.5  5230.1   127.2092
      1620 517.78  1848.5  4473.2  5185.9   127.1536
      1621 517.98  1935.3  4616.1  5205.1   121.9710
      1622 518.18  1824.7  4455.6  5015.1   121.2673
      1623 518.38  1819.0  4467.4  5081.0   123.1673
      1624 518.58  2025.9  4661.6  5250.2   122.3310
      1625 518.78  1857.1  4477.3  5113.4   124.2770
      1626 518.98  1969.3  4546.9  5174.0   124.3286
      1627 519.18  1907.1  4562.1  5080.6   119.5310
      1628 519.38  1914.9  4508.0  5079.0   122.0186
      1629 519.58  1885.8  4547.3  5101.9   120.8372
      1630 519.78  1806.7  4460.5  5052.3   122.3028
      1631 519.98  2011.5  4582.9  5149.0   122.0134
      1632 520.18  1860.0  4496.9  5071.2   121.7769
      1633 520.38  1910.8  4483.8  5131.0   125.1512
      1634 520.58  1848.1  4482.2  5046.6   121.4275
      1635 520.78  1854.2  4445.3  5013.8   121.9412
      1636 520.98  1909.5  4539.5  5122.8   122.1772
      1637 521.18  1936.6  4506.8  5121.6   123.9203
      1638 521.38  1950.9  4540.3  5166.6   124.1854
      1639 521.58  1952.1  4509.2  5072.4   122.0247
      1640 521.78  1963.6  4475.2  5092.5   124.5760
      1641 521.98  1872.7  4427.3  5052.7   124.4829
      1642 522.18  1859.1  4419.9  5033.9   123.9763
      1643 522.38  1940.7  4554.7  5166.6   123.4096
      1644 522.58  1803.9  4355.6  4861.1   119.8074
      1645 522.78  1881.3  4513.3  5050.7   120.4171
      1646 522.98  1907.9  4472.4  5047.4   122.4245
      1647 523.18  1824.7  4419.1  5073.2   125.2131
      1648 523.38  1875.9  4467.0  5059.7   122.8739
      1649 523.58  1839.5  4451.1  5028.2   122.0985
      1650 523.78  1740.4  4392.1  5010.6   123.3241
      1651 523.98  1810.4  4421.6  5000.7   122.1804
      1652 524.18  1866.1  4462.5  5088.0   124.0890
      1653 524.38  1875.5  4467.4  5090.0   124.0202
      1654 524.58  1840.3  4417.1  5118.3   127.2135
      1655 524.78  1899.3  4471.5  5166.6   127.0223
      1656 524.98  1858.3  4477.3  5145.7   125.5239
      1657 525.18  1867.3  4487.9  5090.4   122.9916
      1658 525.38  1939.0  4567.4  5216.2   124.6844
      1659 525.58  1989.4  4578.8  5262.5   126.3999
      1660 525.78  1896.4  4564.1  5239.1   125.3032
      1661 525.98  1906.7  4557.5  5134.3   121.7553
      1662 526.18  1875.1  4531.7  5161.3   123.6972
      1663 526.38  1801.4  4425.3  5060.5   124.2117
      1664 526.58  1873.9  4546.1  5201.0   124.5095
      1665 526.78  1841.9  4478.5  5162.5   125.9438
      1666 526.98  1944.8  4620.2  5210.4   122.0606
      1667 527.17  1764.9  4495.3  5131.8   123.3123
      1668 527.37  1840.7  4573.5  5152.7   121.1930
      1669 527.57  1825.6  4537.9  5175.6   123.5125
      1670 527.77  1813.3  4477.3  5098.2   123.3087
      1671 527.97  1891.1  4562.1  5218.6   124.5821
      1672 528.17  1813.3  4552.6  5151.9   121.8750
      1673 528.37  1902.6  4555.5  5253.4   126.3085
      1674 528.57  1850.1  4594.8  5212.5   122.5041
      1675 528.77  1847.7  4524.8  5209.6   125.5814
      1676 528.97  1992.7  4732.9  5366.1   123.1091
      1677 529.17  1911.2  4633.7  5267.8   123.2887
      1678 529.37  1979.6  4724.7  5350.9   122.8141
      1679 529.57  1902.6  4649.7  5299.7   123.6618
      1680 529.77  1875.1  4590.3  5210.0   122.8240
      1681 529.97  1979.6  4732.9  5354.2   122.5677
      1682 530.17  1961.5  4792.7  5374.3   120.5440
      1683 530.36  1900.1  4605.5  5346.0   127.3732
      1684 530.56  1930.8  4655.4  5273.9   122.6999
      1685 530.76  1822.7  4560.8  5182.2   122.6926
      1686 530.96  1922.6  4636.6  5363.2   126.7733
      1687 531.16  1896.8  4650.9  5372.6   126.2046
      1688 531.36  1936.6  4785.3  5410.3   121.9410
      1689 531.56  1962.8  4793.9  5466.8   123.7703
      1690 531.76  1793.6  4593.2  5253.4   123.5845
      1691 531.96  1833.8  4646.4  5361.6   125.4260
      1692 532.16  1846.0  4734.5  5436.9   124.3193
      1693 532.36  1863.7  4744.3  5425.9   123.6599
      1694 532.56  1837.0  4744.3  5407.0   122.7952
      1695 532.76  1859.1  4774.6  5439.0   122.7873
      1696 532.95  1865.3  4743.5  5409.9   123.1536
      1697 533.15  1903.4  4805.4  5543.9   125.4481
      1698 533.35  1957.9  4859.4  5602.0   125.5929
      1699 533.55  1833.3  4761.9  5467.3   124.0839
      1700 533.75  1992.3  4985.2  5657.3   122.4579
      1701 533.95  1901.7  4769.7  5525.4   126.3496
      1702 534.15  1825.6  4761.1  5431.6   122.8408
      1703 534.35  1927.1  4825.8  5592.6   126.4519
      1704 534.55  1921.0  4917.2  5559.0   121.4217
      1705 534.75  1907.1  4809.0  5441.0   121.7784
      1706 534.94  1844.0  4742.3  5497.6   126.0599
      1707 535.14  1945.2  4830.3  5465.6   122.0187
      1708 535.34  1855.5  4771.8  5443.5   123.0337
      1709 535.54  1862.8  4783.6  5519.7   125.1998
      1710 535.74  1907.5  4858.2  5520.9   122.4597
      1711 535.94  1821.9  4755.0  5420.2   122.6784
      1712 536.14  1856.7  4839.4  5538.5   123.4414
      1713 536.34  2070.1  4926.2  5634.4   124.7956
      1714 536.54  1980.0  4989.7  5670.8   122.6320
      1715 536.73  1833.3  4750.9  5496.7   125.5651
      1716 536.93  1846.9  4805.8  5548.8   125.1107
      1717 537.13  1978.7  4914.7  5621.7   124.0792
      1718 537.33  2036.5  4956.1  5687.2   125.0421
      1719 537.53  1898.5  4842.6  5485.3   121.8280
      1720 537.73  1836.2  4819.7  5492.2   122.5426
      1721 537.93  1835.0  4812.3  5537.3   124.3500
      1722 538.13  1949.3  4972.1  5639.3   122.0732
      1723 538.32  1896.8  4879.1  5593.0   123.9390
      1724 538.52  1832.1  4863.9  5486.9   120.5485
      1725 538.72  1827.2  4836.1  5538.5   123.3460
      1726 538.92  1876.8  4927.4  5620.9   122.7309
      1727 539.12  1854.6  4898.3  5585.6   122.5811
      1728 539.32  1965.2  5009.7  5690.9   122.3732
      1729 539.52  1906.7  4942.2  5615.1   122.1697
      1730 539.72  1903.0  4974.5  5583.6   119.8293
      1731 539.91  1858.3  4898.3  5653.2   124.8316
      1732 540.11  1832.9  4880.3  5629.0   124.5699
      1733 540.31  1854.6  4940.1  5606.1   121.5850
      1734 540.51  1883.7  5022.0  5655.3   120.1775
      1735 540.71  2054.5  5108.5  5802.7   122.7334
      1736 540.91  2005.8  5022.4  5723.7   123.2451
      1737 541.11  1813.3  4884.0  5636.8   124.5165
      1738 541.30  1778.0  4945.4  5559.0   119.3715
      1739 541.50  1804.7  4862.7  5566.0   122.9976
      1740 541.70  1811.2  4946.3  5617.2   121.4006
      1741 541.90  1870.6  4947.1  5710.1   124.8036
      1742 542.10  1748.1  4886.5  5550.8   121.1694
      1743 542.30  1780.5  4879.9  5615.9   123.7479
      1744 542.49  1912.8  5054.0  5774.0   122.9235
      1745 542.69  1821.9  5012.2  5672.1   120.6830
      1746 542.89  1801.0  4943.0  5586.4   120.4797
      1747 543.09  1839.1  4972.5  5722.4   123.9346
      1748 543.29  1939.8  5085.1  5776.5   121.9820
      1749 543.49  1968.9  5105.2  5778.1   121.4575
      1750 543.68  1995.1  5094.9  5781.0   122.1327
      1751 543.88  1837.0  4921.3  5615.9   122.5232
      1752 544.08  1898.1  5082.2  5735.5   120.5171
      1753 544.28  1903.8  5083.9  5752.7   121.0330
      1754 544.48  1979.6  5135.9  5803.1   121.1394
      1755 544.68  1885.0  4986.0  5756.4   124.8448
      1756 544.87  1938.2  5088.4  5836.3   123.7420
      1757 545.07  1912.4  5062.6  5703.6   120.3485
      1758 545.27  1878.8  5078.1  5710.1   119.7542
      1759 545.47  1888.6  5064.6  5788.4   122.7882
      1760 545.67  1865.3  5005.2  5746.2   123.5977
      1761 545.87  1871.4  4992.5  5724.9   123.4646
      1762 546.06  1832.9  4982.7  5703.6   122.8869
      1763 546.26  1840.3  5054.4  5675.7   119.3322
      1764 546.46  1842.4  5042.5  5764.2   122.5522
      1765 546.66  1867.7  5089.2  5715.9   119.4533
      1766 546.86  2070.5  5233.8  5886.7   120.6396
      1767 547.05  1814.9  4967.1  5699.5   123.2328
      1768 547.25  1948.4  5085.5  5826.5   123.6193
      1769 547.45  2068.9  5244.0  5948.9   122.2007
      1770 547.65  1840.7  5039.2  5736.0   121.7826
      1771 547.85  1767.8  4832.0  5584.8   124.5689
      1772 548.04  1948.0  5126.9  5877.7   123.6181
      1773 548.24  1980.4  5104.8  5787.2   121.8406
      1774 548.44  1958.7  5042.5  5747.4   122.8583
      1775 548.64  1905.4  5043.7  5723.7   121.6654
      1776 548.84  2013.2  5128.9  5790.4   121.2304
      1777 549.03  1854.6  4841.4  5569.7   124.3829
      1778 549.23  1860.4  4920.0  5621.3   122.9183
      1779 549.43  1841.9  4888.5  5638.5   124.6168
      1780 549.63  1862.4  4959.4  5646.7   122.1928
      1781 549.83  1897.2  4937.7  5571.7   120.8541
      1782 550.02  1862.4  4929.9  5702.8   125.1970
      1783 550.22  1891.1  4946.3  5682.3   124.0917
      1784 550.42  1853.0  4961.4  5649.9   122.1505
      1785 550.62  1932.5  4967.1  5677.0   123.3905
      1786 550.82  1802.2  4832.8  5473.4   121.1380
      1787 551.01  1899.3  4963.5  5611.8   121.1603
      1788 551.21  1857.9  4913.9  5667.5   124.6616
      1789 551.41  2034.9  5057.3  5815.8   125.0983
      1790 551.61  1789.5  4813.5  5506.2   122.9040
      1791 551.80  1867.3  4992.5  5663.5   121.4679
      1792 552.00  1866.9  4898.3  5588.9   122.7807
      1793 552.20  1917.3  4922.9  5750.3   127.5279
      1794 552.40  1794.0  4881.1  5511.5   120.4193
      1795 552.60  1939.8  5035.1  5747.8   123.0250
      1796 552.79  1925.1  4955.7  5715.1   125.0574
      1797 552.99  1903.0  5004.0  5707.3   122.6786
      1798 553.19  1906.2  4952.0  5688.8   124.1931
      1799 553.39  1807.1  4930.7  5604.1   121.5578
      1800 553.58  1864.5  5034.7  5669.2   120.0129
      1801 553.78  1790.7  4883.6  5547.5   121.4674
      1802 553.98  1915.7  4949.9  5706.1   124.9190
      1803 554.18  1856.7  4915.9  5578.7   121.6629
      1804 554.37  1802.6  4872.9  5516.4   120.9578
      1805 554.57  1908.3  4875.0  5664.3   126.6050
      1806 554.77  1943.1  4999.5  5675.7   122.1254
      1807 554.97  1946.0  5000.3  5683.5   122.3682
      1808 555.16  1962.0  5008.5  5600.4   119.4273
      1809 555.36  2070.5  5072.8  5828.1   125.1569
      1810 555.56  1854.2  4927.8  5623.7   122.6413
      1811 555.76  1791.6  4884.8  5586.9   122.6960
      1812 555.95  2052.5  5128.5  5763.8   120.6525
      1813 556.15  1876.3  4877.9  5533.6   121.8477
      1814 556.35  1880.0  4897.9  5605.7   123.4528
      1815 556.55  1918.5  4896.3  5586.0   123.1637
      1816 556.74  1792.8  4843.4  5475.9   120.7304
      1817 556.94  1880.9  4838.1  5535.7   123.5873
      1818 557.14  1787.5  4769.3  5493.5   124.2857
      1819 557.34  1894.4  4849.2  5539.3   123.3574
      1820 557.53  1908.3  4889.3  5555.7   122.3550
      1821 557.73  1887.0  4892.6  5571.7   122.5947
      1822 557.93  1838.7  4861.1  5592.2   124.1903
      1823 558.13  1822.7  4862.7  5529.5   121.9348
      1824 558.32  1897.2  4889.3  5584.8   123.2444
      1825 558.52  1897.2  5020.4  5609.8   118.8721
      1826 558.72  1787.9  4870.5  5581.5   123.0667
      1827 558.92  1956.6  5010.6  5709.3   122.8809
      1828 559.11  1906.2  4946.7  5674.5   123.9391
      1829 559.31  1884.5  5008.9  5687.6   121.7226
      1830 559.51  1902.2  5002.4  5743.7   123.9133
      1831 559.70  1928.0  5054.4  5792.9   123.6211
      1832 559.90  1891.5  4964.7  5673.3   123.0574
      1833 560.10  1842.8  4947.5  5701.1   124.2744
      1834 560.30  1923.9  5048.2  5822.0   124.7640
      1835 560.49  1924.3  5068.3  5794.1   123.0849
      1836 560.69  1846.4  5070.0  5814.6   123.1004
      1837 560.89  1993.5  5149.4  5933.8   124.8540
      1838 561.08  1806.3  5056.8  5760.9   121.6608
      1839 561.28  1839.9  4990.1  5792.5   125.4713
      1840 561.48  1831.7  5088.8  5851.5   123.4155
      1841 561.68  1928.0  5115.4  5849.8   123.0403
      1842 561.87  1860.8  5057.7  5865.8   125.2787
      1843 562.07  1865.7  5121.6  5881.8   123.3488
      1844 562.27  1812.9  5033.5  5802.3   123.8713
      1845 562.46  1864.9  5154.7  5951.8   124.2281
      1846 562.66  1961.5  5231.7  6006.3   123.6849
      1847 562.86  1841.5  5132.2  5864.2   122.2430
      1848 563.05  1880.9  5139.6  5964.9   125.3268
      1849 563.25  1821.5  5081.4  5920.3   125.7319
      1850 563.45  1775.6  5122.4  5901.8   123.2897
      1851 563.65  2077.9  5387.4  6182.8   124.0347
      1852 563.84  1935.7  5302.6  6124.2   124.4039
      1853 564.04  1844.8  5297.3  6115.2   123.6920
      1854 564.24  1861.2  5303.0  6112.0   123.5035
      1855 564.43  1868.6  5261.2  6156.6   126.3914
      1856 564.63  1951.3  5421.4  6306.9   125.5194
      1857 564.83  1905.8  5468.9  6272.5   122.5543
      1858 565.02  1863.7  5441.0  6284.0   123.5631
      1859 565.22  1811.2  5465.2  6356.5   124.3919
      1860 565.42  1815.7  5540.2  6376.6   122.4568
      1861 565.61  1896.8  5609.0  6468.3   123.1491
      1862 565.81  1818.2  5732.3  6555.5   121.0339
      1863 566.01  1974.2  5849.0  6774.3   123.8795
      1864 566.20  1889.5  5822.4  6822.2   125.4218
      1865 566.40  1826.8  5840.8  6918.4   126.8469
      1866 566.60  1846.4  6070.6  7045.8   123.0874
      1867 566.79  1887.8  6212.3  7241.6   123.8019
      1868 566.99  1912.0  6455.2  7516.0   123.3502
      1869 567.19  1910.3  6537.9  7586.5   122.6589
      1870 567.38  1984.9  6651.4  7873.2   126.1827
      1871 567.58  1922.6  6719.4  7978.5   126.2488
      1872 567.78  1872.7  6947.1  8105.9   122.8348
      1873 567.97  1802.6  7009.0  8331.1   125.3953
      1874 568.17  1706.8  7124.9  8358.2   122.7623
      1875 568.37  1868.6  7423.1  8729.3   123.5160
      1876 568.56  1997.6  7684.0  9106.5   125.0162
      1877 568.76  1873.5  7744.6  9212.6   125.0035
      1878 568.96  1875.1  7940.8  9366.2   123.4992
      1879 569.15  1918.5  8109.1  9570.2   123.6006
      1880 569.35  2034.9  8586.7 10144.4   123.7747
      1881 569.55  1995.1  8571.6 10110.8   123.4056
      1882 569.74  1863.7  8536.8 10155.9   124.2634
      1883 569.94  2011.1  8689.9 10355.8   124.9417
      1884 570.14  1886.2  8912.4 10584.3   123.7962
      1885 570.33  1884.5  8967.6 10705.1   124.5302
      1886 570.53  1818.6  9030.7 10847.3   125.1874
      1887 570.73  1793.6  9250.7 10971.8   123.0803
      1888 570.92  1810.0  9387.9 11195.8   123.8582
      1889 571.12  1883.7  9507.9 11391.2   124.7018
      1890 571.31  1785.8  9643.1 11434.6   122.8014
      1891 571.51  1892.3  9840.1 11818.4   124.8918
      1892 571.71  1894.8 10058.0 11950.7   123.1862
      1893 571.90  1986.1 10236.2 12229.7   124.1634
      1894 572.10  1810.0 10119.4 12084.2   123.6457
      1895 572.30  1858.7 10356.6 12390.2   123.9312
      1896 572.49  1998.0 10597.4 12622.5   123.5485
      1897 572.69  1912.0 10570.8 12602.4   123.4626
      1898 572.88  2008.6 10839.5 12926.8   123.6364
      1899 573.08  1823.1 10597.8 12655.2   123.4468
      1900 573.28  2008.6 10921.4 13080.4   124.2233
      1901 573.47  1880.4 10982.0 13107.4   123.3518
      1902 573.67  1799.8 10896.4 13094.3   124.1614
      1903 573.87  1896.4 11136.0 13313.0   123.5615
      1904 574.06  1869.8 11309.3 13351.9   121.6393
      1905 574.26  1914.0 11430.9 13898.3   125.9264
      1906 574.45  1871.0 11507.1 13898.7   124.8193
      1907 574.65  1849.7 11684.9 13918.0   122.7053
      1908 574.85  1966.9 11971.6 14194.1   122.2140
      1909 575.04  1876.3 11993.7 14176.4   121.5740
      1910 575.24  1929.6 12085.5 14501.7   123.7911
      1911 575.44  1855.1 12009.3 14557.4   125.0938
      1912 575.63  1894.8 12252.2 14756.4   124.1784
      1913 575.83  1809.2 12187.5 14575.8   123.0129
      1914 576.02  1839.1 12323.0 14700.3   122.6754
      1915 576.22  1850.5 12356.6 14822.4   123.4698
      1916 576.42  1935.3 12549.5 14930.5   122.4319
      1917 576.61  1849.3 12587.2 15011.2   122.5740
      1918 576.81  1822.7 12524.6 15030.5   123.4155
      1919 577.00  1939.0 12607.3 15141.0   123.7503
      1920 577.20  1912.0 12603.6 15200.4   124.2884
      1921 577.40  1871.8 12694.1 15299.1   124.0709
      1922 577.59  1818.6 12740.0 15227.5   122.7760
      1923 577.79  1893.6 12878.4 15458.1   123.4834
      1924 577.98  1875.5 13031.6 15762.0   124.4741
      1925 578.18  1848.1 13141.4 15775.9   123.3280
      1926 578.37  1938.2 13291.7 16057.7   124.3624
      1927 578.57  1802.2 13336.4 15991.8   123.0220
      1928 578.77  1787.9 13391.7 16149.5   123.7663
      1929 578.96  1765.8 13330.2 16064.3   123.6417
      1930 579.16  1797.7 13600.2 16353.4   123.3281
      1931 579.35  1855.9 13606.3 16301.0   122.9329
      1932 579.55  1839.1 13822.6 16530.8   122.5997
      1933 579.75  1821.1 13641.5 16576.7   124.8311
      1934 579.94  1916.9 14078.6 16928.5   123.4339
      1935 580.14  1870.2 13868.0 16655.7   123.2350
      1936 580.33  1988.6 14064.6 16939.2   123.8035
      1937 580.53  1841.5 13771.0 16651.6   124.1476
      1938 580.72  1939.0 13853.7 16649.2   123.4625
      1939 580.92  1928.0 13873.3 16795.4   124.4617
      1940 581.12  1864.5 13627.6 16348.1   123.1275
      1941 581.31  1875.1 13757.8 16499.3   123.0706
      1942 581.51  1983.3 13764.0 16439.9   122.7140
      1943 581.70  1820.6 13655.4 16411.2   123.2851
      1944 581.90  2143.0 13783.2 16494.7   123.2943
      1945 582.09  1830.1 13433.0 16174.9   123.6303
      1946 582.29  1783.8 13281.9 16028.2   123.8850
      1947 582.48  1858.7 13200.8 15886.5   123.6792
      1948 582.68  1909.9 13301.6 16010.2   123.7775
      1949 582.88  1982.4 12990.7 15635.8   124.0289
      1950 583.07  1793.2 12767.0 15303.2   123.1114
      1951 583.27  1810.0 12581.5 15070.6   123.1082
      1952 583.46  1913.6 12622.5 15139.4   123.5035
      1953 583.66  1990.2 12539.7 14910.4   122.4724
      1954 583.85  1871.4 12350.5 14893.6   124.2691
      1955 584.05  1960.7 12320.6 14797.4   123.9078
      1956 584.24  2023.8 12291.5 14853.5   124.9521
      1957 584.44  1925.5 12341.9 14617.6   121.8474
      1958 584.63  1866.5 12224.3 14580.7   122.7499
      1959 584.83  1869.4 12120.7 14620.4   124.3847
      1960 585.03  1903.8 12176.8 14586.9   123.4600
      1961 585.22  1837.8 12066.6 14435.7   123.1610
      1962 585.42  1756.7 11891.7 14265.7   123.4239
      1963 585.61  1889.5 11906.1 14228.1   123.1814
      1964 585.81  1840.7 11851.2 14169.1   123.1547
      1965 586.00  1874.3 11651.3 13837.7   122.3628
      1966 586.20  1902.6 11585.8 13890.1   123.7976
      1967 586.39  1913.6 11438.3 13670.6   123.4368
      1968 586.59  1830.9 11218.8 13453.1   123.8002
      1969 586.78  1827.2 10950.5 13113.1   123.7048
      1970 586.98  1941.9 11057.0 13010.3   121.4299
      1971 587.17  1890.3 10749.8 12770.3   122.8063
      1972 587.37  1922.6 10712.1 12646.6   122.0094
      1973 587.56  1978.3 10642.9 12533.2   121.8162
      1974 587.76  1939.8 10361.9 12318.5   123.2322
      1975 587.95  1909.5 10263.6 12133.4   122.3818
      1976 588.15  1853.0 10076.0 11863.1   121.7324
      1977 588.34  1904.6 10035.9 11813.1   121.8567
      1978 588.54  1839.5  9726.2 11548.5   123.1057
      1979 588.74  1898.9  9618.5 11453.5   123.7704
      1980 588.93  1773.5  9430.9 11137.3   122.2840
      1981 589.13  1907.9  9395.3 11077.9   122.4726
      1982 589.32  1858.3  9281.0 10932.1   122.2437
      1983 589.52  1799.8  9092.6 10639.6   121.2131
      1984 589.71  1929.6  9224.5 10924.3   123.3015
      1985 589.91  1915.3  9098.7 10801.4   123.7028
      1986 590.10  1786.6  8998.4 10770.3   124.5698
      1987 590.30  1880.4  9121.2 10752.2   122.5252
      1988 590.49  1851.8  9161.0 10743.2   121.6475
      1989 590.69  1947.6  9072.1 10810.4   124.3992
      1990 590.88  1814.1  8996.7 10773.5   124.7377
      1991 591.08  1795.2  9093.8 10717.0   122.2403
      1992 591.27  1896.8  9163.8 10920.2   124.1686
      1993 591.47  1789.1  9094.2 10811.6   123.5100
      1994 591.66  1826.0  9146.2 10797.3   122.5548
      1995 591.85  1836.2  9276.9 10965.2   122.6907
      1996 592.05  1930.8  9342.0 11109.8   123.8532
      1997 592.24  2023.4  9298.6 11052.1   124.1020
      1998 592.44  1940.2  9334.2 11150.4   124.5624
      1999 592.63  1751.0  9162.6 10943.5   124.0287
      2000 592.83  1883.3  9435.0 11208.9   123.4908
      2001 593.02  1863.7  9403.9 11033.2   121.6090
      2002 593.22  1834.6  9389.5 11135.6   123.1120
      2003 593.41  1802.2  9247.8 11029.5   123.9300
      2004 593.61  1833.8  9275.7 11004.1   123.2264
      2005 593.80  2112.3  9469.0 11099.6   122.1647
      2006 594.00  1797.3  9123.3 10774.4   122.5372
      2007 594.19  1794.4  9033.2 10751.4   123.7368
      2008 594.39  1878.8  9074.5 10637.6   121.7213
      2009 594.58  1806.7  8911.9 10610.1   123.9004
      2010 594.78  1851.8  8874.7 10506.1   123.2299
      2011 594.97  1923.5  8768.2 10472.5   124.8998
      2012 595.17  1860.4  8789.5 10459.0   124.0941
      2013 595.36  1915.7  8805.0 10386.1   122.9489
      2014 595.56  1887.4  8754.7 10378.3   123.6431
      2015 595.75  1941.1  8839.4 10391.8   122.5033
      2016 595.94  1916.1  8816.5 10441.8   123.5532
      2017 596.14  1946.0  8755.9 10328.7   123.0964
      2018 596.33  1891.9  8683.4 10309.9   123.9491
      2019 596.53  1772.7  8659.6 10296.4   123.7659
      2020 596.72  1867.3  8761.6 10392.2   123.6514
      2021 596.92  1852.6  8770.6 10353.3   122.8774
      2022 597.11  1816.5  8698.5 10324.6   123.6281
      2023 597.31  1817.8  8848.0 10442.6   122.6812
      2024 597.50  1887.0  8907.0 10568.3   123.6653
      2025 597.69  1982.8  8958.6 10669.9   124.5317
      2026 597.89  1936.6  8960.3 10588.4   123.1805
      2027 598.08  1784.6  8778.8 10445.9   123.8346
      2028 598.28  1898.1  9155.2 10783.0   122.4292
      2029 598.47  1896.0  8959.0 10614.2   123.4342
      2030 598.67  1856.3  9028.7 10769.9   124.2762
      2031 598.86  1878.0  9066.8 10684.7   122.5058
      2032 599.06  1958.3  9108.1 10779.7   123.3788
      2033 599.25  1861.6  8975.8 10610.9   122.9835
      2034 599.44  1874.3  9019.7 10681.8   123.2617
      2035 599.64  1870.6  9012.3 10762.1   124.5010
      2036 599.83  1883.3  9101.2 10694.5   122.0747
      2037 600.03  1862.0  9053.7 10694.1   122.8101
      2038 600.22  1899.7  9084.4 10831.7   124.3202
      2039 600.42  1859.6  8994.3 10685.1   123.6983
      2040 600.61  1840.3  8954.1 10703.1   124.5854
      2041 600.80  1839.1  8992.6 10721.5   124.1683
      2042 601.00  1914.9  9063.5 10741.6   123.4745
      2043 601.19  1835.0  8954.1 10632.6   123.5775
      2044 601.39  1976.3  9020.9 10632.2   122.8734
      2045 601.58  1860.8  8899.2 10511.8   122.9108
      2046 601.78  1909.9  8992.6 10552.0   122.0160
      2047 601.97  1847.3  8805.9 10465.5   123.8507
      2048 602.16  1859.6  8855.4 10455.3   122.8689
      2049 602.36  1835.8  8742.8 10309.1   122.6769
      2050 602.55  1887.4  8885.3 10459.0   122.4876
      2051 602.75  1886.2  8771.0 10404.9   123.7313
      2052 602.94  1941.1  8812.8 10392.6   122.9898
      2053 603.13  1946.8  8837.8 10483.6   123.8825
      2054 603.33  1767.4  8667.4 10291.9   123.5427
      2055 603.52  1863.7  8739.1 10344.7   123.3528
      2056 603.72  1920.6  8792.3 10426.2   123.7766
      2057 603.91  1823.1  8590.4 10241.5   124.3978
      2058 604.10  1871.0  8735.8 10284.9   122.5656
      2059 604.30  1879.6  8601.5 10320.5   125.5743
      2060 604.49  1918.1  8642.0 10157.1   122.5329
      2061 604.69  1882.9  8539.2 10083.4   123.1986
      2062 604.88  1869.4  8502.3 10070.3   123.6384
      2063 605.07  1855.5  8447.9 10001.5   123.5663
      2064 605.27  1873.5  8441.3  9982.6   123.4674
      2065 605.46  1783.4  8362.3  9890.5   123.2287
      2066 605.66  1891.1  8406.5  9855.2   122.2355
      2067 605.85  1866.5  8321.7  9743.4   122.0241
      2068 606.04  1896.4  8397.9  9898.7   123.0832
      2069 606.24  1948.4  8362.3  9794.2   122.3258
      2070 606.43  1805.5  8184.1  9653.3   123.0335
      2071 606.62  1835.8  8087.8  9591.0   124.0435
      2072 606.82  1847.3  8089.5  9639.0   124.8228
      2073 607.01  1898.1  8096.4  9628.7   124.7208
      2074 607.21  1812.5  7992.0  9418.6   123.0861
      2075 607.40  1979.2  8066.9  9457.5   122.8420
      2076 607.59  1884.5  7976.8  9380.1   123.0335
      2077 607.79  1812.9  7883.0  9307.6   123.4683
      2078 607.98  1940.7  8059.2  9421.1   122.2587
      2079 608.17  1808.8  7832.7  9189.2   122.5199
      2080 608.37  1871.0  7919.5  9226.1   121.6022
      2081 608.56  2028.3  7917.0  9349.4   124.3236
      2082 608.76  1781.3  7703.2  9000.0   121.8979
      2083 608.95  1794.4  7625.4  8966.4   122.9980
      2084 609.14  1957.0  7864.2  9041.8   119.9348
      2085 609.34  1880.9  7605.3  8940.6   123.3257
      2086 609.53  1839.9  7649.2  8864.8   120.9265
      2087 609.72  1821.9  7447.6  8849.3   124.9145
      2088 609.92  1850.1  7640.2  8874.3   121.3144
      2089 610.11  1878.0  7601.2  8897.2   122.6437
      2090 610.30  1873.9  7678.7  8883.7   120.7592
      2091 610.50  1823.1  7493.5  8686.7   121.0416
      2092 610.69  1778.0  7372.3  8660.5   123.0268
      2093 610.88  1919.4  7524.2  8772.3   122.2669
      2094 611.08  1824.3  7383.7  8584.3   121.5943
      2095 611.27  1783.0  7328.5  8510.9   121.3236
      2096 611.46  1926.3  7477.5  8760.8   123.1167
      2097 611.66  1828.4  7330.9  8510.1   121.4307
      2098 611.85  1798.9  7308.4  8535.9   122.2809
      2099 612.04  1908.7  7416.1  8568.3   120.9207
      2100 612.24  1950.9  7357.5  8633.4   123.5985
      2101 612.43  1835.4  7278.9  8574.0   123.7923
      2102 612.62  1859.1  7297.3  8457.7   121.3377
      2103 612.82  1866.5  7273.2  8462.2   121.9924
      2104 613.01  1834.2  7371.9  8624.8   122.6257
      2105 613.20  1867.7  7360.4  8433.9   119.5451
      2106 613.40  1855.9  7269.9  8451.1   121.8187
      2107 613.59  1817.8  7242.8  8327.5   119.9924
      2108 613.78  1853.4  7306.3  8450.7   120.9870
      2109 613.98  1764.5  7072.5  8292.6   122.9879
      2110 614.17  1785.0  7124.9  8289.8   121.8148
      2111 614.36  1893.1  7236.7  8390.9   121.6005
      2112 614.56  2198.3  7500.5  8672.3   122.1012
      2113 614.75  1832.9  7067.1  8286.1   123.2882
      2114 614.94  1804.3  6958.2  8303.7   126.1067
      2115 615.14  1794.4  6990.5  8253.7   124.3103
      2116 615.33  1973.8  7147.0  8344.2   123.1433
      2117 615.52  1932.5  7100.7  8186.6   121.0097
      2118 615.72  1852.2  7061.0  8204.6   121.9549
      2119 615.91  1890.3  6982.3  8044.4   120.8575
      2120 616.10  1898.1  6990.9  8098.1   121.7388
      2121 616.30  1896.4  6924.2  7985.4   121.1079
      2122 616.49  1893.6  6949.2  7957.2   119.9384
      2123 616.68  1871.4  6757.1  7923.2   123.8682
      2124 616.88  2023.4  6879.5  7917.4   121.3731
      2125 617.07  1978.3  6867.7  7897.8   121.0689
      2126 617.26  1839.5  6653.0  7728.2   122.3366
      2127 617.45  1889.0  6707.9  7731.5   121.2410
      2128 617.65  2036.5  6804.6  7942.0   123.8553
      2129 617.84  1792.8  6509.7  7580.8   122.7075
      2130 618.03  1897.2  6606.3  7666.4   122.5102
      2131 618.23  1896.4  6601.0  7636.5   122.0094
      2132 618.42  1893.1  6498.2  7586.5   123.6325
      2133 618.61  1837.0  6417.9  7466.9   122.8988
      2134 618.80  1814.5  6474.4  7507.9   122.1763
      2135 619.00  1839.9  6344.2  7401.8   123.4791
      2136 619.19  1922.2  6450.7  7539.0   124.0322
      2137 619.38  1912.8  6431.9  7419.4   121.8526
      2138 619.58  1885.4  6378.6  7379.7   122.2789
      2139 619.77  1885.0  6438.4  7429.2   121.7595
      2140 619.96  1938.2  6460.9  7450.9   121.8892
      2141 620.15  1826.4  6374.1  7347.7   121.4086
      2142 620.35  1841.9  6319.6  7413.6   124.4329
      2143 620.54  1807.5  6394.6  7376.8   121.4126
      2144 620.73  1832.5  6377.0  7407.9   122.6859
      2145 620.93  1902.6  6424.5  7412.4   121.8478
      2146 621.12  1855.5  6397.0  7355.5   121.1039
      2147 621.31  1896.0  6463.4  7411.2   120.7515
      2148 621.50  1819.8  6375.3  7339.1   121.1563
      2149 621.70  2030.4  6628.0  7634.4   121.8886
      2150 621.89  1808.8  6359.8  7367.0   122.1312
      2151 622.08  1690.0  6319.6  7285.4   120.8617
      2152 622.27  1914.0  6491.7  7533.7   122.7631
      2153 622.47  1986.5  6555.5  7589.8   122.6356
      2154 622.66  1805.9  6365.9  7480.0   124.4319
      2155 622.85  1873.9  6501.1  7496.4   121.5101
      2156 623.04  1884.1  6431.0  7491.9   123.3312
      2157 623.24  1830.9  6439.2  7430.0   121.5003
      2158 623.43  1860.0  6416.7  7399.3   121.5640
      2159 623.62  1859.1  6414.6  7400.9   121.6508
      2160 623.81  1880.9  6455.6  7446.0   121.6492
      2161 624.01  1930.0  6398.7  7378.8   121.9340
      2162 624.20  1872.3  6379.8  7293.2   120.2635
      2163 624.39  1910.8  6313.5  7356.7   123.6952
      2164 624.58  1851.4  6266.8  7206.0   121.2709
      2165 624.78  1910.3  6343.4  7288.7   121.3250
      2166 624.97  1835.4  6221.7  7173.6   121.7014
      2167 625.16  1840.7  6109.5  7079.8   122.7308
      2168 625.35  1881.7  6150.5  7104.0   122.3374
      2169 625.55  1911.2  6216.8  7160.9   121.9273
      2170 625.74  1885.8  6073.5  6987.3   121.8212
      2171 625.93  1910.8  6069.0  6947.5   121.1288
      2172 626.12  1838.7  5929.3  6917.6   124.1614
      2173 626.32  1784.2  5946.9  6823.0   121.0469
      2174 626.51  1850.1  5919.0  6816.9   122.0656
      2175 626.70  1833.3  5910.0  6801.7   121.8728
      2176 626.89  1845.2  5839.6  6760.8   123.0619
      2177 627.09  1873.9  5847.4  6746.4   122.6265
      2178 627.28  1765.8  5702.8  6591.2   122.5655
      2179 627.47  1860.0  5831.0  6678.8   121.3512
      2180 627.66  1994.3  5860.1  6782.5   123.8610
      2181 627.85  1883.3  5788.8  6555.1   119.6224
      2182 628.05  1925.1  5767.5  6610.8   121.9486
      2183 628.24  1828.0  5710.1  6499.0   120.3207
      2184 628.43  1912.8  5750.7  6635.4   123.0523
      2185 628.62  1972.2  5680.7  6524.4   122.7524
      2186 628.82  1791.6  5516.0  6332.3   121.9180
      2187 629.01  1973.8  5622.1  6534.7   125.0140
      2188 629.20  1927.5  5550.4  6383.1   122.9847
      2189 629.39  1930.8  5592.2  6354.0   120.8077
      2190 629.58  1800.6  5506.2  6307.3   121.6204
      2191 629.78  1888.6  5498.4  6334.4   123.1590
      2192 629.97  1869.4  5445.1  6266.0   122.9553
      2193 630.16  1866.1  5383.7  6217.2   123.6959
      2194 630.35  1893.1  5403.4  6218.9   123.2322
      2195 630.54  1905.0  5396.0  6176.7   122.3630
      2196 630.74  1834.2  5293.2  6042.7   121.6696
      2197 630.93  1829.2  5346.8  6006.3   118.7471
      2198 631.12  1876.8  5297.3  6131.2   124.3803
      2199 631.31  1780.5  5191.2  5867.8   119.8391
      2200 631.50  1894.8  5286.2  6044.8   122.3671
      2201 631.70  1991.9  5322.7  6056.3   122.0241
      2202 631.89  1844.8  5156.8  5952.6   124.0292
      2203 632.08  1861.2  5165.8  5907.6   122.4467
      2204 632.27  1783.4  5044.1  5824.4   123.9292
      2205 632.46  1951.7  5199.0  5986.2   124.2432
      2206 632.65  1876.8  5178.5  5879.3   121.2257
      2207 632.85  1777.6  5027.4  5785.5   123.3300
      2208 633.04  1867.7  5130.6  5771.2   119.6334
      2209 633.23  1946.8  5185.9  5879.3   121.4087
      2210 633.42  1821.9  5052.3  5824.4   123.9001
      2211 633.61  1849.3  5161.3  5796.6   119.1813
      2212 633.81  1888.2  5130.6  5801.9   120.7049
      2213 634.00  1874.3  5119.1  5756.4   119.6415
      2214 634.19  1847.7  5089.2  5840.4   123.1741
      2215 634.38  1890.7  5086.3  5804.8   122.4814
      2216 634.57  1855.1  5013.4  5751.1   123.3562
      2217 634.76  1799.3  5014.7  5733.9   122.3694
      2218 634.96  1818.6  5017.5  5679.0   120.6786
      2219 635.15  1914.4  5058.5  5768.3   122.5769
      2220 635.34  1933.3  5149.8  5814.2   120.6545
      2221 635.53  1940.7  5083.5  5832.6   123.8368
      2222 635.72  1937.4  5064.6  5773.2   122.6588
      2223 635.91  1787.5  5003.2  5665.9   120.6088
      2224 636.11  1924.7  5107.2  5788.4   121.4028
      2225 636.30  1937.0  5098.6  5822.8   122.9045
      2226 636.49  1980.4  5130.2  5815.0   121.7425
      2227 636.68  1801.8  4950.8  5648.3   122.1514
      2228 636.87  1783.0  4905.7  5673.7   124.5934
      2229 637.06  2061.1  5145.3  5880.1   123.8247
      2230 637.26  1854.6  4992.5  5647.9   120.8850
      2231 637.45  1830.5  4911.8  5654.9   124.1127
      2232 637.64  1831.7  4949.5  5670.0   123.1083
      2233 637.83  1848.5  4913.5  5671.6   124.7361
      2234 638.02  1767.4  4902.8  5493.9   118.8504
      2235 638.21  1947.2  4995.4  5700.3   123.1255
      2236 638.40  1993.5  5058.5  5666.7   119.8450
      2237 638.60  2002.5  5007.7  5687.6   122.6251
      2238 638.79  1905.0  4905.3  5567.6   122.0751
      2239 638.98  1891.9  4889.3  5532.0   121.4403
      2240 639.17  1887.8  4875.0  5563.1   123.0358
      2241 639.36  1790.3  4820.1  5468.1   121.3870
      2242 639.55  1835.4  4833.6  5448.0   120.4918
      2243 639.74  1787.5  4786.5  5406.2   120.6638
      2244 639.93  1832.5  4799.6  5478.7   122.8879
      2245 640.13  1892.7  4833.6  5433.7   120.4039
      2246 640.32  1846.4  4774.6  5479.5   124.0733
      2247 640.51  1888.2  4721.0  5438.2   125.3181
      2248 640.70  1966.0  4854.1  5437.8   120.2099
      2249 640.89  1882.1  4765.2  5363.2   120.7416
      2250 641.08  1893.6  4750.1  5320.2   119.9599
      2251 641.27  1821.5  4650.9  5296.9   122.8286
      2252 641.46  1932.9  4775.0  5373.1   121.0405
      2253 641.66  1946.0  4759.5  5428.8   123.7880
      2254 641.85  1839.9  4709.9  5294.0   120.3511
      2255 642.04  1803.0  4551.8  5214.9   124.1246
      2256 642.23  1977.9  4755.4  5340.7   121.0736
      2257 642.42  1842.4  4611.2  5287.9   124.4379
      2258 642.61  1832.9  4633.3  5220.7   120.9741
      2259 642.80  1842.4  4613.3  5193.2   120.9313
      2260 642.99  1819.8  4575.6  5290.3   125.9364
      2261 643.18  1952.9  4748.8  5338.2   121.0812
      2262 643.38  1971.4  4714.8  5334.5   122.5888
      2263 643.57  1816.1  4598.9  5197.3   121.5043
      2264 643.76  1808.8  4503.9  5194.9   125.6383
      2265 643.95  1968.1  4727.5  5287.9   120.3058
      2266 644.14  1957.0  4714.4  5312.0   121.6726
      2267 644.33  1932.1  4680.4  5266.1   121.3115
      2268 644.52  1998.8  4680.0  5300.1   123.1286
      2269 644.71  1871.0  4561.6  5194.9   123.5348
      2270 644.90  1788.3  4532.2  5123.6   121.5555
      2271 645.09  1797.7  4537.5  5109.3   120.8701
      2272 645.29  1908.3  4618.6  5192.0   121.1576
      2273 645.48  1872.3  4524.0  5182.2   124.8224
      2274 645.67  1880.9  4610.0  5230.9   122.7525
      2275 645.86  1855.5  4635.4  5251.4   122.1600
      2276 646.05  1903.8  4657.1  5286.2   122.8503
      2277 646.24  1992.7  4757.8  5396.8   123.1077
      2278 646.43  1739.5  4518.2  5103.1   121.0495
      2279 646.62  1849.3  4634.1  5231.3   121.4443
      2280 646.81  1842.8  4667.3  5264.5   121.1427
      2281 647.00  1869.4  4664.5  5327.6   123.7251
      2282 647.19  1847.7  4642.3  5203.5   120.0791
      2283 647.38  1827.6  4631.7  5285.8   123.3275
      2284 647.57  1877.2  4701.3  5305.5   121.3923
      2285 647.77  1945.2  4767.3  5371.8   121.4224
      2286 647.96  1853.8  4674.7  5286.6   121.6930
      2287 648.15  1803.9  4649.7  5254.3   121.2435
      2288 648.34  1904.6  4777.9  5454.2   123.5353
      2289 648.53  1974.7  4830.3  5421.8   120.7114
      2290 648.72  1896.8  4733.7  5403.8   123.6211
      2291 648.91  1927.1  4781.6  5400.9   121.6961
      2292 649.10  1946.0  4836.5  5382.5   118.8890
      2293 649.29  1755.5  4639.1  5249.4   121.1648
      2294 649.48  1854.6  4700.9  5341.5   122.5068
      2295 649.67  1855.5  4678.0  5365.7   124.3651
      2296 649.86  1997.6  4837.3  5518.0   123.9723
      2297 650.05  1791.6  4657.1  5234.2   120.1401
      2298 650.24  1794.8  4717.7  5366.1   122.1833
      2299 650.43  1941.5  4852.5  5412.8   119.2486
      2300 650.62  1864.9  4738.6  5375.9   122.1779
      2301 650.81  2009.1  4834.0  5501.3   123.6190
      2302 651.01  1848.9  4721.0  5394.3   123.4455
      2303 651.20  1860.4  4740.2  5383.7   122.3439
      2304 651.39  1900.1  4818.9  5405.8   120.1095
      2305 651.58  1966.0  4886.0  5551.6   122.7942
      2306 651.77  1807.9  4773.0  5348.5   119.4088
      2307 651.96  1894.4  5031.4  5778.1   123.8021
      2308 652.15  1881.7  5713.0  6642.0   124.2463
      2309 652.34  1870.2  6707.9  7846.6   123.5374
      2310 652.53  1942.3  8211.9  9720.1   124.0544
      2311 652.72  1814.9  9695.5 11741.4   125.9615
      2312 652.91  1926.3 11818.0 14072.4   122.7909
      2313 653.10  1927.5 13553.0 16185.1   122.6403
      2314 653.29  1884.5 15347.1 18470.2   123.1989
      2315 653.48  1803.0 17269.3 20896.2   123.4507
      2316 653.67  1937.4 19148.1 23244.0   123.7988
      2317 653.86  1833.3 20807.8 25058.5   122.4026
      2318 654.05  1812.5 22352.8 27130.7   123.2611
      2319 654.24  1845.2 23597.5 28652.7   123.2399
      2320 654.43  1845.6 25078.6 30164.9   121.8927
      2321 654.62  1862.8 25933.8 31294.2   122.2689
      2322 654.81  1906.2 26909.1 32636.4   122.9068
      2323 655.00  1840.7 27340.8 32819.9   121.4867
      2324 655.19  1883.7 28091.6 34040.9   122.7006
      2325 655.38  1916.9 28278.4 34246.5   122.6398
      2326 655.57  1861.2 28832.1 34773.7   122.0295
      2327 655.76  2011.5 28871.4 34956.8   122.6558
      2328 655.95  1892.7 29037.3 35097.3   122.3247
      2329 656.14  1821.1 28809.2 34770.8   122.0898
      2330 656.33  1793.6 28604.8 34505.8   122.0095
      2331 656.52  1902.2 27673.0 33636.7   123.1412
      2332 656.71  1787.5 26390.5 31818.5   122.0620
      2333 656.90  1892.7 24705.5 29686.1   121.8328
      2334 657.09  1898.5 22922.9 27410.4   121.3442
      2335 657.28  1866.5 20800.0 24968.0   122.0141
      2336 657.47  1919.8 18793.8 22409.7   121.4287
      2337 657.66  1903.0 17346.3 20640.7   121.3320
      2338 657.85  1838.7 15570.3 18431.3   120.8352
      2339 658.04  1851.4 14544.3 17095.6   120.1007
      2340 658.23  1828.0 13310.2 15723.9   121.0217
      2341 658.42  1922.2 12588.0 14925.2   121.9124
      2342 658.61  1803.0 11715.6 13818.1   121.2099
      2343 658.80  1810.4 10986.5 12883.0   120.6669
      2344 658.99  1861.6 10546.2 12337.0   120.6197
      2345 659.18  2069.7 10147.7 11945.0   122.2493
      2346 659.37  1789.9  9437.0 11074.2   121.4087
      2347 659.56  1902.2  9115.1 10520.8   119.4889
      2348 659.75  1857.9  8603.1 10050.6   121.4598
      2349 659.94  1863.7  8136.2  9553.8   122.6002
      2350 660.13  1783.8  7775.3  9029.5   120.9325
      2351 660.32  1878.0  7466.9  8642.8   121.0407
      2352 660.51  1884.5  7081.5  8239.8   122.2888
      2353 660.70  1873.9  6789.0  7790.5   120.3750
      2354 660.89  2010.7  6497.4  7532.0   123.0601
      2355 661.08  1838.7  6106.6  6971.3   120.2591
      2356 661.27  1921.4  5926.4  6792.7   121.6302
      2357 661.46  1900.9  5572.9  6360.2   121.4389
      2358 661.65  1814.9  5416.1  6084.1   118.5510
      2359 661.84  1939.4  5282.1  6036.6   122.5708
      2360 662.03  1864.5  5071.2  5790.0   122.4167
      2361 662.22  1914.4  5053.6  5706.9   120.8116
      2362 662.41  1863.7  4914.7  5492.2   118.9287
      2363 662.60  1797.3  4762.8  5371.8   120.5387
      2364 662.78  1852.2  4771.8  5325.1   118.9534
      2365 662.97  1930.0  4799.6  5418.9   121.5815
      2366 663.16  1860.4  4608.7  5314.5   125.6781
      2367 663.35  1831.3  4619.0  5232.2   121.9953
      2368 663.54  1852.2  4693.9  5292.4   121.0579
      2369 663.73  1949.3  4753.3  5320.6   120.2308
      2370 663.92  1822.3  4583.8  5178.1   121.5218
      2371 664.11  1847.7  4620.6  5190.0   120.5318
      2372 664.30  1855.9  4584.2  5258.0   124.6960
      2373 664.49  1948.4  4703.8  5280.1   120.9157
      2374 664.68  1804.7  4559.2  5167.0   122.0669
      2375 664.87  1892.7  4626.0  5246.1   122.6884
      2376 665.06  1878.8  4622.3  5185.0   120.5136
      2377 665.25  1869.0  4611.6  5207.2   121.7145
      2378 665.44  1921.4  4671.8  5274.3   121.9062
      2379 665.63  1881.7  4588.7  5164.6   121.2740
      2380 665.82  1907.5  4645.2  5194.1   120.0479
      2381 666.01  2051.2  4737.8  5384.1   124.0585
      2382 666.19  1810.4  4598.1  5167.8   120.4378
      2383 666.38  1961.1  4670.6  5309.6   123.5828
      2384 666.57  1982.8  4688.2  5284.2   122.0288
      2385 666.76  1833.8  4557.1  5160.1   122.1387
      2386 666.95  1930.8  4668.5  5236.2   120.7361
      2387 667.14  1861.2  4557.1  5116.6   120.7536
      2388 667.33  1826.0  4624.7  5208.4   120.8547
      2389 667.52  1965.6  4684.1  5298.9   122.6156
      2390 667.71  1805.5  4512.1  5190.8   125.0757
      2391 667.90  1912.8  4614.5  5190.8   121.3311
      2392 668.09  1957.9  4688.2  5320.6   123.1623
      2393 668.28  1822.7  4585.0  5210.0   122.6275
      2394 668.46  1828.0  4579.3  5173.6   121.6019
      2395 668.65  1955.4  4631.3  5308.7   125.3176
      2396 668.84  2011.9  4798.4  5329.6   119.0651
      2397 669.03  1817.0  4612.4  5203.9   121.1575
      2398 669.22  1760.4  4544.0  5161.7   122.1895
      2399 669.41  1925.5  4731.2  5388.6   123.4307
      2400 669.60  1979.2  4856.6  5484.1   121.8078
      2401 669.79  1821.9  4612.0  5278.4   123.8843
      2402 669.98  1902.6  4754.2  5292.0   118.8595
      2403 670.17  1800.6  4645.2  5362.0   125.1980
      2404 670.35  1914.9  4798.0  5428.8   121.8781
      2405 670.54  1847.7  4740.2  5416.5   123.3786
      2406 670.73  1813.7  4730.4  5346.4   121.1206
      2407 670.92  1941.1  4816.8  5495.1   123.5864
      2408 671.11  1905.8  4811.1  5451.7   122.0499
      2409 671.30  1769.4  4669.0  5294.4   121.5708
      2410 671.49  1827.6  4750.1  5368.1   121.1493
      2411 671.68  1817.8  4710.3  5407.0   124.0867
      2412 671.87  1914.4  4883.2  5509.4   121.0955
      2413 672.05  1968.9  4785.3  5535.2   126.6289
      2414 672.24  1782.6  4745.1  5383.7   121.5540
      2415 672.43  1919.8  4872.5  5464.8   120.0583
      2416 672.62  1848.9  4763.2  5400.5   121.8693
      2417 672.81  1972.2  4870.9  5550.0   123.4280
      2418 673.00  1913.6  4786.5  5466.8   123.6812
      2419 673.19  1787.9  4689.0  5355.8   122.9846
      2420 673.38  1824.7  4776.3  5397.2   121.0380
      2421 673.57  1816.5  4698.9  5327.2   121.7991
      2422 673.75  1980.4  4822.1  5537.7   125.1802
      2423 673.94  1904.6  4747.2  5369.8   121.9020
      2424 674.13  1873.9  4719.3  5350.9   122.1966
      2425 674.32  1860.0  4653.4  5297.7   123.0645
      2426 674.51  1891.5  4755.0  5307.9   119.3105
      2427 674.70  1882.9  4774.2  5378.4   120.8953
      2428 674.89  1730.9  4578.4  5253.4   123.7054
      2429 675.07  1912.8  4769.3  5372.2   121.1070
      2430 675.26  2037.3  4862.7  5484.1   121.9919
      2431 675.45  1848.5  4737.8  5347.7   121.1086
      2432 675.64  1908.7  4786.5  5432.0   122.4310
      2433 675.83  1904.6  4777.5  5440.2   123.0681
      2434 676.02  1956.6  4828.3  5449.6   121.6374
      2435 676.21  1962.0  4848.8  5488.6   122.1623
      2436 676.39  1894.8  4805.4  5464.0   122.6288
      2437 676.58  1792.8  4715.7  5333.7   121.1463
      2438 676.77  1742.8  4660.8  5306.7   122.1364
      2439 676.96  1887.0  4770.5  5452.9   123.6648
      2440 677.15  1889.0  4821.7  5518.5   123.7570
      2441 677.34  1959.9  4887.3  5593.0   124.1080
      2442 677.52  1926.3  4874.6  5576.6   123.8122
      2443 677.71  1823.9  4762.3  5480.8   124.4494
      2444 677.90  1846.9  4845.5  5478.3   121.1037
      2445 678.09  1935.3  4875.8  5582.4   124.0284
      2446 678.28  1859.1  4864.7  5562.7   123.2216
      2447 678.47  1995.5  4997.9  5640.5   121.4052
      2448 678.65  1879.6  4938.9  5612.3   122.0110
      2449 678.84  2000.9  5003.6  5660.2   121.8660
      2450 679.03  1791.2  4840.6  5472.6   120.7253
      2451 679.22  1843.2  4909.4  5584.0   122.0011
      2452 679.41  1845.6  4856.6  5511.9   121.7657
      2453 679.60  1842.8  4848.4  5568.4   123.9575
      2454 679.78  1922.6  4952.4  5642.2   122.7660
      2455 679.97  1838.3  4865.6  5525.4   121.7968
      2456 680.16  1928.8  4998.7  5655.7   121.4009
      2457 680.35  1919.8  4883.6  5668.8   126.4925
      2458 680.54  1963.6  4954.9  5615.5   122.0868
      2459 680.73  1850.5  4782.4  5510.3   124.8254
      2460 680.91  1858.7  4884.8  5562.3   122.3877
      2461 681.10  1905.8  4932.3  5590.5   121.7485
      2462 681.29  1891.9  4843.9  5514.4   122.7140
      2463 681.48  1868.6  4879.5  5502.9   120.7047
      2464 681.67  1936.6  4934.0  5590.5   121.9049
      2465 681.85  1841.1  4822.6  5491.0   122.4207
      2466 682.04  1848.9  4895.9  5547.1   121.3738
      2467 682.23  1878.8  4895.5  5548.8   121.6565
      2468 682.42  1829.2  4848.4  5570.5   123.9181
      2469 682.61  1788.3  4876.6  5498.8   120.1459
      2470 682.79  1909.9  4961.4  5635.6   122.0940
      2471 682.98  1908.7  4972.5  5635.2   121.6310
      2472 683.17  1892.3  4943.8  5670.8   123.8255
      2473 683.36  1817.4  4942.2  5667.5   123.2141
      2474 683.55  1885.8  4958.1  5693.8   123.9435
      2475 683.73  1907.9  5102.7  5815.4   122.3077
      2476 683.92  1851.0  4967.1  5745.8   124.9869
      2477 684.11  1890.3  5070.8  5824.0   123.6832
      2478 684.30  1864.1  5042.9  5813.8   124.2495
      2479 684.49  1903.8  5073.2  5763.0   121.7627
      2480 684.67  1827.2  5022.4  5772.4   123.4713
      2481 684.86  1828.0  5074.0  5751.1   120.8580
      2482 685.05  1885.4  5090.8  5748.6   120.5213
      2483 685.24  1895.2  5101.1  5805.6   121.9752
      2484 685.42  1986.9  5191.6  5925.2   122.8911
      2485 685.61  1834.6  5065.0  5707.7   119.8935
      2486 685.80  1865.7  4997.5  5797.4   125.5428
      2487 685.99  1992.3  5196.9  5950.2   123.5046
      2488 686.18  1880.0  5017.9  5758.9   123.6131
      2489 686.36  1844.4  4992.1  5682.7   121.9388
      2490 686.55  1909.1  5043.7  5759.3   122.8276
      2491 686.74  1923.0  5069.1  5759.7   121.9503
      2492 686.93  1864.5  5025.3  5675.7   120.5779
      2493 687.11  1932.5  5052.7  5708.1   121.0029
      2494 687.30  1754.7  4893.8  5635.6   123.6300
      2495 687.49  1797.7  4922.5  5560.6   120.4221
      2496 687.68  1920.6  4995.4  5650.8   121.3134
      2497 687.86  1914.0  4917.2  5652.0   124.4681
      2498 688.05  1883.7  4929.1  5701.5   125.3665
      2499 688.24  1873.1  4920.0  5596.7   122.2073
      2500 688.43  2007.0  5074.5  5781.8   123.0605
      2501 688.61  1859.6  4942.6  5644.2   122.7581
      2502 688.80  1851.8  4917.6  5640.5   123.5805
      2503 688.99  1816.1  4890.1  5592.6   122.8514
      2504 689.18  1970.6  5015.9  5671.6   121.5333
      2505 689.36  1914.9  5010.2  5621.3   119.7433
      2506 689.55  1819.0  4864.7  5555.3   122.6735
      2507 689.74  1799.8  4844.3  5478.3   120.8260
      2508 689.93  1910.8  5018.3  5613.1   119.1380
      2509 690.11  1888.2  4930.7  5650.3   123.6537
      2510 690.30  1868.2  4977.8  5657.7   121.8651
      2511 690.49  1834.6  4950.4  5580.3   120.2182
      2512 690.68  2017.7  5083.5  5782.2   122.7923
      2513 690.86  1823.9  4857.0  5572.9   123.6057
      2514 691.05  1758.0  4847.5  5540.2   122.4181
      2515 691.24  1792.8  4920.4  5534.4   119.6307
      2516 691.43  1871.0  4882.4  5638.1   125.0952
      2517 691.61  1978.7  5062.6  5692.9   120.4410
      2518 691.80  1829.7  4852.0  5650.8   126.4263
      2519 691.99  1867.7  4953.6  5559.8   119.6443
      2520 692.17  1912.8  4919.2  5633.1   123.7466
      2521 692.36  1882.5  4857.0  5564.7   123.7951
      2522 692.55  1936.6  5023.3  5655.7   120.4883
      2523 692.74  1850.1  4836.1  5550.0   123.9095
      2524 692.92  1833.3  4845.9  5483.6   121.1693
      2525 693.11  1850.1  4856.1  5501.3   121.4607
      2526 693.30  1961.5  4946.3  5626.2   122.7803
      2527 693.49  1774.0  4782.8  5495.9   123.7000
      2528 693.67  1846.9  4837.7  5501.3   122.1857
      2529 693.86  1918.5  4892.6  5560.6   122.4625
      2530 694.05  1857.5  4814.8  5510.3   123.5180
      2531 694.23  1823.9  4829.1  5509.0   122.6251
      2532 694.42  1987.8  4906.1  5611.8   124.1825
      2533 694.61  1839.5  4779.5  5440.6   122.4854
      2534 694.79  1806.3  4721.8  5450.9   125.0070
      2535 694.98  1770.3  4746.4  5442.3   123.3829
      2536 695.17  1965.6  4941.7  5565.2   120.9469
      2537 695.36  1788.3  4736.1  5455.4   124.3991
      2538 695.54  1912.8  4900.8  5552.0   121.7958
      2539 695.73  1766.6  4782.0  5430.0   121.4887
      2540 695.92  1896.4  4834.4  5616.8   126.6276
      2541 696.10  1914.4  4992.5  5569.7   118.7492
      2542 696.29  1797.3  4837.3  5498.0   121.7327
      2543 696.48  1909.1  4957.3  5577.8   120.3574
      2544 696.66  2029.9  5095.8  5769.1   121.9639
      2545 696.85  1855.5  4859.0  5545.5   122.8556
      2546 697.04  1794.4  4837.3  5477.9   121.0526
      2547 697.22  1812.9  4832.8  5529.5   123.0707
      2548 697.41  1958.7  4955.3  5670.4   123.8655
      2549 697.60  1823.1  4827.9  5507.0   122.6009
      2550 697.79  1853.8  4837.3  5517.6   122.8034
      2551 697.97  1798.5  4793.1  5467.7   122.5277
      2552 698.16  1919.4  4882.8  5606.1   124.4091
      2553 698.35  1857.9  4832.4  5465.6   121.2889
      2554 698.53  1839.1  4775.9  5446.4   122.8312
      2555 698.72  1860.4  4810.3  5421.0   120.7026
      2556 698.91  1987.8  4958.5  5602.0   121.6600
      2557 699.09  1875.5  4746.0  5385.7   122.2888
      2558 699.28  1828.0  4712.4  5383.7   123.2746
      2559 699.47  2021.8  4896.7  5516.0   121.5415
      2560 699.65  1796.9  4637.8  5423.0   127.6384
      2561 699.84  1916.5  4863.1  5496.7   121.5040
      2562 700.03  1870.6  4764.4  5413.2   122.4204
      2563 700.21  1835.8  4661.6  5357.5   124.6268
      2564 700.40  1796.5  4702.1  5347.2   122.2019
      2565 700.59  1875.1  4741.5  5335.8   120.7345
      2566 700.77  1858.7  4731.6  5355.4   121.7137
      2567 700.96  1842.8  4730.4  5362.8   121.9007
      2568 701.15  1976.3  4809.4  5499.6   124.3603
      2569 701.33  1938.2  4786.1  5412.0   121.9761
      2570 701.52  1812.0  4694.8  5348.5   122.6769
      2571 701.70  1835.8  4676.3  5326.4   122.8839
      2572 701.89  2010.7  4820.1  5500.0   124.2018
      2573 702.08  1857.1  4691.1  5301.8   121.5494
      2574 702.26  1734.6  4591.1  5210.0   121.6662
      2575 702.45  1793.2  4612.4  5251.8   122.6791
      2576 702.64  1792.8  4577.6  5232.6   123.5182
      2577 702.82  1860.0  4696.4  5361.6   123.4513
      2578 703.01  1891.5  4697.2  5315.7   122.0438
      2579 703.20  1857.1  4637.8  5289.1   123.4202
      2580 703.38  1981.2  4840.6  5443.1   121.0715
      2581 703.57  1818.6  4620.2  5229.3   121.7398
      2582 703.76  1882.5  4728.8  5313.3   120.5353
      2583 703.94  1907.5  4738.2  5345.2   121.4441
      2584 704.13  1848.9  4690.3  5313.7   121.9403
      2585 704.31  1822.7  4566.2  5236.2   124.4252
      2586 704.50  1948.0  4780.8  5471.4   124.3783
      2587 704.69  1949.3  4809.4  5421.8   121.4091
      2588 704.87  1848.1  4748.0  5388.2   122.0763
      2589 705.06  1857.1  4748.0  5367.3   121.4225
      2590 705.25  1967.7  4870.5  5532.4   122.8023
      2591 705.43  1798.9  4700.5  5407.9   124.3789
      2592 705.62  1863.7  4822.6  5408.3   119.7951
      2593 705.80  1916.9  4860.2  5493.9   121.5280
      2594 705.99  1845.2  4825.0  5484.5   122.1306
      2595 706.18  1852.2  4842.2  5482.8   121.4247
      2596 706.36  1891.9  4832.4  5518.0   123.3180
      2597 706.55  1841.5  4816.0  5495.1   122.8312
      2598 706.73  1896.8  4898.7  5629.9   124.3553
      2599 706.92  1812.0  4845.5  5439.0   119.5652
      2600 707.11  1898.5  4930.3  5618.0   122.6831
      2601 707.29  1955.0  4967.6  5658.1   122.9232
      2602 707.48  1896.4  4966.3  5592.2   120.3869
      2603 707.66  1853.8  4891.4  5612.7   123.7460
      2604 707.85  1842.4  4841.0  5506.6   122.1964
      2605 708.04  1884.5  4931.1  5572.1   121.0406
      2606 708.22  1846.9  4853.7  5514.4   121.9725
      2607 708.41  1864.9  4906.5  5550.0   121.1554
      2608 708.59  1941.9  5001.1  5569.7   118.5835
      2609 708.78  1901.7  4857.0  5533.6   122.8967
      2610 708.97  1703.9  4710.3  5313.7   120.0681
      2611 709.15  1841.9  4848.8  5500.4   121.6728
      2612 709.34  1880.0  4939.3  5525.0   119.1458
      2613 709.52  1882.1  4844.7  5525.4   122.9780
      2614 709.71  1842.8  4789.0  5420.2   121.4236
      2615 709.90  1801.0  4715.7  5366.1   122.3159
      2616 710.08  1977.1  4868.8  5576.6   124.4759
      2617 710.27  1741.6  4729.2  5333.3   120.2221
      2618 710.45  1895.6  4787.3  5452.1   122.9887
      2619 710.64  1832.9  4728.4  5337.0   121.0214
      2620 710.82  1903.4  4827.1  5432.9   120.7201
      2621 711.01  1838.7  4761.9  5455.4   123.7215
      2622 711.20  1866.9  4773.4  5444.3   123.0834
      2623 711.38  1785.0  4702.1  5328.4   121.4687
      2624 711.57  1874.7  4808.2  5436.9   121.4326
      2625 711.75  1782.6  4656.3  5325.5   123.2896
      2626 711.94  1889.0  4834.4  5425.5   120.0668
      2627 712.12  1862.4  4780.4  5445.5   122.7962
      2628 712.31  1887.8  4795.9  5477.9   123.4507
      2629 712.50  1910.3  4863.5  5523.4   122.3440
      2630 712.68  1842.4  4761.1  5393.5   121.6671
      2631 712.87  1892.7  4829.9  5384.9   118.8956
      2632 713.05  1850.5  4768.1  5421.8   122.4063
      2633 713.24  1879.2  4762.8  5450.1   123.8352
      2634 713.42  1836.2  4741.0  5393.9   122.4760
      2635 713.61  1852.6  4736.1  5373.1   122.0881
      2636 713.79  1918.9  4862.7  5531.6   122.7216
      2637 713.98  1814.1  4712.4  5365.7   122.5410
      2638 714.17  1859.6  4793.1  5396.8   120.5808
      2639 714.35  1853.8  4683.3  5388.6   124.9276
      2640 714.54  1826.8  4700.5  5343.2   122.3632
      2641 714.72  1825.6  4688.2  5357.5   123.3796
      2642 714.91  1791.2  4694.8  5330.0   121.8790
      2643 715.09  1879.2  4756.2  5376.7   121.5689
      2644 715.28  1788.7  4614.9  5256.7   122.7101
      2645 715.46  1999.6  4810.3  5498.8   124.4972
      2646 715.65  1799.3  4666.9  5257.5   120.5971
      2647 715.83  1928.0  4786.5  5412.8   121.9086
      2648 716.02  1951.3  4799.6  5290.7   117.2419
      2649 716.21  1930.0  4700.5  5293.2   121.3927
      2650 716.39  1868.2  4680.4  5269.0   120.9292
      2651 716.58  1811.6  4592.0  5196.9   121.7590
      2652 716.76  1848.9  4616.1  5231.3   122.2321
      2653 716.95  1960.7  4718.1  5380.0   124.0048
      2654 717.13  1819.4  4631.3  5149.0   118.4122
      2655 717.32  1815.3  4585.8  5178.1   121.3779
      2656 717.50  1991.0  4767.7  5411.1   123.1745
      2657 717.69  1920.2  4683.3  5214.5   119.2262
      2658 717.87  1783.0  4601.8  5238.3   122.5806
      2659 718.06  1879.6  4649.3  5254.3   121.8427
      2660 718.24  1817.4  4595.6  5238.3   123.1314
      2661 718.43  1921.0  4667.7  5266.1   121.7865
      2662 718.61  1951.3  4718.1  5315.7   121.5988
      2663 718.80  1913.2  4680.4  5271.5   121.3588
      2664 718.98  1858.3  4669.8  5287.9   121.9843
      2665 719.17  1890.7  4607.9  5195.7   121.6310
      2666 719.35  1879.6  4614.5  5274.3   124.1276
      2667 719.54  1853.8  4584.6  5256.7   124.6138
      2668 719.72  1830.1  4576.0  5227.2   123.7172
      2669 719.91  1889.0  4641.9  5285.8   123.3894
      2670 720.09  1851.8  4506.4  5147.0   124.1321
      2671 720.28  1873.5  4651.8  5241.6   121.2295
      2672 720.46  1869.4  4636.6  5229.3   121.4180
      2673 720.65  2017.7  4727.9  5323.5   121.9737
      2674 720.83  1872.7  4615.7  5219.0   121.9949
      2675 721.02  1877.2  4577.6  5220.7   123.8131
      2676 721.20  1959.9  4689.0  5252.6   120.6514
      2677 721.39  1853.0  4551.4  5177.3   123.1937
      2678 721.57  1812.5  4474.0  5066.3   122.2530
      2679 721.76  1904.6  4585.0  5171.1   121.8674
      2680 721.94  1873.5  4564.9  5177.3   122.7515
      2681 722.13  1844.4  4515.0  5191.6   125.3374
      2682 722.31  1851.8  4596.1  5211.3   122.4179
      2683 722.50  1932.9  4612.8  5238.7   123.3532
      2684 722.68  1847.3  4539.1  5186.3   124.0414
      2685 722.87  1952.9  4632.9  5263.7   123.5366
      2686 723.05  1907.1  4641.5  5179.3   119.6675
      2687 723.24  2100.0  4786.5  5403.0   122.9456
      2688 723.42  1841.5  4542.8  5160.9   122.8810
      2689 723.61  1968.1  4729.6  5307.1   120.9137
      2690 723.79  1823.9  4464.6  5117.1   124.7092
      2691 723.98  1827.6  4605.9  5193.6   121.1558
      2692 724.16  2005.8  4762.3  5357.9   121.6048
      2693 724.34  1832.1  4513.7  5171.5   124.5303
      2694 724.53  1872.3  4682.5  5242.0   119.9096
      2695 724.71  1951.7  4728.8  5359.9   122.7286
      2696 724.90  1846.9  4577.2  5170.7   121.7372
      2697 725.08  1913.2  4700.5  5268.2   120.3674
      2698 725.27  1800.6  4578.4  5249.4   124.1522
      2699 725.45  1855.5  4666.5  5228.5   119.9913
      2700 725.64  1834.2  4564.1  5196.9   123.1808
      2701 725.82  1966.5  4755.8  5364.9   121.8355
      2702 726.01  1783.8  4543.6  5171.5   122.7516
      2703 726.19  1827.6  4635.4  5264.1   122.3924
      2704 726.38  1839.1  4655.4  5311.2   123.2839
      2705 726.56  1806.3  4612.4  5254.3   122.8726
      2706 726.74  1838.7  4624.3  5254.7   122.6290
      2707 726.93  1819.4  4639.5  5212.5   120.3195
      2708 727.11  2111.0  4841.0  5523.4   124.9962
      2709 727.30  1861.6  4678.0  5286.2   121.5969
      2710 727.48  1863.7  4647.3  5280.9   122.7634
      2711 727.67  1813.7  4688.2  5337.0   122.5705
      2712 727.85  1927.5  4740.2  5414.4   123.9697
      2713 728.04  2011.9  4909.4  5443.5   118.4337
      2714 728.22  1932.5  4831.2  5454.2   121.4922
      2715 728.40  1845.2  4703.4  5389.0   123.9897
      2716 728.59  1916.1  4843.4  5440.2   120.3862
      2717 728.77  1893.6  4741.0  5370.6   122.1087
      2718 728.96  1800.2  4701.3  5389.8   123.7329
      2719 729.14  1798.5  4751.7  5363.6   120.7212
      2720 729.33  2078.7  5019.2  5708.9   123.4573
      2721 729.51  1909.9  4815.6  5455.4   122.0186
      2722 729.69  1908.3  4813.5  5549.6   125.3348
      2723 729.88  1820.2  4808.6  5496.3   123.0126
      2724 730.06  1897.2  4877.0  5527.5   121.8282
      2725 730.25  1897.2  4880.7  5518.0   121.3619
      2726 730.43  1826.4  4838.5  5499.6   121.9472
      2727 730.61  1835.4  4838.1  5525.4   122.8891
      2728 730.80  1851.4  4881.1  5577.8   122.9958
      2729 730.98  1970.6  4993.4  5713.0   123.8076
      2730 731.17  1832.1  4886.9  5517.6   120.6490
      2731 731.35  1790.3  4885.2  5526.2   120.7120
      2732 731.54  1871.0  4906.1  5638.1   124.1161
      2733 731.72  1914.9  5069.5  5704.8   120.1376
      2734 731.90  1776.0  4864.3  5541.0   121.9098
      2735 732.09  1862.0  4910.2  5598.7   122.5880
      2736 732.27  1962.0  5022.0  5721.6   122.8617
      2737 732.46  1943.1  5083.9  5810.5   123.1351
      2738 732.64  1871.4  4943.8  5618.8   121.9704
      2739 732.82  1826.0  4919.6  5583.6   121.4617
      2740 733.01  1905.0  4990.5  5699.9   122.9922
      2741 733.19  1927.5  5028.6  5716.3   122.1767
      2742 733.38  1808.8  4851.2  5608.6   124.8923
      2743 733.56  1915.7  5031.9  5729.4   122.3843
      2744 733.74  1905.4  5078.6  5744.6   120.9888
      2745 733.93  1925.9  5065.9  5748.6   121.7454
      2746 734.11  1879.2  4991.3  5715.1   123.2561
      2747 734.29  1856.7  4993.4  5726.5   123.3742
      2748 734.48  1932.5  5022.8  5727.3   122.7966
      2749 734.66  1881.3  5004.0  5738.0   123.5047
      2750 734.85  1772.3  4946.3  5604.5   120.7382
      2751 735.03  1859.6  4975.3  5648.7   121.6117
      2752 735.21  1865.3  4980.7  5689.7   122.7583
      2753 735.40  1976.7  5110.9  5817.5   122.5431
      2754 735.58  1876.3  4950.8  5598.7   121.0765
      2755 735.77  1852.2  4922.9  5573.8   121.1951
      2756 735.95  1937.4  4983.9  5729.0   124.4555
      2757 736.13  1866.1  4983.5  5615.5   120.2733
      2758 736.32  1871.0  4919.2  5555.7   120.8815
      2759 736.50  1947.2  4972.5  5608.6   121.0263
      2760 736.68  1835.4  4952.8  5593.4   120.5492
      2761 736.87  1948.0  5031.0  5747.0   123.2231
      2762 737.05  1862.4  4893.4  5553.3   121.7703
      2763 737.23  1881.3  4896.3  5600.8   123.3664
      2764 737.42  1968.1  4952.4  5586.9   121.2600
      2765 737.60  1890.3  4893.4  5584.4   123.0087
      2766 737.79  1881.7  4879.9  5562.7   122.7732
      2767 737.97  1837.8  4790.6  5439.8   121.9864
      2768 738.15  1926.3  4895.1  5608.2   124.0204
      2769 738.34  1880.0  4847.5  5547.5   123.5887
      2770 738.52  1834.6  4737.8  5459.5   124.8589
      2771 738.70  1919.8  4863.5  5508.6   121.9146
      2772 738.89  1922.2  4863.5  5574.2   124.1610
      2773 739.07  1861.2  4762.3  5454.6   123.8599
      2774 739.25  1920.6  4842.6  5489.0   122.1194
      2775 739.44  1914.9  4748.8  5482.0   125.8708
      2776 739.62  1957.9  4797.2  5464.4   123.4997
      2777 739.80  1835.4  4688.6  5340.7   122.8539
      2778 739.99  1765.8  4619.4  5287.0   123.3960
      2779 740.17  1827.6  4676.7  5333.3   123.0449
      2780 740.35  1997.2  4837.7  5499.6   123.3021
      2781 740.54  1945.2  4791.4  5416.9   121.9744
      2782 740.72  1852.6  4681.2  5270.2   120.8225
      2783 740.90  1838.7  4641.5  5249.8   121.7010
      2784 741.09  1787.1  4551.0  5210.0   123.8441
      2785 741.27  1861.6  4597.3  5255.9   124.0755
      2786 741.45  1871.0  4642.3  5151.9   118.3860
      2787 741.64  1884.5  4617.4  5234.6   122.5869
      2788 741.82  1877.2  4662.0  5248.9   121.0766
      2789 742.00  1875.1  4588.3  5192.0   122.2524
      2790 742.19  1896.8  4586.2  5178.1   122.0073
      2791 742.37  1968.5  4622.3  5280.5   124.8032
      2792 742.55  1880.0  4598.9  5139.6   119.8855
      2793 742.74  1871.8  4575.6  5144.5   121.0423
      2794 742.92  1866.1  4544.4  5119.9   121.4865
      2795 743.10  1824.3  4556.3  5113.4   120.3898
      2796 743.29  1965.2  4662.0  5220.3   120.7017
      2797 743.47  1971.4  4565.7  5252.2   126.4604
      2798 743.65  1785.0  4474.8  5065.0   121.9430
      2799 743.83  1973.4  4619.8  5196.9   121.8078
      2800 744.02  1853.8  4569.0  5073.2   118.5699
      2801 744.20  1839.9  4505.1  5097.8   122.2376
      2802 744.38  1867.7  4492.4  5012.2   119.8034
      2803 744.57  1760.8  4422.0  5016.3   122.3334
      2804 744.75  1815.3  4455.6  5105.2   124.6044
      2805 744.93  1883.3  4475.6  5099.9   124.0796
      2806 745.12  1847.3  4470.7  5064.6   122.6386
      2807 745.30  1876.3  4490.4  5124.0   124.2401
      2808 745.48  2049.2  4723.8  5290.7   121.1945
      2809 745.66  1810.8  4468.3  5086.3   123.2583
      2810 745.85  1778.0  4382.2  5000.3   123.7339
      2811 746.03  1818.6  4482.2  5033.5   120.6981
      2812 746.21  1930.8  4607.1  5188.7   121.7325
      2813 746.40  1887.0  4587.9  5120.7   119.7301
      2814 746.58  1891.1  4571.1  5193.2   123.2157
      2815 746.76  1812.5  4467.4  5054.4   122.1074
      2816 746.94  1959.9  4622.7  5257.1   123.8271
      2817 747.13  1916.1  4556.7  5165.4   123.0495
      2818 747.31  1789.9  4515.8  5119.9   122.1638
      2819 747.49  1891.9  4630.0  5187.5   120.3590
      2820 747.68  1905.8  4568.6  5193.2   123.4579
      2821 747.86  1933.7  4667.3  5301.0   123.1795
      2822 748.04  1907.9  4585.0  5186.3   122.4602
      2823 748.22  1826.4  4605.5  5128.9   118.8357
      2824 748.41  1955.8  4703.0  5247.7   119.8300
      2825 748.59  1954.6  4700.5  5370.6   124.4033
      2826 748.77  1818.6  4573.9  5153.5   121.0346
      2827 748.95  1901.3  4623.1  5246.1   122.8894
      2828 749.14  1850.5  4610.8  5266.6   123.7572
      2829 749.32  1897.6  4687.0  5304.2   122.1292
      2830 749.50  1846.4  4615.7  5179.3   120.3520
      2831 749.68  1758.8  4499.8  5166.2   124.3126
      2832 749.87  1878.4  4691.5  5274.7   120.7338
      2833 750.05  1895.2  4678.0  5299.3   122.3285
      2834 750.23  1796.1  4678.0  5267.4   120.4520
      2835 750.42  1886.6  4717.3  5292.4   120.3154
      2836 750.60  1880.4  4707.9  5277.2   120.1362
      2837 750.78  1868.2  4682.1  5261.6   120.5968
      2838 750.96  1907.9  4684.5  5343.2   123.7203
      2839 751.15  1917.7  4704.2  5361.2   123.5778
      2840 751.33  1796.5  4579.3  5218.2   122.9614
      2841 751.51  1946.0  4747.2  5362.4   121.9623
      2842 751.69  1946.4  4688.2  5435.3   127.2483
      2843 751.87  1875.9  4656.3  5281.7   122.4956
      2844 752.06  1794.0  4644.0  5233.0   120.6669
      2845 752.24  1898.9  4698.0  5345.6   123.1343
      2846 752.42  1828.0  4625.1  5286.2   123.6345
      2847 752.60  1773.5  4674.3  5177.3   117.3397
      2848 752.79  1957.4  4846.3  5458.7   121.1967
      2849 752.97  1912.8  4753.3  5380.8   122.0908
      2850 753.15  1784.2  4664.9  5297.3   121.9536
      2851 753.33  1832.9  4691.5  5386.2   124.3015
      2852 753.52  1881.7  4725.9  5378.8   122.9551
      2853 753.70  1907.9  4761.5  5381.7   121.7310
      2854 753.88  1814.1  4691.9  5396.0   124.4663
      2855 754.06  1914.0  4799.6  5491.4   123.9744
      2856 754.24  1859.1  4810.7  5470.9   122.3702
      2857 754.43  1957.9  4942.2  5572.1   121.1090
      2858 754.61  1812.9  4823.4  5462.3   121.2245
      2859 754.79  1857.5  4885.6  5505.3   120.4653
      2860 754.97  1843.6  4895.5  5567.6   122.0239
      2861 755.16  1939.4  5036.4  5690.1   121.1083
      2862 755.34  1869.8  4997.5  5647.9   120.7962
      2863 755.52  1926.7  5063.0  5722.0   121.0135
      2864 755.70  1903.4  4992.9  5748.6   124.4598
      2865 755.88  1833.3  4989.3  5709.7   122.8293
      2866 756.07  1821.9  5044.1  5764.6   122.3592
      2867 756.25  1847.3  5086.3  5810.1   122.3445
      2868 756.43  1923.9  5167.4  5887.9   122.2124
      2869 756.61  1798.1  5094.1  5790.8   121.1383
      2870 756.79  1958.7  5251.4  5968.6   121.7813
      2871 756.98  1824.7  5094.1  5869.5   123.7159
      2872 757.16  1928.4  5266.1  5954.3   120.6160
      2873 757.34  1807.9  5156.4  5932.1   123.1682
      2874 757.52  1799.3  5192.4  5931.3   121.7769
      2875 757.70  1835.8  5238.7  6102.1   125.3731
      2876 757.89  1916.9  5434.9  6190.2   121.4693
      2877 758.07  2090.6  5474.6  6328.6   125.2360
      2878 758.25  1931.2  5384.9  6160.7   122.4620
      2879 758.43  1822.3  5339.1  6125.1   122.3503
      2880 758.61  1913.2  5377.1  6141.0   122.0527
      2881 758.80  1938.2  5403.0  6209.9   123.2888
      2882 758.98  1901.7  5402.1  6246.7   124.1282
      2883 759.16  1889.0  5346.0  6104.6   121.9431
      2884 759.34  1951.7  5405.0  6212.7   123.3899
      2885 759.52  1864.5  5381.2  6140.2   121.5816
      2886 759.70  1873.5  5411.1  6127.5   120.2501
      2887 759.89  1830.5  5345.6  6067.3   120.5313
      2888 760.07  1844.0  5324.7  6147.2   123.6291
      2889 760.25  1842.8  5385.7  6130.8   121.0289
      2890 760.43  1787.9  5280.9  6086.2   123.0535
      2891 760.61  1842.8  5307.5  6124.7   123.5843
      2892 760.79  1841.5  5389.0  6131.6   120.9329
      2893 760.98  1888.2  5307.5  6107.9   123.4068
      2894 761.16  1869.0  5367.7  6121.4   121.5406
      2895 761.34  1840.7  5287.0  6095.6   123.4609
      2896 761.52  1805.9  5257.1  6012.0   121.8728
      2897 761.70  1905.4  5428.8  6156.6   120.6580
      2898 761.88  1830.9  5286.6  6111.1   123.8592
      2899 762.07  1843.2  5347.7  6067.7   120.5470
      2900 762.25  1991.9  5439.8  6206.2   122.2262
      2901 762.43  1903.8  5369.8  6116.9   121.5552
      2902 762.61  1897.6  5345.2  6226.6   125.5673
      2903 762.79  1779.3  5236.2  5985.4   121.6706
      2904 762.97  1877.2  5422.6  6151.7   120.5638
      2905 763.15  1853.4  5310.0  6141.9   124.0668
      2906 763.34  1803.4  5326.4  6116.9   122.4393
      2907 763.52  1814.5  5273.1  6155.4   125.5092
      2908 763.70  1946.4  5439.4  6227.9   122.5727
      2909 763.88  1941.1  5496.7  6242.2   120.9653
      2910 764.06  1957.9  5498.4  6356.1   124.2249
      2911 764.24  1827.6  5387.8  6172.6   122.0433
      2912 764.42  1873.1  5443.9  6227.1   121.9316
      2913 764.61  1832.1  5410.3  6166.0   121.1195
      2914 764.79  1749.8  5267.4  6027.2   121.5999
      2915 764.97  1895.2  5414.8  6192.2   122.0877
      2916 765.15  1847.3  5263.3  6088.6   124.1607
      2917 765.33  1966.0  5482.0  6241.4   121.5983
      2918 765.51  1864.1  5369.8  6117.3   121.3226
      2919 765.69  2006.6  5449.2  6269.7   123.8311
      2920 765.87  1906.2  5399.7  6160.3   121.7728
      2921 766.06  1914.9  5397.2  6146.0   121.5008
      2922 766.24  1805.5  5256.3  6001.4   121.5905
      2923 766.42  1796.5  5234.2  5994.8   122.1256
      2924 766.60  1896.8  5270.2  6056.7   123.3123
      2925 766.78  1980.0  5417.3  6118.1   120.3885
      2926 766.96  1921.4  5275.6  6033.3   122.5913
      2927 767.14  1839.5  5267.4  5965.7   120.3728
      2928 767.32  1921.4  5314.1  6007.9   120.4515
      2929 767.50  1805.5  5154.7  5896.9   122.1597
      2930 767.69  1923.9  5275.6  6055.0   123.2555
      2931 767.87  1868.6  5268.2  6019.0   122.0843
      2932 768.05  1970.6  5394.3  6073.0   119.8229
      2933 768.23  1869.8  5206.3  5970.2   122.8947
      2934 768.41  1913.2  5307.1  6139.8   124.5354
      2935 768.59  1807.1  5215.4  6005.9   123.1943
      2936 768.77  1887.0  5311.2  6092.3   122.8110
      2937 768.95  1874.3  5330.0  6043.1   120.6353
      2938 769.13  1851.0  5246.5  5942.4   120.4946
      2939 769.32  1849.3  5297.3  6024.7   121.0976
      2940 769.50  1927.5  5346.4  6131.6   122.9663
      2941 769.68  1911.2  5278.4  6118.1   124.9361
      2942 769.86  1950.1  5360.4  6151.7   123.2044
      2943 770.04  1805.9  5186.7  6036.2   125.1272
      2944 770.22  1820.6  5239.1  5899.4   119.3146
      2945 770.40  1873.1  5261.2  6016.9   122.3042
      2946 770.58  1837.0  5183.0  5942.0   122.6833
      2947 770.76  1882.1  5207.6  5896.1   120.7045
      2948 770.94  1973.0  5241.6  6017.3   123.7343
      2949 771.12  1803.4  5125.2  5822.0   120.9741
      2950 771.30  1883.3  5141.2  5802.7   120.3042
      2951 771.49  1904.2  5157.6  5862.1   121.6543
      2952 771.67  1892.7  5111.3  5767.1   120.3741
      2953 771.85  1887.8  5008.9  5717.1   122.6903
      2954 772.03  1896.8  5032.3  5743.7   122.6911
      2955 772.21  1890.3  5055.6  5782.6   122.9684
      2956 772.39  1823.9  4895.5  5595.5   122.7897
      2957 772.57  1941.1  4990.9  5692.9   123.0191
      2958 772.75  1798.1  4814.8  5484.1   122.1860
      2959 772.93  1932.9  4879.1  5534.4   122.2438
      2960 773.11  1947.2  4854.5  5480.0   121.5131
      2961 773.29  1907.5  4802.1  5498.8   124.0696
      2962 773.47  1907.1  4837.7  5443.1   120.6569
      2963 773.65  1894.8  4759.5  5369.8   121.3040
      2964 773.83  1957.4  4803.7  5452.1   122.7803
      2965 774.01  1839.9  4645.2  5267.8   122.1930
      2966 774.19  1920.6  4677.6  5333.3   123.7855
      2967 774.38  1852.6  4637.8  5336.2   125.0735
      2968 774.56  1971.0  4708.3  5364.9   123.9862
      2969 774.74  1921.8  4659.1  5291.5   123.1034
      2970 774.92  1862.8  4564.5  5172.8   122.5136
      2971 775.10  1886.6  4567.4  5172.8   122.5821
      2972 775.28  1848.1  4496.9  5119.1   123.4885
      2973 775.46  1977.5  4578.0  5232.2   125.1536
      2974 775.64  1872.7  4503.1  5029.4   120.0093
      2975 775.82  1820.2  4419.9  5025.3   123.2866
      2976 776.00  1798.1  4379.0  5008.1   124.3771
      2977 776.18  1857.1  4424.8  5040.5   123.9751
      2978 776.36  1892.3  4458.4  5116.6   125.6504
      2979 776.54  2001.3  4644.8  5237.1   122.4047
      2980 776.72  1865.3  4508.0  5104.8   122.5821
      2981 776.90  1879.6  4548.9  5129.3   121.7431
      2982 777.08  1896.8  4502.3  5133.8   124.2415
      2983 777.26  1896.4  4506.4  5060.5   121.2335
      2984 777.44  1840.7  4462.5  5051.5   122.4652
      2985 777.62  1966.9  4584.6  5137.1   121.1078
      2986 777.80  1963.6  4620.6  5197.7   121.7204
      2987 777.98  1875.5  4513.3  5162.1   124.5963
      2988 778.16  1817.8  4393.7  5023.7   124.4554
      2989 778.34  1894.0  4563.7  5126.9   121.0954
      2990 778.52  1934.5  4628.4  5153.9   119.5074
      2991 778.70  1888.6  4507.6  5101.9   122.6931
      2992 778.88  1842.8  4504.7  5095.3   122.1880
      2993 779.06  1794.8  4417.9  5013.4   122.7046
      2994 779.24  1906.2  4658.7  5167.4   118.4821
      2995 779.42  1930.0  4574.8  5137.9   121.2947
      2996 779.60  1991.0  4612.0  5192.4   122.1441
      2997 779.78  1879.6  4546.1  5178.1   123.7020
      2998 779.96  1881.3  4444.5  5063.4   124.1451
      2999 780.14  1880.0  4528.5  5116.6   122.2085
      3000 780.32  1893.1  4458.8  5159.2   127.2989
      3001 780.50  1914.0  4591.5  5178.1   121.9061
      3002 780.68  1826.0  4453.9  5029.4   121.8984
      3003 780.86  1900.9  4486.7  5073.2   122.6834
      3004 781.04  1905.0  4451.1  5008.9   121.9112
      3005 781.22  1836.2  4428.1  4994.2   121.8394
      3006 781.40  1903.4  4494.9  5009.7   119.8672
      3007 781.58  1851.8  4420.7  5009.3   122.9114
      3008 781.76  1928.0  4480.5  4993.8   120.1059
      3009 781.94  1897.6  4411.3  5017.1   124.0997
      3010 782.12  1901.3  4396.6  4959.0   122.5378
      3011 782.30  1975.9  4490.8  5076.9   123.3062
      3012 782.48  1896.4  4367.9  4946.3   123.4007
      3013 782.66  1912.8  4373.6  4936.0   122.8529
      3014 782.84  1925.9  4319.2  4845.9   122.0092
      3015 783.02  1910.8  4318.8  4919.6   124.9532
      3016 783.20  1896.4  4310.6  4850.0   122.3448
      3017 783.38  1927.5  4350.7  4966.7   125.4226
      3018 783.56  1771.5  4146.7  4724.3   124.3145
      3019 783.74  1811.2  4169.7  4705.0   122.6989
      3020 783.92  1856.7  4184.0  4736.1   123.7240
      3021 784.10  1879.6  4249.1  4766.9   121.8496
      3022 784.28  1936.1  4272.1  4771.4   121.3747
      3023 784.46  1848.9  4122.2  4722.2   126.3964
      3024 784.64  1914.0  4180.3  4658.3   121.0916
      3025 784.82  1899.3  4156.1  4665.7   122.5771
      3026 785.00  1839.9  4076.3  4591.5   123.0403
      3027 785.18  1835.4  4104.9  4610.8   122.2884
      3028 785.36  1973.8  4204.1  4741.9   124.1139
      3029 785.54  1789.5  4059.1  4537.9   121.0973
      3030 785.72  1902.2  4124.6  4635.4   122.9819
      3031 785.90  1891.1  4167.2  4676.3   122.3682
      3032 786.08  1827.2  4046.4  4553.5   122.8498
      3033 786.26  1813.7  4104.9  4573.9   120.4684
      3034 786.43  1922.6  4157.8  4645.6   121.8252
      3035 786.61  1934.1  4204.9  4702.5   121.9156
      3036 786.79  2022.6  4257.7  4755.8   122.2833
      3037 786.97  2014.8  4249.1  4726.7   121.3749
      3038 787.15  1865.3  4084.5  4646.4   125.3230
      3039 787.33  1902.6  4112.7  4606.7   122.3499
      3040 787.51  1845.6  4050.5  4529.3   121.7165
      3041 787.69  1953.4  4164.7  4639.9   121.4855
      3042 787.87  1791.6  4015.7  4526.0   122.9466
      3043 788.05  1921.8  4114.0  4590.7   121.7489
      3044 788.23  2073.0  4221.7  4750.9   124.6283
      3045 788.41  1862.0  4000.5  4551.0   125.7422
      3046 788.59  1947.6  4078.7  4590.3   124.0054
      3047 788.77  1976.7  4098.4  4631.7   125.1351
      3048 788.95  1882.1  4030.8  4492.8   121.5021
      3049 789.13  1888.2  4021.8  4490.8   121.9812
      3050 789.30  1929.6  4017.3  4495.3   122.8958
      3051 789.48  1791.6  3905.1  4392.9   123.0814
      3052 789.66  1899.7  3939.1  4482.6   126.6519
      3053 789.84  1908.3  3984.1  4384.7   119.2976
      3054 790.02  1862.8  3924.3  4380.2   122.1140
      3055 790.20  1740.8  3776.9  4301.6   125.7695
      3056 790.38  1937.0  3953.4  4353.6   119.8456
      3057 790.56  1859.6  3853.5  4289.3   121.8570
      3058 790.74  1756.7  3733.4  4202.8   123.7464
      3059 790.92  1884.1  3908.3  4329.0   120.7811
      3060 791.10  1925.9  3938.7  4354.8   120.6756
      3061 791.28  1963.2  3983.3  4428.1   122.0195
      3062 791.45  2014.4  4043.9  4395.8   117.3360
      3063 791.63  1799.3  3799.0  4251.6   122.6342
      3064 791.81  2071.3  3982.1  4462.9   125.1661
      3065 791.99  1966.9  3930.1  4385.9   123.2214
      3066 792.17  1829.2  3803.5  4289.7   124.6266
      3067 792.35  1808.4  3828.9  4291.3   122.8867
      3068 792.53  1738.3  3848.5  4186.0   115.9938
      3069 792.71  1956.6  3983.3  4429.3   122.0089
      3070 792.89  1838.3  3872.7  4332.7   122.6092
      3071 793.07  2044.3  4035.3  4467.8   121.7239
      3072 793.24  1890.3  3871.9  4332.3   123.2327
      3073 793.42  1991.0  3988.2  4490.8   125.1641
      3074 793.60  1801.8  3772.4  4251.6   124.3193
      3075 793.78  1875.1  3883.4  4367.1   124.0873
      3076 793.96  1839.5  3851.4  4289.7   121.7834
      3077 794.14  1864.5  3906.7  4363.0   122.3426
      3078 794.32  1911.6  3890.3  4318.8   121.6518
      3079 794.50  1944.3  3935.0  4398.6   123.2922
      3080 794.67  1899.7  3855.1  4297.0   122.6016
      3081 794.85  1881.7  3868.6  4255.7   119.4805
      3082 795.03  1853.0  3805.5  4302.0   125.4248
      3083 795.21  1840.7  3760.5  4241.8   125.0693
      3084 795.39  1869.0  3846.5  4236.8   119.7390
      3085 795.57  1905.0  3808.0  4255.7   123.5256
      3086 795.75  1884.1  3796.9  4226.2   122.4411
      3087 795.93  1868.2  3794.1  4182.8   120.1829
      3088 796.10  2027.9  3897.7  4271.2   119.9781
      3089 796.28  1842.8  3715.8  4049.2   117.8001
      3090 796.46  1794.8  3640.9  4054.2   122.3874
      3091 796.64  1945.6  3827.2  4180.7   118.7854
      3092 796.82  1986.5  3735.9  4143.5   123.2967
      3093 797.00  1953.8  3679.4  4148.0   127.1540
      3094 797.18  1802.6  3587.6  4021.8   124.3231
      3095 797.35  1853.4  3675.3  4025.1   119.1996
      3096 797.53  1900.9  3647.4  4064.0   123.8508
      3097 797.71  1907.9  3678.6  4135.7   125.8154
      3098 797.89  1941.1  3686.8  4096.8   123.4866
      3099 798.07  1825.6  3524.6  3957.9   125.5063
      3100 798.25  1887.4  3623.7  4029.2   123.3546
      3101 798.43  1966.5  3731.0  4069.3   119.1736
      3102 798.60  1824.7  3570.4  3983.3   123.6509
      3103 798.78  1908.7  3605.7  4036.1   125.3681
      3104 798.96  2018.9  3722.0  4139.4   124.5070
      3105 799.14  1842.8  3560.2  3959.5   123.2530
      3106 799.32  1764.1  3486.9  3880.5   122.8483
      3107 799.50  1887.8  3599.9  3991.9   122.8947
      3108 799.67  1839.1  3516.4  3885.0   121.9780
      3109 799.85  1871.8  3572.9  3993.9   124.7532
      3110 800.03  1855.1  3550.4  3886.2   119.8115
      3111 800.21  1898.9  3590.9  3973.1   122.5853
      3112 800.39  1929.6  3583.1  3948.1   122.0708
      3113 800.57  1876.8  3615.9  3976.3   120.7254
      3114 800.74  1828.0  3479.1  3849.8   122.4510
      3115 800.92  1835.0  3529.5  3856.3   119.2893
      3116 801.10  1853.8  3514.3  3892.4   122.7676
      3117 801.28  1800.6  3423.0  3794.9   122.9235
      3118 801.46  1873.9  3491.0  3860.0   122.8217
      3119 801.64  1912.8  3552.4  3930.9   123.0827
      3120 801.81  1974.7  3612.6  3979.6   122.4056
      3121 801.99  1843.2  3466.8  3869.4   124.7982
      3122 802.17  1871.8  3506.9  3864.9   121.8938
      3123 802.35  1846.9  3455.3  3884.6   126.6870
      3124 802.53  1854.2  3449.2  3825.6   123.6004
      3125 802.70  1693.7  3308.3  3638.8   120.4718
      3126 802.88  1851.8  3436.5  3785.9   122.0470
      3127 803.06  1780.1  3372.2  3684.3   119.6038
      3128 803.24  1913.2  3496.7  3817.8   120.2794
      3129 803.42  1907.9  3544.6  3847.3   118.4935
      3130 803.59  1777.2  3382.8  3751.9   122.9847
      3131 803.77  1833.3  3403.7  3793.7   124.8305
      3132 803.95  2031.2  3583.1  4033.7   129.0314
      3133 804.13  1922.6  3581.5  3931.3   121.0864
      3134 804.31  1819.4  3463.1  3800.6   120.5333
      3135 804.48  1925.9  3526.6  3900.6   123.3623
      3136 804.66  1928.8  3542.6  3901.0   122.2081
      3137 804.84  1819.4  3438.9  3780.6   121.0926
      3138 805.02  1887.0  3510.2  3896.1   123.7699
      3139 805.20  1870.6  3531.5  3923.5   123.6005
      3140 805.37  1840.7  3486.5  3823.6   120.4828
      3141 805.55  1908.3  3542.2  3873.1   120.2557
      3142 805.73  1864.5  3449.2  3853.5   125.5105
      3143 805.91  1910.8  3554.0  3918.6   122.1834
      3144 806.08  1905.4  3519.2  3926.8   125.2538
      3145 806.26  1884.1  3551.2  3889.1   120.2703
      3146 806.44  1873.1  3506.1  3785.5   117.1056
      3147 806.62  1760.0  3457.0  3801.0   120.2752
      3148 806.80  1842.8  3498.7  3834.6   120.2820
      3149 806.97  1867.3  3466.0  3805.9   121.2657
      3150 807.15  1882.9  3486.5  3819.1   120.7407
      3151 807.33  1992.3  3490.1  3899.7   127.3448
      3152 807.51  1955.8  3484.8  3907.5   127.6453
      3153 807.68  1743.2  3339.8  3697.8   122.4218
      3154 807.86  1920.2  3416.4  3851.8   129.0994
      3155 808.04  1808.8  3368.9  3787.1   126.8049
      3156 808.22  1903.4  3410.3  3822.7   127.3716
      3157 808.39  2189.7  4000.5  4373.6   120.6062
      3158 808.57  1868.6  3372.2  3738.8   124.3803
      3159 808.75  1857.9  3410.7  3746.1   121.6038
      3160 808.93  1910.8  3363.2  3744.5   126.2549
      3161 809.10  1850.1  3346.4  3644.6   119.9288
      3162 809.28  1878.8  3364.0  3729.4   124.6001
      3163 809.46  1866.1  3331.6  3713.0   126.0201
      3164 809.64  1976.3  3434.0  3777.3   123.5459
      3165 809.81  1835.4  3284.9  3667.1   126.3634
      3166 809.99  1847.7  3353.8  3662.2   120.4787
      3167 810.17  1793.6  3241.5  3554.0   121.5842
      3168 810.35  2080.7  3472.9  3835.4   126.0371
      3169 810.52  1899.3  3311.2  3662.6   124.8912
      3170 810.70  1956.6  3385.3  3702.7   122.2190
      3171 810.88  1880.9  3338.6  3688.8   124.0236
      3172 811.06  1901.3  3347.2  3635.6   119.9433
      3173 811.23  1969.3  3403.7  3712.6   121.5306
      3174 811.41  1855.5  3265.3  3600.7   123.7943
      3175 811.59  1703.1  3128.9  3491.4   125.4237
      3176 811.77  1936.1  3367.3  3707.6   123.7836
      3177 811.94  1843.6  3232.9  3552.0   122.9658
      3178 812.12  1849.3  3271.4  3613.4   124.0495
      3179 812.30  1913.2  3325.1  3579.8   118.0447
      3180 812.47  1934.1  3259.1  3583.5   124.4822
      3181 812.65  1971.4  3308.3  3706.0   129.7488
      3182 812.83  1957.9  3327.9  3665.0   124.6039
      3183 813.01  1875.9  3266.5  3597.9   123.8292
      3184 813.18  1847.7  3235.8  3503.3   119.2682
      3185 813.36  1877.2  3285.4  3613.4   123.2984
      3186 813.54  1860.0  3226.4  3589.3   126.5588
      3187 813.71  1855.1  3216.9  3523.7   122.5263
      3188 813.89  2056.2  3416.8  3771.5   126.0686
      3189 814.07  1928.8  3321.8  3601.1   120.0529
      3190 814.25  1841.1  3194.8  3549.5   126.2027
      3191 814.42  1880.4  3239.9  3534.0   121.6330
      3192 814.60  2016.8  3343.9  3639.2   122.2531
      3193 814.78  1942.7  3338.2  3634.7   121.2504
      3194 814.95  1768.2  3105.1  3447.6   125.6127
      3195 815.13  2016.0  3314.0  3703.5   130.0095
      3196 815.31  1862.4  3228.0  3523.7   121.6557
      3197 815.49  1973.4  3309.1  3634.3   124.3484
      3198 815.66  1891.9  3193.6  3525.4   125.4877
      3199 815.84  1904.2  3248.1  3567.2   123.7428
      3200 816.02  1934.9  3255.9  3594.6   125.6434
      3201 816.19  1871.0  3229.6  3505.3   120.2894
      3202 816.37  1954.2  3247.3  3571.2   125.0554
      3203 816.55  1904.6  3195.2  3495.9   123.2942
      3204 816.72  1961.5  3254.2  3585.6   125.6337
      3205 816.90  1845.2  3175.2  3465.2   121.8047
      3206 817.08  1832.9  3176.0  3434.0   119.2132
      3207 817.25  1845.2  3169.4  3496.3   124.6830
      3208 817.43  1957.9  3243.2  3582.3   126.3862
      3209 817.61  1890.7  3151.0  3463.1   124.7644
      3210 817.78  1964.4  3268.1  3542.2   121.0179
      3211 817.96  1846.4  3144.0  3451.6   123.7058
      3212 818.14  1807.1  3158.8  3416.8   119.0909
      3213 818.31  1946.4  3238.2  3501.2   120.3551
      3214 818.49  1877.6  3201.4  3477.0   120.8230
      3215 818.67  1763.7  3044.1  3352.1   124.0563
      3216 818.84  1843.2  3126.8  3422.6   123.0377
      3217 819.02  1820.6  3084.7  3376.7   123.1043
      3218 819.20  1833.8  3123.6  3370.1   119.1172
      3219 819.37  1914.9  3213.3  3493.8   121.6088
      3220 819.55  1862.4  3140.4  3473.8   126.0897
      3221 819.73  1934.1  3150.2  3485.6   127.5850
      3222 819.90  1855.9  3102.7  3392.7   123.2589
      3223 820.08  1941.9  3241.1  3552.0   123.9281
      3224 820.26  1913.2  3190.7  3484.0   122.9561
      3225 820.43  1947.6  3200.6  3517.6   125.3024
      3226 820.61  1943.1  3143.2  3498.7   129.6246
      3227 820.79  1870.6  3098.6  3439.4   127.7518
      3228 820.96  1884.5  3153.5  3464.8   124.5320
      3229 821.14  1869.0  3074.8  3343.1   122.2486
      3230 821.32  1810.0  3066.2  3289.0   117.7372
      3231 821.49  1784.2  3027.7  3319.3   123.4519
      3232 821.67  1854.6  3054.3  3371.4   126.4254
      3233 821.85  1844.8  3033.5  3358.7   127.3604
      3234 822.02  1925.5  3122.3  3423.8   125.1882
      3235 822.20  1888.2  3104.3  3357.0   120.7814
      3236 822.37  1996.8  3159.6  3470.1   126.6995
      3237 822.55  1776.8  2989.6  3241.1   120.7362
      3238 822.73  1913.6  3047.0  3381.2   129.4904
      3239 822.90  1907.5  3061.3  3380.0   127.6180
      3240 823.08  1993.9  3165.8  3428.7   122.4397
      3241 823.26  1831.3  3014.6  3309.9   124.9567
      3242 823.43  1966.5  3120.3  3448.8   128.4700
      3243 823.61  1893.6  3045.7  3343.1   125.8087
      3244 823.78  1926.3  3049.4  3344.7   126.2947
      3245 823.96  1800.6  2999.5  3298.5   124.9402
      3246 824.14  1874.7  3050.2  3309.1   122.0209
      3247 824.31  1863.2  3056.8  3288.6   119.4235
      3248 824.49  1986.9  3164.9  3443.0   123.6092
      3249 824.67  1993.1  3172.7  3437.7   122.4653
      3250 824.84  1911.2  3058.8  3335.3   124.0899
      3251 825.02  1910.3  3030.2  3339.0   127.5786
      3252 825.19  1948.0  3053.9  3366.5   128.2593
      3253 825.37  2039.8  3217.4  3570.4   129.9826
      3254 825.55  1932.1  3046.6  3332.9   125.6891
      3255 825.72  1765.3  2972.4  3218.2   120.3597
      3256 825.90  1795.2  2948.3  3202.6   122.0604
      3257 826.07  1845.2  3079.7  3310.3   118.6795
      3258 826.25  1873.9  3070.7  3332.0   121.8344
      3259 826.43  1771.5  2939.7  3269.0   128.1907
      3260 826.60  1760.4  2932.7  3226.4   125.0524
      3261 826.78  1916.9  3088.7  3338.6   121.3212
      3262 826.95  1839.5  3016.7  3250.5   119.8678
      3263 827.13  1831.7  2948.7  3206.3   123.0656
      3264 827.31  1998.4  3115.0  3387.3   124.3947
      3265 827.48  1916.1  3075.2  3383.7   126.6078
      3266 827.66  1960.3  3144.5  3387.3   120.5119
      3267 827.83  1894.8  3080.1  3345.2   122.3566
      3268 828.01  1865.7  2958.1  3287.0   130.1087
      3269 828.19  1880.0  2999.0  3293.1   126.2811
      3270 828.36  1832.5  2995.8  3233.3   120.4225
      3271 828.54  1991.4  3053.1  3328.4   125.9259
      3272 828.71  1831.7  2982.3  3207.9   119.6155
      3273 828.89  1854.2  2952.4  3229.2   125.2145
      3274 829.06  1793.6  2887.2  3185.8   127.3034
      3275 829.24  2045.9  3122.7  3432.0   128.7181
      3276 829.42  1850.1  2958.9  3195.2   121.3151
      3277 829.59  1925.1  3038.8  3330.4   126.1861
      3278 829.77  1821.1  2923.3  3195.2   124.6748
      3279 829.94  1873.5  2965.9  3170.3   118.7102
      3280 830.12  1853.8  2931.5  3177.2   122.8050
      3281 830.29  1798.5  2886.0  3154.3   124.6704
      3282 830.47  1839.1  2906.5  3155.9   123.3691
      3283 830.65  1781.7  2785.2  3087.5   130.1224
      3284 830.82  2008.6  3068.3  3275.5   119.5593
      3285 831.00  1854.6  2890.1  3184.2   128.4019
      3286 831.17  1895.6  2933.9  3201.0   125.7199
      3287 831.35  1873.1  2916.3  3137.9   121.2407
      3288 831.52  1891.9  2895.8  3193.2   129.6206
      3289 831.70  1920.6  2978.6  3236.6   124.3902
      3290 831.87  1889.5  2942.1  3169.4   121.5953
      3291 832.05  1843.2  2903.2  3165.8   124.7682
      3292 832.23  1905.4  2919.6  3115.8   119.3457
      3293 832.40  1905.4  2925.3  3146.9   121.7269
      3294 832.58  1924.7  2938.8  3156.3   121.4459
      3295 832.75  1853.0  2935.1  3205.5   124.9811
      3296 832.93  1846.9  2919.6  3143.2   120.8477
      3297 833.10  1845.6  2894.6  3177.2   126.9426
      3298 833.28  1906.2  2938.8  3214.9   126.7354
      3299 833.45  1848.9  2916.3  3110.5   118.1888
      3300 833.63  1904.2  2960.1  3207.5   123.4290
      3301 833.80  1796.5  2789.3  3054.3   126.6914
      3302 833.98  1908.7  2909.8  3201.4   129.1326
      3303 834.15  1900.1  2964.2  3228.8   124.8653
      3304 834.33  1908.3  2931.1  3173.9   123.7485
      3305 834.51  1886.6  2904.4  3135.0   122.6559
      3306 834.68  1836.2  2890.1  3096.1   119.5492
      3307 834.86  1804.3  2785.2  3042.1   126.1795
      3308 835.03  1888.6  2851.6  3114.6   127.3075
      3309 835.21  1874.7  2906.1  3126.4   121.3662
      3310 835.38  1849.7  2850.4  3058.0   120.7532
      3311 835.56  1846.0  2878.2  3132.6   124.6429
      3312 835.73  1920.6  2885.2  3100.2   122.2930
      3313 835.91  1969.7  2947.8  3164.9   122.1943
      3314 836.08  1839.9  2825.4  3073.6   125.1870
      3315 836.26  1859.6  2835.6  3028.1   119.7230
      3316 836.43  1873.5  2854.9  3117.0   126.7112
      3317 836.61  1904.2  2912.6  3143.2   122.8676
      3318 836.78  1916.1  2843.0  3099.8   127.7066
      3319 836.96  1801.4  2752.5  3025.7   128.7252
      3320 837.13  2017.2  2953.6  3267.3   133.5083
      3321 837.31  1923.5  2895.8  3112.1   122.2409
      3322 837.48  1866.1  2819.2  3059.3   125.1826
      3323 837.66  1812.0  2749.6  2992.5   125.9065
      3324 837.83  1860.4  2843.8  3061.3   122.1158
      3325 838.01  1931.6  2895.8  3102.3   121.4104
      3326 838.18  1810.4  2722.2  2953.2   125.3369
      3327 838.36  1816.1  2742.6  2983.9   126.0389
      3328 838.53  1876.8  2767.2  3001.9   126.3569
      3329 838.71  1992.7  2942.1  3175.6   124.5902
      3330 838.88  1788.3  2756.6  3015.4   126.7343
      3331 839.06  1892.7  2794.7  3061.7   129.6094
      3332 839.23  1921.8  2846.3  3087.5   126.0966
      3333 839.41  1865.3  2836.4  3068.7   123.9140
      3334 839.58  1873.9  2780.7  2976.5   121.5899
      3335 839.76  1785.8  2748.8  2980.6   124.0749
      3336 839.93  1936.1  2910.6  3122.7   121.7739
      3337 840.11  1930.0  2911.4  3091.6   118.3639
      3338 840.28  1841.1  2783.2  3005.2   123.5652
      3339 840.46  1894.0  2827.8  3015.0   120.0439
      3340 840.63  1809.6  2710.7  2936.4   125.0455
      3341 840.81  1896.8  2782.0  3022.8   127.2096
      3342 840.98  1753.5  2689.4  2930.6   125.7768
      3343 841.15  1845.6  2786.1  2976.1   120.2091
      3344 841.33  1917.7  2843.0  3041.6   121.4697
      3345 841.50  1846.9  2749.2  2967.5   124.1943
      3346 841.68  1837.8  2765.2  2975.7   122.7032
      3347 841.85  1887.0  2825.8  3013.4   119.9825
      3348 842.03  2002.9  2912.2  3093.3   119.9099
      3349 842.20  1961.1  2837.7  3095.7   129.4393
      3350 842.38  1841.9  2741.4  2912.6   119.0346
      3351 842.55  1801.0  2681.6  2892.6   123.9535
      3352 842.73  1891.5  2784.4  2988.8   122.8899
      3353 842.90  1846.4  2744.7  2927.4   120.3374
      3354 843.08  1879.6  2781.6  3012.2   125.5677
      3355 843.25  1926.7  2764.3  2971.6   124.7433
      3356 843.42  1857.1  2780.7  2956.9   119.0687
      3357 843.60  1933.3  2865.1  2996.2   114.0659
      3358 843.77  1783.0  2621.0  2880.7   130.9873
      3359 843.95  1822.3  2677.1  2905.2   126.6890
      3360 844.12  1746.1  2674.2  2804.1   113.9894
      3361 844.30  1965.6  2795.9  3091.2   135.5698
      3362 844.47  1853.4  2713.6  2925.7   124.6667
      3363 844.64  1835.4  2714.0  2927.4   124.2890
      3364 844.82  2042.6  2908.9  3117.4   124.0662
      3365 844.99  1879.2  2764.8  2976.5   123.9130
      3366 845.17  1825.6  2679.6  2933.5   129.7362
      3367 845.34  1780.1  2600.9  2787.3   122.7046
      3368 845.52  1909.1  2704.5  2902.8   124.9228
      3369 845.69  1966.0  2799.2  2990.0   122.9105
      3370 845.87  1890.7  2767.2  2933.1   118.9252
      3371 846.04  1846.0  2680.8  2891.3   125.2208
      3372 846.21  1908.7  2732.0  2965.0   128.3085
      3373 846.39  1929.6  2787.3  2949.9   118.9589
      3374 846.56  1824.3  2669.7  2860.6   122.5775
      3375 846.74  1792.4  2628.0  2840.9   125.4902
      3376 846.91  1866.1  2710.3  2913.8   124.1145
      3377 847.08  1862.0  2692.7  2920.8   127.4655
      3378 847.26  1799.8  2638.6  2834.8   123.3887
      3379 847.43  1846.4  2655.4  2852.4   124.3544
      3380 847.61  1849.3  2689.0  2886.8   123.5610
      3381 847.78  1992.7  2815.5  3006.8   123.2454
      3382 847.95  1812.5  2677.1  2864.3   121.6485
      3383 848.13  1824.7  2655.8  2875.3   126.4170
      3384 848.30  1874.3  2733.6  2915.5   121.1630
      3385 848.48  1857.5  2684.9  2896.6   125.5941
      3386 848.65  1837.0  2667.3  2854.5   122.5456
      3387 848.83  1886.6  2669.7  2844.2   122.2803
      3388 849.00  1853.4  2695.1  2854.0   118.8808
      3389 849.17  1879.2  2707.4  2918.8   125.5193
      3390 849.35  1775.6  2551.8  2747.1   125.1715
      3391 849.52  1785.8  2612.8  2798.3   122.4368
      3392 849.69  1945.2  2779.1  2966.3   122.4460
      3393 849.87  1823.1  2645.6  2847.9   124.6016
      3394 850.04  1834.6  2606.7  2765.2   120.5305
      3395 850.22  1740.0  2584.9  2764.3   121.2312
      3396 850.39  1868.2  2700.9  2856.9   118.7408
      3397 850.56  1962.4  2778.7  2980.6   124.7366
      3398 850.74  1837.4  2670.1  2819.2   117.9046
      3399 850.91  1823.5  2627.5  2826.6   124.7580
      3400 851.09  1843.6  2650.1  2885.6   129.2026
      3401 851.26  1863.7  2768.0  2926.1   117.4819
      3402 851.43  1771.9  2621.0  2779.1   118.6204
      3403 851.61  1870.6  2718.1  2892.1   120.5413
      3404 851.78  1850.1  2698.0  2863.9   119.5652
      3405 851.95  1865.7  2721.3  2961.4   128.0517
      3406 852.13  1833.3  2715.2  2873.7   117.9749
      3407 852.30  1736.7  2610.3  2770.1   118.2841
      3408 852.48  2086.9  2897.1  3085.5   123.2558
      3409 852.65  1918.5  2745.9  2908.1   119.6040
      3410 852.82  1842.8  2684.1  2928.6   129.0652
      3411 853.00  1792.0  2660.3  2876.6   124.9057
      3412 853.17  1962.0  2800.4  3029.8   127.3571
      3413 853.34  1746.1  2620.6  2799.2   120.4215
      3414 853.52  1810.0  2636.6  2865.5   127.7007
      3415 853.69  1778.0  2616.5  2830.3   125.5007
      3416 853.86  1954.6  2823.7  2988.8   118.9915
      3417 854.04  1868.2  2816.8  2915.5   110.4059
      3418 854.21  1816.1  2726.3  2857.7   114.4464
      3419 854.38  1811.6  2707.4  2881.1   119.3873
      3420 854.56  1825.6  2657.0  2887.6   127.7340
      3421 854.73  1820.2  2652.9  2862.7   125.1845
      3422 854.90  1865.3  2711.5  2914.7   124.0077
      3423 855.08  1809.2  2659.1  2837.7   121.0120
      3424 855.25  1911.6  2740.6  2965.5   127.1245
      3425 855.42  1786.2  2569.0  2764.3   124.9608
      3426 855.60  1856.3  2675.1  2854.5   121.9110
      3427 855.77  1873.5  2697.2  2897.5   124.3163
      3428 855.95  1900.1  2718.5  2926.5   125.4254
      3429 856.12  1912.8  2705.0  2917.5   126.8356
      3430 856.29  1819.8  2613.2  2783.2   121.4249
      3431 856.46  1889.9  2688.2  2827.8   117.4962
      3432 856.64  1890.7  2648.8  2818.4   122.3663
      3433 856.81  1910.8  2707.0  2855.7   118.6728
      3434 856.98  1848.5  2616.5  2825.4   127.2000
      3435 857.16  1814.1  2627.1  2752.5   115.4156
      3436 857.33  1797.3  2557.1  2778.7   129.1644
      3437 857.50  1894.8  2717.2  2891.7   121.2151
      3438 857.68  1839.9  2600.5  2802.4   126.5482
      3439 857.85  1853.0  2602.1  2754.9   120.3937
      3440 858.02  1835.4  2539.1  2737.3   128.1723
      3441 858.20  1828.8  2625.9  2791.0   120.7091
      3442 858.37  1831.3  2543.6  2707.4   123.0017
      3443 858.54  1838.7  2540.7  2729.9   126.9545
      3444 858.72  2215.5  2934.3  3136.3   128.0912
      3445 858.89  1989.0  2719.7  2842.2   116.7601
      3446 859.06  1744.9  2528.0  2667.3   117.7824
      3447 859.24  1820.6  2526.8  2728.7   128.5963
      3448 859.41  1932.9  2637.4  2835.2   128.0814
      3449 859.58  1923.9  2641.9  2825.0   125.4991
      3450 859.75  1850.1  2546.9  2792.2   135.2146
      3451 859.93  1852.2  2560.4  2705.4   120.4743
      3452 860.10  1910.3  2622.2  2794.7   124.2232
      3453 860.27  1956.6  2666.0  2822.5   122.0554
      3454 860.45  1851.4  2571.8  2705.4   118.5333
      3455 860.62  1849.3  2579.6  2745.5   122.7145
      3456 860.79  1914.9  2572.2  2779.9   131.5888
      3457 860.97  1904.6  2629.6  2807.4   124.5198
      3458 861.14  1813.3  2527.2  2675.1   120.7114
      3459 861.31  1849.3  2526.0  2725.4   129.4794
      3460 861.48  1885.4  2563.2  2752.5   127.9154
      3461 861.66  1779.7  2502.6  2679.2   124.4193
      3462 861.83  1788.7  2493.2  2649.3   122.1512
      3463 862.00  1794.8  2468.2  2625.9   123.4185
      3464 862.17  1813.3  2481.7  2665.6   127.5123
      3465 862.35  1950.1  2657.0  2781.1   117.5550
      3466 862.52  1855.5  2487.9  2663.2   127.7202
      3467 862.69  1828.4  2489.1  2662.8   126.2864
      3468 862.87  1888.6  2573.9  2771.3   128.8105
      3469 863.04  1943.5  2626.7  2773.4   121.4628
      3470 863.21  1762.9  2495.7  2634.5   118.9491
      3471 863.38  1807.5  2464.1  2622.6   124.1422
      3472 863.56  1938.6  2603.4  2762.7   123.9680
      3473 863.73  1852.6  2520.2  2691.4   125.6442
      3474 863.90  1838.3  2476.8  2615.3   121.6806
      3475 864.07  1898.5  2565.3  2751.7   127.9484
      3476 864.25  2016.4  2699.2  2853.6   122.6155
      3477 864.42  1825.1  2519.4  2670.1   121.7109
      3478 864.59  1776.4  2412.5  2592.7   128.3323
      3479 864.76  1764.1  2377.3  2614.8   138.7442
      3480 864.94  1944.3  2625.9  2780.7   122.7163
      3481 865.11  1841.1  2511.6  2624.7   116.8601
      3482 865.28  1752.7  2414.1  2573.1   124.0248
      3483 865.45  1842.4  2469.9  2630.0   125.5222
      3484 865.63  1877.2  2505.9  2677.1   127.2313
      3485 865.80  1832.5  2480.5  2622.2   121.8710
      3486 865.97  1777.6  2500.6  2602.1   114.0510
      3487 866.14  1765.3  2411.7  2541.5   120.0887
      3488 866.32  1950.9  2531.3  2706.6   130.2047
      3489 866.49  1829.7  2488.7  2608.3   118.1479
      3490 866.66  1909.5  2576.8  2702.9   118.9073
      3491 866.83  1820.6  2449.0  2668.1   134.8761
      3492 867.01  1830.5  2528.0  2669.7   120.3171
      3493 867.18  1852.2  2475.6  2659.1   129.4350
      3494 867.35  1755.1  2395.7  2528.0   120.6522
      3495 867.52  1760.8  2390.8  2521.5   120.7412
      3496 867.70  1964.4  2587.8  2724.6   121.9448
      3497 867.87  2018.5  2621.0  2795.5   128.9599
      3498 868.04  1761.3  2315.8  2518.2   136.4845
      3499 868.21  1787.5  2418.7  2537.0   118.7541
      3500 868.38  1901.3  2517.8  2693.5   128.5050
      3501 868.56  1977.9  2595.2  2736.5   122.8932
      3502 868.73  1809.2  2472.3  2587.8   117.4182
      3503 868.90  1761.7  2371.5  2461.2   114.7079
      3504 869.07  1896.8  2446.1  2625.5   132.6622
      3505 869.24  1915.3  2561.2  2668.1   116.5504
      3506 869.42  1861.2  2486.2  2601.7   118.4797
      3507 869.59  1839.5  2473.1  2647.6   127.5372
      3508 869.76  2019.3  2588.2  2734.4   125.7019
      3509 869.93  1851.0  2463.7  2580.0   118.9840
      3510 870.11  1947.2  2566.1  2729.5   126.4064
      3511 870.28  1859.6  2419.9  2558.3   124.7076
      3512 870.45  1987.8  2604.2  2706.6   116.6113
      3513 870.62  1908.3  2507.9  2686.5   129.7814
      3514 870.79  1819.0  2410.0  2537.4   121.5523
      3515 870.97  1880.9  2466.6  2617.7   125.8042
      3516 871.14  1959.5  2532.1  2692.7   128.0401
      3517 871.31  1942.7  2498.9  2681.2   132.7688
      3518 871.48  1826.0  2398.2  2530.9   123.1926
      3519 871.65  1974.2  2540.3  2675.5   123.8784
      3520 871.82  2014.0  2603.0  2719.3   119.7497
      3521 872.00  1907.1  2489.9  2628.0   123.6824
      3522 872.17  1833.8  2357.6  2545.2   135.8092
      3523 872.34  1869.4  2443.6  2557.1   119.7575
      3524 872.51  1880.4  2446.9  2582.9   124.0058
      3525 872.68  1933.3  2499.3  2643.9   125.5427
      3526 872.86  1917.3  2471.9  2601.3   123.3383
      3527 873.03  1799.3  2406.4  2509.6   117.0040
      3528 873.20  1901.3  2442.0  2587.0   126.8182
      3529 873.37  2063.9  2676.7  2816.0   122.7273
      3530 873.54  1775.6  2309.7  2500.6   135.7362
      3531 873.71  1818.2  2418.7  2526.8   118.0082
      3532 873.89  2063.1  2613.2  2691.4   114.2219
      3533 874.06  1918.1  2487.9  2639.4   126.5996
      3534 874.23  1789.9  2388.3  2481.7   115.6057
      3535 874.40  1865.3  2463.7  2570.2   117.7960
      3536 874.57  2027.5  2561.2  2682.4   122.7168
      3537 874.74  1887.4  2437.9  2576.3   125.1488
      3538 874.92  1829.2  2353.5  2491.6   126.3281
      3539 875.09  1760.4  2297.8  2445.7   127.5152
      3540 875.26  1966.5  2513.3  2637.4   122.6966
      3541 875.43  1929.2  2482.1  2629.6   126.6667
      3542 875.60  1807.5  2377.3  2503.0   122.0705
      3543 875.77  1871.8  2406.4  2510.4   119.4636
      3544 875.95  1834.2  2369.1  2469.0   118.6830
      3545 876.12  1943.9  2436.7  2554.2   123.8570
      3546 876.29  1769.4  2293.3  2428.1   125.7232
      3547 876.46  1872.3  2439.9  2582.1   125.0361
      3548 876.63  1848.5  2421.9  2513.7   116.0000
      3549 876.80  1910.8  2454.3  2557.1   118.9148
      3550 876.97  1959.9  2458.0  2602.1   128.9474
      3551 877.15  1805.5  2326.5  2456.3   124.9214
      3552 877.32  1975.1  2518.2  2596.8   114.4796
      3553 877.49  1841.1  2382.6  2501.0   121.8608
      3554 877.66  1967.7  2505.1  2650.5   127.0579
      3555 877.83  1864.1  2371.5  2549.3   135.0282
      3556 878.00  1839.1  2354.3  2467.8   122.0191
      3557 878.17  2049.6  2622.6  2677.9   109.6497
      3558 878.34  1811.6  2350.7  2456.7   119.6809
      3559 878.52  1898.9  2372.8  2541.9   135.6958
      3560 878.69  1930.0  2426.8  2530.5   120.8574
      3561 878.86  1805.5  2300.7  2419.1   123.9041
      3562 879.03  1778.5  2306.8  2419.1   121.2403
      3563 879.20  1829.7  2308.5  2445.3   128.5714
      3564 879.37  1889.5  2453.1  2531.3   113.8808
      3565 879.54  2056.6  2597.6  2761.5   130.2801
      3566 879.71  1792.0  2308.1  2414.6   120.6349
      3567 879.89  1841.1  2335.9  2453.5   123.7583
      3568 880.06  1976.3  2473.5  2623.4   130.1483
      3569 880.23  1906.2  2404.7  2527.2   124.5686
      3570 880.40  1935.7  2392.0  2534.6   131.2388
      3571 880.57  1886.6  2362.5  2529.7   135.1119
      3572 880.74  1868.6  2355.6  2491.1   127.8385
      3573 880.91  2016.0  2474.4  2606.2   128.7757
      3574 881.08  1855.9  2335.9  2496.5   133.4471
      3575 881.25  1874.7  2366.2  2508.8   129.0000
      3576 881.42  1955.4  2462.5  2593.1   125.7674
      3577 881.60  1848.5  2384.7  2461.7   114.3621
      3578 881.77  1876.3  2320.8  2451.8   129.4931
      3579 881.94  1765.3  2278.2  2365.0   116.9329
      3580 882.11  1847.3  2319.1  2464.1   130.7292
      3581 882.28  1934.5  2392.8  2544.8   133.1546
      3582 882.45  1847.3  2305.6  2438.3   128.9544
      3583 882.62  1854.6  2349.8  2477.2   125.7237
      3584 882.79  2015.2  2454.3  2548.5   121.4552
      3585 882.96  1895.2  2398.2  2507.1   121.6612
      3586 883.13  1755.5  2299.0  2402.3   118.9902
      3587 883.30  1954.2  2438.7  2521.0   116.9907
      3588 883.48  1893.6  2394.5  2529.7   126.9828
      3589 883.65  1866.9  2344.9  2447.3   121.4225
      3590 883.82  1769.4  2202.4  2357.6   135.8562
      3591 883.99  1803.9  2322.8  2419.1   118.5478
      3592 884.16  1962.8  2460.8  2540.3   115.9539
      3593 884.33  1835.0  2325.3  2429.7   121.3033
      3594 884.50  1822.3  2302.3  2372.0   114.5051
      3595 884.67  1937.4  2364.2  2476.0   126.1996
      3596 884.84  1882.1  2381.4  2488.7   121.4930
      3597 885.01  1863.2  2309.3  2446.9   130.8540
      3598 885.18  1905.8  2354.8  2483.0   128.5584
      3599 885.35  1759.2  2264.2  2351.9   117.3560
      3600 885.52  1804.3  2229.8  2331.4   123.8691
      3601 885.69  1885.4  2352.3  2472.3   125.7018
      3602 885.87  1818.6  2297.0  2406.4   122.8596
      3603 886.04  1820.2  2334.3  2421.9   117.0518
      3604 886.21  1928.0  2383.4  2470.7   119.1547
      3605 886.38  1966.5  2415.0  2553.8   130.9589
      3606 886.55  1838.7  2274.1  2394.9   127.7516
      3607 886.72  1834.6  2303.6  2416.6   124.1048
      3608 886.89  1966.5  2391.2  2496.9   124.8795
      3609 887.06  1880.9  2335.5  2423.6   119.3694
      3610 887.23  1865.7  2310.5  2405.1   121.2707
      3611 887.40  1924.7  2362.1  2508.4   133.4270
      3612 887.57  1894.4  2350.7  2454.3   122.7110
      3613 887.74  1944.3  2388.3  2505.9   126.4760
      3614 887.91  1774.4  2194.2  2342.9   135.4146
      3615 888.08  1794.8  2244.2  2310.5   114.7675
      3616 888.25  1922.2  2377.7  2519.4   131.1151
      3617 888.42  2030.4  2496.9  2563.6   114.3108
      3618 888.59  1792.8  2218.0  2366.2   134.8748
      3619 888.76  1840.7  2266.3  2395.7   130.4139
      3620 888.93  1887.8  2302.3  2405.5   124.9012
      3621 889.10  1810.4  2229.8  2350.2   128.7109
      3622 889.27  1838.7  2239.2  2355.2   128.9366
      3623 889.44  1897.6  2287.6  2408.4   130.9874
      3624 889.61  1856.7  2304.4  2419.9   125.8005
      3625 889.78  1928.4  2322.4  2439.5   129.7297
      3626 889.95  1887.4  2324.4  2418.2   121.4620
      3627 890.12  1853.0  2313.0  2377.7   114.0695
      3628 890.29  1986.9  2356.4  2475.2   132.1508
      3629 890.46  1878.4  2280.2  2385.5   126.1978
      3630 890.63  1790.7  2189.7  2282.3   123.2033
      3631 890.80  1844.0  2260.5  2368.3   125.8604
      3632 890.97  1860.0  2281.8  2356.4   117.6699
      3633 891.15  1902.2  2344.9  2429.3   119.0564
      3634 891.32  1864.1  2253.2  2338.4   121.8947
      3635 891.49  1863.2  2295.8  2374.4   118.1818
      3636 891.66  2029.5  2425.6  2524.7   125.0259
      3637 891.83  1876.3  2309.7  2444.9   131.1909
      3638 892.00  1882.9  2270.4  2361.7   123.5729
      3639 892.17  1952.5  2333.9  2476.0   137.2718
      3640 892.34  1913.2  2334.3  2406.0   117.0233
      3641 892.51  1946.0  2351.1  2483.8   132.7604
      3642 892.68  1853.8  2264.2  2392.0   131.1377
      3643 892.84  1788.7  2208.5  2337.6   130.7317
      3644 893.01  1796.1  2174.1  2292.5   131.3109
      3645 893.18  1940.2  2331.4  2395.7   116.4398
      3646 893.35  1936.6  2359.7  2459.2   123.5237
      3647 893.52  1776.4  2143.8  2270.4   134.4482
      3648 893.69  1984.5  2397.8  2501.4   125.0743
      
      $metadata
       [1] "hugo"                "2016-03-16 13:18:31" "USB4000"            
       [4] "USB4C00008"          "200"                 "200"                
       [7] "200"                 "5"                   "5"                  
      [10] "5"                   "0"                   "0"                  
      [13] "0"                  
      

---

    Code
      lr_parse_procspec(test.file("procspec_files", "OceanOptics_Windows.ProcSpec"),
      verify_checksum = TRUE)
    Output
      $data
               wl      dark       white       scope  processed
      1    190.94 -22.51770   -27.01060  -35.226181  282.85714
      2    191.32 -22.51770   -27.01060  -35.226181  282.85714
      3    191.70 -22.51770   -27.01060  -35.226181  282.85714
      4    192.07 -24.14132   -21.40175  -22.089660   74.88980
      5    192.45 -18.97527     0.29565  -29.764931  -55.98932
      6    192.83   4.49334    -1.62317   22.043144 -286.92505
      7    193.21   3.16493    -0.14715    6.397400  -97.59622
      8    193.59  12.02101    32.32514   22.485948   51.54092
      9    193.96   2.27932    15.49859   14.663076   93.67958
      10   194.34  13.34942    19.18862   24.847569  196.91306
      11   194.72  -4.51034    -6.93682   14.220272 -771.92627
      12   195.10  22.50071     1.32886    6.692603   74.66568
      13   195.48  10.84020    11.07055   20.124326 4030.48544
      14   195.85   1.09851    11.66095   15.548684  136.80711
      15   196.23  -1.41071    11.66095   16.877096  139.90419
      16   196.61  16.15385    -3.24678    4.626184   59.41902
      17   196.99  -3.32953    13.28457   10.235036   81.64491
      18   197.37 -14.10443     8.85653    5.954596   87.36145
      19   197.74 -24.14132    -7.52722  -16.923613   43.44326
      20   198.12  -6.13395    -6.34641  -17.071214 5148.00000
      21   198.50 -18.23727    -4.13239   11.268245  209.18662
      22   198.88  -4.06754    -0.29476   -5.410708  -35.60166
      23   199.25 -17.35166    -4.27999  -11.314762   46.18306
      24   199.63   4.78855    -9.59364   -8.510336   92.46773
      25   200.01 -25.17453    14.17018  -10.429154   37.47741
      26   200.39 -27.53615    16.82700  -17.809221   21.92569
      27   200.76 -14.69483    35.71997  -21.056451  -12.61855
      28   201.14  -6.57676    21.99305  -10.724356  -14.51742
      29   201.52 -30.04537    41.91923  -29.322127    1.00500
      30   201.90 -27.83135    36.60558   -8.657937   29.75532
      31   202.27 -12.03801    27.30670  -12.938377   -2.28841
      32   202.65  -9.82399    17.71261  -19.432836  -34.89483
      33   203.03  -2.88672    15.35099  -21.646856 -102.86450
      34   203.40  -1.55831    20.81224   -0.244660    5.87224
      35   203.78 -19.12287    33.35835  -17.809221    2.50309
      36   204.16 -11.89041    21.10744   -8.067532   11.58523
      37   204.54 -15.13764    26.12589    0.788549   38.59628
      38   204.91  -8.34797     8.41372  -20.318444  -71.41561
      39   205.29 -26.06014    29.66832  -19.432836   11.89213
      40   205.67 -19.27047    21.84545  -11.167160   19.70846
      41   206.04 -11.74281     7.82332   -3.196687   43.67813
      42   206.42 -18.08966     1.77166   -1.868275   81.67323
      43   206.80 -24.58412    12.25136  -20.761248   10.37824
      44   207.18 -17.05645    29.07791   -0.687464   35.48112
      45   207.55 -35.21142    38.81960  -16.776012   24.90227
      46   207.93 -43.32949    16.82700  -14.561992   47.82111
      47   208.31 -28.71696    32.17754   -4.525100   39.72750
      48   208.68 -17.79446    24.35467   -8.362735   22.37704
      49   209.06 -14.54723    34.09636  -21.204052  -13.68489
      50   209.44 -41.41068    21.99305  -19.137633   35.12892
      51   209.81 -14.39963    33.94876  -16.628410   -4.60983
      52   210.19 -21.04169    27.30670  -27.550910  -13.46316
      53   210.57 -22.96051    23.76426  -17.661620   11.34064
      54   210.94  -7.90517    27.15910   -0.539863   21.00517
      55   211.32  -3.77233    47.97089  -25.779694  -42.53188
      56   211.70 -15.72804    35.12957  -29.026924  -26.14925
      57   212.07 -38.75385    43.54285  -30.798140    9.66711
      58   212.45 -22.96051    42.95244  -16.038005   10.50249
      59   212.83 -19.86088    35.86758  -35.521383  -28.10145
      60   213.20 -10.26679    53.57974   -3.787093   10.14887
      61   213.58 -23.69852    36.75318  -34.783377  -18.33672
      62   213.95 -30.19297    74.98193   -5.558309   23.42257
      63   214.33 -27.53615    62.14062  -22.384863    5.74428
      64   214.71 -22.96051    64.35464  -28.584120   -6.44059
      65   215.08 -25.02693    34.53916  -24.008478    1.70978
      66   215.46 -38.16345    77.49116  -19.580437   16.06768
      67   215.84 -20.15608    63.32143  -22.237262   -2.49310
      68   216.21 -37.42544    69.22548    1.231353   36.24609
      69   216.59 -30.63578    70.84910   -7.624728   22.67436
      70   216.96 -36.24463    62.58342  -18.547228   17.90727
      71   217.34 -21.77970    80.00038  -19.137633    2.59586
      72   217.72 -30.34058    76.60555  -19.432836   10.19928
      73   218.09 -19.71328    73.50592   -8.362735   12.17619
      74   218.47 -18.53247   103.91180  -13.823985    3.84541
      75   218.84 -27.97895   101.40258  -21.794458    4.78005
      76   219.22 -23.25571   115.71991  -18.547228    3.38799
      77   219.60 -28.12656   120.44315  -13.381181    9.92489
      78   219.97 -14.54723   134.17008  -21.204052   -4.47616
      79   220.35 -29.60257   130.18484  -17.661620    7.47302
      80   220.72 -41.26308   144.79737   -1.130269   21.56977
      81   221.10 -23.69852   160.44312  -12.938377    5.84340
      82   221.48 -22.51770   161.32872  -11.019559    6.25421
      83   221.85 -30.48818   162.21433  -11.609964    9.79656
      84   222.23 -29.60257   196.60545  -22.384863    3.19074
      85   222.60 -20.59889   206.19954  -16.333208    1.88082
      86   222.98 -45.10071   225.53531  -21.204052    8.82981
      87   223.35 -20.30368   229.66815  -15.890404    1.76551
      88   223.73 -42.44389   242.21426  -21.646856    7.30597
      89   224.10 -23.55091   263.91166  -13.233579    3.58911
      90   224.48 -11.30000   298.89318  -15.595201   -1.38469
      91   224.86 -44.21510   295.79356  -18.990032    7.41895
      92   225.23 -29.30737   340.66437   -8.510336    5.62125
      93   225.61 -32.84980   362.21416  -19.285235    3.43351
      94   225.98 -26.65054   414.02224   -1.720674    5.65723
      95   226.36 -26.79814   436.60524   -0.835066    5.60269
      96   226.73 -17.35166   520.73801   -3.491890    2.57574
      97   227.11 -43.47710   573.87450    0.050542    7.05070
      98   227.48 -26.06014   668.78217    1.083752    3.90648
      99   227.86 -23.99372   812.69349   -3.639492    2.43272
      100  228.23 -25.17453   949.81514  -18.252025    0.71001
      101  228.61 -18.82767  1211.21714   -2.753883    1.30676
      102  228.98 -18.08966  1458.59700    3.297772    1.44834
      103  229.36 -14.25203  1727.37906   17.762704    1.83820
      104  229.73 -13.51402  1909.81433   19.681522    1.72594
      105  230.11 -12.77602  1980.81058   15.991488    1.44300
      106  230.48 -51.74277  1961.32720   24.109563    3.76799
      107  230.86 -30.34058  1845.16494    4.478583    1.85652
      108  231.23  -3.18193  1705.53406   28.980407    1.88225
      109  231.61 -29.45497  1550.84785    6.692603    2.28738
      110  231.98 -17.20406  1415.05460   21.452738    2.69901
      111  232.36 -37.42544  1310.25764    7.430610    3.32838
      112  232.73 -14.25203  1235.71896   -3.787093    0.83721
      113  233.11 -23.69852  1153.06220    6.102198    2.53244
      114  233.48 -28.86456  1103.76335   -0.097059    2.53989
      115  233.86 -27.68375  1063.76339   14.515475    3.86636
      116  234.23 -33.58781  1083.39437    5.806995    3.52690
      117  234.60 -19.27047  1083.39437    7.283008    2.40812
      118  234.98  -9.08598  1115.57146   13.482265    2.00668
      119  235.35 -30.04537  1108.63420    8.168617    3.35599
      120  235.73 -20.74649  1122.80393    4.773786    2.23167
      121  236.10  -9.97159  1112.02903   -5.558309    0.39334
      122  236.48 -14.99004  1108.78180    7.725813    2.02139
      123  236.85 -28.86456  1078.22832   11.563448    3.65173
      124  237.23 -27.68375  1049.59366   18.205508    4.25974
      125  237.60 -13.80922  1002.50883   -2.458681    1.11683
      126  237.97 -14.69483   972.10295   -2.163478    1.26990
      127  238.35 -12.92362   978.89261   12.449056    2.55820
      128  238.72 -23.10811   970.77454   -3.491890    1.97370
      129  239.10 -26.20774   965.46089   -7.477127    1.88880
      130  239.47 -24.73172   977.56420   -1.720674    2.29583
      131  239.85 -18.68007   980.95903   -2.015877    1.66702
      132  240.22 -32.84980  1006.78926   -7.034323    2.48312
      133  240.59 -19.12287  1043.54200    7.135407    2.47098
      134  240.97 -14.39963  1107.15818    7.578211    1.95958
      135  241.34 -40.82027  1194.68579   21.157536    5.01639
      136  241.72 -24.28892  1340.07312    8.021015    2.36814
      137  242.09 -11.30000  1455.34977   21.747941    2.25329
      138  242.46 -20.45129  1618.89207    9.054225    1.79984
      139  242.84 -30.48818  1707.89568   18.353110    2.80958
      140  243.21 -24.73172  1793.94727   40.345711    3.57828
      141  243.59 -22.51770  1800.14653   22.485948    2.46911
      142  243.96 -17.05645  1707.30528   19.238718    2.10485
      143  244.33  -7.75757  1619.63008   28.980407    2.25748
      144  244.71 -11.59520  1470.70031    0.788549    0.83544
      145  245.08 -19.27047  1329.74102   21.305137    3.00780
      146  245.45 -16.90885  1277.93295   17.467502    2.65487
      147  245.83 -44.80551  1263.17281    9.201826    4.12907
      148  246.20 -30.63578  1341.40153   18.205508    3.55976
      149  246.57 -13.07122  1516.60433   19.533921    2.13151
      150  246.95 -31.81659  1766.93622    8.759022    2.25576
      151  247.32  -3.91993  1990.99508   30.899225    1.74540
      152  247.70 -37.42544  2208.85467   40.493313    3.46879
      153  248.07 -30.04537  2326.34535   40.493313    2.99351
      154  248.44 -23.99372  2341.25308   41.674123    2.77636
      155  248.82 -21.04169  2246.49301   55.843853    3.39071
      156  249.19 -16.02324  2122.65548   45.068954    2.85654
      157  249.56 -13.80922  1931.51173   14.367873    1.44845
      158  249.94 -21.92730  1742.72960   23.076353    2.55028
      159  250.31 -21.77970  1587.45298   -2.311079    1.20981
      160  250.68 -46.72433  1469.81470    4.035779    3.34710
      161  251.05 -37.72064  1436.16160    9.644630    3.21364
      162  251.43 -20.74649  1437.93281   28.390002    3.36856
      163  251.80 -23.84612  1481.77041   14.072671    2.51849
      164  252.17 -32.55460  1605.60795   38.722096    4.35101
      165  252.55 -14.99004  1713.65214   14.515475    1.70686
      166  252.92 -18.08966  1775.34950   26.028380    2.45997
      167  253.29 -20.15608  1819.77751   38.869698    3.20804
      168  253.67 -24.43652  1857.26825   42.264529    3.54471
      169  254.04 -24.58412  1834.39004   21.009934    2.45265
      170  254.41 -10.41439  1787.45281   18.795914    1.62472
      171  254.78  -5.69115  1727.82187   19.829123    1.47217
      172  255.16  -8.93838  1690.77393   26.618786    2.09195
      173  255.53 -15.28524  1728.41227   28.390002    2.50475
      174  255.90 -17.05645  1783.17237   41.674123    3.26240
      175  256.28  -8.34797  1877.04683   22.485948    1.63541
      176  256.65 -23.99372  1981.54859   35.032063    2.94313
      177  257.02 -24.28892  2105.53372   35.770069    2.81991
      178  257.39 -28.27416  2339.92467   50.382603    3.32137
      179  257.77 -23.84612  2581.54808   50.235002    2.84337
      180  258.14  -8.79078  2850.77295   77.098448    3.00358
      181  258.51 -16.17085  3208.85383   61.600306    2.41149
      182  258.88 -36.39223  3685.01579   72.818008    2.93465
      183  259.26 -25.61733  4292.54295  110.161150    3.14436
      184  259.63 -21.77970  4942.43170  121.526454    2.88679
      185  260.00 -26.79814  5860.21690  136.138988    2.76774
      186  260.37 -31.52139  6610.17937  135.548583    2.51547
      187  260.75 -26.65054  7162.94643  148.832704    2.44079
      188  261.12 -18.08966  7275.12345  160.936015    2.45469
      189  261.49 -22.22250  7189.80987  154.884360    2.45571
      190  261.86 -26.79814  6682.06122  153.113144    2.68170
      191  262.23 -21.18929  6175.64099  145.733076    2.69367
      192  262.61 -48.20034  5579.18393  111.489563    2.83773
      193  262.98 -19.56568  5203.09568  114.293988    2.56305
      194  263.35 -31.66899  4879.70112  120.345644    3.09516
      195  263.72   0.50811  4695.49464  119.607637    2.53674
      196  264.09 -34.62102  4560.43940  115.622400    3.26967
      197  264.47 -26.94574  4483.68670  103.666691    2.89566
      198  264.84 -36.09703  4454.60923   87.873346    2.76060
      199  265.21 -26.35534  4389.66464   92.153786    2.68362
      200  265.58 -28.56936  4462.43210  101.157468    2.88859
      201  265.95 -19.12287  4570.03349  103.961894    2.68208
      202  266.33 -18.23727  4782.28423   97.319833    2.40718
      203  266.70 -20.00848  5049.44268  117.688819    2.71622
      204  267.07 -25.02693  5281.02920  119.164833    2.71749
      205  267.44 -20.15608  5547.59724  121.674056    2.54735
      206  267.81 -28.56936  5745.23545  137.172198    2.87058
      207  268.18 -28.86456  5834.82947  130.972941    2.72588
      208  268.56 -26.20774  5916.45301  127.135306    2.58038
      209  268.93 -26.50294  5892.98440  114.146387    2.37604
      210  269.30 -19.41808  5916.60062  136.138988    2.62056
      211  269.67 -24.14132  5951.72974  136.138988    2.68212
      212  270.04 -23.25571  5966.34227  146.175880    2.82876
      213  270.41 -14.25203  6176.52660  138.353008    2.46504
      214  270.79 -35.35902  6454.90274  141.600238    2.72654
      215  271.16 -20.15608  6913.35254  157.393583    2.56075
      216  271.53 -21.63210  7408.11227  167.135272    2.54070
      217  271.90 -30.19297  7936.37751  177.762569    2.61035
      218  272.27 -19.71328  8375.04872  176.729360    2.34006
      219  272.64 -21.92730  8529.43974  193.851117    2.52332
      220  273.01 -25.91254  8501.24788  199.459968    2.64300
      221  273.38 -40.22987  8327.07829  183.961826    2.67938
      222  273.76 -18.97527  8107.59508  185.733042    2.51900
      223  274.13 -18.38487  7767.66916  197.541150    2.77324
      224  274.50  -9.82399  7549.80957  186.618650    2.59857
      225  274.87 -19.41808  7223.75818  184.995036    2.82215
      226  275.24 -29.45497  7098.88744  160.640813    2.66676
      227  275.61 -13.95683  7047.07937  164.035644    2.52077
      228  275.98 -20.45129  7079.10886  141.747840    2.28464
      229  276.35  -6.28156  7198.07555  174.072536    2.50340
      230  276.72 -22.51770  7266.26737  171.710914    2.66476
      231  277.09 -19.27047  7405.89825  161.821623    2.43890
      232  277.47 -31.22618  7504.79116  182.633414    2.83783
      233  277.84 -20.45129  7660.51058  177.467367    2.57674
      234  278.21 -20.15608  7618.44420  170.825306    2.50021
      235  278.58 -22.22250  7605.16008  169.349292    2.51163
      236  278.95 -17.49926  7514.09004  188.832671    2.73955
      237  279.32 -12.62841  7467.59562  174.367738    2.49987
      238  279.69  -1.85352  7485.01258  172.153718    2.32417
      239  280.06 -23.55091  7569.29295  175.400948    2.62025
      240  280.43 -30.78338  7605.60288  164.921252    2.56279
      241  280.80 -31.37379  7902.57680  190.308684    2.79410
      242  281.17 -13.95683  8095.34416  188.094664    2.49160
      243  281.54 -24.14132  8442.65014  211.120475    2.77864
      244  281.91 -17.05645  8857.70514  216.138921    2.62762
      245  282.28 -26.35534  9206.92994  226.766218    2.74140
      246  282.65 -13.21882  9487.07731  214.810508    2.40023
      247  283.02  -8.05277  9684.71551  220.271758    2.35562
      248  283.39 -23.99372  9648.25798  223.223786    2.55595
      249  283.76 -18.68007  9550.25068  217.467333    2.46786
      250  284.13  -5.24835  9491.21014  231.046657    2.48824
      251  284.50 -39.04906  9488.70092  245.511590    2.98665
      252  284.87 -24.73172  9396.74528  230.161049    2.70544
      253  285.25 -26.50294  9641.17312  238.721927    2.74342
      254  285.62 -33.29260  9832.16926  250.234833    2.87394
      255  285.99 -23.69852 10139.18008  246.101995    2.65476
      256  286.36 -19.56568 10362.50092  249.644427    2.59303
      257  286.73 -18.97527 10564.41957  263.814157    2.67201
      258  287.10 -37.13024 10609.29038  270.161015    2.88633
      259  287.47 -17.64686 10594.38264  262.190542    2.63698
      260  287.83 -23.10811 10415.48981  264.109360    2.75149
      261  288.20 -29.15977 10147.15055  269.127806    2.93120
      262  288.57 -17.05645  9912.75960  251.415644    2.70370
      263  288.94 -22.07490  9576.67133  242.559563    2.75697
      264  289.31 -38.60625  9480.87805  246.544799    2.99545
      265  289.68 -34.91622  9498.88541  239.312333    2.87638
      266  290.05 -20.00848  9703.31329  240.788346    2.68218
      267  290.42 -13.36642  9952.02156  275.769867    2.90141
      268  290.79 -15.58044 10244.86264  256.138887    2.64822
      269  291.16 -22.66531 10510.54508  255.991286    2.64550
      270  291.53 -38.60625 10584.64095  260.714529    2.81760
      271  291.90 -30.93098 10493.12812  285.363954    3.00545
      272  292.27 -20.30368 10484.86244  268.389799    2.74811
      273  292.64 -25.32213 10158.95866  272.965441    2.92890
      274  293.01 -32.11179  9925.60092  258.943313    2.92291
      275  293.38  -9.38118  9948.47913  287.135171    2.97771
      276  293.75 -24.14132  9904.93673  266.913786    2.93134
      277  294.12 -38.16345 10061.98457  262.042941    2.97230
      278  294.49 -28.27416 10316.00649  277.541083    2.95637
      279  294.86 -26.79814 10661.24606  308.389765    3.13610
      280  295.23 -25.46973 11021.83616  306.028144    3.00071
      281  295.59 -19.27047 11205.30464  297.319664    2.82051
      282  295.96 -24.14132 11411.79893  307.946961    2.90390
      283  296.33 -15.87564 11686.78024  333.039191    2.98150
      284  296.70  -4.51034 11975.48849  350.898954    2.96669
      285  297.07 -26.50294 12206.63220  337.024427    2.97166
      286  297.44 -33.44020 12577.70200  363.592671    3.14827
      287  297.81 -29.75017 12641.46579  365.216286    3.11704
      288  298.18 -13.21882 12616.37356  383.518853    3.14133
      289  298.55   1.09851 12439.39954  377.762400    3.02826
      290  298.92 -29.60257 12076.44781  356.360204    3.18818
      291  299.29 -31.37379 11509.51102  334.367603    3.16909
      292  299.65 -26.65054 11156.89139  324.478313    3.13969
      293  300.02 -34.32581 10636.00622  307.504157    3.20356
      294  300.39 -23.55091 10410.76656  309.718177    3.19397
      295  300.76 -41.41068 10016.96616  315.474630    3.54814
      296  301.13 -19.12287  9734.01437  307.799360    3.35197
      297  301.50 -14.10443  9512.16954  289.791995    3.19009
      298  301.87  -7.31477  9371.35785  288.168380    3.15059
      299  302.23 -26.50294  9373.12906  288.758786    3.35398
      300  302.60 -19.41808  9257.70481  282.707130    3.25667
      301  302.97 -24.73172  9058.29538  274.736657    3.29701
      302  303.34 -22.66531  8901.83795  299.238481    3.60697
      303  303.71 -24.14132  8772.83437  292.596421    3.60053
      304  304.08 -12.03801  8531.80136  274.736657    3.35651
      305  304.45  -0.82031  8328.99710  283.592738    3.41440
      306  304.81 -26.94574  8171.35886  269.718211    3.61860
      307  305.18 -16.61365  8163.97879  258.943313    3.36842
      308  305.55 -31.66899  8117.48437  253.186860    3.49553
      309  305.92 -12.92362  8121.46960  275.769867    3.54905
      310  306.29 -31.52139  7986.11916  243.740373    3.43320
      311  306.66 -22.37010  7955.12288  242.264360    3.31726
      312  307.02 -25.17453  7999.40329  265.290171    3.61969
      313  307.39 -29.60257  8036.15602  265.290171    3.65611
      314  307.76 -22.66531  8071.43274  265.142569    3.55577
      315  308.13 -33.73541  8211.65403  279.902704    3.80380
      316  308.50 -19.41808  8315.56538  285.806758    3.66197
      317  308.86 -26.79814  8542.87146  289.053988    3.68570
      318  309.23 -25.91254  8745.08531  281.083515    3.50013
      319  309.60 -20.15608  8863.75680  303.223718    3.64006
      320  309.97  -0.37750  9005.89690  293.482029    3.26283
      321  310.33 -17.35166  9108.18464  299.828887    3.47575
      322  310.70 -16.61365  9085.15883  315.917434    3.65348
      323  311.07 -22.22250  9190.54619  315.474630    3.66553
      324  311.44 -18.97527  9238.66423  325.363921    3.71951
      325  311.81 -32.99740  9205.45393  314.441421    3.76079
      326  312.17 -23.25571  9080.87839  314.441421    3.70927
      327  312.54 -23.10811  8956.00764  328.315948    3.91379
      328  312.91 -35.50662  8901.39514  313.851015    3.90916
      329  313.28 -34.03061  8575.93416  315.179427    4.05588
      330  313.64 -17.05645  8413.57268  301.600103    3.77975
      331  314.01 -17.20406  8370.76829  301.304900    3.79721
      332  314.38 -28.71696  8450.47301  295.105644    3.81903
      333  314.75 -23.84612  8519.25524  297.467265    3.76109
      334  315.11 -35.06382  8635.12231  312.079799    4.00388
      335  315.48 -32.11179  8586.85666  313.113008    4.00541
      336  315.85 -21.92730  8535.78660  294.072434    3.69257
      337  316.22 -32.25939  8416.67231  294.515238    3.86764
      338  316.58 -22.66531  8162.65038  307.061353    4.02827
      339  316.95 -12.18561  7791.28538  281.969123    3.76954
      340  317.32 -21.92730  7719.55112  287.577975    3.99801
      341  317.68 -28.56936  7503.75795  282.411927    4.12862
      342  318.05 -19.41808  7367.66950  268.389799    3.89609
      343  318.42 -22.66531  7422.13440  277.688684    4.03441
      344  318.79 -26.94574  7362.79866  273.260644    4.06247
      345  319.15 -30.48818  7303.75812  281.378718    4.25220
      346  319.52 -27.68375  7406.04585  267.946995    3.97688
      347  319.89 -42.88669  7392.76173  254.810475    4.00365
      348  320.25 -21.18929  7354.82818  278.721894    4.06603
      349  320.62 -40.52507  7308.92416  259.828921    4.08676
      350  320.99 -30.04537  7270.54781  277.541083    4.21317
      351  321.35 -34.32581  7034.23805  244.330779    3.94220
      352  321.72 -21.77970  7052.09781  254.072468    3.89959
      353  322.09 -17.49926  7087.22693  271.932231    4.07379
      354  322.45 -10.56199  7015.04987  279.164698    4.12386
      355  322.82 -28.27416  7063.31551  249.496826    3.91691
      356  323.19 -30.93098  7386.85768  292.744022    4.36350
      357  323.55 -30.93098  7583.01987  289.496792    4.20843
      358  323.92 -30.63578  7844.86467  294.662840    4.13051
      359  324.29 -27.24095  8122.79801  293.186826    3.93161
      360  324.65 -41.55828  8429.66122  307.946961    4.12580
      361  325.02 -31.37379  8484.86413  329.791961    4.24091
      362  325.39 -24.73172  8536.08180  338.352840    4.24124
      363  325.75 -30.19297  8515.56521  318.426657    4.07945
      364  326.12 -30.34058  8509.95636  343.961691    4.38278
      365  326.49 -14.99004  8378.73876  314.293819    3.92297
      366  326.85 -14.54723  8307.15210  323.592704    4.06335
      367  327.22 -14.10443  8248.70197  335.843617    4.23522
      368  327.59  -4.95314  8043.38849  326.397130    4.11700
      369  327.95 -13.95683  7857.55839  302.485711    4.02010
      370  328.32 -12.62841  7607.22649  295.991252    4.05020
      371  328.68 -17.94206  7382.57724  305.290137    4.36770
      372  329.05 -34.76862  7117.78041  280.345508    4.40562
      373  329.42 -31.81659  6898.88761  289.053988    4.62970
      374  329.78 -21.63210  6806.48916  270.456218    4.27773
      375  330.15 -26.06014  6927.52227  277.098279    4.35974
      376  330.51 -31.52139  7037.78048  289.496792    4.54102
      377  330.88 -18.53247  7060.65869  304.109326    4.55761
      378  331.25 -19.27047  7139.33021  283.887941    4.23488
      379  331.61 -25.61733  7239.99433  298.943279    4.46708
      380  331.98 -17.49926  7305.82454  299.828887    4.33312
      381  332.34  -2.14872  7404.86504  296.286454    4.02909
      382  332.71 -12.18561  7595.41839  297.910069    4.07613
      383  333.07 -11.44760  7789.21896  302.633313    4.02633
      384  333.44  -8.64318  7937.70592  325.216319    4.20142
      385  333.81 -12.62841  8122.50281  337.319630    4.30169
      386  334.17 -24.28892  8301.98606  339.238448    4.36603
      387  334.54 -26.65054  8279.84585  333.777198    4.33911
      388  334.90 -22.81291  8279.69825  335.400813    4.31452
      389  335.27  -7.31477  8247.07835  360.197840    4.45233
      390  335.63 -25.76493  8297.41041  342.042873    4.41908
      391  336.00 -18.23727  8089.58771  336.876826    4.37989
      392  336.36 -24.28892  7981.83872  351.194157    4.68995
      393  336.73 -23.55091  7743.01974  319.459867    4.41650
      394  337.10 -21.63210  7741.98653  325.363921    4.46951
      395  337.46 -31.52139  7677.77994  327.577941    4.65800
      396  337.83 -25.46973  7718.37031  319.607468    4.45615
      397  338.19 -12.18561  7765.75035  314.146218    4.19561
      398  338.56 -30.19297  7793.20420  333.186792    4.64478
      399  338.92 -31.52139  7758.51788  299.238481    4.24593
      400  339.29 -15.13764  7781.39609  318.279056    4.27647
      401  339.65 -30.48818  7761.46991  322.707096    4.53282
      402  340.02 -36.39223  7694.01609  318.426657    4.58991
      403  340.38 -31.07858  7689.29285  309.275373    4.40852
      404  340.75 -24.73172  7639.69879  323.592704    4.54469
      405  341.11 -23.25571  7694.01609  325.659123    4.52122
      406  341.48  -7.75757  7682.20798  329.053954    4.37988
      407  341.84 -22.81291  7768.25957  343.371286    4.70005
      408  342.21 -22.51770  7794.38501  328.906353    4.49569
      409  342.57 -26.35534  7753.35183  338.943245    4.69553
      410  342.94 -24.87933  7871.87572  345.290103    4.68761
      411  343.30 -20.30368  7953.49926  355.179394    4.70896
      412  343.67 -18.82767  8091.35893  350.160948    4.54969
      413  344.03 -34.76862  8250.62079  341.304867    4.53900
      414  344.39 -34.32581  8508.62795  350.013346    4.49890
      415  344.76 -22.51770  8658.59092  386.175677    4.70785
      416  345.12 -44.36270  8928.55379  394.293752    4.88867
      417  345.49 -22.51770  8954.23643  388.832502    4.58239
      418  345.85 -17.49926  9067.88947  384.699664    4.42688
      419  346.22 -37.57304  9205.74913  401.821421    4.75364
      420  346.58 -31.37379  9179.18089  402.707029    4.71286
      421  346.95 -26.50294  9036.45038  387.651691    4.56975
      422  347.31 -35.06382  8794.67937  390.898921    4.82418
      423  347.68 -37.13024  8650.91565  376.433988    4.76015
      424  348.04 -29.30737  8429.80883  372.301150    4.74764
      425  348.40 -25.32213  8296.22960  374.515171    4.80484
      426  348.77 -19.56568  8271.87538  381.157231    4.83297
      427  349.13 -12.92362  8187.74261  364.625880    4.60389
      428  349.50 -18.82767  8229.80899  357.836218    4.56638
      429  349.86   1.83652  8202.65035  379.090813    4.60021
      430  350.22 -17.64686  8247.96396  370.382333    4.69450
      431  350.59  -9.67639  8410.47305  371.710745    4.52946
      432  350.95 -22.51770  8395.56531  360.345441    4.54810
      433  351.32 -32.40699  8553.49876  395.917367    4.98869
      434  351.68 -31.37379  8534.01538  376.286387    4.75939
      435  352.04 -16.02324  8590.54670  380.714427    4.60971
      436  352.41 -30.19297  8656.96731  372.301150    4.63321
      437  352.77 -14.39963  8678.81231  393.112941    4.68771
      438  353.14  -6.72436  8922.05933  413.629529    4.70785
      439  353.50 -18.68007  9059.62379  394.884157    4.55552
      440  353.86 -38.31105  9217.55724  408.463481    4.82693
      441  354.23 -39.04906  9454.45741  405.954258    4.68745
      442  354.59 -30.19297  9662.28011  443.297400    4.88513
      443  354.95 -19.27047  9844.71538  450.382265    4.76129
      444  355.32 -24.73172 10033.34991  436.507738    4.58576
      445  355.68 -31.96419 10271.57849  454.367502    4.72004
      446  356.05 -18.23727 10461.24622  486.987400    4.82108
      447  356.41 -36.98264 10732.83271  474.884090    4.75279
      448  356.77 -13.95683 11130.47075  514.441252    4.74137
      449  357.14 -27.24095 11407.22329  526.544563    4.84313
      450  357.50 -22.51770 11968.99403  544.994731    4.73262
      451  357.86 -35.21142 12354.38116  554.884022    4.76283
      452  358.23 -11.30000 12628.77207  580.714258    4.68363
      453  358.59 -32.99740 12704.04876  554.588819    4.61321
      454  358.95 -13.07122 12775.63541  588.241927    4.70191
      455  359.32 -40.82027 12633.64291  564.920914    4.77923
      456  359.68  -4.80554 12508.77217  576.286218    4.64369
      457  360.04 -13.66162 12412.09329  573.334191    4.72403
      458  360.41 -26.06014 12803.67967  569.791758    4.64430
      459  360.77 -25.61733 13164.12217  628.832299    4.96181
      460  361.13 -35.80183 13840.28396  621.895036    4.73979
      461  361.49 -21.92730 14701.68545  678.721556    4.75867
      462  361.86 -28.27416 15558.65889  699.828549    4.67124
      463  362.22 -19.56568 16175.92774  746.618177    4.73085
      464  362.58 -36.98264 16140.79862  749.865407    4.86376
      465  362.95 -25.17453 16052.82822  750.455813    4.82417
      466  363.31 -26.94574 15520.87295  724.182772    4.83109
      467  363.67 -34.62102 14742.71862  687.282434    4.88521
      468  364.03 -19.71328 13848.99244  654.662536    4.86257
      469  364.40 -27.97895 12923.08916  618.500204    4.99171
      470  364.76 -26.79814 12278.21886  583.075880    4.95630
      471  365.12 -28.56936 11812.83180  582.485475    5.16033
      472  365.49 -23.25571 11382.57386  570.677367    5.20728
      473  365.85 -28.12656 11111.43018  550.751184    5.19660
      474  366.21 -11.89041 10829.80680  536.286252    5.05619
      475  366.57 -24.43652 10727.81426  522.264123    5.08452
      476  366.94 -13.80922 10519.84396  515.326860    5.02329
      477  367.30 -13.07122 10477.33477  497.467096    4.86672
      478  367.66  -8.34797 10503.46021  498.943110    4.82592
      479  368.02 -24.28892 10375.63744  494.810272    4.99137
      480  368.39 -20.59889 10220.36082  511.046421    5.19136
      481  368.75  -9.23358 10086.33879  486.839799    4.91377
      482  369.11 -26.65054  9881.02531  478.721725    5.10082
      483  369.47 -30.78338  9836.15450  493.039056    5.30887
      484  369.83 -35.06382  9725.74869  478.131319    5.25771
      485  370.20 -23.84612  9691.65278  500.714326    5.39921
      486  370.56 -32.40699  9722.20626  510.751218    5.56822
      487  370.92  -9.23358  9828.47923  507.061184    5.24812
      488  371.28 -33.14500  9910.98839  490.087029    5.26172
      489  371.64 -28.86456 10070.25024  510.898819    5.34466
      490  372.01 -18.97527 10073.49747  501.009529    5.15220
      491  372.37 -21.63210 10186.85531  530.086995    5.40451
      492  372.73 -13.07122 10194.08778  532.005813    5.34014
      493  373.09 -26.06014 10122.94393  515.031657    5.33148
      494  373.45 -25.32213 10096.81849  512.817637    5.31646
      495  373.82 -23.69852 10105.96977  501.599934    5.18574
      496  374.18 -15.43284 10086.92920  514.588853    5.24651
      497  374.54 -29.15977 10047.96244  513.850846    5.38855
      498  374.90 -25.91254 10215.34237  532.153414    5.44919
      499  375.26 -21.77970 10379.91788  520.640508    5.21473
      500  375.62 -14.25203 10567.96200  557.098042    5.39915
      501  375.99 -19.56568 10711.57812  547.503954    5.28434
      502  376.35 -26.94574 10977.11295  569.201353    5.41752
      503  376.71 -18.82767 11482.64758  567.577738    5.09852
      504  377.07 -29.45497 11853.71737  587.356319    5.19063
      505  377.43 -27.09335 12380.94940  647.577671    5.43737
      506  377.79 -11.15240 12657.55433  632.522333    5.08082
      507  378.16 -30.48818 12731.05981  649.496488    5.32839
      508  378.52 -14.10443 12759.10406  622.928245    4.98726
      509  378.88 -27.09335 12445.74639  630.603515    5.27303
      510  379.24 -36.24463 12174.60271  614.072164    5.32573
      511  379.60 -27.68375 11846.78011  603.297265    5.31376
      512  379.96 -10.41439 11401.02403  582.485475    5.19566
      513  380.32 -33.29260 11165.00947  594.145981    5.60298
      514  380.68 -22.66531 11052.53724  572.005779    5.36939
      515  381.05 -18.23727 10943.60744  591.193954    5.55957
      516  381.41  -0.52510 10816.07987  610.086927    5.64514
      517  381.77 -26.20774 10899.62224  578.057434    5.53061
      518  382.13 -36.68743 10781.24595  581.157063    5.71130
      519  382.49 -35.35902 10774.75149  566.249326    5.56524
      520  382.85 -33.73541 10854.01342  579.533448    5.63265
      521  383.21 -27.24095 10921.46724  577.319427    5.52175
      522  383.57  -9.23358 11174.60356  579.828650    5.26709
      523  383.93 -36.09703 11346.26393  608.168110    5.66021
      524  384.29 -26.50294 11510.69183  615.400576    5.56377
      525  384.65 -26.35534 11655.78396  619.533414    5.52886
      526  385.02 -31.96419 11680.72859  612.448549    5.50183
      527  385.38 -30.04537 11736.22670  626.323076    5.57839
      528  385.74 -16.46605 11740.65474  650.529698    5.67312
      529  386.10 -37.57304 11876.15278  626.470677    5.57377
      530  386.46 -22.37010 11881.17122  644.478042    5.60210
      531  386.82 -19.56568 12017.99768  658.795373    5.63537
      532  387.18 -11.89041 12172.09349  651.710508    5.44650
      533  387.54 -19.41808 12250.46981  677.835948    5.68264
      534  387.90 -32.55460 12460.21133  693.776894    5.81402
      535  388.26 -18.23727 12493.71683  666.175441    5.47007
      536  388.62 -17.20406 12405.30362  650.234495    5.37282
      537  388.98 -12.92362 12292.83139  667.356252    5.52814
      538  389.34 -26.06014 12306.70592  676.802738    5.69915
      539  389.70 -21.04169 12245.89416  664.847029    5.59136
      540  390.06 -26.35534 12196.30011  663.518617    5.64422
      541  390.42 -39.49186 12148.03447  694.810103    6.02503
      542  390.78 -21.63210 12581.98244  722.854360    5.90693
      543  391.14 -31.22618 12878.51356  700.418954    5.66739
      544  391.50 -20.00848 13174.89707  725.215981    5.64782
      545  391.86 -25.91254 13512.90416  748.684596    5.72131
      546  392.22 -21.92730 13894.01085  757.097873    5.59808
      547  392.58 -10.56199 14024.78565  797.097840    5.75447
      548  392.94 -12.33321 14126.92579  775.105238    5.56916
      549  393.30 -36.83504 13877.18430  775.252840    5.83647
      550  393.66 -20.00848 13817.55335  751.636623    5.57645
      551  394.02 -33.14500 13745.81910  772.891218    5.84976
      552  394.38 -15.87564 13833.19910  775.400441    5.71357
      553  394.74 -19.41808 13935.33923  811.857975    5.95694
      554  395.10 -26.20774 13834.08470  776.581252    5.79201
      555  395.46 -42.59149 13627.14761  763.739934    5.89866
      556  395.82 -20.00848 13396.00389  751.193819    5.74837
      557  396.18  -5.39595 13208.99298  759.607096    5.78917
      558  396.54 -30.04537 12820.80143  754.883853    6.10800
      559  396.90  -8.49558 12513.79062  751.636623    6.07024
      560  397.26  -8.20037 12361.61362  705.437400    5.76919
      561  397.62 -20.89409 12045.59913  720.197536    6.14173
      562  397.98 -29.45497 11993.64345  717.688313    6.21423
      563  398.34 -27.68375 11949.95345  676.212333    5.87675
      564  398.70 -20.89409 11938.14535  702.190171    6.04634
      565  399.06 -20.30368 12015.34085  705.437400    6.02993
      566  399.41 -24.87933 11993.93866  698.352536    6.01750
      567  399.77 -11.44760 11902.72102  690.086860    5.88824
      568  400.13  -6.57676 11921.61399  692.300880    5.85904
      569  400.49 -28.12656 11863.01626  686.544427    6.01011
      570  400.85 -13.36642 11870.39633  719.459529    6.16662
      571  401.21  -7.16716 11803.68051  720.787941    6.16345
      572  401.57 -16.02324 11740.80234  674.736319    5.87539
      573  401.93 -14.39963 11849.58454  702.337772    6.04129
      574  402.29 -21.77970 11872.90555  708.684630    6.14110
      575  402.65  -9.82399 11948.03464  721.673549    6.11730
      576  403.01 -33.58781 12084.27068  725.806387    6.26674
      577  403.36 -33.14500 12352.16714  732.005644    6.17789
      578  403.72 -18.82767 12644.27021  745.142164    6.03304
      579  404.08 -14.84243 12937.40649  771.267603    6.06929
      580  404.44 -22.07490 13185.08156  788.684563    6.13879
      581  404.80 -23.40331 13583.60521  821.599664    6.21006
      582  405.16 -13.07122 13744.49068  836.507400    6.17536
      583  405.52 -24.28892 13939.76727  827.208515    6.09778
      584  405.88 -21.04169 13945.67133  833.998177    6.12198
      585  406.23 -13.66162 13892.38724  835.178988    6.10411
      586  406.59 -12.77602 13546.55727  819.385644    6.13719
      587  406.95 -16.31845 13538.73440  818.942840    6.16199
      588  407.31  -9.38118 13355.70872  799.311860    6.05079
      589  407.67 -14.84243 13265.81950  822.780475    6.30709
      590  408.03 -23.99372 13023.45808  801.378279    6.32592
      591  408.39 -11.15240 12998.07065  803.592299    6.26282
      592  408.74 -22.66531 12840.72761  797.983448    6.37972
      593  409.10 -31.96419 12971.65001  801.525880    6.40968
      594  409.46 -27.38855 13007.66474  810.529563    6.42819
      595  409.82 -29.75017 13261.98187  810.529563    6.32182
      596  410.18 -26.79814 13370.02606  829.274934    6.39012
      597  410.54 -28.71696 13555.56095  832.374563    6.33888
      598  410.89 -25.46973 13707.29514  840.049833    6.30259
      599  411.25 -18.53247 13836.15112  839.607029    6.19386
      600  411.61 -21.04169 13749.50913  857.761995    6.38176
      601  411.97 -18.53247 13616.22511  872.817333    6.53734
      602  412.33 -29.75017 13540.21041  860.418819    6.55985
      603  412.68 -12.62841 13497.40602  842.854258    6.33220
      604  413.04 -15.43284 13278.66082  837.688211    6.41729
      605  413.40 -30.78338 13281.17004  833.850576    6.49517
      606  413.76 -15.72804 13373.86369  838.869022    6.38255
      607  414.12 -42.14868 13396.74190  846.839495    6.61504
      608  414.47 -27.97895 13623.45758  860.714022    6.50989
      609  414.83 -27.83135 13746.11430  875.621758    6.55915
      610  415.19 -31.07858 13803.38362  857.171590    6.42056
      611  415.55 -22.22250 14042.35021  883.001826    6.43620
      612  415.90  -9.97159 14083.82619  873.702941    6.26995
      613  416.26 -11.44760 14323.08798  914.145711    6.45709
      614  416.62  -7.01956 14743.16143  923.444596    6.30815
      615  416.98 -23.55091 14930.02474  943.518380    6.46714
      616  417.33 -17.35166 15286.03920  978.499900    6.50739
      617  417.69 -24.73172 15641.31565 1007.282164    6.58758
      618  418.05 -30.19297 16188.91666 1032.817198    6.55406
      619  418.41 -40.67267 16647.36646 1068.241522    6.64496
      620  418.76 -48.34794 17170.76085 1117.245171    6.76918
      621  419.12 -34.76862 17826.11085 1107.355880    6.39456
      622  419.48 -32.84980 18535.18774 1189.422231    6.58267
      623  419.84 -43.18189 19059.02494 1230.012603    6.66517
      624  420.19 -41.70588 19891.34896 1247.281961    6.46658
      625  420.55 -26.35534 20666.84646 1326.543887    6.53789
      626  420.91 -39.63946 21552.74977 1395.621319    6.64707
      627  421.26 -16.02324 22474.96301 1419.237536    6.38149
      628  421.62 -21.92730 22884.85197 1464.108346    6.48732
      629  421.98 -16.46605 23282.49001 1475.030846    6.40156
      630  422.34 -43.03429 23344.33497 1502.779900    6.60961
      631  422.69  -5.98635 23368.09879 1499.827873    6.44224
      632  423.05 -18.08966 23469.20572 1508.093549    6.49791
      633  423.41  -2.44392 23010.16551 1487.429360    6.47416
      634  423.76  -9.82399 23715.69997 1560.049225    6.61681
      635  424.12 -27.68375 23685.14649 1535.252198    6.59110
      636  424.48 -23.10811 23717.76639 1553.849968    6.64238
      637  424.83 -13.95683 23919.53744 1572.742941    6.62962
      638  425.19 -22.51770 24036.58531 1570.824123    6.62262
      639  425.55 -22.66531 23812.37886 1552.078752    6.60684
      640  425.90 -13.36642 23484.11345 1532.004968    6.57675
      641  426.26 -20.89409 23149.94399 1534.514191    6.71278
      642  426.62 -36.53983 22474.22501 1496.728245    6.81127
      643  426.97 -26.06014 22018.72724 1481.820508    6.84008
      644  427.33 -35.35902 21329.28133 1423.960779    6.83054
      645  427.69 -25.46973 20932.82410 1418.204326    6.88832
      646  428.04 -33.29260 20393.78396 1371.119495    6.87525
      647  428.40  -5.54355 19478.06518 1313.850171    6.77181
      648  428.75 -18.08966 19278.65575 1306.027299    6.86187
      649  429.11 -20.15608 18967.95491 1299.237637    6.94853
      650  429.47 -23.40331 18448.39815 1281.968279    7.06683
      651  429.82 -28.71696 18295.63075 1263.518110    7.05201
      652  430.18  -5.98635 18038.65680 1247.577164    6.94701
      653  430.54 -16.17085 18006.03690 1219.385306    6.85574
      654  430.89 -14.10443 17732.38399 1235.031049    7.03878
      655  431.25 -28.56936 17690.76041 1209.643617    6.98792
      656  431.60 -32.40699 17656.22170 1209.496015    7.02091
      657  431.96 -44.65791 17567.07048 1213.481252    7.14376
      658  432.32 -45.10071 17600.72359 1192.079056    7.01118
      659  432.67 -36.68743 17725.44673 1204.329968    6.98687
      660  433.03 -19.41808 18048.98889 1248.905576    7.01957
      661  433.38 -27.68375 17964.70852 1224.256150    6.95816
      662  433.74 -33.29260 18398.36129 1266.322536    7.05100
      663  434.10 -20.74649 18555.99954 1272.374191    6.96096
      664  434.45 -43.91990 18502.71545 1306.765306    7.28264
      665  434.81 -35.65422 18776.07315 1320.197029    7.20748
      666  435.16 -18.38487 18474.37599 1306.617704    7.16498
      667  435.52 -30.19297 18621.38693 1271.783786    6.98052
      668  435.87 -28.71696 18490.90734 1287.577130    7.10756
      669  436.23  -9.67639 18423.89633 1315.621387    7.18959
      670  436.59 -30.93098 18254.74518 1284.920306    7.19608
      671  436.94 -13.36642 18298.28758 1297.614022    7.15927
      672  437.30 -31.22618 18330.46467 1297.614022    7.23703
      673  437.65 -25.32213 18452.53099 1313.850171    7.24745
      674  438.01 -27.68375 18668.76697 1308.093718    7.14455
      675  438.36 -26.35534 18898.58227 1322.263448    7.12615
      676  438.72 -25.17453 19283.67420 1370.971894    7.23060
      677  439.07 -20.00848 19317.91771 1345.436860    7.06097
      678  439.43 -16.02324 19720.72180 1419.089934    7.27128
      679  439.78 -26.35534 20295.62906 1439.163718    7.21150
      680  440.14 -27.68375 20727.65822 1479.016083    7.25934
      681  440.49 -31.81659 21157.62095 1498.647063    7.22277
      682  440.85 -19.56568 21736.80866 1535.104596    7.14582
      683  441.20 -31.81659 22200.71970 1583.517840    7.26563
      684  441.56 -33.44020 22419.16970 1603.148819    7.28908
      685  441.91 -11.44760 22542.71204 1601.672806    7.15221
      686  442.27 -24.43652 22568.54227 1620.418177    7.28038
      687  442.62 -25.46973 22120.86737 1596.801961    7.32524
      688  442.98 -19.27047 21972.23281 1598.573177    7.35668
      689  443.33 -25.91254 21199.68734 1555.621184    7.45107
      690  443.69 -55.87561 21067.28893 1520.639664    7.46344
      691  444.04 -30.48818 20686.03464 1510.012367    7.43610
      692  444.40 -36.24463 20780.64710 1509.126758    7.42364
      693  444.75 -24.58412 20874.96437 1520.639664    7.39357
      694  445.11 -32.70220 20892.52893 1526.691319    7.45222
      695  445.46 -30.19297 21276.29244 1544.698684    7.39161
      696  445.82  -8.49558 21761.45808 1565.953279    7.23221
      697  446.17 -12.33321 22270.09234 1634.292704    7.38980
      698  446.52 -25.46973 22766.77089 1657.466117    7.38381
      699  446.88 -12.62841 23012.23193 1706.322164    7.46563
      700  447.23  -6.57676 23489.86991 1727.133954    7.37861
      701  447.59 -22.07490 23753.78112 1760.049056    7.49552
      702  447.94  -9.97159 23503.74443 1738.351657    7.43533
      703  448.30 -12.33321 23794.96190 1766.543515    7.47198
      704  448.65 -27.53615 23305.22062 1751.340576    7.62395
      705  449.01 -48.64314 23166.32774 1718.720677    7.61303
      706  449.36 -30.34058 22304.18825 1685.362772    7.68184
      707  449.71 -25.46973 22262.85987 1675.916286    7.63353
      708  450.07 -20.30368 21782.12227 1633.554698    7.58566
      709  450.42 -24.58412 21231.12643 1591.193110    7.60161
      710  450.78 -20.30368 21100.49923 1594.145137    7.64388
      711  451.13 -18.68007 20496.66210 1552.521556    7.65867
      712  451.48 -17.64686 20460.64737 1556.211590    7.68550
      713  451.84 -19.12287 20204.70663 1541.451454    7.71651
      714  452.19 -24.73172 20238.06454 1538.056623    7.71260
      715  452.55 -12.92362 20343.00910 1543.075069    7.64396
      716  452.90 -29.01216 20409.13450 1560.639630    7.77787
      717  453.25 -10.26679 20234.66970 1579.385002    7.85210
      718  453.61 -17.64686 19967.51126 1521.968076    7.70379
      719  453.96 -17.35166 19569.57801 1474.440441    7.61626
      720  454.31 -17.49926 19179.17244 1480.934900    7.80570
      721  454.67 -26.06014 18796.88494 1452.300238    7.85403
      722  455.02 -20.59889 18517.03278 1429.864833    7.82443
      723  455.38  -8.49558 18326.77464 1410.381454    7.73851
      724  455.73 -40.82027 18110.09585 1420.270745    8.04968
      725  456.08 -36.39223 18095.04051 1398.130542    7.91180
      726  456.44  -9.08598 17712.90062 1387.208042    7.87888
      727  456.79 -23.84612 18028.47231 1386.174833    7.81075
      728  457.14 -18.23727 17996.00001 1388.536454    7.80923
      729  457.50 -17.35166 18249.43153 1407.134225    7.79823
      730  457.85 -25.91254 18526.47926 1428.684022    7.84048
      731  458.20 -23.69852 19003.37923 1482.263313    7.91484
      732  458.56 -31.07858 19516.44153 1508.536353    7.87627
      733  458.91 -21.77970 20158.80261 1573.333346    7.90420
      734  459.26 -27.38855 21207.36261 1665.731792    7.97335
      735  459.62 -27.97895 22665.07356 1730.676387    7.74975
      736  459.97 -12.03801 23824.18697 1846.986252    7.79916
      737  460.32 -21.18929 24387.72893 1887.724225    7.82056
      738  460.67  -9.52879 24698.87258 1927.871792    7.84106
      739  461.03 -19.27047 24703.44822 1906.174394    7.78816
      740  461.38 -15.72804 24250.90247 1869.274056    7.76788
      741  461.73 -19.41808 23336.65970 1822.189225    7.88492
      742  462.09 -23.69852 22563.81903 1796.506590    8.05846
      743  462.44 -13.80922 21472.45464 1723.739123    8.08679
      744  462.79 -11.44760 20746.10839 1660.418144    8.05425
      745  463.14 -29.89777 20198.95018 1633.997502    8.22536
      746  463.50 -31.96419 19613.26801 1601.968008    8.31719
      747  463.85 -33.29260 19217.40119 1570.971725    8.33354
      748  464.20 -28.86456 18795.55653 1527.576927    8.26820
      749  464.56 -25.91254 18728.98832 1531.562164    8.30436
      750  464.91 -36.09703 18782.12481 1567.281691    8.52035
      751  465.26 -32.55460 18651.20241 1532.742975    8.37785
      752  465.61 -23.55091 18628.76700 1536.433008    8.36349
      753  465.97 -18.97527 18569.13606 1532.152569    8.34473
      754  466.32 -24.87933 19149.20937 1553.849968    8.23366
      755  466.67 -20.59889 19252.38271 1588.831488    8.35071
      756  467.02 -29.01216 19566.03558 1601.820407    8.32268
      757  467.38 -21.77970 19784.33798 1608.610069    8.23175
      758  467.73 -24.58412 20051.79163 1647.724427    8.32973
      759  468.08 -30.48818 19785.66639 1608.019664    8.26855
      760  468.43 -32.40699 19544.92859 1615.842536    8.41917
      761  468.78 -13.66162 19274.96572 1596.506758    8.34776
      762  469.14 -10.85720 18902.41991 1591.193110    8.47051
      763  469.49   1.09851 18635.26146 1528.905340    8.19896
      764  469.84 -21.18929 18373.85947 1537.023414    8.47083
      765  470.19 -32.55460 18163.23234 1542.189461    8.65444
      766  470.54  -4.80554 18283.97024 1536.728211    8.42885
      767  470.90 -12.77602 18204.41312 1552.521556    8.59242
      768  471.25 -10.70960 18259.17322 1544.551083    8.51270
      769  471.60 -11.59520 18137.69731 1533.923786    8.51559
      770  471.95 -15.43284 18094.00731 1526.543718    8.51477
      771  472.30 -28.12656 18271.12893 1542.632265    8.58373
      772  472.66 -25.61733 18618.28731 1567.576894    8.54539
      773  473.01 -22.96051 18784.33883 1588.241083    8.56690
      774  473.36 -25.02693 19142.41970 1628.241049    8.62539
      775  473.71 -29.75017 19287.06903 1615.842536    8.51896
      776  474.06 -26.20774 19559.24592 1654.071286    8.57922
      777  474.41  -6.72436 19576.51528 1668.683819    8.55532
      778  474.76 -20.45129 19576.36768 1664.403380    8.59759
      779  475.12 -13.51402 19404.26450 1669.717029    8.66850
      780  475.47  -8.79078 19661.09085 1706.469765    8.72024
      781  475.82 -39.78706 19695.92477 1682.410745    8.72630
      782  476.17 -28.86456 19909.50393 1707.355373    8.70793
      783  476.52 -24.87933 20051.64403 1745.436522    8.81784
      784  476.87 -19.12287 20494.59568 1770.676353    8.72489
      785  477.22 -24.28892 20994.81666 1798.277806    8.67100
      786  477.58 -18.97527 21240.72051 1829.716894    8.69576
      787  477.93 -17.20406 21883.22920 1923.443752    8.86123
      788  478.28 -35.06382 21936.21808 1886.691015    8.74667
      789  478.63 -12.33321 22378.87454 1940.713110    8.72238
      790  478.98 -35.06382 22604.99981 1940.417907    8.72560
      791  479.33 -28.42176 22888.68960 1975.989833    8.74635
      792  479.68 -27.38855 23275.10994 2004.181691    8.71825
      793  480.03 -33.14500 23610.31261 2043.148448    8.78168
      794  480.38 -27.53615 24003.37501 2067.502671    8.71810
      795  480.74 -12.48081 24680.27481 2116.801522    8.62311
      796  481.09  -5.39595 25479.38852 2195.177840    8.63485
      797  481.44 -25.61733 26758.94464 2297.760779    8.67432
      798  481.79 -21.18929 28122.19072 2442.705306    8.75479
      799  482.14 -25.46973 30014.29244 2597.096319    8.73032
      800  482.49 -11.59520 32943.29366 2833.553684    8.63347
      801  482.84 -40.08227 36611.92524 3134.365238    8.66105
      802  483.19 -29.30737 42470.96089 3682.113853    8.73270
      803  483.54 -17.05645 48828.15109 4306.467569    8.85148
      804  483.89 -28.12656 52877.15136 4791.633211    9.11017
      805  484.24  -8.93838 55668.58812 5268.385576    9.47837
      806  484.59 -16.90885 56871.09633 5502.186117    9.70168
      807  484.94 -22.51770 57087.03710 5587.056894    9.82248
      808  485.29 -12.33321 56082.75751 5446.097603    9.73067
      809  485.64 -19.71328 53909.77041 5073.846995    9.44485
      810  485.99 -28.56936 50962.61423 4705.286421    9.28368
      811  486.34 -35.65422 48773.68619 4498.792130    9.29012
      812  486.69 -31.52139 47369.84974 4346.319934    9.23568
      813  487.04 -28.12656 46983.57700 4341.744292    9.29528
      814  487.39 -14.39963 47747.70920 4473.847502    9.39709
      815  487.74 -42.29629 48847.04406 4536.873279    9.36640
      816  488.10 -31.07858 49865.49339 4635.175779    9.35185
      817  488.45 -39.34426 49921.13910 4620.710846    9.32748
      818  488.80 -28.12656 49042.61585 4544.105745    9.31763
      819  489.15 -13.66162 47578.11524 4344.843921    9.15811
      820  489.50 -25.91254 45471.54876 4180.711218    9.24584
      821  489.84 -20.89409 43331.62437 4048.608008    9.38700
      822  490.19 -29.89777 40888.82200 3799.161725    9.35772
      823  490.54 -21.04169 40056.49798 3724.327840    9.34531
      824  490.89 -26.06014 40408.52720 3756.357333    9.35441
      825  491.24 -32.11179 42243.80241 3936.430981    9.38724
      826  491.59 -24.58412 43586.53190 4088.755576    9.43186
      827  491.94 -23.10811 44367.63825 4107.796150    9.30578
      828  492.29 -21.18929 45263.72606 4246.836623    9.42483
      829  492.64  -9.08598 44285.12910 4135.988008    9.35805
      830  492.99 -12.48081 42649.85372 3959.604394    9.31052
      831  493.34 -19.12287 39658.12193 3722.113819    9.42917
      832  493.69 -22.66531 36902.25710 3458.350204    9.42728
      833  494.04 -23.25571 34325.13751 3276.210137    9.60588
      834  494.39 -35.50662 31839.23555 3078.571927    9.76974
      835  494.74 -14.99004 29774.73545 2906.763954    9.80793
      836  495.09 -18.08966 28584.47815 2785.288042    9.80114
      837  495.44 -25.61733 27645.58595 2711.930171    9.89313
      838  495.79 -19.86088 27275.84457 2639.605508    9.74317
      839  496.14 -27.09335 27255.32798 2645.952367    9.79769
      840  496.49 -42.73909 27513.48274 2639.457907    9.73354
      841  496.84 -28.56936 27846.61899 2657.170069    9.63487
      842  497.18 -44.36270 28071.26825 2705.583313    9.78084
      843  497.53 -12.92362 28122.33832 2731.413549    9.75408
      844  497.88 -19.56568 28161.60028 2730.232738    9.75758
      845  498.23 -30.04537 28093.55606 2728.756725    9.80956
      846  498.58 -24.43652 27666.25014 2716.063008    9.89683
      847  498.93 -14.99004 27098.72295 2629.125813    9.75195
      848  499.28 -32.70220 26632.89308 2622.778954    9.95845
      849  499.63 -20.59889 26240.12589 2621.745745   10.06196
      850  499.98 -36.53983 25797.76464 2564.476421   10.06807
      851  500.32 -18.23727 25352.15616 2528.904495   10.03982
      852  500.67 -18.82767 24736.65852 2470.749563   10.05667
      853  501.02  -7.46237 24262.85818 2441.672096   10.09107
      854  501.37 -32.84980 24047.80301 2419.827096   10.18526
      855  501.72 -35.50662 23912.60018 2378.203515   10.07892
      856  502.07 -12.77602 23610.75541 2374.365880   10.10493
      857  502.42 -34.17821 23154.37204 2344.255204   10.25693
      858  502.76 -34.32581 23379.02129 2371.709056   10.27634
      859  503.11 -11.74281 23338.28332 2369.199833   10.19675
      860  503.46 -37.27784 23324.70399 2363.738583   10.27745
      861  503.81 -20.89409 23629.20558 2403.000542   10.24898
      862  504.16 -20.15608 23495.77396 2403.443346   10.30620
      863  504.51 -22.51770 23687.80332 2419.679495   10.30014
      864  504.86 -43.18189 23620.79231 2416.727468   10.39517
      865  505.20 -36.98264 23699.90663 2428.240373   10.38562
      866  505.55 -20.74649 23633.48602 2431.487603   10.36700
      867  505.90 -12.33321 23244.11366 2418.055880   10.45039
      868  506.25 -43.77230 23309.05825 2426.026353   10.57601
      869  506.60 -19.41808 23007.65629 2411.856623   10.55833
      870  506.94 -17.05645 23093.85548 2394.882468   10.43636
      871  507.29 -15.43284 23195.11001 2393.996860   10.38076
      872  507.64 -23.25571 23367.06558 2430.306792   10.48965
      873  507.99 -13.51402 23562.63737 2479.900846   10.57600
      874  508.34 -15.58044 23602.78494 2494.513380   10.62772
      875  508.68 -19.27047 23980.34920 2513.701556   10.55422
      876  509.03 -40.82027 24177.24940 2548.240272   10.69061
      877  509.38 -32.11179 24471.86170 2561.229191   10.58335
      878  509.73 -21.18929 24779.46291 2612.151657   10.61803
      879  510.07 -19.27047 25039.68410 2645.066758   10.63228
      880  510.42 -25.61733 25100.05305 2657.908076   10.68041
      881  510.77 -41.85348 25320.86467 2649.790002   10.61260
      882  511.12 -30.78338 25469.94204 2688.018752   10.66167
      883  511.46 -26.20774 25502.26673 2734.217975   10.81312
      884  511.81 -32.11179 25814.44359 2736.579596   10.71203
      885  512.16 -26.79814 25956.14089 2777.317569   10.79214
      886  512.51 -22.51770 26095.32896 2780.269596   10.73131
      887  512.85 -16.46605 26015.18143 2813.627502   10.87174
      888  513.20 -30.48818 26124.84923 2791.487299   10.78929
      889  513.55 -36.53983 25999.53568 2771.856319   10.78656
      890  513.90 -24.28892 25822.26646 2759.162603   10.76914
      891  514.24 -25.61733 25517.76487 2752.077738   10.87442
      892  514.59 -23.25571 25504.92356 2772.299123   10.95086
      893  514.94 -23.84612 25384.92366 2751.044529   10.92100
      894  515.29 -28.42176 25199.38876 2751.044529   11.01747
      895  515.63 -26.35534 25065.80954 2739.974427   11.02468
      896  515.98 -13.07122 25391.27051 2870.011218   11.34878
      897  516.33 -13.51402 25598.35521 2792.815711   10.95715
      898  516.67 -25.76493 25675.69832 2844.623786   11.16819
      899  517.02 -11.74281 26447.80099 2911.634799   11.04848
      900  517.37 -25.17453 27311.12129 3001.524022   11.07209
      901  517.71 -16.90885 27963.51926 3068.092231   11.02557
      902  518.06  -8.49558 29226.10122 3204.623481   10.99081
      903  518.41 -19.86088 30381.96741 3326.542198   11.00724
      904  518.75 -32.25939 30924.40237 3393.700813   11.06696
      905  519.10 -30.04537 31736.80021 3473.257941   11.02817
      906  519.45 -20.45129 31500.04764 3449.494123   11.00854
      907  519.79 -28.86456 31515.54579 3479.309596   11.12138
      908  520.14 -26.65054 30892.52048 3415.841015   11.13384
      909  520.49 -25.46973 30145.06724 3364.770948   11.23693
      910  520.83 -27.09335 29578.13045 3283.737806   11.18327
      911  521.18 -20.45129 28970.01288 3254.807941   11.29771
      912  521.53 -23.40331 28227.28288 3168.903954   11.29993
      913  521.87  -6.28156 27586.10261 3118.571894   11.32506
      914  522.22 -18.82767 27806.17622 3164.328313   11.43991
      915  522.57 -34.32581 27696.50842 3133.036826   11.42181
      916  522.91 -30.48818 27922.19089 3124.475948   11.28680
      917  523.26 -30.34058 27926.47133 3179.678853   11.48207
      918  523.60 -31.37379 28194.95818 3238.276590   11.58369
      919  523.95 -20.89409 28953.18633 3302.335576   11.46966
      920  524.30 -27.68375 29431.11950 3349.715610   11.46482
      921  524.64 -23.69852 30720.41731 3497.021758   11.45169
      922  524.99 -26.94574 31749.05112 3644.032704   11.55268
      923  525.34 -35.50662 33363.80991 3824.106353   11.55596
      924  525.68 -17.35166 34785.50612 3939.383008   11.36899
      925  526.03 -47.16713 36150.81862 4111.190981   11.48782
      926  526.37 -21.18929 37695.90957 4286.393786   11.42077
      927  526.72 -25.17453 38969.11883 4428.829090   11.42219
      928  527.06 -20.45129 40444.83714 4661.006015   11.56907
      929  527.41 -25.02693 42573.39622 4874.142367   11.50082
      930  527.76 -29.89777 45548.30146 5293.182603   11.67901
      931  528.10 -31.52139 49811.17609 5910.008650   11.92056
      932  528.45 -36.98264 52900.61997 6455.690846   12.26477
      933  528.79 -28.27416 54621.50413 6780.266218   12.45850
      934  529.14 -23.55091 55966.15244 7092.295475   12.70921
      935  529.48 -14.25203 56238.18173 7155.911657   12.74641
      936  529.83 -18.82767 55411.31896 6996.206995   12.65563
      937  530.18 -27.24095 53195.52747 6516.945407   12.29584
      938  530.52 -18.68007 50465.34528 6098.495576   12.11705
      939  530.87 -29.60257 47024.31497 5681.374157   12.13709
      940  531.21 -32.25939 44465.94075 5376.724968   12.15551
      941  531.56 -36.09703 41628.15717 5045.359934   12.19620
      942  531.90 -32.84980 40271.84835 4880.932029   12.19159
      943  532.25 -30.19297 39622.25481 4821.301083   12.23504
      944  532.59 -27.53615 40393.02906 4857.020610   12.08434
      945  532.94 -27.53615 42005.86903 5030.156995   12.03256
      946  533.28 -20.59889 43566.90092 5238.274900   12.06510
      947  533.63 -44.51031 44159.52035 5245.064563   11.96627
      948  533.97 -13.07122 44505.64551 5311.337569   11.95993
      949  534.32 -31.07858 43972.50943 5237.094090   11.97214
      950  534.66 -32.40699 42451.32991 5090.083144   12.05753
      951  535.01 -23.84612 40529.56031 4853.920981   12.02801
      952  535.35 -13.95683 38842.77207 4649.640711   12.00203
      953  535.70 -10.11919 37340.04271 4522.260745   12.13483
      954  536.04 -19.12287 36974.72937 4519.013515   12.26727
      955  536.39 -22.66531 36658.86247 4476.799529   12.26630
      956  536.73 -30.63578 36660.33849 4501.006150   12.35084
      957  537.08 -21.48449 36512.14673 4438.423177   12.20768
      958  537.42 -25.32213 36129.71163 4371.412164   12.16078
      959  537.77 -35.65422 35566.61247 4358.275644   12.34171
      960  538.11 -33.44020 34621.07822 4195.176150   12.20221
      961  538.45 -29.01216 33524.54778 4086.098752   12.26430
      962  538.80 -16.31845 32114.95487 3929.493718   12.28029
      963  539.14 -21.18929 31866.54180 3932.888549   12.40000
      964  539.49 -17.49926 31938.86646 3976.135745   12.49715
      965  539.83 -22.66531 32610.60021 4018.202130   12.38266
      966  540.18 -12.48081 33999.08612 4174.069157   12.30919
      967  540.52 -17.05645 36035.24676 4452.740508   12.39809
      968  540.87 -27.09335 39115.98217 4819.825069   12.38257
      969  541.21 -26.94574 42026.68082 5167.869056   12.35283
      970  541.55 -20.15608 44288.08112 5453.330069   12.35320
      971  541.90  -3.62473 45335.31271 5581.743245   12.31914
      972  542.24 -16.61365 45842.47095 5691.706252   12.44752
      973  542.59 -19.41808 45498.85501 5594.732164   12.33384
      974  542.93 -11.44760 43880.55379 5434.584698   12.40780
      975  543.27 -24.58412 41852.95403 5235.027671   12.55951
      976  543.62 -16.46605 39608.82308 4943.072198   12.51609
      977  543.96 -27.97895 37972.80970 4785.876758   12.66778
      978  544.31  -0.52510 36211.63038 4569.493177   12.62012
      979  544.65 -29.89777 34192.44389 4330.378988   12.74102
      980  544.99 -26.20774 32920.85825 4164.622671   12.71989
      981  545.34 -23.10811 31372.37247 3929.641319   12.59019
      982  545.68 -21.04169 30853.55372 3894.659799   12.68260
      983  546.02 -32.55460 30193.33288 3817.316691   12.73700
      984  546.37 -28.71696 30271.26639 3821.744731   12.70780
      985  546.71 -24.58412 30068.31454 3822.482738   12.78397
      986  547.06 -38.16345 29897.53977 3802.261353   12.82891
      987  547.40 -30.19297 29284.69896 3724.918245   12.80957
      988  547.74 -32.11179 28989.05345 3671.929360   12.76324
      989  548.09 -18.68007 28498.42656 3616.431252   12.74713
      990  548.43 -10.85720 27262.70805 3464.992265   12.74439
      991  548.77 -26.50294 26094.44335 3329.641826   12.84848
      992  549.12 -14.84243 25202.04558 3236.800576   12.89470
      993  549.46 -25.02693 24401.75106 3111.191826   12.83926
      994  549.80 -24.14132 23394.07663 3054.070103   13.14452
      995  550.15 -19.86088 22817.39815 3002.262029   13.23330
      996  550.49 -28.27416 22056.66079 2881.228921   13.17415
      997  550.83 -25.46973 21805.00048 2871.634833   13.27092
      998  551.17 -13.66162 21552.30697 2799.162569   13.04288
      999  551.52 -25.46973 21360.86801 2799.900576   13.21110
      1000 551.86 -14.54723 21695.48028 2822.040779   13.06580
      1001 552.20 -23.55091 21666.55041 2825.435610   13.13496
      1002 552.55 -16.46605 21980.94129 2849.051826   13.02662
      1003 552.89 -19.56568 21943.89335 2864.254765   13.13008
      1004 553.23 -29.89777 22236.29163 2868.092400   13.01520
      1005 553.58 -30.63578 22080.86741 2894.808245   13.23042
      1006 553.92 -17.35166 22215.33224 2895.546252   13.10187
      1007 554.26 -20.45129 21878.94876 2854.808279   13.12940
      1008 554.60 -30.34058 21417.54693 2828.978042   13.33147
      1009 554.95 -14.84243 20968.10082 2777.317569   13.30681
      1010 555.29 -12.03801 20684.85383 2711.930171   13.16124
      1011 555.63 -30.78338 20347.14193 2695.103617   13.37667
      1012 555.97 -30.19297 20050.02041 2657.465272   13.38461
      1013 556.32 -14.99004 19785.96160 2640.933921   13.41311
      1014 556.66 -38.90145 19517.62234 2623.369360   13.61321
      1015 557.00 -28.12656 19544.04298 2603.147975   13.44396
      1016 557.34 -21.63210 19320.42693 2554.734731   13.32002
      1017 557.69 -15.43284 19207.95470 2564.328819   13.41991
      1018 558.03 -35.06382 18950.68555 2508.240306   13.39586
      1019 558.37 -41.11547 18925.44572 2532.446927   13.56895
      1020 558.71 -25.91254 18851.05464 2544.993042   13.61927
      1021 559.06 -38.90145 18728.54551 2539.088988   13.73650
      1022 559.40 -30.19297 18646.33156 2526.100069   13.68720
      1023 559.74 -37.57304 18538.73018 2518.424799   13.75945
      1024 560.08 -22.51770 18505.07707 2498.646218   13.60762
      1025 560.42 -19.86088 18528.25048 2528.166488   13.73740
      1026 560.77 -14.39963 18909.50477 2558.129563   13.59407
      1027 561.11 -24.87933 18814.44950 2543.664630   13.63395
      1028 561.45  -1.41071 18961.90325 2565.509630   13.53624
      1029 561.79 -18.53247 18840.42734 2563.295610   13.69019
      1030 562.13  -5.98635 18926.33133 2581.450576   13.66677
      1031 562.47  -4.36274 18911.27599 2591.635069   13.72408
      1032 562.82  -5.69115 18837.18011 2590.306657   13.77708
      1033 563.16 -12.03801 18682.05109 2534.808549   13.62381
      1034 563.50 -10.70960 18690.75957 2548.535475   13.68473
      1035 563.84 -17.79446 18667.43856 2525.509664   13.61131
      1036 564.18 -32.11179 18714.67099 2579.826961   13.93273
      1037 564.52 -39.34426 18746.40528 2588.240238   13.98712
      1038 564.87 -40.67267 19036.44193 2622.336150   13.95918
      1039 565.21 -33.88301 19236.73697 2644.181150   13.89714
      1040 565.55 -27.38855 19682.49305 2725.361894   13.96635
      1041 565.89 -19.12287 20080.86910 2756.358177   13.80837
      1042 566.23 -25.46973 20662.41842 2827.206826   13.78911
      1043 566.57 -24.87933 20736.07149 2852.446657   13.85932
      1044 566.91 -12.77602 20959.68754 2921.819292   13.99261
      1045 567.26  -2.59152 20960.27795 2884.476150   13.77229
      1046 567.60 -32.99740 20799.68768 2866.321184   13.91716
      1047 567.94 -27.68375 20387.14190 2857.465103   14.13262
      1048 568.28 -28.12656 20147.43731 2775.103549   13.89418
      1049 568.62 -34.47341 19974.44852 2790.749292   14.11981
      1050 568.96 -20.59889 19694.89156 2763.738245   14.12259
      1051 569.30  -2.59152 19529.87325 2743.369258   14.05844
      1052 569.64 -23.10811 19501.68139 2729.642333   14.09875
      1053 569.98  -6.42916 19567.65920 2764.328650   14.15523
      1054 570.32 -19.27047 19541.38616 2735.398786   14.08270
      1055 570.67 -14.84243 19771.93947 2788.535272   14.16793
      1056 571.01 -24.58412 20165.14947 2846.985407   14.22292
      1057 571.35 -27.24095 20173.11994 2891.561015   14.44926
      1058 571.69 -22.07490 20546.69896 2921.081286   14.30886
      1059 572.03 -14.10443 21120.57301 2968.166117   14.11079
      1060 572.37 -24.87933 21329.87173 3020.859799   14.26258
      1061 572.71 -21.48449 21236.73528 3018.793380   14.30166
      1062 573.05 -40.08227 21278.80166 2997.391184   14.24781
      1063 573.39 -19.56568 21098.28521 3002.262029   14.30935
      1064 573.73 -23.25571 20957.32592 2956.062806   14.20036
      1065 574.07 -12.77602 20808.69136 2972.594157   14.33794
      1066 574.41 -26.79814 20593.34099 2939.974258   14.38774
      1067 574.75 -22.22250 20333.11981 2864.107164   14.17972
      1068 575.09 -11.74281 20476.58832 2890.380204   14.16476
      1069 575.43 -22.22250 20247.95383 2891.856218   14.37619
      1070 575.77 -22.37010 19920.57403 2873.848853   14.52252
      1071 576.11  -6.87196 19997.32673 2827.944833   14.17111
      1072 576.45 -50.11916 19551.71825 2813.775103   14.61034
      1073 576.79 -10.41439 19196.14660 2750.454123   14.37461
      1074 577.13 -20.74649 18844.85538 2685.066725   14.34258
      1075 577.47 -16.90885 18385.51997 2684.919123   14.68191
      1076 577.81  -9.67639 17885.29899 2583.812198   14.49283
      1077 578.15 -35.80183 17639.98555 2547.945069   14.61744
      1078 578.49 -18.82767 17339.76440 2513.849157   14.59034
      1079 578.83 -34.17821 16936.22231 2463.812299   14.71969
      1080 579.17 -22.96051 16553.19680 2401.819731   14.62812
      1081 579.51 -24.14132 16485.30018 2413.923042   14.76770
      1082 579.85 -17.05645 15948.17886 2335.251522   14.73394
      1083 580.19 -24.28892 15868.17893 2351.635272   14.95000
      1084 580.53 -30.34058 15661.97984 2324.919427   15.00900
      1085 580.87 -32.40699 15579.47068 2301.303211   14.94830
      1086 581.21 -23.84612 15410.46714 2278.425002   14.91658
      1087 581.55 -15.58044 15310.54102 2268.830914   14.90535
      1088 581.89 -39.04906 15197.03558 2245.362299   14.99343
      1089 582.23 -24.87933 15125.89173 2233.111387   14.90347
      1090 582.57 -43.62470 15197.18318 2236.801421   14.96263
      1091 582.91 -15.43284 15076.59288 2228.388144   14.86759
      1092 583.25 -28.12656 14929.72954 2199.605880   14.89339
      1093 583.59 -23.40331 14821.24254 2227.502536   15.16308
      1094 583.93  -5.24835 14814.45288 2201.967502   14.89379
      1095 584.27  -2.59152 14734.74815 2184.993346   14.84382
      1096 584.61 -27.83135 14688.25372 2187.354968   15.05282
      1097 584.94 -19.12287 14505.81845 2190.159394   15.21027
      1098 585.28 -17.49926 14567.81102 2204.181522   15.23232
      1099 585.62 -29.60257 14477.62660 2153.701860   15.04977
      1100 585.96 -16.76125 14521.61180 2157.096691   14.95255
      1101 586.30 -30.34058 14468.47531 2169.495204   15.17252
      1102 586.64 -14.39963 14329.13964 2147.650204   15.07334
      1103 586.98 -46.87193 14363.67835 2157.982299   15.30028
      1104 587.32 -27.68375 14456.22440 2166.985981   15.15247
      1105 587.66 -11.15240 14466.40889 2166.543177   15.04187
      1106 588.00 -25.02693 14521.16899 2193.259022   15.24994
      1107 588.33 -25.17453 14648.84416 2190.454596   15.09899
      1108 588.67 -28.27416 14767.22045 2241.672265   15.34215
      1109 589.01 -22.96051 14800.72595 2248.019123   15.31994
      1110 589.35 -20.45129 15011.64829 2267.207299   15.21849
      1111 589.69 -41.55828 14973.86234 2276.210981   15.43593
      1112 590.03 -20.74649 15014.89551 2276.653786   15.27970
      1113 590.37 -19.12287 15044.26818 2266.912096   15.17610
      1114 590.70 -23.69852 15071.72204 2249.495137   15.05883
      1115 591.04 -11.15240 15056.22389 2304.550441   15.36899
      1116 591.38 -19.86088 14807.81082 2247.133515   15.28894
      1117 591.72 -18.82767 14769.13926 2255.251590   15.37790
      1118 592.06 -39.04906 14614.30545 2226.764529   15.46276
      1119 592.40 -23.10811 14553.49369 2244.624292   15.55735
      1120 592.73 -31.22618 14481.02143 2246.543110   15.69550
      1121 593.07 -16.76125 14476.29818 2231.635373   15.51361
      1122 593.41 -20.45129 14513.78893 2267.059698   15.73877
      1123 593.75 -26.06014 14672.46038 2261.598448   15.56387
      1124 594.09  -0.96791 14673.93639 2280.639022   15.54768
      1125 594.42   0.21290 14919.10224 2281.819833   15.29341
      1126 594.76 -30.93098 15178.88062 2325.509833   15.49290
      1127 595.10 -27.24095 15098.88068 2330.971083   15.59033
      1128 595.44 -19.12287 15311.86943 2393.701657   15.73821
      1129 595.78  -5.98635 15779.17531 2442.410103   15.51075
      1130 596.11 -20.74649 15876.44460 2479.458042   15.72734
      1131 596.45 -23.40331 16516.00126 2548.535475   15.55037
      1132 596.79 -34.62102 16795.11541 2569.347265   15.47242
      1133 597.13  -6.28156 17032.31079 2635.325069   15.50367
      1134 597.47 -22.96051 17216.81247 2695.841623   15.77052
      1135 597.80 -19.56568 16844.85707 2603.885981   15.55613
      1136 598.14 -25.46973 16655.63214 2592.815880   15.69612
      1137 598.48 -23.99372 16228.17862 2498.793819   15.52277
      1138 598.82 -15.58044 15531.20504 2412.889833   15.62040
      1139 599.15 -20.45129 15100.06149 2365.805002   15.78158
      1140 599.49 -26.50294 14617.55268 2300.270002   15.88886
      1141 599.83 -19.71328 14126.92579 2243.443481   15.99784
      1142 600.17 -23.40331 13976.37241 2227.650137   16.07921
      1143 600.50 -16.31845 13768.40210 2186.912164   15.98314
      1144 600.84 -33.14500 13624.78599 2150.897434   15.99102
      1145 601.18  -5.24835 13648.25460 2160.343921   15.86107
      1146 601.51 -25.61733 13610.46866 2149.421421   15.95061
      1147 601.85 -24.43652 13669.80440 2165.952772   15.99497
      1148 602.19 -30.04537 13832.90389 2193.554225   16.03987
      1149 602.53 -34.03061 14085.44981 2243.295880   16.12897
      1150 602.86 -38.60625 14532.68190 2325.952637   16.22752
      1151 603.20 -23.84612 14998.51176 2383.812367   16.02717
      1152 603.54 -35.06382 15429.80291 2455.399022   16.10400
      1153 603.87 -25.76493 15810.76200 2538.646184   16.19301
      1154 604.21 -39.34426 16542.27430 2633.849056   16.12143
      1155 604.55 -28.86456 16750.83501 2666.321353   16.06218
      1156 604.88 -13.66162 17005.44734 2695.841623   15.92036
      1157 605.22 -29.30737 16921.60977 2675.177434   15.95480
      1158 605.56  -4.51034 17057.10781 2686.247536   15.77082
      1159 605.89 -21.77970 16690.76126 2659.531691   16.04371
      1160 606.23 -14.10443 16284.70994 2570.528076   15.85779
      1161 606.57 -33.44020 15625.81751 2512.225542   16.25662
      1162 606.90 -16.17085 15140.35666 2435.030036   16.17258
      1163 607.24 -13.36642 14682.20207 2389.126015   16.34841
      1164 607.58 -21.63210 14413.71521 2345.436015   16.39772
      1165 607.91 -21.92730 14308.47545 2283.591049   16.08830
      1166 608.25 -21.18929 14142.12872 2292.151927   16.33333
      1167 608.59 -20.74649 14285.44964 2331.118684   16.43949
      1168 608.92 -11.74281 14566.18741 2404.181353   16.57248
      1169 609.26 -29.75017 14826.40859 2422.336319   16.50552
      1170 609.59 -27.53615 15104.34193 2443.148110   16.32768
      1171 609.93 -19.27047 15219.76619 2427.649968   16.05692
      1172 610.27 -19.56568 15256.37133 2492.742164   16.44618
      1173 610.60 -31.96419 15174.60018 2470.306758   16.45520
      1174 610.94 -30.48818 14951.72214 2377.317907   16.07110
      1175 611.28 -11.59520 14570.17264 2331.856691   16.07111
      1176 611.61   1.98412 14247.81129 2341.155576   16.42005
      1177 611.95 -33.88301 13803.53122 2226.026522   16.33188
      1178 612.28 -25.02693 13468.47616 2165.509968   16.23401
      1179 612.62  -7.60997 13088.99308 2123.738786   16.27406
      1180 612.95 -18.82767 12821.24423 2126.543211   16.70840
      1181 613.29 -18.97527 12575.34038 2085.214833   16.70746
      1182 613.63 -23.25571 12370.76491 2010.676150   16.41059
      1183 613.96 -21.33689 12228.18200 2021.893853   16.68009
      1184 614.30 -21.33689 12003.97555 1970.233380   16.56148
      1185 614.63 -32.11179 12032.90541 1995.473211   16.80549
      1186 614.97 -30.34058 11808.10856 1947.502772   16.70695
      1187 615.30 -10.56199 11805.15653 1977.023042   16.82153
      1188 615.64 -38.45865 11727.37062 1950.307198   16.90290
      1189 615.98 -21.48449 11775.19345 1948.683583   16.70104
      1190 616.31 -29.15977 11627.88731 1929.643008   16.80359
      1191 616.65 -29.15977 11631.42974 1955.178042   17.01747
      1192 616.98 -13.66162 11704.78761 1964.181725   16.87803
      1193 617.32 -37.13024 11628.18251 1934.513853   16.90177
      1194 617.65  -8.20037 11624.93528 1920.639326   16.58057
      1195 617.99 -25.17453 11526.48518 1921.377333   16.85084
      1196 618.32 -20.89409 11626.41129 1969.790576   17.09138
      1197 618.66 -16.46605 11683.97582 1922.410542   16.57097
      1198 618.99 -26.20774 11614.16038 1947.059968   16.95194
      1199 619.33 -23.84612 11680.13818 1941.155914   16.78917
      1200 619.66 -28.27416 11547.73977 1949.421590   17.08443
      1201 620.00 -36.39223 11346.70673 1925.214968   17.23263
      1202 620.33 -14.10443 11443.97602 1939.384698   17.04901
      1203 620.67 -21.92730 11359.25285 1895.251894   16.84517
      1204 621.00 -21.04169 11293.86545 1891.119056   16.89948
      1205 621.34 -17.05645 11276.00568 1890.085846   16.88773
      1206 621.67 -35.06382 11107.59254 1890.971454   17.28524
      1207 622.01 -16.02324 11255.93190 1910.159630   17.08828
      1208 622.34 -19.71328 11034.08707 1872.521286   17.11841
      1209 622.68 -25.17453 11044.71437 1888.757434   17.28953
      1210 623.01 -30.04537 11009.73285 1876.654123   17.27118
      1211 623.34 -23.99372 11035.26788 1892.152265   17.32617
      1212 623.68 -18.53247 11127.66633 1884.624596   17.07449
      1213 624.01 -28.12656 11078.07227 1899.827536   17.35926
      1214 624.35 -34.32581 11143.45967 1916.358887   17.45144
      1215 624.68 -30.48818 11150.54454 1934.661454   17.57574
      1216 625.02 -31.96419 11277.03889 1937.908684   17.41863
      1217 625.35 -26.06014 11463.75460 1961.082096   17.29482
      1218 625.69 -36.39223 11565.45193 1970.233380   17.29575
      1219 626.02 -38.16345 11770.32261 2046.395677   17.65306
      1220 626.35 -20.89409 12007.96079 2096.284934   17.60084
      1221 626.69 -24.28892 12189.36285 2093.037704   17.33574
      1222 627.02 -20.00848 12312.60997 2102.926995   17.21399
      1223 627.36 -35.80183 12412.97889 2094.070914   17.10909
      1224 627.69  -4.65794 12386.11545 2149.569022   17.38573
      1225 628.02 -20.45129 12315.11920 2106.469427   17.24218
      1226 628.36 -33.29260 12081.31866 2084.034022   17.47746
      1227 628.69  -0.82031 11884.71366 2067.355069   17.40078
      1228 629.03  11.43061 11823.60670 2023.517468   17.03401
      1229 629.36 -18.53247 11588.03494 2008.757333   17.46675
      1230 629.69 -13.36642 11564.56633 2015.251792   17.52142
      1231 630.03 -29.15977 11299.17910 1954.292434   17.50876
      1232 630.36 -28.42176 11104.05011 1930.085813   17.59275
      1233 630.69  -8.64318 11024.93579 1922.558144   17.50295
      1234 631.03 -26.06014 10860.36028 1900.713144   17.69887
      1235 631.36 -14.84243 10813.42305 1919.901319   17.86753
      1236 631.70 -29.75017 10684.41947 1891.414258   17.93106
      1237 632.03 -19.27047 10588.03579 1852.299900   17.64416
      1238 632.36 -10.56199 10471.87352 1811.119123   17.37841
      1239 632.70 -25.61733 10530.47126 1831.045306   17.58855
      1240 633.03 -31.66899 10386.26474 1851.414292   18.07540
      1241 633.36 -18.68007 10467.74068 1826.912468   17.59983
      1242 633.70 -13.07122 10367.37176 1836.358954   17.81649
      1243 634.03  -1.26311 10552.46386 1875.178110   17.77989
      1244 634.36  -6.13395 10443.82926 1854.661522   17.80672
      1245 634.69 -21.92730 10450.17612 1834.735340   17.72961
      1246 635.03 -12.33321 10351.43082 1823.370036   17.71271
      1247 635.36 -24.58412 10169.88116 1823.812840   18.13138
      1248 635.69 -37.86824 10083.97717 1749.126556   17.65483
      1249 636.03 -26.79814 10023.75582 1746.322130   17.64202
      1250 636.36 -27.24095  9809.14345 1757.392231   18.14318
      1251 636.69 -29.45497  9696.22842 1732.447603   18.11598
      1252 637.03 -14.99004  9531.94812 1721.229900   18.18614
      1253 637.36 -26.79814  9478.95923 1696.137671   18.12518
      1254 637.69 -23.99372  9322.05899 1679.015914   18.22170
      1255 638.02 -29.45497  9238.66423 1651.562063   18.13763
      1256 638.36 -21.48449  9151.57943 1648.757637   18.20812
      1257 638.69 -26.50294  8997.77883 1611.857299   18.15502
      1258 639.02 -19.12287  8975.04822 1611.266894   18.12718
      1259 639.35 -14.54723  8821.39521 1574.514157   17.98406
      1260 639.69 -15.87564  8840.43579 1571.414529   17.92270
      1261 640.02 -35.21142  8669.21822 1547.798313   18.18625
      1262 640.35 -30.04537  8647.37322 1540.123042   18.09488
      1263 640.68 -34.62102  8508.48035 1551.340745   18.56424
      1264 641.02 -24.73172  8544.79028 1554.587975   18.42950
      1265 641.35 -34.76862  8495.04862 1526.100914   18.29898
      1266 641.68 -18.97527  8462.87153 1526.100914   18.21627
      1267 642.01 -14.69483  8429.36602 1524.772502   18.23136
      1268 642.35 -38.45865  8395.27011 1521.525272   18.49697
      1269 642.68 -16.76125  8305.52849 1525.215306   18.52827
      1270 643.01 -20.74649  8291.94916 1476.211657   18.00810
      1271 643.34 -25.46973  8354.38454 1499.532671   18.19844
      1272 643.67 -26.50294  8207.96399 1506.469934   18.61654
      1273 644.01 -30.34058  8196.45109 1488.462569   18.46167
      1274 644.34 -31.07858  8158.66514 1478.720880   18.43525
      1275 644.67 -28.12656  8116.59876 1483.444123   18.55889
      1276 645.00 -15.58044  8034.08960 1480.787299   18.58918
      1277 645.33 -29.01216  8093.42535 1493.776218   18.74792
      1278 645.67 -12.62841  8064.05268 1465.584360   18.30223
      1279 646.00 -23.99372  8147.44744 1507.060340   18.73665
      1280 646.33 -52.77598  8103.16704 1491.562198   18.93513
      1281 646.66 -24.87933  8075.86079 1475.030846   18.51572
      1282 646.99 -34.76862  8106.70947 1500.713481   18.85999
      1283 647.32 -47.46233  8168.84964 1522.410880   19.10679
      1284 647.66 -14.84243  8310.39933 1518.720846   18.42065
      1285 647.99  -2.00112  8094.45856 1506.912738   18.63671
      1286 648.32 -26.50294  8167.81643 1503.960711   18.67713
      1287 648.65 -26.94574  8161.76477 1494.957029   18.58538
      1288 648.98  -5.98635  8118.36997 1496.728245   18.49641
      1289 649.31 -30.19297  8085.15967 1509.421961   18.97163
      1290 649.64 -23.55091  8103.46224 1519.163650   18.98255
      1291 649.98 -20.59889  8104.64305 1503.813110   18.76144
      1292 650.31 -11.00480  8082.94565 1492.300204   18.57319
      1293 650.64  -8.93838  8078.37001 1500.418279   18.66328
      1294 650.97 -16.31845  8099.77220 1509.421961   18.79896
      1295 651.30 -19.86088  8108.33308 1501.303887   18.71467
      1296 651.63 -30.78338  8069.80913 1488.167367   18.75111
      1297 651.96  -6.13395  8129.88288 1502.779900   18.54610
      1298 652.29 -12.92362  8070.10433 1502.927502   18.75351
      1299 652.62 -36.68743  8078.51761 1480.049292   18.69006
      1300 652.95 -48.20034  8088.11170 1499.975475   19.02798
      1301 653.29 -26.20774  7929.29264 1497.171049   19.14875
      1302 653.62 -16.90885  7940.65795 1489.643380   18.93232
      1303 653.95 -16.17085  7838.07501 1480.787299   19.05922
      1304 654.28 -24.87933  7795.41822 1453.628650   18.90603
      1305 654.61 -17.64686  7715.71349 1476.802063   19.32470
      1306 654.94 -22.07490  7738.88690 1468.388786   19.20463
      1307 655.27 -27.83135  7713.94227 1440.492130   18.96624
      1308 655.60 -33.88301  7621.69143 1439.606522   19.24728
      1309 655.93  -9.52879  7695.63970 1451.562231   18.96248
      1310 656.26 -18.82767  7670.84268 1463.517941   19.27710
      1311 656.59 -22.66531  7681.91278 1432.226454   18.88347
      1312 656.92 -22.51770  7760.14149 1465.879563   19.12453
      1313 657.25 -28.42176  7785.67653 1497.909056   19.53304
      1314 657.58 -20.00848  7843.24106 1505.289123   19.39780
      1315 657.91 -27.53615  8011.21139 1525.953313   19.32502
      1316 658.24 -44.65791  8184.05258 1542.484664   19.28787
      1317 658.57 -18.23727  8434.67967 1590.159900   19.02772
      1318 658.90 -21.04169  8666.11859 1677.244698   19.54938
      1319 659.23 -28.56936  8852.39149 1690.528819   19.35712
      1320 659.56 -33.73541  8941.69031 1709.274191   19.41980
      1321 659.89 -32.70220  9077.18835 1684.034360   18.84476
      1322 660.22 -13.36642  9064.49464 1690.528819   18.76979
      1323 660.55 -21.33689  8966.19214 1679.163515   18.92067
      1324 660.88 -25.91254  8827.15166 1669.864630   19.15469
      1325 661.21 -20.74649  8629.51345 1652.447671   19.34270
      1326 661.54 -20.15608  8466.56156 1586.617468   18.93280
      1327 661.87 -16.17085  8152.17068 1556.359191   19.25152
      1328 662.20 -30.04537  7967.66899 1537.171015   19.59580
      1329 662.53 -29.15977  7834.68018 1503.075103   19.48456
      1330 662.86 -33.14500  7661.10099 1455.990272   19.35388
      1331 663.19 -13.51402  7478.51812 1430.455238   19.27340
      1332 663.52  -3.62473  7371.50714 1431.783650   19.46282
      1333 663.85 -16.46605  7263.90575 1370.233887   19.04710
      1334 664.18 -32.25939  7192.17149 1389.864867   19.68493
      1335 664.51 -23.40331  7068.48156 1335.399968   19.15997
      1336 664.84 -34.03061  7036.30447 1373.776319   19.91146
      1337 665.17 -31.37379  7056.82106 1347.503279   19.45315
      1338 665.50 -11.59520  6944.34883 1355.473752   19.65325
      1339 665.83  -8.34797  6903.75845 1342.780036   19.54727
      1340 666.16 -11.44760  6981.54437 1355.178549   19.54280
      1341 666.48 -35.35902  6956.00933 1338.647198   19.65289
      1342 666.81 -17.94206  6902.72524 1341.746826   19.64679
      1343 667.14 -18.82767  6925.16065 1372.890711   20.04206
      1344 667.47  -9.52879  6869.21974 1345.141657   19.69356
      1345 667.80 -26.06014  6910.25291 1356.949765   19.93869
      1346 668.13 -45.39591  6876.00940 1321.968245   19.75559
      1347 668.46 -13.51402  6911.13852 1359.901792   19.83371
      1348 668.79 -11.59520  6935.64035 1352.669326   19.63752
      1349 669.12 -12.03801  6962.94660 1347.946083   19.49802
      1350 669.44 -40.22987  6930.17910 1346.765272   19.89833
      1351 669.77 -33.73541  6925.89866 1334.514360   19.65979
      1352 670.10 -30.63578  6890.03153 1367.429461   20.20131
      1353 670.43 -37.27784  6867.74372 1335.547569   19.88155
      1354 670.76 -21.63210  6802.20872 1347.060475   20.05751
      1355 671.09 -22.81291  6689.14609 1331.414731   20.17634
      1356 671.42 -14.25203  6717.63315 1327.281894   19.92806
      1357 671.75 -14.84243  6577.11666 1310.898144   20.11148
      1358 672.07 -29.75017  6658.74021 1324.772671   20.25155
      1359 672.40 -15.72804  6587.44876 1317.687806   20.19355
      1360 672.73 -17.35166  6543.02075 1290.381556   19.93383
      1361 673.06 -13.36642  6549.51521 1289.053144   19.84524
      1362 673.39 -18.53247  6511.87687 1284.477502   19.95296
      1363 673.72 -32.70220  6524.86579 1298.794833   20.30474
      1364 674.04 -13.07122  6428.62970 1289.348346   20.21857
      1365 674.37 -22.66531  6438.37139 1265.732130   19.94103
      1366 674.70 -12.03801  6329.58920 1269.569765   20.20945
      1367 675.03 -30.48818  6323.83274 1271.931387   20.49660
      1368 675.36 -27.83135  6356.74785 1249.938786   20.01338
      1369 675.68 -14.10443  6240.29038 1266.470137   20.47480
      1370 676.01 -34.91622  6264.20180 1272.226590   20.75120
      1371 676.34 -22.81291  6277.63352 1263.518110   20.41651
      1372 676.67 -20.45129  6257.55974 1254.366826   20.30608
      1373 677.00 -15.72804  6251.36048 1264.994123   20.43568
      1374 677.32 -25.61733  6247.37524 1254.366826   20.40468
      1375 677.65 -31.37379  6291.50805 1244.182333   20.17365
      1376 677.98 -28.71696  6348.77737 1270.012569   20.36426
      1377 678.31 -21.92730  6409.14633 1291.119563   20.41723
      1378 678.63 -16.76125  6438.07619 1278.130644   20.06080
      1379 678.96 -20.74649  6541.54474 1337.171184   20.69274
      1380 679.29 -24.58412  6634.23839 1345.289258   20.57231
      1381 679.62 -33.88301  6761.47075 1373.481117   20.71068
      1382 679.94 -11.44760  6880.73264 1388.388853   20.31050
      1383 680.27 -16.46605  6879.10903 1398.573346   20.52098
      1384 680.60 -24.14132  6975.49271 1432.669258   20.81267
      1385 680.93 -30.04537  7021.10153 1411.857468   20.44920
      1386 681.25 -29.01216  6998.66612 1394.145306   20.25075
      1387 681.58  -4.51034  7033.20484 1418.056725   20.21348
      1388 681.91 -24.43652  6906.26768 1403.591792   20.60438
      1389 682.23 -22.96051  6875.27139 1396.359326   20.57512
      1390 682.56 -19.71328  6863.02048 1403.148988   20.67292
      1391 682.89 -44.51031  6707.74386 1366.543853   20.89753
      1392 683.22 -26.06014  6591.43399 1350.455306   20.80116
      1393 683.54 -42.14868  6509.07244 1319.163819   20.77952
      1394 683.87 -23.99372  6407.37511 1284.477502   20.34514
      1395 684.20 -20.45129  6264.93981 1274.293008   20.59926
      1396 684.52 -23.69852  6190.40112 1280.197063   20.98286
      1397 684.85 -31.22618  6120.88089 1252.005204   20.85840
      1398 685.18 -12.03801  6079.70011 1238.425880   20.52721
      1399 685.50 -18.97527  5962.06183 1249.495981   21.20822
      1400 685.83 -27.38855  5957.04339 1219.237704   20.83115
      1401 686.16 -16.61365  5949.81092 1219.975711   20.72580
      1402 686.48  -8.05277  5843.98075 1236.064258   21.25957
      1403 686.81 -17.35166  5956.30538 1240.344698   21.05404
      1404 687.14 -27.24095  5979.18359 1230.898211   20.94656
      1405 687.46 -36.09703  5970.17991 1244.920340   21.32798
      1406 687.79 -25.02693  6043.68538 1249.643583   21.00397
      1407 688.12 -23.40331  6017.41234 1240.197096   20.91771
      1408 688.44 -21.33689  5986.26845 1235.326252   20.91787
      1409 688.77 -24.14132  5947.89210 1238.573481   21.14380
      1410 689.09 -21.48449  5855.93646 1199.459123   20.77346
      1411 689.42 -38.31105  5809.14683 1205.953583   21.27873
      1412 689.75 -12.03801  5755.71514 1172.743279   20.54147
      1413 690.07 -40.37747  5632.91082 1160.344765   21.16448
      1414 690.40 -20.00848  5561.47176 1167.134427   21.26932
      1415 690.73 -40.08227  5500.66001 1153.259900   21.53759
      1416 691.05 -20.00848  5448.70433 1133.628921   21.09523
      1417 691.38 -21.48449  5378.00329 1126.101252   21.25360
      1418 691.70 -18.08966  5302.87420 1125.068042   21.48403
      1419 692.03 -23.55091  5237.78200 1133.333718   21.98843
      1420 692.35 -37.57304  5178.29866 1087.872502   21.57732
      1421 692.68 -19.41808  5171.21379 1079.902029   21.17893
      1422 693.01 -19.41808  4995.42058 1057.761826   21.47985
      1423 693.33 -31.81659  5090.91866 1060.566252   21.32421
      1424 693.66 -18.08966  5016.67518 1047.872536   21.17204
      1425 693.98 -32.55460  5018.74160 1038.426049   21.20210
      1426 694.31 -10.56199  4994.83018 1049.348549   21.17537
      1427 694.63 -18.97527  4944.35051 1045.068110   21.43811
      1428 694.96 -25.91254  4961.02947 1034.736015   21.26852
      1429 695.29 -22.51770  4958.96305 1037.983245   21.28887
      1430 695.61 -20.15608  4910.84501 1059.975846   21.90492
      1431 695.94 -27.38855  5065.08842 1074.293177   21.63351
      1432 696.26 -25.91254  5070.84487 1094.219360   21.97734
      1433 696.59 -30.48818  5173.13261 1125.658448   22.21812
      1434 696.91 -30.48818  5215.19899 1135.990542   22.23691
      1435 697.24 -28.12656  5353.50146 1140.861387   21.72183
      1436 697.56 -19.12287  5591.87764 1218.056894   22.04918
      1437 697.89 -25.61733  5767.81845 1226.617772   21.61472
      1438 698.21 -34.47341  5991.87731 1314.440576   22.38360
      1439 698.54 -38.01585  6265.53021 1353.112130   22.06897
      1440 698.86 -15.43284  6393.94339 1383.518008   21.82663
      1441 699.19 -16.46605  6516.74771 1373.481117   21.27509
      1442 699.51 -24.58412  6501.83997 1363.444225   21.26782
      1443 699.84 -21.33689  6422.72565 1369.348279   21.58088
      1444 700.16 -22.22250  6328.70359 1340.270813   21.45346
      1445 700.49 -28.42176  6101.84031 1273.702603   21.24092
      1446 700.81 -26.94574  5943.46406 1261.599292   21.58219
      1447 701.14 -11.59520  5639.11008 1191.636252   21.29347
      1448 701.46  -9.23358  5525.16183 1185.732198   21.59162
      1449 701.78 -24.87933  5305.82622 1141.894596   21.88780
      1450 702.11 -28.27416  5048.26187 1095.104968   22.12885
      1451 702.43 -40.37747  4938.59406 1073.850373   22.37867
      1452 702.76 -27.68375  4779.77501 1041.673279   22.24371
      1453 703.08 -21.18929  4681.76771 1014.957434   22.03181
      1454 703.41 -19.86088  4549.36930  992.374427   22.15330
      1455 703.73 -17.64686  4473.64981  956.507299   21.68982
      1456 704.06 -12.92362  4409.59082  962.706556   22.06053
      1457 704.38 -15.43284  4406.63879  963.296961   22.13283
      1458 704.70 -32.25939  4314.83075  934.071894   22.22938
      1459 705.03 -20.59889  4321.03001  925.363414   21.78819
      1460 705.35 -19.56568  4297.56139  919.902164   21.76141
      1461 705.68 -30.04537  4240.14447  905.142029   21.90037
      1462 706.00 -28.27416  4197.19247  912.964900   22.27539
      1463 706.32 -38.01585  4220.21829  923.149394   22.57192
      1464 706.65 -22.07490  4169.88622  904.108819   22.09428
      1465 706.97 -11.30000  4232.76440  925.658617   22.07692
      1466 707.30 -40.67267  4178.74231  901.599596   22.33182
      1467 707.62 -26.50294  4146.71281  941.747164   23.20153
      1468 707.94 -26.94574  4198.52089  946.175204   23.02990
      1469 708.27 -26.50294  4234.53562  926.249022   22.35962
      1470 708.59 -28.71696  4195.86406  936.876319   22.85655
      1471 708.91 -32.11179  4207.96737  940.271150   22.93313
      1472 709.24 -31.66899  4249.14815  955.474090   23.05969
      1473 709.56 -19.86088  4277.48761  957.392907   22.74085
      1474 709.89 -12.33321  4327.52447  967.577400   22.57933
      1475 710.21 -21.04169  4366.93403  976.138279   22.72528
      1476 710.53 -41.55828  4432.17383  971.857840   22.65259
      1477 710.86 -25.32213  4501.10366 1003.739731   22.73454
      1478 711.18 -40.08227  4546.41727  991.931623   22.50112
      1479 711.50 -22.96051  4587.74565 1005.363346   22.30296
      1480 711.83 -25.91254  4560.29180 1021.156691   22.83085
      1481 712.15 -29.45497  4579.47997 1011.267400   22.58054
      1482 712.47 -22.51770  4584.94122 1017.761860   22.57816
      1483 712.80 -23.55091  4480.88227  999.164090   22.70463
      1484 713.12 -34.76862  4422.28454  956.654900   22.24392
      1485 713.44  -1.85352  4375.64251  985.141961   22.54703
      1486 713.76 -23.10811  4290.32893  939.090340   22.30700
      1487 714.09 -28.86456  4331.80491  956.507299   22.59680
      1488 714.41 -39.78706  4224.05592  924.035002   22.60454
      1489 714.73 -18.53247  4287.52450  966.986995   22.88682
      1490 715.06 -14.39963  4248.41014  953.998076   22.71736
      1491 715.38 -15.13764  4233.50241  936.876319   22.40750
      1492 715.70  -2.44392  4221.98950  933.629090   22.15855
      1493 716.02 -16.46605  4242.50609  965.953786   23.06706
      1494 716.35 -11.74281  4240.43967  957.392907   22.79149
      1495 716.67 -16.90885  4141.10396  958.721319   23.46386
      1496 716.99  -0.52510  4193.20724  948.979630   22.64104
      1497 717.31 -11.59520  4089.73869  929.939056   22.95678
      1498 717.64 -14.39963  4055.19997  885.215846   22.10575
      1499 717.96 -16.90885  3991.14099  896.433549   22.78770
      1500 718.28 -28.12656  3950.84582  900.418786   23.33631
      1501 718.60 -32.40699  3866.12264  859.680813   22.88267
      1502 718.93 -19.56568  3812.83856  868.389292   23.16966
      1503 719.25 -13.51402  3731.06741  860.714022   23.34648
      1504 719.57 -21.77970  3714.83126  864.551657   23.72019
      1505 719.89  -7.60997  3615.20035  844.920677   23.53230
      1506 720.22 -15.72804  3595.42176  799.754664   22.58236
      1507 720.54 -16.90885  3539.48085  802.411488   23.03798
      1508 720.86 -16.76125  3513.94582  796.359833   23.02998
      1509 721.18 -35.21142  3464.20416  817.466826   24.36630
      1510 721.50 -29.60257  3468.92741  781.599698   23.18695
      1511 721.83 -20.74649  3438.22633  801.673481   23.77642
      1512 722.15 -21.92730  3432.17467  784.256522   23.33990
      1513 722.47 -23.84612  3431.14146  779.680880   23.25702
      1514 722.79 -19.12287  3375.49575  773.776826   23.35755
      1515 723.11 -19.27047  3410.77247  791.193786   23.62840
      1516 723.43 -14.39963  3407.23004  785.142130   23.36728
      1517 723.76 -17.20406  3354.53636  755.179056   22.90755
      1518 724.08 -11.15240  3331.95335  755.474258   22.93157
      1519 724.40 -11.00480  3371.36291  766.249157   22.97958
      1520 724.72 -30.48818  3376.23376  771.120002   23.53019
      1521 725.04 -19.56568  3397.93116  786.027738   23.57262
      1522 725.36 -29.45497  3367.82048  784.994529   23.97361
      1523 725.68 -12.77602  3393.06031  779.238076   23.25461
      1524 726.01 -24.14132  3437.19312  777.171657   23.15041
      1525 726.33 -19.86088  3375.64335  778.352468   23.50795
      1526 726.65 -25.76493  3450.47724  780.123684   23.18275
      1527 726.97 -30.19297  3425.68021  807.577536   24.24193
      1528 727.29 -31.37379  3500.36649  805.953921   23.70864
      1529 727.61 -26.20774  3529.29636  834.440981   24.20610
      1530 727.93 -20.89409  3539.03805  822.928076   23.70332
      1531 728.25  -9.52879  3632.76491  836.212198   23.22001
      1532 728.58 -10.26679  3627.15606  846.249090   23.54733
      1533 728.90 -13.80922  3594.97896  831.341353   23.41923
      1534 729.22 -26.65054  3572.24835  834.145779   23.91832
      1535 729.54 -17.49926  3596.89778  829.570137   23.43598
      1536 729.86 -21.18929  3537.56204  835.178988   24.06373
      1537 730.18 -25.76493  3561.76866  824.551691   23.70198
      1538 730.50 -31.66899  3584.20406  838.721421   24.07138
      1539 730.82 -12.18561  3572.98636  851.710340   24.09636
      1540 731.14 -13.80922  3586.27048  834.736184   23.57018
      1541 731.46 -39.78706  3648.85345  844.182671   23.96465
      1542 731.78 -26.50294  3617.56197  843.444664   23.87300
      1543 732.10 -23.84612  3601.62102  843.592265   23.92625
      1544 732.42 -16.90885  3662.72798  872.374529   24.16769
      1545 732.74 -31.81659  3621.10440  836.359799   23.76663
      1546 733.06 -46.13392  3628.48447  865.732468   24.81527
      1547 733.39 -35.80183  3584.20406  848.758313   24.43532
      1548 733.71 -31.96419  3561.76866  835.916995   24.14985
      1549 734.03 -35.50662  3557.63582  848.463110   24.60158
      1550 734.35 -20.89409  3451.06764  844.920677   24.93734
      1551 734.67 -22.07490  3360.29281  798.426252   24.25819
      1552 734.99 -36.53983  3317.04562  774.514833   24.18470
      1553 735.31 -28.42176  3285.31133  774.810036   24.23948
      1554 735.63 -30.04537  3252.98663  749.422603   23.74232
      1555 735.95  -2.88672  3170.62508  745.437367   23.58032
      1556 736.27 -16.02324  3139.18599  751.931826   24.33928
      1557 736.59 -16.17085  3080.44065  733.186454   24.19927
      1558 736.91 -15.28524  3101.69524  733.776860   24.03166
      1559 737.23 -33.29260  3060.36687  723.001961   24.44660
      1560 737.55 -41.55828  3058.59565  730.824833   24.91435
      1561 737.87 -18.97527  3116.89818  757.540677   24.76235
      1562 738.19 -15.13764  3107.74690  735.990880   24.05239
      1563 738.50 -15.87564  3142.72842  744.846961   24.08414
      1564 738.82 -21.77970  3143.17122  749.570204   24.37162
      1565 739.14 -31.07858  3169.29666  747.798988   24.33707
      1566 739.46 -12.92362  3169.73947  756.212265   24.16642
      1567 739.78 -29.60257  3143.61403  748.684596   24.52676
      1568 740.10 -31.22618  3114.09376  742.928144   24.61290
      1569 740.42 -20.15608  3086.34470  732.743650   24.23626
      1570 740.74 -27.53615  3017.41487  728.758414   24.83766
      1571 741.06 -20.89409  2995.12707  736.876488   25.12484
      1572 741.38 -25.46973  2961.47396  719.607130   24.94446
      1573 741.70 -13.21882  2875.27477  706.470610   24.91574
      1574 742.02  -9.67639  2843.83568  684.625610   24.33149
      1575 742.34 -25.32213  2810.92058  670.308279   24.52648
      1576 742.66  -2.44392  2786.56636  661.304596   23.79871
      1577 742.98 -10.56199  2759.55531  680.935576   24.96275
      1578 743.29  -4.06754  2697.26754  631.784326   23.53843
      1579 743.61 -20.00848  2669.37089  653.924529   25.05905
      1580 743.93 -20.15608  2680.73619  653.629326   24.94677
      1581 744.25 -23.25571  2647.82109  629.570306   24.44056
      1582 744.57 -23.69852  2626.27129  625.880272   24.51269
      1583 744.89 -14.99004  2627.15690  636.655171   24.66347
      1584 745.21 -11.44760  2590.10896  636.064765   24.88942
      1585 745.53 -31.96419  2583.46690  597.098008   24.05195
      1586 745.84 -22.96051  2518.96511  610.677333   24.92747
      1587 746.16 -24.87933  2501.40055  608.020508   25.05264
      1588 746.48 -30.48818  2522.95035  627.946691   25.78620
      1589 746.80 -13.95683  2523.54075  627.061083   25.26181
      1590 747.12 -42.29629  2497.26771  625.437468   26.29324
      1591 747.44 -17.20406  2473.65149  619.385813   25.55708
      1592 747.76 -22.81291  2520.44112  626.027873   25.51223
      1593 748.07 -33.88301  2509.96143  605.216083   25.12336
      1594 748.39 -35.65422  2526.19758  610.824934   25.23484
      1595 748.71 -31.52139  2498.74372  609.053718   25.31652
      1596 749.03 -36.09703  2504.35258  623.666252   25.97034
      1597 749.35 -28.42176  2551.43741  615.252975   24.95000
      1598 749.66 -24.58412  2517.63670  615.400576   25.17424
      1599 749.98 -28.27416  2496.52970  611.710542   25.34790
      1600 750.30 -29.01216  2496.97251  626.765880   25.96128
      1601 750.62 -19.12287  2461.40058  606.396894   25.21725
      1602 750.94 -20.00848  2468.92825  586.765914   24.37886
      1603 751.25 -18.38487  2475.86551  596.064799   24.63464
      1604 751.57 -11.89041  2418.44859  600.492840   25.19744
      1605 751.89 -28.71696  2421.99102  588.979934   25.20483
      1606 752.21 -24.43652  2385.97629  583.518684   25.22204
      1607 752.53 -28.42176  2407.67369  584.551894   25.16214
      1608 752.84 -34.76862  2376.08700  565.068515   24.88067
      1609 753.16 -27.24095  2394.83237  573.186590   24.78982
      1610 753.48 -34.91622  2385.53349  583.813887   25.56261
      1611 753.80 -13.51402  2360.14606  581.895069   25.08401
      1612 754.11  -9.52879  2359.70325  582.337873   24.98137
      1613 754.43 -11.44760  2354.38960  577.024225   24.87372
      1614 754.75 -16.90885  2324.42653  583.223481   25.63205
      1615 755.07 -34.76862  2304.64795  605.511286   27.36921
      1616 755.38 -17.64686  2309.96160  548.537164   24.32471
      1617 755.70 -38.90145  2303.46714  555.179225   25.36239
      1618 756.02 -28.71696  2262.13876  565.806522   25.95203
      1619 756.34 -27.09335  2279.40812  572.448583   25.99356
      1620 756.65 -33.29260  2296.23467  549.717975   25.02699
      1621 756.97 -32.25939  2250.92106  576.433819   26.65988
      1622 757.29  -6.72436  2265.53359  562.854495   25.06665
      1623 757.60  -1.55831  2282.80295  568.168144   24.94030
      1624 757.92 -23.25571  2322.21251  582.485475   25.82602
      1625 758.24 -18.53247  2327.96896  571.710576   25.15417
      1626 758.55 -24.73172  2343.46710  580.123853   25.54074
      1627 758.87 -16.61365  2386.41910  605.954090   25.90758
      1628 759.19 -11.30000  2385.23829  604.773279   25.70680
      1629 759.50 -16.61365  2399.26041  613.334157   26.07536
      1630 759.82 -15.72804  2400.73643  614.662569   26.08731
      1631 760.14 -25.32213  2380.81024  623.223448   26.95386
      1632 760.45 -13.51402  2374.16818  611.562941   26.17924
      1633 760.77 -37.13024  2396.89879  608.906117   26.54185
      1634 761.09 -21.63210  2394.97997  611.710542   26.20787
      1635 761.40 -15.72804  2417.71058  585.585103   24.71043
      1636 761.72  -4.06754  2425.23825  603.592468   25.01373
      1637 762.04 -21.48449  2435.42274  638.131184   26.84740
      1638 762.35 -24.28892  2504.20497  658.204968   26.99211
      1639 762.67 -22.66531  2628.04251  688.906049   26.84458
      1640 762.99 -24.73172  2896.38176  779.680880   27.53788
      1641 763.30 -26.35534  3089.00153  786.470542   26.09094
      1642 763.62 -26.79814  3253.28183  849.348718   26.71114
      1643 763.93 -29.30737  3441.17835  898.499968   26.73422
      1644 764.25  -7.60997  3515.27423  897.319157   25.68717
      1645 764.57 -23.55091  3562.94947  916.507333   26.21102
      1646 764.88 -10.26679  3499.33329  869.717704   25.07364
      1647 765.20 -16.17085  3295.64342  814.662400   25.08695
      1648 765.51 -29.01216  3142.43322  777.614461   25.43404
      1649 765.83 -24.28892  3015.20085  729.496421   24.79973
      1650 766.15 -12.92362  2813.13460  742.042536   26.71446
      1651 766.46 -32.25939  2736.38190  699.828549   26.44214
      1652 766.78 -22.22250  2620.07204  686.839630   26.83509
      1653 767.09 -15.58044  2536.23447  663.961421   26.62975
      1654 767.41 -21.48449  2521.62193  650.529698   26.42493
      1655 767.72 -24.14132  2393.20876  626.175475   26.90205
      1656 768.04 -22.66531  2342.72910  595.769596   26.14511
      1657 768.36 -17.79446  2282.21254  599.607231   26.84347
      1658 768.67  -9.67639  2245.60741  576.138617   25.97522
      1659 768.99 -27.83135  2206.34545  587.061117   27.52210
      1660 769.30 -14.69483  2173.43035  566.101725   26.54311
      1661 769.62 -28.12656  2092.54481  555.031623   27.49875
      1662 769.93 -23.55091  2110.55217  543.075914   26.55105
      1663 770.25 -33.58781  2087.52636  520.788110   26.13607
      1664 770.56  -7.16716  2057.56329  533.481826   26.18497
      1665 770.88 -26.06014  1999.99876  514.441252   26.67748
      1666 771.19 -28.71696  1990.84747  516.212468   26.98252
      1667 771.51 -33.58781  1976.38254  508.980002   26.99382
      1668 771.82 -33.29260  1943.17224  494.662671   26.71210
      1669 772.14 -40.52507  1967.67406  496.433887   26.73833
      1670 772.45 -30.48818  1897.71102  497.467096   27.38074
      1671 772.77 -16.61365  1890.33095  511.046421   27.67045
      1672 773.08 -38.16345  1883.98410  503.961556   28.20413
      1673 773.40 -29.15977  1884.72210  488.168211   27.03030
      1674 773.71 -15.58044  1852.10220  488.906218   27.01137
      1675 774.03 -27.38855  1822.58193  500.566725   28.53858
      1676 774.34 -15.58044  1831.88082  470.898853   26.33231
      1677 774.66 -34.47341  1806.05058  470.751252   27.45005
      1678 774.97 -23.69852  1806.05058  477.540914   27.39389
      1679 775.29 -17.64686  1797.78491  461.747569   26.40663
      1680 775.60 -31.81659  1822.28673  463.075981   26.69175
      1681 775.91 -23.25571  1794.53768  471.341657   27.20867
      1682 776.23 -18.53247  1754.98051  479.459731   28.07942
      1683 776.54 -26.35534  1732.39751  460.566758   27.68565
      1684 776.86 -37.86824  1773.13548  456.729123   27.31068
      1685 777.17 -22.51770  1710.84771  450.825069   27.30773
      1686 777.49 -33.73541  1739.03957  447.577840   27.15027
      1687 777.80 -35.94943  1715.71856  455.400711   28.05041
      1688 778.11 -16.76125  1736.82555  452.153481   26.74032
      1689 778.43 -12.48081  1744.05801  445.363819   26.06516
      1690 778.74 -20.00848  1737.85876  439.902569   26.16301
      1691 779.06 -19.27047  1719.26099  433.850914   26.06346
      1692 779.37 -12.77602  1724.27943  441.821387   26.17058
      1693 779.68  -7.46237  1708.19089  446.692231   26.47123
      1694 780.00 -22.51770  1706.12447  436.360137   26.54557
      1695 780.31 -25.32213  1702.72964  448.906252   27.44295
      1696 780.63 -29.01216  1701.69643  427.208853   26.36036
      1697 780.94 -32.84980  1657.71122  435.031725   27.67611
      1698 781.25 -26.50294  1673.94737  450.234664   28.03596
      1699 781.57 -26.35534  1641.91788  449.201454   28.50593
      1700 781.88 -27.68375  1643.24629  427.799258   27.25925
      1701 782.19 -26.06014  1636.89943  423.814022   27.05262
      1702 782.51 -11.59520  1613.43082  436.212536   27.55696
      1703 782.82 -18.68007  1581.40133  413.629529   27.01798
      1704 783.13 -25.46973  1575.64487  399.755002   26.55804
      1705 783.45 -32.70220  1557.04710  407.430272   27.68565
      1706 783.76  -1.26311  1529.44565  408.611083   26.77676
      1707 784.07  -3.62473  1532.54528  408.611083   26.83530
      1708 784.39 -15.43284  1536.38291  411.858313   27.53492
      1709 784.70  -6.28156  1506.71504  392.079731   26.32929
      1710 785.01 -25.02693  1526.93643  420.419191   28.70210
      1711 785.33 -16.90885  1503.17261  402.264225   27.57570
      1712 785.64 -27.24095  1500.22058  407.135069   28.43777
      1713 785.95 -36.98264  1488.56008  383.961657   27.59308
      1714 786.27 -16.31845  1473.94754  408.020677   28.47405
      1715 786.58 -27.24095  1495.49734  390.898921   27.45973
      1716 786.89 -28.56936  1452.98815  389.718110   28.23296
      1717 787.20 -29.89777  1496.97335  389.422907   27.46274
      1718 787.52 -25.02693  1516.60433  418.205171   28.75085
      1719 787.83 -21.48449  1578.15410  422.485610   27.75440
      1720 788.14 -23.40331  1597.19467  437.688549   28.45196
      1721 788.46 -20.74649  1620.36808  445.511421   28.41105
      1722 788.77 -22.51770  1655.79241  455.843515   28.50255
      1723 789.08 -38.16345  1651.51197  454.515103   29.15818
      1724 789.39 -38.45865  1662.43447  458.500340   29.21753
      1725 789.71 -18.53247  1646.34592  454.957907   28.43994
      1726 790.02 -31.96419  1623.46771  428.242063   27.79977
      1727 790.33 -13.07122  1593.06183  413.777130   26.57615
      1728 790.64  -4.36274  1541.84416  417.319563   27.27205
      1729 790.95 -34.91622  1528.56004  431.932096   29.85964
      1730 791.27 -22.51770  1498.44937  418.205171   28.97649
      1731 791.58 -33.44020  1469.07670  396.950576   28.64465
      1732 791.89 -31.22618  1415.20220  385.585272   28.81660
      1733 792.20 -26.65054  1430.70035  402.707029   29.46151
      1734 792.52 -23.40331  1398.96606  380.566826   28.40121
      1735 792.83 -29.60257  1384.50112  376.286387   28.70291
      1736 793.14 -10.26679  1363.39413  386.913684   28.91401
      1737 793.45 -16.02324  1348.04359  385.142468   29.40953
      1738 793.76 -16.31845  1351.14322  372.596353   28.44064
      1739 794.08 -18.23727  1331.95504  371.563144   28.86999
      1740 794.39 -35.94943  1346.41997  362.264258   28.80660
      1741 794.70 -25.17453  1345.09156  365.511488   28.51169
      1742 795.01 -26.50294  1354.39045  364.330677   28.30295
      1743 795.32 -28.86456  1370.62660  367.430306   28.31707
      1744 795.63 -32.70220  1394.39041  374.810373   28.55544
      1745 795.95 -34.03061  1418.74464  389.570508   29.15806
      1746 796.26 -14.39963  1413.43099  402.264225   29.18160
      1747 796.57 -23.99372  1438.81842  388.242096   28.18105
      1748 796.88 -16.46605  1445.75568  380.271623   27.13252
      1749 797.19 -11.89041  1437.93281  391.636927   27.83286
      1750 797.50 -17.35166  1433.94758  401.378617   28.85210
      1751 797.81 -17.35166  1427.15791  398.426590   28.78335
      1752 798.13  -0.52510  1386.41994  393.408144   28.40295
      1753 798.44 -13.21882  1385.38673  386.175677   28.55662
      1754 798.75 -27.68375  1361.77051  359.755036   27.88424
      1755 799.06 -29.75017  1338.89231  343.223684   27.25137
      1756 799.37 -37.72064  1341.84433  377.171995   30.07416
      1757 799.68  -4.51034  1322.80376  375.843583   28.65591
      1758 799.99  -7.46237  1320.14693  356.212603   27.39322
      1759 800.30 -17.20406  1302.72997  354.293786   28.14518
      1760 800.61 -30.04537  1268.63406  342.633279   28.69674
      1761 800.92 -30.78338  1263.17281  352.965373   29.65701
      1762 801.24 -16.61365  1229.96251  358.279022   30.07379
      1763 801.55 -20.45129  1229.37210  347.799326   29.46421
      1764 801.86 -22.22250  1222.73004  344.552096   29.46093
      1765 802.17 -25.46973  1219.18761  368.463515   31.64994
      1766 802.48 -25.61733  1218.30200  323.149900   28.03777
      1767 802.79 -26.65054  1190.84815  320.050272   28.47648
      1768 803.10 -16.76125  1221.25403  344.404495   29.17296
      1769 803.41 -17.49926  1198.67102  329.349157   28.51972
      1770 803.72 -28.12656  1176.38322  319.312265   28.84483
      1771 804.03 -21.92730  1164.72271  327.135137   29.41579
      1772 804.34 -35.94943  1188.04372  327.873144   29.72423
      1773 804.65 -12.92362  1184.94410  303.076117   26.38019
      1774 804.96 -27.53615  1184.05849  322.854698   28.91981
      1775 805.27 -22.07490  1214.61197  316.507840   27.37821
      1776 805.58 -29.30737  1191.88136  333.481995   29.70789
      1777 805.89 -25.46973  1210.92193  335.105610   29.16352
      1778 806.20 -30.48818  1205.46068  341.600069   30.10547
      1779 806.51 -45.24831  1224.05845  357.245813   31.70976
      1780 806.82 -27.53615  1226.56768  324.183110   28.04547
      1781 807.13 -28.42176  1201.77065  321.526286   28.44661
      1782 807.44 -30.63578  1184.50129  321.083481   28.94482
      1783 807.75 -16.90885  1186.56771  323.887907   28.31769
      1784 808.06 -36.98264  1176.23562  324.625914   29.80573
      1785 808.37 -13.07122  1128.41278  334.220002   30.42454
      1786 808.68 -15.58044  1140.22089  312.079799   28.34918
      1787 808.99 -28.86456  1106.27258  322.854698   30.98474
      1788 809.30 -17.79446  1118.81869  294.958042   27.51618
      1789 809.61 -35.80183  1095.79288  334.220002   32.69915
      1790 809.92 -26.50294  1073.65268  320.197873   31.51380
      1791 810.23 -36.24463  1057.12133  291.563211   29.98153
      1792 810.54 -29.01216  1059.92575  305.290137   30.69985
      1793 810.85 -24.87933  1067.01062  290.825204   28.91359
      1794 811.16 -23.69852  1037.19514  289.349191   29.50793
      1795 811.47 -19.86088  1033.06231  281.969123   28.66591
      1796 811.78 -20.30368  1041.18038  279.902704   28.28176
      1797 812.08 -23.84612  1013.57893  272.670238   28.58195
      1798 812.39 -18.23727  1023.02541  288.906387   29.49723
      1799 812.70 -27.83135  1005.90366  275.622265   29.35507
      1800 813.01 -25.46973  1005.46085  292.448819   30.83802
      1801 813.32 -32.70220  1017.41656  269.275407   28.75652
      1802 813.63 -16.17085   984.94426  282.559529   29.83976
      1803 813.94 -16.31845   977.41660  274.736657   29.28900
      1804 814.25 -34.03061   966.34649  277.983887   31.18969
      1805 814.56 -17.94206   974.16937  296.729258   31.71734
      1806 814.87 -49.38115   968.85572  279.017096   32.25166
      1807 815.17 -16.90885   984.05866  279.017096   29.56399
      1808 815.48 -19.56568   983.32065  289.201590   30.78786
      1809 815.79 -36.39223   967.82251  293.039225   32.80488
      1810 816.10 -32.40699   980.07342  273.555846   30.21914
      1811 816.41 -21.48449   985.68227  273.851049   29.32340
      1812 816.72 -29.15977   991.43872  281.969123   30.48495
      1813 817.03 -14.39963   984.50146  319.902671   33.46701
      1814 817.33 -41.55828  1000.73761  289.496792   31.76210
      1815 817.64 -17.05645  1013.87413  284.478346   29.24880
      1816 817.95 -31.66899  1008.85568  302.780914   32.14243
      1817 818.26 -46.42912  1040.73758  317.983853   33.51951
      1818 818.57 -35.21142  1011.06970  296.876860   31.73987
      1819 818.88 -22.37010  1061.69697  337.319630   33.17966
      1820 819.18 -13.21882  1124.87035  352.079765   32.09754
      1821 819.49 -24.28892  1190.99575  339.238448   29.91294
      1822 819.80  -7.90517  1260.51599  392.670137   31.58062
      1823 820.11  -8.05277  1348.78160  397.245779   29.87089
      1824 820.42 -22.81291  1414.31660  442.706995   32.39234
      1825 820.72  -4.51034  1515.42352  493.481860   32.76407
      1826 821.03  -0.96791  1643.54149  504.847164   30.75781
      1827 821.34 -23.55091  1962.50801  685.511218   35.70197
      1828 821.65 -23.25571  2700.21957  969.496218   36.45166
      1829 821.95 -18.38487  3815.34778 1259.090069   33.32196
      1830 822.26 -16.31845  4823.02220 1496.580644   31.26250
      1831 822.57 -36.68743  5725.30926 1720.196691   30.49089
      1832 822.88 -24.43652  6377.26443 1911.340441   30.23848
      1833 823.19 -18.68007  6845.30832 1995.620813   29.34592
      1834 823.49 -20.30368  7072.02399 1980.122671   28.20550
      1835 823.80 -33.44020  6641.91366 1775.694799   27.10171
      1836 824.11 -14.69483  5800.29075 1577.908988   27.38792
      1837 824.42 -26.50294  5037.78217 1403.444191   28.23591
      1838 824.72 -20.89409  4420.07051 1244.625137   28.49649
      1839 825.03 -27.83135  3958.96389 1128.758076   29.01050
      1840 825.34 -22.81291  3618.15237 1076.950002   30.20526
      1841 825.64 -22.81291  3329.73933 1011.857806   30.86218
      1842 825.95 -28.27416  3073.94619  951.931657   31.59691
      1843 826.26  -5.24835  2885.60687  946.765610   32.93191
      1844 826.57 -39.19666  2929.59207  983.223144   34.43895
      1845 826.87 -22.22250  3052.10119 1025.584731   34.08253
      1846 827.18 -16.31845  3108.04210 1006.396556   32.73358
      1847 827.49  -9.82399  3164.72102 1009.348583   32.10452
      1848 827.79 -28.71696  3185.97562  987.208380   31.60257
      1849 828.10 -19.27047  3194.38889  987.651184   31.33256
      1850 828.41 -27.68375  3112.47014  917.540542   30.10121
      1851 828.71 -25.02693  2869.37072  822.337671   29.27603
      1852 829.02 -21.63210  2569.44477  723.887569   28.77258
      1853 829.33 -32.40699  2251.21626  659.090576   30.28072
      1854 829.63 -21.92730  2033.06146  585.142299   29.54126
      1855 829.94 -18.82767  1849.59298  546.323144   30.24751
      1856 830.25 -33.58781  1675.86619  515.917265   32.14506
      1857 830.55 -56.90882  1572.10244  473.260475   32.54547
      1858 830.86 -28.56936  1459.03981  462.780779   33.02952
      1859 831.17 -20.45129  1345.82957  439.902569   33.69394
      1860 831.47 -25.32213  1267.89606  415.253144   34.06813
      1861 831.78 -29.89777  1183.46808  385.880475   34.26652
      1862 832.08 -22.07490  1122.36112  384.109258   35.49208
      1863 832.39 -18.23727  1108.92940  357.393414   33.32521
      1864 832.70 -32.25939  1128.26518  373.481961   34.96189
      1865 833.00 -35.06382  1190.70055  384.699664   34.24504
      1866 833.31 -27.09335  1371.80741  441.968988   33.53078
      1867 833.62 -19.41808  1561.62274  501.009529   32.91677
      1868 833.92 -20.45129  1731.51190  534.072231   31.65155
      1869 834.23 -29.01216  1849.59298  559.164461   31.30922
      1870 834.53  -3.91993  1935.05416  569.053752   29.55035
      1871 834.84 -29.89777  1976.67774  607.282502   31.75461
      1872 835.14 -22.22250  1919.55602  577.024225   30.86071
      1873 835.45 -29.01216  1834.98045  529.791792   29.97887
      1874 835.76 -32.40699  1687.23149  508.832400   31.47402
      1875 836.06 -21.63210  1555.57109  468.980036   31.10646
      1876 836.37 -39.34426  1427.60072  436.950542   32.46848
      1877 836.67 -12.48081  1331.06943  398.721792   30.60567
      1878 836.98 -24.73172  1221.99204  368.168313   31.51460
      1879 837.28 -33.58781  1158.96626  351.341758   32.27775
      1880 837.59 -31.96419  1066.86301  352.227367   34.96378
      1881 837.89 -22.22250  1016.97376  319.459867   32.87948
      1882 838.20 -19.71328   930.77457  310.013380   34.69026
      1883 838.50 -43.47710   858.44991  274.589056   35.26518
      1884 838.81 -18.82767   804.42781  275.031860   35.69482
      1885 839.12 -10.56199   787.30606  252.301252   32.94570
      1886 839.42  -9.38118   789.37247  252.891657   32.83526
      1887 839.73 -11.59520   806.19903  269.865813   34.41709
      1888 840.03 -19.12287   837.04771  272.670238   34.08119
      1889 840.34  -1.85352   850.33183  259.238515   30.63794
      1890 840.64 -14.84243   872.17683  272.375036   32.38007
      1891 840.95  -7.16716   872.61964  279.459900   32.57915
      1892 841.25 -14.99004   850.18423  262.190542   32.03754
      1893 841.55 -20.00848   879.99970  262.338144   31.37156
      1894 841.86 -20.59889   809.29866  233.703481   30.64262
      1895 842.16 -26.35534   761.47582  223.814191   31.75421
      1896 842.47 -25.02693   717.63822  222.190576   33.28788
      1897 842.77 -20.30368   685.90393  196.065137   30.63813
      1898 843.08 -29.75017   669.66778  191.784698   31.67418
      1899 843.38 -29.75017   652.25082  184.109427   31.35767
      1900 843.69 -27.68375   609.15122  177.024563   32.14464
      1901 843.99 -15.13764   579.77856  207.578042   37.43648
      1902 844.30 -18.53247   566.49443  180.124191   33.95684
      1903 844.60 -18.53247   541.99261  173.039326   34.17720
      1904 844.90 -23.84612   532.39852  155.622367   32.26431
      1905 845.21 -30.93098   503.61626  147.651894   33.40825
      1906 845.51 -20.59889   528.85609  135.400981   28.39175
      1907 845.82 -24.73172   499.18822  149.423110   33.24073
      1908 846.12 -23.10811   466.42072  120.493245   29.33461
      1909 846.43  -5.24835   454.02220  156.065171   35.12385
      1910 846.73 -18.97527   447.52774  141.895441   34.48439
      1911 847.03 -24.28892   454.61261  125.954495   31.37251
      1912 847.34 -18.23727   428.33957  115.917603   30.04071
      1913 847.64 -30.63578   423.46872  130.972941   35.58844
      1914 847.94 -12.77602   433.06281  110.456353   27.64056
      1915 848.25 -46.42912   399.40970  117.393617   36.74483
      1916 848.55 -18.82767   402.50933  127.282907   34.67784
      1917 848.86 -22.51770   408.41339  112.670373   31.37116
      1918 849.16 -32.11179   395.27687  116.803211   34.84299
      1919 849.46 -39.78706   392.91524  130.087333   39.25895
      1920 849.77 -17.94206   390.84883  114.441590   32.38420
      1921 850.07 -25.91254   400.29531  116.212806   33.34649
      1922 850.37 -22.07490   405.01856  128.906522   35.35091
      1923 850.68 -30.93098   394.98166  117.246015   34.79047
      1924 850.98 -29.15977   381.40234  103.223887   32.24449
      1925 851.28 -23.40331   394.24366  102.633481   30.17783
      1926 851.59 -17.20406   383.32116   86.102130   25.79268
      1927 851.89 -40.22987   369.00383  112.817975   37.39864
      1928 852.19 -34.62102   378.89312  107.209123   34.29874
      1929 852.50  -4.51034   382.28795  111.637164   30.02793
      1930 852.80 -34.32581   361.91896   99.533853   33.78206
      1931 853.10 -12.03801   341.84518   95.991421   30.52686
      1932 853.41 -17.05645   371.21785  109.570745   32.61282
      1933 853.71 -23.25571   365.01859  112.670373   35.00775
      1934 854.01 -22.51770   363.54258  104.847502   32.99102
      1935 854.31 -10.26679   370.18464  119.607637   34.13693
      1936 854.62  -7.90517   346.12562  109.865948   33.26578
      1937 854.92 -40.96787   345.09241  111.489563   39.49058
      1938 855.22 -34.76862   346.27322  104.699900   36.60189
      1939 855.53 -17.35166   332.10349   97.467434   32.85660
      1940 855.83 -42.00108   365.01859  102.043076   35.38997
      1941 856.13 -20.00848   354.83410  107.651927   34.05707
      1942 856.43 -42.59149   348.48724   90.382569   34.00186
      1943 856.74 -22.81291   331.21788  114.293988   38.72739
      1944 857.04 -22.22250   330.33227  104.847502   36.04263
      1945 857.34 -24.58412   357.04812  105.585508   34.10866
      1946 857.64 -19.86088   347.01122   82.707299   27.95748
      1947 857.94 -27.97895   331.07028  109.275542   38.22721
      1948 858.25 -29.15977   326.64224  100.714664   36.50188
      1949 858.55 -22.96051   334.16991   86.840137   30.74525
      1950 858.85 -23.40331   325.75663   95.401015   34.02576
      1951 859.15 -30.19297   327.23264   97.910238   35.84052
      1952 859.46 -16.46605   343.17359   97.172231   31.59782
      1953 859.76 -34.32581   346.56842  116.950813   39.71618
      1954 860.06 -13.51402   323.39501   95.696218   32.41535
      1955 860.36 -16.76125   326.49464  110.013549   36.93303
      1956 860.66 -14.25203   321.77139   96.139022   32.85219
      1957 860.97 -15.58044   333.87470   84.183313   28.54837
      1958 861.27 -11.89041   319.26217  106.766319   35.83144
      1959 861.57  -2.00112   316.45774  105.585508   33.78352
      1960 861.87 -25.91254   301.69761   95.253414   36.98480
      1961 862.17 -26.20774   306.56845   92.448988   35.65662
      1962 862.47 -35.50662   312.47251   92.153786   36.68623
      1963 862.78 -20.74649   303.76403   95.696218   35.88257
      1964 863.08 -27.83135   312.47251   76.803245   30.74740
      1965 863.38 -37.27784   313.21051   74.294022   31.83326
      1966 863.68 -27.97895   313.06291   90.087367   34.61930
      1967 863.98  -6.13395   324.57582   86.544934   28.02424
      1968 864.28 -18.53247   325.46143   78.722063   28.27217
      1969 864.58 -26.65054   324.87102   87.725745   32.53749
      1970 864.88 -16.61365   324.57582  122.116860   40.66084
      1971 865.19 -16.61365   346.86362  102.485880   32.76671
      1972 865.49 -16.90885   329.29906  101.157468   34.10272
      1973 865.79 -17.05645   326.93744  109.865948   36.89670
      1974 866.09 -30.63578   340.51676   84.330914   30.97559
      1975 866.39 -36.24463   317.49095  101.452671   38.92662
      1976 866.69 -25.17453   317.19575   92.153786   34.26942
      1977 866.99 -25.17453   313.35812   86.249731   32.91389
      1978 867.29 -19.71328   307.01126   78.279258   29.99240
      1979 867.59 -18.97527   304.35443   83.297704   31.63117
      1980 867.89 -36.24463   289.00389  109.570745   44.83199
      1981 868.19 -22.96051   304.50204   86.544934   33.44060
      1982 868.50 -24.73172   309.96329   89.496961   34.12919
      1983 868.80 -31.96419   295.64595   92.596590   38.02104
      1984 869.10 -23.55091   308.93008   86.692536   33.15782
      1985 869.40 -31.37379   312.91531   80.493279   32.49219
      1986 869.70 -23.99372   323.54261   90.825373   33.03801
      1987 870.00  -5.69115   328.41345   95.843819   30.39017
      1988 870.30 -13.80922   316.01494  105.142704   36.06526
      1989 870.60 -21.04169   324.13301  109.865948   37.92504
      1990 870.90 -36.53983   317.63856   93.777400   36.79424
      1991 871.20 -19.12287   318.67176   87.430542   31.54384
      1992 871.50 -18.23727   312.91531   97.467434   34.94000
      1993 871.80 -30.63578   313.06291  102.781083   38.81797
      1994 872.10 -23.40331   335.64592  102.781083   35.14404
      1995 872.40 -27.38855   316.16254  112.965576   40.85393
      1996 872.70 -19.41808   322.65700  111.046758   38.13924
      1997 873.00 -24.73172   319.85258  110.308752   39.18939
      1998 873.30 -13.36642   335.05551  105.585508   34.14020
      1999 873.60 -29.01216   323.83781  101.747873   37.05825
      2000 873.90 -40.67267   334.02231  103.814292   38.56122
      2001 874.20   1.68892   343.61639  116.655610   33.62312
      2002 874.50 -17.79446   341.25477  116.655610   37.44614
      2003 874.80 -46.42912   348.04443  107.947130   39.13475
      2004 875.10 -35.65422   337.26954  110.308752   39.14017
      2005 875.40 -36.68743   334.31751  104.257096   37.98993
      2006 875.70 -30.34058   325.90423  101.157468   36.91227
      2007 876.00 -26.35534   342.14038   92.448988   32.24035
      2008 876.30 -29.60257   325.90423  105.290306   37.94382
      2009 876.59 -29.45497   335.94112  107.799529   37.56321
      2010 876.89 -36.68743   343.76399   98.205441   35.45600
      2011 877.19   1.98412   332.98910  127.873313   38.03242
      2012 877.49 -44.36270   335.64592  114.589191   41.82850
      2013 877.79 -33.73541   348.93004  121.674056   40.61236
      2014 878.09 -25.02693   347.60163  105.290306   34.97242
      2015 878.39 -22.96051   353.80089   93.186995   30.82787
      2016 878.69 -15.43284   364.87099  121.969258   36.12956
      2017 878.99 -23.25571   382.73075  109.127941   32.60790
      2018 879.29 -17.94206   374.46508  115.770002   34.07483
      2019 879.59  -9.52879   378.89312  131.563346   36.32445
      2020 879.88 -19.56568   416.67906  147.651894   38.33114
      2021 880.18 -16.90885   459.48345  161.378819   37.42455
      2022 880.48 -26.06014   504.20666  174.958144   37.90889
      2023 880.78 -20.74649   609.29883  225.880610   39.14434
      2024 881.08 -18.53247   807.08464  276.655475   35.75361
      2025 881.38 -12.48081  1072.91467  401.526218   38.14343
      2026 881.68 -15.58044  1478.81839  520.935711   35.90180
      2027 881.98 -18.97527  1824.05795  623.961454   34.88471
      2028 882.27 -18.82767  2140.51524  716.507502   34.05365
      2029 882.57 -13.80922  2406.64048  815.695610   34.27069
      2030 882.87 -20.45129  2588.78055  871.193718   34.17270
      2031 883.17 -16.90885  2697.56274  924.625407   34.68573
      2032 883.47  -2.44392  2716.60332  898.057164   33.11826
      2033 883.77 -16.17085  2545.53335  840.640238   33.44692
      2034 884.06 -21.77970  2354.24200  798.573853   34.52635
      2035 884.36  -7.01956  2132.10197  748.536995   35.32088
      2036 884.66 -37.13024  1923.83646  667.061049   35.91042
      2037 884.96 -12.77602  1779.62994  629.865508   35.85357
      2038 885.26  -5.24835  1612.25001  601.968853   37.54051
      2039 885.55 -21.33689  1449.59332  534.072231   37.75904
      2040 885.85 -14.25203  1297.85913  507.208786   39.74212
      2041 886.15 -28.27416  1149.81497  459.090745   41.36910
      2042 886.45 -38.01585   977.41660  421.600002   45.26307
      2043 886.75 -24.14132   835.57170  344.994900   42.93714
      2044 887.04 -26.65054   736.08839  303.223718   43.24865
      2045 887.34  -6.72436   659.18808  261.895340   40.33859
      2046 887.64 -25.02693   589.96305  233.703481   42.07067
      2047 887.94 -23.40331   553.65312  211.268076   40.66697
      2048 888.23 -26.50294   523.69004  193.851117   40.05032
      
      $metadata
       [1] "doutrelant"          "2015-12-04 10:29:14" "JazUSB"             
       [4] "JAZA2982"            "60"                  "60"                 
       [7] "60"                  "15"                  "15"                 
      [10] "15"                  "0"                   "0"                  
      [13] "0"                  
      

---

    Code
      lr_parse_procspec(test.file("procspec_files", "OceanOptics_badencode.ProcSpec"))
    Output
      $data
               wl    dark white   scope   processed
      1    179.25  795.62   100  795.62 -1.3818e+03
      2    179.63  795.62   100  795.62 -1.3818e+03
      3    180.01  795.62   100  795.62 -1.3818e+03
      4    180.38  751.80   100  751.80 -1.1650e+03
      5    180.76  753.63   100  753.63 -1.9183e+03
      6    181.14  767.40   100  767.40 -1.5073e+03
      7    181.51  766.55   100  766.55 -1.5764e+03
      8    181.89  766.30   100  766.30 -1.6010e+03
      9    182.27  767.29   100  767.29 -1.5839e+03
      10   182.65  773.30   100  773.30 -1.5850e+03
      11   183.02  781.21   100  781.21 -1.6240e+03
      12   183.40  790.07   100  790.07 -1.5523e+03
      13   183.78  800.10   100  800.10 -1.4877e+03
      14   184.15  812.68   100  812.68 -1.5446e+03
      15   184.53  825.40   100  825.40 -1.5633e+03
      16   184.91  839.04   100  839.04 -1.5765e+03
      17   185.28  853.19   100  853.19 -1.5771e+03
      18   185.66  866.85   100  866.85 -1.4816e+03
      19   186.04  881.03   100  881.03 -1.3879e+03
      20   186.41  896.05   100  896.05 -1.2673e+03
      21   186.79  910.69   100  910.69 -1.1349e+03
      22   187.17  924.79   100  924.79 -1.0001e+03
      23   187.54  938.64   100  938.64 -9.1784e+02
      24   187.92  951.84   100  951.84 -8.2779e+02
      25   188.30  964.49   100  964.49 -7.5863e+02
      26   188.67  976.89   100  976.89 -7.0393e+02
      27   189.05  988.87   100  988.87 -6.5752e+02
      28   189.43 1000.21   100 1000.21 -6.2211e+02
      29   189.80 1011.22   100 1011.22 -5.9633e+02
      30   190.18 1022.13   100 1022.13 -5.7856e+02
      31   190.56 1030.38   100 1030.38 -5.6416e+02
      32   190.93 1039.35   100 1039.35 -5.7679e+02
      33   191.31 1046.77   100 1046.77 -5.7011e+02
      34   191.69 1053.96   100 1053.96 -5.6426e+02
      35   192.06 1061.33   100 1061.33 -5.7647e+02
      36   192.44 1067.21   100 1067.21 -5.7798e+02
      37   192.82 1071.70   100 1071.70 -5.6271e+02
      38   193.19 1075.80   100 1075.80 -5.6205e+02
      39   193.57 1079.15   100 1079.15 -5.5972e+02
      40   193.95 1081.92   100 1081.92 -5.5468e+02
      41   194.32 1083.81   100 1083.81 -5.4975e+02
      42   194.70 1086.04   100 1086.04 -5.5502e+02
      43   195.07 1087.48   100 1087.48 -5.4682e+02
      44   195.45 1088.38   100 1088.38 -5.4583e+02
      45   195.83 1088.98   100 1088.98 -5.5245e+02
      46   196.20 1088.41   100 1088.41 -5.4475e+02
      47   196.58 1087.37   100 1087.37 -5.3449e+02
      48   196.96 1087.53   100 1087.53 -5.4243e+02
      49   197.33 1086.84   100 1086.84 -5.3622e+02
      50   197.71 1086.39   100 1086.39 -5.4098e+02
      51   198.08 1085.59   100 1085.59 -5.4200e+02
      52   198.46 1084.78   100 1084.78 -5.4302e+02
      53   198.84 1083.77   100 1083.77 -5.4596e+02
      54   199.21 1082.12   100 1082.12 -5.4143e+02
      55   199.59 1081.68   100 1081.68 -5.5464e+02
      56   199.96 1079.99   100 1079.99 -5.4933e+02
      57   200.34 1079.44   100 1079.44 -5.6269e+02
      58   200.72 1078.22   100 1078.22 -5.6845e+02
      59   201.09 1076.73   100 1076.73 -5.6922e+02
      60   201.47 1075.37   100 1075.37 -5.7690e+02
      61   201.84 1073.26   100 1073.26 -5.6701e+02
      62   202.22 1071.60   100 1071.60 -5.6879e+02
      63   202.60 1069.88   100 1069.88 -5.6313e+02
      64   202.97 1068.96   100 1068.96 -5.6634e+02
      65   203.35 1067.47   100 1067.47 -5.7097e+02
      66   203.72 1065.44   100 1065.44 -5.6005e+02
      67   204.10 1065.80   100 1065.80 -5.6838e+02
      68   204.48 1064.04   100 1064.04 -5.5775e+02
      69   204.85 1063.62   100 1063.62 -5.5936e+02
      70   205.23 1062.80   100 1062.80 -5.5869e+02
      71   205.60 1061.58   100 1061.58 -5.4934e+02
      72   205.98 1060.64   100 1060.64 -5.4426e+02
      73   206.35 1060.84   100 1060.84 -5.4491e+02
      74   206.73 1060.78   100 1060.78 -5.4837e+02
      75   207.11 1059.75   100 1059.75 -5.3611e+02
      76   207.48 1059.85   100 1059.85 -5.3252e+02
      77   207.86 1059.36   100 1059.36 -5.2638e+02
      78   208.23 1058.15   100 1058.15 -5.1533e+02
      79   208.61 1058.08   100 1058.08 -5.1799e+02
      80   208.98 1058.44   100 1058.44 -5.1625e+02
      81   209.36 1058.47   100 1058.47 -5.1423e+02
      82   209.73 1059.06   100 1059.06 -5.1609e+02
      83   210.11 1059.64   100 1059.64 -5.1455e+02
      84   210.49 1059.11   100 1059.11 -5.0357e+02
      85   210.86 1059.06   100 1059.06 -5.0061e+02
      86   211.24 1060.11   100 1060.11 -5.0732e+02
      87   211.61 1060.40   100 1060.40 -5.0282e+02
      88   211.99 1061.40   100 1061.40 -5.0459e+02
      89   212.36 1061.77   100 1061.77 -5.1244e+02
      90   212.74 1061.88   100 1061.88 -5.0360e+02
      91   213.11 1062.39   100 1062.39 -5.0528e+02
      92   213.49 1062.28   100 1062.28 -4.9893e+02
      93   213.86 1063.28   100 1063.28 -5.0207e+02
      94   214.24 1063.71   100 1063.71 -4.9918e+02
      95   214.61 1064.11   100 1064.11 -4.9658e+02
      96   214.99 1064.27   100 1064.27 -4.9015e+02
      97   215.36 1064.13   100 1064.13 -4.8376e+02
      98   215.74 1064.47   100 1064.47 -4.8400e+02
      99   216.12 1064.45   100 1064.45 -4.7815e+02
      100  216.49 1064.46   100 1064.46 -4.6502e+02
      101  216.87 1064.71   100 1064.71 -4.6267e+02
      102  217.24 1064.74   100 1064.74 -4.5992e+02
      103  217.62 1065.56   100 1065.56 -4.6443e+02
      104  217.99 1065.30   100 1065.30 -4.5848e+02
      105  218.37 1065.66   100 1065.66 -4.5805e+02
      106  218.74 1066.28   100 1066.28 -4.6397e+02
      107  219.12 1066.64   100 1066.64 -4.6290e+02
      108  219.49 1067.29   100 1067.29 -4.6250e+02
      109  219.87 1067.56   100 1067.56 -4.5918e+02
      110  220.24 1067.78   100 1067.78 -4.6047e+02
      111  220.62 1068.22   100 1068.22 -4.5841e+02
      112  220.99 1068.83   100 1068.83 -4.5649e+02
      113  221.37 1068.67   100 1068.67 -4.4503e+02
      114  221.74 1068.83   100 1068.83 -4.3599e+02
      115  222.11 1069.34   100 1069.34 -4.3010e+02
      116  222.49 1069.54   100 1069.54 -4.2567e+02
      117  222.86 1069.30   100 1069.30 -4.0795e+02
      118  223.24 1069.37   100 1069.37 -3.9895e+02
      119  223.61 1069.01   100 1069.01 -3.8864e+02
      120  223.99 1068.63   100 1068.63 -3.7567e+02
      121  224.36 1069.00   100 1069.00 -3.6691e+02
      122  224.74 1069.20   100 1069.20 -3.5983e+02
      123  225.11 1069.03   100 1069.03 -3.4675e+02
      124  225.49 1069.09   100 1069.09 -3.4004e+02
      125  225.86 1069.41   100 1069.41 -3.2928e+02
      126  226.24 1069.40   100 1069.40 -3.1854e+02
      127  226.61 1070.27   100 1070.27 -3.0949e+02
      128  226.99 1070.82   100 1070.82 -3.0007e+02
      129  227.36 1071.27   100 1071.27 -2.8516e+02
      130  227.73 1071.75   100 1071.75 -2.6592e+02
      131  228.11 1072.27   100 1072.27 -2.4421e+02
      132  228.48 1072.38   100 1072.38 -2.1767e+02
      133  228.86 1072.66   100 1072.66 -1.8791e+02
      134  229.23 1072.76   100 1072.76 -1.5978e+02
      135  229.61 1072.60   100 1072.60 -1.3436e+02
      136  229.98 1072.46   100 1072.46 -1.1482e+02
      137  230.36 1072.87   100 1072.87 -1.0004e+02
      138  230.73 1072.39   100 1072.39 -8.8736e+01
      139  231.10 1072.44   100 1072.44 -8.0891e+01
      140  231.48 1072.67   100 1072.67 -7.5704e+01
      141  231.85 1073.10   100 1073.10 -7.2179e+01
      142  232.23 1073.66   100 1073.66 -6.9740e+01
      143  232.60 1074.56   100 1074.56 -6.8368e+01
      144  232.97 1074.30   100 1074.30 -6.8128e+01
      145  233.35 1074.75   100 1074.75 -6.9402e+01
      146  233.72 1075.55   100 1075.55 -7.1840e+01
      147  234.10 1075.67   100 1075.67 -7.4390e+01
      148  234.47 1075.60   100 1075.60 -7.6866e+01
      149  234.85 1075.77   100 1075.77 -7.8529e+01
      150  235.22 1076.12   100 1076.12 -7.9280e+01
      151  235.59 1075.64   100 1075.64 -7.8141e+01
      152  235.97 1074.81   100 1074.81 -7.6268e+01
      153  236.34 1074.61   100 1074.61 -7.4702e+01
      154  236.72 1073.57   100 1073.57 -7.2801e+01
      155  237.09 1073.84   100 1073.84 -7.0885e+01
      156  237.46 1074.24   100 1074.24 -6.8700e+01
      157  237.84 1074.43   100 1074.43 -6.6716e+01
      158  238.21 1075.03   100 1075.03 -6.4958e+01
      159  238.58 1075.54   100 1075.54 -6.3799e+01
      160  238.96 1075.60   100 1075.60 -6.2775e+01
      161  239.33 1075.72   100 1075.72 -6.1750e+01
      162  239.71 1076.57   100 1076.57 -6.0772e+01
      163  240.08 1077.06   100 1077.06 -5.9340e+01
      164  240.45 1077.16   100 1077.16 -5.7315e+01
      165  240.83 1077.57   100 1077.57 -5.4623e+01
      166  241.20 1078.14   100 1078.14 -5.1260e+01
      167  241.57 1077.63   100 1077.63 -4.7181e+01
      168  241.95 1077.94   100 1077.94 -4.2633e+01
      169  242.32 1077.04   100 1077.04 -3.7893e+01
      170  242.70 1076.76   100 1076.76 -3.3167e+01
      171  243.07 1076.79   100 1076.79 -2.9100e+01
      172  243.44 1076.37   100 1076.37 -2.5459e+01
      173  243.82 1076.51   100 1076.51 -2.2783e+01
      174  244.19 1076.79   100 1076.79 -2.0792e+01
      175  244.56 1076.92   100 1076.92 -1.9412e+01
      176  244.94 1077.04   100 1077.04 -1.8563e+01
      177  245.31 1077.13   100 1077.13 -1.8134e+01
      178  245.68 1078.05   100 1078.05 -1.7975e+01
      179  246.06 1078.14   100 1078.14 -1.7874e+01
      180  246.43 1078.39   100 1078.39 -1.7664e+01
      181  246.80 1078.38   100 1078.38 -1.7210e+01
      182  247.18 1078.20   100 1078.20 -1.6307e+01
      183  247.55 1078.14   100 1078.14 -1.5197e+01
      184  247.92 1078.23   100 1078.23 -1.3818e+01
      185  248.30 1078.96   100 1078.96 -1.2493e+01
      186  248.67 1079.04   100 1079.04 -1.1290e+01
      187  249.04 1079.34   100 1079.34 -1.0389e+01
      188  249.42 1079.19   100 1079.19 -9.7282e+00
      189  249.79 1077.78   100 1077.78 -9.2455e+00
      190  250.16 1077.40   100 1077.40 -8.9614e+00
      191  250.54 1077.74   100 1077.74 -8.8871e+00
      192  250.91 1077.70   100 1077.70 -9.0237e+00
      193  251.28 1077.78   100 1077.78 -9.4391e+00
      194  251.65 1078.47   100 1078.47 -1.0138e+01
      195  252.03 1078.39   100 1078.39 -1.1077e+01
      196  252.40 1078.11   100 1078.11 -1.2151e+01
      197  252.77 1078.75   100 1078.75 -1.3371e+01
      198  253.15 1079.09   100 1079.09 -1.4317e+01
      199  253.52 1078.95   100 1078.95 -1.4955e+01
      200  253.89 1080.27   100 1080.27 -1.5427e+01
      201  254.27 1080.58   100 1080.58 -1.5789e+01
      202  254.64 1080.83   100 1080.83 -1.6161e+01
      203  255.01 1081.23   100 1081.23 -1.6441e+01
      204  255.38 1081.78   100 1081.78 -1.6697e+01
      205  255.76 1081.91   100 1081.91 -1.6942e+01
      206  256.13 1081.68   100 1081.68 -1.7292e+01
      207  256.50 1081.42   100 1081.42 -1.7912e+01
      208  256.87 1081.54   100 1081.54 -1.8704e+01
      209  257.25 1081.32   100 1081.32 -1.9682e+01
      210  257.62 1081.86   100 1081.86 -2.0723e+01
      211  257.99 1081.96   100 1081.96 -2.1401e+01
      212  258.37 1082.55   100 1082.55 -2.1533e+01
      213  258.74 1083.16   100 1083.16 -2.0925e+01
      214  259.11 1083.68   100 1083.68 -1.9814e+01
      215  259.48 1083.76   100 1083.76 -1.8097e+01
      216  259.86 1083.84   100 1083.84 -1.6029e+01
      217  260.23 1084.28   100 1084.28 -1.3815e+01
      218  260.60 1084.66   100 1084.66 -1.1784e+01
      219  260.97 1084.35   100 1084.35 -1.0078e+01
      220  261.35 1084.40   100 1084.40 -8.8226e+00
      221  261.72 1084.86   100 1084.86 -7.9607e+00
      222  262.09 1084.70   100 1084.70 -7.4145e+00
      223  262.46 1084.58   100 1084.58 -7.1349e+00
      224  262.84 1084.34   100 1084.34 -6.9993e+00
      225  263.21 1083.91   100 1083.91 -6.9555e+00
      226  263.58 1083.97   100 1083.97 -7.0346e+00
      227  263.95 1084.40   100 1084.40 -7.2464e+00
      228  264.32 1084.14   100 1084.14 -7.6954e+00
      229  264.70 1084.47   100 1084.47 -8.4186e+00
      230  265.07 1084.80   100 1084.80 -9.4297e+00
      231  265.44 1084.93   100 1084.93 -1.0719e+01
      232  265.81 1083.97   100 1083.97 -1.2019e+01
      233  266.19 1084.04   100 1084.04 -1.3152e+01
      234  266.56 1084.17   100 1084.17 -1.3776e+01
      235  266.93 1084.87   100 1084.87 -1.4021e+01
      236  267.30 1085.25   100 1085.25 -1.3972e+01
      237  267.67 1085.72   100 1085.72 -1.3769e+01
      238  268.05 1085.80   100 1085.80 -1.3484e+01
      239  268.42 1085.99   100 1085.99 -1.3120e+01
      240  268.79 1085.67   100 1085.67 -1.2682e+01
      241  269.16 1085.39   100 1085.39 -1.2299e+01
      242  269.53 1085.25   100 1085.25 -1.1919e+01
      243  269.90 1086.01   100 1086.01 -1.1661e+01
      244  270.28 1085.88   100 1085.88 -1.1432e+01
      245  270.65 1085.75   100 1085.75 -1.1280e+01
      246  271.02 1085.19   100 1085.19 -1.1174e+01
      247  271.39 1084.58   100 1084.58 -1.1043e+01
      248  271.76 1084.72   100 1084.72 -1.0932e+01
      249  272.14 1084.83   100 1084.83 -1.0805e+01
      250  272.51 1085.32   100 1085.32 -1.0619e+01
      251  272.88 1085.60   100 1085.60 -1.0363e+01
      252  273.25 1085.32   100 1085.32 -1.0029e+01
      253  273.62 1085.59   100 1085.59 -9.7321e+00
      254  273.99 1085.44   100 1085.44 -9.4261e+00
      255  274.37 1085.58   100 1085.58 -9.1991e+00
      256  274.74 1085.04   100 1085.04 -9.0160e+00
      257  275.11 1084.98   100 1084.98 -8.9031e+00
      258  275.48 1085.78   100 1085.78 -8.9236e+00
      259  275.85 1085.84   100 1085.84 -9.0333e+00
      260  276.22 1085.55   100 1085.55 -9.1539e+00
      261  276.59 1086.10   100 1086.10 -9.3588e+00
      262  276.97 1086.64   100 1086.64 -9.6314e+00
      263  277.34 1087.43   100 1087.43 -9.9505e+00
      264  277.71 1087.82   100 1087.82 -1.0258e+01
      265  278.08 1087.39   100 1087.39 -1.0547e+01
      266  278.45 1088.05   100 1088.05 -1.0851e+01
      267  278.82 1088.41   100 1088.41 -1.1070e+01
      268  279.19 1088.96   100 1088.96 -1.1302e+01
      269  279.57 1089.21   100 1089.21 -1.1458e+01
      270  279.94 1089.07   100 1089.07 -1.1503e+01
      271  280.31 1089.48   100 1089.48 -1.1590e+01
      272  280.68 1088.66   100 1088.66 -1.1601e+01
      273  281.05 1088.63   100 1088.63 -1.1633e+01
      274  281.42 1087.82   100 1087.82 -1.1578e+01
      275  281.79 1087.73   100 1087.73 -1.1492e+01
      276  282.16 1089.15   100 1089.15 -1.1416e+01
      277  282.53 1089.03   100 1089.03 -1.1191e+01
      278  282.91 1089.22   100 1089.22 -1.0963e+01
      279  283.28 1089.14   100 1089.14 -1.0655e+01
      280  283.65 1088.58   100 1088.58 -1.0337e+01
      281  284.02 1088.93   100 1088.93 -1.0141e+01
      282  284.39 1089.27   100 1089.27 -9.9270e+00
      283  284.76 1090.06   100 1090.06 -9.7526e+00
      284  285.13 1090.24   100 1090.24 -9.5583e+00
      285  285.50 1091.14   100 1091.14 -9.3827e+00
      286  285.87 1090.99   100 1090.99 -9.1194e+00
      287  286.24 1090.14   100 1090.14 -8.8207e+00
      288  286.61 1090.15   100 1090.15 -8.5566e+00
      289  286.99 1090.22   100 1090.22 -8.3136e+00
      290  287.36 1090.38   100 1090.38 -8.1056e+00
      291  287.73 1091.15   100 1091.15 -7.9799e+00
      292  288.10 1090.70   100 1090.70 -7.8635e+00
      293  288.47 1090.47   100 1090.47 -7.8088e+00
      294  288.84 1090.11   100 1090.11 -7.8029e+00
      295  289.21 1089.52   100 1089.52 -7.7821e+00
      296  289.58 1089.48   100 1089.48 -7.8179e+00
      297  289.95 1089.36   100 1089.36 -7.9088e+00
      298  290.32 1088.69   100 1088.69 -7.9914e+00
      299  290.69 1089.11   100 1089.11 -8.1133e+00
      300  291.06 1089.58   100 1089.58 -8.2228e+00
      301  291.43 1089.03   100 1089.03 -8.3000e+00
      302  291.80 1088.19   100 1088.19 -8.3099e+00
      303  292.17 1089.00   100 1089.00 -8.3424e+00
      304  292.54 1088.21   100 1088.21 -8.3300e+00
      305  292.91 1088.13   100 1088.13 -8.3391e+00
      306  293.28 1088.32   100 1088.32 -8.4015e+00
      307  293.65 1088.76   100 1088.76 -8.4739e+00
      308  294.02 1088.73   100 1088.73 -8.5679e+00
      309  294.40 1089.95   100 1089.95 -8.7125e+00
      310  294.77 1089.94   100 1089.94 -8.8424e+00
      311  295.14 1089.65   100 1089.65 -8.9844e+00
      312  295.51 1089.59   100 1089.59 -9.0928e+00
      313  295.88 1089.94   100 1089.94 -9.2144e+00
      314  296.25 1089.64   100 1089.64 -9.2136e+00
      315  296.62 1090.29   100 1090.29 -9.1521e+00
      316  296.99 1091.16   100 1091.16 -8.9787e+00
      317  297.36 1091.34   100 1091.34 -8.6768e+00
      318  297.73 1090.64   100 1090.64 -8.2780e+00
      319  298.10 1090.72   100 1090.72 -7.8702e+00
      320  298.47 1090.06   100 1090.06 -7.5117e+00
      321  298.84 1089.54   100 1089.54 -7.2223e+00
      322  299.21 1090.03   100 1090.03 -7.0210e+00
      323  299.58 1090.40   100 1090.40 -6.9337e+00
      324  299.95 1090.55   100 1090.55 -6.9035e+00
      325  300.32 1090.59   100 1090.59 -6.9154e+00
      326  300.69 1090.62   100 1090.62 -6.9674e+00
      327  301.06 1089.26   100 1089.26 -7.0467e+00
      328  301.42 1088.90   100 1088.90 -7.1973e+00
      329  301.79 1089.84   100 1089.84 -7.4653e+00
      330  302.16 1090.98   100 1090.98 -7.8102e+00
      331  302.53 1091.80   100 1091.80 -8.1631e+00
      332  302.90 1091.69   100 1091.69 -8.4950e+00
      333  303.27 1091.60   100 1091.60 -8.8135e+00
      334  303.64 1091.54   100 1091.54 -9.0384e+00
      335  304.01 1091.82   100 1091.82 -9.1880e+00
      336  304.38 1091.40   100 1091.40 -9.2525e+00
      337  304.75 1091.91   100 1091.91 -9.3230e+00
      338  305.12 1093.09   100 1093.09 -9.3898e+00
      339  305.49 1092.87   100 1092.87 -9.4010e+00
      340  305.86 1092.35   100 1092.35 -9.4263e+00
      341  306.23 1091.82   100 1091.82 -9.4244e+00
      342  306.60 1091.13   100 1091.13 -9.4748e+00
      343  306.97 1091.50   100 1091.50 -9.5714e+00
      344  307.34 1091.10   100 1091.10 -9.6274e+00
      345  307.71 1091.50   100 1091.50 -9.7077e+00
      346  308.08 1091.89   100 1091.89 -9.7881e+00
      347  308.45 1091.81   100 1091.81 -9.8776e+00
      348  308.81 1091.62   100 1091.62 -9.9151e+00
      349  309.18 1091.33   100 1091.33 -9.8995e+00
      350  309.55 1091.81   100 1091.81 -9.8988e+00
      351  309.92 1092.04   100 1092.04 -9.7875e+00
      352  310.29 1092.05   100 1092.05 -9.6214e+00
      353  310.66 1092.46   100 1092.46 -9.3916e+00
      354  311.03 1092.84   100 1092.84 -9.1686e+00
      355  311.40 1093.13   100 1093.13 -8.9072e+00
      356  311.77 1093.45   100 1093.45 -8.6376e+00
      357  312.14 1093.12   100 1093.12 -8.3608e+00
      358  312.51 1093.36   100 1093.36 -8.1216e+00
      359  312.87 1093.72   100 1093.72 -7.9405e+00
      360  313.24 1094.03   100 1094.03 -7.8610e+00
      361  313.61 1094.48   100 1094.48 -7.8663e+00
      362  313.98 1094.43   100 1094.43 -7.9430e+00
      363  314.35 1094.11   100 1094.11 -8.0977e+00
      364  314.72 1094.66   100 1094.66 -8.3250e+00
      365  315.09 1094.62   100 1094.62 -8.5428e+00
      366  315.46 1094.67   100 1094.67 -8.7945e+00
      367  315.83 1094.77   100 1094.77 -9.0862e+00
      368  316.19 1095.24   100 1095.24 -9.4293e+00
      369  316.56 1095.54   100 1095.54 -9.7736e+00
      370  316.93 1095.22   100 1095.22 -1.0119e+01
      371  317.30 1094.43   100 1094.43 -1.0358e+01
      372  317.67 1094.18   100 1094.18 -1.0529e+01
      373  318.04 1094.42   100 1094.42 -1.0633e+01
      374  318.41 1095.31   100 1095.31 -1.0719e+01
      375  318.77 1095.21   100 1095.21 -1.0716e+01
      376  319.14 1095.01   100 1095.01 -1.0668e+01
      377  319.51 1094.85   100 1094.85 -1.0659e+01
      378  319.88 1094.83   100 1094.83 -1.0672e+01
      379  320.25 1094.64   100 1094.64 -1.0687e+01
      380  320.62 1094.95   100 1094.95 -1.0725e+01
      381  320.99 1095.68   100 1095.68 -1.0786e+01
      382  321.35 1095.85   100 1095.85 -1.0858e+01
      383  321.72 1095.75   100 1095.75 -1.0939e+01
      384  322.09 1095.99   100 1095.99 -1.1034e+01
      385  322.46 1095.69   100 1095.69 -1.1115e+01
      386  322.83 1095.74   100 1095.74 -1.1204e+01
      387  323.19 1095.92   100 1095.92 -1.1338e+01
      388  323.56 1095.97   100 1095.97 -1.1397e+01
      389  323.93 1096.03   100 1096.03 -1.1397e+01
      390  324.30 1096.43   100 1096.43 -1.1332e+01
      391  324.67 1096.51   100 1096.51 -1.1174e+01
      392  325.04 1096.42   100 1096.42 -1.0944e+01
      393  325.40 1097.38   100 1097.38 -1.0717e+01
      394  325.77 1098.13   100 1098.13 -1.0504e+01
      395  326.14 1098.45   100 1098.45 -1.0280e+01
      396  326.51 1099.17   100 1099.17 -1.0077e+01
      397  326.88 1099.46   100 1099.46 -9.9011e+00
      398  327.24 1100.21   100 1100.21 -9.6807e+00
      399  327.61 1101.28   100 1101.28 -9.5304e+00
      400  327.98 1101.28   100 1101.28 -9.4066e+00
      401  328.35 1100.91   100 1100.91 -9.3047e+00
      402  328.71 1100.38   100 1100.38 -9.2882e+00
      403  329.08 1100.67   100 1100.67 -9.3502e+00
      404  329.45 1100.52   100 1100.52 -9.4299e+00
      405  329.82 1101.01   100 1101.01 -9.5184e+00
      406  330.19 1100.78   100 1100.78 -9.6053e+00
      407  330.55 1100.69   100 1100.69 -9.6908e+00
      408  330.92 1101.77   100 1101.77 -9.8111e+00
      409  331.29 1101.85   100 1101.85 -9.9490e+00
      410  331.66 1101.46   100 1101.46 -1.0050e+01
      411  332.02 1102.08   100 1102.08 -1.0170e+01
      412  332.39 1102.77   100 1102.77 -1.0268e+01
      413  332.76 1103.40   100 1103.40 -1.0312e+01
      414  333.13 1103.01   100 1103.01 -1.0274e+01
      415  333.49 1103.51   100 1103.51 -1.0220e+01
      416  333.86 1103.63   100 1103.63 -1.0124e+01
      417  334.23 1103.53   100 1103.53 -9.9925e+00
      418  334.60 1103.98   100 1103.98 -9.8649e+00
      419  334.96 1103.16   100 1103.16 -9.7193e+00
      420  335.33 1103.31   100 1103.31 -9.6009e+00
      421  335.70 1103.79   100 1103.79 -9.5008e+00
      422  336.07 1104.54   100 1104.54 -9.3979e+00
      423  336.43 1104.83   100 1104.83 -9.2894e+00
      424  336.80 1105.48   100 1105.48 -9.2145e+00
      425  337.17 1105.67   100 1105.67 -9.1304e+00
      426  337.53 1105.39   100 1105.39 -9.0396e+00
      427  337.90 1105.74   100 1105.74 -9.0002e+00
      428  338.27 1106.24   100 1106.24 -8.9529e+00
      429  338.64 1106.25   100 1106.25 -8.8971e+00
      430  339.00 1106.48   100 1106.48 -8.8369e+00
      431  339.37 1107.11   100 1107.11 -8.7882e+00
      432  339.74 1107.65   100 1107.65 -8.7567e+00
      433  340.10 1107.61   100 1107.61 -8.7396e+00
      434  340.47 1107.34   100 1107.34 -8.7355e+00
      435  340.84 1107.74   100 1107.74 -8.7140e+00
      436  341.20 1108.12   100 1108.12 -8.7220e+00
      437  341.57 1108.64   100 1108.64 -8.7076e+00
      438  341.94 1108.83   100 1108.83 -8.6563e+00
      439  342.30 1109.01   100 1109.01 -8.6165e+00
      440  342.67 1109.46   100 1109.46 -8.5826e+00
      441  343.04 1110.03   100 1110.03 -8.5356e+00
      442  343.40 1110.15   100 1110.15 -8.5000e+00
      443  343.77 1110.09   100 1110.09 -8.4479e+00
      444  344.14 1110.34   100 1110.34 -8.3620e+00
      445  344.50 1111.15   100 1111.15 -8.2713e+00
      446  344.87 1111.60   100 1111.60 -8.1918e+00
      447  345.24 1112.21   100 1112.21 -8.0818e+00
      448  345.60 1112.40   100 1112.40 -7.9756e+00
      449  345.97 1111.77   100 1111.77 -7.8633e+00
      450  346.34 1112.37   100 1112.37 -7.7656e+00
      451  346.70 1112.02   100 1112.02 -7.6522e+00
      452  347.07 1112.16   100 1112.16 -7.5692e+00
      453  347.44 1112.33   100 1112.33 -7.4989e+00
      454  347.80 1112.88   100 1112.88 -7.4358e+00
      455  348.17 1112.94   100 1112.94 -7.4141e+00
      456  348.54 1112.40   100 1112.40 -7.3913e+00
      457  348.90 1112.35   100 1112.35 -7.4111e+00
      458  349.27 1112.08   100 1112.08 -7.4373e+00
      459  349.63 1112.84   100 1112.84 -7.5063e+00
      460  350.00 1113.43   100 1113.43 -7.5521e+00
      461  350.37 1113.67   100 1113.67 -7.5991e+00
      462  350.73 1113.93   100 1113.93 -7.6127e+00
      463  351.10 1113.96   100 1113.96 -7.6379e+00
      464  351.46 1113.61   100 1113.61 -7.6283e+00
      465  351.83 1114.16   100 1114.16 -7.6497e+00
      466  352.20 1114.43   100 1114.43 -7.6133e+00
      467  352.56 1115.40   100 1115.40 -7.6102e+00
      468  352.93 1115.84   100 1115.84 -7.5540e+00
      469  353.29 1116.60   100 1116.60 -7.5265e+00
      470  353.66 1116.51   100 1116.51 -7.4627e+00
      471  354.03 1116.89   100 1116.89 -7.4272e+00
      472  354.39 1117.38   100 1117.38 -7.4055e+00
      473  354.76 1118.35   100 1118.35 -7.3981e+00
      474  355.12 1119.63   100 1119.63 -7.3696e+00
      475  355.49 1120.46   100 1120.46 -7.3053e+00
      476  355.86 1120.15   100 1120.15 -7.2013e+00
      477  356.22 1120.82   100 1120.82 -7.1116e+00
      478  356.59 1121.19   100 1121.19 -6.9935e+00
      479  356.95 1121.50   100 1121.50 -6.8746e+00
      480  357.32 1122.12   100 1122.12 -6.7507e+00
      481  357.68 1122.93   100 1122.93 -6.6204e+00
      482  358.05 1124.06   100 1124.06 -6.4669e+00
      483  358.41 1124.25   100 1124.25 -6.2885e+00
      484  358.78 1124.98   100 1124.98 -6.1350e+00
      485  359.15 1124.88   100 1124.88 -5.9913e+00
      486  359.51 1125.95   100 1125.95 -5.9011e+00
      487  359.88 1126.71   100 1126.71 -5.8315e+00
      488  360.24 1127.06   100 1127.06 -5.7599e+00
      489  360.61 1128.63   100 1128.63 -5.6981e+00
      490  360.97 1129.11   100 1129.11 -5.5971e+00
      491  361.34 1129.90   100 1129.90 -5.4827e+00
      492  361.70 1130.90   100 1130.90 -5.3618e+00
      493  362.07 1132.56   100 1132.56 -5.2360e+00
      494  362.43 1134.39   100 1134.39 -5.0879e+00
      495  362.80 1135.42   100 1135.42 -4.9257e+00
      496  363.16 1137.29   100 1137.29 -4.7986e+00
      497  363.53 1138.59   100 1138.59 -4.6950e+00
      498  363.89 1139.52   100 1139.52 -4.6005e+00
      499  364.26 1140.11   100 1140.11 -4.5276e+00
      500  364.62 1139.67   100 1139.67 -4.4683e+00
      501  364.99 1140.39   100 1140.39 -4.4531e+00
      502  365.35 1140.61   100 1140.61 -4.4523e+00
      503  365.72 1140.72   100 1140.72 -4.4850e+00
      504  366.08 1139.91   100 1139.91 -4.5391e+00
      505  366.45 1139.02   100 1139.02 -4.6424e+00
      506  366.81 1138.56   100 1138.56 -4.7724e+00
      507  367.18 1136.82   100 1136.82 -4.8443e+00
      508  367.54 1135.50   100 1135.50 -4.9016e+00
      509  367.91 1135.73   100 1135.73 -4.9456e+00
      510  368.27 1135.58   100 1135.58 -4.9673e+00
      511  368.64 1135.72   100 1135.72 -4.9848e+00
      512  369.00 1135.12   100 1135.12 -4.9819e+00
      513  369.37 1134.60   100 1134.60 -4.9736e+00
      514  369.73 1134.08   100 1134.08 -4.9648e+00
      515  370.10 1133.30   100 1133.30 -4.9338e+00
      516  370.46 1132.95   100 1132.95 -4.8933e+00
      517  370.83 1132.07   100 1132.07 -4.8414e+00
      518  371.19 1132.04   100 1132.04 -4.8084e+00
      519  371.55 1132.26   100 1132.26 -4.7410e+00
      520  371.92 1131.71   100 1131.71 -4.6345e+00
      521  372.28 1131.27   100 1131.27 -4.5217e+00
      522  372.65 1131.69   100 1131.69 -4.3955e+00
      523  373.01 1131.61   100 1131.61 -4.2611e+00
      524  373.38 1131.90   100 1131.90 -4.1493e+00
      525  373.74 1131.91   100 1131.91 -4.0218e+00
      526  374.11 1132.20   100 1132.20 -3.9157e+00
      527  374.47 1131.39   100 1131.39 -3.7842e+00
      528  374.83 1131.54   100 1131.54 -3.6713e+00
      529  375.20 1131.78   100 1131.78 -3.5680e+00
      530  375.56 1131.04   100 1131.04 -3.4494e+00
      531  375.93 1130.76   100 1130.76 -3.3626e+00
      532  376.29 1130.72   100 1130.72 -3.2574e+00
      533  376.65 1129.79   100 1129.79 -3.1348e+00
      534  377.02 1130.02   100 1130.02 -3.0177e+00
      535  377.38 1129.52   100 1129.52 -2.8504e+00
      536  377.75 1130.16   100 1130.16 -2.6696e+00
      537  378.11 1130.37   100 1130.37 -2.4623e+00
      538  378.47 1130.70   100 1130.70 -2.2455e+00
      539  378.84 1131.19   100 1131.19 -2.0383e+00
      540  379.20 1130.79   100 1130.79 -1.8499e+00
      541  379.57 1130.91   100 1130.91 -1.6893e+00
      542  379.93 1130.69   100 1130.69 -1.5165e+00
      543  380.29 1130.44   100 1130.44 -1.3734e+00
      544  380.66 1129.57   100 1129.57 -1.2275e+00
      545  381.02 1129.00   100 1129.00 -1.0809e+00
      546  381.38 1128.10   100 1128.10 -9.3387e-01
      547  381.75 1126.91   100 1126.91 -7.8837e-01
      548  382.11 1125.74   100 1125.74 -6.5948e-01
      549  382.48 1125.71   100 1125.71 -5.6531e-01
      550  382.84 1124.90   100 1124.90 -4.6973e-01
      551  383.20 1124.50   100 1124.50 -3.5546e-01
      552  383.57 1124.16   100 1124.16 -2.2807e-01
      553  383.93 1123.98   100 1123.98 -1.1288e-01
      554  384.29 1124.11   100 1124.11  2.8929e-02
      555  384.66 1123.68   100 1123.68  1.7887e-01
      556  385.02 1123.67   100 1123.67  3.2595e-01
      557  385.38 1123.83   100 1123.83  4.7561e-01
      558  385.75 1124.29   100 1124.29  6.2589e-01
      559  386.11 1123.97   100 1123.97  7.7879e-01
      560  386.47 1123.87   100 1123.87  9.3323e-01
      561  386.84 1123.39   100 1123.39  1.0934e+00
      562  387.20 1123.11   100 1123.11  1.2440e+00
      563  387.56 1122.60   100 1122.60  1.3908e+00
      564  387.93 1121.85   100 1121.85  1.5486e+00
      565  388.29 1120.50   100 1120.50  1.7040e+00
      566  388.65 1120.89   100 1120.89  1.8270e+00
      567  389.02 1120.16   100 1120.16  1.9538e+00
      568  389.38 1119.73   100 1119.73  2.0491e+00
      569  389.74 1118.59   100 1118.59  2.1451e+00
      570  390.10 1118.56   100 1118.56  2.2429e+00
      571  390.47 1117.83   100 1117.83  2.3352e+00
      572  390.83 1117.28   100 1117.28  2.4475e+00
      573  391.19 1116.91   100 1116.91  2.5568e+00
      574  391.56 1117.42   100 1117.42  2.6844e+00
      575  391.92 1116.51   100 1116.51  2.8296e+00
      576  392.28 1117.22   100 1117.22  2.9812e+00
      577  392.64 1117.52   100 1117.52  3.1364e+00
      578  393.01 1117.31   100 1117.31  3.2889e+00
      579  393.37 1117.02   100 1117.02  3.4406e+00
      580  393.73 1116.68   100 1116.68  3.5729e+00
      581  394.09 1116.29   100 1116.29  3.7047e+00
      582  394.46 1116.43   100 1116.43  3.8466e+00
      583  394.82 1116.68   100 1116.68  3.9765e+00
      584  395.18 1117.37   100 1117.37  4.1116e+00
      585  395.55 1116.46   100 1116.46  4.2226e+00
      586  395.91 1117.60   100 1117.60  4.3100e+00
      587  396.27 1116.97   100 1116.97  4.3916e+00
      588  396.63 1115.42   100 1115.42  4.4722e+00
      589  396.99 1115.03   100 1115.03  4.5459e+00
      590  397.36 1115.66   100 1115.66  4.6156e+00
      591  397.72 1115.46   100 1115.46  4.6963e+00
      592  398.08 1114.98   100 1114.98  4.7703e+00
      593  398.44 1114.17   100 1114.17  4.8415e+00
      594  398.81 1113.53   100 1113.53  4.9073e+00
      595  399.17 1112.60   100 1112.60  4.9707e+00
      596  399.53 1112.42   100 1112.42  5.0409e+00
      597  399.89 1111.23   100 1111.23  5.1326e+00
      598  400.25 1111.17   100 1111.17  5.2157e+00
      599  400.62 1111.61   100 1111.61  5.3005e+00
      600  400.98 1111.49   100 1111.49  5.3855e+00
      601  401.34 1110.67   100 1110.67  5.4784e+00
      602  401.70 1110.34   100 1110.34  5.5718e+00
      603  402.06 1110.31   100 1110.31  5.6674e+00
      604  402.43 1109.56   100 1109.56  5.7655e+00
      605  402.79 1109.59   100 1109.59  5.8545e+00
      606  403.15 1109.31   100 1109.31  5.9443e+00
      607  403.51 1109.15   100 1109.15  6.0434e+00
      608  403.87 1109.00   100 1109.00  6.1511e+00
      609  404.24 1108.68   100 1108.68  6.2672e+00
      610  404.60 1108.57   100 1108.57  6.3895e+00
      611  404.96 1108.51   100 1108.51  6.5241e+00
      612  405.32 1108.50   100 1108.50  6.6697e+00
      613  405.68 1109.05   100 1109.05  6.7933e+00
      614  406.04 1108.90   100 1108.90  6.9254e+00
      615  406.41 1109.88   100 1109.88  7.0364e+00
      616  406.77 1109.68   100 1109.68  7.1735e+00
      617  407.13 1108.83   100 1108.83  7.3012e+00
      618  407.49 1108.95   100 1108.95  7.4132e+00
      619  407.85 1109.44   100 1109.44  7.5060e+00
      620  408.21 1109.25   100 1109.25  7.5939e+00
      621  408.57 1109.00   100 1109.00  7.6692e+00
      622  408.94 1108.96   100 1108.96  7.7309e+00
      623  409.30 1108.66   100 1108.66  7.7927e+00
      624  409.66 1107.46   100 1107.46  7.8758e+00
      625  410.02 1107.44   100 1107.44  7.9422e+00
      626  410.38 1106.76   100 1106.76  8.0362e+00
      627  410.74 1106.57   100 1106.57  8.1244e+00
      628  411.10 1106.95   100 1106.95  8.2139e+00
      629  411.46 1106.17   100 1106.17  8.3175e+00
      630  411.83 1105.39   100 1105.39  8.4245e+00
      631  412.19 1105.07   100 1105.07  8.5249e+00
      632  412.55 1104.51   100 1104.51  8.6314e+00
      633  412.91 1104.16   100 1104.16  8.7439e+00
      634  413.27 1103.64   100 1103.64  8.8326e+00
      635  413.63 1103.92   100 1103.92  8.9242e+00
      636  413.99 1103.55   100 1103.55  9.0300e+00
      637  414.35 1103.26   100 1103.26  9.1183e+00
      638  414.71 1102.69   100 1102.69  9.2015e+00
      639  415.07 1102.41   100 1102.41  9.3016e+00
      640  415.43 1102.47   100 1102.47  9.4037e+00
      641  415.80 1102.10   100 1102.10  9.5129e+00
      642  416.16 1101.75   100 1101.75  9.6339e+00
      643  416.52 1101.49   100 1101.49  9.7688e+00
      644  416.88 1100.77   100 1100.77  9.9063e+00
      645  417.24 1101.32   100 1101.32  1.0063e+01
      646  417.60 1101.55   100 1101.55  1.0211e+01
      647  417.96 1101.54   100 1101.54  1.0369e+01
      648  418.32 1101.93   100 1101.93  1.0528e+01
      649  418.68 1101.93   100 1101.93  1.0713e+01
      650  419.04 1102.21   100 1102.21  1.0886e+01
      651  419.40 1102.67   100 1102.67  1.1050e+01
      652  419.76 1103.16   100 1103.16  1.1209e+01
      653  420.12 1103.63   100 1103.63  1.1367e+01
      654  420.48 1104.70   100 1104.70  1.1520e+01
      655  420.84 1105.52   100 1105.52  1.1663e+01
      656  421.20 1105.08   100 1105.08  1.1816e+01
      657  421.56 1105.35   100 1105.35  1.1954e+01
      658  421.92 1105.99   100 1105.99  1.2084e+01
      659  422.28 1106.59   100 1106.59  1.2204e+01
      660  422.64 1107.40   100 1107.40  1.2310e+01
      661  423.00 1107.29   100 1107.29  1.2412e+01
      662  423.36 1106.86   100 1106.86  1.2518e+01
      663  423.72 1106.83   100 1106.83  1.2617e+01
      664  424.08 1106.93   100 1106.93  1.2715e+01
      665  424.44 1107.02   100 1107.02  1.2804e+01
      666  424.80 1107.80   100 1107.80  1.2897e+01
      667  425.16 1108.59   100 1108.59  1.2978e+01
      668  425.52 1108.26   100 1108.26  1.3071e+01
      669  425.88 1107.98   100 1107.98  1.3168e+01
      670  426.24 1107.78   100 1107.78  1.3267e+01
      671  426.60 1107.75   100 1107.75  1.3355e+01
      672  426.96 1107.84   100 1107.84  1.3441e+01
      673  427.32 1108.27   100 1108.27  1.3512e+01
      674  427.68 1107.73   100 1107.73  1.3578e+01
      675  428.04 1106.97   100 1106.97  1.3641e+01
      676  428.40 1106.40   100 1106.40  1.3702e+01
      677  428.76 1105.53   100 1105.53  1.3771e+01
      678  429.12 1104.90   100 1104.90  1.3842e+01
      679  429.48 1104.59   100 1104.59  1.3902e+01
      680  429.84 1103.95   100 1103.95  1.3966e+01
      681  430.20 1103.03   100 1103.03  1.4033e+01
      682  430.56 1102.48   100 1102.48  1.4102e+01
      683  430.92 1102.62   100 1102.62  1.4163e+01
      684  431.28 1101.99   100 1101.99  1.4243e+01
      685  431.64 1102.69   100 1102.69  1.4329e+01
      686  432.00 1103.03   100 1103.03  1.4418e+01
      687  432.35 1102.03   100 1102.03  1.4529e+01
      688  432.71 1101.43   100 1101.43  1.4638e+01
      689  433.07 1100.90   100 1100.90  1.4756e+01
      690  433.43 1100.48   100 1100.48  1.4891e+01
      691  433.79 1100.99   100 1100.99  1.5011e+01
      692  434.15 1101.21   100 1101.21  1.5151e+01
      693  434.51 1100.89   100 1100.89  1.5297e+01
      694  434.87 1100.29   100 1100.29  1.5440e+01
      695  435.23 1099.80   100 1099.80  1.5570e+01
      696  435.59 1099.15   100 1099.15  1.5701e+01
      697  435.95 1098.66   100 1098.66  1.5822e+01
      698  436.30 1099.08   100 1099.08  1.5940e+01
      699  436.66 1099.03   100 1099.03  1.6040e+01
      700  437.02 1099.19   100 1099.19  1.6138e+01
      701  437.38 1099.25   100 1099.25  1.6242e+01
      702  437.74 1098.84   100 1098.84  1.6354e+01
      703  438.10 1099.25   100 1099.25  1.6457e+01
      704  438.46 1099.23   100 1099.23  1.6556e+01
      705  438.82 1099.60   100 1099.60  1.6656e+01
      706  439.17 1100.02   100 1100.02  1.6763e+01
      707  439.53 1100.37   100 1100.37  1.6869e+01
      708  439.89 1101.36   100 1101.36  1.6973e+01
      709  440.25 1101.32   100 1101.32  1.7071e+01
      710  440.61 1101.62   100 1101.62  1.7190e+01
      711  440.97 1101.91   100 1101.91  1.7309e+01
      712  441.33 1102.05   100 1102.05  1.7420e+01
      713  441.68 1102.07   100 1102.07  1.7514e+01
      714  442.04 1101.11   100 1101.11  1.7611e+01
      715  442.40 1100.93   100 1100.93  1.7702e+01
      716  442.76 1100.77   100 1100.77  1.7784e+01
      717  443.12 1100.42   100 1100.42  1.7868e+01
      718  443.48 1099.72   100 1099.72  1.7944e+01
      719  443.83 1099.17   100 1099.17  1.8020e+01
      720  444.19 1112.70   100 1112.70  1.8074e+01
      721  444.55 1113.42   100 1113.42  1.8140e+01
      722  444.91 1113.77   100 1113.77  1.8201e+01
      723  445.27 1113.77   100 1113.77  1.8273e+01
      724  445.62 1113.68   100 1113.68  1.8367e+01
      725  445.98 1114.17   100 1114.17  1.8448e+01
      726  446.34 1114.98   100 1114.98  1.8535e+01
      727  446.70 1114.92   100 1114.92  1.8624e+01
      728  447.06 1114.64   100 1114.64  1.8692e+01
      729  447.41 1115.56   100 1115.56  1.8757e+01
      730  447.77 1115.58   100 1115.58  1.8829e+01
      731  448.13 1102.19   100 1102.19  1.8914e+01
      732  448.49 1101.56   100 1101.56  1.8982e+01
      733  448.84 1101.00   100 1101.00  1.9061e+01
      734  449.20 1100.94   100 1100.94  1.9112e+01
      735  449.56 1100.75   100 1100.75  1.9173e+01
      736  449.92 1100.75   100 1100.75  1.9226e+01
      737  450.28 1100.93   100 1100.93  1.9276e+01
      738  450.63 1101.21   100 1101.21  1.9335e+01
      739  450.99 1101.57   100 1101.57  1.9407e+01
      740  451.35 1100.56   100 1100.56  1.9487e+01
      741  451.71 1100.58   100 1100.58  1.9554e+01
      742  452.06 1101.00   100 1101.00  1.9630e+01
      743  452.42 1100.72   100 1100.72  1.9703e+01
      744  452.78 1100.97   100 1100.97  1.9756e+01
      745  453.14 1100.80   100 1100.80  1.9827e+01
      746  453.49 1101.06   100 1101.06  1.9882e+01
      747  453.85 1100.92   100 1100.92  1.9956e+01
      748  454.21 1100.09   100 1100.09  2.0022e+01
      749  454.56 1099.73   100 1099.73  2.0081e+01
      750  454.92 1100.13   100 1100.13  2.0131e+01
      751  455.28 1101.11   100 1101.11  2.0174e+01
      752  455.64 1100.94   100 1100.94  2.0227e+01
      753  455.99 1100.49   100 1100.49  2.0284e+01
      754  456.35 1101.10   100 1101.10  2.0332e+01
      755  456.71 1100.70   100 1100.70  2.0391e+01
      756  457.06 1100.89   100 1100.89  2.0448e+01
      757  457.42 1101.25   100 1101.25  2.0508e+01
      758  457.78 1101.65   100 1101.65  2.0571e+01
      759  458.13 1101.91   100 1101.91  2.0639e+01
      760  458.49 1101.99   100 1101.99  2.0699e+01
      761  458.85 1101.86   100 1101.86  2.0763e+01
      762  459.20 1101.08   100 1101.08  2.0834e+01
      763  459.56 1101.48   100 1101.48  2.0899e+01
      764  459.92 1101.12   100 1101.12  2.0946e+01
      765  460.27 1100.41   100 1100.41  2.0994e+01
      766  460.63 1100.40   100 1100.40  2.1044e+01
      767  460.99 1100.34   100 1100.34  2.1093e+01
      768  461.34 1100.93   100 1100.93  2.1134e+01
      769  461.70 1101.33   100 1101.33  2.1182e+01
      770  462.06 1101.12   100 1101.12  2.1234e+01
      771  462.41 1101.21   100 1101.21  2.1289e+01
      772  462.77 1100.99   100 1100.99  2.1351e+01
      773  463.13 1100.68   100 1100.68  2.1392e+01
      774  463.48 1100.22   100 1100.22  2.1441e+01
      775  463.84 1100.17   100 1100.17  2.1496e+01
      776  464.20 1099.48   100 1099.48  2.1575e+01
      777  464.55 1099.23   100 1099.23  2.1660e+01
      778  464.91 1099.58   100 1099.58  2.1749e+01
      779  465.26 1098.36   100 1098.36  2.1845e+01
      780  465.62 1097.68   100 1097.68  2.1914e+01
      781  465.98 1097.92   100 1097.92  2.1967e+01
      782  466.33 1097.75   100 1097.75  2.2023e+01
      783  466.69 1097.57   100 1097.57  2.2066e+01
      784  467.04 1098.28   100 1098.28  2.2135e+01
      785  467.40 1097.92   100 1097.92  2.2194e+01
      786  467.76 1098.18   100 1098.18  2.2258e+01
      787  468.11 1098.50   100 1098.50  2.2303e+01
      788  468.47 1099.24   100 1099.24  2.2353e+01
      789  468.82 1099.13   100 1099.13  2.2423e+01
      790  469.18 1098.88   100 1098.88  2.2489e+01
      791  469.53 1098.30   100 1098.30  2.2575e+01
      792  469.89 1098.08   100 1098.08  2.2661e+01
      793  470.25 1097.75   100 1097.75  2.2734e+01
      794  470.60 1097.83   100 1097.83  2.2801e+01
      795  470.96 1097.60   100 1097.60  2.2859e+01
      796  471.31 1098.10   100 1098.10  2.2924e+01
      797  471.67 1098.50   100 1098.50  2.2984e+01
      798  472.02 1098.55   100 1098.55  2.3057e+01
      799  472.38 1098.02   100 1098.02  2.3124e+01
      800  472.74 1097.20   100 1097.20  2.3173e+01
      801  473.09 1097.61   100 1097.61  2.3226e+01
      802  473.45 1097.83   100 1097.83  2.3274e+01
      803  473.80 1098.24   100 1098.24  2.3321e+01
      804  474.16 1098.52   100 1098.52  2.3381e+01
      805  474.51 1098.97   100 1098.97  2.3438e+01
      806  474.87 1098.75   100 1098.75  2.3503e+01
      807  475.22 1098.40   100 1098.40  2.3563e+01
      808  475.58 1097.73   100 1097.73  2.3628e+01
      809  475.93 1098.36   100 1098.36  2.3685e+01
      810  476.29 1098.41   100 1098.41  2.3734e+01
      811  476.64 1098.49   100 1098.49  2.3782e+01
      812  477.00 1098.47   100 1098.47  2.3828e+01
      813  477.35 1098.64   100 1098.64  2.3846e+01
      814  477.71 1098.29   100 1098.29  2.3871e+01
      815  478.06 1098.70   100 1098.70  2.3886e+01
      816  478.42 1098.35   100 1098.35  2.3913e+01
      817  478.77 1099.07   100 1099.07  2.3929e+01
      818  479.13 1099.54   100 1099.54  2.3942e+01
      819  479.48 1099.88   100 1099.88  2.3954e+01
      820  479.84 1099.42   100 1099.42  2.3971e+01
      821  480.19 1099.64   100 1099.64  2.4007e+01
      822  480.55 1100.64   100 1100.64  2.4050e+01
      823  480.90 1100.57   100 1100.57  2.4089e+01
      824  481.25 1101.00   100 1101.00  2.4143e+01
      825  481.61 1101.45   100 1101.45  2.4187e+01
      826  481.96 1101.19   100 1101.19  2.4238e+01
      827  482.32 1101.13   100 1101.13  2.4265e+01
      828  482.67 1101.05   100 1101.05  2.4291e+01
      829  483.03 1100.62   100 1100.62  2.4312e+01
      830  483.38 1100.47   100 1100.47  2.4337e+01
      831  483.74 1101.33   100 1101.33  2.4348e+01
      832  484.09 1101.61   100 1101.61  2.4419e+01
      833  484.44 1103.06   100 1103.06  2.5000e+01
      834  484.80 1104.89   100 1104.89  2.6188e+01
      835  485.15 1106.91   100 1106.91  2.7298e+01
      836  485.51 1108.31   100 1108.31  2.7733e+01
      837  485.86 1109.59   100 1109.59  2.7730e+01
      838  486.22 1110.17   100 1110.17  2.7622e+01
      839  486.57 1110.52   100 1110.52  2.7551e+01
      840  486.92 1111.71   100 1111.71  2.7510e+01
      841  487.28 1112.27   100 1112.27  2.7480e+01
      842  487.63 1112.31   100 1112.31  2.7471e+01
      843  487.99 1113.00   100 1113.00  2.7481e+01
      844  488.34 1111.51   100 1111.51  2.7282e+01
      845  488.69 1111.02   100 1111.02  2.6642e+01
      846  489.05 1109.79   100 1109.79  2.5841e+01
      847  489.40 1108.78   100 1108.78  2.5373e+01
      848  489.75 1108.78   100 1108.78  2.5228e+01
      849  490.11 1108.74   100 1108.74  2.5231e+01
      850  490.46 1108.85   100 1108.85  2.5257e+01
      851  490.82 1108.26   100 1108.26  2.5294e+01
      852  491.17 1108.28   100 1108.28  2.5337e+01
      853  491.52 1108.47   100 1108.47  2.5377e+01
      854  491.88 1107.92   100 1107.92  2.5402e+01
      855  492.23 1108.70   100 1108.70  2.5356e+01
      856  492.58 1109.01   100 1109.01  2.5299e+01
      857  492.94 1109.06   100 1109.06  2.5263e+01
      858  493.29 1109.30   100 1109.30  2.5246e+01
      859  493.64 1109.07   100 1109.07  2.5281e+01
      860  494.00 1109.68   100 1109.68  2.5327e+01
      861  494.35 1109.54   100 1109.54  2.5376e+01
      862  494.70 1109.63   100 1109.63  2.5422e+01
      863  495.06 1109.54   100 1109.54  2.5473e+01
      864  495.41 1109.08   100 1109.08  2.5533e+01
      865  495.76 1108.56   100 1108.56  2.5598e+01
      866  496.12 1106.84   100 1106.84  2.5679e+01
      867  496.47 1105.74   100 1105.74  2.5700e+01
      868  496.82 1104.73   100 1104.73  2.5711e+01
      869  497.17 1103.86   100 1103.86  2.5785e+01
      870  497.53 1103.07   100 1103.07  2.5852e+01
      871  497.88 1103.18   100 1103.18  2.5888e+01
      872  498.23 1102.96   100 1102.96  2.5900e+01
      873  498.59 1102.74   100 1102.74  2.5909e+01
      874  498.94 1103.24   100 1103.24  2.5911e+01
      875  499.29 1103.48   100 1103.48  2.5915e+01
      876  499.64 1104.05   100 1104.05  2.5917e+01
      877  500.00 1104.95   100 1104.95  2.5923e+01
      878  500.35 1104.71   100 1104.71  2.5947e+01
      879  500.70 1105.07   100 1105.07  2.5980e+01
      880  501.05 1105.32   100 1105.32  2.6023e+01
      881  501.41 1105.06   100 1105.06  2.6084e+01
      882  501.76 1104.19   100 1104.19  2.6159e+01
      883  502.11 1104.37   100 1104.37  2.6232e+01
      884  502.46 1104.22   100 1104.22  2.6297e+01
      885  502.82 1103.65   100 1103.65  2.6362e+01
      886  503.17 1102.93   100 1102.93  2.6422e+01
      887  503.52 1102.40   100 1102.40  2.6489e+01
      888  503.87 1102.20   100 1102.20  2.6547e+01
      889  504.23 1102.61   100 1102.61  2.6582e+01
      890  504.58 1102.01   100 1102.01  2.6613e+01
      891  504.93 1101.68   100 1101.68  2.6634e+01
      892  505.28 1101.80   100 1101.80  2.6646e+01
      893  505.63 1101.88   100 1101.88  2.6659e+01
      894  505.99 1101.37   100 1101.37  2.6673e+01
      895  506.34 1101.87   100 1101.87  2.6689e+01
      896  506.69 1102.18   100 1102.18  2.6707e+01
      897  507.04 1102.53   100 1102.53  2.6727e+01
      898  507.39 1102.55   100 1102.55  2.6756e+01
      899  507.75 1102.31   100 1102.31  2.6769e+01
      900  508.10 1101.83   100 1101.83  2.6783e+01
      901  508.45 1102.07   100 1102.07  2.6792e+01
      902  508.80 1102.31   100 1102.31  2.6803e+01
      903  509.15 1102.42   100 1102.42  2.6802e+01
      904  509.50 1102.90   100 1102.90  2.6799e+01
      905  509.86 1102.88   100 1102.88  2.6790e+01
      906  510.21 1103.08   100 1103.08  2.6774e+01
      907  510.56 1103.10   100 1103.10  2.6753e+01
      908  510.91 1103.38   100 1103.38  2.6741e+01
      909  511.26 1104.06   100 1104.06  2.6721e+01
      910  511.61 1104.76   100 1104.76  2.6714e+01
      911  511.97 1105.07   100 1105.07  2.6719e+01
      912  512.32 1105.67   100 1105.67  2.6722e+01
      913  512.67 1105.78   100 1105.78  2.6729e+01
      914  513.02 1106.37   100 1106.37  2.6731e+01
      915  513.37 1106.39   100 1106.39  2.6740e+01
      916  513.72 1106.75   100 1106.75  2.6746e+01
      917  514.07 1106.61   100 1106.61  2.6773e+01
      918  514.42 1106.16   100 1106.16  2.6805e+01
      919  514.78 1106.10   100 1106.10  2.6826e+01
      920  515.13 1105.87   100 1105.87  2.6848e+01
      921  515.48 1105.64   100 1105.64  2.6867e+01
      922  515.83 1105.34   100 1105.34  2.6887e+01
      923  516.18 1105.04   100 1105.04  2.6902e+01
      924  516.53 1104.92   100 1104.92  2.6937e+01
      925  516.88 1104.94   100 1104.94  2.6973e+01
      926  517.23 1104.92   100 1104.92  2.7007e+01
      927  517.58 1104.41   100 1104.41  2.7047e+01
      928  517.93 1103.77   100 1103.77  2.7058e+01
      929  518.28 1104.12   100 1104.12  2.7046e+01
      930  518.64 1104.24   100 1104.24  2.7023e+01
      931  518.99 1104.52   100 1104.52  2.6979e+01
      932  519.34 1104.74   100 1104.74  2.6915e+01
      933  519.69 1105.23   100 1105.23  2.6851e+01
      934  520.04 1105.49   100 1105.49  2.6794e+01
      935  520.39 1105.48   100 1105.48  2.6744e+01
      936  520.74 1105.24   100 1105.24  2.6720e+01
      937  521.09 1104.28   100 1104.28  2.6708e+01
      938  521.44 1104.57   100 1104.57  2.6703e+01
      939  521.79 1104.77   100 1104.77  2.6703e+01
      940  522.14 1105.59   100 1105.59  2.6717e+01
      941  522.49 1105.64   100 1105.64  2.6738e+01
      942  522.84 1105.05   100 1105.05  2.6772e+01
      943  523.19 1104.90   100 1104.90  2.6832e+01
      944  523.54 1104.27   100 1104.27  2.6893e+01
      945  523.89 1103.97   100 1103.97  2.6961e+01
      946  524.24 1103.90   100 1103.90  2.7018e+01
      947  524.59 1103.96   100 1103.96  2.7065e+01
      948  524.94 1104.09   100 1104.09  2.7085e+01
      949  525.29 1104.33   100 1104.33  2.7075e+01
      950  525.64 1104.90   100 1104.90  2.7065e+01
      951  525.99 1104.27   100 1104.27  2.7033e+01
      952  526.34 1104.37   100 1104.37  2.6978e+01
      953  526.69 1104.95   100 1104.95  2.6911e+01
      954  527.04 1105.46   100 1105.46  2.6842e+01
      955  527.39 1105.93   100 1105.93  2.6796e+01
      956  527.74 1106.28   100 1106.28  2.6761e+01
      957  528.09 1107.17   100 1107.17  2.6728e+01
      958  528.44 1107.37   100 1107.37  2.6706e+01
      959  528.79 1108.89   100 1108.89  2.6721e+01
      960  529.14 1110.19   100 1110.19  2.7000e+01
      961  529.49 1112.22   100 1112.22  2.7714e+01
      962  529.84 1114.26   100 1114.26  2.8609e+01
      963  530.19 1116.36   100 1116.36  2.9192e+01
      964  530.54 1118.45   100 1118.45  2.9416e+01
      965  530.89 1119.02   100 1119.02  2.9443e+01
      966  531.24 1119.81   100 1119.81  2.9427e+01
      967  531.59 1120.32   100 1120.32  2.9417e+01
      968  531.93 1120.39   100 1120.39  2.9423e+01
      969  532.28 1120.35   100 1120.35  2.9445e+01
      970  532.63 1119.70   100 1119.70  2.9487e+01
      971  532.98 1118.63   100 1118.63  2.9387e+01
      972  533.33 1116.33   100 1116.33  2.8873e+01
      973  533.68 1114.07   100 1114.07  2.8013e+01
      974  534.03 1113.02   100 1113.02  2.7336e+01
      975  534.38 1112.04   100 1112.04  2.7060e+01
      976  534.73 1112.76   100 1112.76  2.7027e+01
      977  535.08 1112.83   100 1112.83  2.7024e+01
      978  535.43 1112.63   100 1112.63  2.7028e+01
      979  535.77 1112.39   100 1112.39  2.7043e+01
      980  536.12 1112.35   100 1112.35  2.7058e+01
      981  536.47 1111.94   100 1111.94  2.7085e+01
      982  536.82 1112.18   100 1112.18  2.7101e+01
      983  537.17 1112.31   100 1112.31  2.7105e+01
      984  537.52 1112.60   100 1112.60  2.7096e+01
      985  537.87 1111.80   100 1111.80  2.7063e+01
      986  538.22 1110.76   100 1110.76  2.7005e+01
      987  538.56 1109.15   100 1109.15  2.6962e+01
      988  538.91 1108.64   100 1108.64  2.6975e+01
      989  539.26 1107.84   100 1107.84  2.7004e+01
      990  539.61 1107.42   100 1107.42  2.7029e+01
      991  539.96 1107.53   100 1107.53  2.7059e+01
      992  540.31 1108.01   100 1108.01  2.7072e+01
      993  540.65 1107.43   100 1107.43  2.7087e+01
      994  541.00 1107.64   100 1107.64  2.7107e+01
      995  541.35 1107.70   100 1107.70  2.7154e+01
      996  541.70 1108.21   100 1108.21  2.7213e+01
      997  542.05 1108.98   100 1108.98  2.7287e+01
      998  542.40 1110.22   100 1110.22  2.7488e+01
      999  542.74 1111.14   100 1111.14  2.7662e+01
      1000 543.09 1112.52   100 1112.52  2.7704e+01
      1001 543.44 1113.25   100 1113.25  2.7686e+01
      1002 543.79 1114.07   100 1114.07  2.7657e+01
      1003 544.14 1113.94   100 1113.94  2.7634e+01
      1004 544.48 1114.43   100 1114.43  2.7619e+01
      1005 544.83 1114.97   100 1114.97  2.7611e+01
      1006 545.18 1115.18   100 1115.18  2.7617e+01
      1007 545.53 1113.74   100 1113.74  2.7639e+01
      1008 545.87 1112.66   100 1112.66  2.7645e+01
      1009 546.22 1111.76   100 1111.76  2.7525e+01
      1010 546.57 1110.76   100 1110.76  2.7377e+01
      1011 546.92 1110.05   100 1110.05  2.7326e+01
      1012 547.26 1109.52   100 1109.52  2.7323e+01
      1013 547.61 1108.88   100 1108.88  2.7331e+01
      1014 547.96 1108.72   100 1108.72  2.7330e+01
      1015 548.31 1108.76   100 1108.76  2.7336e+01
      1016 548.65 1108.03   100 1108.03  2.7358e+01
      1017 549.00 1107.49   100 1107.49  2.7375e+01
      1018 549.35 1108.03   100 1108.03  2.7390e+01
      1019 549.70 1107.97   100 1107.97  2.7408e+01
      1020 550.04 1106.85   100 1106.85  2.7447e+01
      1021 550.39 1106.24   100 1106.24  2.7485e+01
      1022 550.74 1105.77   100 1105.77  2.7519e+01
      1023 551.09 1105.01   100 1105.01  2.7577e+01
      1024 551.43 1103.98   100 1103.98  2.7640e+01
      1025 551.78 1103.60   100 1103.60  2.7732e+01
      1026 552.13 1102.50   100 1102.50  2.7821e+01
      1027 552.47 1101.86   100 1101.86  2.7890e+01
      1028 552.82 1101.29   100 1101.29  2.7950e+01
      1029 553.17 1100.79   100 1100.79  2.7980e+01
      1030 553.51 1099.62   100 1099.62  2.7978e+01
      1031 553.86 1100.08   100 1100.08  2.7957e+01
      1032 554.21 1099.66   100 1099.66  2.7938e+01
      1033 554.55 1099.08   100 1099.08  2.7941e+01
      1034 554.90 1098.98   100 1098.98  2.7941e+01
      1035 555.25 1099.05   100 1099.05  2.7950e+01
      1036 555.59 1098.80   100 1098.80  2.7961e+01
      1037 555.94 1099.08   100 1099.08  2.7984e+01
      1038 556.29 1098.35   100 1098.35  2.8000e+01
      1039 556.63 1098.59   100 1098.59  2.8023e+01
      1040 556.98 1098.74   100 1098.74  2.8057e+01
      1041 557.33 1099.93   100 1099.93  2.8115e+01
      1042 557.67 1099.48   100 1099.48  2.8175e+01
      1043 558.02 1100.15   100 1100.15  2.8240e+01
      1044 558.37 1100.16   100 1100.16  2.8283e+01
      1045 558.71 1100.25   100 1100.25  2.8319e+01
      1046 559.06 1100.13   100 1100.13  2.8354e+01
      1047 559.40 1100.04   100 1100.04  2.8384e+01
      1048 559.75 1099.72   100 1099.72  2.8405e+01
      1049 560.10 1100.10   100 1100.10  2.8442e+01
      1050 560.44 1099.91   100 1099.91  2.8467e+01
      1051 560.79 1099.44   100 1099.44  2.8488e+01
      1052 561.14 1099.49   100 1099.49  2.8500e+01
      1053 561.48 1099.86   100 1099.86  2.8517e+01
      1054 561.83 1099.29   100 1099.29  2.8520e+01
      1055 562.17 1099.53   100 1099.53  2.8518e+01
      1056 562.52 1099.09   100 1099.09  2.8525e+01
      1057 562.86 1099.00   100 1099.00  2.8519e+01
      1058 563.21 1100.72   100 1100.72  2.8512e+01
      1059 563.56 1101.31   100 1101.31  2.8513e+01
      1060 563.90 1101.35   100 1101.35  2.8511e+01
      1061 564.25 1101.32   100 1101.32  2.8503e+01
      1062 564.59 1100.83   100 1100.83  2.8512e+01
      1063 564.94 1099.83   100 1099.83  2.8530e+01
      1064 565.28 1100.00   100 1100.00  2.8538e+01
      1065 565.63 1099.66   100 1099.66  2.8556e+01
      1066 565.97 1099.90   100 1099.90  2.8577e+01
      1067 566.32 1100.91   100 1100.91  2.8575e+01
      1068 566.67 1101.11   100 1101.11  2.8571e+01
      1069 567.01 1099.64   100 1099.64  2.8559e+01
      1070 567.36 1099.86   100 1099.86  2.8524e+01
      1071 567.70 1100.05   100 1100.05  2.8489e+01
      1072 568.05 1099.92   100 1099.92  2.8479e+01
      1073 568.39 1100.70   100 1100.70  2.8472e+01
      1074 568.74 1101.26   100 1101.26  2.8476e+01
      1075 569.08 1100.55   100 1100.55  2.8489e+01
      1076 569.43 1101.08   100 1101.08  2.8512e+01
      1077 569.77 1100.81   100 1100.81  2.8536e+01
      1078 570.12 1100.18   100 1100.18  2.8565e+01
      1079 570.46 1099.86   100 1099.86  2.8601e+01
      1080 570.81 1099.76   100 1099.76  2.8645e+01
      1081 571.15 1099.10   100 1099.10  2.8711e+01
      1082 571.50 1099.10   100 1099.10  2.8777e+01
      1083 571.84 1099.18   100 1099.18  2.8816e+01
      1084 572.19 1099.07   100 1099.07  2.8843e+01
      1085 572.53 1098.83   100 1098.83  2.8829e+01
      1086 572.87 1099.08   100 1099.08  2.8810e+01
      1087 573.22 1099.89   100 1099.89  2.8769e+01
      1088 573.56 1099.75   100 1099.75  2.8741e+01
      1089 573.91 1099.52   100 1099.52  2.8732e+01
      1090 574.25 1098.91   100 1098.91  2.8734e+01
      1091 574.60 1098.81   100 1098.81  2.8735e+01
      1092 574.94 1098.57   100 1098.57  2.8735e+01
      1093 575.29 1098.81   100 1098.81  2.8743e+01
      1094 575.63 1099.15   100 1099.15  2.8749e+01
      1095 575.97 1099.16   100 1099.16  2.8734e+01
      1096 576.32 1099.47   100 1099.47  2.8745e+01
      1097 576.66 1099.37   100 1099.37  2.8764e+01
      1098 577.01 1098.98   100 1098.98  2.8798e+01
      1099 577.35 1099.17   100 1099.17  2.8831e+01
      1100 577.70 1100.09   100 1100.09  2.8865e+01
      1101 578.04 1100.68   100 1100.68  2.8891e+01
      1102 578.38 1100.38   100 1100.38  2.8920e+01
      1103 578.73 1100.37   100 1100.37  2.8942e+01
      1104 579.07 1099.62   100 1099.62  2.8967e+01
      1105 579.41 1099.51   100 1099.51  2.9000e+01
      1106 579.76 1099.55   100 1099.55  2.9071e+01
      1107 580.10 1099.23   100 1099.23  2.9142e+01
      1108 580.45 1099.70   100 1099.70  2.9211e+01
      1109 580.79 1099.24   100 1099.24  2.9274e+01
      1110 581.13 1099.45   100 1099.45  2.9326e+01
      1111 581.48 1098.43   100 1098.43  2.9368e+01
      1112 581.82 1098.50   100 1098.50  2.9407e+01
      1113 582.16 1098.77   100 1098.77  2.9436e+01
      1114 582.51 1098.62   100 1098.62  2.9472e+01
      1115 582.85 1098.76   100 1098.76  2.9491e+01
      1116 583.19 1098.47   100 1098.47  2.9514e+01
      1117 583.54 1098.24   100 1098.24  2.9526e+01
      1118 583.88 1098.34   100 1098.34  2.9536e+01
      1119 584.22 1097.59   100 1097.59  2.9552e+01
      1120 584.57 1097.25   100 1097.25  2.9561e+01
      1121 584.91 1097.07   100 1097.07  2.9579e+01
      1122 585.25 1097.34   100 1097.34  2.9587e+01
      1123 585.60 1097.10   100 1097.10  2.9607e+01
      1124 585.94 1096.97   100 1096.97  2.9618e+01
      1125 586.28 1097.69   100 1097.69  2.9622e+01
      1126 586.63 1098.06   100 1098.06  2.9627e+01
      1127 586.97 1097.51   100 1097.51  2.9644e+01
      1128 587.31 1097.89   100 1097.89  2.9645e+01
      1129 587.65 1097.89   100 1097.89  2.9640e+01
      1130 588.00 1098.28   100 1098.28  2.9633e+01
      1131 588.34 1098.72   100 1098.72  2.9633e+01
      1132 588.68 1098.14   100 1098.14  2.9639e+01
      1133 589.03 1097.80   100 1097.80  2.9641e+01
      1134 589.37 1097.65   100 1097.65  2.9626e+01
      1135 589.71 1097.87   100 1097.87  2.9632e+01
      1136 590.05 1097.08   100 1097.08  2.9628e+01
      1137 590.40 1096.47   100 1096.47  2.9627e+01
      1138 590.74 1096.78   100 1096.78  2.9606e+01
      1139 591.08 1096.11   100 1096.11  2.9607e+01
      1140 591.42 1095.80   100 1095.80  2.9599e+01
      1141 591.77 1095.42   100 1095.42  2.9590e+01
      1142 592.11 1095.16   100 1095.16  2.9596e+01
      1143 592.45 1095.43   100 1095.43  2.9592e+01
      1144 592.79 1095.79   100 1095.79  2.9593e+01
      1145 593.13 1096.32   100 1096.32  2.9603e+01
      1146 593.48 1096.34   100 1096.34  2.9601e+01
      1147 593.82 1096.54   100 1096.54  2.9624e+01
      1148 594.16 1096.61   100 1096.61  2.9636e+01
      1149 594.50 1096.67   100 1096.67  2.9648e+01
      1150 594.85 1097.78   100 1097.78  2.9641e+01
      1151 595.19 1097.75   100 1097.75  2.9650e+01
      1152 595.53 1097.67   100 1097.67  2.9656e+01
      1153 595.87 1097.41   100 1097.41  2.9638e+01
      1154 596.21 1097.13   100 1097.13  2.9641e+01
      1155 596.55 1097.03   100 1097.03  2.9633e+01
      1156 596.90 1097.04   100 1097.04  2.9616e+01
      1157 597.24 1096.36   100 1096.36  2.9601e+01
      1158 597.58 1096.61   100 1096.61  2.9567e+01
      1159 597.92 1096.81   100 1096.81  2.9514e+01
      1160 598.26 1097.06   100 1097.06  2.9456e+01
      1161 598.60 1096.28   100 1096.28  2.9417e+01
      1162 598.95 1096.34   100 1096.34  2.9390e+01
      1163 599.29 1097.07   100 1097.07  2.9385e+01
      1164 599.63 1097.43   100 1097.43  2.9393e+01
      1165 599.97 1098.24   100 1098.24  2.9390e+01
      1166 600.31 1098.20   100 1098.20  2.9405e+01
      1167 600.65 1097.82   100 1097.82  2.9426e+01
      1168 600.99 1098.36   100 1098.36  2.9449e+01
      1169 601.34 1098.04   100 1098.04  2.9469e+01
      1170 601.68 1097.89   100 1097.89  2.9532e+01
      1171 602.02 1098.20   100 1098.20  2.9595e+01
      1172 602.36 1097.94   100 1097.94  2.9671e+01
      1173 602.70 1098.53   100 1098.53  2.9724e+01
      1174 603.04 1097.76   100 1097.76  2.9757e+01
      1175 603.38 1096.98   100 1096.98  2.9781e+01
      1176 603.72 1096.36   100 1096.36  2.9786e+01
      1177 604.06 1095.90   100 1095.90  2.9760e+01
      1178 604.40 1096.47   100 1096.47  2.9719e+01
      1179 604.74 1096.58   100 1096.58  2.9694e+01
      1180 605.09 1097.12   100 1097.12  2.9668e+01
      1181 605.43 1098.11   100 1098.11  2.9611e+01
      1182 605.77 1098.10   100 1098.10  2.9569e+01
      1183 606.11 1098.67   100 1098.67  2.9508e+01
      1184 606.45 1098.58   100 1098.58  2.9466e+01
      1185 606.79 1098.98   100 1098.98  2.9439e+01
      1186 607.13 1100.28   100 1100.28  2.9425e+01
      1187 607.47 1100.27   100 1100.27  2.9421e+01
      1188 607.81 1100.61   100 1100.61  2.9437e+01
      1189 608.15 1099.80   100 1099.80  2.9463e+01
      1190 608.49 1099.24   100 1099.24  2.9487e+01
      1191 608.83 1098.84   100 1098.84  2.9511e+01
      1192 609.17 1098.32   100 1098.32  2.9553e+01
      1193 609.51 1097.62   100 1097.62  2.9613e+01
      1194 609.85 1097.38   100 1097.38  2.9681e+01
      1195 610.19 1097.33   100 1097.33  2.9714e+01
      1196 610.53 1097.64   100 1097.64  2.9716e+01
      1197 610.87 1096.98   100 1096.98  2.9699e+01
      1198 611.21 1097.52   100 1097.52  2.9686e+01
      1199 611.55 1097.59   100 1097.59  2.9672e+01
      1200 611.89 1097.21   100 1097.21  2.9673e+01
      1201 612.23 1097.54   100 1097.54  2.9666e+01
      1202 612.57 1097.27   100 1097.27  2.9679e+01
      1203 612.91 1097.35   100 1097.35  2.9693e+01
      1204 613.25 1097.93   100 1097.93  2.9701e+01
      1205 613.59 1097.39   100 1097.39  2.9722e+01
      1206 613.93 1096.86   100 1096.86  2.9768e+01
      1207 614.27 1096.47   100 1096.47  2.9814e+01
      1208 614.61 1096.29   100 1096.29  2.9872e+01
      1209 614.95 1096.12   100 1096.12  2.9935e+01
      1210 615.29 1096.01   100 1096.01  2.9978e+01
      1211 615.63 1096.78   100 1096.78  2.9999e+01
      1212 615.97 1097.28   100 1097.28  3.0017e+01
      1213 616.31 1097.46   100 1097.46  3.0024e+01
      1214 616.64 1096.97   100 1096.97  3.0036e+01
      1215 616.98 1096.11   100 1096.11  3.0038e+01
      1216 617.32 1096.07   100 1096.07  3.0039e+01
      1217 617.66 1096.68   100 1096.68  3.0026e+01
      1218 618.00 1096.48   100 1096.48  3.0058e+01
      1219 618.34 1096.72   100 1096.72  3.0065e+01
      1220 618.68 1096.79   100 1096.79  3.0056e+01
      1221 619.02 1096.60   100 1096.60  3.0056e+01
      1222 619.36 1096.84   100 1096.84  3.0070e+01
      1223 619.70 1096.30   100 1096.30  3.0071e+01
      1224 620.03 1095.87   100 1095.87  3.0090e+01
      1225 620.37 1095.90   100 1095.90  3.0088e+01
      1226 620.71 1097.18   100 1097.18  3.0087e+01
      1227 621.05 1097.62   100 1097.62  3.0090e+01
      1228 621.39 1096.74   100 1096.74  3.0112e+01
      1229 621.73 1096.41   100 1096.41  3.0093e+01
      1230 622.07 1096.42   100 1096.42  3.0095e+01
      1231 622.41 1095.89   100 1095.89  3.0105e+01
      1232 622.74 1095.49   100 1095.49  3.0124e+01
      1233 623.08 1094.79   100 1094.79  3.0128e+01
      1234 623.42 1093.99   100 1093.99  3.0148e+01
      1235 623.76 1094.21   100 1094.21  3.0147e+01
      1236 624.10 1093.84   100 1093.84  3.0157e+01
      1237 624.44 1092.69   100 1092.69  3.0187e+01
      1238 624.77 1092.56   100 1092.56  3.0187e+01
      1239 625.11 1092.95   100 1092.95  3.0186e+01
      1240 625.45 1093.09   100 1093.09  3.0195e+01
      1241 625.79 1092.64   100 1092.64  3.0202e+01
      1242 626.13 1092.40   100 1092.40  3.0205e+01
      1243 626.46 1092.89   100 1092.89  3.0214e+01
      1244 626.80 1093.26   100 1093.26  3.0214e+01
      1245 627.14 1094.04   100 1094.04  3.0213e+01
      1246 627.48 1094.74   100 1094.74  3.0201e+01
      1247 627.82 1095.38   100 1095.38  3.0182e+01
      1248 628.15 1096.04   100 1096.04  3.0142e+01
      1249 628.49 1096.25   100 1096.25  3.0140e+01
      1250 628.83 1096.03   100 1096.03  3.0130e+01
      1251 629.17 1096.34   100 1096.34  3.0117e+01
      1252 629.50 1096.74   100 1096.74  3.0113e+01
      1253 629.84 1097.13   100 1097.13  3.0115e+01
      1254 630.18 1097.46   100 1097.46  3.0117e+01
      1255 630.52 1097.32   100 1097.32  3.0125e+01
      1256 630.85 1097.65   100 1097.65  3.0120e+01
      1257 631.19 1097.63   100 1097.63  3.0126e+01
      1258 631.53 1097.65   100 1097.65  3.0142e+01
      1259 631.87 1097.76   100 1097.76  3.0180e+01
      1260 632.20 1097.69   100 1097.69  3.0195e+01
      1261 632.54 1097.79   100 1097.79  3.0220e+01
      1262 632.88 1097.87   100 1097.87  3.0248e+01
      1263 633.22 1097.74   100 1097.74  3.0256e+01
      1264 633.55 1097.38   100 1097.38  3.0263e+01
      1265 633.89 1097.52   100 1097.52  3.0237e+01
      1266 634.23 1097.61   100 1097.61  3.0225e+01
      1267 634.56 1097.46   100 1097.46  3.0234e+01
      1268 634.90 1097.41   100 1097.41  3.0228e+01
      1269 635.24 1097.25   100 1097.25  3.0224e+01
      1270 635.57 1097.16   100 1097.16  3.0202e+01
      1271 635.91 1096.98   100 1096.98  3.0198e+01
      1272 636.25 1097.62   100 1097.62  3.0183e+01
      1273 636.58 1097.87   100 1097.87  3.0177e+01
      1274 636.92 1098.54   100 1098.54  3.0181e+01
      1275 637.26 1099.07   100 1099.07  3.0171e+01
      1276 637.59 1099.20   100 1099.20  3.0182e+01
      1277 637.93 1099.47   100 1099.47  3.0182e+01
      1278 638.27 1099.32   100 1099.32  3.0165e+01
      1279 638.60 1099.32   100 1099.32  3.0171e+01
      1280 638.94 1099.73   100 1099.73  3.0155e+01
      1281 639.28 1099.58   100 1099.58  3.0160e+01
      1282 639.61 1099.73   100 1099.73  3.0165e+01
      1283 639.95 1098.58   100 1098.58  3.0169e+01
      1284 640.28 1098.22   100 1098.22  3.0172e+01
      1285 640.62 1097.86   100 1097.86  3.0177e+01
      1286 640.96 1097.59   100 1097.59  3.0168e+01
      1287 641.29 1097.64   100 1097.64  3.0163e+01
      1288 641.63 1097.50   100 1097.50  3.0168e+01
      1289 641.96 1098.36   100 1098.36  3.0166e+01
      1290 642.30 1098.40   100 1098.40  3.0159e+01
      1291 642.64 1097.76   100 1097.76  3.0167e+01
      1292 642.97 1097.65   100 1097.65  3.0167e+01
      1293 643.31 1097.32   100 1097.32  3.0154e+01
      1294 643.64 1098.37   100 1098.37  3.0148e+01
      1295 643.98 1098.67   100 1098.67  3.0139e+01
      1296 644.32 1098.96   100 1098.96  3.0119e+01
      1297 644.65 1099.20   100 1099.20  3.0125e+01
      1298 644.99 1098.94   100 1098.94  3.0106e+01
      1299 645.32 1099.30   100 1099.30  3.0084e+01
      1300 645.66 1098.53   100 1098.53  3.0107e+01
      1301 645.99 1098.38   100 1098.38  3.0105e+01
      1302 646.33 1098.78   100 1098.78  3.0121e+01
      1303 646.66 1099.10   100 1099.10  3.0115e+01
      1304 647.00 1099.68   100 1099.68  3.0111e+01
      1305 647.33 1099.07   100 1099.07  3.0130e+01
      1306 647.67 1099.08   100 1099.08  3.0129e+01
      1307 648.00 1098.68   100 1098.68  3.0128e+01
      1308 648.34 1098.26   100 1098.26  3.0128e+01
      1309 648.68 1098.28   100 1098.28  3.0154e+01
      1310 649.01 1098.83   100 1098.83  3.0152e+01
      1311 649.35 1098.31   100 1098.31  3.0129e+01
      1312 649.68 1098.61   100 1098.61  3.0128e+01
      1313 650.01 1098.88   100 1098.88  3.0123e+01
      1314 650.35 1098.75   100 1098.75  3.0141e+01
      1315 650.68 1098.78   100 1098.78  3.0150e+01
      1316 651.02 1099.19   100 1099.19  3.0128e+01
      1317 651.35 1099.54   100 1099.54  3.0126e+01
      1318 651.69 1099.99   100 1099.99  3.0131e+01
      1319 652.02 1100.93   100 1100.93  3.0141e+01
      1320 652.36 1101.27   100 1101.27  3.0136e+01
      1321 652.69 1100.86   100 1100.86  3.0159e+01
      1322 653.03 1101.65   100 1101.65  3.0161e+01
      1323 653.36 1101.87   100 1101.87  3.0156e+01
      1324 653.70 1102.07   100 1102.07  3.0171e+01
      1325 654.03 1102.54   100 1102.54  3.0147e+01
      1326 654.36 1102.20   100 1102.20  3.0143e+01
      1327 654.70 1102.14   100 1102.14  3.0145e+01
      1328 655.03 1102.38   100 1102.38  3.0151e+01
      1329 655.37 1102.43   100 1102.43  3.0141e+01
      1330 655.70 1102.03   100 1102.03  3.0119e+01
      1331 656.04 1101.69   100 1101.69  3.0107e+01
      1332 656.37 1102.16   100 1102.16  3.0089e+01
      1333 656.70 1102.25   100 1102.25  3.0099e+01
      1334 657.04 1102.37   100 1102.37  3.0089e+01
      1335 657.37 1101.90   100 1101.90  3.0080e+01
      1336 657.71 1102.29   100 1102.29  3.0080e+01
      1337 658.04 1102.75   100 1102.75  3.0082e+01
      1338 658.37 1103.61   100 1103.61  3.0057e+01
      1339 658.71 1103.40   100 1103.40  3.0053e+01
      1340 659.04 1103.98   100 1103.98  3.0059e+01
      1341 659.37 1104.48   100 1104.48  3.0092e+01
      1342 659.71 1105.03   100 1105.03  3.0125e+01
      1343 660.04 1104.97   100 1104.97  3.0157e+01
      1344 660.37 1105.59   100 1105.59  3.0163e+01
      1345 660.71 1106.08   100 1106.08  3.0203e+01
      1346 661.04 1107.20   100 1107.20  3.0188e+01
      1347 661.37 1107.20   100 1107.20  3.0201e+01
      1348 661.71 1107.51   100 1107.51  3.0215e+01
      1349 662.04 1107.33   100 1107.33  3.0240e+01
      1350 662.37 1108.04   100 1108.04  3.0238e+01
      1351 662.71 1108.52   100 1108.52  3.0239e+01
      1352 663.04 1108.81   100 1108.81  3.0226e+01
      1353 663.37 1109.44   100 1109.44  3.0195e+01
      1354 663.71 1109.77   100 1109.77  3.0170e+01
      1355 664.04 1109.92   100 1109.92  3.0149e+01
      1356 664.37 1109.92   100 1109.92  3.0109e+01
      1357 664.71 1110.10   100 1110.10  3.0101e+01
      1358 665.04 1110.45   100 1110.45  3.0081e+01
      1359 665.37 1111.56   100 1111.56  3.0036e+01
      1360 665.70 1112.10   100 1112.10  3.0006e+01
      1361 666.04 1111.58   100 1111.58  2.9977e+01
      1362 666.37 1111.77   100 1111.77  2.9951e+01
      1363 666.70 1111.90   100 1111.90  2.9933e+01
      1364 667.03 1112.25   100 1112.25  2.9926e+01
      1365 667.37 1112.31   100 1112.31  2.9919e+01
      1366 667.70 1113.29   100 1113.29  2.9908e+01
      1367 668.03 1113.42   100 1113.42  2.9914e+01
      1368 668.36 1113.18   100 1113.18  2.9916e+01
      1369 668.70 1113.65   100 1113.65  2.9913e+01
      1370 669.03 1113.76   100 1113.76  2.9919e+01
      1371 669.36 1114.33   100 1114.33  2.9931e+01
      1372 669.69 1115.42   100 1115.42  2.9949e+01
      1373 670.03 1115.45   100 1115.45  2.9958e+01
      1374 670.36 1116.38   100 1116.38  2.9954e+01
      1375 670.69 1116.89   100 1116.89  2.9954e+01
      1376 671.02 1118.14   100 1118.14  2.9953e+01
      1377 671.35 1118.94   100 1118.94  2.9938e+01
      1378 671.69 1120.19   100 1120.19  2.9922e+01
      1379 672.02 1122.25   100 1122.25  2.9906e+01
      1380 672.35 1123.49   100 1123.49  2.9888e+01
      1381 672.68 1124.46   100 1124.46  2.9875e+01
      1382 673.01 1125.48   100 1125.48  2.9843e+01
      1383 673.35 1126.60   100 1126.60  2.9808e+01
      1384 673.68 1127.37   100 1127.37  2.9787e+01
      1385 674.01 1128.36   100 1128.36  2.9744e+01
      1386 674.34 1129.27   100 1129.27  2.9722e+01
      1387 674.67 1130.46   100 1130.46  2.9674e+01
      1388 675.00 1131.24   100 1131.24  2.9670e+01
      1389 675.33 1132.27   100 1132.27  2.9646e+01
      1390 675.67 1132.92   100 1132.92  2.9628e+01
      1391 676.00 1133.41   100 1133.41  2.9609e+01
      1392 676.33 1134.38   100 1134.38  2.9596e+01
      1393 676.66 1135.54   100 1135.54  2.9603e+01
      1394 676.99 1137.02   100 1137.02  2.9597e+01
      1395 677.32 1138.93   100 1138.93  2.9579e+01
      1396 677.65 1140.68   100 1140.68  2.9563e+01
      1397 677.98 1142.45   100 1142.45  2.9549e+01
      1398 678.31 1144.24   100 1144.24  2.9554e+01
      1399 678.65 1145.47   100 1145.47  2.9522e+01
      1400 678.98 1147.16   100 1147.16  2.9500e+01
      1401 679.31 1149.18   100 1149.18  2.9479e+01
      1402 679.64 1151.56   100 1151.56  2.9485e+01
      1403 679.97 1154.33   100 1154.33  2.9458e+01
      1404 680.30 1157.66   100 1157.66  2.9432e+01
      1405 680.63 1160.44   100 1160.44  2.9455e+01
      1406 680.96 1164.38   100 1164.38  2.9461e+01
      1407 681.29 1168.41   100 1168.41  2.9478e+01
      1408 681.62 1173.06   100 1173.06  2.9493e+01
      1409 681.95 1177.10   100 1177.10  2.9509e+01
      1410 682.28 1182.76   100 1182.76  2.9521e+01
      1411 682.61 1187.47   100 1187.47  2.9536e+01
      1412 682.94 1191.25   100 1191.25  2.9548e+01
      1413 683.27 1195.01   100 1195.01  2.9538e+01
      1414 683.60 1199.01   100 1199.01  2.9538e+01
      1415 683.93 1202.00   100 1202.00  2.9524e+01
      1416 684.27 1205.12   100 1205.12  2.9485e+01
      1417 684.60 1207.67   100 1207.67  2.9443e+01
      1418 684.93 1208.79   100 1208.79  2.9413e+01
      1419 685.26 1210.72   100 1210.72  2.9352e+01
      1420 685.59 1213.22   100 1213.22  2.9288e+01
      1421 685.92 1214.23   100 1214.23  2.9225e+01
      1422 686.25 1216.03   100 1216.03  2.9149e+01
      1423 686.57 1218.40   100 1218.40  2.9063e+01
      1424 686.90 1220.79   100 1220.79  2.8992e+01
      1425 687.23 1223.42   100 1223.42  2.8897e+01
      1426 687.56 1226.05   100 1226.05  2.8819e+01
      1427 687.89 1229.51   100 1229.51  2.8728e+01
      1428 688.22 1232.89   100 1232.89  2.8644e+01
      1429 688.55 1237.96   100 1237.96  2.8546e+01
      1430 688.88 1242.60   100 1242.60  2.8455e+01
      1431 689.21 1246.67   100 1246.67  2.8372e+01
      1432 689.54 1251.69   100 1251.69  2.8289e+01
      1433 689.87 1256.57   100 1256.57  2.8220e+01
      1434 690.20 1261.80   100 1261.80  2.8160e+01
      1435 690.53 1267.67   100 1267.67  2.8078e+01
      1436 690.86 1273.21   100 1273.21  2.8026e+01
      1437 691.19 1278.88   100 1278.88  2.7950e+01
      1438 691.52 1283.99   100 1283.99  2.7864e+01
      1439 691.85 1289.09   100 1289.09  2.7773e+01
      1440 692.17 1294.67   100 1294.67  2.7691e+01
      1441 692.50 1299.70   100 1299.70  2.7594e+01
      1442 692.83 1304.65   100 1304.65  2.7484e+01
      1443 693.16 1308.98   100 1308.98  2.7397e+01
      1444 693.49 1314.30   100 1314.30  2.7287e+01
      1445 693.82 1319.14   100 1319.14  2.7155e+01
      1446 694.15 1324.15   100 1324.15  2.7016e+01
      1447 694.48 1328.43   100 1328.43  2.6863e+01
      1448 694.81 1333.40   100 1333.40  2.6733e+01
      1449 695.13 1338.94   100 1338.94  2.6599e+01
      1450 695.46 1344.53   100 1344.53  2.6486e+01
      1451 695.79 1349.27   100 1349.27  2.6345e+01
      1452 696.12 1353.78   100 1353.78  2.6235e+01
      1453 696.45 1360.08   100 1360.08  2.6121e+01
      1454 696.78 1367.03   100 1367.03  2.5970e+01
      1455 697.10 1373.25   100 1373.25  2.5829e+01
      1456 697.43 1380.40   100 1380.40  2.5711e+01
      1457 697.76 1388.79   100 1388.79  2.5602e+01
      1458 698.09 1399.52   100 1399.52  2.5472e+01
      1459 698.42 1411.24   100 1411.24  2.5365e+01
      1460 698.75 1425.16   100 1425.16  2.5278e+01
      1461 699.07 1442.88   100 1442.88  2.5218e+01
      1462 699.40 1466.14   100 1466.14  2.5192e+01
      1463 699.73 1497.15   100 1497.15  2.5130e+01
      1464 700.06 1531.00   100 1531.00  2.5081e+01
      1465 700.38 1566.34   100 1566.34  2.5037e+01
      1466 700.71 1601.75   100 1601.75  2.4979e+01
      1467 701.04 1633.76   100 1633.76  2.4921e+01
      1468 701.37 1660.91   100 1660.91  2.4844e+01
      1469 701.70 1684.06   100 1684.06  2.4766e+01
      1470 702.02 1702.06   100 1702.06  2.4648e+01
      1471 702.35 1715.21   100 1715.21  2.4513e+01
      1472 702.68 1721.45   100 1721.45  2.4343e+01
      1473 703.01 1720.72   100 1720.72  2.4118e+01
      1474 703.33 1711.53   100 1711.53  2.3869e+01
      1475 703.66 1696.61   100 1696.61  2.3585e+01
      1476 703.99 1679.69   100 1679.69  2.3275e+01
      1477 704.32 1662.63   100 1662.63  2.2920e+01
      1478 704.64 1648.46   100 1648.46  2.2552e+01
      1479 704.97 1638.47   100 1638.47  2.2181e+01
      1480 705.30 1629.44   100 1629.44  2.1823e+01
      1481 705.62 1625.33   100 1625.33  2.1441e+01
      1482 705.95 1624.09   100 1624.09  2.1065e+01
      1483 706.28 1626.61   100 1626.61  2.0696e+01
      1484 706.60 1629.82   100 1629.82  2.0375e+01
      1485 706.93 1634.85   100 1634.85  2.0100e+01
      1486 707.26 1642.44   100 1642.44  1.9776e+01
      1487 707.58 1650.75   100 1650.75  1.9487e+01
      1488 707.91 1660.16   100 1660.16  1.9236e+01
      1489 708.24 1670.68   100 1670.68  1.8947e+01
      1490 708.56 1682.31   100 1682.31  1.8640e+01
      1491 708.89 1696.81   100 1696.81  1.8358e+01
      1492 709.22 1710.04   100 1710.04  1.8141e+01
      1493 709.54 1724.47   100 1724.47  1.7903e+01
      1494 709.87 1738.67   100 1738.67  1.7653e+01
      1495 710.20 1755.01   100 1755.01  1.7385e+01
      1496 710.52 1771.75   100 1771.75  1.7108e+01
      1497 710.85 1788.92   100 1788.92  1.6852e+01
      1498 711.18 1806.36   100 1806.36  1.6565e+01
      1499 711.50 1824.44   100 1824.44  1.6279e+01
      1500 711.83 1842.34   100 1842.34  1.6002e+01
      1501 712.15 1860.56   100 1860.56  1.5746e+01
      1502 712.48 1878.92   100 1878.92  1.5446e+01
      1503 712.81 1899.30   100 1899.30  1.5147e+01
      1504 713.13 1919.01   100 1919.01  1.4845e+01
      1505 713.46 1938.89   100 1938.89  1.4525e+01
      1506 713.78 1957.55   100 1957.55  1.4232e+01
      1507 714.11 1974.85   100 1974.85  1.3920e+01
      1508 714.44 1991.43   100 1991.43  1.3598e+01
      1509 714.76 2008.32   100 2008.32  1.3270e+01
      1510 715.09 2025.92   100 2025.92  1.2911e+01
      1511 715.41 2042.02   100 2042.02  1.2576e+01
      1512 715.74 2058.31   100 2058.31  1.2184e+01
      1513 716.06 2074.18   100 2074.18  1.1812e+01
      1514 716.39 2090.13   100 2090.13  1.1407e+01
      1515 716.71 2106.90   100 2106.90  1.1029e+01
      1516 717.04 2126.17   100 2126.17  1.0680e+01
      1517 717.37 2147.84   100 2147.84  1.0284e+01
      1518 717.69 2171.45   100 2171.45  9.8850e+00
      1519 718.02 2192.74   100 2192.74  9.4745e+00
      1520 718.34 2210.68   100 2210.68  9.0419e+00
      1521 718.67 2224.69   100 2224.69  8.6003e+00
      1522 718.99 2237.47   100 2237.47  8.1131e+00
      1523 719.32 2245.19   100 2245.19  7.6565e+00
      1524 719.64 2249.39   100 2249.39  7.1861e+00
      1525 719.97 2250.33   100 2250.33  6.6737e+00
      1526 720.29 2249.01   100 2249.01  6.0658e+00
      1527 720.62 2243.61   100 2243.61  5.4383e+00
      1528 720.94 2234.48   100 2234.48  4.7807e+00
      1529 721.27 2222.45   100 2222.45  4.1082e+00
      1530 721.59 2211.41   100 2211.41  3.5004e+00
      1531 721.91 2204.98   100 2204.98  2.7966e+00
      1532 722.24 2198.71   100 2198.71  2.1337e+00
      1533 722.56 2193.80   100 2193.80  1.4482e+00
      1534 722.89 2191.58   100 2191.58  7.8228e-01
      1535 723.21 2190.95   100 2190.95  8.8373e-02
      1536 723.54 2192.30   100 2192.30 -6.0309e-01
      1537 723.86 2193.50   100 2193.50 -1.1910e+00
      1538 724.19 2196.66   100 2196.66 -1.8391e+00
      1539 724.51 2202.01   100 2202.01 -2.4739e+00
      1540 724.83 2208.80   100 2208.80 -3.1851e+00
      1541 725.16 2216.64   100 2216.64 -3.9614e+00
      1542 725.48 2222.05   100 2222.05 -4.5242e+00
      1543 725.81 2230.72   100 2230.72 -5.1680e+00
      1544 726.13 2240.71   100 2240.71 -5.8104e+00
      1545 726.45 2251.46   100 2251.46 -6.4619e+00
      1546 726.78 2263.88   100 2263.88 -7.1045e+00
      1547 727.10 2277.36   100 2277.36 -7.7301e+00
      1548 727.43 2292.27   100 2292.27 -8.3788e+00
      1549 727.75 2307.44   100 2307.44 -8.9797e+00
      1550 728.07 2324.03   100 2324.03 -9.6111e+00
      1551 728.40 2341.22   100 2341.22 -1.0116e+01
      1552 728.72 2361.22   100 2361.22 -1.0653e+01
      1553 729.04 2385.41   100 2385.41 -1.1283e+01
      1554 729.37 2410.50   100 2410.50 -1.1854e+01
      1555 729.69 2436.44   100 2436.44 -1.2381e+01
      1556 730.01 2463.23   100 2463.23 -1.2979e+01
      1557 730.34 2490.31   100 2490.31 -1.3536e+01
      1558 730.66 2516.67   100 2516.67 -1.4098e+01
      1559 730.98 2544.59   100 2544.59 -1.4710e+01
      1560 731.31 2570.76   100 2570.76 -1.5289e+01
      1561 731.63 2596.30   100 2596.30 -1.5896e+01
      1562 731.95 2622.41   100 2622.41 -1.6532e+01
      1563 732.28 2646.92   100 2646.92 -1.7181e+01
      1564 732.60 2669.27   100 2669.27 -1.7863e+01
      1565 732.92 2690.61   100 2690.61 -1.8504e+01
      1566 733.25 2711.59   100 2711.59 -1.9179e+01
      1567 733.57 2732.53   100 2732.53 -1.9811e+01
      1568 733.89 2753.53   100 2753.53 -2.0462e+01
      1569 734.21 2776.42   100 2776.42 -2.1164e+01
      1570 734.54 2799.56   100 2799.56 -2.1805e+01
      1571 734.86 2824.65   100 2824.65 -2.2536e+01
      1572 735.18 2847.36   100 2847.36 -2.3255e+01
      1573 735.50 2865.52   100 2865.52 -2.4035e+01
      1574 735.83 2878.52   100 2878.52 -2.4783e+01
      1575 736.15 2886.15   100 2886.15 -2.5604e+01
      1576 736.47 2889.10   100 2889.10 -2.6554e+01
      1577 736.79 2887.17   100 2887.17 -2.7484e+01
      1578 737.12 2880.62   100 2880.62 -2.8453e+01
      1579 737.44 2869.01   100 2869.01 -2.9456e+01
      1580 737.76 2853.23   100 2853.23 -3.0451e+01
      1581 738.08 2834.31   100 2834.31 -3.1540e+01
      1582 738.40 2813.90   100 2813.90 -3.2750e+01
      1583 738.73 2794.90   100 2794.90 -3.3906e+01
      1584 739.05 2779.64   100 2779.64 -3.5028e+01
      1585 739.37 2768.55   100 2768.55 -3.6184e+01
      1586 739.69 2761.93   100 2761.93 -3.7165e+01
      1587 740.01 2760.03   100 2760.03 -3.8097e+01
      1588 740.34 2761.95   100 2761.95 -3.8990e+01
      1589 740.66 2767.29   100 2767.29 -3.9797e+01
      1590 740.98 2776.22   100 2776.22 -4.0686e+01
      1591 741.30 2785.32   100 2785.32 -4.1516e+01
      1592 741.62 2794.14   100 2794.14 -4.2391e+01
      1593 741.94 2803.04   100 2803.04 -4.3306e+01
      1594 742.27 2808.78   100 2808.78 -4.4179e+01
      1595 742.59 2813.40   100 2813.40 -4.5148e+01
      1596 742.91 2816.27   100 2816.27 -4.6225e+01
      1597 743.23 2815.89   100 2815.89 -4.7301e+01
      1598 743.55 2812.61   100 2812.61 -4.8445e+01
      1599 743.87 2807.67   100 2807.67 -4.9615e+01
      1600 744.19 2800.91   100 2800.91 -5.0933e+01
      1601 744.51 2791.93   100 2791.93 -5.2126e+01
      1602 744.84 2783.04   100 2783.04 -5.3479e+01
      1603 745.16 2773.75   100 2773.75 -5.4832e+01
      1604 745.48 2763.73   100 2763.73 -5.5960e+01
      1605 745.80 2755.25   100 2755.25 -5.7229e+01
      1606 746.12 2745.85   100 2745.85 -5.8389e+01
      1607 746.44 2736.62   100 2736.62 -5.9467e+01
      1608 746.76 2729.33   100 2729.33 -6.0771e+01
      1609 747.08 2722.39   100 2722.39 -6.1887e+01
      1610 747.40 2717.56   100 2717.56 -6.3211e+01
      1611 747.72 2712.95   100 2712.95 -6.4519e+01
      1612 748.04 2709.33   100 2709.33 -6.5720e+01
      1613 748.36 2706.45   100 2706.45 -6.6920e+01
      1614 748.68 2705.29   100 2705.29 -6.8033e+01
      1615 749.00 2703.77   100 2703.77 -6.9139e+01
      1616 749.33 2703.99   100 2703.99 -7.0225e+01
      1617 749.65 2705.90   100 2705.90 -7.1188e+01
      1618 749.97 2709.58   100 2709.58 -7.2239e+01
      1619 750.29 2715.87   100 2715.87 -7.3269e+01
      1620 750.61 2723.21   100 2723.21 -7.4225e+01
      1621 750.93 2729.31   100 2729.31 -7.5055e+01
      1622 751.25 2737.04   100 2737.04 -7.5835e+01
      1623 751.57 2744.47   100 2744.47 -7.6701e+01
      1624 751.89 2751.50   100 2751.50 -7.7486e+01
      1625 752.21 2757.14   100 2757.14 -7.8437e+01
      1626 752.53 2763.88   100 2763.88 -7.9468e+01
      1627 752.85 2768.41   100 2768.41 -8.0411e+01
      1628 753.17 2771.26   100 2771.26 -8.1577e+01
      1629 753.49 2772.96   100 2772.96 -8.2376e+01
      1630 753.80 2773.32   100 2773.32 -8.3173e+01
      1631 754.12 2773.32   100 2773.32 -8.4210e+01
      1632 754.44 2773.86   100 2773.86 -8.5330e+01
      1633 754.76 2773.79   100 2773.79 -8.6067e+01
      1634 755.08 2775.63   100 2775.63 -8.7189e+01
      1635 755.40 2779.36   100 2779.36 -8.8441e+01
      1636 755.72 2782.76   100 2782.76 -8.9367e+01
      1637 756.04 2783.82   100 2783.82 -8.9880e+01
      1638 756.36 2786.00   100 2786.00 -9.0868e+01
      1639 756.68 2788.23   100 2788.23 -9.1800e+01
      1640 757.00 2789.03   100 2789.03 -9.3047e+01
      1641 757.32 2788.83   100 2788.83 -9.4238e+01
      1642 757.64 2786.56   100 2786.56 -9.5220e+01
      1643 757.96 2784.05   100 2784.05 -9.6402e+01
      1644 758.27 2779.94   100 2779.94 -9.7642e+01
      1645 758.59 2776.67   100 2776.67 -9.8838e+01
      1646 758.91 2772.35   100 2772.35 -9.9611e+01
      1647 759.23 2769.83   100 2769.83 -1.0076e+02
      1648 759.55 2769.88   100 2769.88 -1.0211e+02
      1649 759.87 2771.27   100 2771.27 -1.0303e+02
      1650 760.19 2774.01   100 2774.01 -1.0384e+02
      1651 760.51 2778.39   100 2778.39 -1.0444e+02
      1652 760.82 2784.43   100 2784.43 -1.0502e+02
      1653 761.14 2793.84   100 2793.84 -1.0570e+02
      1654 761.46 2804.14   100 2804.14 -1.0626e+02
      1655 761.78 2817.50   100 2817.50 -1.0692e+02
      1656 762.10 2829.27   100 2829.27 -1.0730e+02
      1657 762.42 2841.81   100 2841.81 -1.0799e+02
      1658 762.73 2855.65   100 2855.65 -1.0847e+02
      1659 763.05 2870.77   100 2870.77 -1.0923e+02
      1660 763.37 2887.36   100 2887.36 -1.1008e+02
      1661 763.69 2904.83   100 2904.83 -1.1063e+02
      1662 764.01 2929.00   100 2929.00 -1.1124e+02
      1663 764.32 2965.58   100 2965.58 -1.1127e+02
      1664 764.64 3027.35   100 3027.35 -1.1099e+02
      1665 764.96 3117.61   100 3117.61 -1.1009e+02
      1666 765.28 3228.32   100 3228.32 -1.0879e+02
      1667 765.60 3349.28   100 3349.28 -1.0802e+02
      1668 765.91 3459.22   100 3459.22 -1.0740e+02
      1669 766.23 3554.58   100 3554.58 -1.0709e+02
      1670 766.55 3633.79   100 3633.79 -1.0701e+02
      1671 766.87 3694.70   100 3694.70 -1.0705e+02
      1672 767.18 3741.71   100 3741.71 -1.0751e+02
      1673 767.50 3770.84   100 3770.84 -1.0809e+02
      1674 767.82 3774.91   100 3774.91 -1.0876e+02
      1675 768.14 3746.36   100 3746.36 -1.1007e+02
      1676 768.45 3681.57   100 3681.57 -1.1182e+02
      1677 768.77 3586.93   100 3586.93 -1.1439e+02
      1678 769.09 3474.65   100 3474.65 -1.1677e+02
      1679 769.40 3366.33   100 3366.33 -1.1916e+02
      1680 769.72 3266.74   100 3266.74 -1.2162e+02
      1681 770.04 3176.46   100 3176.46 -1.2396e+02
      1682 770.36 3098.41   100 3098.41 -1.2585e+02
      1683 770.67 3029.86   100 3029.86 -1.2776e+02
      1684 770.99 2969.29   100 2969.29 -1.2949e+02
      1685 771.31 2916.63   100 2916.63 -1.3135e+02
      1686 771.62 2869.06   100 2869.06 -1.3304e+02
      1687 771.94 2825.45   100 2825.45 -1.3444e+02
      1688 772.26 2787.65   100 2787.65 -1.3588e+02
      1689 772.57 2755.03   100 2755.03 -1.3723e+02
      1690 772.89 2727.14   100 2727.14 -1.3902e+02
      1691 773.21 2701.40   100 2701.40 -1.4016e+02
      1692 773.52 2678.65   100 2678.65 -1.4087e+02
      1693 773.84 2658.64   100 2658.64 -1.4212e+02
      1694 774.15 2641.04   100 2641.04 -1.4314e+02
      1695 774.47 2626.02   100 2626.02 -1.4481e+02
      1696 774.79 2611.76   100 2611.76 -1.4631e+02
      1697 775.10 2596.51   100 2596.51 -1.4689e+02
      1698 775.42 2583.55   100 2583.55 -1.4802e+02
      1699 775.74 2571.05   100 2571.05 -1.4893e+02
      1700 776.05 2559.57   100 2559.57 -1.5022e+02
      1701 776.37 2548.61   100 2548.61 -1.5113e+02
      1702 776.68 2537.93   100 2537.93 -1.5209e+02
      1703 777.00 2528.81   100 2528.81 -1.5342e+02
      1704 777.31 2519.08   100 2519.08 -1.5433e+02
      1705 777.63 2509.35   100 2509.35 -1.5539e+02
      1706 777.95 2500.03   100 2500.03 -1.5601e+02
      1707 778.26 2492.11   100 2492.11 -1.5629e+02
      1708 778.58 2486.39   100 2486.39 -1.5675e+02
      1709 778.89 2481.34   100 2481.34 -1.5695e+02
      1710 779.21 2479.14   100 2479.14 -1.5766e+02
      1711 779.52 2478.07   100 2478.07 -1.5827e+02
      1712 779.84 2477.75   100 2477.75 -1.5892e+02
      1713 780.15 2476.35   100 2476.35 -1.5915e+02
      1714 780.47 2475.12   100 2475.12 -1.5938e+02
      1715 780.79 2474.81   100 2474.81 -1.5977e+02
      1716 781.10 2474.91   100 2474.91 -1.6006e+02
      1717 781.42 2473.29   100 2473.29 -1.5986e+02
      1718 781.73 2472.18   100 2472.18 -1.6078e+02
      1719 782.05 2469.86   100 2469.86 -1.6192e+02
      1720 782.36 2466.19   100 2466.19 -1.6274e+02
      1721 782.68 2460.23   100 2460.23 -1.6296e+02
      1722 782.99 2453.36   100 2453.36 -1.6341e+02
      1723 783.30 2446.07   100 2446.07 -1.6401e+02
      1724 783.62 2439.44   100 2439.44 -1.6503e+02
      1725 783.93 2432.69   100 2432.69 -1.6590e+02
      1726 784.25 2424.53   100 2424.53 -1.6646e+02
      1727 784.56 2415.59   100 2415.59 -1.6697e+02
      1728 784.88 2408.84   100 2408.84 -1.6810e+02
      1729 785.19 2400.87   100 2400.87 -1.6888e+02
      1730 785.51 2392.85   100 2392.85 -1.6912e+02
      1731 785.82 2385.06   100 2385.06 -1.6975e+02
      1732 786.14 2377.07   100 2377.07 -1.7076e+02
      1733 786.45 2370.26   100 2370.26 -1.7156e+02
      1734 786.76 2362.48   100 2362.48 -1.7177e+02
      1735 787.08 2356.59   100 2356.59 -1.7257e+02
      1736 787.39 2350.22   100 2350.22 -1.7304e+02
      1737 787.71 2345.93   100 2345.93 -1.7344e+02
      1738 788.02 2343.37   100 2343.37 -1.7459e+02
      1739 788.33 2339.86   100 2339.86 -1.7467e+02
      1740 788.65 2338.27   100 2338.27 -1.7513e+02
      1741 788.96 2340.58   100 2340.58 -1.7611e+02
      1742 789.28 2347.27   100 2347.27 -1.7620e+02
      1743 789.59 2359.17   100 2359.17 -1.7521e+02
      1744 789.90 2375.59   100 2375.59 -1.7353e+02
      1745 790.22 2397.33   100 2397.33 -1.7259e+02
      1746 790.53 2419.16   100 2419.16 -1.7100e+02
      1747 790.84 2440.72   100 2440.72 -1.7035e+02
      1748 791.16 2459.67   100 2459.67 -1.6964e+02
      1749 791.47 2475.17   100 2475.17 -1.6877e+02
      1750 791.78 2489.88   100 2489.88 -1.6912e+02
      1751 792.10 2501.06   100 2501.06 -1.6910e+02
      1752 792.41 2505.54   100 2505.54 -1.6883e+02
      1753 792.72 2504.22   100 2504.22 -1.6961e+02
      1754 793.04 2496.37   100 2496.37 -1.7128e+02
      1755 793.35 2481.93   100 2481.93 -1.7342e+02
      1756 793.66 2460.12   100 2460.12 -1.7487e+02
      1757 793.98 2437.18   100 2437.18 -1.7724e+02
      1758 794.29 2413.93   100 2413.93 -1.7894e+02
      1759 794.60 2392.34   100 2392.34 -1.8121e+02
      1760 794.91 2371.84   100 2371.84 -1.8222e+02
      1761 795.23 2351.91   100 2351.91 -1.8274e+02
      1762 795.54 2335.17   100 2335.17 -1.8354e+02
      1763 795.85 2322.90   100 2322.90 -1.8466e+02
      1764 796.17 2312.28   100 2312.28 -1.8469e+02
      1765 796.48 2305.31   100 2305.31 -1.8485e+02
      1766 796.79 2301.20   100 2301.20 -1.8486e+02
      1767 797.10 2301.95   100 2301.95 -1.8476e+02
      1768 797.42 2305.87   100 2305.87 -1.8384e+02
      1769 797.73 2313.56   100 2313.56 -1.8302e+02
      1770 798.04 2324.16   100 2324.16 -1.8181e+02
      1771 798.35 2336.21   100 2336.21 -1.8113e+02
      1772 798.66 2346.88   100 2346.88 -1.8044e+02
      1773 798.98 2356.02   100 2356.02 -1.7981e+02
      1774 799.29 2362.53   100 2362.53 -1.7875e+02
      1775 799.60 2368.66   100 2368.66 -1.7873e+02
      1776 799.91 2372.92   100 2372.92 -1.7889e+02
      1777 800.22 2374.83   100 2374.83 -1.7882e+02
      1778 800.54 2372.14   100 2372.14 -1.7892e+02
      1779 800.85 2366.72   100 2366.72 -1.7937e+02
      1780 801.16 2358.89   100 2358.89 -1.7981e+02
      1781 801.47 2348.48   100 2348.48 -1.8090e+02
      1782 801.78 2337.92   100 2337.92 -1.8250e+02
      1783 802.09 2327.95   100 2327.95 -1.8330e+02
      1784 802.41 2318.64   100 2318.64 -1.8433e+02
      1785 802.72 2309.50   100 2309.50 -1.8527e+02
      1786 803.03 2300.87   100 2300.87 -1.8561e+02
      1787 803.34 2291.25   100 2291.25 -1.8599e+02
      1788 803.65 2282.05   100 2282.05 -1.8667e+02
      1789 803.96 2275.83   100 2275.83 -1.8801e+02
      1790 804.27 2268.11   100 2268.11 -1.8877e+02
      1791 804.59 2259.54   100 2259.54 -1.9024e+02
      1792 804.90 2249.62   100 2249.62 -1.9046e+02
      1793 805.21 2239.83   100 2239.83 -1.9033e+02
      1794 805.52 2231.12   100 2231.12 -1.9082e+02
      1795 805.83 2223.00   100 2223.00 -1.9103e+02
      1796 806.14 2216.12   100 2216.12 -1.9178e+02
      1797 806.45 2209.94   100 2209.94 -1.9255e+02
      1798 806.76 2205.18   100 2205.18 -1.9179e+02
      1799 807.07 2201.90   100 2201.90 -1.9094e+02
      1800 807.38 2200.11   100 2200.11 -1.9066e+02
      1801 807.69 2200.43   100 2200.43 -1.9116e+02
      1802 808.00 2200.25   100 2200.25 -1.9014e+02
      1803 808.31 2201.40   100 2201.40 -1.9074e+02
      1804 808.63 2201.70   100 2201.70 -1.9125e+02
      1805 808.94 2201.46   100 2201.46 -1.9137e+02
      1806 809.25 2200.54   100 2200.54 -1.9143e+02
      1807 809.56 2198.98   100 2198.98 -1.9156e+02
      1808 809.87 2195.71   100 2195.71 -1.9124e+02
      1809 810.18 2191.73   100 2191.73 -1.9241e+02
      1810 810.49 2185.87   100 2185.87 -1.9341e+02
      1811 810.80 2177.28   100 2177.28 -1.9377e+02
      1812 811.11 2167.82   100 2167.82 -1.9438e+02
      1813 811.42 2159.32   100 2159.32 -1.9658e+02
      1814 811.73 2149.52   100 2149.52 -1.9749e+02
      1815 812.04 2140.45   100 2140.45 -1.9843e+02
      1816 812.35 2131.78   100 2131.78 -1.9957e+02
      1817 812.66 2122.23   100 2122.23 -2.0048e+02
      1818 812.97 2113.96   100 2113.96 -2.0146e+02
      1819 813.28 2106.05   100 2106.05 -2.0291e+02
      1820 813.58 2098.27   100 2098.27 -2.0363e+02
      1821 813.89 2091.89   100 2091.89 -2.0513e+02
      1822 814.20 2086.27   100 2086.27 -2.0646e+02
      1823 814.51 2080.57   100 2080.57 -2.0695e+02
      1824 814.82 2074.19   100 2074.19 -2.0663e+02
      1825 815.13 2069.19   100 2069.19 -2.0736e+02
      1826 815.44 2064.30   100 2064.30 -2.0776e+02
      1827 815.75 2059.20   100 2059.20 -2.0803e+02
      1828 816.06 2055.88   100 2055.88 -2.0868e+02
      1829 816.37 2051.69   100 2051.69 -2.0888e+02
      1830 816.68 2049.40   100 2049.40 -2.0973e+02
      1831 816.99 2047.02   100 2047.02 -2.0936e+02
      1832 817.30 2045.19   100 2045.19 -2.0888e+02
      1833 817.60 2044.25   100 2044.25 -2.0797e+02
      1834 817.91 2045.87   100 2045.87 -2.0850e+02
      1835 818.22 2048.01   100 2048.01 -2.0839e+02
      1836 818.53 2051.71   100 2051.71 -2.0809e+02
      1837 818.84 2056.31   100 2056.31 -2.0805e+02
      1838 819.15 2061.32   100 2061.32 -2.0748e+02
      1839 819.46 2068.05   100 2068.05 -2.0675e+02
      1840 819.76 2076.89   100 2076.89 -2.0638e+02
      1841 820.07 2087.92   100 2087.92 -2.0612e+02
      1842 820.38 2102.86   100 2102.86 -2.0636e+02
      1843 820.69 2121.84   100 2121.84 -2.0617e+02
      1844 821.00 2146.83   100 2146.83 -2.0550e+02
      1845 821.31 2179.20   100 2179.20 -2.0302e+02
      1846 821.61 2221.31   100 2221.31 -1.9932e+02
      1847 821.92 2273.11   100 2273.11 -1.9535e+02
      1848 822.23 2335.65   100 2335.65 -1.9136e+02
      1849 822.54 2413.75   100 2413.75 -1.8816e+02
      1850 822.85 2512.02   100 2512.02 -1.8403e+02
      1851 823.15 2656.98   100 2656.98 -1.7764e+02
      1852 823.46 2904.27   100 2904.27 -1.6764e+02
      1853 823.77 3317.14   100 3317.14 -1.5571e+02
      1854 824.08 3873.10   100 3873.10 -1.4516e+02
      1855 824.38 4508.95   100 4508.95 -1.3826e+02
      1856 824.69 5118.76   100 5118.76 -1.3525e+02
      1857 825.00 5636.26   100 5636.26 -1.3434e+02
      1858 825.31 6050.51   100 6050.51 -1.3441e+02
      1859 825.61 6378.38   100 6378.38 -1.3467e+02
      1860 825.92 6633.73   100 6633.73 -1.3509e+02
      1861 826.23 6817.89   100 6817.89 -1.3570e+02
      1862 826.54 6913.66   100 6913.66 -1.3673e+02
      1863 826.84 6871.44   100 6871.44 -1.3836e+02
      1864 827.15 6634.16   100 6634.16 -1.4112e+02
      1865 827.46 6228.92   100 6228.92 -1.4559e+02
      1866 827.76 5722.69   100 5722.69 -1.5141e+02
      1867 828.07 5232.08   100 5232.08 -1.5698e+02
      1868 828.38 4854.09   100 4854.09 -1.6106e+02
      1869 828.69 4613.98   100 4613.98 -1.6236e+02
      1870 828.99 4484.03   100 4484.03 -1.6161e+02
      1871 829.30 4420.26   100 4420.26 -1.5990e+02
      1872 829.61 4375.94   100 4375.94 -1.5860e+02
      1873 829.91 4327.00   100 4327.00 -1.5814e+02
      1874 830.22 4270.19   100 4270.19 -1.5760e+02
      1875 830.52 4208.68   100 4208.68 -1.5755e+02
      1876 830.83 4144.01   100 4144.01 -1.5766e+02
      1877 831.14 4074.78   100 4074.78 -1.5842e+02
      1878 831.44 3989.79   100 3989.79 -1.5949e+02
      1879 831.75 3860.59   100 3860.59 -1.6146e+02
      1880 832.06 3672.66   100 3672.66 -1.6535e+02
      1881 832.36 3438.30   100 3438.30 -1.7173e+02
      1882 832.67 3187.69   100 3187.69 -1.7999e+02
      1883 832.97 2961.44   100 2961.44 -1.8778e+02
      1884 833.28 2776.95   100 2776.95 -1.9355e+02
      1885 833.59 2633.63   100 2633.63 -1.9907e+02
      1886 833.89 2524.87   100 2524.87 -2.0366e+02
      1887 834.20 2443.80   100 2443.80 -2.0592e+02
      1888 834.50 2395.89   100 2395.89 -2.0655e+02
      1889 834.81 2386.41   100 2386.41 -2.0363e+02
      1890 835.12 2425.14   100 2425.14 -1.9674e+02
      1891 835.42 2510.42   100 2510.42 -1.8843e+02
      1892 835.73 2625.79   100 2625.79 -1.7986e+02
      1893 836.03 2749.15   100 2749.15 -1.7291e+02
      1894 836.34 2859.29   100 2859.29 -1.6888e+02
      1895 836.64 2951.38   100 2951.38 -1.6605e+02
      1896 836.95 3023.82   100 3023.82 -1.6460e+02
      1897 837.25 3075.49   100 3075.49 -1.6312e+02
      1898 837.56 3108.96   100 3108.96 -1.6307e+02
      1899 837.86 3116.02   100 3116.02 -1.6314e+02
      1900 838.17 3090.74   100 3090.74 -1.6451e+02
      1901 838.47 3021.70   100 3021.70 -1.6779e+02
      1902 838.78 2908.68   100 2908.68 -1.7236e+02
      1903 839.08 2767.97   100 2767.97 -1.7914e+02
      1904 839.39 2618.26   100 2618.26 -1.8669e+02
      1905 839.69 2482.26   100 2482.26 -1.9463e+02
      1906 840.00 2362.75   100 2362.75 -2.0253e+02
      1907 840.30 2259.13   100 2259.13 -2.0947e+02
      1908 840.61 2170.93   100 2170.93 -2.1712e+02
      1909 840.91 2096.74   100 2096.74 -2.2380e+02
      1910 841.22 2039.63   100 2039.63 -2.2893e+02
      1911 841.52 2000.89   100 2000.89 -2.2991e+02
      1912 841.83 1980.47   100 1980.47 -2.2977e+02
      1913 842.13 1973.54   100 1973.54 -2.2748e+02
      1914 842.43 1971.37   100 1971.37 -2.2435e+02
      1915 842.74 1971.42   100 1971.42 -2.2387e+02
      1916 843.04 1969.60   100 1969.60 -2.2255e+02
      1917 843.35 1968.01   100 1968.01 -2.2199e+02
      1918 843.65 1964.67   100 1964.67 -2.2110e+02
      1919 843.96 1959.88   100 1959.88 -2.2126e+02
      1920 844.26 1951.79   100 1951.79 -2.2180e+02
      1921 844.56 1935.66   100 1935.66 -2.2382e+02
      1922 844.87 1908.78   100 1908.78 -2.2811e+02
      1923 845.17 1871.41   100 1871.41 -2.3280e+02
      1924 845.47 1828.17   100 1828.17 -2.3984e+02
      1925 845.78 1787.14   100 1787.14 -2.4755e+02
      1926 846.08 1750.37   100 1750.37 -2.5353e+02
      1927 846.39 1719.55   100 1719.55 -2.5921e+02
      1928 846.69 1691.62   100 1691.62 -2.6456e+02
      1929 846.99 1667.79   100 1667.79 -2.7058e+02
      1930 847.30 1645.56   100 1645.56 -2.7332e+02
      1931 847.60 1626.80   100 1626.80 -2.7750e+02
      1932 847.90 1610.25   100 1610.25 -2.7976e+02
      1933 848.21 1596.17   100 1596.17 -2.8417e+02
      1934 848.51 1584.04   100 1584.04 -2.8747e+02
      1935 848.81 1573.90   100 1573.90 -2.9172e+02
      1936 849.11 1565.09   100 1565.09 -2.9401e+02
      1937 849.42 1557.84   100 1557.84 -2.9662e+02
      1938 849.72 1549.55   100 1549.55 -2.9600e+02
      1939 850.02 1543.01   100 1543.01 -2.9702e+02
      1940 850.33 1537.35   100 1537.35 -2.9938e+02
      1941 850.63 1533.03   100 1533.03 -3.0320e+02
      1942 850.93 1528.34   100 1528.34 -3.0453e+02
      1943 851.23 1523.86   100 1523.86 -3.0562e+02
      1944 851.54 1519.75   100 1519.75 -3.0601e+02
      1945 851.84 1515.66   100 1515.66 -3.0566e+02
      1946 852.14 1512.30   100 1512.30 -3.0574e+02
      1947 852.44 1509.07   100 1509.07 -3.0653e+02
      1948 852.75 1505.76   100 1505.76 -3.0588e+02
      1949 853.05 1503.82   100 1503.82 -3.0847e+02
      1950 853.35 1501.78   100 1501.78 -3.0755e+02
      1951 853.65 1499.07   100 1499.07 -3.0584e+02
      1952 853.96 1496.60   100 1496.60 -3.0323e+02
      1953 854.26 1494.47   100 1494.47 -3.0279e+02
      1954 854.56 1492.97   100 1492.97 -3.0393e+02
      1955 854.86 1491.62   100 1491.62 -3.0578e+02
      1956 855.16 1489.80   100 1489.80 -3.0656e+02
      1957 855.47 1488.03   100 1488.03 -3.0563e+02
      1958 855.77 1486.69   100 1486.69 -3.0654e+02
      1959 856.07 1484.81   100 1484.81 -3.0723e+02
      1960 856.37 1483.56   100 1483.56 -3.0756e+02
      1961 856.67 1482.37   100 1482.37 -3.0984e+02
      1962 856.97 1481.28   100 1481.28 -3.1097e+02
      1963 857.28 1480.36   100 1480.36 -3.1543e+02
      1964 857.58 1478.44   100 1478.44 -3.1486e+02
      1965 857.88 1477.35   100 1477.35 -3.1660e+02
      1966 858.18 1475.89   100 1475.89 -3.1497e+02
      1967 858.48 1475.82   100 1475.82 -3.1868e+02
      1968 858.78 1475.27   100 1475.27 -3.1942e+02
      1969 859.08 1474.26   100 1474.26 -3.1877e+02
      1970 859.38 1473.87   100 1473.87 -3.1775e+02
      1971 859.69 1473.30   100 1473.30 -3.1692e+02
      1972 859.99 1472.42   100 1472.42 -3.1630e+02
      1973 860.29 1472.80   100 1472.80 -3.1769e+02
      1974 860.59 1471.99   100 1471.99 -3.1729e+02
      1975 860.89 1471.89   100 1471.89 -3.1951e+02
      1976 861.19 1470.32   100 1470.32 -3.1651e+02
      1977 861.49 1469.26   100 1469.26 -3.1775e+02
      1978 861.79 1467.44   100 1467.44 -3.1599e+02
      1979 862.09 1466.37   100 1466.37 -3.1828e+02
      1980 862.39 1464.98   100 1464.98 -3.1850e+02
      1981 862.69 1464.06   100 1464.06 -3.2047e+02
      1982 862.99 1463.23   100 1463.23 -3.2151e+02
      1983 863.29 1462.59   100 1462.59 -3.2181e+02
      1984 863.59 1460.55   100 1460.55 -3.1745e+02
      1985 863.89 1460.30   100 1460.30 -3.1640e+02
      1986 864.19 1458.72   100 1458.72 -3.1281e+02
      1987 864.49 1459.25   100 1459.25 -3.1344e+02
      1988 864.79 1459.09   100 1459.09 -3.1103e+02
      1989 865.09 1459.54   100 1459.54 -3.0942e+02
      1990 865.39 1460.35   100 1460.35 -3.0775e+02
      1991 865.69 1461.14   100 1461.14 -3.0576e+02
      1992 865.99 1462.17   100 1462.17 -3.0344e+02
      1993 866.29 1463.32   100 1463.32 -3.0166e+02
      1994 866.59 1464.39   100 1464.39 -3.0210e+02
      1995 866.89 1465.65   100 1465.65 -3.0379e+02
      1996 867.19 1465.64   100 1465.64 -3.0187e+02
      1997 867.49 1467.23   100 1467.23 -3.0451e+02
      1998 867.79 1466.67   100 1466.67 -3.0352e+02
      1999 868.09 1467.42   100 1467.42 -3.0393e+02
      2000 868.39 1467.17   100 1467.17 -3.0462e+02
      2001 868.69 1466.13   100 1466.13 -3.0348e+02
      2002 868.99 1465.83   100 1465.83 -3.0526e+02
      2003 869.29 1465.06   100 1465.06 -3.0731e+02
      2004 869.59 1463.50   100 1463.50 -3.0786e+02
      2005 869.89 1462.47   100 1462.47 -3.0762e+02
      2006 870.18 1462.07   100 1462.07 -3.1025e+02
      2007 870.48 1462.41   100 1462.41 -3.1250e+02
      2008 870.78 1462.30   100 1462.30 -3.1316e+02
      2009 871.08 1463.10   100 1463.10 -3.1504e+02
      2010 871.38 1463.44   100 1463.44 -3.1619e+02
      2011 871.68 1464.04   100 1464.04 -3.1496e+02
      2012 871.98 1464.75   100 1464.75 -3.1485e+02
      2013 872.28 1465.97   100 1465.97 -3.1359e+02
      2014 872.57 1467.40   100 1467.40 -3.1202e+02
      2015 872.87 1469.31   100 1469.31 -3.1035e+02
      2016 873.17 1471.28   100 1471.28 -3.0840e+02
      2017 873.47 1473.23   100 1473.23 -3.0573e+02
      2018 873.77 1475.59   100 1475.59 -3.0583e+02
      2019 874.07 1477.03   100 1477.03 -3.0312e+02
      2020 874.36 1478.94   100 1478.94 -3.0172e+02
      2021 874.66 1480.14   100 1480.14 -2.9875e+02
      2022 874.96 1482.48   100 1482.48 -2.9889e+02
      2023 875.26 1484.15   100 1484.15 -2.9659e+02
      2024 875.56 1485.90   100 1485.90 -2.9835e+02
      2025 875.85 1486.85   100 1486.85 -2.9598e+02
      2026 876.15 1488.32   100 1488.32 -2.9819e+02
      2027 876.45 1489.84   100 1489.84 -2.9963e+02
      2028 876.75 1490.56   100 1490.56 -2.9993e+02
      2029 877.05 1490.97   100 1490.97 -2.9821e+02
      2030 877.34 1491.79   100 1491.79 -2.9788e+02
      2031 877.64 1492.73   100 1492.73 -2.9782e+02
      2032 877.94 1494.35   100 1494.35 -3.0064e+02
      2033 878.24 1495.15   100 1495.15 -3.0150e+02
      2034 878.53 1496.97   100 1496.97 -3.0238e+02
      2035 878.83 1498.96   100 1498.96 -3.0031e+02
      2036 879.13 1502.20   100 1502.20 -3.0150e+02
      2037 879.42 1506.56   100 1506.56 -3.0123e+02
      2038 879.72 1511.75   100 1511.75 -2.9809e+02
      2039 880.02 1519.66   100 1519.66 -2.9692e+02
      2040 880.32 1529.90   100 1529.90 -2.9561e+02
      2041 880.61 1543.63   100 1543.63 -2.9307e+02
      2042 880.91 1557.00   100 1557.00 -2.9041e+02
      2043 881.21 1570.02   100 1570.02 -2.8695e+02
      2044 881.50 1581.79   100 1581.79 -2.9395e+02
      2045 881.80 1610.87   100 1610.87 -2.9002e+02
      2046 882.10 1643.93   100 1643.93 -2.7165e+02
      2047 882.39 1643.93   100 1643.93 -2.7165e+02
      2048 882.69 1643.93   100 1643.93 -2.7165e+02
      
      $metadata
       [1] "user"                "2016-12-02 20:39:12" "USB2000Plus"        
       [4] "USB2+H06330"         "20"                  "20"                 
       [7] "20"                  "100"                 "100"                
      [10] "100"                 "5"                   "5"                  
      [13] "5"                  
      

# OceanOptics others

    Code
      lr_parse_jdx(test.file("OceanOptics_period.jdx"))
    Output
      $data
               wl    dark   white   scope   processed
      1    176.36 32822.8 32822.8 32822.8         NaN
      2    176.58 32822.8 32822.8 32822.8         NaN
      3    176.80 32822.8 32822.8 32822.8         NaN
      4    177.02  1661.3  1606.0  1647.8    24.44344
      5    177.24  1654.3  1555.2  1660.1    -5.78479
      6    177.47  2568.6  2494.4  2585.4   -22.65296
      7    177.69  2592.3  2473.1  2591.1     1.03111
      8    177.91  3137.5  2913.0  3164.1   -11.86151
      9    178.13  2822.1  2563.6  2757.8    24.88102
      10   178.35  2458.8  2351.1  2454.7     3.80234
      11   178.57  2432.6  2306.4  2420.7     9.41540
      12   178.79  2813.5  2527.6  2813.9    -0.14341
      13   179.01  2874.1  2587.8  2841.4    11.44475
      14   179.23  2301.1  2224.9  2277.8    30.64514
      15   179.46  2453.1  2371.5  2462.5   -11.55823
      16   179.68  2776.6  2520.2  2816.8   -15.65486
      17   179.90  2666.9  2469.4  2699.2   -16.39010
      18   180.12  2270.4  2209.3  2294.5   -39.59757
      19   180.34  2391.6  2286.4  2419.9   -26.84818
      20   180.56  2675.1  2507.5  2734.0   -35.20749
      21   180.78  3050.7  2834.4  3085.1   -15.90919
      22   181.00  2357.2  2267.5  2342.5    16.43794
      23   181.22  2487.9  2430.9  2550.9  -110.79339
      24   181.44  2765.2  2572.7  2786.1   -10.85144
      25   181.66  2908.1  2689.8  2938.4   -13.88367
      26   181.89  2462.9  2387.1  2519.8   -75.13560
      27   182.11  2349.0  2228.6  2340.8     6.80286
      28   182.33  2807.4  2618.5  2872.5   -34.48997
      29   182.55  3334.5  3069.9  3346.0    -4.33412
      30   182.77  2505.5  2455.1  2518.6   -26.01628
      31   182.99  2563.2  2546.9  2627.5  -392.49268
      32   183.21  2470.7  2299.9  2526.4   -32.61339
      33   183.43  2825.0  2607.1  2833.6    -3.94761
      34   183.65  2410.5  2270.8  2402.3     5.86521
      35   183.87  2265.5  2169.6  2241.3    25.21363
      36   184.09  3085.1  2863.5  3096.5    -5.17578
      37   184.31  2975.7  2763.1  3015.0   -18.49704
      38   184.53  2339.2  2290.4  2351.5   -25.21029
      39   184.76  2326.1  2257.3  2340.0   -20.23775
      40   184.98  2770.5  2557.1  2715.6    25.71955
      41   185.20  3071.1  2841.4  3085.1    -6.06053
      42   185.42  2467.4  2454.7  2543.6  -599.96850
      43   185.64  2383.0  2308.5  2405.1   -29.67027
      44   185.86  3120.7  2948.7  3191.6   -41.18991
      45   186.08  3474.6  3187.9  3493.8    -6.71431
      46   186.30  2326.1  2246.6  2334.7   -10.82418
      47   186.52  2312.6  2242.1  2355.6   -61.04755
      48   186.74  3024.8  2759.0  3000.3     9.24515
      49   186.96  2977.3  2693.5  2968.7     3.03013
      50   187.18  2444.0  2345.7  2433.0    11.24991
      51   187.40  2324.4  2263.0  2366.2   -67.99805
      52   187.62  3133.8  2871.3  3167.8   -12.94839
      53   187.84  3143.6  2867.2  3178.0   -12.44448
      54   188.06  2506.7  2415.0  2490.7    17.41054
      55   188.28  2401.9  2343.7  2436.7   -59.85764
      56   188.51  3090.8  2840.9  3072.4     7.37677
      57   188.73  3103.9  2831.1  3140.8   -13.51374
      58   188.95  2445.7  2349.0  2453.1    -7.62745
      59   189.17  2521.1  2441.6  2532.5   -14.43206
      60   189.39  2949.1  2735.3  2998.2   -22.98838
      61   189.61  2991.3  2750.4  3015.8   -10.20424
      62   189.83  2480.9  2421.5  2527.6   -78.62134
      63   190.05  2489.9  2383.0  2488.3     1.53222
      64   190.27  3160.0  2939.2  3200.2   -18.18174
      65   190.49  2986.3  2727.1  3029.4   -16.58754
      66   190.71  2339.2  2187.6  2331.8     4.86506
      67   190.93  2368.3  2273.2  2365.0     3.44853
      68   191.15  2616.1  2397.8  2635.7    -9.00588
      69   191.37  3003.1  2788.5  3006.4    -1.52683
      70   191.59  2470.7  2358.4  2446.1    21.89808
      71   191.81  2507.9  2416.2  2546.9   -42.41027
      72   192.03  2870.8  2678.7  2904.0   -17.27069
      73   192.25  2972.0  2763.5  3012.6   -19.45003
      74   192.47  2319.9  2270.0  2341.2   -42.62357
      75   192.69  2444.9  2319.9  2450.2    -4.26252
      76   192.91  2972.4  2756.6  2944.6    12.90351
      77   193.13  2930.2  2702.5  2958.1   -12.23006
      78   193.35  2289.6  2187.2  2327.3   -36.80052
      79   193.57  2554.2  2446.5  2555.5    -1.13995
      80   193.79  2655.0  2550.5  2709.5   -52.15660
      81   194.01  3090.0  2906.1  3174.8   -46.10265
      82   194.23  2406.8  2356.4  2442.4   -70.73243
      83   194.45  2316.7  2253.6  2374.8   -92.20952
      84   194.67  3094.1  2853.6  3101.4    -3.06658
      85   194.89  2666.9  2504.7  2688.2   -13.13140
      86   195.11  2319.5  2218.4  2347.4   -27.53116
      87   195.33  2202.0  2150.8  2255.6  -104.80088
      88   195.55  2813.5  2595.2  2823.7    -4.69051
      89   195.77  2936.0  2715.6  2969.6   -15.24181
      90   195.99  2449.0  2379.7  2497.3   -69.82274
      91   196.21  2380.1  2260.5  2423.6   -36.30154
      92   196.43  3000.7  2760.7  3015.0    -5.97279
      93   196.65  2794.7  2576.3  2800.0    -2.43916
      94   196.87  2541.9  2468.6  2564.9   -31.28470
      95   197.09  2385.1  2326.5  2438.7   -91.60862
      96   197.31  3123.2  2897.1  3116.6     2.89834
      97   197.53  3196.5  2915.5  3172.3     8.60055
      98   197.75  2491.1  2399.0  2467.4    25.77747
      99   197.97  2462.5  2367.9  2460.0     2.59784
      100  198.19  3074.0  2862.2  3144.0   -33.07565
      101  198.41  3336.1  3063.8  3351.7    -5.71444
      102  198.63  2396.5  2292.5  2443.2   -44.88211
      103  198.85  2442.4  2328.9  2437.1     4.69337
      104  199.07  3082.6  2854.0  3115.8   -14.51604
      105  199.29  2677.5  2498.5  2713.6   -20.13777
      106  199.51  2442.4  2300.7  2461.7   -13.58312
      107  199.73  2525.6  2430.5  2542.3   -17.67201
      108  199.95  2732.8  2557.9  2753.7   -11.94360
      109  200.17  3001.9  2790.2  3047.0   -21.27645
      110  200.39  2490.7  2390.0  2479.3    11.38249
      111  200.61  2544.4  2388.3  2507.1    23.88453
      112  200.83  2695.5  2529.7  2788.5   -56.04967
      113  201.05  2978.2  2784.4  3065.4   -45.03195
      114  201.27  2329.4  2269.1  2352.7   -38.77365
      115  201.49  2460.0  2334.3  2476.8   -13.35481
      116  201.71  3171.9  2908.9  3169.4     0.93475
      117  201.93  3086.3  2861.0  3115.8   -13.09099
      118  202.15  2390.8  2288.8  2434.6   -42.97130
      119  202.37  2401.9  2298.2  2409.6    -7.50963
      120  202.59  2986.3  2754.5  2999.0    -5.47686
      121  202.81  2824.1  2619.8  2827.4    -1.60333
      122  203.03  2483.8  2399.4  2501.8   -21.36034
      123  203.25  2407.6  2344.9  2501.4  -149.67288
      124  203.47  2798.3  2646.4  2855.7   -37.73649
      125  203.69  2921.6  2662.4  2922.9    -0.47402
      126  203.91  2458.8  2403.9  2505.9   -85.82308
      127  204.13  2296.6  2232.3  2297.8    -1.91117
      128  204.35  2695.9  2517.8  2705.4    -5.28756
      129  204.57  3221.0  2891.7  3243.2    -6.71641
      130  204.79  2338.8  2242.9  2355.6   -17.52204
      131  205.01  2346.6  2277.8  2365.0   -26.78457
      132  205.23  3094.9  2883.9  3133.0   -18.05869
      133  205.45  2854.9  2663.2  2893.4   -20.08566
      134  205.67  2227.8  2161.8  2247.8   -30.43491
      135  205.89  2404.3  2315.8  2470.3   -74.53771
      136  206.10  3083.0  2905.2  3114.6   -17.74206
      137  206.32  2603.0  2454.3  2648.0   -30.30360
      138  206.54  2325.3  2211.4  2334.3    -7.91362
      139  206.76  2417.8  2317.9  2412.9     4.91790
      140  206.98  2911.4  2680.8  2898.3     5.68384
      141  207.20  2767.2  2583.3  2785.6   -10.02246
      142  207.42  2428.9  2356.4  2472.7   -60.45132
      143  207.64  2308.1  2193.8  2307.2     0.71668
      144  207.86  2691.0  2567.3  2692.3    -0.99356
      145  208.08  3382.4  3124.8  3421.3   -15.10360
      146  208.30  2387.9  2266.7  2396.1    -6.75602
      147  208.52  2321.6  2254.0  2344.1   -33.33383
      148  208.74  3093.7  2843.0  3127.2   -13.39839
      149  208.96  3067.9  2860.2  3124.4   -27.21897
      150  209.18  2254.0  2164.3  2280.2   -29.22375
      151  209.40  2595.2  2487.1  2614.8   -18.18131
      152  209.62  2753.3  2593.5  2834.8   -51.02572
      153  209.83  2895.8  2673.8  2908.1    -5.53514
      154  210.05  2330.2  2232.7  2336.3    -6.30264
      155  210.27  2362.9  2281.4  2378.9   -19.59784
      156  210.49  2856.9  2624.3  2916.3   -25.52859
      157  210.71  2721.3  2526.8  2714.0     3.78963
      158  210.93  2421.5  2361.7  2477.6   -93.83779
      159  211.15  2467.4  2392.4  2497.3   -39.89007
      160  211.37  2664.0  2509.6  2654.2     6.36653
      161  211.59  2720.9  2571.0  2789.3   -45.62841
      162  211.81  2259.7  2222.5  2281.0   -57.14324
      163  212.03  2254.4  2252.8  2291.3 -2250.48840
      164  212.25  2995.4  2739.4  3020.3    -9.75992
      165  212.47  2820.1  2597.6  2810.2     4.41979
      166  212.68  2367.5  2270.8  2338.0    30.50877
      167  212.90  2424.4  2359.7  2467.4   -66.45754
      168  213.12  2866.3  2645.6  2870.0    -1.66960
      169  213.34  3117.8  2878.6  3133.4    -6.50661
      170  213.56  2280.2  2199.5  2263.0    21.31987
      171  213.78  2348.6  2267.9  2375.6   -33.50229
      172  214.00  3165.8  2955.2  3231.3   -31.12843
      173  214.22  2610.3  2452.6  2646.8   -23.11692
      174  214.44  2417.0  2343.7  2434.6   -24.02139
      175  214.66  2371.1  2309.3  2401.0   -48.34594
      176  214.88  2825.0  2620.2  2850.0   -12.19989
      177  215.09  2897.5  2686.1  2878.2     9.10859
      178  215.31  2143.8  2068.9  2225.3  -108.74246
      179  215.53  2394.1  2312.6  2412.9   -23.11647
      180  215.75  3026.9  2763.9  3034.7    -2.95940
      181  215.97  2671.4  2481.7  2648.4    12.09496
      182  216.19  2483.4  2415.8  2515.7   -47.87890
      183  216.41  2480.1  2433.4  2535.8  -119.29798
      184  216.63  2808.6  2572.2  2816.4    -3.29321
      185  216.85  3186.2  2937.2  3238.7   -21.05263
      186  217.06  2463.7  2383.8  2518.6   -68.71917
      187  217.28  2386.7  2295.8  2397.4   -11.71121
      188  217.50  2697.2  2499.8  2712.3    -7.67637
      189  217.72  3081.0  2832.8  3110.0   -11.71610
      190  217.94  2432.2  2380.6  2471.9   -76.98270
      191  218.16  2339.6  2248.3  2385.1   -49.77447
      192  218.38  2680.4  2489.9  2706.6   -13.76338
      193  218.60  2699.2  2522.3  2734.0   -19.67561
      194  218.82  2410.5  2308.1  2422.3   -11.59984
      195  219.03  2453.5  2337.1  2442.0     9.85945
      196  219.25  2877.8  2704.5  2959.3   -47.04487
      197  219.47  2909.8  2721.3  2984.7   -39.78282
      198  219.69  2351.1  2313.8  2347.4     9.88920
      199  219.91  2490.7  2421.9  2486.2     6.54828
      200  220.13  3294.4  2985.5  3304.6    -3.31537
      201  220.35  2914.3  2695.1  2969.6   -25.23353
      202  220.57  2392.0  2337.6  2439.5   -87.21983
      203  220.78  2604.2  2466.2  2621.4   -12.46296
      204  221.00  2948.3  2731.6  3031.8   -38.56329
      205  221.22  3042.9  2823.7  3026.9     7.28964
      206  221.44  2376.9  2319.5  2409.6   -57.14111
      207  221.66  2291.7  2229.8  2308.9   -27.81452
      208  221.88  3185.0  2952.4  3241.9   -24.47206
      209  222.10  2633.7  2417.4  2609.5    11.17420
      210  222.31  2258.9  2193.8  2260.5    -2.51512
      211  222.53  2307.2  2209.8  2337.6   -31.09228
      212  222.75  2661.9  2511.6  2727.9   -43.86879
      213  222.97  2726.3  2550.9  2780.7   -31.07481
      214  223.19  2387.9  2306.4  2412.9   -30.65268
      215  223.41  2423.2  2343.3  2467.8   -55.89638
      216  223.63  2740.2  2536.2  2777.5   -18.27305
      217  223.84  3261.2  3015.4  3333.3   -29.33357
      218  224.06  2419.5  2319.1  2415.4     4.08171
      219  224.28  2392.8  2318.7  2455.1   -83.97696
      220  224.50  3101.0  2856.1  3026.9    30.26737
      221  224.72  2825.8  2661.1  2868.8   -26.11991
      222  224.94  2295.0  2258.1  2369.1  -201.10677
      223  225.16  2426.4  2338.8  2486.2   -68.22470
      224  225.37  3300.1  3056.4  3343.5   -17.81517
      225  225.59  2863.5  2680.4  2916.3   -28.85935
      226  225.81  2392.8  2300.3  2413.3   -22.12296
      227  226.03  2450.2  2375.2  2471.9   -28.96099
      228  226.25  3124.4  2912.2  3201.4   -36.29371
      229  226.47  2758.6  2560.0  2752.9     2.88644
      230  226.68  2378.1  2333.5  2406.4   -63.30384
      231  226.90  2403.5  2340.8  2433.8   -48.36599
      232  227.12  2751.2  2542.8  2800.8   -23.77220
      233  227.34  3080.1  2841.4  3111.7   -13.20767
      234  227.56  2297.4  2223.3  2327.3   -40.33263
      235  227.78  2353.9  2275.3  2375.2   -27.08349
      236  227.99  2845.0  2651.3  2906.1   -31.50131
      237  228.21  2895.0  2664.8  2959.3   -27.93581
      238  228.43  2486.6  2420.7  2520.6   -51.55205
      239  228.65  2424.8  2335.9  2469.0   -49.76936
      240  228.87  2888.5  2732.4  2979.4   -58.26792
      241  229.09  2725.4  2582.5  2795.9   -49.28366
      242  229.30  2445.3  2383.4  2492.8   -76.82097
      243  229.52  2321.6  2221.6  2315.0     6.55687
      244  229.74  2896.2  2731.2  2990.4   -57.07232
      245  229.96  3104.3  2954.0  3167.0   -41.68945
      246  230.18  2394.5  2347.8  2406.8   -26.31601
      247  230.39  2404.3  2312.2  2404.3     0.00000
      248  230.61  2949.9  2699.2  3016.7   -26.63411
      249  230.83  2814.7  2600.9  2904.8   -42.14576
      250  231.05  2288.4  2247.4  2319.5   -76.00039
      251  231.27  2436.3  2380.6  2484.6   -86.76420
      252  231.49  2759.4  2573.9  2784.8   -13.68663
      253  231.70  2968.3  2759.4  3025.7   -27.45090
      254  231.92  2348.6  2282.3  2385.9   -56.17210
      255  232.14  2349.8  2270.4  2337.6    15.46293
      256  232.36  2748.4  2545.6  2783.2   -17.17197
      257  232.58  3042.1  2832.8  3083.8   -19.96054
      258  232.79  2263.4  2202.4  2305.6   -69.12779
      259  233.01  2392.0  2268.7  2363.8    22.92294
      260  233.23  2873.7  2687.8  2935.1   -33.03954
      261  233.45  2788.1  2561.6  2843.8   -24.59273
      262  233.67  2341.2  2256.9  2377.3   -42.71831
      263  233.88  2406.8  2331.4  2412.1    -7.06561
      264  234.10  3169.8  2939.2  3214.5   -19.36071
      265  234.32  3113.3  2870.4  3176.4   -25.96989
      266  234.54  2370.3  2289.2  2419.1   -60.10111
      267  234.75  2353.1  2292.9  2364.2   -18.36738
      268  234.97  2932.3  2754.9  2971.2   -21.93974
      269  235.19  3197.7  2920.0  3183.4     5.16197
      270  235.41  2402.7  2333.5  2445.7   -62.12999
      271  235.63  2421.1  2310.1  2401.0    18.08108
      272  235.84  3203.8  2957.7  3262.4   -23.79370
      273  236.06  2596.8  2454.3  2640.7   -30.74759
      274  236.28  2354.8  2314.2  2390.4   -87.88133
      275  236.50  2290.9  2214.7  2359.3   -89.78408
      276  236.72  2620.2  2461.7  2665.2   -28.42417
      277  236.93  2718.9  2580.8  2738.1   -13.94666
      278  237.15  2382.2  2281.0  2394.5   -12.14601
      279  237.37  2321.6  2225.3  2331.4   -10.21360
      280  237.59  3029.8  2842.6  3088.3   -31.29114
      281  237.80  2701.3  2507.9  2750.8   -25.63571
      282  238.02  2362.9  2278.2  2359.3     4.34742
      283  238.24  2347.4  2266.7  2329.4    22.33486
      284  238.46  3018.7  2786.1  3086.3   -29.04934
      285  238.67  3212.0  2949.5  3252.2   -15.28857
      286  238.89  2464.9  2381.8  2494.4   -35.46851
      287  239.11  2467.4  2363.8  2494.8   -26.48248
      288  239.33  2736.5  2551.4  2760.7   -13.05304
      289  239.55  2759.4  2569.4  2787.7   -14.87075
      290  239.76  2446.9  2434.6  2505.1  -473.32357
      291  239.98  2278.2  2237.6  2286.8   -21.21384
      292  240.20  2869.6  2671.4  2891.7   -11.15696
      293  240.42  2808.2  2601.3  2840.9   -15.84133
      294  240.63  2410.9  2337.1  2458.0   -63.88840
      295  240.85  2394.5  2296.2  2396.9    -2.50046
      296  241.07  2935.1  2757.8  3001.1   -37.18213
      297  241.29  3062.5  2841.8  3142.4   -36.17821
      298  241.50  2305.6  2233.5  2345.3   -55.11458
      299  241.72  2469.4  2366.6  2449.4    19.52183
      300  241.94  2816.8  2607.1  2820.1    -1.56262
      301  242.16  3239.9  3029.8  3274.7   -16.56895
      302  242.37  2414.6  2296.6  2419.1    -3.81984
      303  242.59  2349.4  2304.0  2364.2   -32.43154
      304  242.81  2566.5  2391.6  2563.2     1.87311
      305  243.03  3070.3  2777.5  3110.9   -13.84621
      306  243.24  2339.2  2273.7  2359.7   -31.25048
      307  243.46  2477.2  2421.9  2500.2   -41.48115
      308  243.68  3093.7  2820.1  3113.3    -7.18544
      309  243.90  2698.0  2476.8  2718.9    -9.44430
      310  244.11  2286.4  2225.3  2323.2   -60.40407
      311  244.33  2358.8  2249.1  2357.2     1.49220
      312  244.55  2806.9  2603.8  2803.7     1.61302
      313  244.76  2770.9  2605.8  2851.2   -48.63480
      314  244.98  2480.1  2414.6  2517.4   -56.87495
      315  245.20  2323.2  2240.1  2349.8   -32.01881
      316  245.42  2978.2  2741.8  2974.9     1.38659
      317  245.63  2728.7  2511.6  2800.8   -33.20727
      318  245.85  2273.7  2207.7  2305.6   -48.44643
      319  246.07  2333.9  2283.5  2324.0    19.51171
      320  246.29  2925.7  2738.5  3040.8   -61.48816
      321  246.50  2918.4  2742.6  2952.8   -19.58057
      322  246.72  2423.6  2384.7  2461.7   -97.89520
      323  246.94  2460.0  2435.4  2511.2  -208.32926
      324  247.15  2756.2  2555.5  2772.5    -8.16339
      325  247.37  3175.6  2919.6  3215.7   -15.68032
      326  247.59  2306.4  2254.4  2355.2   -93.70218
      327  247.81  2506.3  2416.6  2544.0   -42.00957
      328  248.02  2853.2  2623.0  2872.5    -8.36302
      329  248.24  3013.8  2807.4  3067.0   -25.79359
      330  248.46  2376.9  2337.6  2448.6  -182.28936
      331  248.67  2314.6  2266.7  2338.4   -49.57431
      332  248.89  2974.1  2779.9  3019.5   -23.41782
      333  249.11  3027.7  2780.7  3031.0    -1.32680
      334  249.33  2534.2  2393.3  2557.9   -16.86006
      335  249.54  2336.3  2275.3  2364.6   -46.30837
      336  249.76  2840.1  2630.0  2856.9    -7.99202
      337  249.98  2605.0  2446.5  2641.9   -23.25614
      338  250.19  2329.8  2272.8  2384.2   -95.68440
      339  250.41  2308.1  2223.7  2314.6    -7.76633
      340  250.63  2936.4  2757.4  3025.7   -49.88519
      341  250.84  2749.6  2546.4  2797.5   -23.58842
      342  251.06  2397.4  2304.4  2410.5   -14.09688
      343  251.28  2431.3  2362.5  2468.6   -54.16866
      344  251.50  2601.7  2442.4  2605.0    -2.05608
      345  251.71  2890.9  2670.1  2830.7    27.27306
      346  251.93  2365.0  2290.0  2393.7   -38.25228
      347  252.15  2318.7  2250.7  2353.1   -50.60301
      348  252.36  2761.5  2587.0  2816.4   -31.45564
      349  252.58  3336.1  3052.7  3362.4    -9.24855
      350  252.80  2415.0  2344.5  2462.1   -66.86018
      351  253.01  2566.5  2510.8  2592.7   -47.05946
      352  253.23  3013.4  2775.4  3070.7   -24.09633
      353  253.45  2801.6  2600.9  2797.1     2.24463
      354  253.66  2414.6  2327.7  2412.5     2.35852
      355  253.88  2428.1  2346.6  2450.2   -27.13565
      356  254.10  2770.9  2538.3  2802.8   -13.73222
      357  254.31  3008.9  2803.7  3065.8   -27.74418
      358  254.53  2229.0  2156.9  2313.8  -117.61458
      359  254.75  2430.1  2349.4  2469.8   -49.23782
      360  254.97  3173.9  2953.6  3225.6   -23.42021
      361  255.18  2943.8  2686.5  2936.0     3.02537
      362  255.40  2371.1  2345.7  2449.8  -309.67513
      363  255.62  2374.4  2301.1  2399.4   -34.07804
      364  255.83  2723.4  2516.1  2795.1   -34.58493
      365  256.05  2972.0  2762.3  3039.2   -32.03155
      366  256.27  2394.1  2299.5  2428.5   -36.36383
      367  256.48  2455.5  2329.8  2491.1   -28.33808
      368  256.70  2942.5  2715.2  2950.3    -3.42329
      369  256.92  3001.9  2738.1  3001.5     0.15543
      370  257.13  2514.5  2458.0  2565.3   -89.85564
      371  257.35  2280.6  2217.9  2313.4   -52.28825
      372  257.57  3131.8  2901.6  3134.6    -1.24548
      373  257.78  2924.1  2695.5  2919.6     1.97153
      374  258.00  2543.6  2475.6  2606.7   -92.77268
      375  258.21  2535.4  2444.5  2571.0   -39.18992
      376  258.43  3107.2  2845.4  3117.0    -3.75578
      377  258.65  2909.3  2721.8  2956.9   -25.32757
      378  258.86  2379.7  2321.6  2398.6   -32.39345
      379  259.08  2402.3  2351.9  2449.0   -92.68360
      380  259.30  3047.4  2855.7  3044.5     1.49565
      381  259.51  3164.1  2901.2  3227.6   -24.14331
      382  259.73  2282.7  2177.0  2305.6   -21.70523
      383  259.95  2487.5  2386.7  2501.4   -13.82096
      384  260.16  3027.3  2798.3  3066.2   -16.99489
      385  260.38  3165.8  2958.1  3223.5   -27.81079
      386  260.60  2268.7  2202.8  2324.9   -85.09212
      387  260.81  2378.1  2302.7  2411.7   -44.56578
      388  261.03  2935.6  2733.2  2988.4   -26.11360
      389  261.25  2603.4  2487.1  2683.7   -69.01354
      390  261.46  2383.4  2356.0  2446.1  -228.35696
      391  261.68  2330.2  2299.9  2394.1  -210.80831
      392  261.89  2774.2  2567.3  2796.7   -10.89130
      393  262.11  2817.2  2586.6  2870.4   -23.09053
      394  262.33  2382.6  2340.4  2450.2  -160.19484
      395  262.54  2153.6  2116.8  2187.6   -92.22005
      396  262.76  2960.5  2761.5  3024.8   -32.30435
      397  262.98  2926.1  2726.7  3020.3   -47.22768
      398  263.19  2352.3  2248.3  2370.3   -17.32268
      399  263.41  2367.0  2299.5  2426.0   -87.27343
      400  263.62  2779.5  2646.0  2870.0   -67.79153
      401  263.84  2881.9  2721.3  2960.5   -48.97952
      402  264.06  2359.3  2315.4  2410.5  -116.82068
      403  264.27  2379.7  2359.7  2458.0  -389.79571
      404  264.49  2865.9  2661.9  2904.8   -19.07666
      405  264.71  2812.3  2695.1  2901.2   -75.87414
      406  264.92  2440.8  2414.1  2459.6   -70.76964
      407  265.14  2482.5  2459.6  2548.5  -287.48801
      408  265.35  2983.9  2742.2  3010.9   -11.18679
      409  265.57  2932.3  2767.2  2948.7    -9.92506
      410  265.79  2381.8  2354.3  2437.5  -202.98072
      411  266.00  2441.2  2367.5  2509.2   -92.22130
      412  266.22  3160.8  2944.6  3181.3    -9.46982
      413  266.43  2664.4  2514.9  2734.4   -46.84985
      414  266.65  2493.2  2419.1  2507.5   -19.33743
      415  266.87  2223.7  2199.1  2292.5  -280.00814
      416  267.08  2529.7  2408.0  2579.2   -40.74098
      417  267.30  2612.4  2471.5  2641.5   -20.63946
      418  267.51  2465.8  2466.2  2558.3 22577.80488
      419  267.73  2387.1  2367.0  2442.8  -277.55356
      420  267.95  3132.6  2992.5  3291.5  -113.45008
      421  268.16  2690.6  2545.6  2782.8   -63.55968
      422  268.38  2412.1  2372.8  2477.6  -166.66667
      423  268.59  2479.7  2453.1  2580.8  -379.99174
      424  268.81  2904.0  2777.9  3021.2   -92.85720
      425  269.03  3014.2  2839.7  3108.8   -54.22582
      426  269.24  2326.9  2330.6  2430.5  2811.36734
      427  269.46  2428.9  2419.1  2518.6  -912.52289
      428  269.67  2841.4  2661.1  2972.8   -72.95432
      429  269.89  2753.7  2648.4  2902.0  -140.85555
      430  270.11  2416.2  2424.0  2513.3  1247.40427
      431  270.32  2426.8  2429.7  2569.4  4971.71259
      432  270.54  2828.7  2650.5  2902.4   -41.37945
      433  270.75  3321.8  3126.8  3487.3   -84.87429
      434  270.97  2304.4  2291.3  2417.8  -865.62905
      435  271.19  2330.2  2369.5  2438.7   276.04079
      436  271.40  2798.8  2677.9  2917.5   -98.30506
      437  271.62  2643.9  2512.0  2757.0   -85.71385
      438  271.83  2263.8  2265.5  2358.4  5776.31258
      439  272.05  2244.6  2253.6  2360.1  1281.82222
      440  272.26  2869.6  2782.0  3021.6  -173.36429
      441  272.48  2973.2  2817.2  3083.4   -70.60395
      442  272.70  2503.8  2489.5  2657.4 -1071.40765
      443  272.91  2477.2  2449.4  2600.5  -442.65403
      444  273.13  2963.0  2830.3  3108.8  -109.87732
      445  273.34  3012.2  2863.1  3146.9   -90.38513
      446  273.56  2451.4  2464.5  2606.2  1181.24666
      447  273.77  2471.1  2495.2  2606.2   559.32302
      448  273.99  3224.3  3079.7  3383.2  -109.91445
      449  274.21  3316.1  3137.5  3415.2   -55.50472
      450  274.42  2649.3  2635.7  2776.6  -942.46819
      451  274.64  2498.5  2492.0  2634.5 -2074.83979
      452  274.85  2838.5  2743.9  3004.8  -175.75780
      453  275.07  2729.5  2629.2  2882.3  -152.24362
      454  275.28  2461.7  2490.3  2629.2   584.27734
      455  275.50  2601.3  2591.1  2709.9 -1059.98047
      456  275.71  2669.7  2594.8  2826.6  -209.28812
      457  275.93  2675.1  2596.0  2799.2  -156.99413
      458  276.15  2575.9  2612.0  2708.2   367.04861
      459  276.36  2481.7  2532.1  2648.8   331.70703
      460  276.58  3043.7  2932.7  3178.0  -121.03333
      461  276.79  2808.6  2721.8  2941.7  -153.30170
      462  277.01  2570.6  2598.1  2720.9   547.75717
      463  277.22  2557.5  2592.3  2692.7   388.22955
      464  277.44  3381.6  3271.8  3610.2  -208.20891
      465  277.65  3049.4  2954.0  3161.2  -117.16875
      466  277.87  2539.5  2588.6  2695.5   317.50117
      467  278.08  2459.6  2502.2  2653.8   455.76788
      468  278.30  3344.3  3265.3  3524.1  -227.46041
      469  278.52  2892.6  2836.0  3089.6  -348.55106
      470  278.73  2614.8  2621.8  2784.8  2440.86732
      471  278.95  2428.9  2459.6  2582.1   498.67509
      472  279.16  2675.5  2662.4  2835.2 -1218.75334
      473  279.38  2894.2  2844.2  3072.0  -355.74144
      474  279.59  2628.4  2702.1  2831.9   276.11052
      475  279.81  2411.3  2481.7  2623.0   300.57771
      476  280.02  3101.9  3037.1  3304.6  -313.29522
      477  280.24  3194.4  3121.9  3427.5  -321.46818
      478  280.45  2556.7  2595.2  2746.3   492.55104
      479  280.67  2404.3  2449.0  2581.3   396.32890
      480  280.88  2914.7  2811.5  3137.1  -215.47807
      481  281.10  3078.1  3008.5  3352.5  -394.11756
      482  281.31  2604.2  2684.5  2805.7   251.02143
      483  281.53  2513.3  2615.3  2736.1   218.47356
      484  281.74  2985.1  2923.3  3220.2  -380.13679
      485  281.96  2764.3  2778.7  3014.6  1745.68917
      486  282.17  2486.2  2522.7  2730.8   670.78510
      487  282.39  2442.8  2589.0  2690.6   169.46760
      488  282.60  2648.0  2688.2  2923.7   686.73642
      489  282.82  2870.0  2843.0  3057.2  -692.43147
      490  283.04  2486.6  2612.4  2716.4   182.73649
      491  283.25  2487.1  2605.4  2745.1   217.99228
      492  283.47  2913.0  2889.3  3126.0  -896.53155
      493  283.68  2894.6  2900.3  3184.2  5050.27904
      494  283.90  2553.4  2691.0  2819.6   193.45172
      495  284.11  2431.3  2585.8  2710.7   180.90171
      496  284.33  2664.4  2696.4  2936.4   851.26608
      497  284.54  2779.9  2819.6  3078.5   751.55802
      498  284.76  2432.2  2569.0  2697.2   193.71290
      499  284.97  2578.4  2768.9  2843.8   139.35451
      500  285.19  2815.1  2847.1  3093.7   871.80418
      501  285.40  3035.1  3027.3  3340.2 -3920.68611
      502  285.62  2628.4  2795.5  2907.7   167.15715
      503  285.83  2434.6  2611.2  2737.7   171.69400
      504  286.05  2941.3  2923.7  3264.1 -1832.51008
      505  286.26  2833.6  2859.0  3148.1  1238.74931
      506  286.48  2535.8  2665.6  2800.0   203.47040
      507  286.69  2575.5  2742.6  2878.6   181.37211
      508  286.91  2667.7  2706.6  3012.6   886.30243
      509  287.12  3253.4  3254.6  3594.2 27728.39707
      510  287.33  2384.2  2587.0  2712.3   161.81831
      511  287.55  2413.3  2588.6  2718.9   174.29923
      512  287.76  3000.3  3067.4  3334.1   496.94674
      513  287.98  2973.2  3040.4  3300.9   487.80760
      514  288.19  2778.7  2924.9  3104.3   222.68901
      515  288.41  2293.7  2512.0  2650.1   163.22757
      516  288.62  2827.4  2961.8  3167.8   253.35477
      517  288.84  2908.1  3015.0  3351.7   414.94238
      518  289.05  2310.1  2543.2  2648.8   145.34260
      519  289.27  2367.9  2579.6  2730.8   171.37372
      520  289.48  3062.1  3130.5  3309.1   361.07862
      521  289.70  2647.6  2772.1  3015.0   295.06730
      522  289.91  2555.9  2795.1  2941.3   161.13009
      523  290.13  2504.3  2691.4  2854.0   186.87021
      524  290.34  2963.4  3101.0  3337.0   271.42919
      525  290.56  2884.8  3024.8  3276.3   279.53184
      526  290.77  2483.8  2754.5  2872.5   143.57026
      527  290.99  2424.8  2711.5  2853.2   149.42835
      528  291.20  2727.9  2876.6  3124.4   266.66599
      529  291.41  2709.1  2867.2  3090.8   241.45083
      530  291.63  2453.9  2773.8  2876.2   132.01008
      531  291.84  2679.6  2919.6  3032.6   147.09902
      532  292.06  2901.2  3107.2  3328.8   207.55491
      533  292.27  2761.5  2984.3  3264.1   225.55168
      534  292.49  2473.5  2720.5  2877.4   163.51560
      535  292.70  2648.0  2970.8  3140.4   152.53827
      536  292.92  2913.0  3146.5  3369.3   195.43878
      537  293.13  2991.3  3201.8  3484.0   234.04677
      538  293.35  2514.1  2848.3  3001.5   145.83325
      539  293.56  2492.0  2831.9  2914.7   124.33735
      540  293.77  2681.6  2938.0  3162.5   187.53968
      541  293.99  3110.9  3304.6  3586.4   245.45544
      542  294.20  2416.2  2769.3  2963.4   154.98868
      543  294.42  2471.9  2850.8  2980.6   134.27050
      544  294.63  2911.4  3182.1  3461.1   203.02539
      545  294.85  3133.0  3337.4  3641.3   248.69732
      546  295.06  2389.2  2796.7  2956.0   139.09546
      547  295.28  2473.5  2868.0  2985.5   129.80291
      548  295.49  2533.3  2839.3  3070.7   175.63561
      549  295.70  3160.0  3404.5  3709.3   224.62346
      550  295.92  2417.4  2891.3  3020.3   127.22558
      551  296.13  2620.6  3033.0  3231.7   148.16286
      552  296.35  3110.0  3449.6  3731.0   182.87047
      553  296.56  2867.6  3181.7  3439.4   182.00810
      554  296.78  2359.3  2844.2  2980.2   128.04051
      555  296.99  2478.5  2921.2  3053.9   129.97215
      556  297.20  2785.6  3160.0  3380.4   158.86198
      557  297.42  3018.3  3386.9  3665.9   175.66645
      558  297.63  2533.3  3019.5  3164.1   129.73891
      559  297.85  2447.7  2982.7  3042.5   111.17903
      560  298.06  2709.9  3139.5  3355.0   150.14290
      561  298.28  2917.9  3316.1  3563.9   162.24276
      562  298.49  2383.4  2911.4  3043.3   124.98078
      563  298.70  2482.5  3001.5  3186.2   135.59596
      564  298.92  3098.6  3497.1  3750.7   163.61791
      565  299.13  3058.0  3533.2  3784.2   152.84481
      566  299.35  2565.7  3156.7  3235.0   113.23624
      567  299.56  2439.1  3035.5  3138.3   117.23902
      568  299.77  2603.4  3076.9  3348.4   157.35306
      569  299.99  2785.2  3207.1  3441.0   155.43696
      570  300.20  2539.5  3122.3  3306.7   131.62329
      571  300.42  2398.6  2992.9  3144.9   125.56851
      572  300.63  2865.1  3274.7  3614.7   183.00000
      573  300.85  3110.0  3567.2  3850.6   162.00714
      574  301.06  2608.3  3242.3  3345.2   116.21447
      575  301.27  2461.7  3125.2  3251.4   119.01236
      576  301.49  2791.8  3324.7  3561.4   144.42756
      577  301.70  3025.7  3465.2  3762.1   167.56770
      578  301.92  2481.7  3194.8  3306.7   115.68065
      579  302.13  2499.8  3148.5  3254.2   116.28786
      580  302.34  2793.8  3384.9  3577.0   132.50164
      581  302.56  3090.8  3593.8  3888.7   158.63172
      582  302.77  2487.9  3181.7  3292.7   115.99765
      583  302.99  2522.3  3204.3  3354.2   121.98192
      584  303.20  2874.5  3498.8  3714.6   134.58006
      585  303.41  2873.7  3486.5  3724.8   138.90383
      586  303.63  2467.8  3252.2  3334.5   110.49617
      587  303.84  2443.2  3150.2  3244.8   113.38352
      588  304.05  2595.2  3285.4  3491.4   129.85170
      589  304.27  2914.7  3497.9  3774.0   147.33139
      590  304.48  2562.4  3308.3  3431.6   116.52929
      591  304.70  2380.6  3187.9  3316.1   115.88029
      592  304.91  3082.2  3638.0  4014.8   167.79653
      593  305.12  2908.5  3597.9  3816.2   131.66973
      594  305.34  2381.0  3191.6  3351.3   119.70683
      595  305.55  2462.1  3258.3  3378.3   115.07203
      596  305.77  2641.1  3368.9  3559.0   126.11132
      597  305.98  2973.7  3709.3  3922.7   129.00888
      598  306.19  2487.1  3321.4  3487.3   119.88211
      599  306.41  2565.3  3456.6  3532.7   108.54775
      600  306.62  2708.2  3495.9  3699.0   125.79296
      601  306.83  3012.2  3785.1  3989.4   126.44403
      602  307.05  2462.9  3384.1  3525.4   115.34005
      603  307.26  2435.9  3356.6  3493.0   114.81319
      604  307.47  3074.0  3891.6  4146.3   131.16241
      605  307.69  3112.5  3941.9  4204.9   131.70369
      606  307.90  2462.5  3463.9  3551.6   108.75256
      607  308.12  2500.6  3451.2  3620.0   117.75101
      608  308.33  2809.4  3762.1  3980.4   122.91483
      609  308.54  3166.2  4073.8  4366.7   132.26542
      610  308.76  2346.6  3283.7  3455.3   118.31297
      611  308.97  2492.0  3561.0  3629.8   106.43680
      612  309.18  2914.3  3864.1  4143.0   129.36620
      613  309.40  2688.6  3653.6  3876.0   123.04760
      614  309.61  2555.9  3629.8  3753.5   111.51789
      615  309.82  2409.2  3418.9  3621.2   120.04053
      616  310.04  2787.7  3787.5  4006.2   121.87628
      617  310.25  3035.5  4057.4  4320.4   125.73143
      618  310.46  2364.6  3514.3  3661.4   112.78954
      619  310.68  2458.8  3619.6  3736.7   110.09176
      620  310.89  2883.1  3904.2  4149.6   124.02719
      621  311.11  2648.0  3667.5  3897.3   122.53928
      622  311.32  2492.4  3640.1  3781.4   112.31264
      623  311.53  2443.2  3639.2  3753.9   109.58911
      624  311.75  2965.0  4013.6  4299.9   127.30468
      625  311.96  2986.8  4016.9  4306.1   128.07156
      626  312.17  2521.5  3757.2  3888.3   110.60657
      627  312.39  2494.4  3761.7  3880.1   109.34069
      628  312.60  2809.0  3930.1  4236.0   127.29270
      629  312.81  2999.5  4129.1  4371.6   121.46478
      630  313.03  2519.0  3777.7  3891.6   109.04653
      631  313.24  2446.1  3701.5  3878.4   114.09458
      632  313.45  2802.4  3921.9  4142.2   119.68537
      633  313.67  2911.0  4121.7  4322.4   116.57646
      634  313.88  2533.7  3791.2  3972.7   114.42996
      635  314.09  2477.2  3806.4  3957.5   111.37133
      636  314.31  2776.6  4011.6  4179.9   113.63184
      637  314.52  2895.8  4009.5  4279.8   124.27365
      638  314.73  2482.5  3778.9  3917.4   110.67933
      639  314.95  2422.3  3812.5  3946.4   109.63463
      640  315.16  3151.4  4309.3  4622.7   127.06046
      641  315.37  3003.6  4232.7  4494.1   121.25959
      642  315.58  2447.3  3806.4  3899.3   106.84149
      643  315.80  2315.0  3680.2  3783.4   107.56071
      644  316.01  2626.3  3919.8  4152.1   117.95443
      645  316.22  2854.5  4083.2  4346.2   121.39999
      646  316.44  2483.8  3887.0  4024.7   109.80731
      647  316.65  2655.8  3974.3  4174.6   115.19111
      648  316.86  2806.1  4089.8  4402.7   124.37774
      649  317.08  2901.2  4215.5  4415.4   115.20725
      650  317.29  2580.4  3936.2  4057.4   108.94262
      651  317.50  2375.6  3744.9  3919.4   112.74305
      652  317.72  2726.7  3992.7  4194.6   115.94956
      653  317.93  3070.7  4339.2  4614.1   121.66617
      654  318.14  2488.7  3885.4  4042.7   111.26100
      655  318.35  2681.2  4081.2  4167.6   106.17318
      656  318.57  2759.0  4102.5  4326.5   116.67685
      657  318.78  3044.5  4357.3  4671.0   123.90017
      658  318.99  2519.4  4014.0  4109.5   106.38529
      659  319.21  2335.5  3865.7  3948.9   105.43359
      660  319.42  3012.6  4487.9  4698.0   114.24204
      661  319.63  2728.7  4116.0  4405.6   120.87387
      662  319.85  2313.0  3889.1  4043.9   109.82326
      663  320.06  2535.8  4099.2  4199.6   106.41869
      664  320.27  2827.4  4222.5  4473.6   117.99766
      665  320.48  2486.6  4017.3  4224.1   113.51346
      666  320.70  2406.4  4041.9  4123.8   105.00878
      667  320.91  2451.8  4139.4  4215.5   104.51460
      668  321.12  2918.8  4418.7  4670.2   116.76683
      669  321.34  2830.3  4406.4  4641.1   114.89084
      670  321.55  2462.1  4172.5  4265.1   105.41186
      671  321.76  2464.1  4159.8  4248.7   105.24156
      672  321.97  2990.9  4570.7  4802.9   114.70050
      673  322.19  2764.8  4396.6  4639.9   114.90966
      674  322.40  2582.9  4321.2  4476.4   108.93025
      675  322.61  2566.1  4322.0  4409.7   104.99183
      676  322.83  2746.3  4481.4  4730.4   114.35316
      677  323.04  2801.2  4522.7  4875.8   120.50918
      678  323.25  2503.0  4398.2  4549.4   107.97492
      679  323.46  2499.8  4428.9  4568.6   107.23994
      680  323.68  2915.5  4724.3  5011.4   115.87414
      681  323.89  2604.6  4523.1  4740.2   111.31508
      682  324.10  2438.7  4419.9  4500.6   104.07277
      683  324.31  2535.8  4688.6  4784.1   104.43301
      684  324.53  2791.8  4815.6  5045.0   111.33371
      685  324.74  3029.8  5008.1  5305.9   115.05173
      686  324.95  2471.5  4689.0  4716.9   101.25603
      687  325.16  2643.5  4835.3  4908.6   103.34520
      688  325.38  2976.9  5087.2  5305.1   110.32609
      689  325.59  2945.8  5155.1  5329.2   107.87911
      690  325.80  2478.9  4781.6  4872.1   103.93102
      691  326.01  2453.1  4708.3  4805.4   104.30441
      692  326.23  3053.5  5316.9  5487.7   107.54616
      693  326.44  2866.7  5110.1  5332.1   109.89589
      694  326.65  2459.2  4793.1  4880.7   103.75570
      695  326.86  2668.5  4886.0  4987.6   104.58070
      696  327.08  2899.1  5001.5  5206.8   109.76040
      697  327.29  2875.8  5057.3  5264.5   109.50054
      698  327.50  2455.5  4767.7  4941.7   107.52882
      699  327.71  2634.9  4896.7  4981.9   103.76677
      700  327.93  2439.1  4660.4  4847.1   108.40860
      701  328.14  2696.8  4931.1  5133.4   109.05590
      702  328.35  2395.3  4770.9  4769.3    99.93105
      703  328.56  2529.7  4930.3  5016.3   103.58302
      704  328.78  2909.3  5073.6  5421.4   116.06736
      705  328.99  3246.0  5467.7  5738.4   112.18655
      706  329.20  2454.7  4858.6  4986.4   105.31606
      707  329.41  2562.4  4955.7  5051.9   104.02188
      708  329.63  2800.0  5257.5  5430.0   107.01667
      709  329.84  2733.2  5112.5  5316.9   108.59011
      710  330.05  2480.1  4971.2  5015.1   101.75931
      711  330.26  2446.5  4896.7  5011.4   104.68074
      712  330.48  2507.1  4869.7  5122.4   110.69693
      713  330.69  2677.5  5081.4  5344.0   110.92181
      714  330.90  2433.4  5020.0  5064.6   101.72606
      715  331.11  2339.2  4833.6  4972.9   105.58293
      716  331.32  2692.3  5136.7  5350.9   108.76343
      717  331.54  2968.7  5345.6  5615.1   111.33898
      718  331.75  2420.3  4999.9  5119.9   104.65227
      719  331.96  2512.0  5151.5  5246.5   103.60022
      720  332.17  3079.3  5615.1  5870.3   110.06300
      721  332.39  2583.7  5110.5  5264.5   106.09498
      722  332.60  2426.4  5033.1  5142.0   104.17976
      723  332.81  2367.0  4974.5  5090.4   104.44549
      724  333.02  2607.1  5195.7  5438.6   109.38291
      725  333.23  2575.1  5167.4  5288.3   104.66108
      726  333.45  2466.6  5142.0  5278.8   105.11328
      727  333.66  2581.3  5244.8  5410.3   106.21252
      728  333.87  2805.3  5470.9  5609.8   105.20896
      729  334.08  2728.3  5392.7  5664.3   110.19217
      730  334.29  2478.5  5269.8  5359.5   103.21350
      731  334.51  2526.4  5371.8  5521.7   105.26845
      732  334.72  2924.9  5615.9  5792.5   106.56013
      733  334.93  2822.1  5583.6  5817.5   108.46930
      734  335.14  2513.3  5388.2  5482.4   103.27680
      735  335.35  2451.8  5357.1  5403.0   101.57900
      736  335.57  2623.0  5511.5  5672.9   105.58703
      737  335.78  2811.5  5630.3  5900.6   109.59024
      738  335.99  2385.1  5422.2  5470.1   101.57790
      739  336.20  2288.0  5243.2  5403.4   105.41926
      740  336.41  2614.8  5560.6  5763.8   106.89653
      741  336.63  2997.0  5974.3  6248.8   109.21723
      742  336.84  2320.3  5434.1  5527.1   102.98606
      743  337.05  2625.5  5740.0  5828.1   102.82744
      744  337.26  3029.8  6058.3  6274.2   107.12740
      745  337.47  2622.2  5728.2  5878.9   104.85294
      746  337.69  2494.4  5804.8  5914.5   103.31601
      747  337.90  2390.8  5658.9  5793.7   104.12334
      748  338.11  2915.5  6032.5  6293.0   108.35740
      749  338.32  3155.9  6316.8  6558.4   107.64545
      750  338.53  2342.9  5722.4  5731.0   100.25453
      751  338.74  2442.8  5755.2  5776.5   100.64301
      752  338.96  3026.5  6277.8  6589.5   109.58680
      753  339.17  3232.5  6496.2  6730.9   107.19126
      754  339.38  2853.6  6326.6  6398.3   102.06393
      755  339.59  2536.6  6081.6  6150.5   101.94108
      756  339.80  2873.3  6334.4  6545.3   106.09468
      757  340.01  3043.3  6499.4  6726.8   106.57737
      758  340.23  2581.3  6255.7  6320.4   101.76124
      759  340.44  2356.8  5989.9  6065.3   102.07440
      760  340.65  2920.8  6501.5  6738.2   106.61175
      761  340.86  2862.2  6409.7  6558.0   104.17966
      762  341.07  2373.2  6167.3  6267.2   102.63414
      763  341.28  2550.9  6266.4  6351.6   102.29301
      764  341.50  2944.2  6630.5  6805.4   104.74443
      765  341.71  2696.4  6478.1  6610.4   103.49833
      766  341.92  2544.8  6434.3  6474.9   101.04255
      767  342.13  2337.6  6447.8  6401.1    98.86397
      768  342.34  2632.0  6640.7  6686.2   101.13416
      769  342.55  2602.1  6521.1  6627.6   102.71738
      770  342.77  2432.2  6448.2  6541.6   102.32536
      771  342.98  2383.0  6458.5  6499.0   100.99498
      772  343.19  2894.2  6856.2  7042.1   104.69346
      773  343.40  2893.4  6904.1  7112.6   105.19812
      774  343.61  2388.3  6642.0  6586.3    98.69041
      775  343.82  2621.0  6755.0  6872.6   102.84357
      776  344.03  2516.5  6741.5  6760.3   100.44595
      777  344.25  3015.8  7151.9  7327.2   104.23848
      778  344.46  2387.9  6660.8  6694.8   100.79562
      779  344.67  2568.6  6924.6  6936.1   100.26329
      780  344.88  2768.9  6988.9  7136.4   103.49413
      781  345.09  2863.5  7181.0  7379.2   104.59159
      782  345.30  2470.7  6892.2  6840.6    98.83279
      783  345.51  2564.1  7031.1  7030.7    99.99084
      784  345.73  2922.9  7277.7  7393.6   102.66177
      785  345.94  2863.1  7185.5  7344.4   103.67669
      786  346.15  2625.5  7197.0  7206.8   100.21503
      787  346.36  2629.6  7071.6  7134.3   101.41079
      788  346.57  2896.6  7305.5  7479.6   103.94834
      789  346.78  2676.7  7150.7  7237.9   101.95000
      790  346.99  2471.5  7159.7  7185.5   100.55040
      791  347.21  2661.9  7299.4  7276.0    99.49655
      792  347.42  2827.4  7243.7  7427.2   104.15507
      793  347.63  2809.0  7298.1  7384.2   101.91607
      794  347.84  2565.7  7242.4  7244.5   100.04379
      795  348.05  2528.0  7167.5  7243.3   101.63327
      796  348.26  2769.3  7385.8  7419.8   100.73642
      797  348.47  2576.8  7286.3  7365.7   101.68725
      798  348.68  2379.7  7159.7  7157.2    99.94858
      799  348.89  2538.3  7353.4  7408.3   101.13983
      800  349.11  2856.9  7546.8  7634.0   101.86025
      801  349.32  2959.7  7619.3  7810.5   104.10513
      802  349.53  2349.0  7086.8  7192.1   102.22185
      803  349.74  2666.9  7434.5  7404.6    99.37286
      804  349.95  2514.9  7301.4  7455.0   103.20898
      805  350.16  3003.6  7692.2  7802.4   102.34995
      806  350.37  2325.3  7289.9  7208.0    98.34997
      807  350.58  2503.8  7535.7  7455.4    98.40455
      808  350.79  2914.7  7761.4  7914.6   103.16065
      809  351.01  2953.2  7796.2  7919.9   102.55414
      810  351.22  2538.7  7593.5  7479.6    97.74733
      811  351.43  2465.3  7467.3  7423.9    99.13200
      812  351.64  2894.6  7882.6  7944.5   101.23993
      813  351.85  2890.1  7843.7  7919.9   101.53796
      814  352.06  2483.4  7551.7  7640.2   101.74559
      815  352.27  2480.9  7611.1  7641.0   100.58283
      816  352.48  2682.4  7812.6  7941.2   102.50700
      817  352.69  3048.6  8102.2  8155.8   101.06176
      818  352.90  2587.0  7665.5  7660.2    99.89515
      819  353.12  2618.9  7759.3  7822.0   101.21913
      820  353.33  2873.3  8003.5  8017.0   100.26346
      821  353.54  2736.5  7862.6  7987.5   102.43707
      822  353.75  2503.0  7857.6  7736.8    97.74344
      823  353.96  2452.6  7819.6  7756.5    98.82470
      824  354.17  2730.4  8051.8  8087.8   100.67734
      825  354.38  2899.1  8322.1  8382.7   101.11783
      826  354.59  2549.3  7927.7  7878.5    99.08614
      827  354.80  2505.9  7984.6  7961.3    99.57386
      828  355.01  2666.9  8122.2  8100.9    99.60958
      829  355.22  2787.3  8252.9  8240.2    99.76769
      830  355.43  2396.1  8102.6  7980.9    97.86821
      831  355.64  2605.4  8290.6  8057.1    95.89338
      832  355.86  2978.2  8468.8  8526.5   101.05185
      833  356.07  3035.1  8573.2  8664.5   101.64928
      834  356.28  2453.1  8332.0  8217.7    98.05615
      835  356.49  2330.6  8017.0  7864.2    97.31327
      836  356.70  2784.4  8484.3  8508.9   100.43116
      837  356.91  3229.6  8875.9  8995.9   102.12550
      838  357.12  2507.5  8560.5  8437.6    97.96996
      839  357.33  2528.0  8367.6  8372.9   100.09117
      840  357.54  2851.6  8778.0  8948.0   102.86819
      841  357.75  2829.9  8767.8  8761.2    99.88962
      842  357.96  2370.7  8396.3  8302.9    98.45015
      843  358.17  2503.4  8507.7  8483.5    99.59752
      844  358.38  2666.5  8794.4  8850.9   100.92240
      845  358.59  2906.9  8864.4  9024.6   102.68821
      846  358.80  2389.2  8691.6  8589.6    98.38176
      847  359.02  2573.5  8653.1  8644.1    99.85177
      848  359.23  2570.2  8818.6  8768.2    99.19371
      849  359.44  3006.4  9140.1  9200.3   100.98163
      850  359.65  2260.1  8744.4  8705.1    99.39359
      851  359.86  2538.7  9124.5  9077.4    99.28479
      852  360.07  2728.3  9118.8  9200.3   101.27547
      853  360.28  2532.9  8886.5  9004.5   101.85663
      854  360.49  2412.5  9099.9  8987.3    98.31568
      855  360.70  2544.0  9168.3  9102.0    98.99832
      856  360.91  2564.5  9278.9  9370.7   101.36644
      857  361.12  2880.7  9336.3  9288.8    99.26400
      858  361.33  2504.7  9235.9  9213.4    99.66534
      859  361.54  2504.7  9291.2  9215.0    98.87741
      860  361.75  2952.8  9678.3  9683.2   100.07308
      861  361.96  2706.2  9591.9  9605.8   100.20226
      862  362.17  2597.6  9627.5  9528.4    98.58999
      863  362.38  2483.8  9525.5  9336.7    97.31853
      864  362.59  2963.8 10137.0 10126.0    99.84583
      865  362.80  3069.9  9813.5  9917.1   101.53668
      866  363.01  2393.7  9561.1  9412.9    97.93131
      867  363.22  2501.8  9611.5  9484.6    98.21408
      868  363.43  2590.3  9522.6  9535.8   100.18907
      869  363.64  3001.5 10092.8 10092.0    99.98844
      870  363.85  2387.1  9540.3  9372.7    97.65804
      871  364.06  2496.9  9863.4  9753.2    98.50431
      872  364.27  2661.5 10049.8 10075.6   100.34927
      873  364.48  2867.2 10227.1 10126.0    98.62542
      874  364.69  2313.0  9803.6  9645.5    97.88933
      875  364.90  2506.3  9772.5  9598.0    97.59865
      876  365.11  2763.1 10156.7 10212.8   100.75897
      877  365.33  2907.7 10275.5 10307.8   100.43918
      878  365.54  2412.5  9941.7  9757.3    97.55194
      879  365.75  2674.2 10240.3 10123.5    98.45713
      880  365.96  2992.9 10309.1 10298.0    99.84884
      881  366.17  2761.9 10294.7 10205.0    98.80920
      882  366.38  2457.2 10080.9  9901.5    97.64681
      883  366.59  2584.5 10137.4 10017.8    98.41649
      884  366.80  2608.3 10062.1  9988.8    99.01638
      885  367.01  3046.6 10875.1 10851.4    99.69653
      886  367.22  2355.2  9728.7  9622.2    98.55571
      887  367.43  2474.8 10176.4  9956.4    97.14407
      888  367.64  2788.5 10477.0 10364.4    98.53496
      889  367.85  2897.9 10523.7 10393.0    98.28661
      890  368.06  2350.2 10042.0  9875.3    97.83268
      891  368.27  2444.9 10157.9 10025.2    98.27944
      892  368.48  3076.9 10805.9 10876.8   100.91680
      893  368.69  2562.4 10151.0  9931.0    97.10153
      894  368.90  2502.6 10350.8 10027.3    95.87704
      895  369.11  2419.5 10294.7 10073.1    97.18625
      896  369.32  2970.4 10796.9 10690.4    98.63932
      897  369.53  2830.3 10454.5 10421.3    99.56484
      898  369.74  2446.9 10256.6  9953.1    96.11370
      899  369.94  2490.7 10275.1  9947.4    95.79058
      900  370.15  2717.2 10542.9 10341.0    97.41966
      901  370.36  2976.9 10912.8 10760.4    98.08000
      902  370.57  2443.6 10161.6  9881.4    96.37001
      903  370.78  2550.5 10446.3 10306.2    98.22587
      904  370.99  2760.3 10686.3 10445.5    96.96140
      905  371.20  3043.7 10899.7 10874.3    99.67674
      906  371.41  2499.3 10518.4 10254.2    96.70549
      907  371.62  2613.2 10624.0 10382.4    96.98332
      908  371.83  2731.6 10713.3 10468.8    96.93642
      909  372.04  2719.7 10649.0 10399.2    96.84901
      910  372.25  2432.6 10494.2 10223.9    96.64669
      911  372.46  2560.4 10724.8 10430.3    96.39292
      912  372.67  2759.8 10728.5 10599.9    98.38602
      913  372.88  3131.8 11122.5 10962.8    98.00093
      914  373.09  2347.8 10486.0 10237.4    96.94498
      915  373.30  2514.5 10627.7 10311.9    96.10763
      916  373.51  2807.4 10708.8 10545.8    97.93685
      917  373.72  2908.9 11076.6 10900.9    97.84865
      918  373.93  2508.8 10907.5 10619.1    96.56669
      919  374.14  2398.2 10663.8 10464.3    97.58672
      920  374.35  2841.4 11047.6 10949.3    98.80209
      921  374.56  3146.5 11362.5 11129.5    97.16337
      922  374.77  2600.1 11059.4 10803.9    96.97864
      923  374.98  2285.9 10769.4 10510.6    96.94863
      924  375.19  3035.5 11252.0 11219.6    99.60618
      925  375.40  2954.0 11326.9 11242.5    98.99226
      926  375.61  2376.1 11014.8 10719.1    96.57674
      927  375.82  2617.3 11259.3 10945.6    96.36949
      928  376.03  2790.6 11184.0 11105.3    99.06305
      929  376.23  2897.5 11298.6 11152.0    98.25459
      930  376.44  2419.5 11139.7 10928.8    97.58102
      931  376.65  2518.2 10967.7 10762.1    97.56653
      932  376.86  2653.3 11113.9 11146.3   100.38246
      933  377.07  2992.5 11512.5 11501.4    99.87020
      934  377.28  2573.9 11347.0 11110.6    97.30613
      935  377.49  2423.2 11161.0 11000.5    98.16247
      936  377.70  3113.3 11610.8 11553.0    99.32035
      937  377.91  2804.1 11385.9 11345.7    99.53227
      938  378.12  2362.9 11211.0 11033.6    97.99555
      939  378.33  2404.3 11289.2 11213.9    99.15176
      940  378.54  2591.5 11252.4 11293.3   100.47292
      941  378.75  3124.4 11746.3 11744.3    99.97625
      942  378.96  2428.1 11209.4 11155.3    99.38430
      943  379.17  2422.7 11333.5 11131.1    97.72926
      944  379.37  2788.1 11702.1 11646.0    99.37050
      945  379.58  2684.5 11511.2 11446.5    99.26682
      946  379.79  2312.6 11333.5 11131.5    97.76153
      947  380.00  2426.0 11367.5 11177.0    97.86990
      948  380.21  2624.3 11619.8 11557.9    99.31244
      949  380.42  2929.8 11777.5 11783.2   100.06481
      950  380.63  2426.8 11621.4 11318.3    96.70350
      951  380.84  2409.6 11654.2 11476.4    98.07709
      952  381.05  2783.6 11938.4 11831.5    98.83227
      953  381.26  3039.6 12005.2 11990.4    99.83553
      954  381.47  2515.3 11587.0 11396.1    97.89597
      955  381.68  2600.9 11966.3 11751.7    97.70829
      956  381.89  2963.0 12113.7 12176.4   100.68484
      957  382.09  2827.0 11681.2 11566.9    98.70936
      958  382.30  2693.9 11981.8 11798.8    98.02876
      959  382.51  2596.4 11811.5 11726.3    99.07547
      960  382.72  2998.6 12251.8 12187.1    99.30060
      961  382.93  2702.1 11956.9 11873.3    99.09715
      962  383.14  2380.1 11686.5 11575.5    98.80727
      963  383.35  2518.2 12187.1 11879.9    96.82284
      964  383.56  2809.0 12115.4 12043.7    99.22979
      965  383.77  2817.6 12357.4 12344.7    99.86691
      966  383.98  2444.0 12019.1 11878.2    98.52847
      967  384.18  2557.9 12239.9 12108.8    98.64625
      968  384.39  2959.3 12435.3 12450.4   100.15993
      969  384.60  2920.8 12464.3 12618.4   101.61374
      970  384.81  2371.5 11965.9 11775.8    98.01912
      971  385.02  2412.5 11864.7 11745.1    98.73467
      972  385.23  2694.7 12164.1 12097.8    99.29928
      973  385.44  2754.9 12516.4 12427.5    99.08946
      974  385.65  2362.1 12344.7 12087.1    97.41917
      975  385.86  2537.0 12012.2 11915.1    98.97549
      976  386.06  2684.1 12726.1 12628.6    99.02925
      977  386.27  3125.6 12663.0 12659.7    99.96565
      978  386.48  2524.3 12330.8 12169.4    98.35436
      979  386.69  2608.3 12235.8 12110.9    98.70240
      980  386.90  2650.9 12224.3 12024.0    97.90785
      981  387.11  2728.7 12747.4 12586.0    98.38921
      982  387.32  2465.3 12338.2 12039.2    96.97145
      983  387.53  2452.2 12503.7 12185.0    96.82967
      984  387.73  2710.7 12625.7 12490.2    98.63263
      985  387.94  3078.9 12913.3 12808.8    98.93795
      986  388.15  2573.1 12560.2 12300.5    97.39983
      987  388.36  2501.8 12430.8 12201.8    97.69399
      988  388.57  3107.2 13010.3 12894.0    98.82537
      989  388.78  2976.5 12891.1 12720.3    98.27729
      990  388.99  2573.1 12718.7 12427.9    97.13363
      991  389.20  2381.4 12228.8 12004.0    97.71650
      992  389.40  3677.3 13350.3 13286.4    99.33943
      993  389.61  2713.6 12804.3 12500.0    96.98409
      994  389.82  2485.0 12538.9 12192.4    96.55341
      995  390.03  2338.4 12620.8 12362.8    97.49044
      996  390.24  2944.6 13060.7 12912.4    98.53429
      997  390.45  2818.8 12658.9 12500.8    98.39328
      998  390.66  2528.4 12854.7 12668.7    98.19920
      999  390.86  2422.3 12531.5 12353.8    98.24156
      1000 391.07  2613.2 12676.5 12506.9    98.31495
      1001 391.28  2581.3 12916.1 12725.3    98.15315
      1002 391.49  2308.9 12661.8 12362.4    97.10793
      1003 391.70  2415.8 12794.5 12522.5    97.37954
      1004 391.91  2578.4 12868.2 12654.4    97.92214
      1005 392.12  3229.6 13327.8 13255.7    99.28612
      1006 392.32  2380.1 12634.7 12396.8    97.67934
      1007 392.53  2440.4 13057.0 12799.8    97.57716
      1008 392.74  2835.2 13235.6 13065.6    98.36563
      1009 392.95  2918.8 13316.7 13287.6    99.72032
      1010 393.16  2408.8 12880.9 12622.5    97.53198
      1011 393.37  2471.1 12820.7 12565.9    97.53839
      1012 393.57  2872.1 13067.7 13068.9   100.01205
      1013 393.78  2547.3 13176.2 13000.5    98.34683
      1014 393.99  2563.6 13414.2 13356.9    99.47152
      1015 394.20  2491.1 13173.4 12874.4    97.20092
      1016 394.41  2904.0 13578.0 13512.5    99.38603
      1017 394.62  2781.1 13343.7 13184.4    98.49155
      1018 394.82  2456.7 13514.5 13352.3    98.53317
      1019 395.03  2423.2 13354.8 13124.2    97.89052
      1020 395.24  2816.0 13605.1 13466.6    98.71683
      1021 395.45  2796.3 13275.8 13268.8    99.93356
      1022 395.66  2429.7 13296.6 13101.7    98.20587
      1023 395.87  2503.0 13261.8 12991.1    97.48354
      1024 396.07  3068.7 13481.0 13494.1   100.12588
      1025 396.28  2895.4 13494.5 13543.2   100.45986
      1026 396.49  2485.8 13966.3 13679.2    97.49901
      1027 396.70  2403.9 13353.2 13115.2    97.82657
      1028 396.91  2676.7 13539.5 13409.3    98.80095
      1029 397.11  2834.4 13856.6 13731.6    98.86658
      1030 397.32  2312.6 13084.1 12771.1    97.09483
      1031 397.53  2327.7 13501.0 13214.3    97.43393
      1032 397.74  2669.7 13785.3 13640.7    98.69925
      1033 397.95  2819.2 13639.1 13657.9   100.17414
      1034 398.16  2462.9 13240.1 13032.9    98.07693
      1035 398.36  2691.4 13782.0 13579.7    98.17558
      1036 398.57  2773.8 13863.5 13798.4    99.41274
      1037 398.78  2732.4 13746.8 13587.5    98.55342
      1038 398.99  2603.0 13575.2 13472.8    99.06674
      1039 399.20  2335.9 13523.6 13379.0    98.70762
      1040 399.40  2539.5 13082.8 13090.6   100.07381
      1041 399.61  3006.8 14085.5 14115.0   100.26620
      1042 399.82  2434.6 13508.4 13391.3    98.94215
      1043 400.03  2415.0 13569.4 13448.2    98.91309
      1044 400.24  3015.4 13876.2 13901.6   100.23382
      1045 400.44  2589.0 13635.0 13597.7    99.66256
      1046 400.65  2503.4 13578.0 13395.4    98.35047
      1047 400.86  2500.2 13757.0 13533.0    98.00969
      1048 401.07  2636.6 13958.5 14026.1   100.59692
      1049 401.27  2907.7 14085.5 14115.8   100.27116
      1050 401.48  2496.1 13680.0 13647.7    99.71067
      1051 401.69  2392.0 13449.0 13392.1    99.48509
      1052 401.90  2972.8 14426.3 14510.3   100.73311
      1053 402.11  2732.0 13943.8 14050.7   100.95349
      1054 402.31  2443.2 13972.5 13879.1    99.18999
      1055 402.52  2490.7 13940.9 13839.8    99.11643
      1056 402.73  2557.9 13883.6 13795.9    99.22607
      1057 402.94  2591.9 13894.6 13983.9   100.78999
      1058 403.15  2540.7 13818.5 13748.8    99.38258
      1059 403.35  2319.9 13724.7 13684.9    99.65164
      1060 403.56  3103.9 14429.2 14532.8   100.91501
      1061 403.77  2698.8 14088.8 14257.1   101.47799
      1062 403.98  2531.3 13989.7 13954.9    99.69615
      1063 404.18  2385.5 13876.6 13741.5    98.82374
      1064 404.39  2819.2 14367.3 14400.1   100.28374
      1065 404.60  2746.7 14254.3 14253.9    99.99644
      1066 404.81  2541.5 14229.3 14168.7    99.48134
      1067 405.01  2319.9 14228.5 14111.7    99.01974
      1068 405.22  2593.1 14565.2 14552.0    99.89052
      1069 405.43  2955.2 14714.7 14697.5    99.85372
      1070 405.64  2483.8 14677.8 14403.0    97.74613
      1071 405.85  2521.5 14430.4 14449.6   100.16165
      1072 406.05  3154.7 14856.4 14939.9   100.71406
      1073 406.26  2971.6 14805.6 14670.8    98.86128
      1074 406.47  2659.5 14713.0 14556.6    98.70191
      1075 406.68  2505.5 14705.2 14528.7    98.55296
      1076 406.88  3143.2 15605.9 15406.5    98.39945
      1077 407.09  2751.2 14843.7 14850.2   100.05419
      1078 407.30  2355.6 14357.9 14251.8    99.11614
      1079 407.51  2324.4 14311.2 14183.0    98.93046
      1080 407.71  2956.4 15559.2 15449.5    99.12899
      1081 407.92  2615.7 14262.5 14254.3    99.92966
      1082 408.13  2271.2 14530.7 14427.5    99.15806
      1083 408.34  2429.3 14783.5 14591.0    98.44175
      1084 408.54  2495.7 14748.7 14772.0   100.19054
      1085 408.75  2518.2 14625.4 14532.0    99.22866
      1086 408.96  2488.7 15569.9 15376.6    98.52209
      1087 409.16  2566.9 15093.5 14906.3    98.50570
      1088 409.37  2750.4 15156.6 15066.9    99.27697
      1089 409.58  3040.0 15313.5 15236.1    99.36926
      1090 409.79  2539.1 15331.5 15054.2    97.83235
      1091 409.99  2477.6 15238.1 14920.3    97.50915
      1092 410.20  3036.7 15613.3 15527.3    99.31607
      1093 410.41  2682.4 14832.2 14735.1    99.20102
      1094 410.62  2474.8 14668.4 14474.2    98.40780
      1095 410.82  2432.6 15139.0 14883.4    97.98852
      1096 411.03  3019.9 15728.4 15700.5    99.78084
      1097 411.24  2645.6 15373.3 15121.4    98.02085
      1098 411.45  2463.3 15136.1 14882.2    97.99612
      1099 411.65  2519.8 15065.3 14851.9    98.29899
      1100 411.86  2787.3 15317.2 15113.2    98.37207
      1101 412.07  2629.6 15484.3 15251.6    98.19016
      1102 412.27  2587.8 15353.2 14974.7    97.03523
      1103 412.48  2497.3 15310.2 14925.2    96.99508
      1104 412.69  2795.5 15311.8 15134.9    98.58630
      1105 412.90  3017.9 16061.8 15978.3    99.35942
      1106 413.10  2523.1 15159.1 14936.2    98.23663
      1107 413.31  2482.5 15336.4 15082.5    98.02435
      1108 413.52  2780.3 15528.9 15448.2    99.36707
      1109 413.72  2481.3 15144.3 14996.5    98.83232
      1110 413.93  2295.0 15424.9 15053.0    97.16746
      1111 414.14  2329.8 15017.3 14741.7    97.82735
      1112 414.35  2864.7 15512.5 15229.1    97.75899
      1113 414.55  2858.6 15820.6 15730.0    99.30164
      1114 414.76  2476.8 15343.8 14955.9    96.98542
      1115 414.97  2404.3 15508.9 15284.8    98.29030
      1116 415.17  2701.3 15527.7 15302.4    98.24365
      1117 415.38  2984.3 15600.6 15530.2    99.44160
      1118 415.59  2455.5 15161.1 15009.6    98.80722
      1119 415.79  2372.8 15533.0 15128.8    96.92810
      1120 416.00  3091.2 16035.2 15866.4    98.69628
      1121 416.21  3073.2 16064.7 15869.3    98.49612
      1122 416.41  2353.9 15495.8 15213.5    97.85258
      1123 416.62  2347.4 14927.6 14749.5    98.58371
      1124 416.83  3068.7 16210.1 16024.1    98.58497
      1125 417.04  3064.6 16056.1 15966.4    99.30954
      1126 417.24  2444.0 15571.9 15394.2    98.64591
      1127 417.45  2557.9 15404.8 15214.0    98.51427
      1128 417.66  2905.2 15784.1 15570.7    98.34303
      1129 417.86  2660.7 15918.9 15781.6    98.96506
      1130 418.07  2405.1 15358.5 15190.6    98.70355
      1131 418.28  2477.2 15748.1 15506.4    98.17901
      1132 418.48  3149.4 16220.7 16145.8    99.42656
      1133 418.69  2734.4 15889.8 15689.1    98.47438
      1134 418.90  2580.0 15971.3 15797.6    98.70312
      1135 419.10  2457.6 15765.3 15550.2    98.38412
      1136 419.31  2734.4 15995.0 15902.1    99.29884
      1137 419.52  2559.1 16047.1 16029.0    99.86638
      1138 419.72  2493.6 15737.4 15680.1    99.56702
      1139 419.93  2383.4 15906.2 15705.5    98.51583
      1140 420.14  2962.2 16403.8 16304.7    99.26257
      1141 420.34  3013.0 16154.4 16088.8    99.50132
      1142 420.55  2468.6 15557.6 15494.1    99.51496
      1143 420.76  2616.9 16199.0 15994.2    98.49216
      1144 420.96  2603.0 15828.8 15884.0   100.41809
      1145 421.17  2789.3 15992.6 15981.1    99.91314
      1146 421.38  2500.2 15777.6 15585.0    98.55010
      1147 421.58  2514.1 15990.1 15771.8    98.37999
      1148 421.79  2978.6 16325.2 16126.1    98.50852
      1149 422.00  2795.9 16263.3 16354.3   100.67518
      1150 422.20  2460.4 15632.1 15466.7    98.74371
      1151 422.41  2354.8 15771.8 15510.1    98.04928
      1152 422.62  2571.8 15931.1 15760.8    98.72455
      1153 422.82  3000.3 16212.9 16094.2    99.10100
      1154 423.03  2616.5 15753.8 15675.2    99.40138
      1155 423.24  2578.0 16138.4 15928.3    98.45048
      1156 423.44  2512.4 15719.0 15577.7    98.93001
      1157 423.65  2791.8 15724.7 15676.0    99.62312
      1158 423.85  2359.7 15850.0 15585.5    98.03862
      1159 424.06  2588.2 15929.9 15725.5    98.46806
      1160 424.27  2987.2 16381.7 16126.5    98.09492
      1161 424.47  2875.8 16200.3 16096.6    99.22228
      1162 424.68  2949.1 16343.2 16206.0    98.97557
      1163 424.89  2696.8 16337.9 16086.0    98.15337
      1164 425.09  3023.2 16232.6 16037.2    98.52093
      1165 425.30  2878.6 16013.5 15798.4    98.36286
      1166 425.51  2463.7 15899.2 15665.7    98.26230
      1167 425.71  2539.1 15886.1 15725.5    98.79703
      1168 425.92  2844.6 16045.4 15841.0    98.45170
      1169 426.12  3198.1 16794.6 16681.1    99.16553
      1170 426.33  2394.9 15945.5 15684.2    98.07152
      1171 426.54  2360.1 15535.1 15136.5    96.97506
      1172 426.74  2917.1 16148.6 16009.0    98.94441
      1173 426.95  2734.0 16378.8 16151.1    98.33098
      1174 427.16  2357.6 15473.2 15173.4    97.71400
      1175 427.36  2343.7 16867.5 16515.2    97.57467
      1176 427.57  2846.3 16180.2 16004.5    98.68219
      1177 427.77  2970.8 16842.5 16631.6    98.47934
      1178 427.98  2625.1 16206.8 16003.6    98.50418
      1179 428.19  2491.6 16643.0 16213.8    96.96672
      1180 428.39  2684.9 16379.7 16358.4    99.84447
      1181 428.60  2917.1 16655.7 16483.7    98.74784
      1182 428.81  2423.6 16588.1 16267.8    97.73871
      1183 429.01  2449.8 15896.3 15778.0    99.11969
      1184 429.22  2902.4 16520.1 16620.1   100.73390
      1185 429.42  2724.2 16259.6 16082.7    98.69274
      1186 429.63  2687.8 16474.3 16486.1   100.08616
      1187 429.84  2631.6 16516.5 16325.6    98.62533
      1188 430.04  2553.4 16932.6 17027.2   100.65801
      1189 430.25  3081.8 16960.0 16884.3    99.45401
      1190 430.45  2446.5 16143.7 16009.4    99.01917
      1191 430.66  2357.6 17080.9 16939.2    99.03744
      1192 430.87  2576.8 16201.5 16188.8    99.90680
      1193 431.07  2716.4 16386.2 16366.1    99.85317
      1194 431.28  2478.5 16643.8 16541.4    99.27713
      1195 431.48  2331.0 16543.5 16479.6    99.55042
      1196 431.69  2737.7 16900.7 16826.5    99.47655
      1197 431.90  2707.8 16417.7 16330.5    99.36365
      1198 432.10  2594.8 17389.7 17336.5    99.64010
      1199 432.31  2388.3 16595.1 16485.3    99.22733
      1200 432.51  2704.5 17062.9 16972.3    99.36956
      1201 432.72  2952.4 17090.3 16867.5    98.42396
      1202 432.92  2382.2 17128.0 16981.8    99.00836
      1203 433.13  2503.8 16720.4 16526.7    98.63724
      1204 433.34  2915.9 16926.1 16821.2    99.25157
      1205 433.54  2878.2 17246.4 17171.0    99.47547
      1206 433.75  2485.8 16975.6 16681.9    97.97320
      1207 433.95  2615.7 16758.9 16550.0    98.52302
      1208 434.16  2997.0 17579.8 17581.8   100.01404
      1209 434.37  2642.3 16910.9 16699.5    98.51878
      1210 434.57  2559.6 17102.2 16735.6    97.47923
      1211 434.78  2566.5 17142.3 16959.6    98.74670
      1212 434.98  2623.4 17456.9 17348.3    99.26825
      1213 435.19  2781.1 17236.5 17267.2   100.21252
      1214 435.39  2453.9 17821.8 17660.9    98.95255
      1215 435.60  2514.5 17213.6 17004.7    98.57887
      1216 435.81  3017.5 17778.8 17803.8   100.16927
      1217 436.01  2553.0 17384.4 17263.6    99.18530
      1218 436.22  2483.0 16810.5 16724.5    99.39965
      1219 436.42  2525.6 17404.5 17096.4    97.92985
      1220 436.63  2704.5 18334.2 18109.0    98.55867
      1221 436.83  2958.5 18195.8 18127.8    99.55377
      1222 437.04  2548.1 17814.1 17549.5    98.26675
      1223 437.24  2508.8 17651.9 17519.6    99.12634
      1224 437.45  2721.3 17948.0 17772.7    98.84868
      1225 437.66  2806.1 17577.3 17419.2    98.92965
      1226 437.86  2450.2 17185.7 17008.8    98.79920
      1227 438.07  2374.4 17968.1 17661.7    98.03525
      1228 438.27  2753.3 17815.7 17662.9    98.98569
      1229 438.48  2876.2 17722.3 17422.1    97.97771
      1230 438.68  2580.8 17633.0 17301.2    97.79586
      1231 438.89  2482.5 17984.0 17830.8    99.01178
      1232 439.09  2930.2 18048.3 17848.0    98.67516
      1233 439.30  2689.0 18192.5 17959.5    98.49674
      1234 439.50  2516.5 17078.8 16859.3    98.49239
      1235 439.71  2457.2 18013.5 17714.9    98.08057
      1236 439.92  2811.9 17840.7 17535.5    97.96959
      1237 440.12  2675.5 17855.0 17720.3    99.11225
      1238 440.33  2382.2 17334.8 17177.1    98.94538
      1239 440.53  2572.2 18203.2 17820.2    97.54992
      1240 440.74  2580.0 17964.4 17776.4    98.77796
      1241 440.94  2960.1 17825.9 17966.0   100.94230
      1242 441.15  2673.8 17594.5 17440.5    98.96783
      1243 441.35  2403.1 17710.4 17455.2    98.33298
      1244 441.56  2871.3 17899.2 17847.2    99.65385
      1245 441.76  2805.7 18011.1 17969.7    99.72793
      1246 441.97  2399.8 17661.3 17590.0    99.53301
      1247 442.17  2466.6 18180.2 18267.9   100.55781
      1248 442.38  2832.3 17518.3 17576.1   100.39325
      1249 442.58  2909.8 17850.1 17999.6   101.00065
      1250 442.79  2438.7 17136.6 17154.2   100.11983
      1251 443.00  2464.9 17499.9 17484.7    99.89920
      1252 443.20  2760.7 18110.2 18103.6    99.95730
      1253 443.41  2816.0 17335.2 17615.4   101.92959
      1254 443.61  2409.6 17181.2 17226.7   100.30779
      1255 443.82  2565.3 17538.4 17494.2    99.70456
      1256 444.02  2705.4 17343.8 17553.1   101.42981
      1257 444.23  2458.8 17489.2 17671.9   101.21539
      1258 444.43  2560.4 17284.4 17296.7   100.08345
      1259 444.64  2641.5 17231.2 17319.3   100.60360
      1260 444.84  2955.6 17632.2 17850.5   101.48749
      1261 445.05  2609.5 17220.1 17316.0   100.65600
      1262 445.25  2542.8 17293.9 17419.2   100.84967
      1263 445.46  2447.3 17603.5 17711.7   100.71346
      1264 445.66  2634.5 16967.0 17191.5   101.56607
      1265 445.87  2686.5 17026.8 17140.7   100.79404
      1266 446.07  2426.8 17018.6 16968.7    99.65755
      1267 446.28  2510.4 17304.1 17264.0    99.72867
      1268 446.48  2842.2 17687.9 17936.5   101.67472
      1269 446.69  2607.1 17092.8 17210.3   100.81151
      1270 446.89  2521.1 17247.6 17318.0   100.47839
      1271 447.10  2519.4 17422.1 17486.4   100.43151
      1272 447.30  2989.2 17711.2 17972.2   101.77226
      1273 447.51  2838.5 17565.8 17789.9   101.52130
      1274 447.71  2634.5 18087.2 18220.4   100.86145
      1275 447.92  2448.1 17659.2 17890.2   101.51870
      1276 448.12  2732.4 18252.7 18449.3   101.26676
      1277 448.33  2814.3 17789.1 18046.7   101.72046
      1278 448.53  2422.3 17574.8 17748.9   101.14883
      1279 448.73  2603.8 18041.4 18172.9   100.85168
      1280 448.94  3224.3 19020.7 19246.0   101.42612
      1281 449.14  2691.0 18478.4 18604.2   100.79650
      1282 449.35  2549.3 18388.7 18621.8   101.47139
      1283 449.55  2457.6 18257.6 18391.2   100.84511
      1284 449.76  2971.2 18567.7 18873.7   101.96176
      1285 449.96  2927.8 18935.1 19283.7   102.17753
      1286 450.17  2514.1 18533.7 18593.1   100.37074
      1287 450.37  2481.7 18987.9 19054.7   100.40448
      1288 450.58  3176.4 18927.7 19337.3   102.60038
      1289 450.78  2652.9 18938.8 19083.8   100.89032
      1290 450.99  2367.0 18757.8 18851.1   100.56976
      1291 451.19  2671.0 18792.2 19095.7   101.88267
      1292 451.40  2705.4 18839.7 19078.5   101.48003
      1293 451.60  2678.7 18978.5 19189.1   101.29162
      1294 451.81  2381.8 19169.0 19237.4   100.40747
      1295 452.01  2443.6 18693.4 18847.9   100.95027
      1296 452.21  2933.1 18763.1 18779.1   100.10091
      1297 452.42  2772.5 18691.8 18826.6   100.84650
      1298 452.62  2394.5 17952.9 18108.5   101.00039
      1299 452.83  2486.2 18327.7 18508.7   101.14282
      1300 453.03  2960.5 18593.9 18736.9   100.91438
      1301 453.24  2897.1 18410.4 18581.6   101.10363
      1302 453.44  2645.2 18258.1 18466.9   101.33795
      1303 453.65  2442.8 18121.7 18171.6   100.31872
      1304 453.85  3274.3 18667.2 18774.5   100.69716
      1305 454.06  2915.9 18010.7 18198.2   101.24278
      1306 454.26  2489.9 18173.3 18210.5   100.23766
      1307 454.46  2632.9 18180.2 18204.4   100.15543
      1308 454.67  2989.2 17967.2 18262.6   101.97168
      1309 454.87  2795.5 18260.5 18479.2   101.41431
      1310 455.08  2640.2 18156.9 18373.1   101.39377
      1311 455.28  2594.0 17466.7 17625.2   101.06579
      1312 455.49  2796.7 18656.2 18921.2   101.67097
      1313 455.69  3198.9 18222.0 18420.7   101.32232
      1314 455.89  2585.8 17891.9 18033.2   100.92323
      1315 456.10  2365.8 17623.6 17775.5   100.99595
      1316 456.30  3246.4 18595.1 18750.0   101.00872
      1317 456.51  2843.0 18190.9 18448.5   101.67863
      1318 456.71  2444.9 17921.4 18154.4   101.50589
      1319 456.92  2511.2 17978.7 18247.4   101.73715
      1320 457.12  2947.4 18751.6 19044.9   101.85565
      1321 457.32  2694.7 18004.5 18453.0   102.92954
      1322 457.53  2704.5 18207.7 18553.8   102.23250
      1323 457.73  2528.4 18417.4 18621.4   101.28377
      1324 457.94  3032.6 18833.9 19335.3   103.17279
      1325 458.14  2642.3 18346.1 18634.1   101.83359
      1326 458.35  2372.8 18212.2 18600.9   102.45404
      1327 458.55  2456.3 17889.4 18152.0   101.70121
      1328 458.75  3039.6 18674.6 19126.0   102.88693
      1329 458.96  3021.2 18949.9 19266.5   101.98771
      1330 459.16  2247.0 18353.1 18716.4   102.25573
      1331 459.37  2531.7 18723.8 19171.9   102.76738
      1332 459.57  2553.8 18502.6 18838.9   102.10848
      1333 459.77  2933.9 18552.5 19123.1   103.65310
      1334 459.98  2488.3 18362.1 18873.7   103.22281
      1335 460.18  2538.7 18815.9 19215.7   102.45596
      1336 460.39  2971.2 19011.3 19491.3   102.99277
      1337 460.59  2639.8 18860.6 19465.5   103.72961
      1338 460.79  2310.5 19176.0 19517.6   102.02545
      1339 461.00  2466.2 18634.9 19029.7   102.44206
      1340 461.20  2835.2 19325.0 19877.2   103.34832
      1341 461.41  2995.8 19493.4 20118.8   103.79115
      1342 461.61  2439.5 19352.9 19650.7   101.76059
      1343 461.81  2582.9 19207.9 19786.7   103.48124
      1344 462.02  2815.5 19413.5 20141.8   104.38763
      1345 462.22  3022.8 20275.3 20830.7   103.21930
      1346 462.43  2478.9 19968.9 20397.4   102.44959
      1347 462.63  2394.5 19482.7 19724.0   101.41179
      1348 462.83  3067.4 20252.8 20841.8   103.42731
      1349 463.04  2915.1 20204.0 20694.7   102.83819
      1350 463.24  2466.6 20453.9 20784.4   101.83764
      1351 463.45  2422.7 20480.1 20838.5   101.98476
      1352 463.65  2673.8 20429.3 20990.9   103.16270
      1353 463.85  2928.2 20855.3 21401.7   103.04789
      1354 464.06  2330.2 20376.5 20684.5   101.70680
      1355 464.26  2752.5 20923.7 21198.9   101.51474
      1356 464.46  2719.3 21349.7 21845.3   102.66022
      1357 464.67  2980.2 21586.4 22035.3   102.41272
      1358 464.87  2497.7 21325.5 21728.1   102.13849
      1359 465.08  2477.6 21085.9 21422.6   101.80934
      1360 465.28  2833.2 22103.3 22410.1   101.59203
      1361 465.48  2743.5 22042.3 22492.4   102.33249
      1362 465.69  2419.9 21995.6 22394.1   102.03586
      1363 465.89  2501.4 21846.1 22123.8   101.43556
      1364 466.09  3171.1 23186.3 23685.2   102.49253
      1365 466.30  3028.1 22964.7 23418.5   102.27637
      1366 466.50  2431.3 22614.9 22712.4   100.48298
      1367 466.71  2453.5 23354.6 23482.0   100.60946
      1368 466.91  3035.9 23719.6 24243.9   102.53475
      1369 467.11  2998.6 24359.8 24721.8   101.69505
      1370 467.32  2571.0 23883.4 23973.1   100.42089
      1371 467.52  2497.7 23998.5 24032.1   100.15621
      1372 467.72  2659.5 24583.0 24987.3   101.84400
      1373 467.93  2648.4 24029.6 24274.6   101.14557
      1374 468.13  2577.2 24871.4 25090.5   100.98291
      1375 468.33  2340.8 24133.7 24421.2   101.31940
      1376 468.54  2797.5 25416.5 25768.0   101.55370
      1377 468.74  3250.9 24912.3 25383.8   102.17642
      1378 468.94  2623.0 24898.4 25160.1   101.17498
      1379 469.15  2546.9 24512.1 24777.6   101.20835
      1380 469.35  2634.5 24619.9 24919.7   101.36374
      1381 469.55  2735.3 24908.2 25320.3   101.85835
      1382 469.76  2499.3 24453.2 24857.4   101.84146
      1383 469.96  2519.0 24383.9 24858.7   102.17114
      1384 470.17  2964.6 24093.5 24633.0   102.55307
      1385 470.37  3093.7 24854.6 25351.8   102.28505
      1386 470.57  2499.3 24449.1 24801.7   101.60667
      1387 470.78  2476.4 24442.1 24770.2   101.49362
      1388 470.98  2964.6 25035.2 25677.0   102.90810
      1389 471.18  2988.0 24907.8 25642.6   103.35227
      1390 471.39  2508.8 24542.9 25120.8   102.62292
      1391 471.59  2729.5 24804.2 25374.7   102.58470
      1392 471.79  2693.9 24966.4 25670.1   103.15943
      1393 471.99  2546.0 24719.4 25382.5   102.99067
      1394 472.20  2487.5 24946.7 25428.8   102.14652
      1395 472.40  2467.4 24825.5 25472.6   102.89451
      1396 472.60  2606.2 24528.9 25185.5   102.99498
      1397 472.81  2801.6 25114.7 25884.3   103.44923
      1398 473.01  2555.5 25331.7 25934.7   102.64715
      1399 473.21  2506.3 25006.1 25519.7   102.28282
      1400 473.42  3197.7 25310.0 26216.0   104.09736
      1401 473.62  3061.3 25346.9 26048.9   103.15022
      1402 473.82  2538.3 25421.4 26002.7   102.53992
      1403 474.03  2859.4 24904.5 25511.5   102.75352
      1404 474.23  2667.3 25295.7 25896.6   102.65540
      1405 474.43  2992.5 25090.1 25732.7   102.90825
      1406 474.64  2329.4 24227.5 24740.3   102.34181
      1407 474.84  2578.4 24694.8 25208.0   102.32054
      1408 475.04  2807.8 24734.1 25389.9   102.99073
      1409 475.25  2868.0 24403.6 25182.2   103.61558
      1410 475.45  2358.0 24415.9 25012.7   102.70552
      1411 475.65  2503.0 23896.9 24581.8   103.20110
      1412 475.85  2550.1 24091.1 24846.0   103.50440
      1413 476.06  2929.0 24304.5 25098.7   103.71548
      1414 476.26  2618.9 23912.5 24470.0   102.61796
      1415 476.46  2484.6 23950.2 24565.0   102.86412
      1416 476.67  2783.6 23982.9 24694.0   103.35414
      1417 476.87  2888.5 24144.7 24886.5   103.48968
      1418 477.07  2396.5 24043.6 24536.3   102.27625
      1419 477.28  2492.8 23787.2 24336.8   102.58132
      1420 477.48  2929.8 24366.3 24938.1   102.66738
      1421 477.68  3049.4 24275.4 24849.6   102.70541
      1422 477.88  2256.0 23934.6 24538.8   102.78686
      1423 478.09  2512.9 24295.1 24841.5   102.50846
      1424 478.29  2757.4 24526.5 24977.8   102.07345
      1425 478.49  3048.2 25111.4 25991.6   103.98953
      1426 478.70  2419.9 24422.4 25016.3   102.69928
      1427 478.90  2570.2 24779.2 25494.8   103.22194
      1428 479.10  2677.1 25228.9 25724.9   102.19946
      1429 479.30  3026.5 25656.1 26319.3   102.93037
      1430 479.51  2438.3 25055.7 25596.3   102.39048
      1431 479.71  2358.4 25229.3 25804.0   102.51263
      1432 479.91  2897.5 26236.9 26797.3   102.40076
      1433 480.11  2952.4 26255.4 26880.4   102.68223
      1434 480.32  2600.1 26328.7 26590.0   101.10129
      1435 480.52  2580.4 26499.5 26986.9   102.03777
      1436 480.72  2760.7 26369.6 27045.9   102.86433
      1437 480.93  2652.5 26936.5 27356.4   101.72885
      1438 481.13  2257.7 26601.5 26958.2   101.46549
      1439 481.33  2416.6 27127.0 27651.7   102.12336
      1440 481.53  3040.0 27449.3 28122.3   102.75699
      1441 481.74  2840.9 27744.7 28152.2   101.63649
      1442 481.94  2365.8 27730.7 28026.0   101.16427
      1443 482.14  2515.7 27160.2 27412.5   101.02380
      1444 482.34  2757.0 27838.9 28359.0   102.07394
      1445 482.55  2838.5 28016.6 28230.4   100.84918
      1446 482.75  2606.2 27581.2 28001.1   101.68102
      1447 482.95  2443.6 27360.0 27564.0   100.81865
      1448 483.15  2848.3 27994.5 28378.7   101.52786
      1449 483.36  2505.9 27397.7 27693.5   101.18805
      1450 483.56  2673.4 28297.2 28435.2   100.53869
      1451 483.76  2405.5 27385.0 27510.8   100.50339
      1452 483.96  2804.5 27596.8 28136.2   102.17581
      1453 484.17  2919.6 27675.0 28130.1   101.83822
      1454 484.37  2476.8 27174.5 27505.4   101.34001
      1455 484.57  2528.4 27326.9 27709.4   101.54268
      1456 484.77  2779.5 27542.3 27938.8   101.60113
      1457 484.98  3101.4 27446.5 27903.2   101.87594
      1458 485.18  2492.8 26979.5 27360.5   101.55563
      1459 485.38  2546.0 26884.9 27246.2   101.48430
      1460 485.58  2757.8 27537.8 27883.5   101.39506
      1461 485.79  2997.4 26948.0 27276.9   101.37326
      1462 485.99  2288.4 26599.8 26785.4   100.76320
      1463 486.19  2573.9 26727.6 26837.8   100.45616
      1464 486.39  3096.9 27426.0 27861.0   101.78794
      1465 486.59  2547.7 26592.5 27000.8   101.69835
      1466 486.80  2578.4 26599.4 26858.3   101.07765
      1467 487.00  2488.7 26274.2 26410.6   100.57344
      1468 487.20  2927.4 26896.0 27242.5   101.44571
      1469 487.40  2802.8 26598.6 27090.1   102.06554
      1470 487.61  2518.2 26473.7 27047.1   102.39374
      1471 487.81  2394.5 26155.8 26472.5   101.33248
      1472 488.01  3018.7 26504.8 27013.9   102.16777
      1473 488.21  2813.5 26779.6 27318.7   102.24911
      1474 488.41  2577.6 26533.1 26893.9   101.50634
      1475 488.62  2565.3 26645.7 27026.6   101.58187
      1476 488.82  2680.4 26331.6 26914.4   102.46437
      1477 489.02  2711.1 26918.9 27509.1   102.43816
      1478 489.22  2486.2 26665.8 27102.4   101.80577
      1479 489.43  2504.3 26906.2 27355.9   101.84302
      1480 489.63  3026.1 27400.2 27968.3   102.33078
      1481 489.83  2634.9 27219.1 28021.5   103.26386
      1482 490.03  2431.3 27181.5 27849.9   102.70082
      1483 490.23  2360.5 27040.6 27677.5   102.58070
      1484 490.44  2570.6 27598.0 28335.3   102.94585
      1485 490.64  2886.4 27623.0 28404.5   103.15930
      1486 490.84  2520.2 27934.3 28625.3   102.71890
      1487 491.04  2557.9 27900.3 28877.2   103.85474
      1488 491.24  2776.6 28193.6 28952.1   102.98449
      1489 491.45  3096.9 28545.0 29489.5   103.71157
      1490 491.65  2697.2 28213.2 29080.7   103.39990
      1491 491.85  2507.5 28138.7 29154.9   103.96472
      1492 492.05  3374.6 29054.1 30244.4   104.63514
      1493 492.25  2915.5 28595.4 29749.2   104.49311
      1494 492.45  2612.4 28389.4 29573.9   104.59537
      1495 492.66  2439.9 28162.8 29088.9   103.60026
      1496 492.86  2697.2 28505.7 29619.8   104.31678
      1497 493.06  2910.6 28649.4 29920.0   104.93635
      1498 493.26  2688.2 28382.4 29256.9   103.40342
      1499 493.46  2536.2 28271.8 29249.1   103.79743
      1500 493.67  3340.6 28995.6 30050.3   104.11112
      1501 493.87  2577.2 27996.1 29112.3   104.39098
      1502 494.07  2666.0 27957.6 28993.5   104.09568
      1503 494.27  2440.8 27777.4 28433.6   102.58981
      1504 494.47  2661.5 27799.9 28713.8   103.63509
      1505 494.67  2902.0 27836.8 28796.5   103.84875
      1506 494.88  2505.5 27298.6 28025.6   102.93238
      1507 495.08  2488.7 27336.3 27999.0   102.66715
      1508 495.28  2773.8 27547.6 28423.3   103.53482
      1509 495.48  2789.3 27184.3 28203.0   104.17569
      1510 495.68  2434.2 26863.6 27798.3   103.82610
      1511 495.89  2451.8 26684.2 27532.1   103.49887
      1512 496.09  2543.2 26846.0 27758.6   103.75501
      1513 496.29  2818.4 26868.1 27816.3   103.94271
      1514 496.49  2614.0 26781.7 27522.7   103.06589
      1515 496.69  2507.5 26401.6 27280.2   103.67698
      1516 496.89  2507.1 26121.0 27127.0   104.26004
      1517 497.09  2844.6 26597.8 27426.0   103.48669
      1518 497.30  2494.0 26226.7 26896.8   102.82352
      1519 497.50  2503.8 26044.0 26810.8   103.25724
      1520 497.70  2872.5 26349.6 27414.5   104.53609
      1521 497.90  3176.4 26687.9 27543.1   103.63751
      1522 498.10  2580.8 25880.6 26669.5   103.38578
      1523 498.30  2912.2 26327.9 27310.5   104.19640
      1524 498.51  2834.4 25766.7 26932.4   105.08323
      1525 498.71  2799.6 25747.1 26735.8   104.30879
      1526 498.91  2295.0 25658.2 26460.2   103.43268
      1527 499.11  2602.1 25620.9 26387.7   103.33102
      1528 499.31  2949.9 25831.0 26823.1   104.33561
      1529 499.51  2961.4 26001.8 26866.9   103.75453
      1530 499.71  2426.4 25486.2 26270.9   103.40326
      1531 499.92  2522.7 25304.7 26249.6   104.14771
      1532 500.12  2873.3 25546.8 26601.1   104.64990
      1533 500.32  2780.7 25537.8 26513.0   104.28545
      1534 500.52  2673.4 25744.2 26547.0   103.47974
      1535 500.72  2319.9 25135.5 25970.7   103.66048
      1536 500.92  3064.6 25613.1 26710.4   104.86640
      1537 501.12  2926.1 25767.1 26782.9   104.44724
      1538 501.32  2224.5 25009.8 25827.3   103.58806
      1539 501.53  2435.4 25386.6 26138.2   103.27480
      1540 501.73  2917.1 25677.0 26583.5   103.98258
      1541 501.93  2871.7 25648.8 26731.7   104.75462
      1542 502.13  2333.0 25061.0 25986.3   104.07108
      1543 502.33  2255.6 25084.3 25859.3   103.39464
      1544 502.53  2748.4 25407.5 26477.0   104.71973
      1545 502.73  2877.8 25308.0 26514.2   105.37781
      1546 502.93  2286.4 25054.8 25823.7   103.37663
      1547 503.14  2533.7 25238.8 25960.5   103.17861
      1548 503.34  2703.3 25251.0 26177.1   104.10725
      1549 503.54  2800.8 25114.7 26207.0   104.89556
      1550 503.74  2490.7 25107.7 25965.4   103.79224
      1551 503.94  2420.3 24775.1 25852.3   104.81879
      1552 504.14  2907.7 25352.2 26461.0   104.94005
      1553 504.34  2851.6 24924.2 26082.5   105.24782
      1554 504.54  2456.7 24853.3 25944.9   104.87381
      1555 504.74  2468.2 24673.9 25731.1   104.76077
      1556 504.95  2882.7 24877.5 25918.3   104.73193
      1557 505.15  3064.6 25308.4 26521.6   105.45418
      1558 505.35  2391.2 24349.5 25410.0   104.82932
      1559 505.55  2425.6 24685.4 25729.0   104.68848
      1560 505.75  2785.6 24575.2 25735.2   105.32351
      1561 505.95  2821.7 24802.5 26022.3   105.54924
      1562 506.15  2546.0 24335.2 25515.6   105.41760
      1563 506.35  2480.9 24458.1 25474.7   104.62576
      1564 506.55  2770.9 24414.2 25733.5   106.09565
      1565 506.75  2859.4 24799.7 25786.0   104.49539
      1566 506.95  2496.5 24267.6 25447.7   105.42020
      1567 507.16  2621.8 24159.1 25494.8   106.20174
      1568 507.36  2921.6 24540.0 25641.4   105.09473
      1569 507.56  3012.2 24613.7 25662.3   104.85409
      1570 507.76  2454.3 24429.0 25402.6   104.43057
      1571 507.96  2600.1 24269.7 25284.6   104.68387
      1572 508.16  2608.3 24281.9 25326.8   104.82094
      1573 508.36  2826.2 24407.3 25342.0   104.33108
      1574 508.56  2502.6 24143.9 24905.3   103.51844
      1575 508.76  2501.8 24374.9 25389.9   104.64027
      1576 508.96  2838.5 24336.8 25389.9   104.89835
      1577 509.16  3241.9 24719.8 25771.6   104.89731
      1578 509.36  2446.9 24150.9 25119.6   104.46319
      1579 509.57  2644.3 24281.9 25006.9   103.35056
      1580 509.77  2748.4 24368.8 25208.4   103.88368
      1581 509.97  2749.6 24245.9 25175.3   104.32339
      1582 510.17  2528.8 24293.4 24874.2   102.66857
      1583 510.37  2494.8 24521.6 25186.7   103.01988
      1584 510.57  2590.7 24212.3 25172.8   104.44230
      1585 510.77  2593.1 24166.0 25054.4   104.11817
      1586 510.97  2534.2 24404.8 25132.7   103.32796
      1587 511.17  2412.1 24056.7 24865.2   103.73552
      1588 511.37  2979.4 24781.7 25653.7   103.99970
      1589 511.57  2991.3 24530.2 25559.5   104.77884
      1590 511.77  2502.6 24138.6 25123.3   104.55105
      1591 511.97  2432.2 24202.1 25197.4   104.57196
      1592 512.17  3019.1 24571.9 25729.5   105.37058
      1593 512.37  3017.5 24764.9 25801.1   104.76505
      1594 512.57  2445.7 24464.2 25392.4   104.21526
      1595 512.78  2541.9 24202.5 25117.1   104.22253
      1596 512.98  2703.7 24517.9 25589.4   104.91194
      1597 513.18  2487.5 24377.0 25384.2   104.60125
      1598 513.38  2432.6 24153.7 25184.7   104.74628
      1599 513.58  2531.3 24300.4 25361.6   104.87506
      1600 513.78  2968.3 24710.8 25954.3   105.71935
      1601 513.98  2845.0 24562.1 25779.8   105.60722
      1602 514.18  2663.2 24555.6 25586.9   104.71103
      1603 514.38  2336.7 24333.6 25238.8   104.11515
      1604 514.58  2310.9 24196.3 25281.4   104.95770
      1605 514.78  2665.6 24537.9 25626.6   104.97753
      1606 514.98  2560.4 24524.0 25568.1   104.75356
      1607 515.18  2552.6 24510.1 25508.7   104.54783
      1608 515.38  2734.0 24675.6 25722.9   104.77328
      1609 515.58  2671.8 24640.3 25670.9   104.69097
      1610 515.78  2396.9 24329.0 25390.7   104.84070
      1611 515.98  2563.2 24503.5 25567.7   104.85009
      1612 516.18  2888.9 24916.8 26262.3   106.10822
      1613 516.38  3032.6 25086.0 26155.0   104.84751
      1614 516.58  2499.8 24742.3 25827.3   104.87809
      1615 516.78  2327.3 24445.8 25308.8   103.90178
      1616 516.98  2542.3 24689.1 25621.7   104.21121
      1617 517.18  2794.7 24908.2 26108.3   105.42703
      1618 517.38  2478.0 24709.6 25711.4   104.50651
      1619 517.58  2499.3 25037.2 25944.1   104.02363
      1620 517.78  2637.8 24864.8 25962.1   104.93679
      1621 517.98  3052.3 25337.5 26395.0   104.74563
      1622 518.18  2489.9 24888.1 25744.2   103.82196
      1623 518.38  2454.7 25145.8 26031.7   103.90440
      1624 518.58  3145.3 25552.9 26658.4   104.93355
      1625 518.78  2707.4 25050.3 26153.0   104.93502
      1626 518.98  2612.0 25227.7 26167.3   104.15467
      1627 519.18  2474.4 24932.4 25708.6   103.45614
      1628 519.38  2858.1 25275.6 26449.9   105.23835
      1629 519.58  2782.0 25366.6 26381.1   104.49228
      1630 519.78  2474.8 25105.2 26028.5   104.07956
      1631 519.98  2571.4 25281.4 26121.0   103.69736
      1632 520.18  2827.8 25459.5 26519.1   104.68201
      1633 520.38  2771.7 25494.3 26592.5   104.83272
      1634 520.58  2580.0 25505.4 26266.0   103.31779
      1635 520.78  2492.0 25299.4 25949.8   102.85186
      1636 520.98  2773.8 25713.9 26515.5   103.49421
      1637 521.18  2954.4 25533.7 26567.9   104.58041
      1638 521.38  2542.3 25517.7 26491.7   104.23939
      1639 521.58  2600.5 25363.7 26288.5   104.06298
      1640 521.78  2966.3 25773.7 26782.9   104.42505
      1641 521.98  2826.6 25601.2 26630.6   104.51954
      1642 522.18  2459.2 25437.4 26383.2   104.11586
      1643 522.38  2634.9 25775.7 26682.2   103.91702
      1644 522.58  2441.2 25214.2 26363.1   105.04505
      1645 522.78  2833.2 25647.9 26924.2   105.59416
      1646 522.98  2653.3 25550.5 26695.7   105.00161
      1647 523.18  2455.5 25388.7 26464.7   104.69191
      1648 523.38  2740.2 25838.4 26896.4   104.58035
      1649 523.58  2655.4 25658.6 26653.9   104.32685
      1650 523.78  2340.8 25268.2 26226.7   104.18036
      1651 523.98  2485.8 25559.5 26476.1   103.97281
      1652 524.18  2784.4 25834.7 27030.3   105.18694
      1653 524.38  2744.7 25829.4 26683.8   103.70121
      1654 524.58  2436.7 25669.2 26738.7   104.60324
      1655 524.78  2505.5 25596.7 26397.9   103.46956
      1656 524.98  2840.9 26204.2 27104.9   103.85519
      1657 525.18  2685.3 25834.7 26538.8   103.04151
      1658 525.38  2587.8 25751.2 26649.4   103.87785
      1659 525.58  2627.1 25860.1 26560.1   103.01294
      1660 525.78  2917.9 26059.2 27109.4   104.53821
      1661 525.98  2838.9 25892.5 26905.0   104.39201
      1662 526.18  2493.2 25737.2 26604.3   103.73046
      1663 526.38  2418.2 25487.8 26420.8   104.04453
      1664 526.58  2760.7 25829.8 26909.5   104.68023
      1665 526.78  2659.1 25622.5 26413.5   103.44428
      1666 526.98  2712.7 25702.0 26449.5   103.25155
      1667 527.17  2283.5 25495.6 26313.9   103.52561
      1668 527.37  2701.7 25577.9 26441.3   103.77433
      1669 527.57  2653.3 25626.2 26463.9   103.64612
      1670 527.77  2394.9 25362.0 26229.2   103.77544
      1671 527.97  2473.9 25633.6 26518.3   103.82010
      1672 528.17  2512.9 25466.1 26535.1   104.65747
      1673 528.37  2834.0 25634.0 26554.4   104.03665
      1674 528.57  2522.3 25466.9 26473.7   104.38787
      1675 528.77  2446.5 25314.5 26420.0   104.83423
      1676 528.97  3087.1 25646.7 26975.0   105.88801
      1677 529.17  2889.7 25530.4 26696.1   105.14871
      1678 529.37  2564.1 25384.6 26434.4   104.60019
      1679 529.57  2480.9 25155.6 26205.0   104.62797
      1680 529.77  2766.8 25160.9 26401.2   105.53828
      1681 529.97  3001.5 25605.3 26653.5   104.63704
      1682 530.17  2689.8 25187.1 26319.7   105.03405
      1683 530.36  2546.0 25015.5 26134.9   104.98195
      1684 530.56  2924.5 25126.5 26508.5   106.22452
      1685 530.76  2589.5 24910.3 26157.1   105.58583
      1686 530.96  2641.1 24853.7 26209.9   106.10536
      1687 531.16  2450.6 24827.5 26152.6   105.92144
      1688 531.36  2954.0 25250.6 26577.3   105.95011
      1689 531.56  3004.4 25254.7 26623.2   106.15025
      1690 531.76  2410.9 24421.6 25646.3   105.56403
      1691 531.96  2408.8 24663.7 25761.8   104.93429
      1692 532.16  2781.6 25043.4 26244.7   105.39641
      1693 532.36  2736.1 24808.3 25953.1   105.18669
      1694 532.56  2408.0 24753.0 25908.4   105.17102
      1695 532.76  2537.8 24779.2 25839.6   104.76787
      1696 532.95  2727.5 24832.0 26082.1   105.65531
      1697 533.15  2817.2 24959.0 26137.0   105.32021
      1698 533.35  2608.3 24789.4 25792.9   104.52414
      1699 533.55  2460.8 24599.8 25536.5   104.23119
      1700 533.75  3046.1 25305.9 26621.5   105.91028
      1701 533.95  2794.2 24764.0 25755.7   104.51359
      1702 534.15  2451.4 24833.7 25639.8   103.60143
      1703 534.35  2602.6 24575.6 25430.0   103.88846
      1704 534.55  2948.3 25020.9 26140.7   105.07339
      1705 534.75  2754.5 24732.5 25691.4   104.36282
      1706 534.94  2354.3 24474.9 25339.1   103.90697
      1707 535.14  2498.1 24383.9 25344.4   104.38867
      1708 535.34  2756.2 24594.5 25670.9   104.92901
      1709 535.54  2744.3 24492.1 25389.1   104.12460
      1710 535.74  2667.3 24687.4 25614.4   104.20937
      1711 535.94  2425.2 24336.8 25330.1   104.53305
      1712 536.14  2768.9 24469.1 25775.3   106.01925
      1713 536.34  3205.5 24723.9 25854.8   105.25544
      1714 536.54  2669.3 24389.7 25489.8   105.06515
      1715 536.73  2497.7 24079.6 25115.9   104.80158
      1716 536.93  2787.7 24433.1 25516.1   105.00322
      1717 537.13  3162.9 24534.7 25719.2   105.54257
      1718 537.33  2714.0 24195.5 25319.4   105.23205
      1719 537.53  2469.0 23818.3 25007.7   105.57144
      1720 537.73  2693.1 23904.7 25318.2   106.66383
      1721 537.93  2706.6 23866.6 25139.2   106.01421
      1722 538.13  2741.0 24101.3 25414.9   106.14957
      1723 538.32  2653.8 23739.2 24881.6   105.41774
      1724 538.52  2565.7 23740.1 24902.1   105.48785
      1725 538.72  2661.9 23772.0 25068.8   106.14292
      1726 538.92  2685.7 23559.0 24739.1   105.65334
      1727 539.12  2438.7 23551.2 24770.6   105.77554
      1728 539.32  3019.5 23930.5 25114.2   105.66078
      1729 539.52  2936.4 23752.3 25002.4   106.00539
      1730 539.72  2571.4 23686.0 24822.6   105.38313
      1731 539.91  2376.9 23313.7 24554.7   105.92769
      1732 540.11  2673.8 23491.4 24744.8   106.02066
      1733 540.31  2742.6 23560.2 24866.4   106.27447
      1734 540.51  2406.8 23301.8 24377.4   105.14761
      1735 540.71  2626.7 23562.7 24528.1   104.61126
      1736 540.91  3181.3 23901.8 24903.7   104.83514
      1737 541.11  2618.1 23472.2 24438.8   104.63527
      1738 541.30  2362.1 23156.0 24291.8   105.46221
      1739 541.50  2338.4 23029.0 24078.8   105.07374
      1740 541.70  2584.5 23115.0 24304.1   105.79163
      1741 541.90  2748.0 23220.3 24470.8   106.10820
      1742 542.10  2296.6 23062.2 23962.9   104.33745
      1743 542.30  2482.1 22951.2 24027.2   105.25673
      1744 542.49  2872.9 23406.6 24447.4   105.06862
      1745 542.69  2727.5 23164.6 24121.8   104.68374
      1746 542.89  2303.6 22884.0 23776.1   104.33467
      1747 543.09  2476.0 23191.6 24008.3   103.94258
      1748 543.29  3033.0 23529.5 24423.3   104.36042
      1749 543.49  3065.8 23557.8 24585.9   105.01699
      1750 543.68  2640.2 23067.5 24147.2   105.28553
      1751 543.88  2534.2 22975.3 23837.5   104.21793
      1752 544.08  2937.2 23219.0 24098.9   104.33791
      1753 544.28  2772.1 23169.9 24026.8   104.20080
      1754 544.48  2670.1 23203.1 24077.1   104.25693
      1755 544.68  2409.6 22862.7 23707.7   104.13137
      1756 544.87  2984.3 23261.2 24157.4   104.41975
      1757 545.07  2865.5 23002.8 23925.2   104.58059
      1758 545.27  2456.7 22871.3 23774.9   104.42608
      1759 545.47  2449.4 22938.1 23675.7   103.60042
      1760 545.67  2744.3 22920.5 23834.7   104.53115
      1761 545.87  2795.9 22952.4 24133.3   105.85845
      1762 546.06  2378.1 22846.3 23813.4   104.72465
      1763 546.26  2416.2 22680.0 23584.8   104.46506
      1764 546.46  2725.0 22930.7 24097.2   105.77325
      1765 546.66  2736.1 22998.7 24030.5   105.09198
      1766 546.86  2912.6 22985.2 24084.1   105.47484
      1767 547.05  2403.9 22816.0 23826.9   104.95235
      1768 547.25  2969.1 22884.0 23963.3   105.41947
      1769 547.45  3271.4 23333.3 24367.1   105.15313
      1770 547.65  2452.2 22596.5 23487.7   104.42447
      1771 547.85  2306.4 22180.3 23301.8   105.64291
      1772 548.04  3044.1 23040.1 24194.3   105.77234
      1773 548.24  2979.0 22696.4 23999.7   106.61002
      1774 548.44  2596.4 22367.1 23707.3   106.77867
      1775 548.64  2583.3 22454.7 23895.3   107.24930
      1776 548.84  3128.5 22872.1 24236.9   106.91243
      1777 549.03  2599.3 22224.1 23549.2   106.75182
      1778 549.23  2429.7 22383.5 23665.5   106.42500
      1779 549.43  2545.2 22236.8 23557.0   106.70397
      1780 549.63  2716.0 22580.1 24016.5   107.23138
      1781 549.83  2873.7 22525.6 23719.2   106.07349
      1782 550.02  2487.5 22354.4 23575.0   106.14382
      1783 550.22  2487.1 22285.6 23561.1   106.44227
      1784 550.42  2797.5 22465.4 23774.9   106.65792
      1785 550.62  2936.8 22561.2 23983.8   107.24871
      1786 550.82  2288.4 22023.0 23203.5   105.98161
      1787 551.01  2508.8 22086.5 23463.2   107.03167
      1788 551.21  2751.2 22440.8 23771.2   106.75668
      1789 551.41  3242.3 22781.6 24064.9   106.56759
      1790 551.61  2387.9 21905.1 23188.7   106.57713
      1791 551.80  2547.7 22402.7 23539.4   105.72460
      1792 552.00  2741.4 22246.3 23552.5   106.69677
      1793 552.20  2881.1 22427.3 23705.6   106.54010
      1794 552.40  2360.5 21971.0 23208.0   106.30770
      1795 552.60  2553.0 22371.6 23283.4   104.60051
      1796 552.79  2930.2 22380.2 23531.2   105.91754
      1797 552.99  2837.7 22313.8 23648.7   106.85384
      1798 553.19  2596.4 22204.5 23150.6   104.82536
      1799 553.39  2362.1 21913.3 22973.7   105.42392
      1800 553.58  2839.7 22327.8 23517.6   106.10564
      1801 553.78  2526.4 21829.7 22849.2   105.28136
      1802 553.98  2689.4 22004.2 23204.7   106.21554
      1803 554.18  2379.7 21976.3 23038.0   105.41761
      1804 554.37  2540.3 21704.0 22980.3   106.65997
      1805 554.57  2834.0 21838.3 23107.2   106.67701
      1806 554.77  2604.6 22002.6 22918.8   104.72349
      1807 554.97  2584.5 21904.7 23158.8   106.49155
      1808 555.16  3027.7 22240.5 23461.9   106.35726
      1809 555.36  3311.2 22394.1 23641.8   106.53788
      1810 555.56  2446.1 21698.2 22882.4   106.15067
      1811 555.76  2472.7 21619.2 22930.7   106.84993
      1812 555.95  3308.7 22324.1 23538.9   106.38880
      1813 556.15  2799.2 21955.0 23160.1   106.29063
      1814 556.35  2588.2 21749.0 22644.8   104.67507
      1815 556.55  2584.9 21559.8 22604.7   105.50663
      1816 556.74  2517.0 21617.9 22648.1   105.39306
      1817 556.94  2727.5 21860.0 22800.0   104.91319
      1818 557.14  2353.9 21610.2 22535.4   104.80506
      1819 557.34  2514.1 21545.5 22487.1   104.94792
      1820 557.53  2804.5 22026.3 22894.7   104.51746
      1821 557.73  2825.0 21714.6 22665.3   105.03274
      1822 557.93  2476.8 21575.4 22248.7   103.52578
      1823 558.13  2421.5 21349.7 22170.1   104.33437
      1824 558.32  2749.6 21568.4 22629.2   105.63718
      1825 558.52  2794.7 21792.0 22717.7   104.87269
      1826 558.72  2345.7 21298.9 22305.2   105.30979
      1827 558.92  2515.7 21643.8 22453.1   104.23126
      1828 559.11  2873.7 21854.3 22711.2   104.51446
      1829 559.31  2865.1 21724.4 22478.1   103.99617
      1830 559.51  2587.4 21674.9 22250.8   103.01710
      1831 559.70  2500.6 21509.0 22499.4   105.21030
      1832 559.90  2779.1 21735.5 22634.6   104.74277
      1833 560.10  2626.7 21501.2 22309.3   104.28159
      1834 560.30  2385.9 21445.5 22288.5   104.42266
      1835 560.49  2597.2 21432.4 22502.3   105.68011
      1836 560.69  2710.7 21482.8 22521.1   105.53119
      1837 560.89  3043.3 21763.4 22888.1   106.00823
      1838 561.08  2351.5 21239.9 22015.3   104.10495
      1839 561.28  2434.6 21140.0 22126.7   105.27503
      1840 561.48  2748.0 21479.5 22422.8   105.03586
      1841 561.68  2890.9 21455.7 22546.5   105.87535
      1842 561.87  2489.5 21120.3 21990.3   104.66957
      1843 562.07  2476.4 21157.6 22086.5   104.97270
      1844 562.27  2598.9 21217.8 22240.1   105.49090
      1845 562.46  2841.4 21233.8 22264.3   105.60306
      1846 562.66  2460.4 21234.2 22037.4   104.27839
      1847 562.86  2435.0 20824.6 21636.8   104.41678
      1848 563.05  2717.2 21269.4 22256.5   105.32079
      1849 563.25  2573.5 20882.7 21975.1   105.96631
      1850 563.45  2308.5 20714.0 21851.8   106.18213
      1851 563.65  2760.7 20872.9 22074.2   106.63274
      1852 563.84  2980.6 21273.9 22478.1   106.58277
      1853 564.04  2736.5 20858.6 22085.7   106.77154
      1854 564.24  2494.8 20750.0 21821.9   105.87180
      1855 564.43  2435.9 20676.7 21680.6   105.50366
      1856 564.63  2935.6 21058.9 22369.6   107.23213
      1857 564.83  2824.6 20835.2 22061.1   106.80660
      1858 565.02  2433.8 20632.1 21731.4   106.04097
      1859 565.22  2481.3 20639.4 21710.1   105.89642
      1860 565.42  2628.0 20623.9 21910.4   107.14904
      1861 565.61  2831.9 20832.3 21957.9   106.25298
      1862 565.81  2455.1 20620.2 21651.9   105.67995
      1863 566.01  2644.3 20659.1 21808.8   106.38215
      1864 566.20  2791.4 20838.5 21828.9   105.48784
      1865 566.40  2540.3 20532.5 21729.4   106.65195
      1866 566.60  2472.7 20584.1 21726.1   106.30512
      1867 566.79  2386.7 20321.6 21304.2   105.47880
      1868 566.99  2987.6 21099.8 22115.2   105.60606
      1869 567.19  2756.2 20788.1 21856.3   105.92404
      1870 567.38  2593.5 20535.0 21325.5   104.40609
      1871 567.58  2440.4 20339.2 21265.7   105.17632
      1872 567.78  2742.2 20719.3 21713.8   105.53201
      1873 567.97  2605.4 20571.8 21621.2   105.84078
      1874 568.17  2250.7 20392.9 21137.1   104.10222
      1875 568.37  2483.0 20454.7 21382.0   105.15988
      1876 568.56  3051.9 21142.4 22210.2   105.90260
      1877 568.76  2701.3 20606.3 21790.0   106.61115
      1878 568.96  2518.2 20467.4 21381.6   105.09333
      1879 569.15  2571.8 20573.1 21413.6   104.66905
      1880 569.35  4226.2 21936.6 23251.0   107.42154
      1881 569.55  3084.2 21073.2 22127.1   105.85851
      1882 569.74  2444.0 20445.7 21278.0   104.62344
      1883 569.94  2618.5 20381.4 21461.5   106.08066
      1884 570.14  2883.5 20827.0 21915.3   106.06510
      1885 570.33  2803.7 20517.8 21778.1   107.11478
      1886 570.53  2324.9 20213.5 21205.5   105.54563
      1887 570.73  2401.4 20315.8 21313.2   105.56737
      1888 570.92  2569.4 20379.3 21727.3   107.56865
      1889 571.12  2802.8 20422.3 21629.4   106.85078
      1890 571.31  2222.0 19863.7 21049.0   106.71914
      1891 571.51  2467.0 20030.0 21261.6   107.01275
      1892 571.71  2775.4 20450.2 21872.7   108.04829
      1893 571.90  3036.3 20479.3 21971.4   108.55445
      1894 572.10  2357.2 20045.1 21161.3   106.31021
      1895 572.30  2398.2 20063.1 21296.8   106.98386
      1896 572.49  3046.6 20631.6 21912.0   107.28111
      1897 572.69  2958.1 20449.8 21736.7   107.35745
      1898 572.88  2503.4 20150.8 21328.0   106.67053
      1899 573.08  2292.1 19695.3 20990.9   107.44428
      1900 573.28  3179.3 20401.9 21958.3   109.03729
      1901 573.47  2829.9 20039.4 21509.8   108.54437
      1902 573.67  2320.8 19617.1 20912.2   107.48792
      1903 573.87  2434.2 19666.6 20986.4   107.65830
      1904 574.06  2734.0 19922.2 21223.1   107.56839
      1905 574.26  2906.1 20020.1 21555.3   108.97016
      1906 574.45  2379.7 19730.5 20899.5   106.73733
      1907 574.65  2348.6 19458.6 20645.6   106.93750
      1908 574.85  2982.7 20035.3 21303.4   107.43641
      1909 575.04  2752.5 19780.9 20989.2   107.09578
      1910 575.24  2621.0 19747.3 20933.9   106.92847
      1911 575.44  2347.4 19475.4 20490.3   105.92582
      1912 575.63  2844.2 20017.3 21066.2   106.10824
      1913 575.83  2502.2 19599.5 20777.1   106.88755
      1914 576.02  2436.7 19490.1 20545.6   106.18950
      1915 576.22  2432.2 19498.3 20544.0   106.12730
      1916 576.42  2940.5 19774.4 20968.3   107.09263
      1917 576.61  2764.3 19849.7 20936.4   106.36013
      1918 576.81  2364.2 19358.2 20209.4   105.00844
      1919 577.00  2608.3 19540.5 20468.2   105.47909
      1920 577.20  2867.6 19755.1 20865.1   106.57288
      1921 577.40  2848.7 19903.0 20789.8   105.19970
      1922 577.59  2281.0 19391.0 20165.1   104.52446
      1923 577.79  2525.6 19440.1 20423.2   105.81170
      1924 577.98  2798.8 19783.0 20870.4   106.40283
      1925 578.18  2677.5 19602.7 20598.5   105.88307
      1926 578.37  2532.9 19551.5 20520.2   105.69194
      1927 578.57  2309.3 19264.4 20293.7   106.07078
      1928 578.77  2553.8 19386.1 20430.9   106.20757
      1929 578.96  2531.7 19376.2 20256.5   105.22553
      1930 579.16  2285.5 19353.7 20152.8   104.68192
      1931 579.35  2288.8 18986.3 20089.3   106.60600
      1932 579.55  2596.8 19426.6 20429.7   105.96023
      1933 579.75  2526.4 19153.0 20342.9   107.15641
      1934 579.94  2407.6 19277.5 20579.2   107.71603
      1935 580.14  2343.3 19120.7 20227.4   106.59652
      1936 580.33  3165.3 19756.3 21155.1   108.43085
      1937 580.53  2733.6 19365.6 20648.4   107.71315
      1938 580.72  2396.1 19140.3 20320.8   107.04990
      1939 580.92  2539.5 19454.5 20611.6   106.84069
      1940 581.12  2750.0 19148.9 20399.8   107.62795
      1941 581.31  2744.3 19391.0 20791.4   108.41248
      1942 581.51  2541.5 19338.6 20435.0   106.52784
      1943 581.70  2471.5 19281.2 20366.2   106.45468
      1944 581.90  3386.1 19811.6 21102.3   107.85746
      1945 582.09  2559.6 19171.0 20315.4   106.88924
      1946 582.29  2288.4 18862.2 19979.6   106.74180
      1947 582.48  2404.7 19092.0 20093.0   105.99887
      1948 582.68  2836.0 19443.4 20679.6   107.44340
      1949 582.88  3012.2 19470.9 20674.2   107.31155
      1950 583.07  2358.0 19052.3 20052.5   105.99146
      1951 583.27  2256.9 18882.7 19867.3   105.92250
      1952 583.46  2860.2 19371.3 20511.6   106.90630
      1953 583.66  3080.6 19481.5 20534.6   106.42075
      1954 583.85  2540.3 19276.7 20209.8   105.57499
      1955 584.05  2511.2 19066.2 20120.5   106.36845
      1956 584.24  3222.7 19825.6 20827.0   106.03183
      1957 584.44  2966.7 19528.2 20542.4   106.12356
      1958 584.63  2386.7 18979.3 19953.0   105.86768
      1959 584.83  2351.1 19050.2 19821.9   104.62105
      1960 585.03  2934.3 19529.8 20299.9   104.64003
      1961 585.22  2655.0 19143.6 20058.2   105.54700
      1962 585.42  2241.3 18800.8 19621.2   104.95436
      1963 585.61  2410.9 18947.4 19705.6   104.58475
      1964 585.81  2697.6 19294.3 20117.6   104.96052
      1965 586.00  2780.3 19092.8 19963.6   105.33822
      1966 586.20  2378.5 18842.1 19714.2   105.29668
      1967 586.39  2413.3 18815.5 19674.4   105.23661
      1968 586.59  2613.2 19055.1 20034.9   105.95885
      1969 586.78  2598.5 18940.4 19839.9   105.50404
      1970 586.98  2484.6 18899.1 19839.5   105.72926
      1971 587.17  2523.5 18818.0 19803.9   106.05047
      1972 587.37  2912.2 19060.9 20179.5   106.92690
      1973 587.56  3090.0 19308.2 20389.2   106.66482
      1974 587.76  2455.5 18662.3 19766.2   106.81106
      1975 587.95  2463.3 18809.0 19769.9   105.87867
      1976 588.15  2697.2 18815.5 19980.0   107.22454
      1977 588.34  2934.7 19080.9 20305.2   107.58245
      1978 588.54  2388.3 18551.3 19615.4   106.58372
      1979 588.74  2496.9 18561.6 19656.8   106.81778
      1980 588.93  2503.8 18764.7 19720.7   105.87909
      1981 589.13  2912.2 18867.9 20074.2   107.56001
      1982 589.32  2367.5 18534.1 19463.5   105.74867
      1983 589.52  2231.9 18213.0 19142.0   105.81285
      1984 589.71  3014.6 19082.2 20208.9   107.01285
      1985 589.91  2851.6 18495.2 19849.7   108.65865
      1986 590.10  2289.2 18234.7 19263.2   106.45004
      1987 590.30  2453.9 18396.5 19384.4   106.19685
      1988 590.49  2765.2 18551.3 19536.8   106.24271
      1989 590.69  2925.3 18534.1 19677.7   107.32655
      1990 590.88  2340.0 18267.5 19228.0   106.03045
      1991 591.08  2325.3 18165.9 19096.5   105.87475
      1992 591.27  2803.3 18537.4 19687.1   107.30723
      1993 591.47  2514.5 18226.9 19431.9   107.66925
      1994 591.66  2394.5 18031.5 19204.6   107.50190
      1995 591.85  2349.4 18216.7 19038.7   105.18083
      1996 592.05  2881.5 18564.4 19694.1   107.20312
      1997 592.24  3055.6 18557.5 19805.1   108.04820
      1998 592.44  2317.1 18133.9 19099.8   106.10628
      1999 592.63  2251.1 17795.2 18957.2   107.47563
      2000 592.83  2838.9 18365.0 19756.8   108.96428
      2001 593.02  2768.0 18255.6 19325.0   106.90522
      2002 593.22  2297.4 17891.9 19082.2   107.63271
      2003 593.41  2186.8 17752.6 18858.1   107.10207
      2004 593.61  2699.6 18178.6 19497.5   108.52055
      2005 593.80  3366.9 18552.5 20038.6   109.78557
      2006 594.00  2299.5 17855.0 18924.0   106.87240
      2007 594.19  2382.2 17807.9 19073.1   108.20212
      2008 594.39  2781.6 17939.8 19207.9   108.36576
      2009 594.58  2575.5 17871.8 19151.8   108.36792
      2010 594.78  2357.2 17619.9 18708.6   107.13308
      2011 594.97  2493.6 17739.5 18685.7   106.20601
      2012 595.17  2748.8 17936.9 19207.9   108.36816
      2013 595.36  2867.6 17950.4 19104.7   107.65262
      2014 595.56  2374.4 17549.0 18688.9   107.51188
      2015 595.75  2397.4 17517.9 18663.1   107.57395
      2016 595.94  2884.4 17972.6 19238.6   108.39102
      2017 596.14  2991.3 17795.6 19062.9   108.56020
      2018 596.33  2425.2 17472.9 18442.8   106.44564
      2019 596.53  2242.5 17213.2 18399.8   107.92613
      2020 596.72  2759.0 17764.5 19003.1   108.25440
      2021 596.92  2804.1 17651.9 18783.6   107.62207
      2022 597.11  2379.3 17332.8 18291.6   106.41229
      2023 597.31  2566.9 17643.7 18579.2   106.20500
      2024 597.50  2904.8 17744.0 18819.6   107.24834
      2025 597.69  3076.5 17830.4 18968.3   107.71217
      2026 597.89  2468.2 17370.5 18332.2   106.45356
      2027 598.08  2328.1 16971.1 18162.6   108.13707
      2028 598.28  2943.3 17880.0 18867.1   106.60872
      2029 598.47  2818.8 17517.1 18521.0   106.83015
      2030 598.67  2413.7 17357.8 18347.8   106.62464
      2031 598.86  2464.1 17151.7 18061.9   106.19650
      2032 599.06  2974.9 17553.1 18674.2   107.68993
      2033 599.25  2724.2 17156.7 18088.5   106.45647
      2034 599.44  2487.9 17023.1 17971.3   106.52351
      2035 599.64  2472.7 17086.2 17988.9   106.17748
      2036 599.83  2746.3 17271.7 18352.3   107.43874
      2037 600.03  2705.8 17173.9 18324.8   107.95516
      2038 600.22  2281.0 16915.0 17706.3   105.40752
      2039 600.42  2518.6 16862.6 17843.1   106.83610
      2040 600.61  2692.3 16962.9 18019.7   107.40506
      2041 600.80  2623.4 16847.0 17959.0   107.81835
      2042 601.00  2506.7 16779.8 17846.4   107.47267
      2043 601.19  2387.5 16547.2 17699.4   108.13711
      2044 601.39  2971.2 17017.0 18283.9   109.01959
      2045 601.58  2700.9 16694.2 17811.2   107.98209
      2046 601.78  2446.9 16592.6 17679.3   107.68184
      2047 601.97  2431.3 16589.8 17671.1   107.63734
      2048 602.16  2863.1 16798.7 17937.7   108.17389
      2049 602.36  2679.2 16612.3 17654.7   107.48155
      2050 602.55  2454.3 16677.0 17707.6   107.24571
      2051 602.75  2318.7 16259.2 17296.7   107.44234
      2052 602.94  2955.6 16718.4 18097.5   110.02053
      2053 603.13  3017.1 16786.8 18014.8   108.91784
      2054 603.33  2295.0 16224.0 17359.4   108.15126
      2055 603.52  2356.4 16132.7 17227.5   107.94731
      2056 603.72  2940.1 16745.8 17823.9   107.80870
      2057 603.91  2634.1 16254.7 17454.8   108.81097
      2058 604.10  2383.8 16180.2 17287.3   108.02482
      2059 604.30  2421.9 16111.8 17127.2   107.41705
      2060 604.49  2762.7 16424.7 17513.4   107.96883
      2061 604.69  2818.8 16373.9 17392.6   107.51495
      2062 604.88  2215.9 15925.8 16987.9   107.74678
      2063 605.07  2458.0 16035.2 17102.2   107.85869
      2064 605.27  2752.5 16156.8 17188.6   107.69725
      2065 605.46  2542.8 16063.4 17087.8   107.57649
      2066 605.66  2503.0 16080.2 16963.7   106.50718
      2067 605.85  2393.3 15770.2 16634.8   106.46376
      2068 606.04  2865.5 16368.6 17251.7   106.53987
      2069 606.24  2923.7 16353.9 17395.4   107.75565
      2070 606.43  2177.8 15758.3 16498.8   105.45301
      2071 606.62  2399.4 15840.2 16582.4   105.52187
      2072 606.82  2664.0 16050.3 16948.2   106.70705
      2073 607.01  2846.3 16086.8 17016.2   107.01912
      2074 607.21  2316.3 15688.7 16563.2   106.53945
      2075 607.40  2517.8 15839.8 16669.6   106.22905
      2076 607.59  2802.4 15935.7 16993.6   108.05577
      2077 607.79  2592.7 15743.6 16632.0   106.75554
      2078 607.98  2503.8 15698.9 16648.3   107.19541
      2079 608.17  2246.6 15465.4 16191.7   105.49376
      2080 608.37  2858.1 15898.0 16869.1   107.44755
      2081 608.56  3266.5 16337.5 17325.4   107.55828
      2082 608.76  2181.1 15430.2 16227.3   106.01601
      2083 608.95  2306.8 15469.9 16260.1   106.00243
      2084 609.14  3092.4 16070.4 17054.7   107.58403
      2085 609.34  2737.3 15846.4 16717.6   106.64584
      2086 609.53  2378.9 15535.5 16265.4   105.54777
      2087 609.72  2298.2 15347.9 16166.3   106.27119
      2088 609.92  2677.1 15719.4 16639.7   107.05672
      2089 610.11  2793.8 15806.6 16704.9   106.90275
      2090 610.30  2340.0 15405.2 16169.9   105.85303
      2091 610.50  2368.7 15399.1 16152.3   105.78066
      2092 610.69  2455.9 15371.2 16234.2   106.68210
      2093 610.88  2867.2 15769.4 16662.3   106.92064
      2094 611.08  2377.3 15318.8 16108.1   106.09887
      2095 611.27  2268.7 15213.1 16039.3   106.38231
      2096 611.46  2939.7 15739.9 16895.7   109.03011
      2097 611.66  2655.0 15480.6 16516.5   108.07651
      2098 611.85  2199.1 15203.3 16125.3   107.08998
      2099 612.04  2424.8 15417.1 16229.7   106.25473
      2100 612.24  2955.2 15712.0 16793.3   108.47649
      2101 612.43  2699.2 15516.6 16506.6   107.72377
      2102 612.62  2263.4 15059.9 15987.3   107.24665
      2103 612.82  2419.9 15079.2 15967.2   107.01459
      2104 613.01  2671.4 15490.8 16672.5   109.21784
      2105 613.20  2850.0 15596.1 16473.0   106.88004
      2106 613.40  2372.4 15271.3 16171.6   106.97955
      2107 613.59  2299.9 14989.5 15853.7   106.81063
      2108 613.78  2822.9 15629.7 16589.4   107.49352
      2109 613.98  2437.1 15039.1 16027.0   107.83957
      2110 614.17  2347.8 15186.5 16001.2   106.34551
      2111 614.36  2367.9 15071.0 16043.8   107.65783
      2112 614.56  3641.7 16230.6 17324.6   108.69042
      2113 614.75  2654.6 15237.3 16389.1   109.15365
      2114 614.94  2350.7 15118.1 16113.4   107.79571
      2115 615.14  2351.9 15130.4 16103.2   107.61267
      2116 615.33  3025.7 15716.1 16962.1   109.81829
      2117 615.52  3010.9 15630.1 16891.6   109.99707
      2118 615.72  2272.8 15245.1 16314.1   108.24098
      2119 615.91  2454.7 15207.0 16367.8   109.10259
      2120 616.10  2813.9 15627.6 16826.9   109.35941
      2121 616.30  2834.8 15653.9 16882.6   109.58558
      2122 616.49  2449.0 15293.4 16609.0   110.24268
      2123 616.68  2369.9 15334.0 16628.7   109.98705
      2124 616.88  3158.4 15859.1 17341.0   111.66796
      2125 617.07  3104.3 15968.8 17482.3   111.76451
      2126 617.26  2261.8 15370.4 16593.1   109.32696
      2127 617.45  2441.6 15370.8 16765.9   110.79009
      2128 617.65  3215.3 16188.0 17668.2   111.41071
      2129 617.84  2487.5 15492.1 16847.0   110.41890
      2130 618.03  2257.7 15469.1 16742.6   109.63882
      2131 618.23  2411.7 15563.7 16743.8   108.97229
      2132 618.42  2848.7 15825.9 17261.9   111.06587
      2133 618.61  2632.0 15689.5 17132.9   111.05430
      2134 618.80  2350.7 15596.5 16830.2   109.31383
      2135 619.00  2314.6 15647.3 16943.3   109.72013
      2136 619.19  2986.3 16171.2 17697.3   111.57502
      2137 619.38  2810.6 16123.7 17424.1   109.76833
      2138 619.58  2347.0 15738.2 16897.8   108.65908
      2139 619.77  2385.9 15727.2 17171.0   110.82218
      2140 619.96  3048.2 16155.2 17684.2   111.66562
      2141 620.15  2684.9 15981.5 17391.4   110.60284
      2142 620.35  2555.9 15836.5 17320.9   111.17690
      2143 620.54  2376.1 15679.7 17100.1   110.67734
      2144 620.73  2714.8 16020.9 17477.8   110.94933
      2145 620.93  2905.7 16233.4 17501.9   109.51781
      2146 621.12  2281.8 15741.1 16928.9   108.82532
      2147 621.31  2446.5 15908.2 17161.2   109.30749
      2148 621.50  2610.8 16174.0 17329.9   108.52208
      2149 621.70  3289.4 16713.9 18007.4   109.63539
      2150 621.89  2261.0 15890.2 16838.0   106.95416
      2151 622.08  2170.0 15754.2 16924.0   108.61149
      2152 622.27  2847.1 16429.2 17681.3   109.21894
      2153 622.47  2993.7 16324.8 17662.5   110.03473
      2154 622.66  2276.5 15760.3 16939.6   108.74545
      2155 622.85  2427.7 15866.4 17046.1   108.77781
      2156 623.04  2809.8 16120.0 17385.2   109.50578
      2157 623.24  2673.4 15950.8 17188.6   109.32256
      2158 623.43  2408.8 16081.9 17096.0   107.41718
      2159 623.62  2392.4 15839.8 17014.5   108.73564
      2160 623.81  2810.6 16168.3 17328.3   108.68392
      2161 624.01  2917.5 16129.8 17370.1   109.38711
      2162 624.20  2283.5 15756.7 16848.6   108.10482
      2163 624.39  2513.7 15991.0 16894.1   106.70131
      2164 624.58  2621.0 16027.0 17004.3   107.28995
      2165 624.78  2829.1 16198.2 17354.9   108.65196
      2166 624.97  2312.2 15682.9 16718.0   107.74108
      2167 625.16  2368.3 15661.6 16538.6   106.59682
      2168 625.35  2816.4 15864.8 17044.4   109.04040
      2169 625.55  2848.7 16175.7 17160.3   107.38852
      2170 625.74  2409.2 15639.9 16764.7   108.50102
      2171 625.93  2419.5 15676.0 16680.7   107.57917
      2172 626.12  2696.4 15798.0 16829.4   107.87195
      2173 626.32  2597.6 15582.6 16763.0   109.09091
      2174 626.51  2298.2 15445.0 16514.4   108.13471
      2175 626.70  2350.2 15390.9 16457.5   108.17890
      2176 626.89  2725.8 15584.2 16757.7   109.12624
      2177 627.09  2735.7 15744.4 16837.2   108.40050
      2178 627.28  2338.8 15340.1 16309.2   107.45385
      2179 627.47  2421.5 15403.2 16479.6   108.29179
      2180 627.66  3018.3 15853.3 17042.0   109.26091
      2181 627.85  2871.3 15573.2 16865.4   110.17381
      2182 628.05  2297.8 15265.1 16284.6   107.86190
      2183 628.24  2346.6 15216.0 16340.7   108.73966
      2184 628.43  2949.5 15745.2 16965.0   109.53266
      2185 628.62  2974.5 15697.3 16841.7   108.99491
      2186 628.82  2341.2 15284.0 16204.8   107.11415
      2187 629.01  2539.5 15232.0 16216.6   107.75785
      2188 629.20  2852.0 15504.8 16557.8   108.32281
      2189 629.39  2874.9 15477.7 16725.8   109.90282
      2190 629.58  2216.7 14935.4 16074.1   108.95273
      2191 629.78  2397.4 14994.4 15965.1   107.70606
      2192 629.97  2688.6 15319.6 16394.4   108.50898
      2193 630.16  2698.8 15066.1 16328.0   110.20401
      2194 630.35  2339.2 14942.8 16074.9   108.98248
      2195 630.54  2395.7 14900.6 15951.6   108.40485
      2196 630.74  2566.1 15070.6 16183.5   108.89974
      2197 630.93  2614.4 15022.7 16175.3   109.28897
      2198 631.12  2328.1 14855.6 15818.9   107.69004
      2199 631.31  2261.8 14634.8 15574.4   107.59401
      2200 631.50  2865.1 15064.0 16474.3   111.56028
      2201 631.70  2992.1 15194.7 16582.0   111.36882
      2202 631.89  2240.9 14595.1 15786.2   109.64127
      2203 632.08  2463.7 14715.1 15872.2   109.44468
      2204 632.27  2497.3 14604.9 15874.6   110.48715
      2205 632.46  2958.9 15048.9 16293.6   110.29576
      2206 632.65  2461.7 14577.4 15846.0   110.46990
      2207 632.85  2274.1 14342.3 15483.1   109.45221
      2208 633.04  2781.1 14711.0 16031.9   111.07258
      2209 633.23  2956.0 14844.9 16251.5   111.83077
      2210 633.42  2367.5 14341.9 15546.5   110.05986
      2211 633.61  2351.5 14345.6 15547.0   110.01606
      2212 633.81  2849.1 14615.1 15984.8   111.64103
      2213 634.00  2741.0 14452.9 15839.8   111.84165
      2214 634.19  2426.0 14221.9 15356.5   109.61839
      2215 634.38  2411.3 14217.8 15379.4   109.83868
      2216 634.57  2705.4 14227.6 15564.2   111.59931
      2217 634.76  2580.0 14282.1 15515.4   110.53903
      2218 634.96  2279.4 13993.0 15140.2   109.79439
      2219 635.15  2350.2 14016.3 15142.3   109.65171
      2220 635.34  2967.9 14427.9 15719.0   111.26559
      2221 635.53  3019.9 14389.8 15766.1   112.10418
      2222 635.72  2431.3 14035.5 15100.9   109.18075
      2223 635.91  2190.1 13890.1 14893.2   108.57343
      2224 636.11  2880.7 14326.8 15495.3   110.20934
      2225 636.30  2896.2 14317.8 15510.5   110.44289
      2226 636.49  2422.3 13945.8 14944.0   108.66212
      2227 636.68  2321.2 13690.7 14732.7   109.16493
      2228 636.87  2546.9 13939.7 14982.9   109.15693
      2229 637.06  3254.6 14482.4 15657.1   110.46257
      2230 637.26  2352.3 13718.5 14586.0   107.63244
      2231 637.45  2329.8 13745.6 14646.3   107.88992
      2232 637.64  2695.1 14009.7 15001.8   108.76774
      2233 637.83  2787.7 14085.5 15076.3   108.76990
      2234 638.02  2294.1 13663.2 14515.2   107.49361
      2235 638.21  2454.3 13603.0 14520.5   108.22955
      2236 638.40  3117.0 14299.7 15467.9   110.44612
      2237 638.60  3147.7 14190.8 15181.6   108.97222
      2238 638.79  2477.6 13632.5 14496.8   107.74767
      2239 638.98  2246.6 13382.2 14200.2   107.34543
      2240 639.17  2877.8 13781.2 14858.8   109.88355
      2241 639.36  2562.4 13476.9 14459.9   109.00664
      2242 639.55  2425.2 13407.6 14337.8   108.46977
      2243 639.74  2375.6 13326.5 14279.3   108.69988
      2244 639.93  2724.6 13551.4 14572.9   109.43518
      2245 640.13  2862.7 13570.7 14772.4   111.22289
      2246 640.32  2322.8 13165.6 14126.5   108.86219
      2247 640.51  2342.5 13032.5 14058.9   109.60190
      2248 640.70  2970.8 13493.7 14717.1   111.62663
      2249 640.89  2839.3 13481.8 14599.1   110.49918
      2250 641.08  2408.8 13020.6 14093.7   110.11270
      2251 641.27  2324.0 12982.5 14054.4   110.05688
      2252 641.46  2886.0 13294.6 14549.2   112.05336
      2253 641.66  2953.6 13444.5 14688.0   111.85336
      2254 641.85  2323.6 12919.4 14060.9   110.77351
      2255 642.04  2328.5 12785.5 13830.8   109.99608
      2256 642.23  3022.4 13345.8 14692.1   113.04158
      2257 642.42  2697.6 13039.8 14279.3   111.98415
      2258 642.61  2379.7 12873.9 13971.2   110.45627
      2259 642.80  2269.1 12581.1 13801.7   111.83667
      2260 642.99  2701.7 12998.9 14304.2   112.67702
      2261 643.18  3004.0 13269.6 14550.4   112.47655
      2262 643.38  2405.5 12802.7 13870.5   110.27025
      2263 643.57  2398.2 12746.6 13939.7   111.52979
      2264 643.76  2603.8 12851.8 13959.0   110.80336
      2265 643.95  3027.7 13167.6 14316.5   111.33058
      2266 644.14  2430.9 12801.4 13867.6   110.28082
      2267 644.33  2446.1 12724.8 13724.7   109.72703
      2268 644.52  3020.8 13312.2 14410.3   110.67022
      2269 644.71  2688.2 12914.5 14157.6   112.15605
      2270 644.90  2358.0 12668.7 13737.4   110.36428
      2271 645.09  2287.6 12558.1 13540.8   109.56730
      2272 645.29  2870.4 12971.8 14248.1   112.63482
      2273 645.48  2787.7 12831.8 14108.5   112.71104
      2274 645.67  2517.8 12698.6 13872.9   111.53444
      2275 645.86  2498.1 12669.1 13807.0   111.18718
      2276 646.05  2896.2 13052.1 14166.2   110.96995
      2277 646.24  3082.2 13249.9 14494.7   112.24219
      2278 646.43  2230.6 12592.5 13675.9   110.45538
      2279 646.62  2395.7 12638.8 13792.7   111.26440
      2280 646.81  2655.8 12815.0 13957.7   111.24863
      2281 647.00  2609.9 12845.3 13973.7   111.02484
      2282 647.19  2263.8 12474.2 13488.7   109.93661
      2283 647.38  2393.7 12675.3 13628.0   109.26619
      2284 647.57  2813.9 12892.8 14085.1   111.82997
      2285 647.77  2863.1 12943.6 14107.6   111.54769
      2286 647.96  2374.8 12643.7 13501.8   108.35627
      2287 648.15  2281.4 12431.6 13280.3   108.36124
      2288 648.34  2942.1 13166.4 14069.5   108.83342
      2289 648.53  3065.8 13141.8 14140.8   109.91464
      2290 648.72  2340.0 12516.4 13447.4   109.14872
      2291 648.91  2575.9 12717.9 13573.9   108.44069
      2292 649.10  2952.4 13128.3 13990.5   108.47287
      2293 649.29  2418.7 12549.5 13421.6   108.60758
      2294 649.48  2293.7 12405.8 13168.0   107.53807
      2295 649.67  2376.9 12547.9 13134.0   105.76272
      2296 649.86  3112.5 13106.6 13894.2   107.88115
      2297 650.05  2482.5 12469.3 13294.2   108.26018
      2298 650.24  2384.7 12438.5 13086.9   106.44912
      2299 650.43  2572.2 12510.6 13262.2   107.56264
      2300 650.62  2820.9 12518.8 13340.5   108.47236
      2301 650.81  3097.3 12834.6 13621.5   108.08060
      2302 651.01  2300.7 12147.3 12829.7   106.93011
      2303 651.20  2373.6 12091.2 12830.1   107.60379
      2304 651.39  2908.1 12515.5 13357.7   108.76534
      2305 651.58  3033.5 12554.5 13453.9   109.44719
      2306 651.77  2283.1 11873.7 12682.7   108.43477
      2307 651.96  2433.0 12132.6 12786.7   106.74381
      2308 652.15  2876.2 12352.5 13309.7   110.10115
      2309 652.34  2705.4 12066.2 12832.6   108.18675
      2310 652.53  2455.9 12062.5 12738.4   107.03505
      2311 652.72  2431.8 11885.6 12603.2   107.59067
      2312 652.91  2962.6 12255.5 13229.5   110.48131
      2313 653.10  2904.8 12107.6 13014.4   109.85402
      2314 653.29  2355.2 11705.4 12355.0   106.94761
      2315 653.48  2316.7 11625.1 12474.6   109.12611
      2316 653.67  2912.2 12139.5 12967.3   108.97106
      2317 653.86  2738.1 12009.7 12744.9   107.92985
      2318 654.05  2318.7 11672.6 12273.9   106.42816
      2319 654.24  2347.4 11636.1 12181.7   105.87354
      2320 654.43  2745.5 11926.6 12707.6   108.50769
      2321 654.62  2701.3 11821.7 12463.5   107.03732
      2322 654.81  2322.0 11675.1 12196.5   105.57478
      2323 655.00  2370.3 11540.7 12078.9   105.86895
      2324 655.19  2749.6 11873.7 12428.7   106.08279
      2325 655.38  2968.3 11959.7 12632.7   107.48451
      2326 655.57  2299.5 11486.6 12102.7   106.70531
      2327 655.76  2476.8 11547.7 12001.1   104.99864
      2328 655.95  2800.0 11859.0 12493.0   106.99914
      2329 656.14  2562.8 11585.8 12213.3   106.95446
      2330 656.33  2372.4 11531.3 12022.0   105.35754
      2331 656.52  2387.5 11504.3 12013.0   105.58001
      2332 656.71  2637.8 11714.0 12311.6   106.58423
      2333 656.90  2767.2 11676.7 12266.1   106.61548
      2334 657.09  2328.1 11412.5 11910.2   105.47815
      2335 657.28  2308.5 11348.6 11927.4   106.40207
      2336 657.47  2857.7 11632.1 12288.2   107.47829
      2337 657.66  2890.5 11837.3 12461.1   106.97249
      2338 657.85  2291.3 11263.0 11716.4   105.05387
      2339 658.04  2408.4 11448.6 11946.2   105.50496
      2340 658.23  2538.3 11468.2 12031.8   106.31135
      2341 658.42  2907.3 11711.9 12414.4   107.97822
      2342 658.61  2356.8 11290.0 11844.2   106.20357
      2343 658.80  2268.3 11180.3 11644.8   105.21187
      2344 658.99  2803.7 11498.5 12197.3   108.03656
      2345 659.18  3245.2 11956.9 12699.0   108.51944
      2346 659.37  2261.8 11032.8 11684.9   107.43439
      2347 659.56  2395.3 11136.0 11735.7   106.86035
      2348 659.75  2763.9 11564.5 12331.6   108.71730
      2349 659.94  2705.4 11317.1 12070.7   108.75149
      2350 660.13  2212.2 10966.1 11652.5   107.84205
      2351 660.32  2457.2 11176.2 11729.1   106.34190
      2352 660.51  2821.3 11427.7 12198.1   108.95202
      2353 660.70  2739.4 11268.3 12070.7   109.40786
      2354 660.89  2496.1 11204.8 11781.1   106.61743
      2355 661.08  2268.3 10931.2 11544.8   107.08274
      2356 661.27  2893.4 11473.1 12338.2   110.08259
      2357 661.46  2763.9 11331.4 12012.2   107.94569
      2358 661.65  2353.1 10955.4 11755.3   109.29912
      2359 661.84  2441.2 11115.6 11723.8   107.01200
      2360 662.03  2788.9 11286.8 12004.0   108.43978
      2361 662.22  2945.4 11395.3 12117.4   108.54581
      2362 662.41  2290.4 10925.5 11461.3   106.20434
      2363 662.60  2253.2 10844.4 11458.4   107.14660
      2364 662.78  2732.0 11091.4 11979.0   110.61787
      2365 662.97  2939.7 11280.2 12075.2   109.53199
      2366 663.16  2316.7 10967.3 11590.3   107.20170
      2367 663.35  2358.8 10922.2 11669.7   108.72914
      2368 663.54  2784.0 11213.0 12204.3   111.75956
      2369 663.73  3004.4 11446.1 12354.2   110.75692
      2370 663.92  2384.7 10825.2 11548.9   108.57475
      2371 664.11  2336.3 10845.6 11589.5   108.74127
      2372 664.30  2704.5 11042.2 11929.0   110.63568
      2373 664.49  2956.9 11220.0 12260.0   112.58550
      2374 664.68  2364.2 10792.0 11639.4   110.05541
      2375 664.87  2362.5 10769.4 11599.3   109.87089
      2376 665.06  2786.1 11209.8 12096.5   110.52708
      2377 665.25  2744.3 11109.8 12031.0   111.01155
      2378 665.44  2322.8 10836.6 11575.1   108.67410
      2379 665.63  2317.1 10776.4 11516.5   108.74932
      2380 665.82  2784.8 11084.0 12045.3   111.58327
      2381 666.01  3193.2 11431.4 12477.5   112.69825
      2382 666.19  2301.5 10724.8 11573.1   110.07050
      2383 666.38  2426.8 10812.0 11712.7   110.74151
      2384 666.57  3144.0 11441.2 12364.0   111.12209
      2385 666.76  2716.0 10984.1 11967.5   111.89437
      2386 666.95  2463.3 10928.0 11728.3   109.45514
      2387 667.14  2274.1 10760.8 11555.9   109.36775
      2388 667.33  2685.3 11122.1 11905.7   109.28731
      2389 667.52  3079.3 11451.8 12276.8   109.85274
      2390 667.71  2406.4 10957.5 11745.5   109.21588
      2391 667.90  2589.5 10986.5 11775.8   109.39954
      2392 668.09  3049.0 11279.0 12236.2   111.63092
      2393 668.28  2659.9 10926.3 11870.4   111.42106
      2394 668.46  2309.7 10633.5 11492.0   110.31395
      2395 668.65  2470.3 10871.0 11519.0   107.71331
      2396 668.84  3160.4 11421.5 12246.9   109.99057
      2397 669.03  2571.0 10825.2 11595.2   109.32910
      2398 669.22  2246.6 10692.0 11321.6   107.45430
      2399 669.41  2439.9 10762.1 11489.5   108.74101
      2400 669.60  3183.4 11376.5 12332.9   111.67326
      2401 669.79  2575.5 10708.0 11468.6   109.35281
      2402 669.98  2451.0 10732.2 11443.2   108.58641
      2403 670.17  2286.4 10530.7 11162.2   107.66098
      2404 670.35  2829.9 10922.2 11707.4   109.70289
      2405 670.54  2741.0 10749.8 11590.3   110.49455
      2406 670.73  2330.2 10509.8 11123.7   107.50626
      2407 670.92  2413.3 10543.4 11204.0   108.12634
      2408 671.11  2862.7 10836.6 11618.9   109.81097
      2409 671.30  2445.7 10413.5 11102.9   108.65162
      2410 671.49  2367.5 10451.2 11160.6   108.77584
      2411 671.68  2295.4 10328.3 10968.1   107.96451
      2412 671.87  2933.1 10913.2 11641.1   109.12077
      2413 672.05  2955.6 10846.0 11606.2   109.63455
      2414 672.24  2278.2 10311.1 10917.7   107.55149
      2415 672.43  2446.1 10465.5 11100.0   107.91154
      2416 672.62  2647.2 10598.6 11292.9   108.73126
      2417 672.81  2945.4 10906.7 11609.9   108.83368
      2418 673.00  2386.3 10465.5 10966.9   106.20533
      2419 673.19  2257.3 10340.2 10820.2   105.93899
      2420 673.38  2717.2 10677.7 11252.0   107.21380
      2421 673.57  2713.1 10597.8 11182.7   107.41818
      2422 673.75  2496.1 10644.1 11133.6   106.00713
      2423 673.94  2363.4 10358.6 10893.1   106.68545
      2424 674.13  2803.7 10651.9 11404.7   109.59240
      2425 674.32  2689.8 10580.2 11280.2   108.87147
      2426 674.51  2373.6 10364.0 10950.5   107.34057
      2427 674.70  2373.6 10402.9 10876.8   105.90216
      2428 674.89  2441.2 10311.5 10958.7   108.22274
      2429 675.07  2847.5 10710.1 11393.7   108.69452
      2430 675.26  2599.3 10621.6 11173.7   106.88248
      2431 675.45  2431.3 10400.0 10950.1   106.90310
      2432 675.64  2949.1 10725.6 11403.9   108.72221
      2433 675.83  2915.1 10794.4 11464.1   108.49924
      2434 676.02  2485.8 10523.3 10911.6   104.83107
      2435 676.21  2639.8 10605.2 11197.9   107.44075
      2436 676.39  2841.8 10561.0 11430.9   111.27029
      2437 676.58  2535.4 10379.9 10970.1   107.52401
      2438 676.77  2137.3 10047.7 10614.6   107.16616
      2439 676.96  2326.9 10180.5 10826.0   108.21945
      2440 677.15  2738.1 10410.2 11190.9   110.17564
      2441 677.34  3094.5 10760.0 11460.8   109.14240
      2442 677.52  2378.5 10130.1 10655.6   106.77938
      2443 677.71  2353.9 10079.7 10643.7   107.30038
      2444 677.90  2767.6 10488.5 11100.8   107.93104
      2445 678.09  2879.9 10520.8 11193.0   108.79657
      2446 678.28  2327.7 10109.2 10636.3   106.77440
      2447 678.47  2488.3 10227.6 10747.7   106.72135
      2448 678.65  2821.7 10434.8 11121.3   109.01707
      2449 678.84  3068.7 10635.9 11354.8   109.49932
      2450 679.03  2315.4 10003.9 10481.9   106.21704
      2451 679.22  2322.8 10054.7 10492.2   105.65769
      2452 679.41  2648.0 10232.1 10865.7   108.35494
      2453 679.60  2639.0 10328.3 10898.5   107.41490
      2454 679.78  2467.4 10126.4 10694.9   107.42286
      2455 679.97  2387.9 10112.5 10632.2   106.72889
      2456 680.16  2994.1 10564.2 11376.5   110.72935
      2457 680.35  2895.4 10488.5 11283.1   110.46499
      2458 680.54  2599.3 10368.9 10944.8   107.41210
      2459 680.73  2286.4 10024.0 10531.1   106.55338
      2460 680.91  2755.7 10533.5 11111.5   107.43062
      2461 681.10  2935.6 10642.9 11290.0   108.39666
      2462 681.29  2434.2 10259.1 10764.5   106.45937
      2463 681.48  2424.0 10302.1 10747.3   105.65145
      2464 681.67  2945.4 10658.9 11433.4   110.04142
      2465 681.85  2686.9 10337.3 11028.3   109.03202
      2466 682.04  2374.0 10223.5 10791.6   107.23753
      2467 682.23  2357.2 10223.5 10841.5   107.85733
      2468 682.42  2652.9 10448.3 11104.1   108.41215
      2469 682.61  2510.0 10327.5 10968.5   108.19972
      2470 682.79  2387.5 10290.2 10793.6   106.36986
      2471 682.98  2485.8 10356.6 10906.7   106.98896
      2472 683.17  2747.1 10586.0 11278.2   108.83061
      2473 683.36  2655.4 10488.1 11070.9   107.44129
      2474 683.55  2458.0 10332.4 10821.9   106.21586
      2475 683.73  2507.5 10448.3 10954.2   106.37024
      2476 683.92  2661.5 10510.6 11091.0   107.39447
      2477 684.11  2823.3 10526.6 11181.1   108.49684
      2478 684.30  2532.5 10377.5 10873.9   106.32800
      2479 684.49  2479.7 10253.4 10819.0   107.27646
      2480 684.67  2695.1 10486.0 11062.3   107.39708
      2481 684.86  2629.6 10416.0 10959.9   106.98580
      2482 685.05  2353.1 10117.0 10641.2   106.75284
      2483 685.24  2413.3 10101.0 10829.7   109.47840
      2484 685.42  3077.3 10597.4 11426.4   111.02397
      2485 685.61  2736.9 10366.8 11057.8   109.05625
      2486 685.80  2459.6 10114.1 10700.6   107.66268
      2487 685.99  2539.5 10220.2 10792.0   107.44454
      2488 686.18  2777.0 10305.8 10943.5   108.47071
      2489 686.36  2682.4 10262.0 10887.4   108.25181
      2490 686.55  2640.2 10243.1 10753.5   106.71264
      2491 686.74  2449.0 10033.8 10730.1   109.18025
      2492 686.93  2797.1 10216.9 10914.4   109.40105
      2493 687.11  2936.0 10351.7 11217.1   111.67080
      2494 687.30  2237.6  9847.9 10439.3   107.77179
      2495 687.49  2284.7  9847.9 10482.7   108.39425
      2496 687.68  2867.6 10253.0 11007.4   110.21573
      2497 687.86  2790.6 10223.0 11010.7   110.59738
      2498 688.05  2408.8  9847.9 10606.0   110.19161
      2499 688.24  2339.2  9925.3 10556.0   108.31488
      2500 688.43  3119.1 10418.4 11252.8   111.43033
      2501 688.61  2829.9 10128.8 11000.0   111.93603
      2502 688.80  2380.6  9837.6 10561.8   109.71107
      2503 688.99  2350.7  9704.5 10428.7   109.84738
      2504 689.18  3119.5 10358.6 11204.0   111.67816
      2505 689.36  2911.8 10190.3 11071.3   112.10467
      2506 689.55  2365.8  9657.4 10481.1   111.29648
      2507 689.74  2218.8  9425.2 10096.1   109.30998
      2508 689.93  2830.3 10070.7 10911.6   111.61396
      2509 690.11  2753.3  9856.1 10742.4   112.47910
      2510 690.30  2348.2  9702.0 10327.1   108.49950
      2511 690.49  2374.8  9488.2 10272.2   111.02091
      2512 690.68  3113.7 10178.8 11009.1   111.75141
      2513 690.86  2673.0  9615.6 10476.2   112.39527
      2514 691.05  2322.8  9398.1 10026.9   108.88618
      2515 691.24  2347.8  9328.5 10136.6   111.57659
      2516 691.43  2809.8  9623.0 10506.1   112.96140
      2517 691.61  2999.9  9827.0 10780.9   113.97289
      2518 691.80  2337.1  9269.9 10008.0   110.64634
      2519 691.99  2274.5  9147.9  9765.5   108.98635
      2520 692.17  2887.2  9590.6 10475.4   113.19808
      2521 692.36  2762.7  9444.8 10234.1   111.81194
      2522 692.55  2459.6  9251.9  9963.4   110.47458
      2523 692.74  2258.1  8905.4  9525.9   109.33515
      2524 692.92  2618.5  9243.7  9982.2   111.14682
      2525 693.11  2696.8  9223.2 10068.6   112.95344
      2526 693.30  2508.4  9140.5  9847.9   110.66577
      2527 693.49  2309.3  8924.2  9551.3   109.47988
      2528 693.67  2668.5  9080.3  9888.8   112.61019
      2529 693.86  2791.8  9273.6 10005.6   111.29226
      2530 694.05  2426.0  8947.2  9453.4   107.76333
      2531 694.23  2432.2  8886.1  9496.0   109.44977
      2532 694.42  3130.1  9378.1 10100.6   111.56417
      2533 694.61  2632.5  8877.9  9642.2   112.23765
      2534 694.79  2367.9  8817.3  9302.3   107.51937
      2535 694.98  2340.4  8735.4  9204.4   107.33363
      2536 695.17  2961.0  9226.5  9844.2   109.85814
      2537 695.36  2416.6  8672.3  9319.5   110.34507
      2538 695.54  2448.1  8687.5  9364.5   110.85145
      2539 695.73  2260.1  8542.9  9170.4   109.98760
      2540 695.92  2850.4  9000.8  9768.8   112.48668
      2541 696.10  2938.0  9027.0  9722.1   111.41530
      2542 696.29  2228.6  8453.6  9070.9   109.91578
      2543 696.48  2471.5  8665.4  9201.1   108.64966
      2544 696.66  3288.2  9258.9  9947.0   111.52500
      2545 696.85  2554.6  8557.6  9213.0   110.91703
      2546 697.04  2281.4  8375.4  8966.4   109.69889
      2547 697.22  2357.2  8429.0  8945.9   108.51322
      2548 697.41  2995.8  8930.8  9741.4   113.65770
      2549 697.60  2605.4  8517.1  9200.3   111.55686
      2550 697.79  2286.4  8293.5  8828.4   108.90496
      2551 697.97  2328.5  8329.5  8920.1   109.84235
      2552 698.16  2942.9  8834.5  9576.3   112.59037
      2553 698.35  2749.2  8574.8  9246.2   111.52359
      2554 698.53  2364.2  8335.2  8945.9   110.22774
      2555 698.72  2318.3  8237.8  8840.3   110.17851
      2556 698.91  3131.3  8852.1  9784.4   116.29555
      2557 699.09  2779.1  8497.0  9264.2   113.41691
      2558 699.28  2390.0  8267.6  8883.7   110.48084
      2559 699.47  2478.5  8278.7  8958.2   111.71527
      2560 699.65  2552.6  8246.8  9068.8   114.43676
      2561 699.84  3022.4  8641.2  9476.8   114.87099
      2562 700.03  2451.0  8172.6  8796.0   110.89556
      2563 700.21  2363.8  8116.1  8760.0   111.19340
      2564 700.40  2566.9  8271.7  8907.4   111.14301
      2565 700.59  2779.9  8280.3  9127.8   115.40697
      2566 700.77  2464.9  8058.3  8771.0   112.74167
      2567 700.96  2362.1  8033.0  8709.2   111.92488
      2568 701.15  2954.4  8624.8  9228.6   110.64721
      2569 701.33  2983.9  8482.3  9309.7   115.04767
      2570 701.52  2216.3  7867.9  8426.2   109.87826
      2571 701.70  2406.4  8018.6  8644.9   111.15896
      2572 701.89  3130.5  8537.2  9230.2   112.81817
      2573 702.08  2677.1  8079.2  8829.2   113.88278
      2574 702.26  2297.0  7816.7  8423.7   110.99733
      2575 702.45  2213.4  7781.1  8309.4   109.49018
      2576 702.64  2441.2  7945.7  8530.6   110.62579
      2577 702.82  2757.8  8222.2  8894.3   112.30042
      2578 703.01  2437.1  7915.4  8435.6   109.49533
      2579 703.20  2310.5  7798.7  8268.9   108.56781
      2580 703.38  3117.8  8524.5  9177.8   112.08333
      2581 703.57  2609.5  7998.1  8619.1   111.52326
      2582 703.76  2387.1  7934.6  8329.9   107.12493
      2583 703.94  2370.7  7901.5  8334.4   107.82790
      2584 704.13  2627.5  8097.3  8673.6   110.53616
      2585 704.31  2491.1  7840.0  8401.2   110.49084
      2586 704.50  2526.0  7966.2  8361.9   107.27299
      2587 704.69  2511.2  8009.2  8418.4   107.44245
      2588 704.87  2666.9  8104.2  8615.4   109.40113
      2589 705.06  2756.2  8099.3  8710.8   111.44499
      2590 705.25  2398.6  7848.2  8309.0   108.45547
      2591 705.43  2329.4  7767.1  8236.1   108.62459
      2592 705.62  2777.9  8149.7  8645.7   109.23370
      2593 705.80  2873.3  8217.7  8754.7   110.04753
      2594 705.99  2452.6  7892.9  8422.1   109.72745
      2595 706.18  2311.3  7851.5  8329.5   108.62781
      2596 706.36  2754.5  8083.3  8674.4   111.09145
      2597 706.55  2601.3  8085.4  8490.1   107.37918
      2598 706.73  2348.6  7921.5  8154.6   104.18198
      2599 706.92  2387.5  7840.0  8223.8   107.03876
      2600 707.11  2876.6  8338.1  8781.7   108.12209
      2601 707.29  3009.3  8509.7  8896.0   107.02212
      2602 707.48  2523.9  8047.7  8443.4   107.16299
      2603 707.66  2417.8  8044.0  8379.9   105.96972
      2604 707.85  2557.1  8075.1  8522.4   108.10569
      2605 708.04  2757.8  8202.9  8588.0   107.07086
      2606 708.22  2384.2  7935.5  8345.9   107.39320
      2607 708.41  2400.6  8014.1  8403.6   106.93908
      2608 708.59  3040.0  8422.1  8999.6   110.73059
      2609 708.78  2766.0  8199.7  8777.2   110.62867
      2610 708.97  2157.7  7686.8  8141.9   108.23025
      2611 709.15  2444.0  7953.5  8364.7   107.46415
      2612 709.34  2813.1  8275.4  8769.4   109.04319
      2613 709.52  2759.4  8203.8  8707.6   109.25370
      2614 709.71  2349.8  7955.1  8301.2   106.17465
      2615 709.90  2296.2  7909.7  8298.0   106.91719
      2616 710.08  2997.4  8538.0  9004.1   108.41279
      2617 710.27  2439.9  8021.5  8461.0   107.87407
      2618 710.45  2349.0  8023.1  8442.1   107.38469
      2619 710.64  2309.7  7976.8  8372.1   106.97456
      2620 710.82  2870.8  8425.3  8965.6   109.72644
      2621 711.01  2652.1  8218.9  8727.2   109.13105
      2622 711.20  2408.8  8066.5  8500.3   107.66670
      2623 711.38  2231.9  7935.1  8370.9   107.64147
      2624 711.57  2672.2  8322.1  8767.4   107.88023
      2625 711.75  2561.2  8160.3  8470.8   105.54499
      2626 711.94  2421.9  8192.7  8531.4   105.86983
      2627 712.12  2430.1  8089.9  8486.8   107.01259
      2628 712.31  2691.8  8310.7  8869.3   109.94314
      2629 712.50  2942.5  8497.8  8995.1   108.95081
      2630 712.68  2287.6  8012.9  8362.7   106.10960
      2631 712.87  2485.8  8218.9  8606.4   106.75860
      2632 713.05  2714.0  8385.6  8816.9   107.60453
      2633 713.24  2550.1  8158.3  8560.9   107.17938
      2634 713.42  2350.2  8011.2  8393.8   106.75784
      2635 713.61  2284.3  7959.6  8393.4   107.64290
      2636 713.79  2905.2  8521.6  8995.5   108.43786
      2637 713.98  2552.2  8150.5  8574.8   107.57975
      2638 714.17  2355.6  7937.1  8280.8   106.15689
      2639 714.35  2360.9  8031.7  8268.9   104.18202
      2640 714.54  2664.8  8205.4  8602.3   107.16344
      2641 714.72  2637.8  8109.1  8428.6   105.83920
      2642 714.91  2336.7  7966.6  8239.4   104.84541
      2643 715.09  2481.3  7917.0  8339.3   107.76882
      2644 715.28  2591.1  7957.6  8357.8   107.45688
      2645 715.46  3084.2  8462.6  8980.3   109.62609
      2646 715.65  2307.2  7733.9  8039.1   105.62308
      2647 715.83  2315.0  7729.4  8069.4   106.27883
      2648 716.02  3001.5  8259.0  8801.4   110.31474
      2649 716.21  2881.5  8039.1  8501.1   108.95805
      2650 716.39  2395.3  7792.1  8044.8   104.68275
      2651 716.58  2227.4  7509.5  7861.7   106.66872
      2652 716.76  2705.4  7796.2  8350.8   110.89388
      2653 716.95  2975.3  7993.6  8614.6   112.37349
      2654 717.13  2311.7  7424.3  7784.7   107.05016
      2655 717.32  2267.9  7367.4  7777.8   108.04819
      2656 717.50  3119.9  8032.1  8586.3   111.28160
      2657 717.69  2963.0  7807.7  8382.3   111.86168
      2658 717.87  2314.2  7360.8  7726.2   107.23968
      2659 718.06  2352.3  7301.0  7709.0   108.24366
      2660 718.24  2609.9  7460.3  7980.5   110.72454
      2661 718.43  2886.8  7618.0  8168.9   111.64402
      2662 718.61  2435.0  7317.4  7738.0   108.61578
      2663 718.80  2348.6  7205.6  7674.6   109.65593
      2664 718.98  2788.9  7529.2  8056.7   111.12936
      2665 719.17  2698.8  7373.1  7907.6   111.43533
      2666 719.35  2447.3  7301.0  7665.1   107.50209
      2667 719.54  2407.2  7087.6  7516.5   109.16252
      2668 719.72  2647.6  7287.1  7817.1   111.42405
      2669 719.91  2857.7  7400.1  7931.8   111.70425
      2670 720.09  2244.2  6973.7  7283.0   106.53849
      2671 720.28  2429.7  7046.2  7515.2   110.15882
      2672 720.46  2738.5  7258.0  7758.5   111.07487
      2673 720.65  3203.8  7551.7  8231.6   115.63826
      2674 720.83  2330.6  6951.6  7307.6   107.70254
      2675 721.02  2455.5  7026.6  7454.2   109.35484
      2676 721.20  3019.5  7391.1  7924.8   112.20838
      2677 721.39  2762.3  7164.6  7706.1   112.29996
      2678 721.57  2318.7  6835.3  7222.8   108.57895
      2679 721.76  2554.2  6977.8  7425.1   110.11113
      2680 721.94  2801.6  7136.4  7626.2   111.30114
      2681 722.13  2757.8  7063.4  7502.5   110.19788
      2682 722.31  2415.0  6953.3  7385.4   109.52165
      2683 722.50  2447.7  6942.6  7203.5   105.80462
      2684 722.68  2714.0  6965.6  7519.3   113.02505
      2685 722.87  3017.1  7333.0  7808.5   111.01831
      2686 723.05  2328.1  6802.5  7036.8   105.23619
      2687 723.24  3019.9  7361.6  7703.2   107.86794
      2688 723.42  2593.1  6994.2  7325.6   107.52908
      2689 723.61  3113.7  7337.1  7782.3   110.54213
      2690 723.79  2274.5  6672.3  6919.7   105.62542
      2691 723.98  2291.3  6669.4  7012.2   107.83048
      2692 724.16  3044.9  7245.3  7686.4   110.50218
      2693 724.34  2595.2  6774.7  7164.2   109.31986
      2694 724.53  2496.5  6786.1  7045.0   106.03456
      2695 724.71  2575.9  6869.3  7141.7   106.34421
      2696 724.90  2696.4  6887.7  7340.7   110.80818
      2697 725.08  2907.7  7073.3  7492.7   110.06883
      2698 725.27  2329.4  6672.7  6876.3   104.68691
      2699 725.45  2226.1  6622.3  6860.3   105.41321
      2700 725.64  2573.1  6802.5  7249.4   110.56557
      2701 725.82  3091.2  7207.2  7831.0   115.15573
      2702 726.01  2204.0  6454.8  6845.5   109.19251
      2703 726.19  2341.6  6506.8  6995.9   111.74157
      2704 726.38  2661.5  6822.2  7353.4   112.76828
      2705 726.56  2586.6  6662.5  7215.8   113.57652
      2706 726.74  2530.5  6709.1  7248.6   112.90923
      2707 726.93  2350.7  6500.3  7091.3   114.24342
      2708 727.11  3407.4  7362.9  8194.3   121.02104
      2709 727.30  2758.6  6871.8  7491.9   115.07668
      2710 727.48  2391.2  6610.4  7188.8   113.70740
      2711 727.67  2407.6  6693.6  7279.7   113.67547
      2712 727.85  2814.7  7026.6  7695.9   115.89030
      2713 728.04  3028.1  7171.2  7884.3   117.21207
      2714 728.22  2402.7  6743.6  7331.3   113.54029
      2715 728.40  2450.2  6788.6  7378.8   113.60459
      2716 728.59  2884.4  7019.2  7752.8   117.74145
      2717 728.77  2786.5  7030.7  7675.0   115.18047
      2718 728.96  2287.2  6669.4  7287.5   114.10412
      2719 729.14  2342.1  6738.6  7280.5   112.32533
      2720 729.33  3312.0  7547.6  8356.1   119.08906
      2721 729.51  2873.7  7181.4  7858.1   115.70791
      2722 729.69  2491.1  6981.9  7496.8   111.46479
      2723 729.88  2326.1  6832.4  7395.6   112.49774
      2724 730.06  2836.4  7197.0  7949.8   117.26469
      2725 730.25  2857.7  7215.8  7939.6   116.60714
      2726 730.43  2344.1  6854.6  7473.9   113.73048
      2727 730.61  2410.9  6988.5  7606.6   113.50215
      2728 730.80  2764.8  7234.2  7894.5   114.77272
      2729 730.98  3019.5  7537.3  8211.9   114.93201
      2730 731.17  2438.3  7058.1  7611.5   111.97803
      2731 731.35  2322.4  7005.3  7504.6   110.66212
      2732 731.54  2788.5  7248.6  7940.8   115.52024
      2733 731.72  2957.7  7526.3  8202.1   114.79291
      2734 731.90  2322.8  6989.3  7537.8   111.75283
      2735 732.09  2408.0  7036.8  7619.3   112.58295
      2736 732.27  2981.4  7575.8  8232.0   114.28189
      2737 732.46  3050.2  7633.2  8348.3   115.60462
      2738 732.64  2358.8  7039.3  7703.6   114.19445
      2739 732.82  2326.9  7029.9  7507.4   110.15502
      2740 733.01  2796.7  7441.9  8073.5   113.59667
      2741 733.19  2918.8  7423.9  8060.0   114.11946
      2742 733.38  2182.3  6870.9  7298.6   109.12030
      2743 733.56  2469.0  7154.4  7694.6   111.53072
      2744 733.74  2876.6  7425.5  8044.0   113.59626
      2745 733.93  2942.1  7410.8  8044.8   114.18881
      2746 734.11  2383.8  6986.4  7454.6   110.17174
      2747 734.29  2265.9  6905.3  7421.4   111.12386
      2748 734.48  2893.8  7328.9  7983.4   114.75804
      2749 734.66  2733.6  7173.2  7825.3   114.68772
      2750 734.85  2239.2  6738.6  7273.2   111.87984
      2751 735.03  2295.0  6748.9  7310.8   112.61726
      2752 735.21  2799.6  7070.8  7667.2   113.96240
      2753 735.40  3164.5  7422.7  8103.4   115.98692
      2754 735.58  2425.6  6753.0  7333.0   113.40275
      2755 735.77  2362.1  6732.1  7233.0   111.46311
      2756 735.95  2979.8  7133.5  7832.7   116.83265
      2757 736.13  2656.2  6934.4  7439.0   111.79513
      2758 736.32  2242.5  6583.8  7026.6   110.19908
      2759 736.50  2412.9  6714.5  7150.3   110.13141
      2760 736.68  2639.0  6739.0  7301.8   113.72628
      2761 736.87  3013.8  7137.6  7755.7   114.98808
      2762 737.05  2391.6  6560.1  7021.7   111.07399
      2763 737.23  2421.5  6675.6  7113.4   110.29271
      2764 737.42  2877.4  6938.1  7574.6   115.67478
      2765 737.60  2735.3  6884.5  7381.7   111.98421
      2766 737.79  2414.6  6582.2  6924.2   108.20637
      2767 737.97  2290.4  6458.9  6845.5   109.27581
      2768 738.15  2968.7  6954.5  7481.2   113.21551
      2769 738.34  2776.2  6821.4  7376.8   113.73025
      2770 738.52  2421.9  6554.3  6887.3   108.05829
      2771 738.70  2478.9  6586.7  6993.4   109.90130
      2772 738.89  2961.4  7009.4  7521.4   112.64798
      2773 739.07  2714.8  6741.9  7258.4   112.82547
      2774 739.25  2506.3  6598.6  7037.2   110.71965
      2775 739.44  2381.8  6551.9  6911.1   108.61407
      2776 739.62  3058.8  7036.0  7505.8   111.81256
      2777 739.80  2653.8  6650.6  7121.2   111.77495
      2778 739.99  2267.1  6333.5  6669.4   108.25947
      2779 740.17  2453.1  6525.2  6920.9   109.71637
      2780 740.35  3156.7  7122.4  7616.8   112.46642
      2781 740.54  2990.0  6945.1  7459.5   113.00744
      2782 740.72  2309.3  6425.7  6728.0   107.34328
      2783 740.90  2292.1  6346.7  6824.2   111.77896
      2784 741.09  2560.0  6526.1  6992.2   111.75256
      2785 741.27  2777.0  6710.4  7196.2   112.35033
      2786 741.45  2471.9  6461.3  6919.7   111.48872
      2787 741.64  2298.6  6327.0  6760.3   110.75749
      2788 741.82  2895.0  6701.8  7350.2   117.03250
      2789 742.00  2784.8  6601.4  7181.4   115.19640
      2790 742.19  2424.0  6368.0  6882.4   113.04394
      2791 742.37  2390.8  6341.7  6878.7   113.59112
      2792 742.55  2686.5  6500.7  7136.8   116.67743
      2793 742.74  2797.5  6552.3  7201.9   117.30120
      2794 742.92  2349.8  6264.7  6787.0   113.33961
      2795 743.10  2559.6  6377.8  7004.9   116.42351
      2796 743.29  2995.4  6709.1  7445.6   119.83014
      2797 743.47  3017.9  6755.4  7374.3   116.55890
      2798 743.65  2344.1  6174.6  6748.5   114.98076
      2799 743.83  2488.7  6329.0  6836.9   113.22525
      2800 744.02  2823.7  6475.7  7247.4   121.13056
      2801 744.20  2702.5  6415.9  7039.3   116.78801
      2802 744.38  2267.9  6073.9  6614.5   114.20575
      2803 744.57  2331.8  6146.0  6590.0   111.64090
      2804 744.75  2612.8  6272.1  6868.9   116.30848
      2805 744.93  2709.1  6357.3  6918.0   115.36991
      2806 745.12  2391.6  6148.8  6646.1   113.23450
      2807 745.30  2381.0  6108.3  6538.3   111.53845
      2808 745.48  3321.4  6923.8  7499.3   115.97498
      2809 745.66  2556.3  6197.2  6665.7   112.86986
      2810 745.85  2297.0  6048.5  6300.8   106.72563
      2811 746.03  2332.6  6031.3  6429.8   110.77520
      2812 746.21  3047.8  6522.0  7067.5   115.70385
      2813 746.40  2759.0  6346.2  6772.2   111.87484
      2814 746.58  2440.4  6074.3  6410.1   109.24257
      2815 746.76  2312.2  5995.2  6306.1   108.44082
      2816 746.94  3049.4  6578.9  7029.9   112.77707
      2817 747.13  2886.8  6486.7  6873.4   110.74071
      2818 747.31  2285.9  5992.8  6206.6   105.76796
      2819 747.49  2458.0  6121.0  6469.9   109.52701
      2820 747.68  2832.8  6363.4  6775.5   111.67055
      2821 747.86  2999.9  6480.6  6953.3   113.57969
      2822 748.04  2309.3  5964.9  6260.6   108.08962
      2823 748.22  2301.5  5928.5  6179.1   106.91134
      2824 748.41  3015.8  6415.1  6814.0   111.73638
      2825 748.59  2965.9  6397.0  6933.2   115.62611
      2826 748.77  2277.3  5797.8  6155.4   110.15706
      2827 748.95  2458.4  6006.7  6356.9   109.86957
      2828 749.14  2635.3  6071.4  6572.8   114.59054
      2829 749.32  2829.9  6286.4  6761.6   113.74571
      2830 749.50  2380.1  5853.5  6249.2   111.39152
      2831 749.68  2268.7  5729.8  6039.9   108.95857
      2832 749.87  2643.5  6072.6  6517.0   112.95986
      2833 750.05  2828.2  6201.7  6633.0   112.78533
      2834 750.23  2369.1  5789.6  6189.4   111.68721
      2835 750.42  2391.2  5876.0  6156.2   108.03949
      2836 750.60  2742.6  6055.4  6545.7   114.79971
      2837 750.78  2718.5  6080.8  6566.6   114.44755
      2838 750.96  2500.2  5826.1  6323.3   114.95071
      2839 751.15  2527.2  5934.6  6331.5   111.64802
      2840 751.33  2475.6  5806.4  6303.2   114.91637
      2841 751.51  3015.0  6279.1  6785.7   115.52267
      2842 751.69  2420.7  5839.6  6232.0   111.47718
      2843 751.87  2372.4  5754.4  6134.1   111.22682
      2844 752.06  2557.1  5898.1  6288.1   111.67095
      2845 752.24  2762.7  6042.7  6503.1   114.03595
      2846 752.42  2356.8  5716.3  5985.0   107.99806
      2847 752.60  2255.6  5595.1  5977.6   111.45589
      2848 752.79  3107.2  6265.1  6742.7   115.12321
      2849 752.97  2871.3  6064.4  6590.8   116.48281
      2850 753.15  2303.1  5675.7  5980.5   109.03568
      2851 753.33  2402.3  5695.0  5998.9   109.23002
      2852 753.52  2693.5  5903.9  6370.4   114.53179
      2853 753.70  2813.5  5921.9  6418.7   115.98369
      2854 753.88  2337.6  5586.9  5943.2   110.96683
      2855 754.06  2430.1  5679.8  6075.5   112.17543
      2856 754.24  2658.3  5826.1  6292.6   114.72720
      2857 754.43  3060.1  6169.3  6642.8   115.22855
      2858 754.61  2357.6  5574.6  5892.0   109.86758
      2859 754.79  2349.8  5539.3  5893.2   111.09541
      2860 754.97  2673.0  5833.0  6288.5   114.41347
      2861 755.16  2981.4  6043.6  6577.7   117.44247
      2862 755.34  2474.8  5676.6  6057.1   111.88433
      2863 755.52  2493.6  5718.7  6110.7   112.15392
      2864 755.70  2853.6  5939.5  6406.5   115.13141
      2865 755.88  2595.6  5766.3  6204.5   113.82249
      2866 756.07  2363.8  5627.0  6000.5   111.44721
      2867 756.25  2333.0  5638.5  6037.8   112.08176
      2868 756.43  2893.4  6061.6  6642.4   118.33226
      2869 756.61  2564.9  5817.1  6309.0   115.12597
      2870 756.79  2466.2  5840.4  6127.9   108.52149
      2871 756.98  2264.6  5626.6  5980.9   110.53851
      2872 757.16  2851.6  6057.1  6563.7   115.80631
      2873 757.34  2563.6  5801.1  6298.7   115.37198
      2874 757.52  2338.4  5723.7  6052.6   109.71568
      2875 757.70  2377.3  5786.3  6216.0   112.60363
      2876 757.89  2957.7  6271.7  6732.1   113.89196
      2877 758.07  3376.3  6536.7  7108.9   118.10522
      2878 758.25  2409.6  5853.5  6209.4   110.33540
      2879 758.43  2248.3  5746.2  6057.9   108.91101
      2880 758.61  2861.8  6178.7  6708.3   115.96688
      2881 758.80  2897.9  6242.6  6781.6   116.11562
      2882 758.98  2469.0  5915.8  6232.0   109.17408
      2883 759.16  2404.7  5861.3  6240.6   110.97284
      2884 759.34  2955.6  6417.5  6888.1   113.59441
      2885 759.52  2682.8  6215.2  6606.7   111.08532
      2886 759.70  2412.5  5966.1  6344.6   110.65005
      2887 759.89  2431.8  5969.4  6396.6   112.07597
      2888 760.07  2735.3  6242.2  6675.6   112.35692
      2889 760.25  2741.4  6282.3  6734.5   112.77037
      2890 760.43  2228.6  5936.2  6293.4   109.63324
      2891 760.61  2430.9  6122.2  6537.1   111.24056
      2892 760.79  2674.6  6397.4  6901.7   113.54385
      2893 760.98  2752.5  6473.2  6990.1   113.89255
      2894 761.16  2407.2  6323.3  6734.1   110.49055
      2895 761.34  2476.8  6455.2  6886.1   110.83083
      2896 761.52  2398.2  6544.1  7053.6   112.29007
      2897 761.70  2775.4  6924.2  7559.1   115.30261
      2898 761.88  2381.0  6827.9  7306.3   110.75802
      2899 762.07  2352.7  6928.7  7386.2   109.99821
      2900 762.25  3099.0  7609.4  8206.2   113.23102
      2901 762.43  2784.0  7454.2  8012.5   111.95404
      2902 762.61  2338.0  7328.5  7774.1   108.92974
      2903 762.79  2258.5  7381.7  7842.1   108.98624
      2904 762.97  2770.9  7799.9  8503.2   113.98435
      2905 763.15  2588.6  7811.4  8537.2   113.89697
      2906 763.34  2275.3  7672.1  8191.1   109.61596
      2907 763.52  2303.6  7794.2  8366.8   110.42896
      2908 763.70  2992.5  8436.0  9169.2   113.46878
      2909 763.88  2928.6  8384.8  9138.9   113.82028
      2910 764.06  2479.3  8226.7  8717.4   108.53764
      2911 764.24  2257.7  7997.3  8525.7   109.20574
      2912 764.42  2885.6  8495.4  9273.6   113.87266
      2913 764.61  2686.1  8381.9  9041.4   111.57774
      2914 764.79  2259.7  8101.4  8633.4   109.10811
      2915 764.97  2446.5  8228.3  8835.8   110.50580
      2916 765.15  2586.2  8197.6  8943.1   113.28468
      2917 765.33  3001.1  8568.3  9340.0   113.86108
      2918 765.51  2390.0  8030.1  8657.2   111.11839
      2919 765.69  2625.9  8137.8  8793.2   111.88972
      2920 765.87  2983.9  8285.3  9024.2   113.93805
      2921 766.06  2950.7  8171.4  8814.9   112.32544
      2922 766.24  2301.1  7560.7  8057.5   109.44630
      2923 766.42  2265.9  7438.6  7936.3   109.62071
      2924 766.60  2825.8  7632.8  8310.7   114.10189
      2925 766.78  3074.0  7748.3  8346.3   112.79355
      2926 766.96  2512.0  7182.2  7709.8   111.29627
      2927 767.14  2379.3  6941.8  7412.8   110.32409
      2928 767.32  2945.8  7274.8  7883.9   114.06943
      2929 767.50  2577.2  6802.9  7421.4   114.63602
      2930 767.69  2428.1  6635.8  7041.7   109.64666
      2931 767.87  2485.0  6619.9  7035.2   110.04457
      2932 768.05  3034.3  6938.1  7481.6   113.92296
      2933 768.23  2648.4  6471.6  6970.1   113.03837
      2934 768.41  2564.9  6389.7  6778.8   110.17351
      2935 768.59  2278.2  6073.0  6404.0   108.72097
      2936 768.77  2797.5  6387.2  6925.8   115.00457
      2937 768.95  2753.3  6254.1  6831.6   116.49701
      2938 769.13  2325.7  5920.3  6228.3   108.56884
      2939 769.32  2348.6  5874.0  6181.2   108.71383
      2940 769.50  2888.9  6269.7  6695.2   112.58781
      2941 769.68  2843.0  6198.8  6612.1   112.31539
      2942 769.86  2439.9  5839.6  6151.3   109.16868
      2943 770.04  2310.9  5737.6  5950.6   106.21564
      2944 770.22  2491.6  5769.5  6069.4   109.14655
      2945 770.40  2781.1  6023.5  6342.1   109.82820
      2946 770.58  2238.0  5539.8  5767.9   106.90982
      2947 770.76  2299.1  5542.6  5706.5   105.05113
      2948 770.94  3056.8  6045.6  6466.3   114.07428
      2949 771.12  2560.0  5600.4  6011.6   113.52553
      2950 771.30  2305.6  5511.5  5742.9   107.21859
      2951 771.49  2482.5  5616.8  5853.5   107.55358
      2952 771.67  2860.2  5837.5  6154.1   110.63420
      2953 771.85  2782.8  5804.4  6109.1   110.08541
      2954 772.03  2367.9  5524.6  5645.0   103.81473
      2955 772.21  2399.8  5477.9  5653.2   105.69527
      2956 772.39  2754.9  5641.7  6003.4   112.52840
      2957 772.57  2941.7  5862.1  6241.0   112.97334
      2958 772.75  2294.1  5251.0  5450.1   106.73222
      2959 772.93  2446.5  5390.3  5629.0   108.11186
      2960 773.11  2960.1  5791.7  6213.5   114.89944
      2961 773.29  2835.6  5664.7  6003.0   111.95887
      2962 773.47  2385.5  5273.5  5530.7   108.90651
      2963 773.65  2466.6  5337.0  5539.8   107.06332
      2964 773.83  3024.0  5736.0  6070.6   112.33952
      2965 774.01  2625.1  5353.4  5649.9   110.86924
      2966 774.19  2410.1  5239.1  5431.6   106.80469
      2967 774.38  2541.9  5284.2  5524.6   108.76775
      2968 774.56  3096.1  5652.8  6036.2   114.99520
      2969 774.74  2931.1  5503.7  5846.5   113.32591
      2970 774.92  2342.5  5058.1  5244.8   106.87784
      2971 775.10  2363.8  5053.2  5289.9   108.80292
      2972 775.28  2600.1  5147.0  5483.6   113.21968
      2973 775.46  3055.2  5518.9  5944.8   117.29013
      2974 775.64  2311.7  4873.3  5115.8   109.46596
      2975 775.82  2332.2  4854.1  5176.4   112.78219
      2976 776.00  2484.2  4938.5  5312.0   115.22027
      2977 776.18  2640.2  4981.5  5492.7   121.83345
      2978 776.36  2314.6  4791.4  5131.8   113.74233
      2979 776.54  2530.1  4966.3  5356.3   116.00537
      2980 776.72  2729.9  5043.3  5483.6   119.03327
      2981 776.90  2797.1  5065.0  5602.8   123.71323
      2982 777.08  2336.3  4762.8  5115.4   114.53409
      2983 777.26  2411.3  4818.5  5154.3   113.95270
      2984 777.44  2697.6  4946.3  5493.1   124.31695
      2985 777.62  2899.9  5100.3  5717.1   128.03430
      2986 777.80  2339.6  4694.4  5056.0   115.35918
      2987 777.98  2414.1  4708.3  5145.3   119.05019
      2988 778.16  2714.0  4834.0  5377.1   125.61827
      2989 778.34  2906.1  4998.7  5570.1   127.30475
      2990 778.52  2527.6  4719.3  5142.4   119.30483
      2991 778.70  2401.4  4613.3  5033.9   119.01853
      2992 778.88  2766.8  4824.2  5392.7   127.63289
      2993 779.06  2559.6  4704.2  5233.4   124.67532
      2994 779.24  2360.5  4604.2  5051.9   119.95254
      2995 779.42  2474.8  4658.3  5081.8   119.39598
      2996 779.60  3049.8  5056.4  5640.9   129.12838
      2997 779.78  2834.4  4920.4  5446.8   125.23071
      2998 779.96  2290.4  4412.6  4841.4   120.20847
      2999 780.14  2351.9  4586.2  4925.0   115.16040
      3000 780.32  2861.0  4856.6  5358.7   125.16420
      3001 780.50  3020.8  5018.3  5549.6   126.59421
      3002 780.68  2382.2  4497.7  4914.3   119.69023
      3003 780.86  2387.9  4548.5  4840.2   113.49760
      3004 781.04  2810.6  4816.4  5317.8   124.99490
      3005 781.22  2669.3  4707.1  5093.7   118.97490
      3006 781.40  2498.1  4682.9  4952.0   112.31721
      3007 781.58  2319.9  4447.4  4795.5   116.36505
      3008 781.76  2772.1  4795.1  5224.0   121.19864
      3009 781.94  2908.5  4946.7  5320.6   118.34806
      3010 782.12  2440.4  4538.3  4871.3   115.87267
      3011 782.30  2539.5  4696.0  4996.6   113.94113
      3012 782.48  2877.0  4802.5  5294.8   125.56898
      3013 782.66  2909.3  4766.4  5305.1   129.00310
      3014 782.84  2419.9  4508.8  4886.5   118.07841
      3015 783.02  2471.9  4513.7  4900.0   118.91675
      3016 783.20  2968.3  4869.2  5332.5   124.36978
      3017 783.38  2963.4  4858.2  5364.0   126.69698
      3018 783.56  2306.4  4271.2  4703.8   122.01375
      3019 783.74  2305.6  4307.7  4691.1   119.14895
      3020 783.92  2727.9  4515.4  5006.1   127.45185
      3021 784.10  2890.9  4664.5  5282.1   134.82677
      3022 784.28  2417.8  4408.0  4765.2   117.94609
      3023 784.46  2413.3  4382.2  4769.3   119.65882
      3024 784.64  2856.9  4691.9  5210.4   128.25895
      3025 784.82  2834.0  4611.2  5136.3   129.54603
      3026 785.00  2322.8  4243.4  4684.9   122.98997
      3027 785.18  2281.4  4247.5  4621.4   119.02083
      3028 785.36  2973.7  4828.3  5316.5   126.32511
      3029 785.54  2489.9  4345.8  4813.5   125.20414
      3030 785.72  2416.2  4344.6  4782.4   122.70605
      3031 785.90  2339.2  4335.1  4723.0   119.43365
      3032 786.08  2544.8  4434.7  4875.8   123.34197
      3033 786.26  2756.6  4603.8  5076.1   125.56538
      3034 786.43  2465.8  4434.7  4768.1   116.93362
      3035 786.61  2424.8  4459.7  4745.6   114.04990
      3036 786.79  3087.1  4980.7  5461.5   125.39476
      3037 786.97  3123.2  5011.4  5517.6   126.81122
      3038 787.15  2409.2  4417.9  4820.5   120.04488
      3039 787.33  2308.9  4394.1  4739.8   116.57827
      3040 787.51  2655.8  4564.9  5030.2   124.37248
      3041 787.69  3024.4  4946.3  5357.1   121.37683
      3042 787.87  2347.4  4478.9  4766.0   113.47040
      3043 788.05  2356.0  4416.6  4764.4   116.87537
      3044 788.23  3432.0  5260.0  5824.8   130.89851
      3045 788.41  2697.2  4678.4  5066.3   119.57824
      3046 788.59  2465.3  4641.5  4852.0   109.67442
      3047 788.77  2426.8  4580.9  4882.4   113.99505
      3048 788.95  2856.9  4799.6  5243.2   122.83364
      3049 789.13  2803.3  4783.6  5217.0   121.88216
      3050 789.30  2421.9  4504.3  4866.0   117.36825
      3051 789.48  2291.7  4364.2  4704.6   116.42296
      3052 789.66  2862.2  4821.3  5328.0   125.86246
      3053 789.84  2833.6  4768.9  5309.2   127.91534
      3054 790.02  2383.8  4467.0  4831.6   117.49905
      3055 790.20  2194.2  4270.4  4607.5   116.23597
      3056 790.38  2885.2  4811.5  5312.8   126.02595
      3057 790.56  2713.6  4631.3  5093.3   124.09223
      3058 790.74  2369.1  4331.5  4785.7   123.14754
      3059 790.92  2409.2  4495.3  4820.9   115.60966
      3060 791.10  2989.6  4885.6  5316.1   122.70469
      3061 791.28  3004.8  4904.9  5320.6   121.87974
      3062 791.45  2600.9  4555.5  4870.9   116.13578
      3063 791.63  2221.2  4258.1  4522.3   112.97004
      3064 791.81  3212.4  4986.4  5425.9   124.77488
      3065 791.99  2924.1  4681.2  5190.0   128.95103
      3066 792.17  2332.2  4256.1  4535.4   114.51991
      3067 792.35  2367.5  4247.5  4537.5   115.42487
      3068 792.53  2408.8  4211.0  4547.7   118.68182
      3069 792.71  2941.3  4656.7  5084.7   124.95228
      3070 792.89  2321.6  4099.2  4466.2   120.64516
      3071 793.07  2541.9  4354.8  4630.0   115.18301
      3072 793.24  2786.1  4433.4  4802.1   122.37690
      3073 793.42  3061.7  4793.9  5195.7   123.19700
      3074 793.60  2360.5  4079.1  4458.8   122.09251
      3075 793.78  2381.0  4152.9  4452.7   116.92096
      3076 793.96  2747.6  4374.9  4791.0   125.57260
      3077 794.14  2817.6  4424.8  4861.9   127.19167
      3078 794.32  2367.9  4116.0  4419.1   117.33830
      3079 794.50  2419.5  4139.4  4422.0   116.43250
      3080 794.67  2846.7  4413.0  4850.4   127.92887
      3081 794.85  2703.7  4321.6  4740.6   125.89870
      3082 795.03  2454.7  4132.8  4529.7   123.65143
      3083 795.21  2399.4  4148.4  4457.2   117.65803
      3084 795.39  2794.2  4401.9  4807.4   125.22295
      3085 795.57  2863.9  4503.5  4894.2   123.83217
      3086 795.75  2428.9  4163.5  4485.9   118.58328
      3087 795.93  2434.2  4191.0  4565.7   121.33369
      3088 796.10  3173.1  4721.8  5264.1   135.01718
      3089 796.28  2681.2  4335.1  4775.9   126.64687
      3090 796.46  2286.8  4009.1  4385.5   121.85489
      3091 796.64  2421.5  4122.6  4477.3   120.85238
      3092 796.82  2996.2  4631.3  5098.6   128.58212
      3093 797.00  3016.2  4570.2  5065.9   131.89249
      3094 797.18  2384.2  4118.1  4435.1   118.28486
      3095 797.35  2313.0  4093.9  4402.3   117.31830
      3096 797.53  2807.8  4408.5  4904.5   130.98770
      3097 797.71  2885.2  4487.5  4893.8   125.35787
      3098 797.89  2580.0  4283.5  4665.3   122.40928
      3099 798.07  2410.9  4104.5  4449.8   120.38691
      3100 798.25  2822.5  4399.4  4850.4   128.59744
      3101 798.43  3049.4  4617.8  5140.4   133.32464
      3102 798.60  2395.3  4123.0  4473.2   120.27023
      3103 798.78  2429.7  4132.0  4418.3   116.81905
      3104 798.96  3164.9  4776.7  5188.3   125.54005
      3105 799.14  2605.8  4180.7  4680.0   131.70352
      3106 799.32  2271.2  3958.7  4230.7   116.11648
      3107 799.50  2462.9  4118.1  4418.7   118.16376
      3108 799.67  2735.7  4311.8  4674.7   123.02496
      3109 799.85  2855.7  4305.2  4730.0   129.30209
      3110 800.03  2431.3  4043.5  4353.2   119.20725
      3111 800.21  2443.2  4013.2  4400.7   124.68036
      3112 800.39  2884.4  4336.0  4795.1   131.63096
      3113 800.57  2908.5  4352.3  4789.4   130.26954
      3114 800.74  2436.3  3996.8  4285.2   118.47769
      3115 800.92  2452.2  4017.3  4272.9   116.33077
      3116 801.10  2736.5  4204.1  4572.7   125.11867
      3117 801.28  2553.4  4020.2  4349.1   122.42384
      3118 801.46  2279.8  3839.1  4096.3   116.49594
      3119 801.64  2355.2  3892.0  4145.5   116.49783
      3120 801.81  3123.2  4462.5  4934.0   135.19873
      3121 801.99  2720.1  4100.0  4544.4   132.20547
      3122 802.17  2485.4  4005.4  4299.1   119.32096
      3123 802.35  2473.1  3959.1  4243.4   119.12899
      3124 802.53  2745.1  4123.8  4511.3   128.10459
      3125 802.70  2209.8  3689.6  4023.8   122.58515
      3126 802.88  2326.9  3799.4  4091.0   119.80523
      3127 803.06  2269.1  3729.8  4029.6   120.52715
      3128 803.24  2825.0  4133.6  4607.1   136.18158
      3129 803.42  2882.7  4281.1  4647.3   126.18631
      3130 803.59  2352.7  3794.9  4087.7   120.30676
      3131 803.77  2215.5  3661.4  3953.8   120.22656
      3132 803.95  3187.0  4459.7  4948.7   138.42935
      3133 804.13  2956.4  4215.1  4671.8   136.28378
      3134 804.31  2444.5  3815.4  4187.3   127.12877
      3135 804.48  2408.8  3828.9  4139.8   121.89216
      3136 804.66  2960.1  4217.6  4678.8   136.67747
      3137 804.84  2566.1  3876.0  4315.5   133.55221
      3138 805.02  2458.4  3863.3  4154.5   120.72886
      3139 805.20  2471.9  3862.5  4171.7   122.23856
      3140 805.37  2732.4  3972.2  4408.0   135.15034
      3141 805.55  2852.4  4066.0  4559.6   140.66829
      3142 805.73  2449.0  3763.3  4105.4   126.02059
      3143 805.91  2493.2  3859.6  4164.7   122.33211
      3144 806.08  2994.1  4148.0  4688.6   146.85837
      3145 806.26  2802.0  4012.8  4534.2   143.06497
      3146 806.44  2374.0  3679.4  4035.7   127.29834
      3147 806.62  2295.4  3698.6  3980.8   120.11090
      3148 806.80  2820.9  4072.2  4474.4   132.14402
      3149 806.97  2736.1  4011.6  4412.6   131.43864
      3150 807.15  2431.3  3756.0  4109.9   126.71612
      3151 807.33  2517.4  3898.9  4301.1   129.11354
      3152 807.51  2981.0  4206.1  4659.1   136.97762
      3153 807.68  2344.9  3690.4  4035.7   125.66205
      3154 807.86  2417.8  3786.7  4150.8   126.60086
      3155 808.04  2367.5  3685.1  4050.5   127.72773
      3156 808.22  2833.2  4010.7  4506.8   142.12174
      3157 808.39  4364.6  5334.1  6019.4   170.68028
      3158 808.57  2407.2  3752.7  4062.8   123.04410
      3159 808.75  2449.4  3758.0  4130.8   128.48198
      3160 808.93  2784.0  4039.4  4459.7   133.47470
      3161 809.10  2595.6  3887.5  4263.1   129.07425
      3162 809.28  2415.4  3716.7  4061.1   126.47147
      3163 809.46  2386.7  3711.3  4003.0   122.01610
      3164 809.64  3059.3  4246.7  4710.7   139.08248
      3165 809.81  2582.9  3863.7  4246.7   129.90084
      3166 809.99  2430.9  3791.6  4061.9   119.86757
      3167 810.17  2270.8  3608.1  3890.3   121.10261
      3168 810.35  3294.4  4443.7  4948.7   143.94155
      3169 810.52  2809.8  3973.5  4457.2   141.56985
      3170 810.70  2399.8  3762.9  4079.6   123.22717
      3171 810.88  2427.7  3721.6  4054.2   125.70432
      3172 811.06  2836.8  4086.1  4494.5   132.68853
      3173 811.23  3022.0  4225.0  4748.4   143.51372
      3174 811.41  2326.5  3678.6  3960.4   120.84221
      3175 811.59  2185.2  3484.4  3818.6   125.72514
      3176 811.77  2974.5  4133.6  4617.4   141.73144
      3177 811.94  2594.8  3823.1  4190.1   129.87662
      3178 812.12  2538.3  3798.2  4127.5   126.13780
      3179 812.30  2430.1  3725.7  3993.9   120.70820
      3180 812.47  2877.8  4048.8  4459.2   135.04724
      3181 812.65  3010.1  4165.2  4583.4   136.20564
      3182 812.83  2418.7  3755.6  4027.1   120.31253
      3183 813.01  2422.7  3716.7  4020.6   123.48840
      3184 813.18  2689.4  3856.3  4265.5   135.06494
      3185 813.36  2911.0  4120.9  4526.0   133.48001
      3186 813.54  2331.0  3701.9  3916.9   115.68571
      3187 813.71  2424.4  3764.2  4039.4   120.54416
      3188 813.89  3294.4  4456.4  4866.0   135.24854
      3189 814.07  2972.4  4149.6  4526.8   132.04595
      3190 814.25  2587.8  3928.0  4214.7   121.39367
      3191 814.42  2466.6  3806.8  4127.1   123.89982
      3192 814.60  3175.6  4412.6  4852.5   135.56294
      3193 814.78  2958.1  4198.3  4650.5   136.45967
      3194 814.95  2204.0  3597.5  3903.0   121.92828
      3195 815.13  2473.9  3900.2  4205.3   121.39572
      3196 815.31  2721.8  4013.6  4484.6   136.46164
      3197 815.49  3041.6  4332.3  4738.2   131.45030
      3198 815.66  2405.1  3776.5  4109.9   124.31307
      3199 815.84  2453.1  3910.0  4234.0   122.23786
      3200 816.02  3008.5  4311.8  4736.5   132.58960
      3201 816.19  2804.9  4139.8  4627.6   136.54494
      3202 816.37  2472.3  4033.7  4261.4   114.58551
      3203 816.55  2513.3  4012.8  4303.6   119.39363
      3204 816.72  3124.0  4489.6  4957.7   134.28318
      3205 816.90  2717.2  4127.9  4573.1   131.56211
      3206 817.08  2299.5  3861.2  4190.1   121.05955
      3207 817.25  2340.8  4032.9  4293.4   115.39581
      3208 817.43  3048.2  4508.0  4988.0   132.88441
      3209 817.61  2705.8  4290.9  4768.5   130.12918
      3210 817.78  2499.8  4191.4  4562.5   121.93705
      3211 817.96  2506.3  4226.2  4611.2   122.38628
      3212 818.14  2610.3  4314.7  4720.6   123.81636
      3213 818.31  2941.3  4643.2  5128.9   128.54391
      3214 818.49  2365.8  4333.9  4642.3   115.67122
      3215 818.67  2302.7  4250.8  4637.4   119.84859
      3216 818.84  2623.0  4569.8  5015.1   122.86980
      3217 819.02  2536.2  4602.6  5047.8   121.54606
      3218 819.20  2341.2  4485.5  4881.9   118.49094
      3219 819.37  2439.1  4724.7  5108.5   116.79210
      3220 819.55  2727.5  5033.1  5589.7   124.14284
      3221 819.73  2959.3  5384.5  6027.6   126.51583
      3222 819.90  2416.6  5134.3  5636.4   118.47777
      3223 820.08  2701.3  5572.9  6145.5   119.94009
      3224 820.26  2969.1  6017.8  6697.3   122.28940
      3225 820.43  3004.8  6379.0  7095.4   121.23090
      3226 820.61  2489.1  6339.7  6870.1   113.77513
      3227 820.79  2356.4  6521.1  7101.1   113.92605
      3228 820.96  2842.6  7167.5  8087.8   121.28042
      3229 821.14  2682.4  7290.4  8257.8   120.99557
      3230 821.32  2439.5  7473.4  8314.3   116.70464
      3231 821.49  2363.4  7649.2  8646.5   118.86866
      3232 821.67  2767.6  8305.3  9426.8   120.25149
      3233 821.85  2734.4  8608.8  9609.5   117.03390
      3234 822.02  2448.1  8727.6  9788.1   116.88735
      3235 822.20  2418.2  8785.8  9854.4   116.78245
      3236 822.37  3158.0  9441.1 10681.4   119.73925
      3237 822.55  2530.1  9137.6 10304.1   117.65435
      3238 822.73  2561.6  9410.8 10621.2   117.67134
      3239 822.90  2495.2  9471.9 10621.6   116.47978
      3240 823.08  3176.8 10181.3 11423.2   117.72995
      3241 823.26  2683.2  9875.7 11095.5   116.95900
      3242 823.43  2572.7  9873.3 11045.9   116.06261
      3243 823.61  2503.0  9941.2 11026.3   114.58701
      3244 823.78  2960.5 10217.7 11527.6   118.04943
      3245 823.96  2608.3  9937.2 11243.8   117.82820
      3246 824.14  2529.2  9881.9 11187.6   117.75946
      3247 824.31  2396.9  9736.0 10878.4   115.56536
      3248 824.49  3166.2 10204.2 11443.2   117.60461
      3249 824.67  3124.0 10088.3 11383.0   118.59084
      3250 824.84  2461.7  9394.9 10522.5   116.26395
      3251 825.02  2432.2  9263.4 10273.4   114.78594
      3252 825.19  2991.7  9485.4 10603.6   117.21963
      3253 825.37  3284.1  9698.4 10937.8   119.32312
      3254 825.55  2435.4  8824.7  9745.1   114.40478
      3255 825.72  2369.1  8582.2  9548.0   115.54486
      3256 825.90  2583.3  8574.0  9698.8   118.77478
      3257 826.07  2724.6  8563.8  9591.9   117.60662
      3258 826.25  2573.9  8421.2  9386.7   116.51022
      3259 826.43  2323.2  7957.6  8906.2   116.83629
      3260 826.60  2461.2  8076.0  8904.6   114.75780
      3261 826.78  2823.7  8207.4  9172.4   117.92451
      3262 826.95  2394.1  7757.3  8565.4   115.06796
      3263 827.13  2303.1  7551.3  8460.6   117.32615
      3264 827.31  3131.8  8091.1  9044.6   119.22695
      3265 827.48  2921.6  7820.0  8812.0   120.25253
      3266 827.66  2419.5  7344.4  8128.0   115.90983
      3267 827.83  2628.0  7399.7  8291.8   118.69527
      3268 828.01  2738.1  7445.6  8288.9   117.91526
      3269 828.19  2781.6  7356.3  8275.0   120.08237
      3270 828.36  2400.6  6995.0  7702.0   115.38736
      3271 828.54  2568.6  7167.5  7732.7   112.29069
      3272 828.71  2707.0  7011.8  7801.1   118.33494
      3273 828.89  2763.5  6946.3  7704.0   118.11596
      3274 829.06  2349.0  6503.5  7108.5   114.56177
      3275 829.24  2675.1  6755.0  7306.3   113.51270
      3276 829.42  2739.8  6560.1  7276.0   118.74127
      3277 829.59  3029.4  6623.9  7340.7   119.94074
      3278 829.77  2452.6  6016.5  6584.6   115.94068
      3279 829.94  2394.9  5812.1  6279.5   113.67615
      3280 830.12  2880.7  5946.1  6539.6   119.36133
      3281 830.29  2623.9  5660.6  6164.4   116.59022
      3282 830.47  2384.2  5303.8  5800.7   117.01742
      3283 830.65  2282.7  5106.8  5569.2   116.37417
      3284 830.82  3160.4  5692.1  6221.3   120.90276
      3285 831.00  2809.0  5253.4  5779.0   121.49800
      3286 831.17  2402.3  4841.4  5237.9   116.25526
      3287 831.35  2433.4  4856.1  5240.8   115.87487
      3288 831.52  2810.2  5090.0  5566.8   120.91268
      3289 831.70  2907.3  5153.9  5635.2   121.42207
      3290 831.87  2245.4  4663.2  4994.2   113.68797
      3291 832.05  2276.9  4679.6  5066.3   116.09272
      3292 832.23  2796.3  5124.4  5672.9   123.55736
      3293 832.40  2800.8  5086.3  5598.3   122.40143
      3294 832.58  2535.0  5004.8  5417.7   116.71644
      3295 832.75  2392.8  4888.1  5328.4   117.64608
      3296 832.93  2734.0  5196.1  5675.7   119.48098
      3297 833.10  2723.4  5201.4  5694.6   119.90083
      3298 833.28  2547.7  5146.5  5475.9   112.67142
      3299 833.45  2401.4  5103.5  5517.2   115.31000
      3300 833.63  2895.4  5411.1  5989.1   122.97298
      3301 833.80  2506.7  5129.3  5634.8   119.27219
      3302 833.98  2435.9  5162.1  5643.8   117.66826
      3303 834.15  2513.3  5248.1  5733.9   117.76246
      3304 834.33  2939.2  5497.2  6071.0   122.43395
      3305 834.51  2804.1  5362.8  6059.5   127.22907
      3306 834.68  2336.3  4985.6  5507.4   119.69699
      3307 834.86  2263.8  4991.3  5424.2   115.87327
      3308 835.03  2770.5  5341.1  5927.2   122.80112
      3309 835.21  2796.7  5371.0  5917.0   121.20921
      3310 835.38  2415.8  4983.5  5479.5   119.31728
      3311 835.56  2419.9  5029.0  5548.4   119.90581
      3312 835.73  2888.5  5303.4  5889.5   124.27070
      3313 835.91  3004.0  5412.8  5987.4   123.85649
      3314 836.08  2318.7  4784.5  5245.7   118.70429
      3315 836.26  2490.7  4857.4  5335.8   120.21463
      3316 836.43  2852.4  4959.0  5549.2   128.01863
      3317 836.61  2915.5  4974.9  5580.3   129.39535
      3318 836.78  2363.4  4432.2  4894.2   122.33222
      3319 836.96  2290.4  4281.9  4709.9   121.49324
      3320 837.13  3280.8  4915.1  5605.3   142.23055
      3321 837.31  2936.0  4597.7  5187.5   135.49420
      3322 837.48  2523.1  4212.7  4640.3   125.30910
      3323 837.66  2322.4  3932.5  4425.3   130.60288
      3324 837.83  2881.9  4326.9  4918.8   140.95807
      3325 838.01  2961.4  4371.2  4890.1   136.81006
      3326 838.18  2168.0  3713.4  4066.0   122.82003
      3327 838.36  2157.7  3656.0  4050.5   126.32587
      3328 838.53  2711.9  4118.9  4573.5   132.31440
      3329 838.71  3162.1  4426.5  5020.0   146.93874
      3330 838.88  2231.9  3664.2  4050.9   126.99452
      3331 839.06  2308.1  3707.2  4162.3   132.52345
      3332 839.23  2886.0  4156.6  4726.3   144.84207
      3333 839.41  2822.9  4157.8  4607.9   133.72204
      3334 839.58  2306.4  3681.0  4012.4   124.10605
      3335 839.76  2159.4  3567.2  3845.7   119.78471
      3336 839.93  2985.1  4284.8  4788.2   138.73308
      3337 840.11  2967.1  4228.6  4704.6   137.72727
      3338 840.28  2238.8  3617.9  4002.6   127.88827
      3339 840.46  2337.1  3712.6  4091.4   127.54614
      3340 840.63  2571.8  3878.4  4285.2   131.12856
      3341 840.81  2812.3  3976.7  4499.0   144.84699
      3342 840.98  2217.5  3502.8  3871.9   128.71256
      3343 841.15  2255.2  3593.4  3933.7   125.43615
      3344 841.33  2937.2  4161.1  4600.6   135.91030
      3345 841.50  2671.4  3855.5  4318.8   139.12135
      3346 841.68  2328.1  3593.8  3997.6   131.90934
      3347 841.85  2335.9  3607.7  3993.1   130.30589
      3348 842.03  3125.6  4209.8  4775.5   152.17226
      3349 842.20  3051.1  4127.5  4599.3   143.83563
      3350 842.38  2168.8  3368.5  3656.9   124.03551
      3351 842.55  2192.6  3335.7  3707.6   132.53311
      3352 842.73  2882.7  3847.3  4343.7   151.46502
      3353 842.90  2727.5  3728.9  4152.9   142.33137
      3354 843.08  2291.3  3370.5  3661.8   126.98290
      3355 843.25  2447.7  3422.2  3739.2   132.53461
      3356 843.42  2801.6  3633.5  4040.6   148.94138
      3357 843.60  3031.4  3759.7  4242.6   166.31043
      3358 843.77  2217.5  3126.4  3370.5   126.85897
      3359 843.95  2246.2  3066.2  3379.1   138.16175
      3360 844.12  2483.0  3280.0  3593.4   139.31135
      3361 844.30  3019.1  3657.3  4079.1   166.11032
      3362 844.47  2226.1  2971.6  3237.4   135.65928
      3363 844.64  2184.8  2988.8  3168.6   122.36363
      3364 844.82  3288.2  3821.1  4257.7   181.93706
      3365 844.99  2791.4  3414.4  3738.0   151.93943
      3366 845.17  2297.4  2976.1  3196.5   132.46839
      3367 845.34  2143.4  2784.0  2981.0   130.75437
      3368 845.52  2833.6  3382.0  3717.5   161.16500
      3369 845.69  2997.0  3462.3  3771.1   166.37324
      3370 845.87  2331.4  2907.7  3134.2   139.30345
      3371 846.04  2224.1  2821.3  3006.8   131.06995
      3372 846.21  2866.7  3267.3  3595.4   181.90208
      3373 846.39  2895.4  3316.9  3694.9   189.69872
      3374 846.56  2307.2  2876.2  3053.1   131.10164
      3375 846.74  2209.3  2789.7  2972.4   131.47500
      3376 846.91  2785.6  3193.2  3548.7   187.23604
      3377 847.08  2686.9  3257.9  3472.5   137.58963
      3378 847.26  2112.3  2713.1  2872.1   126.44847
      3379 847.43  2208.1  2820.9  2902.0   113.23537
      3380 847.61  2793.0  3175.2  3497.5   184.35147
      3381 847.78  3137.9  3468.0  3815.8   205.33514
      3382 847.95  2251.1  2802.4  2958.1   128.23188
      3383 848.13  2208.9  2755.7  2895.8   125.61795
      3384 848.30  2835.6  3189.1  3494.7   186.44276
      3385 848.48  2734.0  3130.1  3461.9   183.76427
      3386 848.65  2276.1  2840.5  2988.8   126.26993
      3387 848.83  2258.9  2765.6  2931.5   132.74044
      3388 849.00  2733.6  3132.2  3385.3   163.51503
      3389 849.17  2882.3  3262.0  3505.7   164.18537
      3390 849.35  2269.1  2750.4  2912.6   133.70208
      3391 849.52  2162.7  2668.9  2782.8   122.49189
      3392 849.69  3006.8  3346.8  3634.7   184.69863
      3393 849.87  2753.7  3076.9  3298.0   168.44128
      3394 850.04  2189.7  2716.0  2788.9   113.85220
      3395 850.22  2147.9  2625.9  2718.1   119.28008
      3396 850.39  2788.1  3121.1  3376.3   176.62996
      3397 850.56  3059.7  3366.5  3727.3   217.62336
      3398 850.74  2192.1  2650.5  2768.9   125.82674
      3399 850.91  2163.9  2677.9  2729.1   109.96012
      3400 851.09  2682.4  3042.9  3295.2   169.99997
      3401 851.26  2912.2  3188.7  3449.2   194.22262
      3402 851.43  2111.9  2569.0  2694.7   127.50888
      3403 851.61  2299.9  2780.3  2898.7   124.63779
      3404 851.78  2646.4  3013.0  3236.2   160.89359
      3405 851.95  2763.9  3141.6  3391.8   166.26912
      3406 852.13  2203.2  2655.4  2722.2   114.76456
      3407 852.30  2125.8  2605.8  2713.1   122.35508
      3408 852.48  3348.0  3613.4  3958.7   230.09265
      3409 852.65  2867.6  3167.8  3463.5   198.49949
      3410 852.82  2189.7  2664.0  2750.8   118.30744
      3411 853.00  2195.8  2646.8  2785.6   130.79011
      3412 853.17  2972.4  3297.2  3590.9   190.41588
      3413 853.34  2455.9  2869.2  3033.0   139.64334
      3414 853.52  2215.5  2682.4  2784.4   121.84218
      3415 853.69  2043.9  2549.7  2612.4   112.38870
      3416 853.86  3009.7  3310.3  3572.1   187.05703
      3417 854.04  2873.7  3175.6  3463.5   195.38709
      3418 854.21  2289.6  2703.7  2817.2   127.39876
      3419 854.38  2152.4  2612.0  2709.1   121.12306
      3420 854.56  2634.9  3027.3  3232.1   152.19221
      3421 854.73  2588.2  2970.0  3152.6   147.85417
      3422 854.90  2283.5  2737.3  2868.0   128.79052
      3423 855.08  2190.1  2651.3  2747.1   120.78157
      3424 855.25  2896.6  3190.3  3441.8   185.63432
      3425 855.42  2473.1  2847.1  3014.6   144.79742
      3426 855.60  2360.1  2731.6  2878.2   139.47058
      3427 855.77  2277.3  2719.3  2831.1   125.30116
      3428 855.95  2903.6  3203.8  3475.8   190.58695
      3429 856.12  2934.3  3248.9  3518.0   185.54685
      3430 856.29  2158.6  2540.7  2664.8   132.47591
      3431 856.46  2288.8  2754.5  2861.0   122.86712
      3432 856.64  2778.7  3056.0  3341.5   202.95425
      3433 856.81  2925.7  3164.1  3497.1   239.69016
      3434 856.98  2306.0  2720.9  2842.6   129.31905
      3435 857.16  2252.4  2698.0  2778.3   118.01462
      3436 857.33  2597.6  2918.4  3149.8   172.15873
      3437 857.50  2951.5  3231.7  3515.5   201.31567
      3438 857.68  2153.6  2596.0  2723.8   128.88885
      3439 857.85  2279.0  2677.5  2797.9   130.21599
      3440 858.02  2661.5  2969.1  3191.1   172.17048
      3441 858.20  2689.8  2985.9  3223.5   180.22159
      3442 858.37  2256.0  2696.8  2856.1   136.15241
      3443 858.54  2147.1  2588.6  2656.6   115.39899
      3444 858.72  3469.3  3616.3  4017.7   372.98088
      3445 858.89  3069.9  3308.7  3649.1   242.53894
      3446 859.06  2229.0  2616.9  2764.8   138.12058
      3447 859.24  2176.2  2620.2  2745.5   128.22889
      3448 859.41  2901.2  3168.6  3470.1   212.71087
      3449 859.58  2948.7  3217.8  3488.9   200.76142
      3450 859.75  2216.3  2664.8  2772.5   124.01824
      3451 859.93  2212.2  2665.6  2754.1   119.51215
      3452 860.10  2901.2  3183.4  3459.0   197.67762
      3453 860.27  2994.5  3235.0  3533.2   224.02103
      3454 860.45  2216.3  2616.1  2752.9   134.22153
      3455 860.62  2279.0  2668.9  2805.7   135.08398
      3456 860.79  2854.5  3107.6  3460.7   239.48224
      3457 860.97  2949.5  3169.4  3509.0   254.37711
      3458 861.14  2276.1  2644.7  2814.3   145.99997
      3459 861.31  2263.0  2669.3  2791.4   130.04034
      3460 861.48  2879.4  3107.2  3395.9   226.79881
      3461 861.66  2540.3  2868.8  3112.5   174.18926
      3462 861.83  2177.4  2566.5  2679.6   129.05267
      3463 862.00  2156.5  2548.9  2720.9   143.84122
      3464 862.17  2616.5  2890.5  3181.3   206.12879
      3465 862.35  2954.4  3202.2  3503.3   221.48755
      3466 862.52  2219.2  2583.3  2751.7   146.23169
      3467 862.69  2310.1  2664.4  2902.0   167.05231
      3468 862.87  2954.8  3164.1  3414.8   219.76465
      3469 863.04  2930.6  3162.9  3501.2   245.67861
      3470 863.21  2122.5  2505.5  2721.3   156.36368
      3471 863.38  2262.2  2658.3  2807.4   137.64243
      3472 863.56  2930.6  3128.5  3503.3   289.44064
      3473 863.73  2723.4  3017.1  3263.2   183.82111
      3474 863.90  2175.8  2597.6  2744.7   134.85430
      3475 864.07  2409.6  2784.8  2987.2   153.93003
      3476 864.25  3152.2  3354.2  3731.8   287.01920
      3477 864.42  2665.6  2956.0  3246.0   199.85882
      3478 864.59  2112.3  2546.9  2703.3   136.00381
      3479 864.76  2192.1  2586.6  2763.9   144.96361
      3480 864.94  3045.3  3283.3  3631.9   246.47146
      3481 865.11  2652.1  2988.0  3248.1   177.43922
      3482 865.28  2131.9  2532.1  2679.6   136.84722
      3483 865.45  2238.8  2612.0  2808.6   152.68934
      3484 865.63  2820.1  3096.1  3393.1   207.56703
      3485 865.80  2620.2  2957.3  3218.6   177.52124
      3486 865.97  2188.1  2634.9  2802.8   137.58009
      3487 866.14  2114.3  2613.2  2727.9   122.98846
      3488 866.32  2920.4  3207.1  3508.6   205.14272
      3489 866.49  2675.9  2972.0  3282.5   204.84102
      3490 866.66  2343.7  2765.6  2965.5   147.37865
      3491 866.83  2175.4  2611.2  2754.9   132.98884
      3492 867.01  2734.0  3058.0  3352.1   190.77098
      3493 867.18  2741.4  3089.6  3352.5   175.52929
      3494 867.35  2072.5  2505.9  2682.0   140.64257
      3495 867.52  2120.9  2591.5  2746.3   132.89802
      3496 867.70  3075.2  3320.6  3687.2   249.41532
      3497 867.87  3190.3  3492.2  3832.6   212.75483
      3498 868.04  2182.7  2587.8  2783.2   148.23075
      3499 868.21  2188.1  2646.4  2806.1   134.85267
      3500 868.38  2867.2  3177.2  3526.6   212.68129
      3501 868.56  3124.8  3397.6  3739.2   225.22536
      3502 868.73  2234.3  2655.8  2818.8   138.67825
      3503 868.90  2140.9  2594.8  2774.6   139.62109
      3504 869.07  2737.7  3108.4  3392.3   176.57453
      3505 869.24  2893.4  3301.3  3507.8   150.60227
      3506 869.42  2214.7  2689.0  2878.6   139.98271
      3507 869.59  2423.2  2859.8  3047.8   143.05803
      3508 869.76  3133.8  3408.6  3765.8   229.95557
      3509 869.93  2693.5  3036.7  3326.7   184.48666
      3510 870.11  2294.1  2827.8  2950.7   123.02380
      3511 870.28  2212.2  2643.1  2838.9   145.43737
      3512 870.45  3187.0  3485.6  3817.0   210.97376
      3513 870.62  2881.9  3248.9  3529.5   176.45070
      3514 870.79  2262.6  2729.5  2868.4   129.73677
      3515 870.97  2308.5  2825.0  2963.4   126.80417
      3516 871.14  2999.5  3339.8  3655.6   192.77996
      3517 871.31  3005.2  3308.7  3613.4   200.40493
      3518 871.48  2273.7  2764.8  2929.4   133.52779
      3519 871.65  2415.4  2913.4  3044.9   126.39811
      3520 871.82  3193.6  3519.6  3812.5   189.82416
      3521 872.00  2916.3  3248.9  3571.2   196.92113
      3522 872.17  2204.8  2716.0  2855.3   127.24361
      3523 872.34  2298.2  2777.9  2946.6   135.18349
      3524 872.51  2786.1  3111.7  3413.6   192.70423
      3525 872.68  2943.8  3302.1  3622.9   189.48562
      3526 872.86  2370.7  2906.5  3061.3   128.89922
      3527 873.03  2214.3  2714.0  2856.5   128.52469
      3528 873.20  2888.9  3229.2  3545.4   192.90041
      3529 873.37  3341.9  3672.4  3997.2   198.26467
      3530 873.54  2185.6  2658.3  2875.8   146.01404
      3531 873.71  2258.5  2745.9  2922.5   136.21827
      3532 873.89  3242.3  3567.6  3901.0   202.51862
      3533 874.06  2956.0  3314.4  3643.3   191.77109
      3534 874.23  2206.5  2734.9  2874.5   126.43426
      3535 874.40  2301.9  2797.5  3014.6   143.80175
      3536 874.57  3235.0  3556.1  3959.5   225.63761
      3537 874.74  2816.4  3194.8  3531.5   188.96117
      3538 874.92  2308.9  2840.1  2996.2   129.37545
      3539 875.09  2122.5  2661.1  2860.2   136.95806
      3540 875.26  3128.1  3491.0  3883.8   208.23889
      3541 875.43  2972.8  3353.3  3705.2   192.46491
      3542 875.60  2225.3  2797.5  2981.8   132.21188
      3543 875.77  2272.8  2855.3  3028.1   129.67660
      3544 875.95  2655.4  3130.1  3400.0   156.85953
      3545 876.12  2921.2  3323.9  3640.1   178.53538
      3546 876.29  2179.0  2750.4  2918.4   129.39062
      3547 876.46  2326.9  2921.2  3097.8   129.70364
      3548 876.63  2782.0  3238.2  3586.4   176.30176
      3549 876.80  2936.4  3402.9  3699.0   163.47671
      3550 876.97  2407.6  3075.6  3248.9   125.93515
      3551 877.15  2151.6  2768.4  2960.5   131.14219
      3552 877.32  3090.8  3565.1  3879.3   166.23474
      3553 877.49  2739.8  3261.2  3535.6   152.63170
      3554 877.66  2535.8  3193.2  3424.2   135.14020
      3555 877.83  2318.3  3016.7  3228.8   130.38131
      3556 878.00  2682.8  3323.0  3570.8   138.70758
      3557 878.17  3332.9  3877.6  4249.1   168.19554
      3558 878.34  2211.4  2990.4  3177.2   123.97481
      3559 878.52  2320.8  3132.2  3318.1   122.91778
      3560 878.69  2875.8  3583.1  3868.2   140.30109
      3561 878.86  2593.5  3360.3  3690.4   143.05564
      3562 879.03  2143.8  3078.1  3268.6   120.38579
      3563 879.20  2169.6  3121.9  3333.3   122.19350
      3564 879.37  2875.8  3772.8  4182.0   145.61644
      3565 879.54  3366.0  4205.7  4677.2   156.14624
      3566 879.71  2153.2  3331.6  3567.2   119.98605
      3567 879.89  2235.2  3523.7  3755.6   117.99109
      3568 880.06  3149.8  4336.4  4759.9   135.69210
      3569 880.23  2791.8  4119.3  4569.8   133.94014
      3570 880.40  2249.1  3799.8  4084.1   118.33069
      3571 880.57  2357.6  3915.3  4244.6   121.14118
      3572 880.74  2755.7  4337.6  4761.1   126.77370
      3573 880.91  3171.1  4748.0  5260.0   132.46752
      3574 881.08  2325.7  4076.7  4426.5   119.97660
      3575 881.25  2369.1  4326.1  4702.1   119.21306
      3576 881.42  3083.0  4882.4  5327.2   124.72109
      3577 881.60  2744.3  4671.0  5230.1   129.01788
      3578 881.77  2265.1  4354.8  4780.8   120.38413
      3579 881.94  2197.5  4318.3  4810.3   123.19427
      3580 882.11  2748.8  4755.4  5315.3   127.90368
      3581 882.28  2868.4  4987.2  5554.1   126.75426
      3582 882.45  2213.4  4490.4  4920.0   118.87031
      3583 882.62  2286.8  4617.8  5073.6   119.55720
      3584 882.79  3172.3  5331.3  5921.1   127.31930
      3585 882.96  2880.3  5133.4  5673.7   123.97750
      3586 883.13  2190.1  4517.8  4989.3   120.25337
      3587 883.30  2464.5  4794.7  5330.9   123.00936
      3588 883.48  3005.2  5226.0  5836.7   127.49906
      3589 883.65  2753.3  5021.2  5581.1   124.68843
      3590 883.82  2158.6  4449.8  4921.3   120.57565
      3591 883.99  2191.3  4513.7  4952.4   118.88890
      3592 884.16  3145.7  5215.8  5799.0   128.17568
      3593 884.33  2716.4  4795.9  5361.2   127.18144
      3594 884.50  2272.8  4416.2  4873.8   121.34530
      3595 884.67  2372.8  4476.9  4892.6   119.75858
      3596 884.84  2891.3  4773.0  5286.6   127.29649
      3597 885.01  2735.7  4612.8  5105.6   126.24917
      3598 885.18  2312.6  4231.5  4631.7   120.85378
      3599 885.35  2221.2  4137.3  4478.5   117.80678
      3600 885.52  2494.4  4165.6  4615.3   126.91178
      3601 885.69  2825.8  4443.3  4877.4   126.84221
      3602 885.87  2228.6  3831.8  4150.4   119.87730
      3603 886.04  2240.1  3816.2  4104.5   118.29522
      3604 886.21  2917.9  4319.6  4697.2   126.94327
      3605 886.38  3019.9  4339.6  4769.3   132.55743
      3606 886.55  2177.0  3604.0  3877.6   119.17340
      3607 886.72  2242.5  3570.0  3801.4   117.43294
      3608 886.89  3029.8  4118.1  4545.3   139.25476
      3609 887.06  2784.8  3858.0  4304.4   141.60302
      3610 887.23  2259.3  3446.7  3645.4   116.72991
      3611 887.40  2300.3  3478.3  3687.6   117.76778
      3612 887.57  2848.7  3765.0  4151.2   142.15469
      3613 887.74  2896.6  3868.6  4155.3   129.49856
      3614 887.91  2050.8  3090.4  3295.6   119.73991
      3615 888.08  2137.7  3174.8  3338.6   115.79784
      3616 888.25  2981.4  3745.7  4068.5   142.22938
      3617 888.42  3268.1  3989.0  4423.6   160.28396
      3618 888.59  2331.4  3114.1  3285.4   121.87336
      3619 888.76  2243.3  3082.2  3280.0   123.58401
      3620 888.93  2834.8  3515.1  3790.0   140.39724
      3621 889.10  2592.3  3284.9  3581.9   142.87397
      3622 889.27  2296.2  3024.8  3225.6   127.54358
      3623 889.44  2301.5  3042.5  3227.2   124.93093
      3624 889.61  2788.1  3360.7  3666.7   153.43339
      3625 889.78  2734.0  3341.9  3647.8   150.33701
      3626 889.95  2403.5  3042.5  3258.3   133.78208
      3627 890.12  2435.4  3090.4  3258.3   125.64094
      3628 890.29  3017.9  3529.5  3819.9   156.76548
      3629 890.46  2750.8  3291.1  3573.3   152.23654
      3630 890.63  2154.5  2821.7  2942.9   118.17070
      3631 890.80  2202.4  2867.6  2983.5   117.42611
      3632 890.97  2771.3  3248.1  3513.1   155.58438
      3633 891.15  2959.7  3386.9  3705.2   174.49644
      3634 891.32  2222.0  2863.5  2977.7   117.81614
      3635 891.49  2329.4  2899.1  3099.4   135.15450
      3636 891.66  3224.7  3610.6  3949.3   187.79200
      3637 891.83  2796.3  3324.7  3584.8   149.22489
      3638 892.00  2302.3  2865.1  3068.7   136.17173
      3639 892.17  2399.4  2953.2  3118.2   129.80763
      3640 892.34  2968.3  3326.3  3709.3   206.97934
      3641 892.51  2979.8  3425.4  3745.3   171.78293
      3642 892.68  2314.6  2861.4  3026.1   130.11240
      3643 892.84  2155.3  2786.1  2949.5   125.90908
      3644 893.01  2676.3  3152.6  3441.4   160.61924
      3645 893.18  2993.7  3336.1  3768.7   226.31593
      3646 893.35  2295.4  2895.0  3095.7   133.46991
      3647 893.52  2181.9  2820.1  3042.5   134.85231
      3648 893.69  2972.4  3473.8  3834.6   171.97707
      
      $metadata
       [1] "hugo" NA     NA     NA     "400"  "400"  "400"  "5"    "5"    "5"   
      [11] "0"    "0"    "0"   
      

---

    Code
      lr_parse_jdx(test.file("non_english", "OceanOptics_comma.jdx"))
    Output
      $data
               wl    dark   white   scope   processed
      1    176.36 32822.8 32822.8 32822.8         NaN
      2    176.58 32822.8 32822.8 32822.8         NaN
      3    176.80 32822.8 32822.8 32822.8         NaN
      4    177.02  1483.5  1517.5  1479.0   -13.25450
      5    177.24  1492.2  1506.5  1527.4   245.71010
      6    177.47  1965.6  1934.1  1971.0   -16.88439
      7    177.69  1894.8  1869.0  1908.3   -52.37745
      8    177.91  2016.4  1995.5  2037.3  -100.00000
      9    178.13  1887.0  1890.3  1899.7   387.48856
      10   178.35  1918.9  1913.2  1937.4  -321.37751
      11   178.57  1950.1  1925.1  1951.7    -6.55593
      12   178.79  1866.9  1873.1  1885.8   306.67318
      13   179.01  1910.3  1910.8  1911.2   199.75610
      14   179.23  1873.1  1866.5  1907.1  -518.78529
      15   179.46  1899.7  1894.0  1946.4  -814.33554
      16   179.68  1875.9  1874.3  1914.0 -2325.57998
      17   179.90  1824.7  1838.7  1866.1   297.06305
      18   180.12  1856.3  1835.0  1825.2   146.15240
      19   180.34  1917.7  1915.7  1992.3 -3639.94141
      20   180.56  1823.9  1805.1  1813.3    56.52035
      21   180.78  1937.0  1985.7  2005.4   140.33770
      22   181.00  1810.8  1823.1  1837.0   213.33008
      23   181.22  1894.8  1901.3  1919.4   375.01908
      24   181.44  1848.1  1884.5  1857.1    24.71882
      25   181.66  1918.1  1904.6  1926.7   -63.63098
      26   181.89  1907.5  1943.9  1948.4   112.35804
      27   182.11  1848.1  1839.5  1839.5   100.00000
      28   182.33  1886.2  1921.4  1857.1   -82.55784
      29   182.55  2027.5  2039.0  2072.1   389.27544
      30   182.77  1988.6  2001.7  2029.5   312.49714
      31   182.99  2031.2  1972.6  2037.7   -11.18984
      32   183.21  1751.4  1767.4  1777.2   161.53750
      33   183.43  1868.2  1869.8  1844.8 -1425.33578
      34   183.65  1808.8  1821.5  1829.7   164.51918
      35   183.87  1774.4  1803.0  1763.3   -38.57073
      36   184.09  1955.0  1982.4  1963.2    29.85096
      37   184.31  1923.9  1951.7  1952.1   101.47207
      38   184.53  1801.0  1789.9  1821.1  -181.48115
      39   184.76  1884.5  1895.6  1918.1   303.70739
      40   184.98  1863.7  1858.3  1874.3  -199.98122
      41   185.20  1996.0  1926.7  1950.1    66.27180
      42   185.42  1998.0  1972.2  2018.5   -79.36754
      43   185.64  1893.6  1906.2  1951.3   454.85548
      44   185.86  1940.2  1990.6  2022.2   162.60024
      45   186.08  2112.3  2083.2  2093.4    64.78801
      46   186.30  1866.5  1885.8  1886.6   104.25432
      47   186.52  1783.4  1770.7  1794.8   -90.32842
      48   186.74  1944.8  1925.9  1932.5    65.21947
      49   186.96  1934.1  1927.1  1936.2   -29.41261
      50   187.18  1881.3  1846.9  1880.0     3.57205
      51   187.40  1884.5  1844.8  1846.9    94.84533
      52   187.62  2006.6  1974.2  1994.7    36.70808
      53   187.84  1968.9  1971.0  1988.2   939.99023
      54   188.06  1905.4  1894.8  1886.6   176.92741
      55   188.28  1903.8  1855.0  1894.8    18.48714
      56   188.51  1973.0  1973.8  1977.9   600.12210
      57   188.73  1970.6  2003.3  1985.7    46.25080
      58   188.95  1996.4  1968.1  1992.3    14.49296
      59   189.17  1889.0  1913.6  1869.0   -81.66504
      60   189.39  1934.9  1941.5  1935.7    12.49809
      61   189.61  1901.3  1913.2  1939.0   317.25038
      62   189.83  1928.4  1909.9  1914.9    73.33297
      63   190.05  1879.6  1906.7  1930.0   186.36481
      64   190.27  1982.0  1973.4  2016.8  -404.79014
      65   190.49  1942.7  1963.6  1937.8   -23.52913
      66   190.71  1808.4  1805.9  1783.4  1016.89052
      67   190.93  1876.3  1876.8  1846.0 -7392.68293
      68   191.15  1813.3  1831.3  1796.1   -95.45555
      69   191.37  1914.4  1912.4  1923.5  -439.99023
      70   191.59  1909.1  1919.8  1916.9    73.07981
      71   191.81  1949.3  1939.0  1956.2   -67.99805
      72   192.03  1915.3  1921.8  1889.5  -393.71376
      73   192.25  1918.1  1901.3  1930.8   -75.60438
      74   192.47  1869.8  1884.5  1915.7   311.10132
      75   192.69  1823.5  1832.1  1828.4    57.13787
      76   192.91  1917.7  1944.8  1929.6    43.93889
      77   193.13  1920.6  1889.0  1938.2   -55.84514
      78   193.35  1824.3  1845.2  1861.2   176.47087
      79   193.57  1919.4  1939.0  1946.8   139.58090
      80   193.79  1832.1  1793.2  1868.6   -93.68318
      81   194.01  1957.0  2004.1  1994.7    80.00127
      82   194.23  1894.0  1888.6  1897.6   -69.22066
      83   194.45  1900.9  1869.0  1909.5   -26.92103
      84   194.67  1982.4  1970.6  1970.1   103.45176
      85   194.89  1846.9  1812.5  1836.2    30.95100
      86   195.11  1882.1  1890.3  1872.3  -119.99512
      87   195.33  1805.1  1807.5  1826.0   850.18315
      88   195.55  1837.4  1848.5  1919.4   740.73605
      89   195.77  1912.4  1934.9  1924.7    54.54545
      90   195.99  1885.4  1873.5  1839.9   382.76646
      91   196.21  1821.9  1840.3  1861.6   215.55447
      92   196.43  1920.2  1935.3  1938.2   118.92570
      93   196.65  1832.1  1875.9  1890.7   133.64669
      94   196.87  2009.5  1987.8  2023.0   -62.26450
      95   197.09  1874.7  1868.6  1913.6  -633.31706
      96   197.31  1980.4  1949.7  1963.6    54.66797
      97   197.53  1950.5  1937.8  1981.2  -241.94692
      98   197.75  1892.3  1903.0  1887.8   -42.30047
      99   197.97  1928.4  1971.4  1955.0    61.90476
      100  198.19  1968.1  1965.2  1969.7   -57.13289
      101  198.41  2052.5  2070.9  2013.6  -211.10569
      102  198.63  1862.0  1876.8  1868.2    41.66554
      103  198.85  1927.5  1916.5  1931.2   -33.33936
      104  199.07  1980.0  1999.2  1989.0    46.80796
      105  199.29  1819.0  1853.0  1858.3   115.66361
      106  199.51  1862.0  1874.7  1837.4  -193.53441
      107  199.73  1955.0  1979.2  2007.4   216.94943
      108  199.95  1829.2  1806.3  1836.6   -32.13881
      109  200.17  1893.1  1915.3  1926.3   150.00000
      110  200.39  1913.6  1957.9  1947.6    76.85143
      111  200.61  1944.3  1986.1  2001.7   137.25645
      112  200.83  1822.3  1834.6  1862.8   330.01546
      113  201.05  1937.8  1935.3  1971.4 -1366.43613
      114  201.27  1871.8  1887.4  1887.4   100.00000
      115  201.49  1855.5  1855.0  1866.9 -2797.07317
      116  201.71  1972.2  1975.9  2003.3   844.51980
      117  201.93  1980.8  1997.2  1971.4   -57.49512
      118  202.15  1846.0  1851.8  1845.2   -14.28322
      119  202.37  1891.5  1894.4  1935.3  1528.63621
      120  202.59  1922.6  1955.0  1934.5    36.70808
      121  202.81  1870.2  1901.3  1911.6   132.89537
      122  203.03  1977.9  1984.1  1982.8    79.99674
      123  203.25  1873.1  1931.6  1907.1    58.04138
      124  203.47  1864.1  1889.0  1907.1   172.13128
      125  203.69  1863.7  1879.6  1916.9   333.33542
      126  203.91  1912.4  1926.7  1952.5   279.99442
      127  204.13  1798.1  1803.0  1819.8   441.66836
      128  204.35  1812.9  1845.6  1857.5   136.25294
      129  204.57  2027.9  2031.2  2025.4   -75.03053
      130  204.79  1834.2  1868.2  1893.6   174.69996
      131  205.01  1894.4  1864.9  1926.3  -108.33136
      132  205.23  1952.9  1993.5  1978.7    63.63502
      133  205.45  1898.9  1882.9  1920.6  -135.88732
      134  205.67  1777.6  1786.2  1812.9   409.54540
      135  205.89  1885.8  1874.7  1886.6    -7.40573
      136  206.10  1961.1  1922.2  2012.3  -131.57638
      137  206.32  1817.0  1803.0  1837.4  -147.06305
      138  206.54  1783.4  1830.5  1769.9   -28.69456
      139  206.76  1865.3  1829.2  1889.5   -67.04583
      140  206.98  1881.7  1907.5  1903.4    84.12649
      141  207.20  1856.3  1882.5  1858.3     7.81262
      142  207.42  1921.4  1920.6  1919.8   200.00000
      143  207.64  1840.7  1882.5  1860.0    46.07817
      144  207.86  1836.2  1882.1  1886.6   109.82256
      145  208.08  2069.3  2063.1  2081.1  -193.32682
      146  208.30  1836.6  1832.9  1846.9  -277.80792
      147  208.52  1814.1  1826.4  1817.0    23.33171
      148  208.74  1975.5  1967.3  1990.2  -179.99268
      149  208.96  1947.6  1947.6  1991.0         Inf
      150  209.18  1769.0  1802.2  1790.3    64.19809
      151  209.40  1979.6  1994.3  2005.4   175.00170
      152  209.62  1857.5  1857.9  1844.8 -3104.64548
      153  209.83  1879.2  1905.0  1904.6    98.41116
      154  210.05  1956.2  1905.8  1940.2    31.70703
      155  210.27  1857.9  1833.3  1819.0   158.33571
      156  210.49  1853.8  1897.2  1905.8   119.81252
      157  210.71  1843.6  1846.9  1855.0   349.98474
      158  210.93  1931.6  1957.4  1955.8    93.64852
      159  211.15  1848.1  1879.6  1898.1   158.43876
      160  211.37  1831.3  1807.9  1843.6   -52.62775
      161  211.59  1850.5  1836.2  1857.5   -48.57003
      162  211.81  1792.0  1826.0  1806.3    42.16673
      163  212.03  1911.6  1852.2  1903.8    13.10300
      164  212.25  1930.4  1920.6  1951.3  -212.51272
      165  212.47  1875.9  1864.5  1912.8  -321.45099
      166  212.68  1920.6  1939.8  1968.9   251.06228
      167  212.90  1966.0  1970.6  1958.3  -172.70306
      168  213.12  1873.1  1905.0  1919.8   146.15168
      169  213.34  1925.5  1969.7  1979.2   121.29713
      170  213.56  1810.4  1860.0  1877.6   135.53802
      171  213.78  1834.2  1822.3  1812.9   179.31470
      172  214.00  1978.3  2009.9  2014.8   115.58388
      173  214.22  1815.3  1832.9  1814.5    -4.65592
      174  214.44  1890.3  1918.5  1879.6   -37.67957
      175  214.66  1907.1  1919.8  1889.9  -135.47015
      176  214.88  1869.0  1904.6  1906.7   105.74716
      177  215.09  1888.6  1926.7  1932.5   115.05303
      178  215.31  1716.6  1738.7  1733.4    75.92911
      179  215.53  1909.5  1888.6  1975.9  -317.65044
      180  215.75  1970.1  1954.6  1971.0    -5.26181
      181  215.97  1817.0  1816.5  1822.7 -1398.53659
      182  216.19  1931.2  1918.9  1920.6    86.66992
      183  216.41  1934.1  1931.6  1932.9    50.00000
      184  216.63  1828.4  1892.3  1929.6   158.33294
      185  216.85  1958.3  1980.0  2021.3   290.57030
      186  217.06  1962.0  1967.7  1991.0   507.16777
      187  217.28  1816.1  1827.2  1835.4   174.07541
      188  217.50  1798.1  1836.6  1836.2    98.93769
      189  217.72  1971.8  1973.4  1978.3   399.87797
      190  217.94  1971.8  1960.3  1943.1   250.00872
      191  218.16  1895.6  1866.1  1885.8    33.33220
      192  218.38  1846.9  1857.1  1846.4    -3.99414
      193  218.60  1846.0  1873.5  1842.4   -13.43148
      194  218.82  1885.0  1900.5  1901.7   107.89592
      195  219.03  1860.4  1865.3  1891.9   641.68871
      196  219.25  1902.6  1885.4  1947.6  -261.90199
      197  219.47  1912.4  1925.9  1923.9    84.84871
      198  219.69  1823.5  1864.5  1852.2    70.00000
      199  219.91  1989.4  1996.4  1992.7    47.06305
      200  220.13  2009.9  2026.7  2069.3   353.66522
      201  220.35  1906.2  1925.9  1956.2   254.16306
      202  220.57  1876.8  1896.4  1894.4    89.58291
      203  220.78  1940.2  1966.5  1981.2   156.24857
      204  221.00  1941.9  1914.4  1960.7   -68.65503
      205  221.22  1933.7  1971.0  1959.9    70.32973
      206  221.44  1875.1  1899.3  1885.8    44.07018
      207  221.66  1860.4  1919.4  1911.2    86.11078
      208  221.88  2016.8  2033.6  2042.6   153.65926
      209  222.10  1793.6  1826.4  1835.8   128.74756
      210  222.31  1820.6  1845.2  1850.5   121.66748
      211  222.53  1781.3  1796.9  1813.7   207.88950
      212  222.75  1803.9  1846.9  1833.8    69.52357
      213  222.97  1795.2  1875.9  1904.6   135.53352
      214  223.19  1894.4  1875.1  1896.8   -12.76817
      215  223.41  1910.8  1934.5  1972.6   260.35107
      216  223.63  1829.7  1858.7  1868.6   133.80558
      217  223.84  2054.1  2068.0  2078.7   176.46848
      218  224.06  1785.4  1837.8  1832.1    89.06310
      219  224.28  1878.4  1876.8  1968.5 -5501.28205
      220  224.50  1918.9  1959.1  1954.2    87.75536
      221  224.72  1866.1  1904.2  1905.8   104.30274
      222  224.94  1840.7  1832.5  1829.7   134.99756
      223  225.16  1928.0  1946.8  1969.3   219.56902
      224  225.37  2041.0  2046.7  2083.2   735.75166
      225  225.59  1878.0  1893.6  1951.3   471.04401
      226  225.81  1887.0  1930.0  1910.8    55.23856
      227  226.03  1898.1  1922.6  1926.7   116.66667
      228  226.25  1968.9  2019.3  2027.9   117.07424
      229  226.47  1842.4  1860.8  1876.8   186.67462
      230  226.68  1899.3  1892.7  1924.3  -381.27575
      231  226.90  1948.8  1943.5  1971.4  -423.06103
      232  227.12  1830.9  1892.3  1882.9    84.66609
      233  227.34  1934.1  1987.8  1996.0   115.26763
      234  227.56  1847.7  1887.4  1842.4   -13.40012
      235  227.78  1947.6  1929.6  1964.4   -93.18611
      236  227.99  1861.6  1915.3  1905.4    81.67959
      237  228.21  1887.4  1905.4  1914.9   152.27500
      238  228.43  1977.5  1991.4  2007.0   211.76217
      239  228.65  1932.9  1932.1  1969.7 -4500.97680
      240  228.87  1925.1  1938.6  1958.7   248.49068
      241  229.09  1853.8  1855.9  1882.1  1379.98047
      242  229.30  1921.0  1960.3  1945.2    61.45825
      243  229.52  1811.2  1805.5  1840.3  -507.07934
      244  229.74  1910.8  1926.7  1902.2   -53.85001
      245  229.96  1975.5  2006.6  2005.4    96.05191
      246  230.18  1897.6  1945.6  1970.6   152.13889
      247  230.39  1874.7  1896.8  1920.6   207.40573
      248  230.61  1931.2  1909.5  1952.5   -98.10678
      249  230.83  1882.1  1931.6  1882.5     0.82726
      250  231.05  1783.0  1834.6  1864.5   157.93869
      251  231.27  1952.1  2003.3  2007.8   108.80095
      252  231.49  1886.2  1889.0  1914.4   985.76910
      253  231.70  1909.9  1989.4  2009.1   124.74170
      254  231.92  1891.1  1927.1  1939.8   135.22541
      255  232.14  1847.7  1875.5  1898.9   183.82221
      256  232.36  1820.2  1875.1  1871.4    93.28414
      257  232.58  1988.2  2068.9  2036.1    59.39150
      258  232.79  1781.3  1836.2  1862.0   147.01381
      259  233.01  1888.6  1915.7  1937.8   181.81852
      260  233.23  1872.7  1941.5  1983.3   160.71558
      261  233.45  1894.8  1933.3  1931.6    95.74557
      262  233.67  1821.1  1846.4  1882.1   240.31896
      263  233.88  1842.8  1934.1  1930.8    96.41231
      264  234.10  2002.1  2077.5  2104.9   136.41164
      265  234.32  1979.6  2066.0  2038.5    68.24609
      266  234.54  1895.6  1959.1  1979.2   131.61277
      267  234.75  1873.5  1938.6  1935.7    95.59770
      268  234.97  1927.5  1979.2  1984.5   110.31797
      269  235.19  1970.1  2080.7  2116.8   132.59246
      270  235.41  1850.5  1960.3  1972.2   110.82071
      271  235.63  1890.7  1943.1  1981.2   172.65583
      272  235.84  2003.7  2090.2  2127.0   142.65366
      273  236.06  1802.6  1918.5  1934.1   113.42794
      274  236.28  1948.4  2034.5  2036.5   102.38098
      275  236.50  1853.0  1962.0  1963.2   101.12802
      276  236.72  1837.0  1896.4  1945.6   182.75833
      277  236.93  1860.8  1946.0  1991.9   153.84525
      278  237.15  1942.3  2073.8  2116.0   132.08725
      279  237.37  1839.5  1963.6  2022.6   147.52550
      280  237.59  1941.9  2100.8  2186.0   153.60869
      281  237.80  1834.6  1976.7  2009.9   123.34358
      282  238.02  1880.9  2041.0  2090.6   130.94560
      283  238.24  1817.0  1966.9  1996.4   119.67234
      284  238.46  1923.9  2093.4  2131.1   122.22183
      285  238.67  1968.9  2195.8  2205.7   104.33202
      286  238.89  1950.1  2130.7  2189.7   132.65276
      287  239.11  1847.3  2056.2  2083.6   113.13687
      288  239.33  1810.4  2048.4  2099.6   121.51496
      289  239.55  1839.5  2066.8  2111.5   119.63981
      290  239.76  1927.5  2152.0  2167.2   106.75182
      291  239.98  1832.9  2104.5  2156.1   119.00420
      292  240.20  1887.8  2145.9  2204.4   122.69845
      293  240.42  1874.7  2090.2  2156.1   130.60813
      294  240.63  1882.5  2139.3  2177.4   114.83247
      295  240.85  1855.5  2082.4  2177.4   141.87691
      296  241.07  1898.1  2207.3  2258.1   116.42360
      297  241.29  1932.5  2251.9  2331.4   124.87206
      298  241.50  1773.5  2105.7  2135.6   109.00144
      299  241.72  1920.2  2206.9  2258.5   118.00010
      300  241.94  1874.3  2217.5  2294.1   122.31500
      301  242.16  2042.2  2365.0  2440.8   123.47720
      302  242.37  1833.8  2183.5  2291.3   130.79621
      303  242.59  1880.0  2245.4  2343.3   126.79372
      304  242.81  1767.8  2173.3  2276.1   125.35358
      305  243.03  1941.9  2337.6  2405.1   117.08048
      306  243.24  1846.0  2191.7  2296.6   130.33176
      307  243.46  1939.4  2367.9  2423.2   112.90651
      308  243.68  1964.8  2411.7  2502.6   120.34834
      309  243.90  1819.4  2269.6  2356.4   119.29027
      310  244.11  1827.2  2304.0  2406.4   121.47758
      311  244.33  1847.3  2324.0  2462.9   129.12366
      312  244.55  1863.7  2390.0  2481.7   117.43191
      313  244.76  1861.2  2347.0  2466.2   124.53631
      314  244.98  1889.9  2426.8  2517.8   116.93369
      315  245.20  1853.8  2394.1  2473.1   114.63238
      316  245.42  1929.2  2463.3  2582.5   122.31600
      317  245.63  1848.5  2396.9  2541.5   126.36285
      318  245.85  1783.0  2386.3  2478.9   115.34282
      319  246.07  1896.0  2454.7  2568.6   120.38122
      320  246.29  1903.8  2523.1  2654.2   121.16401
      321  246.50  1909.9  2501.4  2690.2   131.92528
      322  246.72  1938.2  2512.9  2709.9   134.28358
      323  246.94  1878.0  2476.0  2660.7   130.89044
      324  247.15  1844.8  2458.4  2633.7   128.57138
      325  247.37  1973.0  2663.6  2837.7   125.20769
      326  247.59  1862.0  2539.5  2673.0   119.70986
      327  247.81  1939.8  2625.5  2823.7   128.91273
      328  248.02  1868.6  2557.9  2720.5   123.58888
      329  248.24  1972.2  2670.6  2795.9   117.94727
      330  248.46  1895.2  2588.6  2793.0   129.47442
      331  248.67  1881.7  2609.9  2784.0   123.90337
      332  248.89  1931.6  2675.5  2902.0   130.45164
      333  249.11  1906.2  2738.1  2927.4   122.74750
      334  249.33  1928.4  2746.3  2942.1   123.93592
      335  249.54  1889.9  2712.3  2904.0   123.30680
      336  249.76  1869.8  2636.6  2903.6   134.82902
      337  249.98  1809.6  2657.0  2839.3   121.50794
      338  250.19  1904.6  2708.6  2949.5   129.95428
      339  250.41  1890.3  2785.2  3024.0   126.68189
      340  250.63  1932.9  2820.5  2999.0   120.11988
      341  250.84  1850.5  2752.1  3035.9   131.48578
      342  251.06  1871.4  2814.7  3040.8   123.96877
      343  251.28  1880.9  2840.5  3074.0   124.32772
      344  251.50  1790.7  2765.6  3028.5   126.97477
      345  251.71  1892.3  2866.3  3110.9   125.10518
      346  251.93  1904.2  2942.5  3140.8   119.09265
      347  252.15  1864.9  2874.1  3110.9   123.45787
      348  252.36  1863.2  2877.4  3122.3   124.15185
      349  252.58  2012.7  3099.8  3350.1   123.02178
      350  252.80  1835.8  2917.5  3157.1   122.15076
      351  253.01  1969.3  3039.2  3326.3   126.83765
      352  253.23  1926.7  3072.8  3342.3   123.51683
      353  253.45  1872.3  3031.0  3271.8   120.78471
      354  253.66  1930.4  3040.0  3394.7   131.96748
      355  253.88  1897.6  2998.2  3336.1   130.70341
      356  254.10  1824.7  3022.0  3301.3   123.33219
      357  254.31  1925.1  3126.0  3396.4   122.51016
      358  254.53  1778.0  3021.2  3234.2   117.13337
      359  254.75  1963.2  3155.5  3458.2   125.38649
      360  254.97  1974.2  3205.9  3489.7   123.04628
      361  255.18  1882.5  3141.6  3502.8   128.69229
      362  255.40  1835.8  3098.6  3426.3   125.94874
      363  255.62  1776.0  3017.1  3308.7   123.49829
      364  255.83  1847.7  3171.5  3472.1   122.71041
      365  256.05  1926.3  3198.1  3512.7   124.73429
      366  256.27  1851.4  3090.8  3443.0   128.42040
      367  256.48  1868.2  3117.4  3487.3   129.60654
      368  256.70  1920.6  3256.3  3612.6   126.67897
      369  256.92  1897.6  3272.2  3541.3   119.57695
      370  257.13  1921.8  3219.4  3595.0   128.94567
      371  257.35  1783.4  3095.7  3522.1   132.49061
      372  257.57  1983.3  3285.4  3633.1   126.70659
      373  257.78  1866.9  3255.9  3616.3   125.95100
      374  258.00  2018.5  3394.7  3768.7   127.17261
      375  258.21  1966.9  3353.8  3653.2   121.58888
      376  258.43  1946.4  3321.0  3700.3   127.59240
      377  258.65  1892.7  3326.3  3727.7   128.00001
      378  258.86  1901.3  3314.8  3668.7   125.03622
      379  259.08  1940.7  3375.9  3762.1   126.91210
      380  259.30  1937.4  3405.4  3851.8   130.41300
      381  259.51  1976.7  3454.1  3844.9   126.44860
      382  259.73  1797.7  3300.1  3670.8   124.67282
      383  259.95  1946.0  3441.4  3873.1   128.86881
      384  260.16  1917.3  3473.4  3828.1   122.79546
      385  260.38  2002.9  3534.8  3950.5   127.13905
      386  260.60  1831.7  3372.6  3760.9   125.19937
      387  260.81  1914.4  3470.9  3838.3   123.60529
      388  261.03  1906.7  3495.1  3887.0   124.67773
      389  261.25  1776.4  3373.0  3808.0   127.24470
      390  261.46  1860.0  3448.8  3849.8   125.23851
      391  261.68  1821.5  3464.3  3854.7   123.75966
      392  261.89  1850.5  3552.0  3987.4   125.58979
      393  262.11  1881.7  3482.4  3881.7   124.94883
      394  262.33  1851.4  3487.7  3874.3   123.62951
      395  262.54  1775.6  3386.5  3898.1   131.75696
      396  262.76  1887.8  3537.7  4000.1   128.02885
      397  262.98  1937.4  3595.8  4003.0   124.54925
      398  263.19  1826.0  3508.2  3967.7   127.31927
      399  263.41  1834.6  3450.4  3955.0   131.22936
      400  263.62  1883.7  3550.4  3999.3   126.93532
      401  263.84  1882.9  3605.2  4046.4   125.61239
      402  264.06  1822.7  3569.2  4032.0   126.50094
      403  264.27  1892.7  3538.9  3957.5   125.42923
      404  264.49  1900.5  3579.8  4013.2   125.80493
      405  264.71  1871.8  3545.0  3986.2   126.36471
      406  264.92  1901.3  3627.0  4064.0   125.32633
      407  265.14  1989.8  3682.2  4236.0   132.72024
      408  265.35  1945.6  3654.0  4108.6   126.61231
      409  265.57  1895.2  3536.8  4043.1   130.83833
      410  265.79  1851.0  3485.2  4038.2   133.83461
      411  266.00  1849.7  3571.2  3983.3   123.93526
      412  266.22  2007.4  3711.3  4200.8   128.72599
      413  266.43  1835.8  3526.6  3997.2   127.83429
      414  266.65  1845.2  3565.5  4030.8   127.04759
      415  266.87  1826.8  3596.6  4029.2   124.43878
      416  267.08  1780.5  3506.1  3991.5   128.12718
      417  267.30  1801.4  3563.9  4075.0   129.00302
      418  267.51  1927.5  3724.0  4215.5   127.35981
      419  267.73  1845.2  3648.3  4132.0   126.82870
      420  267.95  2016.4  3785.5  4240.5   125.72357
      421  268.16  1821.1  3613.0  4042.7   123.97716
      422  268.38  1884.1  3743.7  4173.8   123.12773
      423  268.59  1875.5  3715.4  4129.9   122.52895
      424  268.81  1923.0  3753.1  4198.7   124.35094
      425  269.03  1924.7  3708.5  4218.4   128.58781
      426  269.24  1862.8  3650.3  4192.2   130.31625
      427  269.46  1930.4  3845.7  4329.0   125.23520
      428  269.67  1882.5  3731.8  4294.6   130.43185
      429  269.89  1852.2  3794.5  4209.0   121.34122
      430  270.11  1813.7  3727.7  4213.5   125.37983
      431  270.32  1929.6  3904.7  4418.7   126.02654
      432  270.54  1862.0  3777.7  4295.0   127.00449
      433  270.75  2063.9  4010.3  4615.3   131.08166
      434  270.97  1869.8  3751.9  4296.6   128.94446
      435  271.19  1890.7  3869.8  4374.1   125.47600
      436  271.40  1837.4  3859.6  4432.2   128.31679
      437  271.62  1803.4  3766.2  4295.8   126.98242
      438  271.83  1754.3  3797.8  4285.6   123.87251
      439  272.05  1768.2  3740.0  4317.1   129.26876
      440  272.26  1916.5  3935.0  4514.5   128.71347
      441  272.48  1962.0  3912.8  4518.6   131.05185
      442  272.70  1932.1  3969.8  4585.0   130.19091
      443  272.91  1907.9  3916.5  4460.1   127.05956
      444  273.13  1928.4  4005.0  4529.7   125.26624
      445  273.34  1946.4  4020.6  4551.4   125.59245
      446  273.56  1849.3  3937.0  4537.9   128.78164
      447  273.77  1860.8  3974.3  4470.3   123.46899
      448  273.99  2008.6  4088.2  4664.0   127.69354
      449  274.21  2034.9  4102.9  4756.2   131.59041
      450  274.42  2013.2  4027.9  4646.4   130.69731
      451  274.64  1837.4  3937.4  4545.3   128.94480
      452  274.85  1902.2  3984.5  4569.4   128.08812
      453  275.07  1843.2  3927.2  4445.7   124.88209
      454  275.28  1825.2  3898.9  4496.9   128.83667
      455  275.50  1919.4  4025.5  4625.5   128.49087
      456  275.71  1821.5  3919.4  4444.1   125.00972
      457  275.93  1822.3  3866.2  4475.6   129.81968
      458  276.15  1894.4  3975.1  4515.8   125.98427
      459  276.36  1851.0  3971.0  4525.6   126.15920
      460  276.58  1966.5  4079.6  4622.7   125.70264
      461  276.79  1860.8  3942.7  4461.7   124.92626
      462  277.01  1871.4  3973.1  4535.8   126.77842
      463  277.22  1930.0  3940.7  4532.6   129.43574
      464  277.44  2045.5  4207.8  4784.1   126.65275
      465  277.65  1942.7  4063.2  4571.1   123.95208
      466  277.87  1911.6  3985.8  4561.6   127.76462
      467  278.08  1851.8  3984.9  4515.0   124.84637
      468  278.30  2023.8  4190.6  4780.0   127.20225
      469  278.52  1881.7  4068.9  4638.6   126.04870
      470  278.73  1903.8  4034.5  4618.2   127.39336
      471  278.95  1884.1  4007.9  4559.6   125.97879
      472  279.16  1835.4  4015.7  4590.3   126.35732
      473  279.38  1894.8  4015.2  4648.9   129.88214
      474  279.59  1918.1  4109.9  4703.8   127.09774
      475  279.81  1782.6  3975.5  4628.4   129.77211
      476  280.02  1953.8  4207.8  4870.1   129.38396
      477  280.24  1985.3  4209.0  4893.8   130.79759
      478  280.45  1865.7  4156.6  4716.1   124.42339
      479  280.67  1859.6  4107.8  4757.4   128.89412
      480  280.88  1920.6  4215.9  4859.8   128.05142
      481  281.10  1991.4  4288.0  4885.2   126.00323
      482  281.31  1885.8  4309.7  5042.5   130.22985
      483  281.53  1934.9  4233.6  4885.6   128.36777
      484  281.74  1934.1  4256.5  4938.1   129.34745
      485  281.96  1856.3  4202.4  4894.2   129.48674
      486  282.17  1885.0  4231.1  4942.2   130.30727
      487  282.39  1939.4  4347.8  5024.1   128.07821
      488  282.60  1808.8  4222.9  4876.2   127.06141
      489  282.82  1891.1  4315.5  4989.7   127.80873
      490  283.04  1902.2  4313.8  5005.6   128.68547
      491  283.25  1948.0  4390.4  5046.6   126.86571
      492  283.47  1911.2  4368.7  5004.4   125.86664
      493  283.68  1942.7  4446.6  5092.9   125.81384
      494  283.90  1894.8  4465.8  5185.5   127.99107
      495  284.11  1941.9  4403.5  5102.3   128.38603
      496  284.33  1828.4  4319.2  4990.5   126.95280
      497  284.54  1857.9  4337.6  5012.6   127.22165
      498  284.76  1858.7  4313.0  5036.8   129.48931
      499  284.97  1937.8  4441.6  5190.8   129.91984
      500  285.19  1882.9  4349.5  5089.2   129.99002
      501  285.40  1951.7  4435.5  5108.0   127.07783
      502  285.62  1995.1  4524.0  5237.9   128.23129
      503  285.83  1853.4  4404.8  5094.5   127.03485
      504  286.05  1920.6  4379.0  5107.6   129.64010
      505  286.26  1861.2  4398.6  5002.4   123.79338
      506  286.48  1922.2  4391.7  5147.0   130.58550
      507  286.69  1933.7  4453.1  5105.6   125.89824
      508  286.91  1843.6  4338.0  4996.2   126.38755
      509  287.12  2023.0  4507.6  5177.3   126.95353
      510  287.33  1871.0  4319.6  5035.1   129.22380
      511  287.55  1822.3  4364.2  5040.9   126.61941
      512  287.76  1939.8  4459.2  5135.5   126.84115
      513  287.98  1935.7  4466.2  5165.8   127.64648
      514  288.19  1999.2  4510.0  5233.8   128.82544
      515  288.41  1778.9  4218.8  4963.0   130.50190
      516  288.62  1892.7  4391.7  5051.1   126.38912
      517  288.84  1919.4  4448.2  5170.3   128.55524
      518  289.05  1789.5  4256.1  4975.3   129.15972
      519  289.27  1776.8  4375.7  5090.4   127.50197
      520  289.48  1922.2  4376.1  5124.4   130.49570
      521  289.70  1830.5  4342.9  5049.9   128.13820
      522  289.91  1934.5  4572.3  5269.0   126.41304
      523  290.13  1815.7  4369.5  5013.4   125.21253
      524  290.34  1878.8  4566.2  5267.0   126.07835
      525  290.56  1903.8  4475.2  5141.2   125.90000
      526  290.77  1869.0  4580.1  5231.7   124.03688
      527  290.99  1841.5  4426.1  5187.1   129.44532
      528  291.20  1837.4  4476.9  5214.9   127.96400
      529  291.41  1843.6  4492.4  5174.4   125.74611
      530  291.63  1857.1  4575.6  5281.3   125.96052
      531  291.84  1875.1  4546.1  5282.1   127.55712
      532  292.06  1933.7  4624.7  5347.2   126.84930
      533  292.27  1856.7  4546.5  5329.6   129.11525
      534  292.49  1847.7  4547.7  5296.0   127.71542
      535  292.70  2018.5  4747.6  5480.8   126.86478
      536  292.92  1859.6  4738.2  5483.2   125.88223
      537  293.13  1929.2  4752.1  5517.6   127.11837
      538  293.35  1803.0  4706.2  5463.2   126.07223
      539  293.56  1918.1  4728.4  5551.6   129.29605
      540  293.77  1804.3  4657.5  5461.9   128.19407
      541  293.99  1939.8  4821.3  5691.7   130.20612
      542  294.20  1801.0  4664.0  5455.0   127.62520
      543  294.42  1871.4  4772.2  5672.9   131.05053
      544  294.63  1905.4  4863.5  5638.1   126.18389
      545  294.85  1975.5  4940.1  5661.8   124.34374
      546  295.06  1805.9  4794.3  5676.1   129.50931
      547  295.28  1833.3  4825.0  5686.8   128.80617
      548  295.49  1771.1  4734.5  5526.2   126.71735
      549  295.70  1991.4  4973.7  5788.0   127.30393
      550  295.92  1839.1  4945.0  5747.8   125.84730
      551  296.13  1985.3  4937.2  5726.5   126.73789
      552  296.35  1958.3  4993.8  5837.1   127.78304
      553  296.56  1886.6  4931.5  5749.5   126.86304
      554  296.78  1858.7  4862.3  5674.1   127.02851
      555  296.99  1830.5  4924.1  5697.4   124.99669
      556  297.20  1848.1  4830.7  5732.3   130.22521
      557  297.42  1960.7  5045.0  5896.5   127.60958
      558  297.63  1865.3  4890.5  5754.4   128.55405
      559  297.85  1844.8  4837.3  5735.1   130.00275
      560  298.06  1829.7  4832.8  5748.6   130.49643
      561  298.28  1882.5  4973.3  5844.9   128.20039
      562  298.49  1778.0  4773.4  5616.8   128.15531
      563  298.70  1819.0  4908.6  5732.3   126.66048
      564  298.92  1946.0  5040.9  5761.8   123.29275
      565  299.13  1960.3  4982.3  5824.4   127.86665
      566  299.35  1963.6  4977.4  5815.8   127.82008
      567  299.56  1940.7  4980.7  5796.6   126.83913
      568  299.77  1795.7  4862.7  5792.9   130.32851
      569  299.99  1874.3  4908.2  5704.4   126.24543
      570  300.20  1865.3  4876.2  5726.5   128.24103
      571  300.42  1856.7  4906.1  5819.1   129.93954
      572  300.63  1919.4  4965.5  5806.8   127.61868
      573  300.85  1978.7  4970.8  5806.0   127.91236
      574  301.06  1949.7  5016.3  5844.1   126.99345
      575  301.27  1887.4  4983.9  5799.4   126.33597
      576  301.49  1866.5  4909.0  5767.1   128.20410
      577  301.70  1923.9  5003.6  5828.5   126.78549
      578  301.92  1968.5  5056.4  5849.4   125.67978
      579  302.13  1862.8  4881.5  5752.3   128.84670
      580  302.34  1892.7  4930.7  5765.9   127.49088
      581  302.56  1967.3  5022.4  5891.2   128.43543
      582  302.77  1808.8  4949.9  5830.2   128.02191
      583  302.99  1845.2  4937.7  5742.1   126.01324
      584  303.20  1903.4  4968.0  5899.8   130.40628
      585  303.41  1903.0  4960.2  5745.4   125.68331
      586  303.63  1881.3  5117.1  5969.4   126.34175
      587  303.84  1812.5  4949.9  5703.6   124.02090
      588  304.05  1809.6  4938.5  5847.0   129.03521
      589  304.27  1884.1  5030.6  5824.4   125.22782
      590  304.48  1875.5  5127.3  5926.8   124.58748
      591  304.70  1792.0  5028.2  5835.5   124.94620
      592  304.91  1952.9  5133.0  6014.9   127.73054
      593  305.12  1937.8  5086.3  5976.0   128.25551
      594  305.34  1786.6  5037.6  5887.1   126.13076
      595  305.55  1848.5  5071.2  5849.4   124.14845
      596  305.77  1781.3  4995.4  5806.0   125.21983
      597  305.98  1948.8  5210.0  6150.9   128.84954
      598  306.19  1795.7  5083.5  5940.7   126.07451
      599  306.41  1916.9  5225.2  6060.8   125.25693
      600  306.62  1802.2  5126.1  6007.1   126.50646
      601  306.83  1963.2  5215.8  6124.7   127.94357
      602  307.05  1853.4  5255.9  6140.2   125.99013
      603  307.26  1806.3  5136.3  5957.1   124.64944
      604  307.47  1959.5  5328.4  6198.4   125.82370
      605  307.69  1974.2  5319.0  6246.7   127.73697
      606  307.90  1797.7  5167.4  6035.8   125.76882
      607  308.12  1864.5  5206.3  6034.1   124.77020
      608  308.33  1869.4  5371.0  6220.1   124.24845
      609  308.54  2025.4  5438.2  6348.3   126.66829
      610  308.76  1776.8  5172.4  6058.3   126.09167
      611  308.97  1926.7  5359.1  6228.7   125.33411
      612  309.18  1930.0  5465.6  6352.0   125.06951
      613  309.40  1815.7  5180.1  6108.3   127.58706
      614  309.61  1899.3  5337.8  6267.6   127.03991
      615  309.82  1816.1  5256.3  6253.3   128.97963
      616  310.04  1837.4  5230.5  6189.4   128.25930
      617  310.25  1964.8  5425.1  6345.0   126.58619
      618  310.46  1790.7  5320.6  6298.7   127.70945
      619  310.68  1866.9  5339.9  6244.3   126.04080
      620  310.89  1894.8  5332.5  6236.9   126.30764
      621  311.11  1809.6  5314.9  6204.1   125.36811
      622  311.32  1841.1  5317.3  6198.4   125.34464
      623  311.53  1839.9  5257.5  6249.6   129.02685
      624  311.75  1951.3  5407.0  6348.7   127.24902
      625  311.96  1925.1  5404.2  6238.1   123.96987
      626  312.17  1878.0  5364.4  6273.3   126.06909
      627  312.39  1861.2  5355.4  6338.5   128.13269
      628  312.60  1917.3  5309.6  6210.3   126.55153
      629  312.81  1948.4  5389.0  6293.8   126.29763
      630  313.03  1979.2  5466.0  6365.9   125.80757
      631  313.24  1929.2  5330.9  6138.2   123.73268
      632  313.45  1866.1  5283.8  6167.3   125.85092
      633  313.67  1943.5  5369.0  6308.6   127.43034
      634  313.88  1875.9  5292.0  6179.5   125.98322
      635  314.09  1899.3  5330.5  6259.8   127.08606
      636  314.31  1855.5  5287.0  6319.2   130.07877
      637  314.52  1907.1  5246.5  6161.5   127.40097
      638  314.73  1880.0  5303.4  6152.1   124.79061
      639  314.95  1858.3  5325.9  6199.6   125.19488
      640  315.16  2024.2  5359.5  6238.9   126.36621
      641  315.37  1964.4  5374.7  6148.8   122.69997
      642  315.58  1855.5  5194.9  6116.5   127.59717
      643  315.80  1782.6  5106.4  6053.8   128.50279
      644  316.01  1811.2  5183.0  6047.2   125.63169
      645  316.22  1868.6  5171.5  6065.3   127.05851
      646  316.44  1851.8  5244.4  6097.2   125.13584
      647  316.65  1961.1  5210.4  6100.9   127.40452
      648  316.86  1853.8  5233.4  6122.6   126.31196
      649  317.08  1939.0  5223.1  6082.5   126.16610
      650  317.29  1890.7  5159.7  5988.7   125.36024
      651  317.50  1867.3  5005.6  5900.2   128.50432
      652  317.72  1837.0  5049.5  5875.2   125.70445
      653  317.93  1962.8  5167.8  6002.6   126.04473
      654  318.14  1896.4  5085.5  5906.8   125.75133
      655  318.35  1946.8  5122.4  5976.8   126.90573
      656  318.57  1868.2  5006.9  5853.5   126.97376
      657  318.78  1942.3  5137.1  6000.1   127.01282
      658  318.99  2002.9  5270.7  6089.4   125.05641
      659  319.21  1805.1  5033.5  5969.4   128.99008
      660  319.42  1980.0  5280.9  6211.5   128.19208
      661  319.63  1868.6  4976.6  5819.9   127.13497
      662  319.85  1762.5  5097.0  5988.3   126.72890
      663  320.06  1845.6  5128.5  5967.4   125.55209
      664  320.27  1858.7  5118.7  5965.7   125.98316
      665  320.48  1742.0  5111.3  5996.9   126.28253
      666  320.70  1860.8  5183.4  6123.8   128.30374
      667  320.91  1915.3  5269.4  6147.2   126.16923
      668  321.12  1903.4  5231.7  6105.0   126.23677
      669  321.34  1850.5  5325.9  6133.3   123.22922
      670  321.55  1848.1  5308.3  6185.7   125.35512
      671  321.76  1862.8  5206.3  6003.8   123.85152
      672  321.97  1919.8  5293.2  6166.4   125.88636
      673  322.19  1888.2  5325.1  6232.0   126.38543
      674  322.40  1877.2  5404.2  6281.5   124.87516
      675  322.61  1920.6  5209.2  6243.4   131.44853
      676  322.83  1882.1  5364.9  6300.4   126.86110
      677  323.04  1872.7  5334.5  6301.2   127.92238
      678  323.25  1836.2  5350.5  6301.2   127.05128
      679  323.46  1941.1  5499.2  6352.8   123.98986
      680  323.68  1911.6  5517.6  6445.0   125.71561
      681  323.89  1823.1  5349.3  6274.2   126.22838
      682  324.10  1806.7  5335.0  6379.0   129.59135
      683  324.31  1942.3  5669.2  6533.8   123.20037
      684  324.53  1857.1  5670.4  6548.6   123.02900
      685  324.74  1958.7  5677.8  6689.5   127.20262
      686  324.95  1939.0  5738.4  6737.4   126.29369
      687  325.16  1966.9  5724.5  6782.1   128.14476
      688  325.38  1911.2  5777.3  6790.2   126.19980
      689  325.59  1911.6  5872.8  6915.2   126.31579
      690  325.80  1891.1  5724.5  6739.5   126.47721
      691  326.01  1937.8  5777.3  6789.8   126.37082
      692  326.23  1965.6  5888.3  6872.6   125.09137
      693  326.44  1897.6  5754.0  6795.6   127.01009
      694  326.65  1841.1  5685.2  6653.4   125.18914
      695  326.86  1958.3  5538.9  6521.1   127.43080
      696  327.08  1926.3  5604.1  6482.2   123.87793
      697  327.29  1878.8  5583.2  6424.5   122.71121
      698  327.50  1877.6  5528.7  6519.9   127.14831
      699  327.71  1925.5  5596.3  6498.6   124.58157
      700  327.93  1729.3  5314.1  6304.5   127.62798
      701  328.14  1819.0  5435.7  6391.7   126.43259
      702  328.35  1845.2  5434.5  6307.3   124.31815
      703  328.56  1894.0  5487.3  6435.5   126.38780
      704  328.78  1906.7  5493.1  6416.3   125.74234
      705  328.99  2031.2  5635.2  6470.4   123.17307
      706  329.20  1815.7  5489.4  6365.5   123.84881
      707  329.41  1889.5  5486.9  6398.3   125.33303
      708  329.63  1900.5  5549.6  6494.1   125.88393
      709  329.84  1870.2  5440.6  6309.8   124.34324
      710  330.05  1940.2  5482.8  6410.1   126.17643
      711  330.26  1845.6  5416.1  6363.4   126.53435
      712  330.48  1750.2  5338.6  6257.8   125.61350
      713  330.69  1823.5  5408.7  6388.4   127.32779
      714  330.90  1869.4  5496.7  6385.2   124.49188
      715  331.11  1775.6  5331.7  6257.4   126.03087
      716  331.32  1799.3  5403.0  6275.8   124.22140
      717  331.54  1943.1  5423.0  6338.1   126.29475
      718  331.75  1868.2  5280.1  6204.9   127.10685
      719  331.96  1895.2  5492.2  6337.2   123.49123
      720  332.17  1976.3  5529.9  6499.8   127.29369
      721  332.39  1771.9  5297.7  6229.9   126.44051
      722  332.60  1788.7  5371.0  6286.0   125.54309
      723  332.81  1882.1  5414.4  6320.4   125.64934
      724  333.02  1812.5  5343.1  6233.2   125.20884
      725  333.23  1798.1  5263.7  6252.4   128.53093
      726  333.45  1801.8  5369.0  6216.0   123.74555
      727  333.66  1922.2  5443.5  6296.7   124.22938
      728  333.87  1874.7  5310.0  6298.7   128.78267
      729  334.08  1851.8  5436.1  6364.7   125.90561
      730  334.29  1949.3  5388.2  6225.8   124.35683
      731  334.51  1890.3  5466.0  6322.1   123.94043
      732  334.72  1930.4  5365.3  6413.0   130.50319
      733  334.93  1874.3  5416.9  6413.4   128.13043
      734  335.14  1894.4  5447.6  6318.8   124.51873
      735  335.35  1797.3  5298.1  6177.9   125.13164
      736  335.57  1802.6  5405.0  6360.6   126.52643
      737  335.78  1865.7  5440.2  6295.5   123.92576
      738  335.99  1819.8  5423.8  6370.4   126.26437
      739  336.20  1771.1  5321.0  6249.2   126.14516
      740  336.41  1836.6  5371.0  6189.0   123.14289
      741  336.63  1931.2  5569.2  6461.8   124.53277
      742  336.84  1816.1  5450.9  6297.5   123.29276
      743  337.05  1873.1  5514.4  6397.9   124.26319
      744  337.26  1983.3  5639.3  6569.5   125.44252
      745  337.47  1797.3  5429.6  6374.9   126.02615
      746  337.69  1966.9  5649.9  6590.4   125.53380
      747  337.90  1844.4  5522.1  6454.8   125.35917
      748  338.11  1927.5  5555.3  6454.8   124.79395
      749  338.32  2031.6  5570.9  6512.5   126.60571
      750  338.53  1812.9  5445.5  6384.7   125.85409
      751  338.74  1855.0  5502.1  6404.4   124.74169
      752  338.96  1948.8  5699.9  6519.5   121.84974
      753  339.17  2052.1  5773.2  6713.7   125.27242
      754  339.38  1975.9  5711.8  6638.7   124.81088
      755  339.59  1921.8  5644.6  6642.4   126.80165
      756  339.80  1901.7  5652.8  6583.4   124.80891
      757  340.01  1957.0  5708.1  6621.5   124.35032
      758  340.23  1947.6  5692.9  6594.5   124.07040
      759  340.44  1795.2  5489.4  6409.7   124.91409
      760  340.65  1913.6  5720.8  6730.4   126.51962
      761  340.86  1895.2  5637.6  6594.5   125.56638
      762  341.07  1882.9  5712.6  6610.8   123.45454
      763  341.28  1887.4  5602.8  6581.4   126.33666
      764  341.50  1911.6  5680.2  6584.2   123.98654
      765  341.71  1871.0  5620.0  6574.4   125.45612
      766  341.92  1926.7  5767.9  6666.1   123.38452
      767  342.13  1839.1  5733.9  6651.0   123.54610
      768  342.34  1821.5  5714.2  6620.7   123.28493
      769  342.55  1823.1  5621.7  6600.6   125.77097
      770  342.77  1789.9  5622.1  6561.3   124.50833
      771  342.98  1912.8  5731.0  6675.1   124.72644
      772  343.19  1894.8  5708.5  6688.7   125.70079
      773  343.40  1911.6  5759.3  6707.9   124.65403
      774  343.61  1823.5  5739.6  6693.6   124.35938
      775  343.82  1888.2  5698.3  6624.4   124.30662
      776  344.03  1766.6  5648.7  6511.7   122.23043
      777  344.25  1945.2  5795.3  6698.9   123.46809
      778  344.46  1787.1  5618.8  6665.7   127.32230
      779  344.67  2052.5  5860.1  6869.3   126.50602
      780  344.88  1874.7  5688.8  6651.8   125.24697
      781  345.09  1942.3  5788.0  6728.0   124.44351
      782  345.30  1818.6  5685.2  6614.1   124.02543
      783  345.51  1925.1  5790.4  6740.3   124.57349
      784  345.73  1895.2  5772.8  6689.5   123.64002
      785  345.94  1887.0  5698.3  6577.3   123.06286
      786  346.15  1911.6  5822.8  6809.1   125.21728
      787  346.36  1859.1  5632.3  6664.5   127.35561
      788  346.57  1930.0  5710.1  6643.2   124.68308
      789  346.78  1802.6  5727.8  6629.7   122.97818
      790  346.99  1804.3  5698.7  6686.6   125.36810
      791  347.21  2027.1  5803.5  6689.1   123.44903
      792  347.42  1915.7  5595.1  6568.2   126.44994
      793  347.63  1904.6  5618.0  6459.7   122.66710
      794  347.84  1945.2  5749.1  6587.5   122.04155
      795  348.05  1856.3  5612.7  6578.9   125.72240
      796  348.26  1832.5  5573.8  6443.7   123.25377
      797  348.47  1814.5  5519.3  6483.1   126.01437
      798  348.68  1830.9  5541.0  6511.7   126.16471
      799  348.89  1915.7  5648.7  6531.8   123.65594
      800  349.11  1895.2  5638.1  6532.2   123.88925
      801  349.32  1925.5  5553.3  6604.7   128.98272
      802  349.53  1778.0  5401.3  6346.7   126.09087
      803  349.74  1917.7  5562.3  6441.7   124.12903
      804  349.95  1776.8  5456.2  6371.6   124.88033
      805  350.16  1911.6  5589.3  6442.1   123.18743
      806  350.37  1769.0  5497.6  6393.3   124.02506
      807  350.58  1939.4  5561.5  6491.2   125.67002
      808  350.79  1934.5  5586.9  6510.1   125.27755
      809  351.01  1932.5  5514.0  6482.6   127.04711
      810  351.22  2004.6  5561.9  6501.5   126.41335
      811  351.43  1866.1  5410.3  6311.4   125.42470
      812  351.64  1907.9  5557.4  6429.0   123.88329
      813  351.85  1914.4  5514.4  6447.4   125.91874
      814  352.06  1838.7  5486.1  6270.9   121.51598
      815  352.27  1825.6  5470.9  6340.1   123.84269
      816  352.48  1842.8  5553.7  6400.3   122.81456
      817  352.69  1971.0  5551.2  6455.2   125.24884
      818  352.90  1948.0  5379.2  6275.0   126.10718
      819  353.12  1927.5  5494.3  6344.6   123.84013
      820  353.33  1894.8  5467.3  6365.9   125.15479
      821  353.54  1864.1  5381.7  6339.3   127.22403
      822  353.75  1955.0  5488.1  6424.5   126.50126
      823  353.96  1882.9  5449.6  6327.8   124.62103
      824  354.17  1839.5  5410.3  6280.7   124.37487
      825  354.38  1911.2  5567.6  6492.9   125.30524
      826  354.59  1853.0  5426.7  6305.3   124.58451
      827  354.80  1962.0  5500.4  6429.0   126.24149
      828  355.01  1837.0  5418.5  6229.9   122.65553
      829  355.22  1900.1  5448.4  6337.2   125.04907
      830  355.43  1779.7  5512.7  6310.2   121.36274
      831  355.64  2009.5  5509.9  6466.7   127.33443
      832  355.86  1989.0  5576.2  6440.9   124.10369
      833  356.07  1949.7  5616.8  6490.4   123.82443
      834  356.28  1854.6  5552.5  6413.0   123.27203
      835  356.49  1772.3  5339.5  6168.9   123.25180
      836  356.70  1845.2  5523.8  6411.0   124.11758
      837  356.91  1994.3  5611.8  6494.9   124.41123
      838  357.12  1851.0  5509.9  6396.6   124.23599
      839  357.33  1846.4  5404.6  6370.8   127.15550
      840  357.54  1901.7  5614.3  6473.2   123.13548
      841  357.75  1872.3  5526.6  6448.6   125.22978
      842  357.96  1800.6  5345.2  6388.8   129.44304
      843  358.17  1938.6  5587.7  6406.9   122.44919
      844  358.38  1883.7  5505.4  6469.1   126.61162
      845  358.59  1902.6  5455.0  6457.2   128.21397
      846  358.80  1935.7  5617.2  6449.1   122.59680
      847  359.02  1837.0  5489.4  6387.6   124.59350
      848  359.23  1792.8  5470.5  6405.2   125.41486
      849  359.44  1946.0  5558.2  6540.4   127.19130
      850  359.65  1788.7  5482.0  6416.3   125.29665
      851  359.86  2096.7  5799.4  6808.7   127.25663
      852  360.07  1846.9  5555.7  6440.5   123.85421
      853  360.28  1795.7  5485.3  6238.5   120.41516
      854  360.49  1798.1  5525.8  6469.5   125.31590
      855  360.70  1910.8  5644.2  6654.3   127.05430
      856  360.91  1800.2  5644.6  6520.3   122.77863
      857  361.12  1875.9  5525.8  6458.1   125.54148
      858  361.33  1846.4  5603.7  6480.2   123.32935
      859  361.54  1880.4  5627.0  6546.9   124.55448
      860  361.75  1926.3  5639.7  6478.1   122.57888
      861  361.96  1839.5  5674.9  6568.7   123.30202
      862  362.17  1889.9  5690.9  6671.1   125.78662
      863  362.38  1853.8  5611.4  6549.0   124.95095
      864  362.59  1922.2  5849.0  6825.9   124.87743
      865  362.80  1973.8  5645.0  6584.6   125.59411
      866  363.01  1831.3  5621.7  6566.6   124.92977
      867  363.22  1867.3  5647.1  6656.7   126.71219
      868  363.43  1801.4  5516.4  6428.6   124.55346
      869  363.64  1950.9  5741.7  6560.9   121.60995
      870  363.85  1851.4  5567.2  6497.4   125.03309
      871  364.06  1855.5  5760.5  6667.4   123.22217
      872  364.27  1843.6  5695.4  6768.9   127.87111
      873  364.48  1895.6  5774.0  6667.8   123.04363
      874  364.69  1789.9  5605.7  6614.1   126.42766
      875  364.90  1815.7  5564.7  6491.7   124.72411
      876  365.11  1864.9  5695.0  6754.2   127.65478
      877  365.33  1878.0  5751.1  6652.2   123.26564
      878  365.54  1869.0  5716.7  6617.8   123.41920
      879  365.75  1909.1  5717.5  6623.5   123.79008
      880  365.96  1918.9  5696.2  6540.0   122.33789
      881  366.17  1837.4  5666.7  6544.5   122.92223
      882  366.38  1835.0  5643.4  6565.0   124.19875
      883  366.59  1851.0  5660.2  6567.8   123.82796
      884  366.80  1790.7  5529.9  6516.2   126.37749
      885  367.01  1949.7  5819.1  6852.9   126.71749
      886  367.22  1836.2  5533.2  6386.4   123.07778
      887  367.43  1848.5  5555.7  6484.7   125.05799
      888  367.64  1907.1  5658.9  6501.5   122.45635
      889  367.85  1869.8  5621.7  6510.1   123.67904
      890  368.06  1832.9  5447.2  6427.3   127.11923
      891  368.27  1767.0  5536.9  6446.2   124.11994
      892  368.48  1983.7  5792.5  6688.3   123.51865
      893  368.69  1812.9  5310.0  6276.2   127.62943
      894  368.90  1826.8  5491.8  6388.0   124.45239
      895  369.11  1796.1  5495.5  6377.0   123.82641
      896  369.32  1950.9  5645.4  6568.7   124.98890
      897  369.53  1851.8  5458.2  6354.8   124.86088
      898  369.74  1828.8  5461.9  6314.3   123.46109
      899  369.94  1891.5  5438.2  6265.6   123.32835
      900  370.15  1833.3  5445.5  6350.8   125.05953
      901  370.36  1973.0  5608.2  6454.8   123.29013
      902  370.57  1822.3  5309.6  6170.1   124.67699
      903  370.78  1891.1  5519.3  6395.0   124.13636
      904  370.99  1833.3  5396.0  6310.6   125.67258
      905  371.20  1922.2  5555.7  6375.3   122.55664
      906  371.41  1923.5  5522.1  6386.4   124.01548
      907  371.62  1838.7  5424.7  6226.2   122.35294
      908  371.83  1811.6  5381.2  6212.7   123.29316
      909  372.04  1837.0  5298.9  6173.4   125.26031
      910  372.25  1864.1  5458.2  6229.1   121.44731
      911  372.46  1885.8  5373.9  6300.0   126.55001
      912  372.67  1869.0  5326.4  6167.3   124.32176
      913  372.88  1989.4  5535.7  6427.3   125.14436
      914  373.09  1814.5  5275.2  6144.7   125.12722
      915  373.30  1847.3  5313.2  6200.8   125.60862
      916  373.51  1880.0  5300.6  6108.3   123.61394
      917  373.72  1896.0  5426.3  6325.4   125.46698
      918  373.93  1835.4  5443.9  6307.3   123.92734
      919  374.14  1888.6  5421.0  6315.9   125.33629
      920  374.35  1881.3  5364.4  6226.6   124.75306
      921  374.56  1987.3  5482.4  6324.1   124.08300
      922  374.77  1895.2  5465.6  6290.1   123.09280
      923  374.98  1821.9  5422.6  6261.5   123.29655
      924  375.19  1978.7  5488.1  6331.1   124.01960
      925  375.40  1950.9  5492.2  6388.4   125.30649
      926  375.61  1884.1  5463.6  6378.2   125.55213
      927  375.82  1912.8  5545.1  6417.1   124.00767
      928  376.03  1851.0  5489.4  6347.1   123.57314
      929  376.23  1925.5  5504.1  6379.8   124.47063
      930  376.44  1855.0  5544.3  6429.4   123.99245
      931  376.65  1912.8  5440.6  6273.3   123.60385
      932  376.86  1838.3  5483.2  6365.9   124.21619
      933  377.07  1930.4  5525.0  6401.5   124.38469
      934  377.28  1903.0  5567.6  6473.2   124.71220
      935  377.49  1799.8  5520.5  6363.0   122.64420
      936  377.70  1980.0  5581.5  6432.3   123.62106
      937  377.91  1873.9  5527.1  6428.6   124.67766
      938  378.12  1791.2  5513.5  6340.9   122.22713
      939  378.33  1815.7  5560.6  6488.4   124.77305
      940  378.54  1812.9  5463.2  6383.5   125.21322
      941  378.75  1983.7  5630.3  6525.2   124.54228
      942  378.96  1863.7  5534.0  6502.3   126.38100
      943  379.17  1880.4  5529.5  6491.2   126.35537
      944  379.37  1833.3  5559.0  6444.5   123.76870
      945  379.58  1878.8  5486.9  6404.0   125.41718
      946  379.79  1867.3  5503.3  6432.3   125.54915
      947  380.00  1814.1  5463.6  6271.7   122.14368
      948  380.21  1808.8  5470.9  6378.2   124.77351
      949  380.42  1930.0  5569.2  6401.1   122.85876
      950  380.63  1828.4  5503.7  6356.5   123.20294
      951  380.84  1866.1  5530.7  6442.5   124.87986
      952  381.05  1876.8  5477.9  6396.6   125.51184
      953  381.26  1941.9  5569.2  6407.3   123.10299
      954  381.47  1806.3  5323.5  6309.8   128.04239
      955  381.68  2015.2  5684.3  6546.9   123.50970
      956  381.89  1932.9  5590.5  6444.5   123.34827
      957  382.09  1888.6  5413.6  6244.7   123.57655
      958  382.30  2046.7  5597.1  6521.1   126.02675
      959  382.51  1959.9  5511.9  6402.8   125.08071
      960  382.72  1896.4  5485.7  6356.5   124.26109
      961  382.93  1832.5  5399.7  6293.8   125.06605
      962  383.14  1738.3  5325.1  6135.3   122.58766
      963  383.35  1868.2  5510.3  6361.8   123.38055
      964  383.56  1892.3  5418.9  6312.7   125.34264
      965  383.77  1874.3  5499.6  6379.8   124.27975
      966  383.98  1875.5  5397.2  6312.2   125.98277
      967  384.18  1901.7  5507.0  6409.7   125.03978
      968  384.39  1925.9  5511.5  6360.2   123.66917
      969  384.60  1912.0  5521.7  6394.2   124.16885
      970  384.81  1839.9  5414.4  6244.3   123.21531
      971  385.02  1829.2  5353.8  6201.7   124.05578
      972  385.23  1866.5  5403.0  6236.9   123.58120
      973  385.44  1859.1  5485.7  6364.7   124.23763
      974  385.65  1798.9  5466.8  6298.3   122.66889
      975  385.86  1844.0  5393.9  6277.8   124.89903
      976  386.06  1871.8  5522.6  6415.1   124.44741
      977  386.27  2006.6  5528.3  6392.5   124.54060
      978  386.48  1885.0  5493.1  6332.3   123.26028
      979  386.69  1942.7  5507.0  6340.1   123.37394
      980  386.90  1796.1  5320.2  6150.1   123.54719
      981  387.11  1824.7  5557.4  6321.7   120.47624
      982  387.32  1936.2  5484.1  6270.5   122.16578
      983  387.53  1850.5  5472.2  6377.0   124.98305
      984  387.73  1853.0  5389.4  6303.6   125.85127
      985  387.94  1998.4  5572.1  6411.4   123.48426
      986  388.15  2016.4  5533.6  6404.0   124.74669
      987  388.36  1886.6  5446.4  6285.2   123.56461
      988  388.57  2002.9  5526.2  6399.1   124.77330
      989  388.78  1934.5  5492.7  6336.0   123.70210
      990  388.99  1938.6  5469.3  6357.3   125.15083
      991  389.20  1783.0  5221.5  6076.3   124.86004
      992  389.40  2147.9  5629.9  6486.7   124.60887
      993  389.61  1847.7  5345.2  6238.5   125.54163
      994  389.82  1850.5  5349.7  6203.7   124.40595
      995  390.03  1735.4  5364.0  6209.4   123.29833
      996  390.24  1937.8  5494.7  6365.1   124.47030
      997  390.45  1912.4  5276.0  6250.4   128.96981
      998  390.66  1916.5  5481.2  6381.9   125.26713
      999  390.86  1826.4  5344.8  6190.6   124.03958
      1000 391.07  1793.2  5276.0  6148.0   125.03822
      1001 391.28  1780.5  5396.0  6224.6   122.91831
      1002 391.49  1823.9  5422.2  6170.1   120.78543
      1003 391.70  1785.8  5325.9  6231.1   125.56982
      1004 391.91  1815.7  5377.1  6179.5   122.53018
      1005 392.12  2025.4  5511.1  6352.8   124.14806
      1006 392.32  1810.0  5246.1  6105.8   125.02085
      1007 392.53  1843.2  5408.7  6280.7   124.45724
      1008 392.74  1866.1  5391.5  6342.6   126.97802
      1009 392.95  1911.6  5472.2  6288.1   122.91500
      1010 393.16  1784.6  5286.2  6195.9   125.97965
      1011 393.37  1794.4  5278.4  6134.1   124.55912
      1012 393.57  1903.8  5341.9  6133.7   123.02833
      1013 393.78  1803.4  5345.6  6146.0   122.59481
      1014 393.99  1866.9  5449.2  6352.4   125.21152
      1015 394.20  1887.0  5442.7  6226.6   122.04813
      1016 394.41  1905.8  5410.7  6311.4   125.69827
      1017 394.62  1905.0  5297.3  6234.0   127.61411
      1018 394.82  1839.9  5394.8  6263.5   124.43832
      1019 395.03  1807.9  5371.4  6225.0   123.95404
      1020 395.24  1881.3  5402.5  6246.3   123.96184
      1021 395.45  1865.3  5310.0  6171.8   125.01786
      1022 395.66  1836.6  5317.3  6116.5   122.95833
      1023 395.87  1867.7  5343.6  6166.8   123.68609
      1024 396.07  1946.0  5382.5  6278.7   126.07869
      1025 396.28  1880.0  5436.5  6229.9   122.30795
      1026 396.49  1880.0  5546.3  6401.5   123.32701
      1027 396.70  1832.9  5341.1  6257.0   126.10626
      1028 396.91  1823.5  5328.8  6192.6   124.64360
      1029 397.11  1875.1  5471.8  6263.9   122.02482
      1030 397.32  1762.1  5211.3  6066.1   124.78328
      1031 397.53  1791.2  5396.0  6270.5   124.25861
      1032 397.74  1840.3  5424.7  6272.9   123.66585
      1033 397.95  1875.5  5408.3  6258.2   124.05797
      1034 398.16  1939.4  5387.8  6329.9   127.31917
      1035 398.36  2031.2  5583.6  6468.3   124.90486
      1036 398.57  1862.8  5407.9  6281.1   124.63316
      1037 398.78  1852.6  5298.9  6220.5   126.74115
      1038 398.99  1887.0  5382.9  6156.2   122.12068
      1039 399.20  1787.1  5292.8  6053.0   121.68478
      1040 399.40  1796.1  5150.2  5934.6   123.38503
      1041 399.61  1954.6  5480.4  6282.8   122.75792
      1042 399.82  1844.0  5284.6  6140.6   124.88095
      1043 400.03  1812.0  5259.6  5978.4   120.85066
      1044 400.24  1973.4  5312.0  6055.8   122.27950
      1045 400.44  1777.6  5182.2  5972.7   123.21945
      1046 400.65  1904.6  5222.3  6096.4   126.34568
      1047 400.86  1934.5  5398.4  6097.2   120.17264
      1048 401.07  1784.6  5245.7  6075.5   123.97633
      1049 401.27  1890.7  5308.3  6069.4   122.26749
      1050 401.48  1854.2  5142.0  5998.5   126.04957
      1051 401.69  1808.4  5093.7  5943.2   125.85711
      1052 401.90  1929.6  5309.2  6163.6   125.28180
      1053 402.11  1812.0  5162.9  5982.9   124.47135
      1054 402.31  1910.3  5262.1  6071.4   124.14761
      1055 402.52  1946.4  5319.4  6191.4   125.85307
      1056 402.73  1812.0  5145.3  5922.3   123.31038
      1057 402.94  1840.3  5210.4  5956.7   122.14391
      1058 403.15  1918.1  5239.1  6053.4   124.51898
      1059 403.35  1796.9  5171.5  5976.8   123.86211
      1060 403.56  1954.6  5386.6  6195.9   123.58279
      1061 403.77  1823.1  5220.3  6042.3   124.19823
      1062 403.98  1868.2  5255.9  6046.0   123.32244
      1063 404.18  1812.0  5184.6  5931.3   122.13990
      1064 404.39  1886.2  5250.6  5990.3   121.98687
      1065 404.60  1858.7  5173.6  6012.8   125.31815
      1066 404.81  1948.8  5256.7  6128.8   126.36206
      1067 405.01  1738.3  5241.2  6046.8   123.00047
      1068 405.22  1790.3  5211.7  6049.7   124.49420
      1069 405.43  1949.3  5307.5  6099.3   123.57606
      1070 405.64  1861.6  5313.2  6091.1   122.53473
      1071 405.85  1820.6  5170.3  6038.6   125.92321
      1072 406.05  1963.6  5263.3  6121.0   125.99303
      1073 406.26  1938.2  5252.6  6110.3   125.87744
      1074 406.47  1938.2  5276.8  6072.6   123.83758
      1075 406.68  1893.1  5235.0  6069.0   124.95404
      1076 406.88  2011.5  5424.2  6254.1   124.31589
      1077 407.09  1851.0  5217.8  5950.2   121.75180
      1078 407.30  1791.2  5040.5  5817.1   123.90014
      1079 407.51  1765.3  4996.2  5764.2   123.77027
      1080 407.71  1938.6  5308.3  6130.8   124.40743
      1081 407.92  1806.7  4938.1  5656.1   122.93003
      1082 408.13  1775.2  5037.2  5797.4   123.30487
      1083 408.34  1857.1  5084.7  5829.3   123.07105
      1084 408.54  1792.8  4992.9  5763.4   124.07526
      1085 408.75  1816.5  4970.8  5781.4   125.69796
      1086 408.96  2020.1  5366.5  6180.4   124.32069
      1087 409.16  1877.6  5153.5  5956.3   124.50610
      1088 409.37  1900.9  5185.0  5860.1   120.55377
      1089 409.58  1964.0  5156.0  5966.6   125.39458
      1090 409.79  1929.2  5270.2  6038.6   122.99866
      1091 409.99  1842.4  5108.9  5931.3   125.17868
      1092 410.20  1971.4  5226.0  6035.0   124.85525
      1093 410.41  1834.2  5009.7  5735.1   122.84279
      1094 410.62  1823.9  4943.4  5704.4   124.39600
      1095 410.82  1884.1  5173.6  5953.4   123.70811
      1096 411.03  1982.8  5223.1  6079.6   126.43153
      1097 411.24  1833.3  5067.9  5846.5   124.07245
      1098 411.45  1964.0  5216.6  5955.9   122.73014
      1099 411.65  1846.4  5013.4  5879.7   127.35383
      1100 411.86  1882.1  5109.3  5850.6   122.97247
      1101 412.07  1814.9  5200.6  5872.8   119.85240
      1102 412.27  1955.8  5177.7  5930.1   123.35365
      1103 412.48  1894.8  5140.8  5951.8   124.98424
      1104 412.69  1867.7  5048.7  5809.3   123.91191
      1105 412.90  1943.9  5274.3  6033.7   122.80163
      1106 413.10  1909.5  5103.5  5840.4   123.07001
      1107 413.31  1842.8  5097.0  5876.4   123.95217
      1108 413.52  1888.2  5103.9  5903.5   124.86307
      1109 413.72  1759.2  4946.3  5692.9   123.42888
      1110 413.93  1786.2  5045.4  5837.1   124.29308
      1111 414.14  1778.5  4886.9  5699.5   126.14310
      1112 414.35  1912.8  5030.2  5734.7   122.59886
      1113 414.55  1887.8  5112.5  5890.0   124.10772
      1114 414.76  1844.4  4999.5  5837.9   126.57409
      1115 414.97  1877.6  5071.6  5858.4   124.63450
      1116 415.17  1828.0  4983.5  5717.9   123.27364
      1117 415.38  1942.7  5033.1  5763.0   123.61829
      1118 415.59  1806.7  4941.7  5649.1   122.56335
      1119 415.79  1873.9  5036.8  5786.7   123.71147
      1120 416.00  2002.5  5065.0  5865.8   126.14686
      1121 416.21  1964.8  5097.0  5821.6   123.13324
      1122 416.41  1749.8  4868.0  5644.6   124.90475
      1123 416.62  1749.8  4759.9  5441.0   122.62892
      1124 416.83  1946.0  5100.7  5828.1   123.05893
      1125 417.04  1975.5  5071.6  5779.0   122.84693
      1126 417.24  1816.5  4859.4  5635.2   125.49470
      1127 417.45  1871.4  4914.3  5565.6   121.40261
      1128 417.66  1948.0  5002.0  5675.3   122.04935
      1129 417.86  1821.1  4971.2  5745.8   124.58719
      1130 418.07  1819.4  4872.1  5598.3   123.78905
      1131 418.28  1865.7  4978.6  5676.1   122.40789
      1132 418.48  1993.1  5052.3  5869.5   126.71038
      1133 418.69  1851.0  4904.1  5755.6   127.89105
      1134 418.90  1949.3  5103.1  5919.9   125.89607
      1135 419.10  1873.1  5089.2  5758.9   120.82273
      1136 419.31  1836.6  5053.6  5825.7   124.00050
      1137 419.52  1793.2  5054.8  5901.4   125.95758
      1138 419.72  1805.9  5070.4  5853.5   123.98996
      1139 419.93  1767.4  5071.6  5905.1   125.22622
      1140 420.14  1944.3  5277.6  6076.7   123.97397
      1141 420.34  1936.6  5286.6  6002.2   121.35957
      1142 420.55  1821.1  5053.6  5917.0   126.71057
      1143 420.76  1971.4  5356.7  6141.4   123.18211
      1144 420.96  1847.3  5159.2  5990.7   125.10511
      1145 421.17  1902.2  5202.7  6144.7   128.54304
      1146 421.38  1865.7  5239.5  6018.6   123.09096
      1147 421.58  1946.0  5332.9  6156.6   124.31975
      1148 421.79  1939.8  5361.2  6183.6   124.03926
      1149 422.00  1847.7  5370.6  6169.3   122.67179
      1150 422.20  1856.7  5146.5  5969.8   125.02492
      1151 422.41  1842.4  5307.5  6073.9   122.11584
      1152 422.62  1771.1  5142.4  6001.4   125.47685
      1153 422.82  1928.0  5309.6  6138.6   124.51551
      1154 423.03  1890.3  5113.4  6009.6   127.80534
      1155 423.24  1893.1  5248.9  6061.2   124.20357
      1156 423.44  1787.9  5080.2  5865.0   123.83679
      1157 423.65  1904.2  5137.1  5931.7   124.57874
      1158 423.85  1942.3  5206.8  6037.8   125.45795
      1159 424.06  1866.5  5172.8  5915.8   122.47278
      1160 424.27  1965.6  5244.8  5975.6   122.28328
      1161 424.47  1907.5  5156.8  5991.1   125.67757
      1162 424.68  1967.7  5217.0  6075.9   126.43387
      1163 424.89  1958.7  5252.2  6042.3   123.98954
      1164 425.09  1947.6  5155.6  5903.5   123.31460
      1165 425.30  1887.0  5032.7  5850.6   126.00261
      1166 425.51  1830.9  5051.1  5760.5   122.03004
      1167 425.71  1832.5  5073.2  5766.7   121.39787
      1168 425.92  1909.9  5042.1  5764.2   123.05480
      1169 426.12  2059.8  5290.7  6039.5   123.17447
      1170 426.33  1829.7  4990.5  5728.2   123.33811
      1171 426.54  1800.6  4993.8  5639.3   120.21550
      1172 426.74  1866.1  5059.7  5829.7   124.11183
      1173 426.95  1870.2  5113.8  5888.3   123.87928
      1174 427.16  1826.4  4916.4  5644.2   123.55514
      1175 427.36  1848.1  5259.2  6115.2   125.09606
      1176 427.57  1895.2  5097.0  5919.0   125.67479
      1177 427.77  1902.2  5292.8  6114.8   124.24500
      1178 427.98  1962.4  5258.0  6025.9   123.30350
      1179 428.19  1830.1  5240.8  6125.1   125.92771
      1180 428.39  1827.6  5182.2  6044.4   125.70208
      1181 428.60  1951.7  5296.5  6177.5   126.34092
      1182 428.81  1876.8  5353.4  6146.8   122.82045
      1183 429.01  1837.0  5144.5  5962.0   124.71830
      1184 429.22  1920.2  5298.1  6144.3   125.05155
      1185 429.42  1838.3  5187.1  5979.2   123.65462
      1186 429.63  1935.7  5341.5  6117.3   122.77812
      1187 429.84  1910.3  5315.7  6137.8   124.13998
      1188 430.04  1792.4  5400.5  6263.5   123.91871
      1189 430.25  1973.0  5427.1  6140.6   120.65696
      1190 430.45  1884.1  5202.2  6078.0   126.39182
      1191 430.66  1796.5  5425.5  6268.8   123.23926
      1192 430.87  1800.6  5063.8  5856.0   124.27512
      1193 431.07  1862.0  5174.0  5964.1   123.85607
      1194 431.28  1896.0  5240.8  6111.1   126.02254
      1195 431.48  1793.6  5135.1  5956.7   124.58936
      1196 431.69  1868.2  5268.6  6058.7   123.23539
      1197 431.90  1873.1  5085.9  5872.8   124.49003
      1198 432.10  1889.5  5378.0  6270.1   125.57238
      1199 432.31  1813.7  5106.8  5839.2   122.23882
      1200 432.51  1878.0  5256.3  6032.1   122.96312
      1201 432.72  1943.5  5173.6  5949.8   124.02992
      1202 432.92  1830.1  5239.1  6075.1   124.52238
      1203 433.13  1883.3  5101.9  5879.7   124.16644
      1204 433.34  1915.3  5124.8  5912.1   124.52781
      1205 433.54  1925.9  5225.6  6015.7   123.94488
      1206 433.75  1820.2  5102.3  5938.3   125.47112
      1207 433.95  1966.5  5147.8  5950.6   125.23498
      1208 434.16  1923.9  5271.1  6062.8   123.65395
      1209 434.37  1796.5  5040.5  5798.6   123.37121
      1210 434.57  1968.1  5183.8  5974.3   124.58286
      1211 434.78  1925.1  5127.7  6002.6   127.31807
      1212 434.98  1812.0  5136.3  5888.7   122.63428
      1213 435.19  1826.8  5105.2  5886.7   123.83809
      1214 435.39  1848.9  5208.8  6035.8   124.61295
      1215 435.60  1836.2  5045.8  5820.3   124.13222
      1216 435.81  1942.7  5224.0  5971.9   122.79365
      1217 436.01  1811.6  5029.0  5779.8   123.33544
      1218 436.22  1905.4  5014.7  5699.9   122.03928
      1219 436.42  1880.0  5105.6  5803.5   121.63810
      1220 436.63  1873.1  5154.7  5974.3   124.97504
      1221 436.83  1947.6  5181.8  5962.9   124.15145
      1222 437.04  1888.2  5141.6  5865.0   122.23343
      1223 437.24  1809.6  5022.4  5789.6   123.87812
      1224 437.45  1825.6  5064.2  5816.2   123.21993
      1225 437.66  1900.5  4996.6  5749.5   124.31538
      1226 437.86  1794.0  4946.7  5625.4   121.52787
      1227 438.07  1912.4  5141.2  5944.4   124.87630
      1228 438.27  1883.3  5026.1  5817.1   125.16615
      1229 438.48  1939.0  5036.8  5754.4   123.16544
      1230 438.68  1854.6  5065.0  5792.9   122.67160
      1231 438.89  1880.0  5162.9  5931.7   123.41861
      1232 439.09  1907.1  5139.2  5882.2   122.98821
      1233 439.30  1825.2  5165.0  5906.8   122.20995
      1234 439.50  1913.2  5051.5  5837.5   125.04566
      1235 439.71  1804.7  5124.4  5920.7   123.98522
      1236 439.92  1910.3  5128.9  5869.5   123.00838
      1237 440.12  1846.0  5157.2  5903.5   122.53835
      1238 440.33  1830.5  5034.3  5818.7   124.48222
      1239 440.53  2000.5  5373.9  6220.5   125.09713
      1240 440.74  1800.2  5165.8  6010.8   125.10650
      1241 440.94  1919.4  5239.1  6031.7   123.87415
      1242 441.15  1957.9  5288.3  6082.1   123.83471
      1243 441.35  1853.4  5237.9  5997.3   122.43738
      1244 441.56  1877.6  5275.2  6101.7   124.32790
      1245 441.76  1851.8  5325.1  6148.0   123.69104
      1246 441.97  1897.2  5302.6  6173.0   125.55927
      1247 442.17  1861.6  5396.0  6247.5   124.09317
      1248 442.38  1865.7  5208.0  6029.2   124.57106
      1249 442.58  1919.8  5308.3  6101.3   123.40141
      1250 442.79  1890.3  5202.2  5990.3   123.79423
      1251 443.00  1863.2  5250.6  6018.6   122.67233
      1252 443.20  1846.4  5289.1  6114.8   123.98573
      1253 443.41  1880.4  5170.3  6004.6   125.36104
      1254 443.61  1819.4  5155.6  5998.1   125.25474
      1255 443.82  1923.0  5291.5  6067.3   123.03014
      1256 444.02  1860.8  5136.7  5996.0   126.23157
      1257 444.23  1755.9  5131.8  5949.3   124.21742
      1258 444.43  1866.9  5163.7  5941.2   123.58057
      1259 444.64  1931.2  5213.3  6000.5   123.98602
      1260 444.84  1937.8  5184.6  6017.8   125.65912
      1261 445.05  1833.3  5057.3  5864.6   125.04129
      1262 445.25  1935.7  5162.5  6005.9   126.13606
      1263 445.46  1890.3  5120.7  6035.4   128.31242
      1264 445.66  1810.8  4980.7  5745.4   124.12458
      1265 445.87  1868.2  5018.3  5743.3   123.01391
      1266 446.07  1857.1  5001.5  5748.6   123.75928
      1267 446.28  1964.8  5141.2  5892.8   123.66213
      1268 446.48  1846.0  5156.8  5873.2   121.63802
      1269 446.69  1819.4  4902.4  5703.6   125.98643
      1270 446.89  1873.1  5020.8  5742.9   122.94080
      1271 447.10  1845.2  4959.4  5714.2   124.24042
      1272 447.30  1937.0  5052.7  5792.5   123.74132
      1273 447.51  1892.3  4962.6  5693.4   123.79935
      1274 447.71  1887.4  5026.5  5805.2   124.80429
      1275 447.92  1887.0  4907.3  5620.0   123.59641
      1276 448.12  1859.1  4924.1  5640.5   123.37300
      1277 448.33  1921.8  4827.9  5554.5   125.00351
      1278 448.53  1802.6  4699.7  5435.7   125.40647
      1279 448.73  1886.6  4812.7  5536.9   124.74801
      1280 448.94  2017.7  4989.3  5723.3   124.70021
      1281 449.14  1859.1  4769.7  5444.7   123.19169
      1282 449.35  1853.0  4769.7  5412.8   122.04746
      1283 449.55  1874.3  4654.6  5461.1   129.00707
      1284 449.76  1961.1  4788.6  5367.7   120.48383
      1285 449.96  1916.9  4768.9  5551.6   127.44508
      1286 450.17  1967.7  4762.3  5410.7   123.20090
      1287 450.37  1858.3  4745.1  5445.1   124.24799
      1288 450.58  2002.1  4784.1  5359.5   120.68609
      1289 450.78  1819.4  4629.2  5329.2   124.91250
      1290 450.99  1780.9  4543.6  5204.3   123.91403
      1291 451.19  1930.0  4619.8  5299.3   125.26268
      1292 451.40  1821.1  4526.8  5185.5   124.34152
      1293 451.60  1873.5  4623.1  5271.5   123.58111
      1294 451.81  1880.0  4669.4  5315.3   123.15710
      1295 452.01  1855.5  4575.6  5216.2   123.55065
      1296 452.21  1917.7  4613.7  5204.3   121.90823
      1297 452.42  1857.9  4543.2  5142.4   122.31545
      1298 452.62  1839.1  4426.5  5072.8   124.98021
      1299 452.83  1869.8  4546.1  5167.4   123.21703
      1300 453.03  1929.2  4529.3  5162.9   124.36986
      1301 453.24  1903.0  4456.0  5142.9   126.90520
      1302 453.44  1962.0  4541.6  5201.8   125.59542
      1303 453.65  1813.3  4403.5  5042.9   124.68376
      1304 453.85  2044.3  4612.4  5282.5   126.09253
      1305 454.06  1948.0  4451.1  4949.5   119.91493
      1306 454.26  1890.7  4417.9  5000.3   123.04699
      1307 454.46  1973.4  4559.2  5217.0   125.43959
      1308 454.67  1916.5  4471.1  5085.5   124.05004
      1309 454.87  1900.9  4553.0  5103.9   120.77222
      1310 455.08  1951.7  4549.4  5182.6   124.37717
      1311 455.28  1916.9  4404.8  5049.1   125.89727
      1312 455.49  1867.3  4512.9  5133.0   123.44016
      1313 455.69  2040.2  4532.6  5136.7   124.23994
      1314 455.89  1887.4  4505.1  5085.1   122.15613
      1315 456.10  1785.0  4388.4  4959.8   121.94780
      1316 456.30  2026.3  4568.6  5244.0   126.56677
      1317 456.51  1893.6  4514.5  5119.5   123.08174
      1318 456.71  1833.8  4434.3  5015.5   122.34995
      1319 456.92  1880.9  4492.4  5140.8   124.82749
      1320 457.12  1930.0  4616.9  5285.4   124.87805
      1321 457.32  1832.1  4545.3  5059.7   118.96136
      1322 457.53  1911.2  4543.2  5202.2   125.03889
      1323 457.73  1900.9  4581.3  5191.2   122.75367
      1324 457.94  1955.0  4700.1  5275.6   120.96392
      1325 458.14  1814.5  4529.3  5134.7   122.29931
      1326 458.35  1867.3  4485.1  5161.3   125.83319
      1327 458.55  1881.7  4507.6  5147.8   124.37998
      1328 458.75  1949.7  4643.2  5219.0   121.38078
      1329 458.96  1968.5  4558.8  5180.1   123.98800
      1330 459.16  1785.0  4416.6  5107.6   126.25683
      1331 459.37  1840.7  4524.0  5131.0   122.62250
      1332 459.57  1789.1  4404.0  5043.7   124.46740
      1333 459.77  1989.0  4500.6  5078.1   122.99412
      1334 459.98  1880.0  4460.1  5062.6   123.35294
      1335 460.18  1864.9  4472.4  5070.4   122.93434
      1336 460.39  1931.2  4557.6  5178.1   123.62755
      1337 460.59  1814.9  4405.6  4993.4   122.68775
      1338 460.79  1752.7  4376.9  5041.7   125.33164
      1339 461.00  1761.7  4296.2  4865.6   122.46282
      1340 461.20  1850.5  4452.7  5044.1   122.72941
      1341 461.41  1934.9  4474.0  5054.4   122.85851
      1342 461.61  1889.5  4422.4  5035.1   124.19145
      1343 461.81  1864.9  4417.5  4995.0   122.62515
      1344 462.02  1879.2  4441.2  5001.5   121.87049
      1345 462.22  1972.2  4623.5  5278.4   124.70264
      1346 462.43  1916.9  4537.5  5166.6   124.00750
      1347 462.63  1798.1  4404.8  4964.7   121.48022
      1348 462.83  1976.7  4541.2  5192.0   125.37931
      1349 463.04  1889.9  4525.6  5119.1   122.51751
      1350 463.24  1872.7  4605.9  5244.8   123.37778
      1351 463.45  1901.7  4635.4  5246.1   122.34046
      1352 463.65  1817.8  4618.2  5170.3   119.71623
      1353 463.85  1929.6  4692.7  5289.1   121.58314
      1354 464.06  1799.8  4563.3  5139.6   120.85370
      1355 464.26  2043.5  4743.1  5462.3   126.64236
      1356 464.46  1880.4  4656.7  5291.1   122.85336
      1357 464.67  1959.1  4743.5  5420.6   124.31600
      1358 464.87  1923.5  4700.1  5314.1   122.11241
      1359 465.08  1847.3  4535.0  5272.7   127.44589
      1360 465.28  1909.5  4680.0  5418.1   126.64104
      1361 465.48  1866.5  4626.4  5270.2   123.33039
      1362 465.69  1868.2  4646.4  5304.2   123.67681
      1363 465.89  1871.4  4534.2  5196.9   124.88845
      1364 466.09  1994.3  4733.7  5390.7   123.98324
      1365 466.30  1981.2  4641.9  5308.7   125.06159
      1366 466.50  1829.2  4490.8  5099.0   122.85320
      1367 466.71  1880.9  4542.4  5235.4   126.03876
      1368 466.91  1930.4  4591.1  5252.6   124.86146
      1369 467.11  1941.9  4587.4  5200.6   123.17697
      1370 467.32  1906.7  4485.5  5097.8   123.74525
      1371 467.52  1831.3  4444.9  5042.1   122.84910
      1372 467.72  1841.1  4369.5  5023.7   125.87072
      1373 467.93  1807.9  4325.3  4971.2   125.65895
      1374 468.13  1901.7  4471.1  5061.8   122.98744
      1375 468.33  1839.9  4300.3  4859.8   122.74013
      1376 468.54  1887.8  4437.9  5077.3   125.07229
      1377 468.74  2058.6  4481.0  5022.8   122.37062
      1378 468.94  1945.2  4430.2  4965.1   121.52627
      1379 469.15  1928.8  4292.5  4850.4   123.60073
      1380 469.35  1850.5  4241.8  4754.2   121.42858
      1381 469.55  1839.1  4240.5  4844.3   125.14071
      1382 469.76  1898.1  4288.0  4835.3   122.89630
      1383 469.96  1919.4  4334.7  4838.9   120.87502
      1384 470.17  1910.8  4233.2  4762.8   122.80425
      1385 470.37  2004.6  4382.2  4949.1   123.84148
      1386 470.57  1932.5  4269.2  4891.4   126.62576
      1387 470.78  1866.9  4258.5  4810.7   123.08617
      1388 470.98  1927.1  4358.9  4902.0   122.33450
      1389 471.18  1933.7  4338.8  4912.7   123.85895
      1390 471.39  1932.1  4315.1  4853.7   122.60228
      1391 471.59  1948.8  4437.9  4954.4   120.75038
      1392 471.79  1823.1  4334.7  4908.6   122.84736
      1393 471.99  1812.0  4286.8  4876.2   123.81665
      1394 472.20  1864.1  4406.4  4985.6   122.78070
      1395 472.40  1814.5  4353.6  4983.9   124.82659
      1396 472.60  1823.5  4340.9  4940.9   123.83660
      1397 472.81  1901.3  4425.7  5072.0   125.60442
      1398 473.01  1853.4  4599.7  5133.8   119.44816
      1399 473.21  1984.1  4569.4  5239.5   125.91887
      1400 473.42  2029.9  4700.5  5347.2   124.21777
      1401 473.62  1969.3  4632.1  5323.5   125.96523
      1402 473.82  1889.0  4595.6  5290.7   125.68097
      1403 474.03  2042.6  4719.7  5391.9   125.10708
      1404 474.23  1817.4  4596.9  5277.6   124.49156
      1405 474.43  1924.7  4681.7  5380.8   125.36025
      1406 474.64  1753.5  4514.5  5169.9   123.73535
      1407 474.84  1898.5  4684.1  5346.4   123.77591
      1408 475.04  1908.7  4714.0  5423.4   125.28839
      1409 475.25  1916.9  4708.3  5427.1   125.75202
      1410 475.45  1794.4  4710.3  5342.7   121.68845
      1411 475.65  1839.5  4705.0  5351.3   122.55576
      1412 475.85  1767.0  4743.9  5348.1   120.29444
      1413 476.06  1927.1  4794.7  5510.3   124.95361
      1414 476.26  1950.9  4834.0  5507.4   123.35562
      1415 476.46  1853.4  4778.3  5556.1   126.59290
      1416 476.67  1879.2  4813.5  5499.6   123.38077
      1417 476.87  1933.3  4875.4  5542.2   122.66464
      1418 477.07  1854.6  4890.5  5547.5   121.64060
      1419 477.28  1841.1  4867.6  5490.2   120.57114
      1420 477.48  1920.6  4965.9  5638.5   122.08473
      1421 477.68  1946.4  4986.0  5684.3   122.97533
      1422 477.88  1892.7  4973.7  5700.7   123.59745
      1423 478.09  1871.8  4977.4  5717.1   123.81959
      1424 478.29  1866.5  4989.7  5653.2   121.24591
      1425 478.49  1957.4  5150.6  5844.5   121.72910
      1426 478.70  1801.0  4986.4  5753.2   124.07100
      1427 478.90  1940.2  5074.5  5831.8   124.16363
      1428 479.10  1830.5  5008.9  5803.5   125.00000
      1429 479.30  1949.3  5164.6  5953.4   124.53501
      1430 479.51  1887.8  5076.5  5817.9   123.24985
      1431 479.71  1812.0  5030.6  5767.9   122.90660
      1432 479.91  1921.4  5202.2  5952.2   122.85892
      1433 480.11  1900.1  5201.8  5969.4   123.24771
      1434 480.32  1922.2  5244.8  5927.6   120.54981
      1435 480.52  1988.6  5343.6  6046.0   120.93761
      1436 480.72  1908.7  5128.5  5903.5   124.06821
      1437 480.93  1868.2  5171.1  5895.3   121.92461
      1438 481.13  1766.6  5028.6  5896.5   126.60726
      1439 481.33  1811.2  5224.4  5953.0   121.34888
      1440 481.53  1968.1  5297.7  6158.7   125.85803
      1441 481.74  1915.7  5377.1  6227.5   124.56512
      1442 481.94  1835.0  5394.4  6155.8   121.39238
      1443 482.14  1913.6  5553.3  6338.5   121.57326
      1444 482.34  1855.5  5673.3  6603.5   124.36433
      1445 482.55  1885.0  5850.6  6819.3   124.42676
      1446 482.75  1880.9  6114.0  7092.5   123.11561
      1447 482.95  1919.8  6319.2  7448.5   125.66800
      1448 483.15  1905.0  6571.5  7747.1   125.19091
      1449 483.36  1785.4  6765.7  7878.5   122.34558
      1450 483.56  1942.3  7331.7  8561.3   122.81503
      1451 483.76  1774.0  7242.4  8533.1   123.60123
      1452 483.96  1889.0  7539.4  8978.3   125.46575
      1453 484.17  1916.1  7760.6  9120.8   123.27423
      1454 484.37  1861.2  7797.4  9256.0   124.57049
      1455 484.57  1905.8  7998.5  9478.0   124.28234
      1456 484.77  1880.4  8057.1  9584.9   124.73474
      1457 484.98  1952.9  8140.3  9568.9   123.09016
      1458 485.18  1861.2  8119.8  9604.6   123.72383
      1459 485.38  1923.5  8188.6  9670.5   123.65324
      1460 485.58  1858.3  8320.5  9821.2   123.22369
      1461 485.79  1965.2  8293.9  9796.7   123.74603
      1462 485.99  1713.7  8110.8  9587.0   123.07594
      1463 486.19  1912.8  8179.2  9718.4   124.56369
      1464 486.39  1956.6  8304.5  9764.7   123.00297
      1465 486.59  1781.7  7858.1  9325.2   124.14561
      1466 486.80  1922.2  7860.5  9163.8   121.94785
      1467 487.00  1875.1  7547.2  8865.7   123.24525
      1468 487.20  1921.4  7467.3  8726.4   122.70310
      1469 487.40  1900.5  7216.2  8413.9   122.53043
      1470 487.61  1912.8  7033.1  8284.9   124.44606
      1471 487.81  1847.3  6830.8  8046.9   124.40208
      1472 488.01  1910.3  6664.1  7766.7   123.19491
      1473 488.21  1905.0  6565.4  7648.3   123.23783
      1474 488.41  1907.5  6383.1  7442.3   123.66614
      1475 488.62  1907.1  6261.5  7327.6   124.48498
      1476 488.82  1839.5  6078.0  7019.2   122.20718
      1477 489.02  1841.5  6054.6  7075.3   124.22709
      1478 489.22  1957.4  6015.7  7083.1   126.30200
      1479 489.43  1853.4  5886.3  6809.9   122.90270
      1480 489.63  1970.1  5926.8  6847.2   123.26086
      1481 489.83  1881.7  5719.2  6604.3   123.06543
      1482 490.03  1900.9  5626.2  6507.6   123.66136
      1483 490.23  1755.1  5498.8  6365.5   123.15097
      1484 490.44  1778.9  5518.5  6414.6   123.96495
      1485 490.64  1934.9  5473.0  6292.6   123.16508
      1486 490.84  1928.4  5486.1  6275.4   122.18512
      1487 491.04  1859.1  5373.1  6197.6   123.46427
      1488 491.24  1862.8  5358.7  6204.9   124.20622
      1489 491.45  1982.8  5355.8  6277.4   127.32240
      1490 491.65  1946.8  5356.7  6096.8   121.70571
      1491 491.85  1891.9  5228.9  6050.9   124.63482
      1492 492.05  2070.1  5434.9  6199.6   122.72674
      1493 492.25  1908.7  5241.6  6010.0   123.05519
      1494 492.45  1879.6  5225.6  5991.9   122.90367
      1495 492.66  1855.5  5115.8  5932.6   125.05026
      1496 492.86  1818.6  5156.0  5956.3   123.98134
      1497 493.06  1944.8  5217.4  5952.6   122.46559
      1498 493.26  1975.1  5304.6  6084.9   123.43461
      1499 493.46  1875.1  5236.2  5983.3   122.22767
      1500 493.67  2058.6  5430.8  6133.7   120.84292
      1501 493.87  1787.5  5097.4  5933.0   125.24439
      1502 494.07  1932.5  5196.5  6018.2   125.17254
      1503 494.27  1793.2  5094.5  5858.8   123.15136
      1504 494.47  1807.1  5131.4  5914.5   123.55843
      1505 494.67  1919.8  5220.3  5973.9   122.83447
      1506 494.88  1893.6  5161.7  5935.0   123.66212
      1507 495.08  1942.7  5244.0  5989.1   122.56823
      1508 495.28  1892.7  5185.9  5970.2   123.81841
      1509 495.48  1878.0  5187.5  5900.6   121.54703
      1510 495.68  1804.3  5107.2  5795.8   120.84576
      1511 495.89  1837.0  5122.0  5879.7   123.06732
      1512 496.09  1824.7  5120.7  5881.8   123.08934
      1513 496.29  1900.9  5174.8  5953.0   123.77083
      1514 496.49  1955.4  5256.3  6014.1   122.95569
      1515 496.69  1898.9  5128.5  5946.1   125.31389
      1516 496.89  1770.3  5071.2  5848.2   123.53892
      1517 497.09  1915.7  5187.9  5980.5   124.22081
      1518 497.30  1932.5  5232.2  6040.7   124.50347
      1519 497.50  1912.0  5177.7  6038.6   126.36398
      1520 497.70  1912.4  5131.4  5967.4   125.97023
      1521 497.90  1998.0  5259.6  6089.8   125.45525
      1522 498.10  1903.0  5096.2  5839.6   123.28119
      1523 498.30  2076.2  5412.0  6206.2   123.80896
      1524 498.51  1909.5  5198.2  5875.2   120.58789
      1525 498.71  1860.0  5202.2  5953.4   122.47549
      1526 498.91  1794.8  5072.4  5889.1   124.91877
      1527 499.11  1984.1  5232.2  6081.2   126.14121
      1528 499.31  1926.7  5230.1  6018.6   123.86857
      1529 499.51  1936.6  5288.3  6083.7   123.73212
      1530 499.71  1898.1  5242.0  6007.5   122.89319
      1531 499.92  1847.3  5118.7  5940.3   125.11581
      1532 500.12  1893.6  5217.0  6001.4   123.60118
      1533 500.32  1881.3  5170.3  6010.0   125.52926
      1534 500.52  1881.7  5221.9  5992.4   123.06561
      1535 500.72  1783.0  5049.9  5946.9   127.45740
      1536 500.92  1969.7  5321.4  6061.6   122.08237
      1537 501.12  1960.7  5271.1  6078.8   124.39990
      1538 501.32  1717.8  5084.7  5795.8   121.11923
      1539 501.53  1830.9  5188.7  5967.4   123.18856
      1540 501.73  1945.2  5271.9  6068.1   123.93499
      1541 501.93  1930.8  5280.9  6059.9   123.25470
      1542 502.13  1803.0  5110.9  5915.4   124.31897
      1543 502.33  1738.7  5112.1  5831.8   121.33316
      1544 502.53  1861.6  5170.7  5962.5   123.92624
      1545 502.73  1909.9  5174.8  5957.1   123.96190
      1546 502.93  1772.7  5038.8  5887.5   125.98448
      1547 503.14  1887.4  5165.4  5933.4   123.42870
      1548 503.34  1805.1  5124.8  5918.2   123.89883
      1549 503.54  1881.3  5124.8  5900.2   123.90453
      1550 503.74  1981.6  5183.4  5996.5   125.39336
      1551 503.94  1762.1  5074.5  5755.6   120.56385
      1552 504.14  1913.2  5144.5  5904.7   123.52646
      1553 504.34  1923.0  5091.7  5849.4   123.91416
      1554 504.54  1799.3  5006.5  5747.0   123.09069
      1555 504.74  1873.5  5047.8  5715.1   121.01938
      1556 504.95  1929.2  5109.3  5767.1   120.68523
      1557 505.15  2029.1  5185.5  5950.2   124.22785
      1558 505.35  1887.8  4991.7  5698.7   122.77647
      1559 505.55  1851.4  4975.7  5740.5   124.47560
      1560 505.75  1890.7  4936.8  5712.6   125.46728
      1561 505.95  1888.2  5008.1  5733.5   123.25060
      1562 506.15  1883.3  4931.5  5729.8   126.18919
      1563 506.35  1894.8  4946.7  5616.3   121.94334
      1564 506.55  1864.1  4921.3  5600.0   122.19990
      1565 506.75  1924.3  4936.8  5596.7   121.90348
      1566 506.95  1850.5  4839.8  5571.7   124.48616
      1567 507.16  1978.7  4956.5  5658.9   123.59008
      1568 507.36  1928.0  4926.2  5611.4   122.85518
      1569 507.56  1970.1  4912.7  5616.4   123.91429
      1570 507.76  1832.5  4868.0  5574.2   123.26269
      1571 507.96  2002.5  4915.5  5652.4   125.29527
      1572 508.16  1818.2  4813.1  5491.0   122.63404
      1573 508.36  1873.5  4834.0  5545.1   124.01772
      1574 508.56  1921.0  4836.9  5529.5   123.75333
      1575 508.76  1823.9  4727.5  5470.5   125.58894
      1576 508.96  1881.7  4841.0  5525.4   123.12802
      1577 509.16  2020.1  4942.6  5615.1   123.01331
      1578 509.36  1837.0  4696.4  5424.2   125.45480
      1579 509.57  1964.4  4827.9  5475.9   122.62908
      1580 509.77  1834.2  4715.7  5448.4   125.42999
      1581 509.97  1850.1  4730.4  5384.5   122.71046
      1582 510.17  1862.8  4716.1  5416.1   124.53346
      1583 510.37  1822.7  4705.8  5405.4   124.26480
      1584 510.57  1857.9  4691.1  5370.6   123.98438
      1585 510.77  1806.3  4670.2  5282.5   121.38159
      1586 510.97  1855.9  4657.5  5418.9   127.17833
      1587 511.17  1854.6  4659.1  5331.7   123.98130
      1588 511.37  1947.6  4752.1  5400.1   123.10499
      1589 511.57  1966.5  4748.8  5424.7   124.28972
      1590 511.77  1882.9  4674.7  5350.1   124.19311
      1591 511.97  1847.3  4711.1  5291.1   120.25173
      1592 512.17  1956.2  4730.4  5394.4   123.93329
      1593 512.37  1955.8  4761.9  5362.8   121.41293
      1594 512.57  1828.0  4585.0  5246.5   123.99347
      1595 512.78  1870.6  4626.4  5248.5   122.57730
      1596 512.98  1861.6  4590.3  5270.2   124.91746
      1597 513.18  1772.3  4537.1  5192.0   123.68887
      1598 513.38  1850.5  4625.5  5296.9   124.19188
      1599 513.58  1902.6  4638.6  5292.8   123.90718
      1600 513.78  1962.4  4673.5  5260.8   121.66489
      1601 513.98  1940.7  4616.5  5223.1   122.66955
      1602 514.18  2040.6  4774.6  5371.8   121.84271
      1603 514.38  1823.5  4480.5  5161.7   125.63587
      1604 514.58  1728.9  4337.6  5025.3   126.36207
      1605 514.78  1844.4  4492.0  5151.1   124.89169
      1606 514.98  1952.5  4579.3  5250.6   125.55745
      1607 515.18  1926.3  4595.6  5223.1   123.50772
      1608 515.38  1854.2  4519.9  5162.5   124.10881
      1609 515.58  1825.2  4490.8  5110.5   123.24830
      1610 515.78  1801.0  4435.9  5036.4   122.78877
      1611 515.98  1908.7  4583.4  5191.6   122.74121
      1612 516.18  1909.1  4567.8  5233.4   125.03462
      1613 516.38  1978.7  4631.7  5242.8   123.03536
      1614 516.58  1833.3  4550.6  5132.2   121.40488
      1615 516.78  1783.0  4423.6  5058.5   124.04222
      1616 516.98  1776.4  4459.7  5102.3   123.95052
      1617 517.18  1888.6  4501.0  5179.7   125.97994
      1618 517.38  1800.6  4478.9  5096.2   123.04630
      1619 517.58  1875.1  4512.5  5254.7   128.14102
      1620 517.78  1848.5  4473.2  5117.9   124.56307
      1621 517.98  1935.3  4616.1  5238.7   123.22381
      1622 518.18  1824.7  4455.6  5085.9   123.96077
      1623 518.38  1819.0  4467.4  5130.2   125.02321
      1624 518.58  2025.9  4661.6  5255.1   122.51751
      1625 518.78  1857.1  4477.3  5115.0   124.33956
      1626 518.98  1969.3  4546.9  5185.9   124.78944
      1627 519.18  1907.1  4562.1  5146.5   122.01480
      1628 519.38  1914.9  4508.0  5148.6   124.70381
      1629 519.58  1885.8  4547.3  5076.5   119.88304
      1630 519.78  1806.7  4460.5  5058.9   122.54976
      1631 519.98  2011.5  4582.9  5174.4   123.00099
      1632 520.18  1860.0  4496.9  5103.9   123.01957
      1633 520.38  1910.8  4483.8  5140.8   125.53325
      1634 520.58  1848.1  4482.2  5024.1   120.57225
      1635 520.78  1854.2  4445.3  4999.5   121.38791
      1636 520.98  1909.5  4539.5  5074.9   120.35508
      1637 521.18  1936.6  4506.8  5130.6   124.27090
      1638 521.38  1950.9  4540.3  5147.8   123.45774
      1639 521.58  1952.1  4509.2  5159.7   125.43645
      1640 521.78  1963.6  4475.2  5170.3   127.67451
      1641 521.98  1872.7  4427.3  5056.8   124.64324
      1642 522.18  1859.1  4419.9  5033.5   123.96036
      1643 522.38  1940.7  4554.7  5127.3   121.90535
      1644 522.58  1803.9  4355.6  4916.4   121.97432
      1645 522.78  1881.3  4513.3  5071.6   121.21069
      1646 522.98  1907.9  4472.4  5094.5   124.26131
      1647 523.18  1824.7  4419.1  5040.9   123.96588
      1648 523.38  1875.9  4467.0  5073.6   123.41134
      1649 523.58  1839.5  4451.1  5010.6   121.42409
      1650 523.78  1740.4  4392.1  4982.7   122.27370
      1651 523.98  1810.4  4421.6  5045.0   123.87448
      1652 524.18  1866.1  4462.5  5140.8   126.12398
      1653 524.38  1875.5  4467.4  5115.0   124.98421
      1654 524.58  1840.3  4417.1  5089.2   126.08487
      1655 524.78  1899.3  4471.5  5167.4   127.05415
      1656 524.98  1858.3  4477.3  5224.0   128.51113
      1657 525.18  1867.3  4487.9  5093.3   123.10095
      1658 525.38  1939.0  4567.4  5195.3   123.88966
      1659 525.58  1989.4  4578.8  5208.8   124.32773
      1660 525.78  1896.4  4564.1  5169.1   122.67772
      1661 525.98  1906.7  4557.6  5211.3   124.66005
      1662 526.18  1875.1  4531.7  5107.6   121.67747
      1663 526.38  1801.4  4425.3  5099.9   125.71027
      1664 526.58  1873.9  4546.1  5106.0   120.95341
      1665 526.78  1841.9  4478.5  5177.3   126.50303
      1666 526.98  1944.8  4620.2  5239.5   123.14755
      1667 527.17  1764.9  4495.3  5116.6   122.75729
      1668 527.37  1840.7  4573.5  5160.5   121.47782
      1669 527.57  1825.6  4537.9  5146.5   122.44034
      1670 527.77  1813.3  4477.3  5182.2   126.46065
      1671 527.97  1891.1  4562.1  5231.7   125.07285
      1672 528.17  1813.3  4552.6  5135.9   121.29185
      1673 528.37  1902.6  4555.5  5214.1   124.82628
      1674 528.57  1850.1  4594.8  5190.8   121.71318
      1675 528.77  1847.7  4524.8  5164.6   123.89843
      1676 528.97  1992.7  4732.9  5344.0   122.30195
      1677 529.17  1911.2  4633.7  5283.4   123.86040
      1678 529.37  1979.6  4724.7  5366.1   123.36617
      1679 529.57  1902.6  4649.7  5292.8   123.40837
      1680 529.77  1875.1  4590.3  5199.4   122.43174
      1681 529.97  1979.6  4732.9  5365.7   122.98422
      1682 530.17  1961.5  4792.7  5316.5   118.50407
      1683 530.36  1900.1  4605.5  5248.5   123.76986
      1684 530.56  1930.8  4655.4  5308.3   123.96270
      1685 530.76  1822.7  4560.8  5149.8   121.51085
      1686 530.96  1922.6  4636.6  5337.4   125.82252
      1687 531.16  1896.8  4650.9  5303.0   123.67638
      1688 531.36  1936.6  4785.3  5379.2   120.84831
      1689 531.56  1962.8  4793.9  5438.2   122.75752
      1690 531.76  1793.6  4593.2  5271.9   124.24288
      1691 531.96  1833.8  4646.4  5360.8   125.39680
      1692 532.16  1846.0  4734.5  5433.3   124.19172
      1693 532.36  1863.7  4744.3  5414.4   123.26179
      1694 532.56  1837.0  4744.3  5428.8   123.54188
      1695 532.76  1859.1  4774.6  5511.5   125.27399
      1696 532.95  1865.3  4743.5  5430.8   123.87935
      1697 533.15  1903.4  4805.4  5529.1   124.94001
      1698 533.35  1957.9  4859.4  5581.5   124.88708
      1699 533.55  1833.3  4761.9  5506.2   125.41260
      1700 533.75  1992.3  4985.2  5611.0   120.91144
      1701 533.95  1901.7  4769.7  5529.9   126.50672
      1702 534.15  1825.6  4761.1  5432.0   122.85473
      1703 534.35  1927.1  4825.8  5514.4   123.75300
      1704 534.55  1921.0  4917.2  5532.0   120.51948
      1705 534.75  1907.1  4809.0  5515.2   124.33311
      1706 534.94  1844.0  4742.3  5468.1   125.04243
      1707 535.14  1945.2  4830.3  5508.2   123.49519
      1708 535.34  1855.5  4771.8  5510.7   125.33708
      1709 535.54  1862.8  4783.6  5489.8   124.17615
      1710 535.74  1907.5  4858.2  5496.7   121.64077
      1711 535.94  1821.9  4755.0  5424.7   122.83201
      1712 536.14  1856.7  4839.4  5500.4   122.16423
      1713 536.34  2070.1  4926.2  5674.9   126.21539
      1714 536.54  1980.0  4989.7  5642.2   121.67937
      1715 536.73  1833.3  4750.9  5464.8   124.47003
      1716 536.93  1846.9  4805.8  5569.2   125.80289
      1717 537.13  1978.7  4914.7  5599.6   123.32590
      1718 537.33  2036.5  4956.1  5742.9   126.95007
      1719 537.53  1898.5  4842.6  5534.4   123.49750
      1720 537.73  1836.2  4819.7  5509.9   123.13288
      1721 537.93  1835.0  4812.3  5508.6   123.38697
      1722 538.13  1949.3  4972.1  5655.3   122.60161
      1723 538.32  1896.8  4879.1  5614.7   124.66693
      1724 538.52  1832.1  4863.9  5522.1   121.71034
      1725 538.72  1827.2  4836.1  5537.7   123.31885
      1726 538.92  1876.8  4927.4  5638.9   123.32169
      1727 539.12  1854.6  4898.3  5554.5   121.55832
      1728 539.32  1965.2  5009.7  5742.5   124.06834
      1729 539.52  1906.7  4942.2  5595.5   121.52206
      1730 539.72  1903.0  4974.5  5616.8   120.90946
      1731 539.91  1858.3  4898.3  5604.5   123.22822
      1732 540.11  1832.9  4880.3  5616.4   124.15322
      1733 540.31  1854.6  4940.1  5637.2   122.59393
      1734 540.51  1883.7  5022.0  5625.0   119.21170
      1735 540.71  2054.5  5108.5  5803.1   122.74678
      1736 540.91  2005.8  5022.4  5794.9   125.60758
      1737 541.11  1813.3  4884.0  5596.3   123.19593
      1738 541.30  1778.0  4945.4  5590.5   120.36725
      1739 541.50  1804.7  4862.7  5588.1   123.72088
      1740 541.70  1811.2  4946.3  5652.4   122.52419
      1741 541.90  1870.6  4947.1  5629.0   122.16751
      1742 542.10  1748.1  4886.5  5592.2   122.48760
      1743 542.30  1780.5  4879.9  5670.4   125.50549
      1744 542.49  1912.8  5054.0  5779.4   123.09299
      1745 542.69  1821.9  5012.2  5693.8   121.36346
      1746 542.89  1801.0  4943.0  5631.9   121.92675
      1747 543.09  1839.1  4972.5  5707.7   123.46406
      1748 543.29  1939.8  5085.1  5761.3   121.50022
      1749 543.49  1968.9  5105.2  5827.7   123.03777
      1750 543.68  1995.1  5094.9  5763.8   121.57767
      1751 543.88  1837.0  4921.3  5688.0   124.86054
      1752 544.08  1898.1  5082.2  5767.5   121.52047
      1753 544.28  1903.8  5083.9  5699.1   119.34567
      1754 544.48  1979.6  5135.9  5780.2   120.41267
      1755 544.68  1885.0  4986.0  5718.3   123.61641
      1756 544.87  1938.2  5088.4  5760.5   121.33662
      1757 545.07  1912.4  5062.6  5740.9   121.53165
      1758 545.27  1878.8  5078.1  5701.5   119.48536
      1759 545.47  1888.6  5064.6  5797.4   123.07196
      1760 545.67  1865.3  5005.2  5719.2   122.73676
      1761 545.87  1871.4  4992.5  5807.6   126.11550
      1762 546.06  1832.9  4982.7  5755.2   124.52536
      1763 546.26  1840.3  5054.4  5728.6   120.97616
      1764 546.46  1842.4  5042.5  5716.7   121.06744
      1765 546.66  1867.7  5089.2  5731.0   119.92374
      1766 546.86  2070.5  5233.8  5921.9   121.75319
      1767 547.05  1814.9  4967.1  5731.4   124.24637
      1768 547.25  1948.4  5085.5  5790.8   122.48334
      1769 547.45  2068.9  5244.0  5935.8   121.78793
      1770 547.65  1840.7  5039.2  5713.4   121.07823
      1771 547.85  1767.8  4832.0  5588.9   124.70261
      1772 548.04  1948.0  5126.9  5869.9   123.37328
      1773 548.24  1980.4  5104.8  5787.6   121.85370
      1774 548.44  1958.7  5042.5  5806.8   124.78416
      1775 548.64  1905.4  5043.7  5781.0   123.49257
      1776 548.84  2013.2  5128.9  5806.8   121.75629
      1777 549.03  1854.6  4841.4  5615.9   125.93253
      1778 549.23  1860.4  4920.0  5615.5   122.73092
      1779 549.43  1841.9  4888.5  5671.6   125.70586
      1780 549.63  1862.4  4959.4  5685.6   123.44929
      1781 549.83  1897.2  4937.7  5612.7   122.20125
      1782 550.02  1862.4  4929.9  5631.1   122.86022
      1783 550.22  1891.1  4946.3  5618.8   122.01368
      1784 550.42  1853.0  4961.4  5623.7   121.30715
      1785 550.62  1932.5  4967.1  5670.8   123.18801
      1786 550.82  1802.2  4832.8  5485.7   121.54343
      1787 551.01  1899.3  4963.5  5693.8   123.83372
      1788 551.21  1857.9  4913.9  5668.0   124.67497
      1789 551.41  2034.9  5057.3  5810.1   124.90852
      1790 551.61  1789.5  4813.5  5501.3   122.74143
      1791 551.80  1867.3  4992.5  5712.6   123.04064
      1792 552.00  1866.9  4898.3  5570.5   122.17266
      1793 552.20  1917.3  4922.9  5685.6   125.37478
      1794 552.40  1794.0  4881.1  5554.1   121.79911
      1795 552.60  1939.8  5035.1  5806.0   124.90405
      1796 552.79  1925.1  4955.7  5735.5   125.73319
      1797 552.99  1903.0  5004.0  5692.9   122.21636
      1798 553.19  1906.2  4952.0  5722.8   125.30933
      1799 553.39  1807.1  4930.7  5612.3   121.82009
      1800 553.58  1864.5  5034.7  5801.9   124.19897
      1801 553.78  1790.7  4883.6  5537.3   121.13629
      1802 553.98  1915.7  4949.9  5708.5   125.00002
      1803 554.18  1856.7  4915.9  5645.4   123.84524
      1804 554.37  1802.6  4872.9  5564.3   122.51867
      1805 554.57  1908.3  4875.0  5638.9   125.74898
      1806 554.77  1943.1  4999.5  5728.6   123.85420
      1807 554.97  1946.0  5000.3  5714.7   123.38744
      1808 555.16  1962.0  5008.5  5707.3   122.93628
      1809 555.36  2070.5  5072.8  5836.3   125.42971
      1810 555.56  1854.2  4927.8  5650.8   123.52079
      1811 555.76  1791.6  4884.8  5584.0   122.60330
      1812 555.95  2052.5  5128.5  5738.8   119.84022
      1813 556.15  1876.3  4877.9  5623.7   124.84988
      1814 556.35  1880.0  4897.9  5575.0   122.43487
      1815 556.55  1918.5  4896.3  5611.4   124.01648
      1816 556.74  1792.8  4843.4  5446.8   119.77714
      1817 556.94  1880.9  4838.1  5519.3   123.03326
      1818 557.14  1787.5  4769.3  5459.1   123.13187
      1819 557.34  1894.4  4849.2  5519.7   122.69199
      1820 557.53  1908.3  4889.3  5580.3   123.17942
      1821 557.73  1887.0  4892.6  5580.3   122.88090
      1822 557.93  1838.7  4861.1  5548.8   122.75376
      1823 558.13  1822.7  4862.7  5561.5   122.98572
      1824 558.32  1897.2  4889.3  5625.8   124.61325
      1825 558.52  1897.2  5020.4  5663.9   120.60325
      1826 558.72  1787.9  4870.5  5556.1   122.24290
      1827 558.92  1956.6  5010.6  5783.5   125.30850
      1828 559.11  1906.2  4946.7  5689.3   124.42407
      1829 559.31  1884.5  5008.9  5658.5   120.79183
      1830 559.51  1902.2  5002.4  5669.6   121.52202
      1831 559.70  1928.0  5054.4  5722.8   121.38085
      1832 559.90  1891.5  4964.7  5701.1   123.96373
      1833 560.10  1842.8  4947.5  5708.9   124.52507
      1834 560.30  1923.9  5048.2  5806.0   124.25274
      1835 560.49  1924.3  5068.3  5847.0   124.76551
      1836 560.69  1846.4  5070.0  5780.6   122.04578
      1837 560.89  1993.5  5149.4  5851.5   122.24527
      1838 561.08  1806.3  5056.8  5745.8   121.19457
      1839 561.28  1839.9  4990.1  5812.1   126.09541
      1840 561.48  1831.7  5088.8  5859.2   123.65443
      1841 561.68  1928.0  5115.4  5901.0   124.64663
      1842 561.87  1860.8  5057.7  5842.4   124.54834
      1843 562.07  1865.7  5121.6  5878.1   123.23564
      1844 562.27  1812.9  5033.5  5826.1   124.60893
      1845 562.46  1864.9  5154.7  5894.1   122.47262
      1846 562.66  1961.5  5231.7  5978.4   122.83315
      1847 562.86  1841.5  5132.2  5933.4   124.34652
      1848 563.05  1880.9  5139.6  5942.0   124.62296
      1849 563.25  1821.5  5081.4  5882.2   124.56339
      1850 563.45  1775.6  5122.4  5958.0   124.96637
      1851 563.65  2077.9  5387.4  6220.5   125.17324
      1852 563.84  1935.7  5302.6  6112.4   124.05110
      1853 564.04  1844.8  5297.3  6047.7   121.73449
      1854 564.24  1861.2  5303.0  6141.4   124.36037
      1855 564.43  1868.6  5261.2  6155.8   126.36724
      1856 564.63  1951.3  5421.4  6268.8   124.42161
      1857 564.83  1905.8  5468.9  6249.2   121.89907
      1858 565.02  1863.7  5441.0  6303.2   124.10122
      1859 565.22  1811.2  5465.2  6277.8   122.23966
      1860 565.42  1815.7  5540.2  6415.1   123.49059
      1861 565.61  1896.8  5609.0  6518.3   124.49520
      1862 565.81  1818.2  5732.3  6572.3   121.46293
      1863 566.01  1974.2  5849.0  6819.7   125.05285
      1864 566.20  1889.5  5822.4  6852.1   126.18205
      1865 566.40  1826.8  5840.8  6815.2   124.27550
      1866 566.60  1846.4  6070.6  7072.9   123.72734
      1867 566.79  1887.8  6212.3  7151.5   121.71814
      1868 566.99  1912.0  6455.2  7448.5   121.86258
      1869 567.19  1910.3  6537.9  7600.8   122.96867
      1870 567.38  1984.9  6651.4  7802.8   124.67304
      1871 567.58  1922.6  6719.4  7865.0   123.88354
      1872 567.78  1872.7  6947.1  8107.9   122.87512
      1873 567.97  1802.6  7009.0  8278.7   124.38833
      1874 568.17  1706.8  7124.9  8383.6   123.23103
      1875 568.37  1868.6  7423.1  8697.7   122.94815
      1876 568.56  1997.6  7684.0  9064.3   124.27429
      1877 568.76  1873.5  7744.6  9098.3   123.05706
      1878 568.96  1875.1  7940.8  9363.3   123.45195
      1879 569.15  1918.5  8109.1  9639.4   124.71880
      1880 569.35  2034.9  8586.7  9978.5   121.24282
      1881 569.55  1995.1  8571.6 10201.3   124.78202
      1882 569.74  1863.7  8536.8 10163.2   124.37393
      1883 569.94  2011.1  8689.9 10366.8   125.10732
      1884 570.14  1886.2  8912.4 10575.7   123.67379
      1885 570.33  1884.5  8967.6 10710.9   124.61111
      1886 570.53  1818.6  9030.7 10838.3   125.06247
      1887 570.73  1793.6  9250.7 10889.5   121.97626
      1888 570.92  1810.0  9387.9 11214.7   124.10680
      1889 571.12  1883.7  9507.9 11432.6   125.24444
      1890 571.31  1785.8  9643.1 11491.6   123.52603
      1891 571.51  1892.3  9840.1 11669.3   123.01588
      1892 571.71  1894.8 10058.0 11940.1   123.05569
      1893 571.90  1986.1 10236.2 12198.1   123.78115
      1894 572.10  1810.0 10119.4 12230.1   125.40051
      1895 572.30  1858.7 10356.6 12373.4   123.73355
      1896 572.49  1998.0 10597.4 12591.3   123.18647
      1897 572.69  1912.0 10570.8 12565.1   123.03215
      1898 572.88  2008.6 10839.5 12917.4   123.52968
      1899 573.08  1823.1 10597.8 12719.9   124.18429
      1900 573.28  2008.6 10921.4 13088.2   124.31066
      1901 573.47  1880.4 10982.0 13157.8   123.90531
      1902 573.67  1799.8 10896.4 13056.2   123.74262
      1903 573.87  1896.4 11136.0 13350.7   123.96932
      1904 574.06  1869.8 11309.3 13458.4   122.76750
      1905 574.26  1914.0 11430.9 13798.4   124.87627
      1906 574.45  1871.0 11507.1 13814.8   123.94797
      1907 574.65  1849.7 11684.9 13957.7   123.10928
      1908 574.85  1966.9 11971.6 14298.5   123.25800
      1909 575.04  1876.3 11993.7 14154.3   121.35541
      1910 575.24  1929.6 12085.5 14437.8   123.16193
      1911 575.44  1855.0 12009.3 14455.4   124.08939
      1912 575.63  1894.8 12252.2 14687.6   123.51405
      1913 575.83  1809.2 12187.5 14647.1   123.69958
      1914 576.02  1839.1 12323.0 14738.8   123.04266
      1915 576.22  1850.5 12356.6 14844.9   123.68421
      1916 576.42  1935.3 12549.5 14993.2   123.02230
      1917 576.61  1849.3 12587.2 15127.5   123.65730
      1918 576.81  1822.7 12524.6 14962.9   122.78398
      1919 577.00  1939.0 12607.3 15143.5   123.77332
      1920 577.20  1912.0 12603.6 15136.1   123.68693
      1921 577.40  1871.8 12694.1 15387.6   124.88834
      1922 577.59  1818.6 12740.0 15251.6   122.99730
      1923 577.79  1893.6 12878.4 15424.9   123.18132
      1924 577.98  1875.5 13031.6 15658.0   123.54150
      1925 578.18  1848.1 13141.4 15676.4   122.44669
      1926 578.37  1938.2 13291.7 15953.7   123.44601
      1927 578.57  1802.2 13336.4 15971.3   122.84445
      1928 578.77  1787.9 13391.7 16052.8   122.93328
      1929 578.96  1765.8 13330.2 16209.7   124.89906
      1930 579.16  1797.7 13600.2 16347.7   123.27954
      1931 579.35  1855.9 13606.3 16485.7   124.50502
      1932 579.55  1839.1 13822.6 16707.7   124.07630
      1933 579.75  1821.1 13641.5 16478.0   123.99598
      1934 579.94  1916.9 14078.6 16860.1   122.87149
      1935 580.14  1870.2 13868.0 16692.6   123.54227
      1936 580.33  1988.6 14064.6 16843.7   123.01327
      1937 580.53  1841.5 13771.0 16659.8   124.21631
      1938 580.72  1939.0 13853.7 16560.3   122.71650
      1939 580.92  1928.0 13873.4 16661.5   123.34042
      1940 581.12  1864.5 13627.6 16438.6   123.89707
      1941 581.31  1875.1 13757.8 16669.2   124.50106
      1942 581.51  1983.3 13764.0 16601.7   124.08734
      1943 581.70  1820.6 13655.4 16366.1   122.90441
      1944 581.90  2143.0 13783.2 16498.0   123.32243
      1945 582.09  1830.1 13433.0 16240.4   124.19514
      1946 582.29  1783.8 13281.9 16081.1   124.34454
      1947 582.48  1858.7 13200.8 15946.7   124.21003
      1948 582.68  1909.9 13301.6 15906.6   122.86783
      1949 582.88  1982.4 12990.7 15512.5   122.90892
      1950 583.07  1793.2 12767.0 15259.0   122.70828
      1951 583.27  1810.0 12581.5 15145.5   123.80409
      1952 583.46  1913.6 12622.5 15157.4   123.67182
      1953 583.66  1990.2 12539.7 14977.2   123.10529
      1954 583.85  1871.4 12350.5 14827.3   123.63587
      1955 584.05  1960.7 12320.6 14813.4   124.06200
      1956 584.24  2023.8 12291.5 14892.8   125.33509
      1957 584.44  1925.5 12341.9 14652.4   122.18159
      1958 584.63  1866.5 12224.3 14607.8   123.01093
      1959 584.83  1869.4 12120.7 14585.2   124.04108
      1960 585.03  1903.8 12176.8 14614.7   123.73111
      1961 585.22  1837.8 12066.6 14396.8   122.78060
      1962 585.42  1756.7 11891.7 14341.1   124.16748
      1963 585.61  1889.5 11906.1 14282.1   123.72112
      1964 585.81  1840.7 11851.2 14258.4   124.04664
      1965 586.00  1874.3 11651.3 13889.3   122.89065
      1966 586.20  1902.6 11585.8 13847.5   123.35773
      1967 586.39  1913.6 11438.3 13617.4   122.87779
      1968 586.59  1830.9 11218.8 13385.1   123.07591
      1969 586.78  1827.2 10950.5 13075.5   123.29173
      1970 586.98  1941.9 11057.0 13142.2   122.87679
      1971 587.17  1890.3 10749.8 12800.6   123.14841
      1972 587.37  1922.6 10712.1 12694.5   122.55464
      1973 587.56  1978.3 10642.9 12544.6   121.94857
      1974 587.76  1939.8 10361.9 12261.2   122.55130
      1975 587.95  1909.5 10263.6 12158.0   122.67601
      1976 588.15  1853.0 10076.0 11881.1   121.95159
      1977 588.34  1904.6 10035.9 11814.3   121.87185
      1978 588.54  1839.5  9726.2 11477.2   122.20202
      1979 588.74  1898.9  9618.5 11357.6   122.52878
      1980 588.93  1773.5  9430.9 11196.7   123.05965
      1981 589.13  1907.9  9395.3 11074.6   122.42889
      1982 589.32  1858.3  9281.0 10939.0   122.33748
      1983 589.52  1799.8  9092.6 10750.2   122.72957
      1984 589.71  1929.6  9224.5 10934.5   123.44189
      1985 589.91  1915.3  9098.7 10713.7   122.48260
      1986 590.10  1786.6  8998.4 10654.4   122.96247
      1987 590.30  1880.4  9121.2 10779.3   122.89853
      1988 590.49  1851.8  9161.0 10747.7   121.70916
      1989 590.69  1947.6  9072.1 10806.7   124.34748
      1990 590.88  1814.1  8996.7 10691.6   123.59717
      1991 591.08  1795.2  9093.8 10767.8   122.93620
      1992 591.27  1896.8  9163.8 10762.1   121.99301
      1993 591.47  1789.1  9094.2 10798.1   123.32492
      1994 591.66  1826.0  9146.2 10841.9   123.16474
      1995 591.85  1836.2  9276.9 10937.0   122.31090
      1996 592.05  1930.8  9342.0 11079.1   123.43871
      1997 592.24  2023.4  9298.6 11132.8   125.21113
      1998 592.44  1940.2  9334.2 11060.7   123.34922
      1999 592.63  1751.0  9162.6 10955.0   124.18347
      2000 592.83  1883.3  9435.0 11234.3   123.82708
      2001 593.02  1863.7  9403.9 11105.7   122.57048
      2002 593.22  1834.6  9389.5 11069.7   122.23909
      2003 593.41  1802.2  9247.8 11004.6   123.59444
      2004 593.61  1833.8  9275.7 11047.6   123.80979
      2005 593.80  2112.3  9469.0 11224.5   123.86282
      2006 594.00  1797.3  9123.3 10798.9   122.87264
      2007 594.19  1794.4  9033.2 10674.4   122.67300
      2008 594.39  1878.8  9074.5 10687.5   122.41575
      2009 594.58  1806.7  8911.9 10550.3   123.05874
      2010 594.78  1851.8  8874.7 10513.5   123.33488
      2011 594.97  1923.5  8768.2 10488.1   125.12717
      2012 595.17  1860.4  8789.5 10480.7   124.40741
      2013 595.36  1915.7  8805.0 10358.6   122.55053
      2014 595.56  1887.4  8754.7 10389.3   123.80412
      2015 595.75  1941.1  8839.4 10471.7   123.66108
      2016 595.94  1916.1  8816.5 10417.2   123.19702
      2017 596.14  1946.0  8755.9 10391.0   124.01058
      2018 596.33  1891.9  8683.4 10310.7   123.96115
      2019 596.53  1772.7  8659.6 10253.8   123.14738
      2020 596.72  1867.3  8761.6 10492.6   125.10694
      2021 596.92  1852.6  8770.6 10381.6   123.28597
      2022 597.11  1816.5  8698.5 10373.4   124.33639
      2023 597.31  1817.8  8848.0 10513.9   123.69495
      2024 597.50  1887.0  8907.0 10595.8   124.05624
      2025 597.69  1982.8  8958.6 10595.0   123.45724
      2026 597.89  1936.6  8960.3 10652.7   124.09610
      2027 598.08  1784.6  8778.8 10499.9   124.60764
      2028 598.28  1898.1  9155.2 10831.7   123.10080
      2029 598.47  1896.0  8959.0 10536.8   122.33820
      2030 598.67  1856.3  9028.7 10735.9   123.80219
      2031 598.86  1878.0  9066.8 10688.8   122.56281
      2032 599.06  1958.3  9108.1 10824.7   124.00895
      2033 599.25  1861.6  8975.8 10632.6   123.28862
      2034 599.44  1874.3  9019.7 10764.9   124.42534
      2035 599.64  1870.6  9012.3 10732.6   124.08810
      2036 599.83  1883.3  9101.2 10814.5   123.73738
      2037 600.03  1862.0  9053.7 10726.0   123.25437
      2038 600.22  1899.7  9084.4 10694.9   122.41605
      2039 600.42  1859.6  8994.3 10608.5   122.62472
      2040 600.61  1840.3  8954.1 10706.8   124.63727
      2041 600.80  1839.1  8992.6 10630.2   122.89150
      2042 601.00  1914.9  9063.5 10722.8   123.21092
      2043 601.19  1835.0  8954.1 10615.9   123.34158
      2044 601.39  1976.3  9020.9 10647.4   123.08855
      2045 601.58  1860.8  8899.2 10565.1   123.66737
      2046 601.78  1909.9  8992.6 10591.7   122.57691
      2047 601.97  1847.3  8805.9 10437.7   123.45048
      2048 602.16  1859.6  8855.4 10508.9   123.63583
      2049 602.36  1835.8  8742.8 10335.7   123.06232
      2050 602.55  1887.4  8885.3 10524.9   123.42991
      2051 602.75  1886.2  8771.0 10331.6   122.66642
      2052 602.94  1941.1  8812.8 10428.3   123.50838
      2053 603.13  1946.8  8837.8 10543.4   124.75037
      2054 603.33  1767.4  8667.4 10278.3   123.34680
      2055 603.52  1863.7  8739.1 10328.3   123.11451
      2056 603.72  1920.6  8792.3 10391.8   123.27592
      2057 603.91  1823.1  8590.4 10169.0   123.32647
      2058 604.10  1871.0  8735.8 10322.2   123.10858
      2059 604.30  1879.6  8601.5 10187.4   123.59393
      2060 604.49  1918.1  8642.0 10123.5   122.03337
      2061 604.69  1882.9  8539.2 10029.3   122.38631
      2062 604.88  1869.4  8502.3 10093.6   123.99037
      2063 605.07  1855.5  8447.9 10091.2   124.92700
      2064 605.27  1873.5  8441.3  9899.5   122.20142
      2065 605.46  1783.4  8362.3  9854.0   122.67463
      2066 605.66  1891.1  8406.5  9915.4   123.15962
      2067 605.85  1866.5  8321.7  9723.8   121.71955
      2068 606.04  1896.4  8397.9  9872.8   122.68632
      2069 606.24  1948.4  8362.3  9816.7   122.67705
      2070 606.43  1805.5  8184.1  9601.3   122.21793
      2071 606.62  1835.8  8087.8  9545.6   123.31630
      2072 606.82  1847.3  8089.5  9584.1   123.94356
      2073 607.01  1898.1  8096.4  9525.5   123.05556
      2074 607.21  1812.5  7992.0  9460.8   123.76880
      2075 607.40  1979.2  8066.9  9449.3   122.70740
      2076 607.59  1884.5  7976.8  9379.7   123.02677
      2077 607.79  1812.9  7883.0  9295.7   123.27261
      2078 607.98  1940.7  8059.2  9318.7   120.58507
      2079 608.17  1808.8  7832.7  9254.8   123.60782
      2080 608.37  1871.0  7919.5  9271.2   122.34714
      2081 608.56  2028.3  7917.0  9366.2   124.60874
      2082 608.76  1781.3  7703.2  9046.3   122.67948
      2083 608.95  1794.4  7625.4  8925.0   122.28856
      2084 609.14  1957.0  7864.2  9093.8   120.81541
      2085 609.34  1880.9  7605.3  8930.4   123.14682
      2086 609.53  1839.9  7649.2  8898.8   121.51168
      2087 609.72  1821.9  7447.6  8787.0   123.80780
      2088 609.92  1850.1  7640.2  8799.3   120.01982
      2089 610.11  1878.0  7601.2  8881.2   122.36455
      2090 610.30  1873.9  7678.7  8920.1   121.38725
      2091 610.50  1823.1  7493.5  8730.5   121.81450
      2092 610.69  1778.0  7372.3  8627.3   122.43373
      2093 610.88  1919.4  7524.2  8709.2   121.14148
      2094 611.08  1824.3  7383.7  8710.4   123.86355
      2095 611.27  1783.0  7328.5  8531.4   121.69289
      2096 611.46  1926.3  7477.5  8675.2   121.57455
      2097 611.66  1828.4  7330.9  8608.4   123.21721
      2098 611.85  1798.9  7308.4  8452.8   120.77169
      2099 612.04  1908.7  7416.1  8625.6   121.96194
      2100 612.24  1950.9  7357.5  8609.7   123.15909
      2101 612.43  1835.4  7278.9  8567.1   123.66440
      2102 612.62  1859.1  7297.3  8459.7   121.37531
      2103 612.82  1866.5  7273.2  8460.6   121.96212
      2104 613.01  1834.2  7371.9  8500.7   120.38463
      2105 613.20  1867.7  7360.4  8445.4   119.75392
      2106 613.40  1855.9  7269.9  8484.3   122.43154
      2107 613.59  1817.8  7242.8  8309.4   119.66025
      2108 613.78  1853.4  7306.3  8488.4   121.67807
      2109 613.98  1764.5  7072.5  8272.6   122.60978
      2110 614.17  1785.0  7124.9  8321.3   122.40548
      2111 614.36  1893.1  7236.7  8351.6   120.86465
      2112 614.56  2198.3  7500.5  8688.7   122.41019
      2113 614.75  1832.9  7067.1  8309.8   123.74207
      2114 614.94  1804.3  6958.2  8216.0   124.40593
      2115 615.14  1794.4  6990.5  8289.8   125.00393
      2116 615.33  1973.8  7147.0  8380.7   123.84799
      2117 615.52  1932.5  7100.7  8237.3   121.99240
      2118 615.72  1852.2  7061.0  8161.6   121.12919
      2119 615.91  1890.3  6982.3  8115.3   122.24903
      2120 616.10  1898.1  6990.9  8111.6   122.00419
      2121 616.30  1896.4  6924.2  8045.2   122.29735
      2122 616.49  1893.6  6949.2  8050.6   121.78561
      2123 616.68  1871.4  6757.1  7905.2   123.49932
      2124 616.88  2023.4  6879.5  8021.1   123.50707
      2125 617.07  1978.3  6867.7  7978.5   122.71929
      2126 617.26  1839.5  6653.0  7811.0   124.05549
      2127 617.45  1889.0  6707.9  7698.3   120.55249
      2128 617.65  2036.5  6804.6  7894.9   122.86746
      2129 617.84  1792.8  6509.7  7577.5   122.63807
      2130 618.03  1897.2  6606.3  7653.3   122.23187
      2131 618.23  1896.4  6601.0  7615.2   121.55667
      2132 618.42  1893.1  6498.2  7637.3   124.73538
      2133 618.61  1837.0  6417.9  7418.6   121.84372
      2134 618.80  1814.5  6474.4  7550.0   123.08167
      2135 619.00  1839.9  6344.2  7434.5   124.20659
      2136 619.19  1922.2  6450.7  7536.1   123.96887
      2137 619.38  1912.8  6431.9  7453.0   122.59584
      2138 619.58  1885.4  6378.6  7396.4   122.65270
      2139 619.77  1885.0  6438.4  7421.0   121.57957
      2140 619.96  1938.2  6460.9  7482.5   122.58649
      2141 620.15  1826.4  6374.1  7327.2   120.95831
      2142 620.35  1841.9  6319.6  7357.9   123.18880
      2143 620.54  1807.5  6394.6  7367.0   121.19831
      2144 620.73  1832.5  6377.0  7419.8   122.94728
      2145 620.93  1902.6  6424.5  7398.1   121.53079
      2146 621.12  1855.5  6397.0  7368.6   121.39251
      2147 621.31  1896.0  6463.4  7531.2   123.37907
      2148 621.50  1819.8  6375.3  7453.0   123.65581
      2149 621.70  2030.4  6628.0  7580.8   120.72160
      2150 621.89  1808.8  6359.8  7416.9   123.22924
      2151 622.08  1690.0  6319.6  7337.9   121.99416
      2152 622.27  1914.0  6491.7  7556.2   123.25521
      2153 622.47  1986.5  6555.5  7585.7   122.54594
      2154 622.66  1805.9  6365.9  7416.9   123.04860
      2155 622.85  1873.9  6501.1  7549.6   122.66088
      2156 623.04  1884.1  6431.0  7554.1   124.70050
      2157 623.24  1830.9  6439.2  7385.8   120.54039
      2158 623.43  1860.0  6416.7  7448.1   122.63370
      2159 623.62  1859.1  6414.6  7369.4   120.95846
      2160 623.81  1880.9  6455.6  7415.7   120.98666
      2161 624.01  1930.0  6398.7  7376.8   121.88816
      2162 624.20  1872.3  6379.8  7442.3   123.57110
      2163 624.39  1910.8  6313.5  7287.5   122.12299
      2164 624.58  1851.4  6266.8  7305.5   123.52506
      2165 624.78  1910.3  6343.4  7298.6   121.54672
      2166 624.97  1835.4  6221.7  7213.4   122.60717
      2167 625.16  1840.7  6109.5  7044.6   121.90560
      2168 625.35  1881.7  6150.5  7074.5   121.64651
      2169 625.55  1911.2  6216.8  7135.5   121.33752
      2170 625.74  1885.8  6073.5  6984.8   121.76252
      2171 625.93  1910.8  6069.0  6973.3   121.74941
      2172 626.12  1838.7  5929.3  6861.9   122.79964
      2173 626.32  1784.2  5946.9  6828.7   121.18468
      2174 626.51  1850.1  5919.0  6809.5   121.88444
      2175 626.70  1833.3  5910.0  6746.4   120.51644
      2176 626.89  1845.2  5839.6  6761.2   123.07219
      2177 627.09  1873.9  5847.4  6763.2   123.04918
      2178 627.28  1765.8  5702.8  6636.2   123.70994
      2179 627.47  1860.0  5831.0  6627.6   120.06186
      2180 627.66  1994.3  5860.1  6768.1   123.49014
      2181 627.85  1883.3  5788.8  6621.1   121.31097
      2182 628.05  1925.1  5767.5  6537.5   120.04050
      2183 628.24  1828.0  5710.1  6541.6   121.41804
      2184 628.43  1912.8  5750.7  6581.4   121.64354
      2185 628.62  1972.2  5680.7  6548.6   123.40401
      2186 628.82  1791.6  5516.0  6277.0   120.43330
      2187 629.01  1973.8  5622.1  6492.9   123.86886
      2188 629.20  1927.5  5550.4  6431.0   124.30750
      2189 629.39  1930.8  5592.2  6305.3   119.47646
      2190 629.58  1800.6  5506.2  6277.0   120.80246
      2191 629.78  1888.6  5498.4  6246.7   120.73072
      2192 629.97  1869.4  5445.1  6284.8   123.48224
      2193 630.16  1866.1  5383.7  6234.4   124.18490
      2194 630.35  1893.1  5403.4  6269.2   124.66744
      2195 630.54  1905.0  5396.0  6177.5   122.38649
      2196 630.74  1834.2  5293.2  6076.7   122.65246
      2197 630.93  1829.2  5346.8  5979.7   117.99021
      2198 631.12  1876.8  5297.3  6052.2   122.06921
      2199 631.31  1780.5  5191.2  5868.7   119.86310
      2200 631.50  1894.8  5286.2  6056.7   122.71740
      2201 631.70  1991.9  5322.7  6059.9   122.13478
      2202 631.89  1844.8  5156.8  5880.5   121.85258
      2203 632.08  1861.2  5165.8  5878.9   121.57909
      2204 632.27  1783.4  5044.1  5792.5   122.94938
      2205 632.46  1951.7  5199.0  5977.6   123.97832
      2206 632.65  1876.8  5178.5  5886.3   121.43655
      2207 632.85  1777.6  5027.4  5776.5   123.05268
      2208 633.04  1867.7  5130.6  5815.8   121.00178
      2209 633.23  1946.8  5185.9  5874.0   121.24433
      2210 633.42  1821.9  5052.3  5769.5   122.20110
      2211 633.61  1849.3  5161.3  5795.3   119.14420
      2212 633.81  1888.2  5130.6  5832.6   121.65236
      2213 634.00  1874.3  5119.1  5796.2   120.86593
      2214 634.19  1847.7  5089.2  5822.8   122.63080
      2215 634.38  1890.7  5086.3  5855.1   124.05795
      2216 634.57  1855.0  5013.4  5755.6   123.49887
      2217 634.76  1799.3  5014.7  5771.6   123.54142
      2218 634.96  1818.6  5017.5  5747.0   122.80412
      2219 635.15  1914.4  5058.5  5723.7   121.15684
      2220 635.34  1933.3  5149.8  5825.2   120.99834
      2221 635.53  1940.7  5083.5  5788.8   122.44232
      2222 635.72  1937.4  5064.6  5792.9   123.28746
      2223 635.91  1787.5  5003.2  5641.3   119.84460
      2224 636.11  1924.7  5107.2  5785.9   121.32562
      2225 636.30  1937.0  5098.6  5747.0   120.50784
      2226 636.49  1980.4  5130.2  5792.1   121.01429
      2227 636.68  1801.8  4950.8  5619.2   121.22789
      2228 636.87  1783.0  4905.7  5670.8   124.50158
      2229 637.06  2061.1  5145.3  5866.2   123.37317
      2230 637.26  1854.6  4992.5  5686.4   122.11201
      2231 637.45  1830.5  4911.8  5646.2   123.83359
      2232 637.64  1831.7  4949.5  5580.7   120.24435
      2233 637.83  1848.5  4913.5  5669.6   124.66925
      2234 638.02  1767.4  4902.8  5534.0   120.13064
      2235 638.21  1947.2  4995.4  5690.5   122.80303
      2236 638.40  1993.5  5058.5  5762.6   122.97205
      2237 638.60  2002.5  5007.7  5692.5   122.78862
      2238 638.79  1905.0  4905.3  5610.2   123.49489
      2239 638.98  1891.9  4889.3  5520.5   121.05767
      2240 639.17  1887.8  4875.0  5561.1   122.96721
      2241 639.36  1790.3  4820.1  5402.5   119.22403
      2242 639.55  1835.4  4833.6  5458.2   120.83332
      2243 639.74  1787.5  4786.5  5425.1   121.29197
      2244 639.93  1832.5  4799.6  5459.9   122.25289
      2245 640.13  1892.7  4833.6  5463.2   121.40667
      2246 640.32  1846.4  4774.6  5410.7   121.72332
      2247 640.51  1888.2  4721.0  5397.6   123.88660
      2248 640.70  1966.0  4854.1  5487.3   121.92593
      2249 640.89  1882.1  4765.2  5405.8   122.21904
      2250 641.08  1893.6  4750.1  5411.6   123.15744
      2251 641.27  1821.5  4650.9  5320.6   123.66822
      2252 641.46  1932.9  4775.0  5387.4   121.54490
      2253 641.66  1946.0  4759.5  5321.4   119.97381
      2254 641.85  1839.9  4709.9  5327.2   121.50703
      2255 642.04  1803.0  4551.8  5200.6   123.60306
      2256 642.23  1977.9  4755.4  5377.6   122.40083
      2257 642.42  1842.4  4611.2  5238.3   122.64793
      2258 642.61  1832.9  4633.3  5244.0   121.80784
      2259 642.80  1842.4  4613.3  5230.1   122.26168
      2260 642.99  1819.8  4575.6  5206.8   122.90428
      2261 643.18  1952.9  4748.8  5333.7   120.92002
      2262 643.38  1971.4  4714.8  5304.6   121.49895
      2263 643.57  1816.1  4598.9  5226.8   122.56402
      2264 643.76  1808.8  4503.9  5183.4   125.21276
      2265 643.95  1968.1  4727.5  5208.0   117.41133
      2266 644.14  1957.0  4714.4  5340.7   122.71242
      2267 644.33  1932.1  4680.4  5224.0   119.77646
      2268 644.52  1998.8  4680.0  5323.1   123.98411
      2269 644.71  1871.0  4561.6  5180.5   123.00197
      2270 644.90  1788.3  4532.2  5131.4   121.83905
      2271 645.09  1797.7  4537.5  5094.9   120.34683
      2272 645.29  1908.3  4618.6  5192.8   121.18787
      2273 645.48  1872.3  4524.0  5185.0   124.93048
      2274 645.67  1880.9  4610.0  5180.5   120.90650
      2275 645.86  1855.5  4635.4  5243.6   121.88008
      2276 646.05  1903.8  4657.1  5258.0   121.82386
      2277 646.24  1992.7  4757.8  5385.3   122.69295
      2278 646.43  1739.5  4518.2  5107.6   121.21166
      2279 646.62  1849.3  4634.1  5257.5   122.38562
      2280 646.81  1842.8  4667.3  5264.5   121.14266
      2281 647.00  1869.4  4664.5  5329.6   123.79835
      2282 647.19  1847.7  4642.3  5255.9   121.95513
      2283 647.38  1827.6  4631.7  5233.4   121.45778
      2284 647.57  1877.2  4701.3  5362.4   123.40826
      2285 647.77  1945.2  4767.3  5391.1   122.10449
      2286 647.96  1853.8  4674.7  5258.8   120.70569
      2287 648.15  1803.9  4649.7  5218.2   119.97697
      2288 648.34  1904.6  4777.9  5395.2   121.48255
      2289 648.53  1974.7  4830.3  5435.3   121.18474
      2290 648.72  1896.8  4733.7  5349.7   121.71528
      2291 648.91  1927.1  4781.6  5414.8   122.18397
      2292 649.10  1946.0  4836.5  5474.6   122.07737
      2293 649.29  1755.5  4639.1  5266.1   121.74716
      2294 649.48  1854.6  4700.9  5316.5   121.62903
      2295 649.67  1855.5  4678.0  5339.1   123.42188
      2296 649.86  1997.6  4837.3  5436.5   121.10199
      2297 650.05  1791.6  4657.1  5278.8   121.69810
      2298 650.24  1794.8  4717.7  5296.0   119.78698
      2299 650.43  1941.5  4852.5  5423.0   119.60039
      2300 650.62  1864.9  4738.6  5350.9   121.30845
      2301 650.81  2009.1  4834.0  5523.8   124.41642
      2302 651.01  1848.9  4721.0  5374.7   122.76095
      2303 651.20  1860.4  4740.2  5379.2   122.18749
      2304 651.39  1900.1  4818.9  5434.5   121.09180
      2305 651.58  1966.0  4886.0  5450.5   119.32949
      2306 651.77  1807.9  4773.0  5384.5   120.62438
      2307 651.96  1894.4  5031.4  5725.3   122.11774
      2308 652.15  1881.7  5713.0  6593.6   122.98480
      2309 652.34  1870.2  6707.9  7901.5   124.67191
      2310 652.53  1942.3  8211.9  9835.6   125.89666
      2311 652.72  1814.9  9695.5 11845.0   127.27651
      2312 652.91  1926.3 11818.0 14054.4   122.60870
      2313 653.10  1927.5 13553.0 16282.2   123.47532
      2314 653.29  1884.5 15347.1 18577.5   123.99599
      2315 653.48  1803.0 17269.3 20772.5   122.65095
      2316 653.67  1937.4 19148.1 23003.2   122.39939
      2317 653.86  1833.3 20807.8 25222.8   123.26821
      2318 654.05  1812.5 22352.8 27231.0   123.74970
      2319 654.24  1845.2 23597.5 28670.7   123.32273
      2320 654.43  1845.6 25078.6 30371.8   122.78305
      2321 654.62  1862.8 25933.8 31252.0   122.09365
      2322 654.81  1906.2 26909.1 32648.3   122.95431
      2323 655.00  1840.7 27340.8 33147.2   122.77013
      2324 655.19  1883.7 28091.6 33815.2   121.83949
      2325 655.38  1916.9 28278.4 34193.3   122.43785
      2326 655.57  1861.2 28832.1 34820.8   122.20417
      2327 655.76  2011.5 28871.4 34768.8   121.95587
      2328 655.95  1892.7 29037.3 34985.0   121.91121
      2329 656.14  1821.1 28809.2 34768.4   122.08074
      2330 656.33  1793.6 28604.8 34576.7   122.27382
      2331 656.52  1902.2 27673.0 33461.8   122.46257
      2332 656.71  1787.5 26390.5 32093.3   123.17912
      2333 656.90  1892.7 24705.5 29705.8   121.91899
      2334 657.09  1898.5 22922.9 27605.4   122.27158
      2335 657.28  1866.5 20800.0 24977.4   122.06381
      2336 657.47  1919.8 18793.8 22411.3   121.43845
      2337 657.66  1903.0 17346.3 20793.8   122.32390
      2338 657.85  1838.7 15570.3 18394.9   120.56972
      2339 658.04  1851.4 14544.3 17218.5   121.06877
      2340 658.23  1828.0 13310.2 15723.5   121.01808
      2341 658.42  1922.2 12588.0 14871.9   121.41320
      2342 658.61  1803.0 11715.6 13765.6   120.68097
      2343 658.80  1810.4 10986.5 12901.8   120.87221
      2344 658.99  1861.6 10546.2 12271.4   119.86512
      2345 659.18  2069.7 10147.7 11921.2   121.95518
      2346 659.37  1789.9  9437.0 11041.4   120.98019
      2347 659.56  1902.2  9115.1 10499.9   119.19933
      2348 659.75  1857.9  8603.1 10031.4   121.17441
      2349 659.94  1863.7  8136.2  9438.3   120.75879
      2350 660.13  1783.8  7775.3  8961.9   119.80448
      2351 660.32  1878.0  7466.9  8607.2   120.40308
      2352 660.51  1884.5  7081.5  8176.7   121.07504
      2353 660.70  1873.9  6789.0  7818.3   120.94169
      2354 660.89  2010.7  6497.4  7524.6   122.89574
      2355 661.08  1838.7  6106.6  7007.3   121.10365
      2356 661.27  1921.4  5926.4  6645.2   117.94845
      2357 661.46  1900.9  5572.9  6394.6   122.37590
      2358 661.65  1814.9  5416.1  6189.0   121.46271
      2359 661.84  1939.4  5282.1  6027.2   122.28893
      2360 662.03  1864.5  5071.2  5774.5   121.93130
      2361 662.22  1914.4  5053.6  5682.3   120.02869
      2362 662.41  1863.7  4914.7  5554.1   120.95584
      2363 662.60  1797.3  4762.8  5392.7   121.24309
      2364 662.78  1852.2  4771.8  5396.4   121.39452
      2365 662.97  1930.0  4799.6  5414.8   121.43874
      2366 663.16  1860.4  4608.7  5265.3   123.88973
      2367 663.35  1831.3  4619.0  5275.6   123.55276
      2368 663.54  1852.2  4693.9  5301.8   121.38948
      2369 663.73  1949.3  4753.3  5371.8   122.05670
      2370 663.92  1822.3  4583.8  5194.1   122.10024
      2371 664.11  1847.7  4620.6  5146.5   118.96601
      2372 664.30  1855.9  4584.2  5192.4   122.29396
      2373 664.49  1948.4  4703.8  5281.7   120.97514
      2374 664.68  1804.7  4559.2  5231.3   124.40147
      2375 664.87  1892.7  4626.0  5291.5   124.35187
      2376 665.06  1878.8  4622.3  5248.1   122.81282
      2377 665.25  1869.0  4611.6  5198.2   121.38589
      2378 665.44  1921.4  4671.8  5255.5   121.22114
      2379 665.63  1881.7  4588.7  5171.1   121.51610
      2380 665.82  1907.5  4645.2  5237.5   121.63373
      2381 666.01  2051.2  4737.8  5327.2   121.93931
      2382 666.19  1810.4  4598.1  5153.5   119.92363
      2383 666.38  1961.1  4670.6  5273.1   122.23732
      2384 666.57  1982.8  4688.2  5300.6   122.63438
      2385 666.76  1833.8  4557.1  5143.7   121.53706
      2386 666.95  1930.8  4668.6  5297.3   122.96527
      2387 667.14  1861.2  4557.1  5176.0   122.95654
      2388 667.33  1826.0  4624.7  5175.6   119.68390
      2389 667.52  1965.6  4684.1  5321.4   123.44433
      2390 667.71  1805.5  4512.1  5144.9   123.38073
      2391 667.90  1912.8  4614.5  5165.4   120.39116
      2392 668.09  1957.9  4688.2  5200.6   118.76688
      2393 668.28  1822.7  4585.0  5193.2   122.01959
      2394 668.46  1828.0  4579.3  5212.9   123.03113
      2395 668.65  1955.4  4631.3  5323.9   125.88397
      2396 668.84  2011.9  4798.4  5375.5   120.71142
      2397 669.03  1817.0  4612.4  5185.0   120.48352
      2398 669.22  1760.4  4544.0  5199.4   123.54326
      2399 669.41  1925.5  4731.2  5383.3   123.24090
      2400 669.60  1979.2  4856.6  5464.0   121.11034
      2401 669.79  1821.9  4612.0  5316.1   125.23485
      2402 669.98  1902.6  4754.2  5383.7   122.07697
      2403 670.17  1800.6  4645.2  5356.7   125.01078
      2404 670.35  1914.9  4798.0  5421.8   121.63659
      2405 670.54  1847.7  4740.2  5415.2   123.33618
      2406 670.73  1813.7  4730.4  5376.3   122.14579
      2407 670.92  1941.1  4816.8  5505.8   123.95672
      2408 671.11  1905.8  4811.1  5440.2   121.65516
      2409 671.30  1769.4  4669.0  5335.4   122.98347
      2410 671.49  1827.6  4750.1  5430.0   123.26557
      2411 671.68  1817.8  4710.3  5399.7   123.83177
      2412 671.87  1914.4  4883.2  5522.1   121.52317
      2413 672.05  1968.9  4785.3  5534.8   126.61429
      2414 672.24  1782.6  4745.1  5376.7   121.31893
      2415 672.43  1919.8  4872.5  5500.8   121.27897
      2416 672.62  1848.9  4763.2  5425.9   122.74066
      2417 672.81  1972.2  4870.9  5496.3   121.57695
      2418 673.00  1913.6  4786.5  5445.1   122.92555
      2419 673.19  1787.9  4689.0  5316.9   121.64337
      2420 673.38  1824.7  4776.3  5383.7   120.58005
      2421 673.57  1816.5  4698.9  5368.1   123.22011
      2422 673.75  1980.4  4822.1  5526.6   124.79100
      2423 673.94  1904.6  4747.2  5418.9   123.63109
      2424 674.13  1873.9  4719.3  5401.7   123.98157
      2425 674.32  1860.0  4653.4  5324.7   124.03225
      2426 674.51  1891.5  4755.0  5410.3   122.88657
      2427 674.70  1882.9  4774.2  5343.1   119.67698
      2428 674.89  1730.9  4578.4  5220.3   122.54026
      2429 675.07  1912.8  4769.3  5433.3   123.24346
      2430 675.26  2037.3  4862.7  5522.1   123.34010
      2431 675.45  1848.5  4737.8  5352.6   121.27870
      2432 675.64  1908.7  4786.5  5369.8   120.26756
      2433 675.83  1904.6  4777.5  5412.4   122.09865
      2434 676.02  1956.6  4828.3  5432.0   121.02410
      2435 676.21  1962.0  4848.8  5447.6   120.74347
      2436 676.39  1894.8  4805.4  5408.3   120.71489
      2437 676.58  1792.8  4715.7  5366.5   122.26736
      2438 676.77  1742.8  4660.8  5296.5   121.78553
      2439 676.96  1887.0  4770.5  5504.5   125.45455
      2440 677.15  1889.0  4821.7  5448.8   121.38268
      2441 677.34  1959.9  4887.3  5596.7   124.23393
      2442 677.52  1926.3  4874.6  5552.0   122.97860
      2443 677.71  1823.9  4762.3  5387.0   121.25730
      2444 677.90  1846.9  4845.5  5498.4   121.77297
      2445 678.09  1935.3  4875.8  5551.2   122.96977
      2446 678.28  1859.1  4864.7  5573.3   123.57590
      2447 678.47  1995.5  4997.9  5615.9   120.58663
      2448 678.65  1879.6  4938.9  5529.9   119.31987
      2449 678.84  2000.9  5003.6  5696.2   123.06643
      2450 679.03  1791.2  4840.6  5491.8   121.35661
      2451 679.22  1843.2  4909.4  5561.5   121.26635
      2452 679.41  1845.6  4856.6  5587.7   124.28241
      2453 679.60  1842.8  4848.4  5494.7   121.50450
      2454 679.78  1922.6  4952.4  5600.8   121.40057
      2455 679.97  1838.3  4865.6  5533.6   122.06740
      2456 680.16  1928.8  4998.7  5582.4   119.01267
      2457 680.35  1919.8  4883.6  5618.0   124.77890
      2458 680.54  1963.6  4954.9  5652.0   123.30547
      2459 680.73  1850.5  4782.4  5511.9   124.88124
      2460 680.91  1858.7  4884.8  5606.9   123.86303
      2461 681.10  1905.8  4932.3  5572.5   121.15307
      2462 681.29  1891.9  4843.9  5598.7   125.57235
      2463 681.48  1868.6  4879.5  5530.3   121.61613
      2464 681.67  1936.6  4934.0  5607.3   122.46515
      2465 681.85  1841.1  4822.6  5526.2   123.60214
      2466 682.04  1848.9  4895.9  5535.7   120.99746
      2467 682.23  1878.8  4895.5  5595.5   123.20436
      2468 682.42  1829.2  4848.4  5536.5   122.79204
      2469 682.61  1788.3  4876.6  5531.2   121.19364
      2470 682.79  1909.9  4961.4  5712.6   124.61746
      2471 682.98  1908.7  4972.5  5657.3   122.35295
      2472 683.17  1892.3  4943.8  5671.6   123.85234
      2473 683.36  1817.4  4942.2  5634.8   122.16542
      2474 683.55  1885.8  4958.1  5677.0   123.39688
      2475 683.73  1907.9  5102.7  5756.0   120.44872
      2476 683.92  1851.0  4967.1  5713.8   123.96164
      2477 684.11  1890.3  5070.8  5786.3   122.49838
      2478 684.30  1864.1  5042.9  5785.9   123.37328
      2479 684.49  1903.8  5073.2  5741.7   121.09072
      2480 684.67  1827.2  5022.4  5751.1   122.80476
      2481 684.86  1828.0  5074.0  5724.1   120.02526
      2482 685.05  1885.4  5090.8  5776.1   121.37745
      2483 685.24  1895.2  5101.1  5876.4   124.18551
      2484 685.42  1986.9  5191.6  5896.1   121.98363
      2485 685.61  1834.6  5065.0  5821.6   123.41829
      2486 685.80  1865.7  4997.5  5779.0   124.95423
      2487 685.99  1992.3  5196.9  5871.9   121.06338
      2488 686.18  1880.0  5017.9  5796.6   124.81400
      2489 686.36  1844.4  4992.1  5706.1   122.68055
      2490 686.55  1909.1  5043.7  5802.3   124.19967
      2491 686.74  1923.0  5069.1  5746.2   121.52066
      2492 686.93  1864.5  5025.3  5649.1   119.73564
      2493 687.11  1932.5  5052.7  5738.8   121.98741
      2494 687.30  1754.7  4893.8  5499.2   119.28499
      2495 687.49  1797.7  4922.5  5602.4   121.75906
      2496 687.68  1920.6  4995.4  5652.4   121.36675
      2497 687.86  1914.0  4917.2  5564.7   121.56302
      2498 688.05  1883.7  4929.1  5583.6   121.49295
      2499 688.24  1873.1  4920.0  5593.8   122.11320
      2500 688.43  2007.0  5074.5  5734.7   121.52490
      2501 688.61  1859.6  4942.6  5646.2   122.82450
      2502 688.80  1851.8  4917.6  5559.0   120.92181
      2503 688.99  1816.1  4890.1  5512.7   120.25315
      2504 689.18  1970.6  5015.9  5731.9   123.51043
      2505 689.36  1914.9  5010.2  5679.8   121.63558
      2506 689.55  1819.0  4864.7  5541.8   122.22968
      2507 689.74  1799.8  4844.3  5476.7   120.77224
      2508 689.93  1910.8  5018.3  5627.0   119.58612
      2509 690.11  1888.2  4930.7  5610.6   122.34785
      2510 690.30  1868.2  4977.8  5625.8   120.83771
      2511 690.49  1834.6  4950.4  5599.1   120.82294
      2512 690.68  2017.7  5083.5  5750.7   121.76352
      2513 690.86  1823.9  4857.0  5577.4   123.75420
      2514 691.05  1758.0  4847.5  5554.1   122.86888
      2515 691.24  1792.8  4920.4  5561.1   120.48191
      2516 691.43  1871.0  4882.4  5553.3   122.27963
      2517 691.61  1978.7  5062.6  5698.3   120.61361
      2518 691.80  1829.7  4852.0  5567.2   123.66171
      2519 691.99  1867.7  4953.6  5584.0   120.42740
      2520 692.17  1912.8  4919.2  5613.9   123.10627
      2521 692.36  1882.5  4857.0  5595.5   124.82785
      2522 692.55  1936.6  5023.3  5610.2   119.01539
      2523 692.74  1850.1  4836.1  5470.9   121.26203
      2524 692.92  1833.3  4845.9  5426.3   119.26579
      2525 693.11  1850.1  4856.1  5497.2   121.32442
      2526 693.30  1961.5  4946.3  5643.4   123.35667
      2527 693.49  1774.0  4782.8  5452.5   122.25702
      2528 693.67  1846.9  4837.7  5416.5   119.35086
      2529 693.86  1918.5  4892.6  5536.5   121.64993
      2530 694.05  1857.5  4814.8  5484.1   122.63157
      2531 694.23  1823.9  4829.1  5488.1   121.92997
      2532 694.42  1987.8  4906.1  5570.9   122.77896
      2533 694.61  1839.5  4779.5  5429.6   122.10925
      2534 694.79  1806.3  4721.8  5407.0   123.50378
      2535 694.98  1770.3  4746.4  5347.2   120.18993
      2536 695.17  1965.6  4941.7  5582.8   121.53866
      2537 695.36  1788.3  4736.1  5375.9   121.70347
      2538 695.54  1912.8  4900.8  5593.8   123.19398
      2539 695.73  1766.6  4782.0  5485.7   123.33605
      2540 695.92  1896.4  4834.4  5578.7   125.33111
      2541 696.10  1914.4  4992.5  5649.1   121.33068
      2542 696.29  1797.3  4837.3  5478.7   121.09944
      2543 696.48  1909.1  4957.3  5572.1   120.16930
      2544 696.66  2029.9  5095.8  5711.0   120.06681
      2545 696.85  1855.5  4859.0  5568.0   123.60559
      2546 697.04  1794.4  4837.3  5553.3   123.52942
      2547 697.22  1812.9  4832.8  5481.2   121.47023
      2548 697.41  1958.7  4955.3  5650.3   123.19575
      2549 697.60  1823.1  4827.9  5475.9   121.56487
      2550 697.79  1853.8  4837.3  5491.0   121.91105
      2551 697.97  1798.5  4793.1  5461.9   122.33622
      2552 698.16  1919.4  4882.8  5640.1   125.55633
      2553 698.35  1857.9  4832.4  5489.8   122.10135
      2554 698.53  1839.1  4775.9  5472.6   123.72385
      2555 698.72  1860.4  4810.3  5492.2   123.11859
      2556 698.91  1987.8  4958.5  5668.0   123.87976
      2557 699.09  1875.5  4746.0  5377.1   121.98916
      2558 699.28  1828.0  4712.4  5430.4   124.89350
      2559 699.47  2021.8  4896.7  5516.8   121.57003
      2560 699.65  1796.9  4637.8  5315.7   123.86103
      2561 699.84  1916.5  4863.1  5518.9   122.25463
      2562 700.03  1870.6  4764.4  5344.8   120.05665
      2563 700.21  1835.8  4661.6  5354.6   124.52531
      2564 700.40  1796.5  4702.1  5310.4   120.93319
      2565 700.59  1875.1  4741.5  5403.0   123.07803
      2566 700.77  1858.7  4731.6  5295.2   119.61790
      2567 700.96  1842.8  4730.4  5388.2   122.78016
      2568 701.15  1976.3  4809.4  5464.4   123.11694
      2569 701.33  1938.2  4786.1  5461.1   123.70198
      2570 701.52  1812.0  4694.8  5305.9   121.19917
      2571 701.70  1835.8  4676.3  5295.2   121.78802
      2572 701.89  2010.7  4820.1  5457.4   122.68553
      2573 702.08  1857.1  4691.1  5312.4   121.92514
      2574 702.26  1734.6  4591.1  5206.8   121.55150
      2575 702.45  1793.2  4612.4  5219.9   121.54585
      2576 702.64  1792.8  4577.6  5201.4   122.40034
      2577 702.82  1860.0  4696.4  5290.3   120.93863
      2578 703.01  1891.5  4697.2  5349.3   123.24087
      2579 703.20  1857.1  4637.8  5325.9   124.74593
      2580 703.38  1981.2  4840.6  5457.4   121.57283
      2581 703.57  1818.6  4620.2  5261.2   122.88010
      2582 703.76  1882.5  4728.8  5329.6   121.11095
      2583 703.94  1907.5  4738.2  5382.5   122.76082
      2584 704.13  1848.9  4690.3  5250.6   119.72033
      2585 704.31  1822.7  4566.2  5272.3   125.73904
      2586 704.50  1948.0  4780.8  5450.5   123.64084
      2587 704.69  1949.3  4809.4  5395.6   120.49260
      2588 704.87  1848.1  4748.0  5361.6   121.15818
      2589 705.06  1857.1  4748.0  5343.6   120.60072
      2590 705.25  1967.7  4870.5  5534.8   122.88697
      2591 705.43  1798.9  4700.5  5384.5   123.57423
      2592 705.62  1863.7  4822.6  5410.7   119.87816
      2593 705.80  1916.9  4860.2  5508.6   122.02895
      2594 705.99  1845.2  4825.0  5514.8   123.14777
      2595 706.18  1852.2  4842.2  5524.2   122.80824
      2596 706.36  1891.9  4832.4  5524.2   123.52696
      2597 706.55  1841.5  4816.0  5493.9   122.78988
      2598 706.73  1896.8  4898.7  5510.3   120.37115
      2599 706.92  1812.0  4845.5  5484.1   121.05051
      2600 707.11  1898.5  4930.3  5625.4   122.92625
      2601 707.29  1955.0  4967.6  5572.9   120.09519
      2602 707.48  1896.4  4966.3  5608.6   120.92061
      2603 707.66  1853.8  4891.4  5617.6   123.90774
      2604 707.85  1842.4  4841.0  5468.1   120.91244
      2605 708.04  1884.5  4931.1  5483.2   118.12317
      2606 708.22  1846.9  4853.7  5527.1   122.39476
      2607 708.41  1864.9  4906.5  5543.0   120.92645
      2608 708.59  1941.9  5001.1  5599.6   119.56083
      2609 708.78  1901.7  4857.0  5495.1   121.59390
      2610 708.97  1703.9  4710.3  5362.4   121.68937
      2611 709.15  1841.9  4848.8  5547.1   123.22570
      2612 709.34  1880.0  4939.3  5523.0   119.07885
      2613 709.52  1882.1  4844.7  5467.7   121.02861
      2614 709.71  1842.8  4789.0  5449.2   122.41067
      2615 709.90  1801.0  4715.7  5335.8   121.27600
      2616 710.08  1977.1  4868.8  5553.7   123.68273
      2617 710.27  1741.6  4729.2  5323.1   119.87936
      2618 710.45  1895.6  4787.3  5509.4   124.97168
      2619 710.64  1832.9  4728.4  5377.6   122.42184
      2620 710.82  1903.4  4827.1  5451.7   121.36455
      2621 711.01  1838.7  4761.9  5412.0   122.23622
      2622 711.20  1866.9  4773.4  5395.2   121.39232
      2623 711.38  1785.0  4702.1  5322.3   121.25808
      2624 711.57  1874.7  4808.2  5498.0   123.51299
      2625 711.75  1782.6  4656.3  5369.4   124.81468
      2626 711.94  1889.0  4834.4  5468.1   121.51302
      2627 712.12  1862.4  4780.4  5458.7   123.24536
      2628 712.31  1887.8  4795.9  5388.6   120.38028
      2629 712.50  1910.3  4863.5  5539.8   122.89874
      2630 712.68  1842.4  4761.1  5420.6   122.59332
      2631 712.87  1892.7  4829.9  5445.5   120.95940
      2632 713.05  1850.5  4768.1  5407.9   121.92895
      2633 713.24  1879.2  4762.8  5425.1   122.96875
      2634 713.42  1836.2  4741.0  5432.9   123.81557
      2635 713.61  1852.6  4736.1  5383.7   122.45736
      2636 713.79  1918.9  4862.7  5497.6   121.56671
      2637 713.98  1814.1  4712.4  5323.5   121.08537
      2638 714.17  1859.6  4793.1  5370.6   119.68723
      2639 714.35  1853.8  4683.3  5367.7   124.18934
      2640 714.54  1826.8  4700.5  5381.2   123.68872
      2641 714.72  1825.6  4688.2  5286.2   120.88997
      2642 714.91  1791.2  4694.8  5391.1   123.98079
      2643 715.09  1879.2  4756.2  5321.4   119.64691
      2644 715.28  1788.7  4614.9  5231.3   121.81157
      2645 715.46  1999.6  4810.3  5505.4   124.73042
      2646 715.65  1799.3  4666.9  5199.8   118.58308
      2647 715.83  1928.0  4786.5  5369.0   120.37540
      2648 716.02  1951.3  4799.6  5415.6   121.62784
      2649 716.21  1930.0  4700.5  5347.7   123.35896
      2650 716.39  1868.2  4680.4  5264.5   120.76898
      2651 716.58  1811.6  4592.0  5228.9   122.90806
      2652 716.76  1848.9  4616.1  5282.9   124.09707
      2653 716.95  1960.7  4718.1  5349.3   122.89067
      2654 717.13  1819.4  4631.3  5201.4   120.27674
      2655 717.32  1815.3  4585.8  5192.8   121.91012
      2656 717.50  1991.0  4767.7  5391.1   122.45170
      2657 717.69  1920.2  4683.3  5315.7   122.88765
      2658 717.87  1783.0  4601.8  5184.6   120.67713
      2659 718.06  1879.6  4649.3  5244.4   121.48770
      2660 718.24  1817.4  4595.6  5168.3   120.61034
      2661 718.43  1921.0  4667.7  5300.6   123.03910
      2662 718.61  1951.3  4718.1  5307.9   121.31755
      2663 718.80  1913.2  4680.4  5296.5   122.26169
      2664 718.98  1858.3  4669.8  5278.8   121.66376
      2665 719.17  1890.7  4607.9  5197.3   121.69127
      2666 719.35  1879.6  4614.5  5241.6   122.92946
      2667 719.54  1853.8  4584.6  5164.2   121.22393
      2668 719.72  1830.1  4576.0  5220.7   123.47854
      2669 719.91  1889.0  4641.9  5255.9   122.30322
      2670 720.09  1851.8  4506.4  5141.2   123.91609
      2671 720.28  1873.5  4651.8  5243.2   121.28854
      2672 720.46  1869.4  4636.6  5179.3   119.61221
      2673 720.65  2017.7  4727.9  5342.7   122.68399
      2674 720.83  1872.7  4615.7  5152.3   119.56101
      2675 721.02  1877.2  4577.6  5180.5   122.32671
      2676 721.20  1959.9  4689.0  5252.2   120.63637
      2677 721.39  1853.0  4551.4  5157.6   122.46506
      2678 721.57  1812.5  4474.0  5119.1   124.23821
      2679 721.76  1904.6  4585.0  5168.3   121.76041
      2680 721.94  1873.5  4564.9  5160.1   122.11233
      2681 722.13  1844.4  4515.0  5122.4   122.74538
      2682 722.31  1851.8  4596.1  5171.9   120.98508
      2683 722.50  1932.9  4612.8  5181.4   121.21351
      2684 722.68  1847.3  4539.1  5103.5   120.96774
      2685 722.87  1952.9  4632.9  5234.6   122.45147
      2686 723.05  1907.1  4641.5  5190.8   120.08691
      2687 723.24  2100.0  4786.5  5391.1   122.50341
      2688 723.42  1841.5  4542.8  5110.9   121.03111
      2689 723.61  1968.1  4729.6  5360.4   122.84187
      2690 723.79  1823.9  4464.6  5131.0   125.23654
      2691 723.98  1827.6  4605.9  5192.4   121.11159
      2692 724.16  2005.8  4762.3  5279.3   118.75185
      2693 724.34  1832.1  4513.7  5161.7   124.16373
      2694 724.53  1872.3  4682.5  5194.1   118.20432
      2695 724.71  1951.7  4728.8  5287.4   120.11800
      2696 724.90  1846.9  4577.2  5191.2   122.48725
      2697 725.08  1913.2  4700.5  5319.4   122.20425
      2698 725.27  1800.6  4578.4  5230.9   123.48865
      2699 725.45  1855.5  4666.5  5239.9   120.39923
      2700 725.64  1834.2  4564.1  5139.6   121.08026
      2701 725.82  1966.5  4755.8  5408.7   123.40674
      2702 726.01  1783.8  4543.6  5181.0   123.09292
      2703 726.19  1827.6  4635.4  5242.8   121.63386
      2704 726.38  1839.1  4655.4  5273.1   121.93134
      2705 726.56  1806.3  4612.4  5230.9   122.04059
      2706 726.74  1838.7  4624.3  5313.7   124.74639
      2707 726.93  1819.4  4639.5  5255.5   121.84459
      2708 727.11  2111.0  4841.0  5581.5   127.12676
      2709 727.30  1861.6  4678.0  5316.9   122.68761
      2710 727.48  1863.7  4647.3  5337.8   124.80871
      2711 727.67  1813.7  4688.2  5288.3   120.87490
      2712 727.85  1927.5  4740.2  5415.2   123.99886
      2713 728.04  2011.9  4909.4  5466.4   119.22532
      2714 728.22  1932.5  4831.2  5487.3   122.63670
      2715 728.40  1845.2  4703.4  5375.9   123.53110
      2716 728.59  1916.1  4843.4  5409.5   119.33680
      2717 728.77  1893.6  4741.0  5401.3   123.18757
      2718 728.96  1800.2  4701.3  5358.3   122.64576
      2719 729.14  1798.5  4751.7  5425.5   122.81554
      2720 729.33  2078.7  5019.2  5641.7   121.17284
      2721 729.51  1909.9  4815.6  5538.5   124.88018
      2722 729.69  1908.3  4813.5  5503.3   123.74172
      2723 729.88  1820.2  4808.6  5407.5   120.03838
      2724 730.06  1897.2  4877.0  5491.0   120.60481
      2725 730.25  1897.2  4880.7  5544.7   122.25427
      2726 730.43  1826.4  4838.5  5520.1   122.62714
      2727 730.61  1835.4  4838.1  5482.4   121.45683
      2728 730.80  1851.4  4881.1  5533.2   121.52223
      2729 730.98  1970.6  4993.4  5693.4   123.15720
      2730 731.17  1832.1  4886.9  5622.9   124.09493
      2731 731.35  1790.3  4885.2  5594.6   122.92216
      2732 731.54  1871.0  4906.1  5561.9   121.60595
      2733 731.72  1914.9  5069.5  5656.9   118.61853
      2734 731.90  1776.0  4864.3  5498.4   120.53054
      2735 732.09  1862.0  4910.2  5592.2   122.37300
      2736 732.27  1962.0  5022.0  5745.0   123.62468
      2737 732.46  1943.1  5083.9  5759.3   121.50495
      2738 732.64  1871.4  4943.8  5645.8   122.85026
      2739 732.82  1826.0  4919.6  5636.0   123.15634
      2740 733.01  1905.0  4990.5  5675.7   122.20897
      2741 733.19  1927.5  5028.6  5665.5   120.53892
      2742 733.38  1808.8  4851.2  5611.8   125.00002
      2743 733.56  1915.7  5031.9  5785.9   124.19821
      2744 733.74  1905.4  5078.6  5749.5   121.14365
      2745 733.93  1925.9  5065.9  5747.0   121.69318
      2746 734.11  1879.2  4991.3  5724.9   123.57201
      2747 734.29  1856.7  4993.4  5717.9   123.10005
      2748 734.48  1932.5  5022.8  5679.4   121.24586
      2749 734.66  1881.3  5004.0  5697.0   122.19305
      2750 734.85  1772.3  4946.3  5612.3   120.98337
      2751 735.03  1859.6  4975.3  5624.1   120.82295
      2752 735.21  1865.3  4980.7  5625.8   120.70733
      2753 735.40  1976.7  5110.9  5836.7   123.15734
      2754 735.58  1876.3  4950.8  5683.9   123.84756
      2755 735.77  1852.2  4922.9  5582.8   121.48861
      2756 735.95  1937.4  4983.9  5683.9   122.97658
      2757 736.13  1866.1  4983.5  5636.4   120.94339
      2758 736.32  1871.0  4919.2  5649.9   123.97204
      2759 736.50  1947.2  4972.5  5649.9   122.39372
      2760 736.68  1835.4  4952.8  5536.5   118.72290
      2761 736.87  1948.0  5031.0  5746.6   123.20977
      2762 737.05  1862.4  4893.4  5520.5   120.68919
      2763 737.23  1881.3  4896.3  5579.9   122.67355
      2764 737.42  1968.1  4952.4  5600.4   121.71286
      2765 737.60  1890.3  4893.4  5524.6   121.01745
      2766 737.79  1881.7  4879.9  5619.6   124.67212
      2767 737.97  1837.8  4790.6  5506.6   124.24748
      2768 738.15  1926.3  4895.1  5561.1   122.43376
      2769 738.34  1880.0  4847.5  5461.1   120.67631
      2770 738.52  1834.6  4737.8  5415.6   123.34933
      2771 738.70  1919.8  4863.5  5508.6   121.91456
      2772 738.89  1922.2  4863.5  5527.1   122.55953
      2773 739.07  1861.2  4762.3  5464.0   124.18466
      2774 739.25  1920.6  4842.6  5469.7   121.46061
      2775 739.44  1914.9  4748.8  5456.2   124.96024
      2776 739.62  1957.9  4797.2  5527.1   125.70686
      2777 739.80  1835.4  4688.6  5287.0   120.97328
      2778 739.99  1765.8  4619.4  5189.6   119.97993
      2779 740.17  1827.6  4676.7  5350.1   123.63430
      2780 740.35  1997.2  4837.7  5521.7   124.08073
      2781 740.54  1945.2  4791.4  5421.0   122.11827
      2782 740.72  1852.6  4681.2  5316.1   122.44424
      2783 740.90  1838.7  4641.5  5233.0   121.10188
      2784 741.09  1787.1  4551.0  5179.7   122.74751
      2785 741.27  1861.6  4597.3  5223.1   122.87771
      2786 741.45  1871.0  4642.3  5208.4   120.42563
      2787 741.64  1884.5  4617.4  5251.4   123.20144
      2788 741.82  1877.2  4662.0  5244.0   120.90014
      2789 742.00  1875.1  4588.3  5132.6   120.06340
      2790 742.19  1896.8  4586.2  5187.5   122.35762
      2791 742.37  1968.5  4622.3  5284.6   124.95760
      2792 742.55  1880.0  4598.9  5143.3   120.02108
      2793 742.74  1871.8  4575.6  5217.8   123.75397
      2794 742.92  1866.1  4544.4  5170.3   123.36747
      2795 743.10  1824.3  4556.3  5182.6   122.92355
      2796 743.29  1965.2  4662.0  5275.6   122.75215
      2797 743.47  1971.4  4565.7  5246.1   126.22355
      2798 743.65  1785.0  4474.8  5029.4   120.61825
      2799 743.83  1973.4  4619.8  5237.1   123.32457
      2800 744.02  1853.8  4569.0  5111.7   119.98794
      2801 744.20  1839.9  4505.1  5063.8   120.96204
      2802 744.38  1867.7  4492.4  5087.6   122.67480
      2803 744.57  1760.8  4422.0  4967.6   120.50178
      2804 744.75  1815.3  4455.6  5043.7   122.27736
      2805 744.93  1883.3  4475.6  5076.5   123.17901
      2806 745.12  1847.3  4470.7  5056.0   122.31068
      2807 745.30  1876.3  4490.4  5137.5   124.75713
      2808 745.48  2049.2  4723.8  5296.9   121.42417
      2809 745.66  1810.8  4468.3  5022.0   120.83848
      2810 745.85  1778.0  4382.2  4994.2   123.49794
      2811 746.03  1818.6  4482.2  5072.4   122.15902
      2812 746.21  1930.8  4607.1  5239.1   123.61493
      2813 746.40  1887.0  4587.9  5087.6   118.50165
      2814 746.58  1891.1  4571.1  5121.2   120.52577
      2815 746.76  1812.5  4467.4  5091.2   123.49582
      2816 746.94  1959.9  4622.7  5206.8   121.93510
      2817 747.13  1916.1  4556.7  5196.5   124.22835
      2818 747.31  1789.9  4515.8  5083.9   120.84149
      2819 747.49  1891.9  4630.0  5200.2   120.82272
      2820 747.68  1905.8  4568.6  5216.6   124.33471
      2821 747.86  1933.7  4667.3  5271.9   122.11566
      2822 748.04  1907.9  4585.0  5208.4   123.28643
      2823 748.22  1826.4  4605.5  5184.6   120.84011
      2824 748.41  1955.8  4703.0  5261.6   120.33697
      2825 748.59  1954.6  4700.5  5310.8   122.22554
      2826 748.77  1818.6  4573.9  5152.7   121.00491
      2827 748.95  1901.3  4623.1  5267.0   123.65687
      2828 749.14  1850.5  4610.8  5235.4   122.62946
      2829 749.32  1897.6  4687.0  5347.7   123.68577
      2830 749.50  1846.4  4615.7  5241.6   122.60020
      2831 749.68  1758.8  4499.8  5176.4   124.68620
      2832 749.87  1878.4  4691.5  5291.5   121.33081
      2833 750.05  1895.2  4678.0  5314.1   122.85840
      2834 750.23  1796.1  4678.0  5259.2   120.16773
      2835 750.42  1886.6  4717.3  5335.8   121.84924
      2836 750.60  1880.4  4707.9  5359.5   123.04792
      2837 750.78  1868.2  4682.1  5310.8   122.34354
      2838 750.96  1907.9  4684.5  5354.2   124.11861
      2839 751.15  1917.7  4704.2  5368.5   123.84242
      2840 751.33  1796.5  4579.3  5236.2   123.60905
      2841 751.51  1946.0  4747.2  5372.6   122.32780
      2842 751.69  1946.4  4688.2  5389.4   125.57517
      2843 751.87  1875.9  4656.3  5289.1   122.76074
      2844 752.06  1794.0  4644.0  5240.3   120.92554
      2845 752.24  1898.9  4698.0  5263.3   120.19318
      2846 752.42  1828.0  4625.1  5296.5   124.00058
      2847 752.60  1773.5  4674.3  5202.7   118.21520
      2848 752.79  1957.4  4846.3  5433.7   120.33180
      2849 752.97  1912.8  4753.3  5334.5   120.46145
      2850 753.15  1784.2  4664.9  5247.3   120.21899
      2851 753.33  1832.9  4691.5  5355.8   123.24115
      2852 753.52  1881.7  4725.9  5361.2   122.33583
      2853 753.70  1907.9  4761.5  5416.5   122.95108
      2854 753.88  1814.1  4691.9  5387.0   124.15317
      2855 754.06  1914.0  4799.6  5492.2   124.00284
      2856 754.24  1859.1  4810.7  5469.3   122.31471
      2857 754.43  1957.9  4942.2  5609.8   122.37168
      2858 754.61  1812.9  4823.4  5506.6   122.69387
      2859 754.79  1857.5  4885.6  5572.5   122.68363
      2860 754.97  1843.6  4895.5  5543.0   121.21864
      2861 755.16  1939.4  5036.4  5698.3   121.37281
      2862 755.34  1869.8  4997.5  5676.6   121.71296
      2863 755.52  1926.7  5063.0  5733.5   121.37913
      2864 755.70  1903.4  4992.9  5746.6   124.39346
      2865 755.88  1833.3  4989.3  5705.2   122.68658
      2866 756.07  1821.9  5044.1  5754.4   122.04145
      2867 756.25  1847.3  5086.3  5818.3   122.59737
      2868 756.43  1923.9  5167.4  5909.2   122.86904
      2869 756.61  1798.1  5094.1  5833.0   122.41833
      2870 756.79  1958.7  5251.4  5955.1   121.37085
      2871 756.98  1824.7  5094.1  5860.1   123.42774
      2872 757.16  1928.4  5266.1  6008.7   122.24811
      2873 757.34  1807.9  5156.4  5974.3   124.42811
      2874 757.52  1799.3  5192.4  6017.3   124.31193
      2875 757.70  1835.8  5238.7  6118.9   125.86663
      2876 757.89  1916.9  5434.9  6085.3   118.48877
      2877 758.07  2090.6  5474.6  6318.0   124.92134
      2878 758.25  1931.2  5384.9  6164.4   122.56879
      2879 758.43  1822.3  5339.1  6118.5   122.16396
      2880 758.61  1913.2  5377.1  6121.4   121.48516
      2881 758.80  1938.2  5403.0  6199.6   122.99327
      2882 758.98  1901.7  5402.1  6112.8   120.30189
      2883 759.16  1889.0  5346.0  6087.8   121.45733
      2884 759.34  1951.7  5405.0  6187.3   122.65449
      2885 759.52  1864.5  5381.2  6207.8   123.50337
      2886 759.70  1873.5  5411.1  6078.8   118.87230
      2887 759.89  1830.5  5345.6  6073.5   120.70612
      2888 760.07  1844.0  5324.7  6082.1   121.75806
      2889 760.25  1842.8  5385.7  6135.3   121.15608
      2890 760.43  1787.9  5280.9  6064.0   122.42026
      2891 760.61  1842.8  5307.5  6022.3   120.62891
      2892 760.79  1841.5  5389.0  6112.8   120.40180
      2893 760.98  1888.2  5307.5  6125.1   123.90991
      2894 761.16  1869.0  5367.7  6128.8   121.75134
      2895 761.34  1840.7  5287.0  6149.6   125.02973
      2896 761.52  1805.9  5257.1  5928.5   119.45169
      2897 761.70  1905.4  5428.8  6138.2   120.13484
      2898 761.88  1830.9  5286.6  6069.8   122.66207
      2899 762.07  1843.2  5347.7  6026.8   119.37820
      2900 762.25  1991.9  5439.8  6243.0   123.29530
      2901 762.43  1903.8  5369.8  6075.5   120.36162
      2902 762.61  1897.6  5345.2  6103.4   121.99121
      2903 762.79  1779.3  5236.2  6057.9   123.76780
      2904 762.97  1877.2  5422.6  6164.0   120.91033
      2905 763.15  1853.4  5310.0  6150.5   124.31570
      2906 763.34  1803.4  5326.4  6102.5   122.03232
      2907 763.52  1814.5  5273.1  6113.6   124.30127
      2908 763.70  1946.4  5439.4  6219.3   122.32647
      2909 763.88  1941.1  5496.7  6232.4   120.68888
      2910 764.06  1957.9  5498.4  6264.3   121.63352
      2911 764.24  1827.6  5387.8  6137.4   121.05385
      2912 764.42  1873.1  5443.9  6176.7   120.52075
      2913 764.61  1832.1  5410.3  6101.7   119.32234
      2914 764.79  1749.8  5267.4  6066.1   122.70607
      2915 764.97  1895.2  5414.8  6302.8   125.22986
      2916 765.15  1847.3  5263.3  6121.0   125.10790
      2917 765.33  1966.0  5482.0  6173.8   119.67614
      2918 765.51  1864.1  5369.8  6184.0   123.22700
      2919 765.69  2006.6  5449.2  6239.3   122.95065
      2920 765.87  1906.2  5399.7  6169.3   122.03073
      2921 766.06  1914.9  5397.2  6166.4   122.08892
      2922 766.24  1805.5  5256.3  6028.0   122.36200
      2923 766.42  1796.5  5234.2  6025.9   123.03107
      2924 766.60  1896.8  5270.2  6091.9   124.35648
      2925 766.78  1980.0  5417.3  6082.9   119.36368
      2926 766.96  1921.4  5275.6  6066.5   123.58043
      2927 767.14  1839.5  5267.4  5979.2   120.76712
      2928 767.32  1921.4  5314.1  6042.7   121.47775
      2929 767.50  1805.5  5154.7  5897.7   122.18417
      2930 767.69  1923.9  5275.6  6061.2   123.43881
      2931 767.87  1868.6  5268.2  6006.3   121.71085
      2932 768.05  1970.6  5394.4  6166.0   122.53856
      2933 768.23  1869.8  5206.3  6022.3   124.45372
      2934 768.41  1913.2  5307.1  6158.7   125.09053
      2935 768.59  1807.1  5215.4  5939.5   121.24746
      2936 768.77  1887.0  5311.2  6077.1   122.36841
      2937 768.95  1874.3  5330.0  6075.5   121.57166
      2938 769.13  1851.0  5246.5  5933.4   120.22920
      2939 769.32  1849.3  5297.3  6083.3   122.79638
      2940 769.50  1927.5  5346.4  6032.5   120.06710
      2941 769.68  1911.2  5278.4  6115.2   124.85098
      2942 769.86  1950.1  5360.4  6105.4   121.84723
      2943 770.04  1805.9  5186.7  6034.1   125.06662
      2944 770.22  1820.6  5239.1  5898.1   119.27868
      2945 770.40  1873.1  5261.2  5980.5   121.22822
      2946 770.58  1837.0  5183.0  5935.0   122.47521
      2947 770.76  1882.1  5207.6  5903.9   120.93853
      2948 770.94  1973.0  5241.6  5965.7   122.15540
      2949 771.12  1803.4  5125.2  5862.5   122.19479
      2950 771.30  1883.3  5141.2  5865.0   122.21523
      2951 771.49  1904.2  5157.6  5842.9   121.06259
      2952 771.67  1892.7  5111.3  5756.4   120.04330
      2953 771.85  1887.8  5008.9  5781.8   124.76377
      2954 772.03  1896.8  5032.3  5640.9   119.41214
      2955 772.21  1890.3  5055.6  5690.1   120.04397
      2956 772.39  1823.9  4895.5  5611.0   123.29647
      2957 772.57  1941.1  4990.9  5654.9   121.77006
      2958 772.75  1798.1  4814.8  5452.9   121.15410
      2959 772.93  1932.9  4879.1  5542.6   122.52190
      2960 773.11  1947.2  4854.5  5550.0   123.92223
      2961 773.29  1907.5  4802.1  5518.0   124.73469
      2962 773.47  1907.1  4837.7  5428.8   120.16772
      2963 773.65  1894.8  4759.5  5386.6   121.89020
      2964 773.83  1957.4  4803.7  5414.8   121.47068
      2965 774.01  1839.9  4645.2  5285.0   122.80623
      2966 774.19  1920.6  4677.6  5338.6   123.97859
      2967 774.38  1852.6  4637.8  5248.1   121.91178
      2968 774.56  1971.0  4708.3  5303.0   121.72677
      2969 774.74  1921.8  4659.1  5278.0   122.60960
      2970 774.92  1862.8  4564.5  5239.5   124.98482
      2971 775.10  1886.6  4567.4  5189.6   123.20856
      2972 775.28  1848.1  4496.9  5074.0   121.78751
      2973 775.46  1977.5  4578.0  5219.5   124.66532
      2974 775.64  1872.7  4503.1  5135.9   124.05791
      2975 775.82  1820.2  4419.9  4964.3   120.93903
      2976 776.00  1798.1  4379.0  5016.7   124.71035
      2977 776.18  1857.1  4424.8  5005.6   122.61924
      2978 776.36  1892.3  4458.4  5096.6   124.86831
      2979 776.54  2001.3  4644.8  5238.3   122.45118
      2980 776.72  1865.3  4508.0  5058.5   120.83075
      2981 776.90  1879.6  4548.9  5072.4   119.61026
      2982 777.08  1896.8  4502.3  5159.2   125.21619
      2983 777.26  1896.4  4506.4  5087.2   122.25362
      2984 777.44  1840.7  4462.5  5026.1   121.49664
      2985 777.62  1966.9  4584.6  5108.5   120.01250
      2986 777.80  1963.6  4620.6  5240.3   123.32355
      2987 777.98  1875.5  4513.3  5148.2   124.06831
      2988 778.16  1817.8  4393.7  5064.2   126.02958
      2989 778.34  1894.0  4563.7  5194.9   123.64222
      2990 778.52  1934.5  4628.4  5175.6   120.31324
      2991 778.70  1888.6  4507.6  5098.2   122.55239
      2992 778.88  1842.8  4504.7  5135.9   123.71134
      2993 779.06  1794.8  4417.9  4988.0   121.73644
      2994 779.24  1906.2  4658.7  5199.4   119.64287
      2995 779.42  1930.0  4574.8  5128.1   120.92302
      2996 779.60  1991.0  4612.0  5252.2   124.42568
      2997 779.78  1879.6  4546.1  5172.8   123.50229
      2998 779.96  1881.3  4444.5  5060.5   124.03323
      2999 780.14  1880.0  4528.5  5091.2   121.24962
      3000 780.32  1893.1  4458.8  5045.8   122.87672
      3001 780.50  1914.0  4591.5  5127.3   120.00920
      3002 780.68  1826.0  4453.9  5048.2   122.61536
      3003 780.86  1900.9  4486.7  5099.4   123.69713
      3004 781.04  1905.0  4451.1  5032.7   122.84427
      3005 781.22  1836.2  4428.1  5021.2   122.88244
      3006 781.40  1903.4  4494.9  5017.9   120.18333
      3007 781.58  1851.8  4420.7  4976.2   121.61989
      3008 781.76  1928.0  4480.5  4981.9   119.64058
      3009 781.94  1897.6  4411.3  4990.9   123.05686
      3010 782.12  1901.3  4396.6  4972.9   123.09589
      3011 782.30  1975.9  4490.8  5023.7   121.18890
      3012 782.48  1896.4  4367.9  4963.0   124.08018
      3013 782.66  1912.8  4373.6  4946.7   123.28564
      3014 782.84  1925.9  4319.2  4880.3   123.44689
      3015 783.02  1910.8  4318.8  4884.8   123.50742
      3016 783.20  1896.4  4310.6  4881.9   123.66812
      3017 783.38  1927.5  4350.7  4881.1   121.88979
      3018 783.56  1771.5  4146.7  4650.1   121.19332
      3019 783.74  1811.2  4169.7  4688.6   122.00421
      3020 783.92  1856.7  4184.0  4746.0   124.14644
      3021 784.10  1879.6  4249.1  4783.6   122.55830
      3022 784.28  1936.2  4272.1  4779.5   121.72538
      3023 784.46  1848.9  4122.2  4661.6   123.72968
      3024 784.64  1914.0  4180.3  4670.6   121.63385
      3025 784.82  1899.3  4156.1  4708.7   124.48276
      3026 785.00  1839.9  4076.3  4588.3   122.89376
      3027 785.18  1835.4  4104.9  4575.6   120.73632
      3028 785.36  1973.8  4204.1  4743.5   124.18733
      3029 785.54  1789.5  4059.1  4576.8   122.81179
      3030 785.72  1902.2  4124.6  4632.5   122.85292
      3031 785.90  1891.1  4167.2  4707.5   123.73582
      3032 786.08  1827.2  4046.4  4615.3   125.63673
      3033 786.26  1813.7  4104.9  4609.2   122.00568
      3034 786.43  1922.6  4157.8  4620.2   120.68905
      3035 786.61  1934.1  4204.9  4718.5   122.61907
      3036 786.79  2022.6  4257.7  4733.7   121.29375
      3037 786.97  2014.8  4249.1  4747.6   122.30978
      3038 787.15  1865.3  4084.5  4616.9   123.99410
      3039 787.33  1902.6  4112.7  4614.1   122.68348
      3040 787.51  1845.6  4050.5  4575.6   123.81570
      3041 787.69  1953.4  4164.7  4689.0   123.70810
      3042 787.87  1791.6  4015.7  4494.5   121.52854
      3043 788.05  1921.8  4114.0  4598.1   122.08516
      3044 788.23  2073.0  4221.7  4786.5   126.28670
      3045 788.41  1862.0  4000.5  4557.6   126.04867
      3046 788.59  1947.6  4078.7  4613.3   125.08164
      3047 788.77  1976.7  4098.4  4616.5   124.42084
      3048 788.95  1882.1  4030.8  4548.1   124.07549
      3049 789.13  1888.2  4021.8  4499.0   122.36515
      3050 789.30  1929.6  4017.3  4424.4   119.50171
      3051 789.48  1791.6  3905.1  4398.2   123.33334
      3052 789.66  1899.7  3939.1  4460.5   125.56739
      3053 789.84  1908.3  3984.1  4451.5   122.51384
      3054 790.02  1862.8  3924.3  4393.7   122.76969
      3055 790.20  1740.8  3776.9  4321.6   126.75519
      3056 790.38  1937.0  3953.4  4419.1   123.09567
      3057 790.56  1859.6  3853.5  4326.1   123.70583
      3058 790.74  1756.7  3733.4  4196.7   123.43559
      3059 790.92  1884.1  3908.3  4342.5   121.44878
      3060 791.10  1925.9  3938.7  4393.3   122.58852
      3061 791.28  1963.2  3983.3  4375.3   119.40389
      3062 791.45  2014.4  4043.9  4424.0   118.72856
      3063 791.63  1799.3  3799.0  4248.3   122.47028
      3064 791.81  2071.3  3982.1  4409.3   122.35803
      3065 791.99  1966.9  3930.1  4396.2   123.74297
      3066 792.17  1829.2  3803.5  4251.2   122.67635
      3067 792.35  1808.4  3828.9  4291.7   122.90696
      3068 792.53  1738.3  3848.5  4224.6   117.81832
      3069 792.71  1956.6  3983.3  4442.9   122.67582
      3070 792.89  1838.3  3872.7  4318.3   121.90457
      3071 793.07  2044.3  4035.3  4463.8   121.51819
      3072 793.24  1890.3  3871.9  4336.0   123.41873
      3073 793.42  1991.0  3988.2  4511.7   126.21002
      3074 793.60  1801.8  3772.4  4289.7   126.25235
      3075 793.78  1875.1  3883.4  4335.1   122.49644
      3076 793.96  1839.5  3851.4  4308.9   122.74022
      3077 794.14  1864.5  3906.7  4393.7   123.84678
      3078 794.32  1911.6  3890.3  4311.4   121.27927
      3079 794.50  1944.3  3935.0  4363.0   121.50209
      3080 794.67  1899.7  3855.1  4299.5   122.72732
      3081 794.85  1881.7  3868.6  4264.7   119.93403
      3082 795.03  1853.0  3805.5  4262.2   123.38996
      3083 795.21  1840.7  3760.5  4240.9   125.02670
      3084 795.39  1869.0  3846.5  4223.3   119.05549
      3085 795.57  1905.0  3808.0  4247.9   123.11668
      3086 795.75  1884.1  3796.9  4213.5   121.77731
      3087 795.93  1868.2  3794.1  4145.5   118.24753
      3088 796.10  2027.9  3897.7  4304.4   121.75249
      3089 796.28  1842.8  3715.8  4109.0   120.99279
      3090 796.46  1794.8  3640.9  4052.1   122.27645
      3091 796.64  1945.6  3827.2  4220.9   120.91861
      3092 796.82  1986.5  3735.9  4144.7   123.36686
      3093 797.00  1953.8  3679.4  4108.6   124.87536
      3094 797.18  1802.6  3587.6  4023.8   124.43779
      3095 797.35  1853.4  3675.3  4009.9   118.36780
      3096 797.53  1900.9  3647.4  4029.6   121.88087
      3097 797.71  1907.9  3678.6  4091.0   123.29402
      3098 797.89  1941.1  3686.8  4108.2   124.14360
      3099 798.07  1825.6  3524.6  3914.9   122.97494
      3100 798.25  1887.4  3623.7  4032.4   123.54325
      3101 798.43  1966.5  3731.0  4071.8   119.31292
      3102 798.60  1824.7  3570.4  3987.0   123.86204
      3103 798.78  1908.7  3605.7  4030.8   125.05429
      3104 798.96  2018.9  3722.0  4130.8   124.00196
      3105 799.14  1842.8  3560.2  3941.5   122.20368
      3106 799.32  1764.1  3486.9  3876.8   122.63431
      3107 799.50  1887.8  3599.9  4033.3   125.31107
      3108 799.67  1839.1  3516.4  3902.2   123.00371
      3109 799.85  1871.8  3572.9  3987.8   124.39203
      3110 800.03  1855.0  3550.4  3897.7   120.48801
      3111 800.21  1898.9  3590.9  3953.4   121.42343
      3112 800.39  1929.6  3583.1  3941.5   121.67454
      3113 800.57  1876.8  3615.9  3978.4   120.84312
      3114 800.74  1828.0  3479.1  3896.9   125.30392
      3115 800.92  1835.0  3529.5  3905.5   122.18999
      3116 801.10  1853.8  3514.3  3915.7   124.17366
      3117 801.28  1800.6  3423.0  3797.8   123.10021
      3118 801.46  1873.9  3491.0  3894.4   124.94928
      3119 801.64  1912.8  3552.4  3950.1   124.25677
      3120 801.81  1974.7  3612.6  4053.7   126.93169
      3121 801.99  1843.2  3466.8  3858.0   124.09182
      3122 802.17  1871.8  3506.9  3907.5   124.49894
      3123 802.35  1846.9  3455.3  3830.9   123.35112
      3124 802.53  1854.2  3449.2  3753.1   119.05498
      3125 802.70  1693.7  3308.3  3662.6   121.94313
      3126 802.88  1851.8  3436.5  3800.2   122.95164
      3127 803.06  1780.1  3372.2  3710.1   121.22460
      3128 803.24  1913.2  3496.7  3876.4   123.97824
      3129 803.42  1907.9  3544.6  3899.7   121.69672
      3130 803.59  1777.2  3382.8  3766.6   123.90303
      3131 803.77  1833.3  3403.7  3797.8   125.09128
      3132 803.95  2031.2  3583.1  4019.8   128.13407
      3133 804.13  1922.6  3581.5  3927.2   120.83949
      3134 804.31  1819.4  3463.1  3851.0   123.59828
      3135 804.48  1925.9  3526.6  3912.0   124.07884
      3136 804.66  1928.8  3542.6  3920.6   123.42640
      3137 804.84  1819.4  3438.9  3806.4   122.68591
      3138 805.02  1887.0  3510.2  3883.8   123.01290
      3139 805.20  1870.6  3531.5  3943.2   124.78424
      3140 805.37  1840.7  3486.5  3805.1   119.36287
      3141 805.55  1908.3  3542.2  3888.3   121.18320
      3142 805.73  1864.5  3449.2  3853.9   125.53634
      3143 805.91  1910.8  3554.0  3948.9   124.02790
      3144 806.08  1905.4  3519.2  3901.0   123.65479
      3145 806.26  1884.1  3551.2  3888.7   120.24568
      3146 806.44  1873.1  3506.1  3871.1   122.34769
      3147 806.62  1760.0  3457.0  3753.5   117.47527
      3148 806.80  1842.8  3498.8  3873.1   122.60693
      3149 806.97  1867.3  3466.0  3832.6   122.93112
      3150 807.15  1882.9  3486.5  3856.7   123.09069
      3151 807.33  1992.3  3490.1  3940.7   130.07930
      3152 807.51  1955.8  3484.8  3844.9   123.54674
      3153 807.68  1743.2  3339.8  3697.8   122.42176
      3154 807.86  1920.2  3416.4  3782.2   124.44573
      3155 808.04  1808.8  3368.9  3774.8   126.01729
      3156 808.22  1903.4  3410.3  3786.3   124.95242
      3157 808.39  2189.7  4000.5  4383.9   121.17169
      3158 808.57  1868.6  3372.2  3698.2   121.68350
      3159 808.75  1857.9  3410.7  3730.6   120.60144
      3160 808.93  1910.8  3363.2  3735.9   125.66277
      3161 809.10  1850.1  3346.4  3653.2   120.50371
      3162 809.28  1878.8  3364.0  3688.8   121.86985
      3163 809.46  1866.1  3331.6  3729.4   127.13802
      3164 809.64  1976.3  3434.0  3800.2   125.11943
      3165 809.81  1835.4  3284.9  3629.8   123.79204
      3166 809.99  1847.7  3353.8  3614.7   117.32388
      3167 810.17  1793.6  3241.5  3582.3   123.53607
      3168 810.35  2080.7  3472.9  3821.9   125.06621
      3169 810.52  1899.3  3311.2  3673.2   125.64549
      3170 810.70  1956.6  3385.3  3670.0   119.92548
      3171 810.88  1880.9  3338.6  3695.4   124.47314
      3172 811.06  1901.3  3347.2  3644.2   120.53828
      3173 811.23  1969.3  3403.7  3747.4   123.95773
      3174 811.41  1855.5  3265.3  3572.1   121.76063
      3175 811.59  1703.1  3128.9  3475.0   124.27458
      3176 811.77  1936.2  3367.3  3725.3   125.01432
      3177 811.94  1843.6  3232.9  3536.4   121.84552
      3178 812.12  1849.3  3271.4  3612.6   123.99197
      3179 812.30  1913.2  3325.1  3618.4   120.77167
      3180 812.47  1934.1  3259.1  3612.2   126.64609
      3181 812.65  1971.4  3308.3  3637.6   124.63232
      3182 812.83  1957.9  3327.9  3663.0   124.45443
      3183 813.01  1875.9  3266.5  3645.0   127.21652
      3184 813.18  1847.7  3235.8  3505.3   119.41570
      3185 813.36  1877.2  3285.4  3635.6   124.86914
      3186 813.54  1860.0  3226.4  3593.4   126.85851
      3187 813.71  1855.0  3216.9  3529.1   122.91734
      3188 813.89  2056.2  3416.8  3714.6   121.88444
      3189 814.07  1928.8  3321.8  3653.6   123.81653
      3190 814.25  1841.1  3194.8  3559.0   126.89866
      3191 814.42  1880.4  3239.9  3591.7   125.88128
      3192 814.60  2016.8  3343.9  3680.6   125.37038
      3193 814.78  1942.7  3338.2  3702.3   126.09335
      3194 814.95  1768.2  3105.1  3438.1   124.90811
      3195 815.13  2016.0  3314.0  3700.7   129.78861
      3196 815.31  1862.4  3228.0  3536.4   122.58549
      3197 815.49  1973.4  3309.1  3628.6   123.91904
      3198 815.66  1891.9  3193.6  3554.0   127.69043
      3199 815.84  1904.2  3248.1  3580.3   124.71811
      3200 816.02  1934.9  3255.9  3583.9   124.83716
      3201 816.19  1871.0  3229.6  3502.0   120.04824
      3202 816.37  1954.2  3247.3  3600.7   127.33613
      3203 816.55  1904.6  3195.2  3509.4   124.34145
      3204 816.72  1961.5  3254.2  3632.7   129.27759
      3205 816.90  1845.2  3175.2  3459.8   121.40432
      3206 817.08  1832.9  3176.0  3508.6   124.76364
      3207 817.25  1845.2  3169.4  3440.6   120.47642
      3208 817.43  1957.9  3243.2  3554.9   124.25113
      3209 817.61  1890.7  3151.0  3499.6   127.65679
      3210 817.78  1964.4  3268.1  3585.6   124.34809
      3211 817.96  1846.4  3144.0  3420.5   121.30676
      3212 818.14  1807.1  3158.8  3418.1   119.18184
      3213 818.31  1946.4  3238.2  3488.5   119.37225
      3214 818.49  1877.6  3201.4  3471.7   120.42080
      3215 818.67  1763.7  3044.1  3370.1   125.46380
      3216 818.84  1843.2  3126.8  3391.4   120.61259
      3217 819.02  1820.6  3084.7  3316.1   118.30844
      3218 819.20  1833.8  3123.6  3409.0   122.13402
      3219 819.37  1914.9  3213.3  3503.3   122.33436
      3220 819.55  1862.4  3140.4  3440.2   123.46158
      3221 819.73  1934.1  3150.2  3480.3   127.14714
      3222 819.90  1855.9  3102.7  3467.2   129.23780
      3223 820.08  1941.9  3241.1  3553.6   124.05423
      3224 820.26  1913.2  3190.7  3474.2   122.18661
      3225 820.43  1947.6  3200.6  3501.6   124.02741
      3226 820.61  1943.1  3143.2  3438.5   124.60760
      3227 820.79  1870.6  3098.6  3452.1   128.78583
      3228 820.96  1884.5  3153.5  3438.1   122.43386
      3229 821.14  1869.0  3074.8  3364.0   123.98096
      3230 821.32  1810.0  3066.2  3312.8   119.62827
      3231 821.49  1784.2  3027.7  3296.0   121.57444
      3232 821.67  1854.6  3054.3  3379.6   127.10817
      3233 821.85  1844.8  3033.5  3394.3   130.35837
      3234 822.02  1925.5  3122.3  3404.5   123.57973
      3235 822.20  1888.2  3104.3  3375.9   122.33078
      3236 822.37  1996.8  3159.6  3457.4   125.60765
      3237 822.55  1776.8  2989.6  3228.4   119.68928
      3238 822.73  1913.6  3047.0  3386.1   129.92414
      3239 822.90  1907.5  3061.3  3337.0   123.89060
      3240 823.08  1993.9  3165.8  3459.0   125.02620
      3241 823.26  1831.3  3014.6  3252.6   120.11077
      3242 823.43  1966.5  3120.3  3392.3   123.57117
      3243 823.61  1893.6  3045.7  3363.2   127.55065
      3244 823.78  1926.3  3049.4  3320.2   124.10654
      3245 823.96  1800.6  2999.5  3241.5   120.19133
      3246 824.14  1874.7  3050.2  3320.2   122.96165
      3247 824.31  1863.2  3056.8  3284.9   119.11465
      3248 824.49  1986.9  3164.9  3450.4   124.23505
      3249 824.67  1993.1  3172.7  3407.0   119.86114
      3250 824.84  1911.2  3058.8  3373.0   127.37335
      3251 825.02  1910.3  3030.2  3306.7   124.68902
      3252 825.19  1948.0  3053.9  3373.8   128.92595
      3253 825.37  2039.8  3217.4  3504.5   124.38259
      3254 825.55  1932.1  3046.6  3387.3   130.57701
      3255 825.72  1765.3  2972.4  3234.6   121.71700
      3256 825.90  1795.2  2948.3  3239.9   125.29308
      3257 826.07  1845.2  3079.7  3281.3   116.32390
      3258 826.25  1873.9  3070.7  3346.0   122.99795
      3259 826.43  1771.5  2939.7  3235.0   125.28050
      3260 826.60  1760.4  2932.7  3227.2   125.12231
      3261 826.78  1916.9  3088.7  3336.6   121.14653
      3262 826.95  1839.5  3016.7  3262.4   120.87681
      3263 827.13  1831.7  2948.7  3242.3   126.29266
      3264 827.31  1998.4  3115.0  3444.7   129.53047
      3265 827.48  1916.1  3075.2  3375.1   125.86576
      3266 827.66  1960.3  3144.5  3409.5   122.37980
      3267 827.83  1894.8  3080.1  3341.9   122.08014
      3268 828.01  1865.7  2958.1  3294.8   130.82116
      3269 828.19  1880.0  2999.0  3274.7   124.63401
      3270 828.36  1832.5  2995.8  3277.2   124.19013
      3271 828.54  1991.4  3053.1  3328.8   125.96445
      3272 828.71  1831.7  2982.3  3237.8   122.21435
      3273 828.89  1854.2  2952.4  3226.8   124.99069
      3274 829.06  1793.6  2887.2  3166.2   125.50569
      3275 829.24  2045.9  3122.7  3386.5   124.49597
      3276 829.42  1850.1  2958.9  3164.1   118.50763
      3277 829.59  1925.1  3038.8  3316.5   124.93569
      3278 829.77  1821.1  2923.3  3185.0   123.74578
      3279 829.94  1873.5  2965.9  3189.1   120.43499
      3280 830.12  1853.8  2931.5  3209.6   125.80776
      3281 830.29  1798.5  2886.0  3149.8   124.25607
      3282 830.47  1839.1  2906.5  3205.1   127.97393
      3283 830.65  1781.7  2785.2  3119.9   133.34692
      3284 830.82  2008.6  3068.3  3341.5   125.78276
      3285 831.00  1854.6  2890.1  3204.7   130.37962
      3286 831.17  1895.6  2933.9  3181.3   123.82647
      3287 831.35  1873.1  2916.3  3153.5   122.73254
      3288 831.52  1891.9  2895.8  3220.6   132.35417
      3289 831.70  1920.6  2978.6  3244.8   125.16454
      3290 831.87  1889.5  2942.1  3165.3   121.20617
      3291 832.05  1843.2  2903.2  3148.5   123.14533
      3292 832.23  1905.4  2919.6  3188.7   126.53473
      3293 832.40  1905.4  2925.3  3171.1   124.09635
      3294 832.58  1924.7  2938.8  3216.1   127.34249
      3295 832.75  1853.0  2935.1  3170.7   121.76377
      3296 832.93  1846.9  2919.6  3138.3   120.38946
      3297 833.10  1845.6  2894.6  3123.2   121.78833
      3298 833.28  1906.2  2938.8  3197.7   125.06939
      3299 833.45  1848.9  2916.3  3141.6   121.10508
      3300 833.63  1904.2  2960.1  3162.9   119.20093
      3301 833.80  1796.5  2789.3  3067.4   128.01164
      3302 833.98  1908.7  2909.8  3191.6   128.15053
      3303 834.15  1900.1  2964.2  3242.3   126.13546
      3304 834.33  1908.3  2931.1  3167.0   123.06767
      3305 834.51  1886.6  2904.4  3182.5   127.32394
      3306 834.68  1836.2  2890.1  3115.8   121.41467
      3307 834.86  1804.3  2785.2  3044.1   126.38826
      3308 835.03  1888.6  2851.6  3113.3   127.17988
      3309 835.21  1874.7  2906.1  3146.1   123.27245
      3310 835.38  1849.7  2850.4  3063.8   121.32619
      3311 835.56  1846.0  2878.2  3116.2   123.05556
      3312 835.73  1920.6  2885.2  3185.4   131.12536
      3313 835.91  1969.7  2947.8  3205.5   126.34008
      3314 836.08  1839.9  2825.4  3029.4   120.69818
      3315 836.26  1859.6  2835.6  3038.0   120.73014
      3316 836.43  1873.5  2854.9  3105.9   125.58433
      3317 836.61  1904.2  2912.6  3155.5   124.08610
      3318 836.78  1916.1  2843.0  3085.5   126.16004
      3319 836.96  1801.4  2752.5  2985.9   124.54775
      3320 837.13  2017.2  2953.6  3222.3   128.69634
      3321 837.31  1923.5  2895.8  3123.2   123.37820
      3322 837.48  1866.1  2819.2  3008.1   119.81083
      3323 837.66  1812.0  2749.6  3004.8   127.21714
      3324 837.83  1860.4  2843.8  3083.8   124.40652
      3325 838.01  1931.6  2895.8  3104.7   121.66526
      3326 838.18  1810.4  2722.2  2945.0   124.43845
      3327 838.36  1816.1  2742.6  3004.4   128.24929
      3328 838.53  1876.8  2767.2  3007.2   126.95495
      3329 838.71  1992.7  2942.1  3187.9   125.88437
      3330 838.88  1788.3  2756.6  3006.8   125.84604
      3331 839.06  1892.7  2794.7  3012.6   124.15988
      3332 839.23  1921.8  2846.3  3060.5   123.17230
      3333 839.41  1865.3  2836.4  3075.2   124.58876
      3334 839.58  1873.9  2780.7  3012.2   125.51936
      3335 839.76  1785.8  2748.8  2942.9   120.16159
      3336 839.93  1936.2  2910.6  3122.3   121.73184
      3337 840.11  1930.0  2911.4  3086.3   117.82143
      3338 840.28  1841.1  2783.2  3003.1   123.34773
      3339 840.46  1894.0  2827.8  3038.8   122.58776
      3340 840.63  1809.6  2710.7  2911.4   122.27274
      3341 840.81  1896.8  2782.0  3041.2   129.29202
      3342 840.98  1753.5  2689.4  2942.9   127.08965
      3343 841.15  1845.6  2786.1  3016.7   124.52086
      3344 841.33  1917.7  2843.0  3038.4   121.11552
      3345 841.50  1846.9  2749.2  2958.5   123.19571
      3346 841.68  1837.8  2765.2  2928.2   117.57958
      3347 841.85  1887.0  2825.8  3009.7   119.58992
      3348 842.03  2002.9  2912.2  3091.6   119.72970
      3349 842.20  1961.1  2837.7  3068.3   126.30837
      3350 842.38  1841.9  2741.4  2911.4   118.89795
      3351 842.55  1801.0  2681.6  2956.4   131.20939
      3352 842.73  1891.5  2784.4  2976.9   121.55964
      3353 842.90  1846.4  2744.7  2902.8   117.60144
      3354 843.08  1879.6  2781.6  2999.5   124.15988
      3355 843.25  1926.7  2764.3  3007.2   128.99755
      3356 843.42  1857.1  2780.7  2959.7   119.37910
      3357 843.60  1933.3  2865.1  3042.1   118.98906
      3358 843.77  1783.0  2621.0  2895.0   132.69807
      3359 843.95  1822.3  2677.1  2889.7   124.86822
      3360 844.12  1746.1  2674.2  2884.8   122.68311
      3361 844.30  1965.6  2795.9  3050.7   130.68569
      3362 844.47  1853.4  2713.6  2917.1   123.66665
      3363 844.64  1835.4  2714.0  2865.5   117.24946
      3364 844.82  2042.6  2908.9  3113.3   123.59334
      3365 844.99  1879.2  2764.8  2982.3   124.56055
      3366 845.17  1825.6  2679.6  2927.4   129.01688
      3367 845.34  1780.1  2600.9  2843.4   129.54097
      3368 845.52  1909.1  2704.5  2951.5   131.05042
      3369 845.69  1966.0  2799.2  3027.3   127.38437
      3370 845.87  1890.7  2767.2  2903.2   115.51402
      3371 846.04  1846.0  2680.8  2917.1   128.31212
      3372 846.21  1908.7  2732.0  2922.5   123.13433
      3373 846.39  1929.6  2787.3  2926.1   116.18920
      3374 846.56  1824.3  2669.7  2865.1   123.11045
      3375 846.74  1792.4  2628.0  2840.5   125.44113
      3376 846.91  1866.1  2710.3  2907.7   123.38668
      3377 847.08  1862.0  2692.7  2882.3   122.83039
      3378 847.26  1799.8  2638.6  2799.6   119.18941
      3379 847.43  1846.4  2655.4  2857.3   124.96208
      3380 847.61  1849.3  2689.0  2852.4   119.46343
      3381 847.78  1992.7  2815.5  2977.3   119.66160
      3382 847.95  1812.5  2677.1  2873.7   122.73802
      3383 848.13  1824.7  2655.8  2863.9   125.03700
      3384 848.30  1874.3  2733.6  2890.1   118.20783
      3385 848.48  1857.5  2684.9  2825.4   116.98025
      3386 848.65  1837.0  2667.3  2852.4   122.29891
      3387 848.83  1886.6  2669.7  2873.3   125.99372
      3388 849.00  1853.4  2695.1  2845.0   117.81019
      3389 849.17  1879.2  2707.4  2903.6   123.68935
      3390 849.35  1775.6  2551.8  2741.0   124.37991
      3391 849.52  1785.8  2612.8  2797.5   122.33769
      3392 849.69  1945.2  2779.1  2975.3   123.52647
      3393 849.87  1823.1  2645.6  2855.7   125.54787
      3394 850.04  1834.6  2606.7  2792.6   124.08478
      3395 850.22  1740.0  2584.9  2798.3   125.25444
      3396 850.39  1868.2  2700.9  2865.5   119.77377
      3397 850.56  1962.4  2778.7  2966.7   123.03067
      3398 850.74  1837.4  2670.1  2818.4   117.80621
      3399 850.91  1823.5  2627.5  2820.5   123.99392
      3400 851.09  1843.6  2650.1  2849.5   124.73332
      3401 851.26  1863.7  2768.0  2927.8   117.66298
      3402 851.43  1771.9  2621.0  2820.9   123.54082
      3403 851.61  1870.6  2718.1  2878.6   118.94639
      3404 851.78  1850.1  2698.0  2858.1   118.88887
      3405 851.95  1865.7  2721.3  2932.7   124.70078
      3406 852.13  1833.3  2715.2  2861.4   116.58152
      3407 852.30  1736.7  2610.3  2843.4   126.67608
      3408 852.48  2086.9  2897.1  3103.1   125.42963
      3409 852.65  1918.5  2745.9  2974.5   127.62370
      3410 852.82  1842.8  2684.1  2914.7   127.40988
      3411 853.00  1792.0  2660.3  2852.4   122.12272
      3412 853.17  1962.0  2800.4  2986.3   122.17886
      3413 853.34  1746.1  2620.6  2818.4   122.62297
      3414 853.52  1810.0  2636.6  2859.0   126.90779
      3415 853.69  1778.0  2616.5  2818.0   124.03514
      3416 853.86  1954.6  2823.7  3007.2   121.11216
      3417 854.04  1868.2  2816.8  2961.4   115.24184
      3418 854.21  1816.1  2726.3  2889.7   117.95681
      3419 854.38  1811.6  2707.4  2890.9   120.48467
      3420 854.56  1825.6  2657.0  2892.1   128.27574
      3421 854.73  1820.2  2652.9  2837.7   122.18399
      3422 854.90  1865.3  2711.5  2888.0   120.86157
      3423 855.08  1809.2  2659.1  2822.5   119.22893
      3424 855.25  1911.6  2740.6  2927.8   122.57900
      3425 855.42  1786.2  2569.0  2782.8   127.31554
      3426 855.60  1856.3  2675.1  2865.1   123.21154
      3427 855.77  1873.5  2697.2  2865.5   120.43759
      3428 855.95  1900.1  2718.5  2929.4   125.77566
      3429 856.12  1912.8  2705.0  2924.9   127.76632
      3430 856.29  1819.8  2613.2  2806.9   124.41923
      3431 856.46  1889.9  2688.2  2858.1   121.29293
      3432 856.64  1890.7  2648.8  2834.0   124.41918
      3433 856.81  1910.8  2707.0  2869.2   120.37036
      3434 856.98  1848.5  2616.5  2792.6   122.93330
      3435 857.16  1814.1  2627.1  2750.0   115.11335
      3436 857.33  1797.3  2557.1  2721.3   121.61722
      3437 857.50  1894.8  2717.2  2885.6   120.46813
      3438 857.68  1839.9  2600.5  2759.8   120.94776
      3439 857.85  1853.0  2602.1  2773.8   122.90872
      3440 858.02  1835.4  2539.1  2795.1   136.37950
      3441 858.20  1828.8  2625.9  2766.8   117.67724
      3442 858.37  1831.3  2543.6  2772.5   132.14495
      3443 858.54  1838.7  2540.7  2732.4   127.30456
      3444 858.72  2215.5  2934.3  3135.0   127.92024
      3445 858.89  1989.0  2719.7  2873.7   121.07634
      3446 859.06  1744.9  2528.0  2664.0   117.36398
      3447 859.24  1820.6  2526.8  2719.7   127.32022
      3448 859.41  1932.9  2637.4  2817.2   125.52331
      3449 859.58  1923.9  2641.9  2820.1   124.81456
      3450 859.75  1850.1  2546.9  2724.2   125.45560
      3451 859.93  1852.2  2560.4  2729.9   123.94435
      3452 860.10  1910.3  2622.2  2813.9   126.92752
      3453 860.27  1956.6  2666.0  2830.7   123.21004
      3454 860.45  1851.4  2571.8  2722.2   120.86415
      3455 860.62  1849.3  2579.6  2767.2   125.68708
      3456 860.79  1914.9  2572.2  2762.7   128.97195
      3457 860.97  1904.6  2629.6  2826.2   127.11864
      3458 861.14  1813.3  2527.2  2659.1   118.47403
      3459 861.31  1849.3  2526.0  2712.7   127.60279
      3460 861.48  1885.4  2563.2  2742.2   126.40475
      3461 861.66  1779.7  2502.6  2677.9   124.24927
      3462 861.83  1788.7  2493.2  2667.7   124.76746
      3463 862.00  1794.8  2468.2  2661.1   128.64969
      3464 862.17  1813.3  2481.7  2685.3   130.45342
      3465 862.35  1950.1  2657.0  2771.7   116.22244
      3466 862.52  1855.5  2487.9  2652.5   126.03635
      3467 862.69  1828.4  2489.1  2662.8   126.28645
      3468 862.87  1888.6  2573.9  2725.0   122.05618
      3469 863.04  1943.5  2626.7  2792.6   124.28048
      3470 863.21  1762.9  2495.7  2593.5   113.35944
      3471 863.38  1807.5  2464.1  2610.8   122.33318
      3472 863.56  1938.6  2603.4  2757.8   123.22860
      3473 863.73  1852.6  2520.2  2692.3   125.76700
      3474 863.90  1838.3  2476.8  2623.9   123.02774
      3475 864.07  1898.5  2565.3  2752.9   128.13267
      3476 864.25  2016.4  2699.2  2804.9   115.47687
      3477 864.42  1825.2  2519.4  2651.3   118.99703
      3478 864.59  1776.4  2412.5  2580.8   126.46491
      3479 864.76  1764.1  2377.3  2579.2   132.93257
      3480 864.94  1944.3  2625.9  2745.5   117.54802
      3481 865.11  1841.1  2511.6  2648.4   120.40313
      3482 865.28  1752.7  2414.1  2569.0   123.40550
      3483 865.45  1842.4  2469.8  2640.7   127.21941
      3484 865.63  1877.2  2505.9  2672.2   126.44948
      3485 865.80  1832.5  2480.5  2632.0   123.38799
      3486 865.97  1777.6  2500.6  2625.9   117.33715
      3487 866.14  1765.3  2411.7  2583.3   126.55263
      3488 866.32  1950.9  2531.3  2739.0   135.77983
      3489 866.49  1829.7  2488.7  2622.6   120.32314
      3490 866.66  1909.5  2576.8  2707.0   119.52121
      3491 866.83  1820.6  2449.0  2599.3   123.92439
      3492 867.01  1830.5  2528.0  2665.2   119.67116
      3493 867.18  1852.2  2475.6  2669.7   131.14315
      3494 867.35  1755.1  2395.7  2548.9   123.91302
      3495 867.52  1760.8  2390.8  2532.9   122.56177
      3496 867.70  1964.4  2587.8  2734.4   123.52178
      3497 867.87  2018.5  2621.0  2800.0   129.70779
      3498 868.04  1761.3  2315.8  2530.9   138.77405
      3499 868.21  1787.5  2418.7  2589.9   127.12521
      3500 868.38  1901.3  2517.8  2709.1   131.02983
      3501 868.56  1977.9  2595.2  2738.5   123.22497
      3502 868.73  1809.2  2472.3  2613.2   121.24766
      3503 868.90  1761.7  2371.5  2505.5   121.96103
      3504 869.07  1896.8  2446.1  2627.5   133.03506
      3505 869.24  1915.3  2561.2  2708.6   122.82802
      3506 869.42  1861.2  2486.2  2611.2   119.98688
      3507 869.59  1839.5  2473.1  2637.8   125.98585
      3508 869.76  2019.3  2588.2  2751.2   128.65364
      3509 869.93  1851.0  2463.7  2589.5   120.52152
      3510 870.11  1947.2  2566.1  2715.6   124.15624
      3511 870.28  1859.6  2419.9  2584.5   129.38603
      3512 870.45  1987.8  2604.2  2746.3   123.05646
      3513 870.62  1908.3  2507.9  2626.3   119.74031
      3514 870.79  1819.0  2410.1  2534.6   121.06713
      3515 870.97  1880.9  2466.6  2659.5   132.93695
      3516 871.14  1959.5  2532.1  2700.0   129.32749
      3517 871.31  1942.7  2498.9  2687.3   133.87352
      3518 871.48  1826.0  2398.2  2547.7   126.12749
      3519 871.65  1974.2  2540.3  2654.6   120.18821
      3520 871.82  2014.0  2603.0  2746.7   124.40899
      3521 872.00  1907.1  2489.9  2622.6   122.76890
      3522 872.17  1833.8  2357.6  2553.0   137.29468
      3523 872.34  1869.4  2443.6  2534.6   115.83457
      3524 872.51  1880.4  2446.9  2581.3   123.71661
      3525 872.68  1933.3  2499.3  2656.2   127.71337
      3526 872.86  1917.3  2471.9  2600.9   123.26439
      3527 873.03  1799.3  2406.4  2508.4   116.80164
      3528 873.20  1901.3  2442.0  2579.2   125.37879
      3529 873.37  2063.9  2676.7  2775.8   116.17653
      3530 873.54  1775.6  2309.7  2490.7   133.89583
      3531 873.71  1818.2  2418.7  2556.3   122.91961
      3532 873.89  2063.1  2613.2  2714.4   118.39174
      3533 874.06  1918.1  2487.9  2612.4   121.85490
      3534 874.23  1789.9  2388.3  2521.9   122.31357
      3535 874.40  1865.3  2463.7  2548.5   114.16840
      3536 874.57  2027.5  2561.2  2719.7   129.70071
      3537 874.74  1887.4  2437.9  2599.3   129.31549
      3538 874.92  1829.2  2353.5  2523.1   132.34379
      3539 875.09  1760.4  2297.8  2416.6   122.10362
      3540 875.26  1966.5  2513.3  2640.7   123.29597
      3541 875.43  1929.2  2482.1  2620.2   124.96297
      3542 875.60  1807.5  2377.3  2485.8   119.05098
      3543 875.77  1871.8  2406.4  2550.5   126.97317
      3544 875.95  1834.2  2369.1  2489.1   122.43494
      3545 876.12  1943.9  2436.7  2586.2   130.34089
      3546 876.29  1769.4  2293.3  2472.3   134.16745
      3547 876.46  1872.3  2439.9  2542.3   118.03744
      3548 876.63  1848.5  2421.9  2524.7   117.92857
      3549 876.80  1910.8  2454.3  2532.5   114.39329
      3550 876.97  1959.9  2458.0  2592.3   126.97373
      3551 877.15  1805.5  2326.5  2477.6   129.00962
      3552 877.32  1975.1  2518.2  2620.2   118.77832
      3553 877.49  1841.1  2382.6  2455.5   113.46450
      3554 877.66  1967.7  2505.1  2638.6   124.84764
      3555 877.83  1864.1  2371.5  2504.7   126.23082
      3556 878.00  1839.1  2354.3  2501.8   128.61690
      3557 878.17  2049.6  2622.6  2726.7   118.15585
      3558 878.34  1811.6  2350.7  2432.2   115.12153
      3559 878.52  1898.9  2372.8  2538.7   135.00422
      3560 878.69  1930.0  2426.8  2542.8   123.33059
      3561 878.86  1805.5  2300.7  2460.4   132.25814
      3562 879.03  1778.5  2306.8  2403.9   118.37214
      3563 879.20  1829.7  2308.5  2461.2   131.90773
      3564 879.37  1889.5  2453.1  2539.5   115.33425
      3565 879.54  2056.6  2597.6  2723.8   123.31548
      3566 879.71  1792.0  2308.1  2419.9   121.66665
      3567 879.89  1841.1  2335.9  2463.3   125.74512
      3568 880.06  1976.3  2473.5  2623.9   130.23065
      3569 880.23  1906.2  2404.7  2536.2   126.37619
      3570 880.40  1935.7  2392.0  2545.2   133.57295
      3571 880.57  1886.6  2362.5  2533.7   135.97242
      3572 880.74  1868.6  2355.6  2463.7   122.20338
      3573 880.91  2016.0  2474.4  2621.4   132.08214
      3574 881.08  1855.9  2335.9  2450.2   123.80553
      3575 881.25  1874.7  2366.2  2540.3   135.41663
      3576 881.42  1955.4  2462.5  2539.9   115.26652
      3577 881.60  1848.5  2384.7  2530.9   127.27274
      3578 881.77  1876.3  2320.8  2464.9   132.44241
      3579 881.94  1765.3  2278.2  2384.2   120.68696
      3580 882.11  1847.3  2319.1  2464.1   130.72913
      3581 882.28  1934.5  2392.8  2531.3   130.20535
      3582 882.45  1847.3  2305.6  2445.3   130.47378
      3583 882.62  1854.6  2349.8  2492.0   128.70139
      3584 882.79  2015.2  2454.3  2593.1   131.62303
      3585 882.96  1895.2  2398.2  2533.7   126.95450
      3586 883.13  1755.5  2299.1  2366.6   112.43407
      3587 883.30  1954.2  2438.7  2521.1   116.99085
      3588 883.48  1893.6  2394.5  2511.2   123.30332
      3589 883.65  1866.9  2344.9  2465.8   125.27845
      3590 883.82  1769.4  2202.4  2353.9   135.00454
      3591 883.99  1803.9  2322.8  2429.7   120.59986
      3592 884.16  1962.8  2460.8  2570.6   122.03945
      3593 884.33  1835.0  2325.3  2441.6   123.72584
      3594 884.50  1822.3  2302.3  2418.7   124.23220
      3595 884.67  1937.4  2364.2  2454.7   121.20915
      3596 884.84  1882.1  2381.4  2464.5   116.65308
      3597 885.01  1863.2  2309.3  2464.5   134.80253
      3598 885.18  1905.8  2354.8  2457.6   122.90149
      3599 885.35  1759.2  2264.2  2369.5   120.84356
      3600 885.52  1804.3  2229.8  2313.4   119.63446
      3601 885.69  1885.4  2352.3  2466.6   124.47375
      3602 885.87  1818.6  2297.0  2392.8   120.03424
      3603 886.04  1820.2  2334.3  2427.7   118.16726
      3604 886.21  1928.0  2383.4  2490.3   123.47124
      3605 886.38  1966.5  2415.0  2503.4   119.72598
      3606 886.55  1838.7  2274.1  2449.0   140.16945
      3607 886.72  1834.6  2303.6  2426.8   126.28826
      3608 886.89  1966.5  2391.2  2503.8   126.51902
      3609 887.06  1880.9  2335.5  2471.5   129.90982
      3610 887.23  1865.7  2310.5  2389.2   117.67959
      3611 887.40  1924.7  2362.1  2490.7   129.40089
      3612 887.57  1894.4  2350.7  2440.8   119.74849
      3613 887.74  1944.3  2388.3  2452.6   114.48337
      3614 887.91  1774.4  2194.2  2292.5   123.41449
      3615 888.08  1794.8  2244.2  2329.8   119.05195
      3616 888.25  1922.2  2377.7  2456.3   117.26616
      3617 888.42  2030.4  2496.9  2599.3   121.94895
      3618 888.59  1792.8  2217.9  2336.7   127.93832
      3619 888.76  1840.7  2266.3  2366.2   123.48414
      3620 888.93  1887.8  2302.3  2435.0   132.01603
      3621 889.10  1810.4  2229.8  2333.0   124.60946
      3622 889.27  1838.7  2239.2  2378.5   134.76483
      3623 889.44  1897.6  2287.6  2419.9   133.92865
      3624 889.61  1856.7  2304.4  2362.5   112.99192
      3625 889.78  1928.4  2322.4  2388.3   116.73578
      3626 889.95  1887.4  2324.4  2423.6   122.68023
      3627 890.12  1853.0  2313.0  2405.1   120.03548
      3628 890.29  1986.9  2356.4  2463.7   129.04638
      3629 890.46  1878.4  2280.2  2377.7   124.26116
      3630 890.63  1790.7  2189.7  2330.6   135.31824
      3631 890.80  1844.0  2260.5  2430.5   140.80618
      3632 890.97  1860.0  2281.8  2359.3   118.34944
      3633 891.15  1902.2  2344.9  2434.6   120.25901
      3634 891.32  1864.1  2253.2  2356.4   126.52642
      3635 891.49  1863.2  2295.8  2368.7   116.85613
      3636 891.66  2029.5  2425.6  2526.0   125.33624
      3637 891.83  1876.3  2309.7  2384.7   117.29687
      3638 892.00  1882.9  2270.4  2367.0   124.94709
      3639 892.17  1952.5  2333.9  2449.4   130.29014
      3640 892.34  1913.2  2334.3  2405.5   116.92597
      3641 892.51  1946.0  2351.1  2464.9   128.10920
      3642 892.68  1853.8  2264.2  2368.7   125.44924
      3643 892.84  1788.7  2208.5  2340.4   131.41487
      3644 893.01  1796.1  2174.1  2317.9   138.02806
      3645 893.18  1940.2  2331.4  2386.3   114.03127
      3646 893.35  1936.6  2359.7  2421.1   114.52078
      3647 893.52  1776.4  2143.8  2297.4   141.80580
      3648 893.69  1984.5  2397.8  2497.3   124.08319
      
      $metadata
       [1] "hugo" NA     NA     NA     "200"  "200"  "200"  "5"    "5"    "5"   
      [11] "0"    "0"    "0"   
      

---

    Code
      lr_parse_spc(test.file("OceanOptics.spc"))
    Output
      $data
               wl dark white scope  processed
      1    176.36   NA    NA    NA     0.0000
      2    176.58   NA    NA    NA     0.0000
      3    176.80   NA    NA    NA     0.0000
      4    177.02   NA    NA    NA    46.9880
      5    177.24   NA    NA    NA   165.7143
      6    177.47   NA    NA    NA     7.7922
      7    177.69   NA    NA    NA   115.8730
      8    177.91   NA    NA    NA   -50.9804
      9    178.13   NA    NA    NA   350.0000
      10   178.35   NA    NA    NA  -807.1429
      11   178.57   NA    NA    NA    29.5082
      12   178.79   NA    NA    NA   746.6667
      13   179.01   NA    NA    NA -1800.0000
      14   179.23   NA    NA    NA   -62.5000
      15   179.46   NA    NA    NA  -792.8571
      16   179.68   NA    NA    NA   700.0000
      17   179.90   NA    NA    NA   226.4706
      18   180.12   NA    NA    NA   259.6154
      19   180.34   NA    NA    NA  -260.0000
      20   180.56   NA    NA    NA  -171.7391
      21   180.78   NA    NA    NA    62.1849
      22   181.00   NA    NA    NA   313.3333
      23   181.22   NA    NA    NA   831.2500
      24   181.44   NA    NA    NA    -4.4944
      25   181.66   NA    NA    NA  -190.9091
      26   181.89   NA    NA    NA    22.4719
      27   182.11   NA    NA    NA    76.1905
      28   182.33   NA    NA    NA     1.1628
      29   182.55   NA    NA    NA   150.0000
      30   182.77   NA    NA    NA   225.0000
      31   182.99   NA    NA    NA     3.4965
      32   183.21   NA    NA    NA   148.7179
      33   183.43   NA    NA    NA   650.0000
      34   183.65   NA    NA    NA    93.5484
      35   183.87   NA    NA    NA    50.0000
      36   184.09   NA    NA    NA    26.8657
      37   184.31   NA    NA    NA    86.7647
      38   184.53   NA    NA    NA    22.2222
      39   184.76   NA    NA    NA    11.1111
      40   184.98   NA    NA    NA  -138.4615
      41   185.20   NA    NA    NA     2.9586
      42   185.42   NA    NA    NA   -28.5714
      43   185.64   NA    NA    NA   312.9032
      44   185.86   NA    NA    NA    60.1626
      45   186.08   NA    NA    NA  -125.3521
      46   186.30   NA    NA    NA   134.0426
      47   186.52   NA    NA    NA  -312.9032
      48   186.74   NA    NA    NA  -173.9130
      49   186.96   NA    NA    NA   111.7647
      50   187.18   NA    NA    NA    45.2381
      51   187.40   NA    NA    NA    89.6907
      52   187.62   NA    NA    NA   -39.2405
      53   187.84   NA    NA    NA   420.0000
      54   188.06   NA    NA    NA  -130.7692
      55   188.28   NA    NA    NA   -17.6471
      56   188.51   NA    NA    NA   850.0000
      57   188.73   NA    NA    NA    96.2500
      58   188.95   NA    NA    NA     5.7971
      59   189.17   NA    NA    NA   138.3333
      60   189.39   NA    NA    NA   543.7500
      61   189.61   NA    NA    NA   300.0000
      62   189.83   NA    NA    NA   166.6667
      63   190.05   NA    NA    NA   145.4545
      64   190.27   NA    NA    NA  -290.4762
      65   190.49   NA    NA    NA    74.5098
      66   190.71   NA    NA    NA  1333.3334
      67   190.93   NA    NA    NA -1800.0000
      68   191.15   NA    NA    NA   -43.1818
      69   191.37   NA    NA    NA   -80.0000
      70   191.59   NA    NA    NA   161.5385
      71   191.81   NA    NA    NA   248.0000
      72   192.03   NA    NA    NA   412.5000
      73   192.25   NA    NA    NA  -270.7317
      74   192.47   NA    NA    NA   125.0000
      75   192.69   NA    NA    NA   285.7143
      76   192.91   NA    NA    NA    45.4545
      77   193.13   NA    NA    NA     6.4935
      78   193.35   NA    NA    NA     1.9608
      79   193.57   NA    NA    NA   162.5000
      80   193.79   NA    NA    NA    64.2105
      81   194.01   NA    NA    NA   107.8261
      82   194.23   NA    NA    NA  -130.7692
      83   194.45   NA    NA    NA   -11.5385
      84   194.67   NA    NA    NA   -93.1034
      85   194.89   NA    NA    NA     3.5714
      86   195.11   NA    NA    NA   275.0000
      87   195.33   NA    NA    NA  1516.6666
      88   195.55   NA    NA    NA   174.0741
      89   195.77   NA    NA    NA    94.5455
      90   195.99   NA    NA    NA    58.6207
      91   196.21   NA    NA    NA   146.6667
      92   196.43   NA    NA    NA   145.9460
      93   196.65   NA    NA    NA   161.6822
      94   196.87   NA    NA    NA   -75.4717
      95   197.09   NA    NA    NA    53.3333
      96   197.31   NA    NA    NA   -62.6667
      97   197.53   NA    NA    NA  -264.5161
      98   197.75   NA    NA    NA   369.2308
      99   197.97   NA    NA    NA    -3.8095
      100  198.19   NA    NA    NA -1271.4286
      101  198.41   NA    NA    NA    71.1111
      102  198.63   NA    NA    NA   172.2222
      103  198.85   NA    NA    NA  -133.3333
      104  199.07   NA    NA    NA    87.2340
      105  199.29   NA    NA    NA   142.1687
      106  199.51   NA    NA    NA    45.1613
      107  199.73   NA    NA    NA   240.6780
      108  199.95   NA    NA    NA  -100.0000
      109  200.17   NA    NA    NA   224.0741
      110  200.39   NA    NA    NA   105.5556
      111  200.61   NA    NA    NA   164.7059
      112  200.83   NA    NA    NA   330.0000
      113  201.05   NA    NA    NA  -733.3333
      114  201.27   NA    NA    NA    86.8421
      115  201.49   NA    NA    NA  2200.0000
      116  201.71   NA    NA    NA  1555.5555
      117  201.93   NA    NA    NA  -105.0000
      118  202.15   NA    NA    NA   671.4286
      119  202.37   NA    NA    NA  1042.8572
      120  202.59   NA    NA    NA   174.6835
      121  202.81   NA    NA    NA    68.4211
      122  203.03   NA    NA    NA    80.0000
      123  203.25   NA    NA    NA    21.6783
      124  203.47   NA    NA    NA    -6.5574
      125  203.69   NA    NA    NA   451.2820
      126  203.91   NA    NA    NA   145.7143
      127  204.13   NA    NA    NA   358.3333
      128  204.35   NA    NA    NA   172.5000
      129  204.57   NA    NA    NA  -362.5000
      130  204.79   NA    NA    NA    97.5904
      131  205.01   NA    NA    NA    -5.5556
      132  205.23   NA    NA    NA   112.1212
      133  205.45   NA    NA    NA   -94.8718
      134  205.67   NA    NA    NA   828.5714
      135  205.89   NA    NA    NA    51.8519
      136  206.10   NA    NA    NA   -90.5263
      137  206.32   NA    NA    NA   135.2941
      138  206.54   NA    NA    NA    19.1304
      139  206.76   NA    NA    NA   -56.8182
      140  206.98   NA    NA    NA    57.1429
      141  207.20   NA    NA    NA    39.0625
      142  207.42   NA    NA    NA  1050.0000
      143  207.64   NA    NA    NA    71.5686
      144  207.86   NA    NA    NA   157.1429
      145  208.08   NA    NA    NA  -540.0000
      146  208.30   NA    NA    NA -1111.1111
      147  208.52   NA    NA    NA   226.6667
      148  208.74   NA    NA    NA   160.0000
      149  208.96   NA    NA    NA     0.0000
      150  209.18   NA    NA    NA    -2.4691
      151  209.40   NA    NA    NA   355.5555
      152  209.62   NA    NA    NA -6900.0000
      153  209.83   NA    NA    NA    79.3651
      154  210.05   NA    NA    NA    64.2276
      155  210.27   NA    NA    NA    31.6667
      156  210.49   NA    NA    NA   125.4717
      157  210.71   NA    NA    NA  -325.0000
      158  210.93   NA    NA    NA   122.2222
      159  211.15   NA    NA    NA   128.5714
      160  211.37   NA    NA    NA    73.6842
      161  211.59   NA    NA    NA   -37.1429
      162  211.81   NA    NA    NA    92.7711
      163  212.03   NA    NA    NA    59.3103
      164  212.25   NA    NA    NA   -62.5000
      165  212.47   NA    NA    NA   214.2857
      166  212.68   NA    NA    NA   112.7660
      167  212.90   NA    NA    NA  -109.0909
      168  213.12   NA    NA    NA   106.4103
      169  213.34   NA    NA    NA   187.0370
      170  213.56   NA    NA    NA   176.0331
      171  213.78   NA    NA    NA   -48.2759
      172  214.00   NA    NA    NA    76.6234
      173  214.22   NA    NA    NA  -113.9535
      174  214.44   NA    NA    NA    63.7681
      175  214.66   NA    NA    NA    48.3871
      176  214.88   NA    NA    NA   -55.1724
      177  215.09   NA    NA    NA    98.9247
      178  215.31   NA    NA    NA   231.4815
      179  215.53   NA    NA    NA  -294.1176
      180  215.75   NA    NA    NA   -78.9474
      181  215.97   NA    NA    NA -6000.0000
      182  216.19   NA    NA    NA  -213.3333
      183  216.41   NA    NA    NA    50.0000
      184  216.63   NA    NA    NA   107.6923
      185  216.85   NA    NA    NA   345.2830
      186  217.06   NA    NA    NA   507.1429
      187  217.28   NA    NA    NA   666.6667
      188  217.50   NA    NA    NA   260.6383
      189  217.72   NA    NA    NA  -675.0000
      190  217.94   NA    NA    NA    17.8571
      191  218.16   NA    NA    NA   -52.7778
      192  218.38   NA    NA    NA    24.0000
      193  218.60   NA    NA    NA    47.7612
      194  218.82   NA    NA    NA   -28.9474
      195  219.03   NA    NA    NA   775.0000
      196  219.25   NA    NA    NA   -50.0000
      197  219.47   NA    NA    NA   233.3333
      198  219.69   NA    NA    NA   113.0000
      199  219.91   NA    NA    NA   105.8824
      200  220.13   NA    NA    NA   173.1707
      201  220.35   NA    NA    NA    43.7500
      202  220.57   NA    NA    NA    93.7500
      203  220.78   NA    NA    NA   115.6250
      204  221.00   NA    NA    NA   -17.9104
      205  221.22   NA    NA    NA   191.2088
      206  221.44   NA    NA    NA   196.6102
      207  221.66   NA    NA    NA    -9.0278
      208  221.88   NA    NA    NA  -107.3171
      209  222.10   NA    NA    NA    68.7500
      210  222.31   NA    NA    NA   178.3333
      211  222.53   NA    NA    NA   373.6842
      212  222.75   NA    NA    NA   125.7143
      213  222.97   NA    NA    NA    94.4162
      214  223.19   NA    NA    NA   -25.5319
      215  223.41   NA    NA    NA   156.8965
      216  223.63   NA    NA    NA   147.8873
      217  223.84   NA    NA    NA   -20.5882
      218  224.06   NA    NA    NA    29.6875
      219  224.28   NA    NA    NA -2525.0000
      220  224.50   NA    NA    NA   155.1020
      221  224.72   NA    NA    NA    55.9140
      222  224.94   NA    NA    NA    95.0000
      223  225.16   NA    NA    NA   182.6087
      224  225.37   NA    NA    NA   678.5714
      225  225.59   NA    NA    NA   326.3158
      226  225.81   NA    NA    NA   144.7619
      227  226.03   NA    NA    NA   150.0000
      228  226.25   NA    NA    NA   122.7642
      229  226.47   NA    NA    NA   100.0000
      230  226.68   NA    NA    NA    50.0000
      231  226.90   NA    NA    NA  -384.6154
      232  227.12   NA    NA    NA    75.3333
      233  227.34   NA    NA    NA   138.9313
      234  227.56   NA    NA    NA   -43.2990
      235  227.78   NA    NA    NA  -111.3636
      236  227.99   NA    NA    NA    81.6794
      237  228.21   NA    NA    NA   222.7273
      238  228.43   NA    NA    NA   291.1765
      239  228.65   NA    NA    NA -4250.0000
      240  228.87   NA    NA    NA   272.7273
      241  229.09   NA    NA    NA  1500.0000
      242  229.30   NA    NA    NA   106.2500
      243  229.52   NA    NA    NA  -192.8571
      244  229.74   NA    NA    NA   253.8462
      245  229.96   NA    NA    NA    53.9474
      246  230.18   NA    NA    NA   120.5128
      247  230.39   NA    NA    NA   203.7037
      248  230.61   NA    NA    NA  -118.8679
      249  230.83   NA    NA    NA    66.1157
      250  231.05   NA    NA    NA   146.0318
      251  231.27   NA    NA    NA    76.8000
      252  231.49   NA    NA    NA   557.1429
      253  231.70   NA    NA    NA    80.4124
      254  231.92   NA    NA    NA   134.0909
      255  232.14   NA    NA    NA   364.7059
      256  232.36   NA    NA    NA   106.7164
      257  232.58   NA    NA    NA    96.9543
      258  232.79   NA    NA    NA   134.3284
      259  233.01   NA    NA    NA   157.5758
      260  233.23   NA    NA    NA   147.6190
      261  233.45   NA    NA    NA   179.7872
      262  233.67   NA    NA    NA   114.5161
      263  233.88   NA    NA    NA   105.8296
      264  234.10   NA    NA    NA   135.8696
      265  234.32   NA    NA    NA    87.2038
      266  234.54   NA    NA    NA   205.1613
      267  234.75   NA    NA    NA   129.5598
      268  234.97   NA    NA    NA   207.9365
      269  235.19   NA    NA    NA   136.6667
      270  235.41   NA    NA    NA   130.9702
      271  235.63   NA    NA    NA   149.2188
      272  235.84   NA    NA    NA   170.1422
      273  236.06   NA    NA    NA   107.0671
      274  236.28   NA    NA    NA   100.4762
      275  236.50   NA    NA    NA   104.1353
      276  236.72   NA    NA    NA   140.6897
      277  236.93   NA    NA    NA   153.3654
      278  237.15   NA    NA    NA   124.9221
      279  237.37   NA    NA    NA   142.2442
      280  237.59   NA    NA    NA   132.7320
      281  237.80   NA    NA    NA   118.7320
      282  238.02   NA    NA    NA   137.3401
      283  238.24   NA    NA    NA   139.8907
      284  238.46   NA    NA    NA   138.4058
      285  238.67   NA    NA    NA   102.7076
      286  238.89   NA    NA    NA   117.9138
      287  239.11   NA    NA    NA   107.0588
      288  239.33   NA    NA    NA    92.4268
      289  239.55   NA    NA    NA   117.6577
      290  239.76   NA    NA    NA   117.5182
      291  239.98   NA    NA    NA   120.5128
      292  240.20   NA    NA    NA   114.4444
      293  240.42   NA    NA    NA   115.2091
      294  240.63   NA    NA    NA   119.6172
      295  240.85   NA    NA    NA   130.1444
      296  241.07   NA    NA    NA   120.3974
      297  241.29   NA    NA    NA   131.2821
      298  241.50   NA    NA    NA   120.3453
      299  241.72   NA    NA    NA   122.1429
      300  241.94   NA    NA    NA   114.2005
      301  242.16   NA    NA    NA   118.1472
      302  242.37   NA    NA    NA   124.9415
      303  242.59   NA    NA    NA   114.7982
      304  242.81   NA    NA    NA   107.6768
      305  243.03   NA    NA    NA   126.6046
      306  243.24   NA    NA    NA   141.8246
      307  243.46   NA    NA    NA   117.3040
      308  243.68   NA    NA    NA   111.0907
      309  243.90   NA    NA    NA   118.3803
      310  244.11   NA    NA    NA   116.4948
      311  244.33   NA    NA    NA   123.4536
      312  244.55   NA    NA    NA   118.0545
      313  244.76   NA    NA    NA   123.5245
      314  244.98   NA    NA    NA   113.9588
      315  245.20   NA    NA    NA   117.4375
      316  245.42   NA    NA    NA   124.4632
      317  245.63   NA    NA    NA   131.7401
      318  245.85   NA    NA    NA   113.4420
      319  246.07   NA    NA    NA   121.2610
      320  246.29   NA    NA    NA   119.9735
      321  246.50   NA    NA    NA   127.4238
      322  246.72   NA    NA    NA   130.1497
      323  246.94   NA    NA    NA   128.0822
      324  247.15   NA    NA    NA   123.9653
      325  247.37   NA    NA    NA   124.9703
      326  247.59   NA    NA    NA   127.3277
      327  247.81   NA    NA    NA   122.5209
      328  248.02   NA    NA    NA   129.1741
      329  248.24   NA    NA    NA   119.5894
      330  248.46   NA    NA    NA   127.5842
      331  248.67   NA    NA    NA   123.0596
      332  248.89   NA    NA    NA   125.3855
      333  249.11   NA    NA    NA   124.4215
      334  249.33   NA    NA    NA   123.2349
      335  249.54   NA    NA    NA   121.2151
      336  249.76   NA    NA    NA   137.3397
      337  249.98   NA    NA    NA   125.4229
      338  250.19   NA    NA    NA   128.7315
      339  250.41   NA    NA    NA   125.4462
      340  250.63   NA    NA    NA   124.9654
      341  250.84   NA    NA    NA   132.7578
      342  251.06   NA    NA    NA   124.7069
      343  251.28   NA    NA    NA   120.0598
      344  251.50   NA    NA    NA   125.2101
      345  251.71   NA    NA    NA   124.0538
      346  251.93   NA    NA    NA   122.4458
      347  252.15   NA    NA    NA   123.2955
      348  252.36   NA    NA    NA   129.4426
      349  252.58   NA    NA    NA   120.7234
      350  252.80   NA    NA    NA   123.3245
      351  253.01   NA    NA    NA   126.3400
      352  253.23   NA    NA    NA   122.9807
      353  253.45   NA    NA    NA   120.3252
      354  253.66   NA    NA    NA   124.6585
      355  253.88   NA    NA    NA   134.5367
      356  254.10   NA    NA    NA   122.7164
      357  254.31   NA    NA    NA   127.8649
      358  254.53   NA    NA    NA   119.2092
      359  254.75   NA    NA    NA   128.2377
      360  254.97   NA    NA    NA   123.4120
      361  255.18   NA    NA    NA   122.9018
      362  255.40   NA    NA    NA   122.2835
      363  255.62   NA    NA    NA   124.3894
      364  255.83   NA    NA    NA   117.3267
      365  256.05   NA    NA    NA   124.3800
      366  256.27   NA    NA    NA   124.9504
      367  256.48   NA    NA    NA   126.2623
      368  256.70   NA    NA    NA   122.9071
      369  256.92   NA    NA    NA   122.1693
      370  257.13   NA    NA    NA   128.9141
      371  257.35   NA    NA    NA   132.8340
      372  257.57   NA    NA    NA   125.3853
      373  257.78   NA    NA    NA   125.3613
      374  258.00   NA    NA    NA   125.4464
      375  258.21   NA    NA    NA   125.7236
      376  258.43   NA    NA    NA   126.8176
      377  258.65   NA    NA    NA   128.6286
      378  258.86   NA    NA    NA   124.5726
      379  259.08   NA    NA    NA   122.0034
      380  259.30   NA    NA    NA   123.7165
      381  259.51   NA    NA    NA   120.4325
      382  259.73   NA    NA    NA   124.9455
      383  259.95   NA    NA    NA   129.5809
      384  260.16   NA    NA    NA   122.1900
      385  260.38   NA    NA    NA   130.0267
      386  260.60   NA    NA    NA   121.3982
      387  260.81   NA    NA    NA   125.0000
      388  261.03   NA    NA    NA   123.9041
      389  261.25   NA    NA    NA   125.0898
      390  261.46   NA    NA    NA   127.6875
      391  261.68   NA    NA    NA   122.3386
      392  261.89   NA    NA    NA   127.3712
      393  262.11   NA    NA    NA   124.4626
      394  262.33   NA    NA    NA   124.7810
      395  262.54   NA    NA    NA   129.0364
      396  262.76   NA    NA    NA   129.3694
      397  262.98   NA    NA    NA   126.7967
      398  263.19   NA    NA    NA   130.2897
      399  263.41   NA    NA    NA   128.8213
      400  263.62   NA    NA    NA   128.2625
      401  263.84   NA    NA    NA   125.8740
      402  264.06   NA    NA    NA   125.0000
      403  264.27   NA    NA    NA   127.0216
      404  264.49   NA    NA    NA   129.6341
      405  264.71   NA    NA    NA   128.6414
      406  264.92   NA    NA    NA   123.5699
      407  265.14   NA    NA    NA   129.3078
      408  265.35   NA    NA    NA   129.4174
      409  265.57   NA    NA    NA   129.3413
      410  265.79   NA    NA    NA   135.0376
      411  266.00   NA    NA    NA   124.6253
      412  266.22   NA    NA    NA   132.9567
      413  266.43   NA    NA    NA   126.2355
      414  266.65   NA    NA    NA   128.5952
      415  266.87   NA    NA    NA   122.6337
      416  267.08   NA    NA    NA   126.3233
      417  267.30   NA    NA    NA   123.8438
      418  267.51   NA    NA    NA   126.9266
      419  267.73   NA    NA    NA   123.4439
      420  267.95   NA    NA    NA   126.3255
      421  268.16   NA    NA    NA   125.8743
      422  268.38   NA    NA    NA   123.1057
      423  268.59   NA    NA    NA   125.8014
      424  268.81   NA    NA    NA   124.8209
      425  269.03   NA    NA    NA   128.0827
      426  269.24   NA    NA    NA   129.2621
      427  269.46   NA    NA    NA   123.6313
      428  269.67   NA    NA    NA   127.9291
      429  269.89   NA    NA    NA   122.3324
      430  270.11   NA    NA    NA   125.8720
      431  270.32   NA    NA    NA   125.9229
      432  270.54   NA    NA    NA   127.1755
      433  270.75   NA    NA    NA   127.3990
      434  270.97   NA    NA    NA   128.9663
      435  271.19   NA    NA    NA   124.1308
      436  271.40   NA    NA    NA   125.1772
      437  271.62   NA    NA    NA   127.4416
      438  271.83   NA    NA    NA   126.3780
      439  272.05   NA    NA    NA   130.9099
      440  272.26   NA    NA    NA   128.4091
      441  272.48   NA    NA    NA   129.3512
      442  272.70   NA    NA    NA   128.9849
      443  272.91   NA    NA    NA   128.7928
      444  273.13   NA    NA    NA   124.8126
      445  273.34   NA    NA    NA   126.3626
      446  273.56   NA    NA    NA   129.5076
      447  273.77   NA    NA    NA   126.5698
      448  273.99   NA    NA    NA   126.1375
      449  274.21   NA    NA    NA   130.1842
      450  274.42   NA    NA    NA   128.6237
      451  274.64   NA    NA    NA   123.1324
      452  274.85   NA    NA    NA   127.4980
      453  275.07   NA    NA    NA   125.9827
      454  275.28   NA    NA    NA   127.1973
      455  275.50   NA    NA    NA   126.6822
      456  275.71   NA    NA    NA   128.9926
      457  275.93   NA    NA    NA   130.5210
      458  276.15   NA    NA    NA   128.9173
      459  276.36   NA    NA    NA   125.9853
      460  276.58   NA    NA    NA   125.3150
      461  276.79   NA    NA    NA   125.1426
      462  277.01   NA    NA    NA   123.8355
      463  277.22   NA    NA    NA   130.1487
      464  277.44   NA    NA    NA   126.8801
      465  277.65   NA    NA    NA   126.0382
      466  277.87   NA    NA    NA   126.0861
      467  278.08   NA    NA    NA   127.5922
      468  278.30   NA    NA    NA   128.2420
      469  278.52   NA    NA    NA   127.9401
      470  278.73   NA    NA    NA   128.6236
      471  278.95   NA    NA    NA   126.4802
      472  279.16   NA    NA    NA   126.6391
      473  279.38   NA    NA    NA   129.9401
      474  279.59   NA    NA    NA   126.3315
      475  279.81   NA    NA    NA   130.2204
      476  280.02   NA    NA    NA   125.8586
      477  280.24   NA    NA    NA   128.5504
      478  280.45   NA    NA    NA   123.4937
      479  280.67   NA    NA    NA   127.4003
      480  280.88   NA    NA    NA   129.0685
      481  281.10   NA    NA    NA   125.5038
      482  281.31   NA    NA    NA   125.0929
      483  281.53   NA    NA    NA   127.9758
      484  281.74   NA    NA    NA   127.0370
      485  281.96   NA    NA    NA   127.8806
      486  282.17   NA    NA    NA   130.7437
      487  282.39   NA    NA    NA   126.2415
      488  282.60   NA    NA    NA   129.4028
      489  282.82   NA    NA    NA   127.6229
      490  283.04   NA    NA    NA   129.3139
      491  283.25   NA    NA    NA   127.7713
      492  283.47   NA    NA    NA   127.1833
      493  283.68   NA    NA    NA   124.7505
      494  283.90   NA    NA    NA   126.7962
      495  284.11   NA    NA    NA   124.6256
      496  284.33   NA    NA    NA   127.9724
      497  284.54   NA    NA    NA   129.6994
      498  284.76   NA    NA    NA   130.3071
      499  284.97   NA    NA    NA   128.4476
      500  285.19   NA    NA    NA   127.4327
      501  285.40   NA    NA    NA   128.1168
      502  285.62   NA    NA    NA   124.9595
      503  285.83   NA    NA    NA   126.4729
      504  286.05   NA    NA    NA   129.8234
      505  286.26   NA    NA    NA   125.7466
      506  286.48   NA    NA    NA   130.8509
      507  286.69   NA    NA    NA   127.2313
      508  286.91   NA    NA    NA   126.6174
      509  287.12   NA    NA    NA   126.0303
      510  287.33   NA    NA    NA   128.8056
      511  287.55   NA    NA    NA   126.0393
      512  287.76   NA    NA    NA   126.6786
      513  287.98   NA    NA    NA   127.9540
      514  288.19   NA    NA    NA   125.3507
      515  288.41   NA    NA    NA   127.0270
      516  288.62   NA    NA    NA   128.0610
      517  288.84   NA    NA    NA   126.6278
      518  289.05   NA    NA    NA   129.3092
      519  289.27   NA    NA    NA   128.9046
      520  289.48   NA    NA    NA   129.1938
      521  289.70   NA    NA    NA   125.9211
      522  289.91   NA    NA    NA   129.9534
      523  290.13   NA    NA    NA   125.5814
      524  290.34   NA    NA    NA   127.3281
      525  290.56   NA    NA    NA   128.8786
      526  290.77   NA    NA    NA   124.3692
      527  290.99   NA    NA    NA   128.4469
      528  291.20   NA    NA    NA   127.4674
      529  291.41   NA    NA    NA   129.3954
      530  291.63   NA    NA    NA   128.2959
      531  291.84   NA    NA    NA   126.8977
      532  292.06   NA    NA    NA   128.5084
      533  292.27   NA    NA    NA   129.5416
      534  292.49   NA    NA    NA   128.6408
      535  292.70   NA    NA    NA   129.4612
      536  292.92   NA    NA    NA   124.7723
      537  293.13   NA    NA    NA   124.1875
      538  293.35   NA    NA    NA   125.6208
      539  293.56   NA    NA    NA   130.0394
      540  293.77   NA    NA    NA   128.7396
      541  293.99   NA    NA    NA   126.4392
      542  294.20   NA    NA    NA   126.5093
      543  294.42   NA    NA    NA   131.5589
      544  294.63   NA    NA    NA   126.2947
      545  294.85   NA    NA    NA   126.8721
      546  295.06   NA    NA    NA   127.4534
      547  295.28   NA    NA    NA   127.7108
      548  295.49   NA    NA    NA   127.6710
      549  295.70   NA    NA    NA   124.9966
      550  295.92   NA    NA    NA   126.5858
      551  296.13   NA    NA    NA   126.8905
      552  296.35   NA    NA    NA   126.1638
      553  296.56   NA    NA    NA   127.5222
      554  296.78   NA    NA    NA   127.5603
      555  296.99   NA    NA    NA   127.2607
      556  297.20   NA    NA    NA   130.0467
      557  297.42   NA    NA    NA   126.5339
      558  297.63   NA    NA    NA   129.2310
      559  297.85   NA    NA    NA   127.7169
      560  298.06   NA    NA    NA   128.8734
      561  298.28   NA    NA    NA   128.3461
      562  298.49   NA    NA    NA   125.6666
      563  298.70   NA    NA    NA   127.0715
      564  298.92   NA    NA    NA   126.0191
      565  299.13   NA    NA    NA   128.1106
      566  299.35   NA    NA    NA   128.4452
      567  299.56   NA    NA    NA   125.1684
      568  299.77   NA    NA    NA   127.4172
      569  299.99   NA    NA    NA   125.7999
      570  300.20   NA    NA    NA   128.7036
      571  300.42   NA    NA    NA   130.4903
      572  300.63   NA    NA    NA   127.0001
      573  300.85   NA    NA    NA   127.9261
      574  301.06   NA    NA    NA   123.9615
      575  301.27   NA    NA    NA   127.6852
      576  301.49   NA    NA    NA   128.3522
      577  301.70   NA    NA    NA   126.1338
      578  301.92   NA    NA    NA   127.4174
      579  302.13   NA    NA    NA   127.1235
      580  302.34   NA    NA    NA   127.0325
      581  302.56   NA    NA    NA   127.5774
      582  302.77   NA    NA    NA   128.6348
      583  302.99   NA    NA    NA   127.8411
      584  303.20   NA    NA    NA   128.7490
      585  303.41   NA    NA    NA   126.7015
      586  303.63   NA    NA    NA   125.6456
      587  303.84   NA    NA    NA   124.3342
      588  304.05   NA    NA    NA   129.1792
      589  304.27   NA    NA    NA   127.0763
      590  304.48   NA    NA    NA   122.5973
      591  304.70   NA    NA    NA   125.1867
      592  304.91   NA    NA    NA   129.1345
      593  305.12   NA    NA    NA   126.6554
      594  305.34   NA    NA    NA   125.3118
      595  305.55   NA    NA    NA   126.3981
      596  305.77   NA    NA    NA   128.5459
      597  305.98   NA    NA    NA   128.9626
      598  306.19   NA    NA    NA   128.9274
      599  306.41   NA    NA    NA   125.7026
      600  306.62   NA    NA    NA   125.9643
      601  306.83   NA    NA    NA   125.8909
      602  307.05   NA    NA    NA   124.8826
      603  307.26   NA    NA    NA   127.3924
      604  307.47   NA    NA    NA   126.5897
      605  307.69   NA    NA    NA   126.0715
      606  307.90   NA    NA    NA   126.6197
      607  308.12   NA    NA    NA   127.5647
      608  308.33   NA    NA    NA   124.9503
      609  308.54   NA    NA    NA   127.3524
      610  308.76   NA    NA    NA   126.4536
      611  308.97   NA    NA    NA   125.5489
      612  309.18   NA    NA    NA   127.1084
      613  309.40   NA    NA    NA   126.9662
      614  309.61   NA    NA    NA   125.5747
      615  309.82   NA    NA    NA   129.4321
      616  310.04   NA    NA    NA   126.6296
      617  310.25   NA    NA    NA   127.3082
      618  310.46   NA    NA    NA   125.2263
      619  310.68   NA    NA    NA   127.9986
      620  310.89   NA    NA    NA   125.3545
      621  311.11   NA    NA    NA   125.3213
      622  311.32   NA    NA    NA   126.7114
      623  311.53   NA    NA    NA   128.4156
      624  311.75   NA    NA    NA   128.0787
      625  311.96   NA    NA    NA   126.2303
      626  312.17   NA    NA    NA   126.6800
      627  312.39   NA    NA    NA   125.6711
      628  312.60   NA    NA    NA   126.7085
      629  312.81   NA    NA    NA   124.7381
      630  313.03   NA    NA    NA   126.9823
      631  313.24   NA    NA    NA   125.9964
      632  313.45   NA    NA    NA   126.3423
      633  313.67   NA    NA    NA   125.7802
      634  313.88   NA    NA    NA   126.6547
      635  314.09   NA    NA    NA   125.1045
      636  314.31   NA    NA    NA   127.7393
      637  314.52   NA    NA    NA   126.6160
      638  314.73   NA    NA    NA   125.9033
      639  314.95   NA    NA    NA   125.0177
      640  315.16   NA    NA    NA   127.7293
      641  315.37   NA    NA    NA   122.5679
      642  315.58   NA    NA    NA   128.5416
      643  315.80   NA    NA    NA   127.2089
      644  316.01   NA    NA    NA   125.9597
      645  316.22   NA    NA    NA   126.7981
      646  316.44   NA    NA    NA   124.8340
      647  316.65   NA    NA    NA   128.7281
      648  316.86   NA    NA    NA   127.0028
      649  317.08   NA    NA    NA   126.1038
      650  317.29   NA    NA    NA   125.4229
      651  317.50   NA    NA    NA   129.5484
      652  317.72   NA    NA    NA   125.5004
      653  317.93   NA    NA    NA   124.8562
      654  318.14   NA    NA    NA   125.6614
      655  318.35   NA    NA    NA   127.7312
      656  318.57   NA    NA    NA   125.8123
      657  318.78   NA    NA    NA   125.2564
      658  318.99   NA    NA    NA   125.4826
      659  319.21   NA    NA    NA   126.4019
      660  319.42   NA    NA    NA   126.0826
      661  319.63   NA    NA    NA   127.4512
      662  319.85   NA    NA    NA   126.2130
      663  320.06   NA    NA    NA   124.3918
      664  320.27   NA    NA    NA   126.8878
      665  320.48   NA    NA    NA   125.0547
      666  320.70   NA    NA    NA   126.4300
      667  320.91   NA    NA    NA   127.7812
      668  321.12   NA    NA    NA   125.3753
      669  321.34   NA    NA    NA   123.5357
      670  321.55   NA    NA    NA   124.7869
      671  321.76   NA    NA    NA   126.1668
      672  321.97   NA    NA    NA   126.3963
      673  322.19   NA    NA    NA   126.2901
      674  322.40   NA    NA    NA   124.3642
      675  322.61   NA    NA    NA   128.7458
      676  322.83   NA    NA    NA   127.8843
      677  323.04   NA    NA    NA   124.7397
      678  323.25   NA    NA    NA   125.6760
      679  323.46   NA    NA    NA   125.6590
      680  323.68   NA    NA    NA   126.1699
      681  323.89   NA    NA    NA   126.5885
      682  324.10   NA    NA    NA   126.3292
      683  324.31   NA    NA    NA   123.9697
      684  324.53   NA    NA    NA   124.4146
      685  324.74   NA    NA    NA   126.8833
      686  324.95   NA    NA    NA   125.3665
      687  325.16   NA    NA    NA   128.1339
      688  325.38   NA    NA    NA   126.5918
      689  325.59   NA    NA    NA   126.0056
      690  325.80   NA    NA    NA   126.1566
      691  326.01   NA    NA    NA   124.6426
      692  326.23   NA    NA    NA   125.0496
      693  326.44   NA    NA    NA   126.1498
      694  326.65   NA    NA    NA   125.7112
      695  326.86   NA    NA    NA   128.4489
      696  327.08   NA    NA    NA   123.5995
      697  327.29   NA    NA    NA   123.3967
      698  327.50   NA    NA    NA   125.7685
      699  327.71   NA    NA    NA   123.9455
      700  327.93   NA    NA    NA   124.7943
      701  328.14   NA    NA    NA   126.8516
      702  328.35   NA    NA    NA   125.2767
      703  328.56   NA    NA    NA   126.6044
      704  328.78   NA    NA    NA   125.1713
      705  328.99   NA    NA    NA   124.4687
      706  329.20   NA    NA    NA   126.3240
      707  329.41   NA    NA    NA   124.5019
      708  329.63   NA    NA    NA   126.4003
      709  329.84   NA    NA    NA   124.1367
      710  330.05   NA    NA    NA   126.8355
      711  330.26   NA    NA    NA   125.1807
      712  330.48   NA    NA    NA   125.1455
      713  330.69   NA    NA    NA   124.8715
      714  330.90   NA    NA    NA   124.5483
      715  331.11   NA    NA    NA   124.6141
      716  331.32   NA    NA    NA   125.4944
      717  331.54   NA    NA    NA   128.4369
      718  331.75   NA    NA    NA   129.2197
      719  331.96   NA    NA    NA   125.2790
      720  332.17   NA    NA    NA   126.9940
      721  332.39   NA    NA    NA   125.2091
      722  332.60   NA    NA    NA   124.9943
      723  332.81   NA    NA    NA   124.0840
      724  333.02   NA    NA    NA   125.1740
      725  333.23   NA    NA    NA   126.5690
      726  333.45   NA    NA    NA   123.0451
      727  333.66   NA    NA    NA   126.5092
      728  333.87   NA    NA    NA   129.9988
      729  334.08   NA    NA    NA   124.9229
      730  334.29   NA    NA    NA   125.5121
      731  334.51   NA    NA    NA   124.1123
      732  334.72   NA    NA    NA   127.1166
      733  334.93   NA    NA    NA   126.7777
      734  335.14   NA    NA    NA   124.0346
      735  335.35   NA    NA    NA   126.0559
      736  335.57   NA    NA    NA   125.9693
      737  335.78   NA    NA    NA   123.7997
      738  335.99   NA    NA    NA   125.4802
      739  336.20   NA    NA    NA   124.4721
      740  336.41   NA    NA    NA   124.1395
      741  336.63   NA    NA    NA   124.6003
      742  336.84   NA    NA    NA   124.2168
      743  337.05   NA    NA    NA   125.5343
      744  337.26   NA    NA    NA   124.6583
      745  337.47   NA    NA    NA   126.0938
      746  337.69   NA    NA    NA   125.4782
      747  337.90   NA    NA    NA   124.1007
      748  338.11   NA    NA    NA   124.8391
      749  338.32   NA    NA    NA   126.7909
      750  338.53   NA    NA    NA   125.0648
      751  338.74   NA    NA    NA   124.8540
      752  338.96   NA    NA    NA   122.3739
      753  339.17   NA    NA    NA   123.4893
      754  339.38   NA    NA    NA   124.1750
      755  339.59   NA    NA    NA   127.9789
      756  339.80   NA    NA    NA   123.8480
      757  340.01   NA    NA    NA   126.0428
      758  340.23   NA    NA    NA   125.6890
      759  340.44   NA    NA    NA   124.7478
      760  340.65   NA    NA    NA   124.9812
      761  340.86   NA    NA    NA   126.2230
      762  341.07   NA    NA    NA   125.0481
      763  341.28   NA    NA    NA   126.5351
      764  341.50   NA    NA    NA   125.6168
      765  341.71   NA    NA    NA   125.9696
      766  341.92   NA    NA    NA   124.4295
      767  342.13   NA    NA    NA   125.7020
      768  342.34   NA    NA    NA   125.0210
      769  342.55   NA    NA    NA   124.9407
      770  342.77   NA    NA    NA   124.3587
      771  342.98   NA    NA    NA   125.8957
      772  343.19   NA    NA    NA   124.6590
      773  343.40   NA    NA    NA   124.9627
      774  343.61   NA    NA    NA   125.0601
      775  343.82   NA    NA    NA   124.7689
      776  344.03   NA    NA    NA   124.0135
      777  344.25   NA    NA    NA   124.2979
      778  344.46   NA    NA    NA   126.2320
      779  344.67   NA    NA    NA   127.5387
      780  344.88   NA    NA    NA   124.5812
      781  345.09   NA    NA    NA   123.7299
      782  345.30   NA    NA    NA   122.6483
      783  345.51   NA    NA    NA   123.7893
      784  345.73   NA    NA    NA   123.1647
      785  345.94   NA    NA    NA   125.9430
      786  346.15   NA    NA    NA   124.6204
      787  346.36   NA    NA    NA   126.9757
      788  346.57   NA    NA    NA   125.2032
      789  346.78   NA    NA    NA   122.2686
      790  346.99   NA    NA    NA   124.9053
      791  347.21   NA    NA    NA   124.8915
      792  347.42   NA    NA    NA   127.1624
      793  347.63   NA    NA    NA   124.4209
      794  347.84   NA    NA    NA   123.0645
      795  348.05   NA    NA    NA   124.9155
      796  348.26   NA    NA    NA   124.5238
      797  348.47   NA    NA    NA   127.3079
      798  348.68   NA    NA    NA   125.6017
      799  348.89   NA    NA    NA   124.5995
      800  349.11   NA    NA    NA   123.5500
      801  349.32   NA    NA    NA   128.7230
      802  349.53   NA    NA    NA   125.8083
      803  349.74   NA    NA    NA   126.1519
      804  349.95   NA    NA    NA   124.7690
      805  350.16   NA    NA    NA   123.3434
      806  350.37   NA    NA    NA   123.5746
      807  350.58   NA    NA    NA   126.3033
      808  350.79   NA    NA    NA   124.4140
      809  351.01   NA    NA    NA   125.5146
      810  351.22   NA    NA    NA   124.1566
      811  351.43   NA    NA    NA   126.9849
      812  351.64   NA    NA    NA   124.9270
      813  351.85   NA    NA    NA   124.7355
      814  352.06   NA    NA    NA   123.2229
      815  352.27   NA    NA    NA   123.0787
      816  352.48   NA    NA    NA   121.3245
      817  352.69   NA    NA    NA   125.2259
      818  352.90   NA    NA    NA   127.6352
      819  353.12   NA    NA    NA   123.2315
      820  353.33   NA    NA    NA   124.8223
      821  353.54   NA    NA    NA   126.0014
      822  353.75   NA    NA    NA   126.5129
      823  353.96   NA    NA    NA   126.5733
      824  354.17   NA    NA    NA   126.9787
      825  354.38   NA    NA    NA   123.6138
      826  354.59   NA    NA    NA   125.2722
      827  354.80   NA    NA    NA   125.4543
      828  355.01   NA    NA    NA   125.6976
      829  355.22   NA    NA    NA   123.5369
      830  355.43   NA    NA    NA   121.3518
      831  355.64   NA    NA    NA   128.0248
      832  355.86   NA    NA    NA   123.1217
      833  356.07   NA    NA    NA   121.5905
      834  356.28   NA    NA    NA   122.8954
      835  356.49   NA    NA    NA   123.4929
      836  356.70   NA    NA    NA   124.6632
      837  356.91   NA    NA    NA   124.0263
      838  357.12   NA    NA    NA   125.0868
      839  357.33   NA    NA    NA   126.0389
      840  357.54   NA    NA    NA   122.5949
      841  357.75   NA    NA    NA   123.6942
      842  357.96   NA    NA    NA   128.5070
      843  358.17   NA    NA    NA   123.8523
      844  358.38   NA    NA    NA   126.1705
      845  358.59   NA    NA    NA   127.8220
      846  358.80   NA    NA    NA   123.3089
      847  359.02   NA    NA    NA   123.1356
      848  359.23   NA    NA    NA   125.3926
      849  359.44   NA    NA    NA   125.7059
      850  359.65   NA    NA    NA   125.7846
      851  359.86   NA    NA    NA   124.4690
      852  360.07   NA    NA    NA   125.1463
      853  360.28   NA    NA    NA   122.4023
      854  360.49   NA    NA    NA   124.8984
      855  360.70   NA    NA    NA   126.7362
      856  360.91   NA    NA    NA   123.1195
      857  361.12   NA    NA    NA   125.4854
      858  361.33   NA    NA    NA   124.4086
      859  361.54   NA    NA    NA   123.8439
      860  361.75   NA    NA    NA   125.7445
      861  361.96   NA    NA    NA   124.7117
      862  362.17   NA    NA    NA   124.2241
      863  362.38   NA    NA    NA   126.4443
      864  362.59   NA    NA    NA   123.2815
      865  362.80   NA    NA    NA   125.0586
      866  363.01   NA    NA    NA   123.4169
      867  363.22   NA    NA    NA   125.3576
      868  363.43   NA    NA    NA   125.0386
      869  363.64   NA    NA    NA   123.0686
      870  363.85   NA    NA    NA   125.3527
      871  364.06   NA    NA    NA   123.4214
      872  364.27   NA    NA    NA   126.3930
      873  364.48   NA    NA    NA   123.1387
      874  364.69   NA    NA    NA   126.1378
      875  364.90   NA    NA    NA   123.7081
      876  365.11   NA    NA    NA   125.3663
      877  365.33   NA    NA    NA   121.5736
      878  365.54   NA    NA    NA   123.2382
      879  365.75   NA    NA    NA   124.2740
      880  365.96   NA    NA    NA   124.0620
      881  366.17   NA    NA    NA   123.6710
      882  366.38   NA    NA    NA   123.4244
      883  366.59   NA    NA    NA   123.3656
      884  366.80   NA    NA    NA   123.9566
      885  367.01   NA    NA    NA   126.6751
      886  367.22   NA    NA    NA   124.1303
      887  367.43   NA    NA    NA   125.8977
      888  367.64   NA    NA    NA   122.9148
      889  367.85   NA    NA    NA   125.7642
      890  368.06   NA    NA    NA   126.8132
      891  368.27   NA    NA    NA   122.1969
      892  368.48   NA    NA    NA   122.1422
      893  368.69   NA    NA    NA   126.3645
      894  368.90   NA    NA    NA   124.8994
      895  369.11   NA    NA    NA   125.4207
      896  369.32   NA    NA    NA   125.3548
      897  369.53   NA    NA    NA   125.2129
      898  369.74   NA    NA    NA   123.5513
      899  369.94   NA    NA    NA   124.1945
      900  370.15   NA    NA    NA   123.9143
      901  370.36   NA    NA    NA   125.2056
      902  370.57   NA    NA    NA   124.9237
      903  370.78   NA    NA    NA   122.8381
      904  370.99   NA    NA    NA   126.6268
      905  371.20   NA    NA    NA   123.7177
      906  371.41   NA    NA    NA   123.7423
      907  371.62   NA    NA    NA   122.8898
      908  371.83   NA    NA    NA   124.6357
      909  372.04   NA    NA    NA   125.1775
      910  372.25   NA    NA    NA   122.6097
      911  372.46   NA    NA    NA   126.2095
      912  372.67   NA    NA    NA   125.5302
      913  372.88   NA    NA    NA   124.4052
      914  373.09   NA    NA    NA   124.6893
      915  373.30   NA    NA    NA   123.0797
      916  373.51   NA    NA    NA   122.7757
      917  373.72   NA    NA    NA   124.3300
      918  373.93   NA    NA    NA   122.9398
      919  374.14   NA    NA    NA   125.4986
      920  374.35   NA    NA    NA   126.1642
      921  374.56   NA    NA    NA   125.7588
      922  374.77   NA    NA    NA   124.3662
      923  374.98   NA    NA    NA   124.8208
      924  375.19   NA    NA    NA   124.9183
      925  375.40   NA    NA    NA   126.0236
      926  375.61   NA    NA    NA   123.6640
      927  375.82   NA    NA    NA   124.0415
      928  376.03   NA    NA    NA   122.8414
      929  376.23   NA    NA    NA   125.3977
      930  376.44   NA    NA    NA   123.2708
      931  376.65   NA    NA    NA   123.2788
      932  376.86   NA    NA    NA   124.6657
      933  377.07   NA    NA    NA   127.9398
      934  377.28   NA    NA    NA   124.6228
      935  377.49   NA    NA    NA   122.7323
      936  377.70   NA    NA    NA   123.7120
      937  377.91   NA    NA    NA   122.4689
      938  378.12   NA    NA    NA   124.1197
      939  378.33   NA    NA    NA   122.6840
      940  378.54   NA    NA    NA   123.5301
      941  378.75   NA    NA    NA   126.5753
      942  378.96   NA    NA    NA   126.1243
      943  379.17   NA    NA    NA   125.8615
      944  379.38   NA    NA    NA   124.7911
      945  379.58   NA    NA    NA   124.9745
      946  379.79   NA    NA    NA   124.5128
      947  380.00   NA    NA    NA   123.9282
      948  380.21   NA    NA    NA   125.1873
      949  380.42   NA    NA    NA   122.9263
      950  380.63   NA    NA    NA   125.0084
      951  380.84   NA    NA    NA   124.0192
      952  381.05   NA    NA    NA   126.1488
      953  381.26   NA    NA    NA   123.4192
      954  381.47   NA    NA    NA   125.1310
      955  381.68   NA    NA    NA   122.3487
      956  381.89   NA    NA    NA   124.1209
      957  382.09   NA    NA    NA   124.9593
      958  382.30   NA    NA    NA   125.1961
      959  382.51   NA    NA    NA   124.5387
      960  382.72   NA    NA    NA   124.0329
      961  382.93   NA    NA    NA   125.2612
      962  383.14   NA    NA    NA   122.3707
      963  383.35   NA    NA    NA   123.9541
      964  383.56   NA    NA    NA   124.7735
      965  383.77   NA    NA    NA   122.5172
      966  383.98   NA    NA    NA   124.7616
      967  384.18   NA    NA    NA   125.0852
      968  384.39   NA    NA    NA   123.6006
      969  384.60   NA    NA    NA   123.7263
      970  384.81   NA    NA    NA   122.8372
      971  385.02   NA    NA    NA   123.6723
      972  385.23   NA    NA    NA   123.2569
      973  385.44   NA    NA    NA   123.2098
      974  385.65   NA    NA    NA   124.7794
      975  385.86   NA    NA    NA   122.8337
      976  386.06   NA    NA    NA   126.3660
      977  386.27   NA    NA    NA   124.0754
      978  386.48   NA    NA    NA   123.6122
      979  386.69   NA    NA    NA   122.7419
      980  386.90   NA    NA    NA   123.9656
      981  387.11   NA    NA    NA   123.4939
      982  387.32   NA    NA    NA   124.5671
      983  387.53   NA    NA    NA   126.0574
      984  387.73   NA    NA    NA   124.5309
      985  387.94   NA    NA    NA   124.1490
      986  388.15   NA    NA    NA   124.8632
      987  388.36   NA    NA    NA   122.8167
      988  388.57   NA    NA    NA   123.9828
      989  388.78   NA    NA    NA   123.8863
      990  388.99   NA    NA    NA   125.1044
      991  389.20   NA    NA    NA   123.4068
      992  389.40   NA    NA    NA   125.9499
      993  389.61   NA    NA    NA   124.3120
      994  389.82   NA    NA    NA   125.0966
      995  390.03   NA    NA    NA   122.3050
      996  390.24   NA    NA    NA   123.3533
      997  390.45   NA    NA    NA   127.6425
      998  390.66   NA    NA    NA   123.9802
      999  390.86   NA    NA    NA   123.6205
      1000 391.07   NA    NA    NA   126.0144
      1001 391.28   NA    NA    NA   122.8050
      1002 391.49   NA    NA    NA   122.1286
      1003 391.70   NA    NA    NA   126.7153
      1004 391.91   NA    NA    NA   124.0943
      1005 392.12   NA    NA    NA   123.9953
      1006 392.32   NA    NA    NA   126.1652
      1007 392.53   NA    NA    NA   123.8254
      1008 392.74   NA    NA    NA   126.4668
      1009 392.95   NA    NA    NA   124.6635
      1010 393.16   NA    NA    NA   124.6111
      1011 393.37   NA    NA    NA   123.9596
      1012 393.57   NA    NA    NA   122.3850
      1013 393.78   NA    NA    NA   124.6531
      1014 393.99   NA    NA    NA   124.4569
      1015 394.20   NA    NA    NA   124.5709
      1016 394.41   NA    NA    NA   126.1540
      1017 394.62   NA    NA    NA   125.4286
      1018 394.82   NA    NA    NA   125.4753
      1019 395.03   NA    NA    NA   124.6782
      1020 395.24   NA    NA    NA   123.6129
      1021 395.45   NA    NA    NA   122.6278
      1022 395.66   NA    NA    NA   122.7112
      1023 395.87   NA    NA    NA   124.8527
      1024 396.07   NA    NA    NA   123.6234
      1025 396.28   NA    NA    NA   122.5844
      1026 396.49   NA    NA    NA   122.7684
      1027 396.70   NA    NA    NA   126.4332
      1028 396.91   NA    NA    NA   123.1596
      1029 397.11   NA    NA    NA   122.1045
      1030 397.32   NA    NA    NA   124.1301
      1031 397.53   NA    NA    NA   122.4520
      1032 397.74   NA    NA    NA   122.7745
      1033 397.95   NA    NA    NA   125.8087
      1034 398.16   NA    NA    NA   125.2049
      1035 398.36   NA    NA    NA   122.9563
      1036 398.57   NA    NA    NA   123.5471
      1037 398.78   NA    NA    NA   125.9805
      1038 398.99   NA    NA    NA   124.4991
      1039 399.20   NA    NA    NA   125.2249
      1040 399.40   NA    NA    NA   125.2168
      1041 399.61   NA    NA    NA   123.0135
      1042 399.82   NA    NA    NA   124.7976
      1043 400.03   NA    NA    NA   122.2645
      1044 400.24   NA    NA    NA   124.1197
      1045 400.44   NA    NA    NA   124.2180
      1046 400.65   NA    NA    NA   122.7531
      1047 400.86   NA    NA    NA   121.1541
      1048 401.07   NA    NA    NA   123.1479
      1049 401.27   NA    NA    NA   123.8495
      1050 401.48   NA    NA    NA   127.2829
      1051 401.69   NA    NA    NA   124.2613
      1052 401.90   NA    NA    NA   128.2026
      1053 402.11   NA    NA    NA   122.6500
      1054 402.31   NA    NA    NA   127.1783
      1055 402.52   NA    NA    NA   123.3273
      1056 402.73   NA    NA    NA   121.8973
      1057 402.94   NA    NA    NA   124.2951
      1058 403.15   NA    NA    NA   124.5067
      1059 403.35   NA    NA    NA   124.1291
      1060 403.56   NA    NA    NA   121.9239
      1061 403.77   NA    NA    NA   123.4145
      1062 403.98   NA    NA    NA   124.2292
      1063 404.18   NA    NA    NA   124.2045
      1064 404.39   NA    NA    NA   125.1278
      1065 404.60   NA    NA    NA   124.8486
      1066 404.81   NA    NA    NA   124.8762
      1067 405.01   NA    NA    NA   122.4743
      1068 405.22   NA    NA    NA   124.6259
      1069 405.43   NA    NA    NA   125.0152
      1070 405.64   NA    NA    NA   123.7332
      1071 405.85   NA    NA    NA   125.3852
      1072 406.05   NA    NA    NA   125.0000
      1073 406.26   NA    NA    NA   124.9382
      1074 406.47   NA    NA    NA   124.4142
      1075 406.68   NA    NA    NA   123.2627
      1076 406.88   NA    NA    NA   124.5919
      1077 407.09   NA    NA    NA   124.7810
      1078 407.30   NA    NA    NA   125.6649
      1079 407.51   NA    NA    NA   121.9067
      1080 407.71   NA    NA    NA   124.2737
      1081 407.92   NA    NA    NA   122.0667
      1082 408.13   NA    NA    NA   123.5309
      1083 408.34   NA    NA    NA   126.1802
      1084 408.54   NA    NA    NA   126.4559
      1085 408.75   NA    NA    NA   123.7502
      1086 408.96   NA    NA    NA   125.4345
      1087 409.16   NA    NA    NA   123.6309
      1088 409.37   NA    NA    NA   123.5844
      1089 409.58   NA    NA    NA   125.4972
      1090 409.79   NA    NA    NA   121.2578
      1091 409.99   NA    NA    NA   125.2163
      1092 410.20   NA    NA    NA   124.8553
      1093 410.41   NA    NA    NA   124.4679
      1094 410.62   NA    NA    NA   123.9890
      1095 410.82   NA    NA    NA   122.5875
      1096 411.03   NA    NA    NA   125.6478
      1097 411.24   NA    NA    NA   125.1235
      1098 411.45   NA    NA    NA   121.2190
      1099 411.65   NA    NA    NA   125.4397
      1100 411.86   NA    NA    NA   122.3252
      1101 412.07   NA    NA    NA   121.1711
      1102 412.27   NA    NA    NA   122.7562
      1103 412.48   NA    NA    NA   124.1136
      1104 412.69   NA    NA    NA   126.3199
      1105 412.90   NA    NA    NA   124.4742
      1106 413.10   NA    NA    NA   125.3014
      1107 413.31   NA    NA    NA   123.7508
      1108 413.52   NA    NA    NA   123.7167
      1109 413.72   NA    NA    NA   124.2899
      1110 413.93   NA    NA    NA   123.9286
      1111 414.14   NA    NA    NA   122.7039
      1112 414.35   NA    NA    NA   124.4515
      1113 414.55   NA    NA    NA   124.4126
      1114 414.76   NA    NA    NA   125.9899
      1115 414.97   NA    NA    NA   124.7499
      1116 415.17   NA    NA    NA   123.7539
      1117 415.38   NA    NA    NA   125.4208
      1118 415.59   NA    NA    NA   123.3211
      1119 415.79   NA    NA    NA   123.4525
      1120 416.00   NA    NA    NA   124.8094
      1121 416.21   NA    NA    NA   125.0033
      1122 416.41   NA    NA    NA   123.8408
      1123 416.62   NA    NA    NA   125.5681
      1124 416.83   NA    NA    NA   123.8899
      1125 417.04   NA    NA    NA   122.7279
      1126 417.24   NA    NA    NA   125.7774
      1127 417.45   NA    NA    NA   122.6141
      1128 417.66   NA    NA    NA   123.6454
      1129 417.86   NA    NA    NA   125.1333
      1130 418.07   NA    NA    NA   125.5870
      1131 418.28   NA    NA    NA   124.1974
      1132 418.48   NA    NA    NA   127.2058
      1133 418.69   NA    NA    NA   127.5423
      1134 418.90   NA    NA    NA   126.1948
      1135 419.10   NA    NA    NA   122.9496
      1136 419.31   NA    NA    NA   124.6753
      1137 419.52   NA    NA    NA   125.4552
      1138 419.72   NA    NA    NA   123.9021
      1139 419.93   NA    NA    NA   123.2924
      1140 420.14   NA    NA    NA   124.1583
      1141 420.34   NA    NA    NA   121.9220
      1142 420.55   NA    NA    NA   128.1551
      1143 420.76   NA    NA    NA   125.5414
      1144 420.96   NA    NA    NA   122.9285
      1145 421.17   NA    NA    NA   125.8501
      1146 421.38   NA    NA    NA   122.5810
      1147 421.58   NA    NA    NA   124.8640
      1148 421.79   NA    NA    NA   124.6379
      1149 422.00   NA    NA    NA   124.7181
      1150 422.20   NA    NA    NA   124.4522
      1151 422.41   NA    NA    NA   122.8605
      1152 422.62   NA    NA    NA   124.4199
      1153 422.82   NA    NA    NA   124.8547
      1154 423.03   NA    NA    NA   130.0419
      1155 423.24   NA    NA    NA   124.6186
      1156 423.44   NA    NA    NA   124.9316
      1157 423.65   NA    NA    NA   124.3887
      1158 423.85   NA    NA    NA   127.0640
      1159 424.06   NA    NA    NA   124.1204
      1160 424.27   NA    NA    NA   122.9203
      1161 424.47   NA    NA    NA   124.1649
      1162 424.68   NA    NA    NA   125.3246
      1163 424.89   NA    NA    NA   124.1761
      1164 425.09   NA    NA    NA   123.4167
      1165 425.30   NA    NA    NA   124.8438
      1166 425.51   NA    NA    NA   123.3656
      1167 425.71   NA    NA    NA   120.1845
      1168 425.92   NA    NA    NA   125.1994
      1169 426.12   NA    NA    NA   122.3251
      1170 426.33   NA    NA    NA   125.5799
      1171 426.54   NA    NA    NA   122.2807
      1172 426.74   NA    NA    NA   123.6886
      1173 426.95   NA    NA    NA   122.8564
      1174 427.16   NA    NA    NA   123.8203
      1175 427.36   NA    NA    NA   123.7872
      1176 427.57   NA    NA    NA   125.4318
      1177 427.77   NA    NA    NA   124.7161
      1178 427.98   NA    NA    NA   123.3408
      1179 428.19   NA    NA    NA   125.8677
      1180 428.39   NA    NA    NA   125.0305
      1181 428.60   NA    NA    NA   124.3326
      1182 428.81   NA    NA    NA   123.9161
      1183 429.01   NA    NA    NA   124.5077
      1184 429.22   NA    NA    NA   126.1913
      1185 429.42   NA    NA    NA   125.7216
      1186 429.63   NA    NA    NA   123.9687
      1187 429.84   NA    NA    NA   124.4287
      1188 430.04   NA    NA    NA   122.8857
      1189 430.25   NA    NA    NA   122.7796
      1190 430.45   NA    NA    NA   124.4908
      1191 430.66   NA    NA    NA   123.3409
      1192 430.87   NA    NA    NA   125.7437
      1193 431.07   NA    NA    NA   126.2676
      1194 431.28   NA    NA    NA   124.6143
      1195 431.48   NA    NA    NA   124.0868
      1196 431.69   NA    NA    NA   122.7415
      1197 431.90   NA    NA    NA   125.6629
      1198 432.10   NA    NA    NA   125.3728
      1199 432.31   NA    NA    NA   123.7935
      1200 432.51   NA    NA    NA   121.9326
      1201 432.72   NA    NA    NA   123.0028
      1202 432.92   NA    NA    NA   122.0353
      1203 433.13   NA    NA    NA   124.5864
      1204 433.34   NA    NA    NA   125.5870
      1205 433.54   NA    NA    NA   122.9518
      1206 433.75   NA    NA    NA   123.5243
      1207 433.95   NA    NA    NA   123.7415
      1208 434.16   NA    NA    NA   123.3235
      1209 434.37   NA    NA    NA   122.0076
      1210 434.57   NA    NA    NA   122.9652
      1211 434.78   NA    NA    NA   125.9240
      1212 434.98   NA    NA    NA   123.0163
      1213 435.19   NA    NA    NA   123.3383
      1214 435.39   NA    NA    NA   123.9912
      1215 435.60   NA    NA    NA   125.7657
      1216 435.81   NA    NA    NA   122.4566
      1217 436.01   NA    NA    NA   123.6028
      1218 436.22   NA    NA    NA   124.6344
      1219 436.42   NA    NA    NA   121.2952
      1220 436.63   NA    NA    NA   123.7394
      1221 436.83   NA    NA    NA   125.9372
      1222 437.04   NA    NA    NA   124.7388
      1223 437.24   NA    NA    NA   123.4447
      1224 437.45   NA    NA    NA   122.9796
      1225 437.66   NA    NA    NA   124.3815
      1226 437.86   NA    NA    NA   122.4633
      1227 438.07   NA    NA    NA   123.6585
      1228 438.27   NA    NA    NA   126.8865
      1229 438.48   NA    NA    NA   122.9671
      1230 438.68   NA    NA    NA   122.5057
      1231 438.89   NA    NA    NA   123.7679
      1232 439.09   NA    NA    NA   123.2163
      1233 439.30   NA    NA    NA   122.4062
      1234 439.50   NA    NA    NA   123.8449
      1235 439.71   NA    NA    NA   123.7261
      1236 439.92   NA    NA    NA   121.5704
      1237 440.12   NA    NA    NA   122.5012
      1238 440.33   NA    NA    NA   124.8402
      1239 440.53   NA    NA    NA   124.3808
      1240 440.74   NA    NA    NA   123.5001
      1241 440.94   NA    NA    NA   125.3671
      1242 441.15   NA    NA    NA   123.7855
      1243 441.35   NA    NA    NA   125.0998
      1244 441.56   NA    NA    NA   124.3038
      1245 441.76   NA    NA    NA   124.0566
      1246 441.97   NA    NA    NA   125.1985
      1247 442.17   NA    NA    NA   123.0849
      1248 442.38   NA    NA    NA   125.5882
      1249 442.58   NA    NA    NA   125.0453
      1250 442.79   NA    NA    NA   122.7554
      1251 443.00   NA    NA    NA   123.6759
      1252 443.20   NA    NA    NA   125.4372
      1253 443.41   NA    NA    NA   123.9666
      1254 443.61   NA    NA    NA   123.2781
      1255 443.82   NA    NA    NA   124.0151
      1256 444.02   NA    NA    NA   125.2563
      1257 444.23   NA    NA    NA   123.2710
      1258 444.43   NA    NA    NA   123.2203
      1259 444.64   NA    NA    NA   123.3121
      1260 444.84   NA    NA    NA   125.5582
      1261 445.05   NA    NA    NA   126.1593
      1262 445.25   NA    NA    NA   124.6763
      1263 445.46   NA    NA    NA   128.8703
      1264 445.66   NA    NA    NA   124.0470
      1265 445.87   NA    NA    NA   121.4667
      1266 446.07   NA    NA    NA   125.9476
      1267 446.28   NA    NA    NA   122.5661
      1268 446.48   NA    NA    NA   121.2174
      1269 446.69   NA    NA    NA   125.2159
      1270 446.89   NA    NA    NA   123.5914
      1271 447.10   NA    NA    NA   124.5824
      1272 447.30   NA    NA    NA   123.5310
      1273 447.51   NA    NA    NA   124.5864
      1274 447.71   NA    NA    NA   125.2740
      1275 447.92   NA    NA    NA   122.8912
      1276 448.12   NA    NA    NA   123.3596
      1277 448.33   NA    NA    NA   123.9746
      1278 448.53   NA    NA    NA   124.6006
      1279 448.73   NA    NA    NA   124.6781
      1280 448.94   NA    NA    NA   123.2805
      1281 449.14   NA    NA    NA   123.7827
      1282 449.35   NA    NA    NA   122.7496
      1283 449.55   NA    NA    NA   127.8433
      1284 449.76   NA    NA    NA   121.9760
      1285 449.96   NA    NA    NA   126.3249
      1286 450.17   NA    NA    NA   121.7206
      1287 450.37   NA    NA    NA   122.1198
      1288 450.58   NA    NA    NA   123.0418
      1289 450.78   NA    NA    NA   124.3003
      1290 450.99   NA    NA    NA   124.0030
      1291 451.19   NA    NA    NA   123.6942
      1292 451.40   NA    NA    NA   125.8401
      1293 451.60   NA    NA    NA   121.8382
      1294 451.81   NA    NA    NA   121.9677
      1295 452.01   NA    NA    NA   122.8881
      1296 452.21   NA    NA    NA   123.3212
      1297 452.42   NA    NA    NA   121.2477
      1298 452.62   NA    NA    NA   124.8377
      1299 452.83   NA    NA    NA   123.0793
      1300 453.03   NA    NA    NA   124.7480
      1301 453.24   NA    NA    NA   124.8997
      1302 453.44   NA    NA    NA   123.2296
      1303 453.65   NA    NA    NA   123.9405
      1304 453.85   NA    NA    NA   124.2105
      1305 454.06   NA    NA    NA   121.6986
      1306 454.26   NA    NA    NA   123.9060
      1307 454.46   NA    NA    NA   124.1723
      1308 454.67   NA    NA    NA   122.8796
      1309 454.87   NA    NA    NA   122.1622
      1310 455.08   NA    NA    NA   125.9382
      1311 455.28   NA    NA    NA   125.6339
      1312 455.49   NA    NA    NA   124.0594
      1313 455.69   NA    NA    NA   124.7494
      1314 455.89   NA    NA    NA   119.3084
      1315 456.10   NA    NA    NA   119.9969
      1316 456.30   NA    NA    NA   125.8257
      1317 456.51   NA    NA    NA   122.2691
      1318 456.71   NA    NA    NA   123.2320
      1319 456.92   NA    NA    NA   123.7296
      1320 457.12   NA    NA    NA   123.1250
      1321 457.32   NA    NA    NA   119.2331
      1322 457.53   NA    NA    NA   122.3934
      1323 457.73   NA    NA    NA   125.1375
      1324 457.94   NA    NA    NA   121.6801
      1325 458.14   NA    NA    NA   121.3790
      1326 458.35   NA    NA    NA   123.6896
      1327 458.55   NA    NA    NA   122.4146
      1328 458.75   NA    NA    NA   120.6965
      1329 458.96   NA    NA    NA   126.6603
      1330 459.16   NA    NA    NA   125.5564
      1331 459.37   NA    NA    NA   124.1643
      1332 459.57   NA    NA    NA   123.5432
      1333 459.77   NA    NA    NA   124.6249
      1334 459.98   NA    NA    NA   124.4483
      1335 460.18   NA    NA    NA   123.2014
      1336 460.39   NA    NA    NA   123.0661
      1337 460.59   NA    NA    NA   123.8735
      1338 460.79   NA    NA    NA   126.8300
      1339 461.00   NA    NA    NA   122.7699
      1340 461.20   NA    NA    NA   124.8072
      1341 461.41   NA    NA    NA   123.3747
      1342 461.61   NA    NA    NA   123.3991
      1343 461.81   NA    NA    NA   121.8389
      1344 462.02   NA    NA    NA   122.4301
      1345 462.22   NA    NA    NA   120.9949
      1346 462.43   NA    NA    NA   126.0550
      1347 462.63   NA    NA    NA   119.4689
      1348 462.83   NA    NA    NA   125.8425
      1349 463.04   NA    NA    NA   125.0971
      1350 463.24   NA    NA    NA   123.2879
      1351 463.45   NA    NA    NA   123.1795
      1352 463.65   NA    NA    NA   121.1643
      1353 463.85   NA    NA    NA   121.8352
      1354 464.06   NA    NA    NA   123.4623
      1355 464.26   NA    NA    NA   125.5652
      1356 464.46   NA    NA    NA   123.2664
      1357 464.67   NA    NA    NA   122.5508
      1358 464.87   NA    NA    NA   121.8174
      1359 465.08   NA    NA    NA   123.6970
      1360 465.28   NA    NA    NA   124.5713
      1361 465.48   NA    NA    NA   123.6866
      1362 465.69   NA    NA    NA   125.2691
      1363 465.89   NA    NA    NA   125.4422
      1364 466.09   NA    NA    NA   125.3140
      1365 466.30   NA    NA    NA   125.4156
      1366 466.50   NA    NA    NA   123.1148
      1367 466.71   NA    NA    NA   122.6531
      1368 466.91   NA    NA    NA   124.7383
      1369 467.11   NA    NA    NA   125.7161
      1370 467.32   NA    NA    NA   125.8259
      1371 467.52   NA    NA    NA   120.9842
      1372 467.72   NA    NA    NA   128.0253
      1373 467.93   NA    NA    NA   121.9818
      1374 468.13   NA    NA    NA   122.1106
      1375 468.33   NA    NA    NA   125.1040
      1376 468.54   NA    NA    NA   122.4542
      1377 468.74   NA    NA    NA   121.9648
      1378 468.94   NA    NA    NA   121.2131
      1379 469.15   NA    NA    NA   126.1133
      1380 469.35   NA    NA    NA   121.0003
      1381 469.55   NA    NA    NA   124.8508
      1382 469.76   NA    NA    NA   121.2853
      1383 469.96   NA    NA    NA   118.9588
      1384 470.17   NA    NA    NA   124.0035
      1385 470.37   NA    NA    NA   121.5332
      1386 470.57   NA    NA    NA   123.9089
      1387 470.78   NA    NA    NA   124.2507
      1388 470.98   NA    NA    NA   125.4843
      1389 471.18   NA    NA    NA   122.0538
      1390 471.39   NA    NA    NA   123.0663
      1391 471.59   NA    NA    NA   118.6112
      1392 471.79   NA    NA    NA   123.9563
      1393 471.99   NA    NA    NA   123.8497
      1394 472.20   NA    NA    NA   122.0074
      1395 472.40   NA    NA    NA   124.5040
      1396 472.60   NA    NA    NA   123.2021
      1397 472.81   NA    NA    NA   124.5984
      1398 473.01   NA    NA    NA   120.7010
      1399 473.21   NA    NA    NA   125.0000
      1400 473.42   NA    NA    NA   123.4202
      1401 473.62   NA    NA    NA   124.4885
      1402 473.82   NA    NA    NA   124.5157
      1403 474.03   NA    NA    NA   121.6646
      1404 474.23   NA    NA    NA   122.8117
      1405 474.43   NA    NA    NA   123.4586
      1406 474.64   NA    NA    NA   123.8392
      1407 474.84   NA    NA    NA   123.4083
      1408 475.04   NA    NA    NA   123.7845
      1409 475.25   NA    NA    NA   123.5070
      1410 475.45   NA    NA    NA   122.9667
      1411 475.65   NA    NA    NA   125.3431
      1412 475.85   NA    NA    NA   122.9224
      1413 476.06   NA    NA    NA   126.1820
      1414 476.26   NA    NA    NA   123.3698
      1415 476.46   NA    NA    NA   122.9660
      1416 476.67   NA    NA    NA   126.0748
      1417 476.87   NA    NA    NA   124.5023
      1418 477.07   NA    NA    NA   122.8144
      1419 477.28   NA    NA    NA   121.0989
      1420 477.48   NA    NA    NA   122.5420
      1421 477.68   NA    NA    NA   124.7406
      1422 477.88   NA    NA    NA   122.2414
      1423 478.09   NA    NA    NA   123.5294
      1424 478.29   NA    NA    NA   122.4262
      1425 478.49   NA    NA    NA   123.2812
      1426 478.70   NA    NA    NA   122.3737
      1427 478.90   NA    NA    NA   123.3534
      1428 479.10   NA    NA    NA   124.2268
      1429 479.30   NA    NA    NA   122.1401
      1430 479.51   NA    NA    NA   122.6461
      1431 479.71   NA    NA    NA   120.8959
      1432 479.91   NA    NA    NA   123.9950
      1433 480.11   NA    NA    NA   125.0837
      1434 480.32   NA    NA    NA   121.8442
      1435 480.52   NA    NA    NA   122.0730
      1436 480.72   NA    NA    NA   124.5007
      1437 480.93   NA    NA    NA   126.0665
      1438 481.13   NA    NA    NA   126.3687
      1439 481.33   NA    NA    NA   121.1328
      1440 481.53   NA    NA    NA   126.5592
      1441 481.74   NA    NA    NA   123.2872
      1442 481.94   NA    NA    NA   121.9448
      1443 482.14   NA    NA    NA   121.3820
      1444 482.34   NA    NA    NA   124.5682
      1445 482.55   NA    NA    NA   124.6230
      1446 482.75   NA    NA    NA   123.3575
      1447 482.95   NA    NA    NA   124.0853
      1448 483.15   NA    NA    NA   126.5163
      1449 483.36   NA    NA    NA   124.0398
      1450 483.56   NA    NA    NA   123.7726
      1451 483.76   NA    NA    NA   124.0431
      1452 483.96   NA    NA    NA   123.7477
      1453 484.17   NA    NA    NA   123.9821
      1454 484.37   NA    NA    NA   122.6178
      1455 484.57   NA    NA    NA   124.4773
      1456 484.77   NA    NA    NA   124.3833
      1457 484.98   NA    NA    NA   124.3678
      1458 485.18   NA    NA    NA   124.6008
      1459 485.38   NA    NA    NA   123.7382
      1460 485.58   NA    NA    NA   123.6483
      1461 485.79   NA    NA    NA   123.5130
      1462 485.99   NA    NA    NA   123.9019
      1463 486.19   NA    NA    NA   123.3414
      1464 486.39   NA    NA    NA   123.8418
      1465 486.59   NA    NA    NA   125.0354
      1466 486.80   NA    NA    NA   123.0859
      1467 487.00   NA    NA    NA   123.2958
      1468 487.20   NA    NA    NA   123.1979
      1469 487.40   NA    NA    NA   122.8618
      1470 487.61   NA    NA    NA   122.9982
      1471 487.81   NA    NA    NA   120.5803
      1472 488.01   NA    NA    NA   123.8153
      1473 488.21   NA    NA    NA   123.8003
      1474 488.41   NA    NA    NA   123.4099
      1475 488.62   NA    NA    NA   124.8518
      1476 488.82   NA    NA    NA   123.6761
      1477 489.02   NA    NA    NA   123.9743
      1478 489.22   NA    NA    NA   123.2640
      1479 489.43   NA    NA    NA   122.3746
      1480 489.63   NA    NA    NA   123.5507
      1481 489.83   NA    NA    NA   122.9160
      1482 490.03   NA    NA    NA   126.1023
      1483 490.23   NA    NA    NA   121.9584
      1484 490.44   NA    NA    NA   121.8949
      1485 490.64   NA    NA    NA   126.1982
      1486 490.84   NA    NA    NA   122.8644
      1487 491.04   NA    NA    NA   122.7766
      1488 491.24   NA    NA    NA   122.7651
      1489 491.45   NA    NA    NA   124.4202
      1490 491.65   NA    NA    NA   122.1141
      1491 491.85   NA    NA    NA   125.2117
      1492 492.05   NA    NA    NA   123.3719
      1493 492.25   NA    NA    NA   122.6373
      1494 492.45   NA    NA    NA   123.2709
      1495 492.66   NA    NA    NA   123.8693
      1496 492.86   NA    NA    NA   121.3058
      1497 493.06   NA    NA    NA   124.0175
      1498 493.26   NA    NA    NA   122.3767
      1499 493.46   NA    NA    NA   121.7158
      1500 493.67   NA    NA    NA   121.0373
      1501 493.87   NA    NA    NA   122.9180
      1502 494.07   NA    NA    NA   124.6329
      1503 494.27   NA    NA    NA   123.4119
      1504 494.47   NA    NA    NA   123.8172
      1505 494.67   NA    NA    NA   123.3308
      1506 494.88   NA    NA    NA   123.9629
      1507 495.08   NA    NA    NA   123.0149
      1508 495.28   NA    NA    NA   123.3582
      1509 495.48   NA    NA    NA   124.0347
      1510 495.68   NA    NA    NA   122.0734
      1511 495.89   NA    NA    NA   124.9377
      1512 496.09   NA    NA    NA   123.0769
      1513 496.29   NA    NA    NA   124.4089
      1514 496.49   NA    NA    NA   123.8615
      1515 496.69   NA    NA    NA   124.1471
      1516 496.89   NA    NA    NA   125.3505
      1517 497.09   NA    NA    NA   122.7688
      1518 497.30   NA    NA    NA   122.3932
      1519 497.50   NA    NA    NA   124.7962
      1520 497.70   NA    NA    NA   123.8707
      1521 497.90   NA    NA    NA   124.6515
      1522 498.10   NA    NA    NA   125.6414
      1523 498.30   NA    NA    NA   123.3301
      1524 498.51   NA    NA    NA   121.9081
      1525 498.71   NA    NA    NA   121.2990
      1526 498.91   NA    NA    NA   125.3937
      1527 499.11   NA    NA    NA   126.2421
      1528 499.31   NA    NA    NA   124.1662
      1529 499.51   NA    NA    NA   123.1822
      1530 499.71   NA    NA    NA   122.2562
      1531 499.92   NA    NA    NA   125.3913
      1532 500.12   NA    NA    NA   124.0325
      1533 500.32   NA    NA    NA   125.4545
      1534 500.52   NA    NA    NA   123.4948
      1535 500.72   NA    NA    NA   125.1505
      1536 500.92   NA    NA    NA   121.8746
      1537 501.12   NA    NA    NA   124.0040
      1538 501.32   NA    NA    NA   123.6618
      1539 501.53   NA    NA    NA   123.4569
      1540 501.73   NA    NA    NA   123.5533
      1541 501.93   NA    NA    NA   123.9638
      1542 502.13   NA    NA    NA   124.4552
      1543 502.33   NA    NA    NA   121.5517
      1544 502.53   NA    NA    NA   123.9015
      1545 502.73   NA    NA    NA   124.7146
      1546 502.93   NA    NA    NA   124.0657
      1547 503.14   NA    NA    NA   123.4912
      1548 503.34   NA    NA    NA   122.9981
      1549 503.54   NA    NA    NA   125.1042
      1550 503.74   NA    NA    NA   122.7325
      1551 503.94   NA    NA    NA   123.3708
      1552 504.14   NA    NA    NA   124.3377
      1553 504.34   NA    NA    NA   122.9317
      1554 504.54   NA    NA    NA   123.8570
      1555 504.74   NA    NA    NA   119.9226
      1556 504.95   NA    NA    NA   122.6816
      1557 505.15   NA    NA    NA   125.1622
      1558 505.35   NA    NA    NA   123.6474
      1559 505.55   NA    NA    NA   122.7058
      1560 505.75   NA    NA    NA   125.0773
      1561 505.95   NA    NA    NA   122.4104
      1562 506.15   NA    NA    NA   123.4211
      1563 506.35   NA    NA    NA   125.4194
      1564 506.55   NA    NA    NA   121.2353
      1565 506.75   NA    NA    NA   124.5139
      1566 506.95   NA    NA    NA   122.2664
      1567 507.16   NA    NA    NA   122.6960
      1568 507.36   NA    NA    NA   122.4317
      1569 507.56   NA    NA    NA   122.5779
      1570 507.76   NA    NA    NA   124.1263
      1571 507.96   NA    NA    NA   124.9578
      1572 508.16   NA    NA    NA   122.4289
      1573 508.36   NA    NA    NA   122.4267
      1574 508.56   NA    NA    NA   123.8236
      1575 508.76   NA    NA    NA   126.8303
      1576 508.96   NA    NA    NA   121.7301
      1577 509.16   NA    NA    NA   122.3826
      1578 509.36   NA    NA    NA   124.1226
      1579 509.57   NA    NA    NA   125.0179
      1580 509.77   NA    NA    NA   125.9559
      1581 509.97   NA    NA    NA   125.0853
      1582 510.17   NA    NA    NA   126.1556
      1583 510.37   NA    NA    NA   124.7905
      1584 510.57   NA    NA    NA   122.4664
      1585 510.77   NA    NA    NA   123.3696
      1586 510.97   NA    NA    NA   126.5351
      1587 511.17   NA    NA    NA   124.8138
      1588 511.37   NA    NA    NA   125.4126
      1589 511.57   NA    NA    NA   122.6410
      1590 511.77   NA    NA    NA   126.0123
      1591 511.97   NA    NA    NA   120.0229
      1592 512.17   NA    NA    NA   121.9844
      1593 512.37   NA    NA    NA   120.7999
      1594 512.57   NA    NA    NA   124.8551
      1595 512.78   NA    NA    NA   121.8490
      1596 512.98   NA    NA    NA   123.6716
      1597 513.18   NA    NA    NA   123.6593
      1598 513.38   NA    NA    NA   122.0959
      1599 513.58   NA    NA    NA   124.6707
      1600 513.78   NA    NA    NA   125.0491
      1601 513.98   NA    NA    NA   123.5879
      1602 514.18   NA    NA    NA   123.1161
      1603 514.38   NA    NA    NA   125.3892
      1604 514.58   NA    NA    NA   129.0470
      1605 514.78   NA    NA    NA   124.3503
      1606 514.98   NA    NA    NA   127.0700
      1607 515.18   NA    NA    NA   123.8300
      1608 515.38   NA    NA    NA   126.0602
      1609 515.58   NA    NA    NA   123.4634
      1610 515.78   NA    NA    NA   125.7267
      1611 515.98   NA    NA    NA   122.0521
      1612 516.18   NA    NA    NA   124.8960
      1613 516.38   NA    NA    NA   123.1589
      1614 516.58   NA    NA    NA   125.5803
      1615 516.78   NA    NA    NA   124.7402
      1616 516.98   NA    NA    NA   122.8973
      1617 517.18   NA    NA    NA   126.3876
      1618 517.38   NA    NA    NA   121.4100
      1619 517.58   NA    NA    NA   125.5940
      1620 517.78   NA    NA    NA   125.8271
      1621 517.98   NA    NA    NA   123.5294
      1622 518.18   NA    NA    NA   126.0937
      1623 518.38   NA    NA    NA   124.8840
      1624 518.58   NA    NA    NA   121.3986
      1625 518.78   NA    NA    NA   121.6039
      1626 518.98   NA    NA    NA   126.2355
      1627 519.18   NA    NA    NA   119.3305
      1628 519.38   NA    NA    NA   123.2033
      1629 519.58   NA    NA    NA   120.6833
      1630 519.78   NA    NA    NA   123.7691
      1631 519.98   NA    NA    NA   123.0169
      1632 520.18   NA    NA    NA   120.4722
      1633 520.38   NA    NA    NA   122.2381
      1634 520.58   NA    NA    NA   123.8377
      1635 520.78   NA    NA    NA   121.9728
      1636 520.98   NA    NA    NA   121.4920
      1637 521.18   NA    NA    NA   122.0239
      1638 521.38   NA    NA    NA   125.7355
      1639 521.58   NA    NA    NA   123.6104
      1640 521.78   NA    NA    NA   128.7508
      1641 521.98   NA    NA    NA   122.6551
      1642 522.18   NA    NA    NA   124.8400
      1643 522.38   NA    NA    NA   124.7728
      1644 522.58   NA    NA    NA   125.6982
      1645 522.78   NA    NA    NA   123.9807
      1646 522.98   NA    NA    NA   122.8238
      1647 523.18   NA    NA    NA   124.7237
      1648 523.38   NA    NA    NA   122.5103
      1649 523.58   NA    NA    NA   121.8789
      1650 523.78   NA    NA    NA   121.0071
      1651 523.98   NA    NA    NA   124.6745
      1652 524.18   NA    NA    NA   125.1301
      1653 524.38   NA    NA    NA   124.5417
      1654 524.58   NA    NA    NA   125.4014
      1655 524.78   NA    NA    NA   128.2166
      1656 524.98   NA    NA    NA   126.4154
      1657 525.18   NA    NA    NA   123.3510
      1658 525.38   NA    NA    NA   122.9391
      1659 525.58   NA    NA    NA   127.1591
      1660 525.78   NA    NA    NA   122.6931
      1661 525.98   NA    NA    NA   122.5433
      1662 526.18   NA    NA    NA   123.6355
      1663 526.38   NA    NA    NA   126.0693
      1664 526.58   NA    NA    NA   122.0723
      1665 526.78   NA    NA    NA   124.7165
      1666 526.98   NA    NA    NA   123.3313
      1667 527.17   NA    NA    NA   121.7372
      1668 527.37   NA    NA    NA   120.5785
      1669 527.57   NA    NA    NA   123.9505
      1670 527.77   NA    NA    NA   123.8622
      1671 527.97   NA    NA    NA   125.2722
      1672 528.17   NA    NA    NA   121.4862
      1673 528.37   NA    NA    NA   125.8144
      1674 528.57   NA    NA    NA   122.5787
      1675 528.77   NA    NA    NA   124.4033
      1676 528.97   NA    NA    NA   121.8386
      1677 529.17   NA    NA    NA   120.6860
      1678 529.37   NA    NA    NA   125.2313
      1679 529.57   NA    NA    NA   120.8439
      1680 529.77   NA    NA    NA   122.0848
      1681 529.97   NA    NA    NA   122.8057
      1682 530.17   NA    NA    NA   119.6470
      1683 530.36   NA    NA    NA   123.9213
      1684 530.56   NA    NA    NA   125.7817
      1685 530.76   NA    NA    NA   125.2506
      1686 530.96   NA    NA    NA   124.2982
      1687 531.16   NA    NA    NA   125.2528
      1688 531.36   NA    NA    NA   122.9907
      1689 531.56   NA    NA    NA   123.7703
      1690 531.76   NA    NA    NA   123.7015
      1691 531.96   NA    NA    NA   123.2998
      1692 532.16   NA    NA    NA   122.8162
      1693 532.36   NA    NA    NA   125.3377
      1694 532.56   NA    NA    NA   122.8797
      1695 532.76   NA    NA    NA   121.6634
      1696 532.95   NA    NA    NA   124.6620
      1697 533.15   NA    NA    NA   125.2082
      1698 533.35   NA    NA    NA   124.3365
      1699 533.55   NA    NA    NA   123.1049
      1700 533.75   NA    NA    NA   121.2262
      1701 533.95   NA    NA    NA   126.5496
      1702 534.15   NA    NA    NA   123.6780
      1703 534.35   NA    NA    NA   125.4628
      1704 534.55   NA    NA    NA   120.4101
      1705 534.75   NA    NA    NA   122.8934
      1706 534.94   NA    NA    NA   124.2369
      1707 535.14   NA    NA    NA   123.8785
      1708 535.34   NA    NA    NA   124.8174
      1709 535.54   NA    NA    NA   122.2970
      1710 535.74   NA    NA    NA   124.0561
      1711 535.94   NA    NA    NA   122.7761
      1712 536.14   NA    NA    NA   120.6262
      1713 536.34   NA    NA    NA   125.4123
      1714 536.54   NA    NA    NA   120.6179
      1715 536.73   NA    NA    NA   123.8523
      1716 536.93   NA    NA    NA   123.4911
      1717 537.13   NA    NA    NA   122.4749
      1718 537.33   NA    NA    NA   124.3126
      1719 537.53   NA    NA    NA   121.6889
      1720 537.73   NA    NA    NA   123.4075
      1721 537.93   NA    NA    NA   122.8917
      1722 538.13   NA    NA    NA   124.2954
      1723 538.32   NA    NA    NA   123.0051
      1724 538.52   NA    NA    NA   121.9941
      1725 538.72   NA    NA    NA   123.4958
      1726 538.92   NA    NA    NA   122.6638
      1727 539.12   NA    NA    NA   125.0168
      1728 539.32   NA    NA    NA   123.1804
      1729 539.52   NA    NA    NA   122.3317
      1730 539.72   NA    NA    NA   121.1895
      1731 539.91   NA    NA    NA   124.4274
      1732 540.11   NA    NA    NA   122.2043
      1733 540.31   NA    NA    NA   120.3372
      1734 540.51   NA    NA    NA   118.8202
      1735 540.71   NA    NA    NA   122.9882
      1736 540.91   NA    NA    NA   126.6531
      1737 541.11   NA    NA    NA   124.0496
      1738 541.30   NA    NA    NA   121.6087
      1739 541.50   NA    NA    NA   125.0469
      1740 541.70   NA    NA    NA   123.2950
      1741 541.90   NA    NA    NA   124.5507
      1742 542.10   NA    NA    NA   121.0519
      1743 542.30   NA    NA    NA   123.5761
      1744 542.49   NA    NA    NA   121.1501
      1745 542.69   NA    NA    NA   122.9683
      1746 542.89   NA    NA    NA   121.1055
      1747 543.09   NA    NA    NA   122.1438
      1748 543.29   NA    NA    NA   122.3988
      1749 543.49   NA    NA    NA   123.0508
      1750 543.68   NA    NA    NA   121.5909
      1751 543.88   NA    NA    NA   126.7463
      1752 544.08   NA    NA    NA   119.6938
      1753 544.28   NA    NA    NA   119.3457
      1754 544.48   NA    NA    NA   119.8157
      1755 544.68   NA    NA    NA   122.8107
      1756 544.87   NA    NA    NA   121.8697
      1757 545.07   NA    NA    NA   120.2834
      1758 545.27   NA    NA    NA   119.2677
      1759 545.47   NA    NA    NA   124.1295
      1760 545.67   NA    NA    NA   123.9630
      1761 545.87   NA    NA    NA   125.2756
      1762 546.06   NA    NA    NA   123.7191
      1763 546.26   NA    NA    NA   120.4282
      1764 546.46   NA    NA    NA   124.2544
      1765 546.66   NA    NA    NA   118.1437
      1766 546.86   NA    NA    NA   122.5948
      1767 547.05   NA    NA    NA   122.4402
      1768 547.25   NA    NA    NA   122.5617
      1769 547.45   NA    NA    NA   120.9752
      1770 547.65   NA    NA    NA   121.0142
      1771 547.85   NA    NA    NA   124.5288
      1772 548.04   NA    NA    NA   121.3632
      1773 548.24   NA    NA    NA   120.2674
      1774 548.44   NA    NA    NA   123.3232
      1775 548.64   NA    NA    NA   123.7797
      1776 548.84   NA    NA    NA   121.2962
      1777 549.03   NA    NA    NA   125.2606
      1778 549.23   NA    NA    NA   124.6452
      1779 549.43   NA    NA    NA   124.6437
      1780 549.63   NA    NA    NA   122.0738
      1781 549.83   NA    NA    NA   124.3163
      1782 550.02   NA    NA    NA   122.9670
      1783 550.22   NA    NA    NA   122.9924
      1784 550.42   NA    NA    NA   121.6102
      1785 550.62   NA    NA    NA   122.4187
      1786 550.82   NA    NA    NA   123.7870
      1787 551.01   NA    NA    NA   122.2698
      1788 551.21   NA    NA    NA   124.5007
      1789 551.41   NA    NA    NA   123.7160
      1790 551.61   NA    NA    NA   124.3939
      1791 551.80   NA    NA    NA   122.1363
      1792 552.00   NA    NA    NA   123.5374
      1793 552.20   NA    NA    NA   124.6934
      1794 552.40   NA    NA    NA   122.8207
      1795 552.60   NA    NA    NA   122.5222
      1796 552.79   NA    NA    NA   125.3413
      1797 552.99   NA    NA    NA   124.4089
      1798 553.19   NA    NA    NA   124.0183
      1799 553.39   NA    NA    NA   121.7414
      1800 553.58   NA    NA    NA   122.4935
      1801 553.78   NA    NA    NA   124.1028
      1802 553.98   NA    NA    NA   122.0167
      1803 554.18   NA    NA    NA   122.4930
      1804 554.37   NA    NA    NA   122.1051
      1805 554.57   NA    NA    NA   126.5222
      1806 554.77   NA    NA    NA   123.3717
      1807 554.97   NA    NA    NA   122.6230
      1808 555.16   NA    NA    NA   122.4388
      1809 555.36   NA    NA    NA   123.7381
      1810 555.56   NA    NA    NA   122.2681
      1811 555.76   NA    NA    NA   120.6435
      1812 555.95   NA    NA    NA   121.8242
      1813 556.15   NA    NA    NA   124.2495
      1814 556.35   NA    NA    NA   121.9598
      1815 556.55   NA    NA    NA   122.5722
      1816 556.74   NA    NA    NA   120.0054
      1817 556.94   NA    NA    NA   124.5706
      1818 557.14   NA    NA    NA   124.4368
      1819 557.34   NA    NA    NA   124.5633
      1820 557.53   NA    NA    NA   123.3031
      1821 557.73   NA    NA    NA   122.7037
      1822 557.93   NA    NA    NA   123.6753
      1823 558.13   NA    NA    NA   124.0232
      1824 558.32   NA    NA    NA   124.7365
      1825 558.52   NA    NA    NA   118.5443
      1826 558.72   NA    NA    NA   121.8841
      1827 558.92   NA    NA    NA   125.1341
      1828 559.11   NA    NA    NA   125.9060
      1829 559.31   NA    NA    NA   121.9324
      1830 559.51   NA    NA    NA   123.9530
      1831 559.70   NA    NA    NA   123.9879
      1832 559.90   NA    NA    NA   125.8830
      1833 560.10   NA    NA    NA   123.7071
      1834 560.30   NA    NA    NA   123.9381
      1835 560.49   NA    NA    NA   124.4138
      1836 560.69   NA    NA    NA   121.3469
      1837 560.89   NA    NA    NA   123.3874
      1838 561.08   NA    NA    NA   122.5932
      1839 561.28   NA    NA    NA   124.4962
      1840 561.48   NA    NA    NA   123.5538
      1841 561.68   NA    NA    NA   124.3254
      1842 561.87   NA    NA    NA   124.7405
      1843 562.07   NA    NA    NA   124.1917
      1844 562.27   NA    NA    NA   124.9396
      1845 562.46   NA    NA    NA   124.1534
      1846 562.66   NA    NA    NA   121.6308
      1847 562.86   NA    NA    NA   123.0022
      1848 563.05   NA    NA    NA   124.4218
      1849 563.25   NA    NA    NA   125.0785
      1850 563.45   NA    NA    NA   122.1637
      1851 563.65   NA    NA    NA   123.4777
      1852 563.84   NA    NA    NA   125.8516
      1853 564.04   NA    NA    NA   121.3667
      1854 564.24   NA    NA    NA   124.0509
      1855 564.43   NA    NA    NA   128.4076
      1856 564.63   NA    NA    NA   123.6898
      1857 564.83   NA    NA    NA   122.2669
      1858 565.02   NA    NA    NA   124.4333
      1859 565.22   NA    NA    NA   123.5288
      1860 565.42   NA    NA    NA   121.7970
      1861 565.61   NA    NA    NA   125.2345
      1862 565.81   NA    NA    NA   122.3106
      1863 566.01   NA    NA    NA   123.3932
      1864 566.20   NA    NA    NA   123.5993
      1865 566.40   NA    NA    NA   124.5918
      1866 566.60   NA    NA    NA   123.5043
      1867 566.79   NA    NA    NA   123.2620
      1868 566.99   NA    NA    NA   121.4479
      1869 567.19   NA    NA    NA   121.9242
      1870 567.38   NA    NA    NA   124.7871
      1871 567.58   NA    NA    NA   124.4386
      1872 567.78   NA    NA    NA   123.5289
      1873 567.97   NA    NA    NA   125.4976
      1874 568.17   NA    NA    NA   123.7980
      1875 568.37   NA    NA    NA   123.4201
      1876 568.56   NA    NA    NA   124.4760
      1877 568.76   NA    NA    NA   123.6570
      1878 568.96   NA    NA    NA   124.5189
      1879 569.15   NA    NA    NA   124.0439
      1880 569.35   NA    NA    NA   124.0185
      1881 569.55   NA    NA    NA   123.8104
      1882 569.74   NA    NA    NA   122.8333
      1883 569.94   NA    NA    NA   125.7267
      1884 570.14   NA    NA    NA   124.3150
      1885 570.33   NA    NA    NA   123.8420
      1886 570.53   NA    NA    NA   124.9602
      1887 570.73   NA    NA    NA   122.9705
      1888 570.92   NA    NA    NA   122.7285
      1889 571.12   NA    NA    NA   124.2935
      1890 571.31   NA    NA    NA   122.8431
      1891 571.51   NA    NA    NA   123.1808
      1892 571.71   NA    NA    NA   123.6678
      1893 571.90   NA    NA    NA   124.5457
      1894 572.10   NA    NA    NA   124.3752
      1895 572.30   NA    NA    NA   124.4662
      1896 572.49   NA    NA    NA   123.6056
      1897 572.69   NA    NA    NA   124.0445
      1898 572.88   NA    NA    NA   123.1494
      1899 573.08   NA    NA    NA   124.1003
      1900 573.28   NA    NA    NA   124.6737
      1901 573.47   NA    NA    NA   123.0818
      1902 573.67   NA    NA    NA   123.9903
      1903 573.87   NA    NA    NA   124.1777
      1904 574.06   NA    NA    NA   122.9324
      1905 574.26   NA    NA    NA   124.0887
      1906 574.45   NA    NA    NA   123.9692
      1907 574.65   NA    NA    NA   123.2717
      1908 574.85   NA    NA    NA   122.9100
      1909 575.04   NA    NA    NA   121.8493
      1910 575.24   NA    NA    NA   123.7346
      1911 575.44   NA    NA    NA   124.0813
      1912 575.63   NA    NA    NA   124.0123
      1913 575.83   NA    NA    NA   123.7588
      1914 576.02   NA    NA    NA   123.2810
      1915 576.22   NA    NA    NA   124.1326
      1916 576.42   NA    NA    NA   122.4319
      1917 576.61   NA    NA    NA   124.3592
      1918 576.81   NA    NA    NA   123.5456
      1919 577.00   NA    NA    NA   124.4145
      1920 577.20   NA    NA    NA   124.3382
      1921 577.40   NA    NA    NA   123.7491
      1922 577.59   NA    NA    NA   123.0273
      1923 577.79   NA    NA    NA   123.6884
      1924 577.98   NA    NA    NA   123.3800
      1925 578.18   NA    NA    NA   123.0778
      1926 578.37   NA    NA    NA   124.7772
      1927 578.57   NA    NA    NA   121.7543
      1928 578.77   NA    NA    NA   123.4698
      1929 578.96   NA    NA    NA   124.8141
      1930 579.16   NA    NA    NA   122.9915
      1931 579.35   NA    NA    NA   123.5673
      1932 579.55   NA    NA    NA   123.0338
      1933 579.75   NA    NA    NA   124.4083
      1934 579.94   NA    NA    NA   123.2083
      1935 580.14   NA    NA    NA   123.6959
      1936 580.33   NA    NA    NA   123.0472
      1937 580.53   NA    NA    NA   123.7013
      1938 580.72   NA    NA    NA   123.7237
      1939 580.92   NA    NA    NA   123.6559
      1940 581.12   NA    NA    NA   122.9883
      1941 581.31   NA    NA    NA   124.7458
      1942 581.51   NA    NA    NA   123.2877
      1943 581.70   NA    NA    NA   123.5066
      1944 581.90   NA    NA    NA   122.7559
      1945 582.09   NA    NA    NA   124.3293
      1946 582.29   NA    NA    NA   122.9695
      1947 582.48   NA    NA    NA   123.9753
      1948 582.68   NA    NA    NA   123.4323
      1949 582.88   NA    NA    NA   123.6568
      1950 583.07   NA    NA    NA   123.2905
      1951 583.27   NA    NA    NA   123.8041
      1952 583.46   NA    NA    NA   123.5303
      1953 583.66   NA    NA    NA   121.8202
      1954 583.85   NA    NA    NA   123.6789
      1955 584.05   NA    NA    NA   123.7576
      1956 584.24   NA    NA    NA   124.3857
      1957 584.44   NA    NA    NA   122.6063
      1958 584.63   NA    NA    NA   122.9674
      1959 584.83   NA    NA    NA   123.1461
      1960 585.03   NA    NA    NA   123.1769
      1961 585.22   NA    NA    NA   123.3652
      1962 585.42   NA    NA    NA   124.1230
      1963 585.61   NA    NA    NA   123.8233
      1964 585.81   NA    NA    NA   124.3412
      1965 586.00   NA    NA    NA   122.9158
      1966 586.20   NA    NA    NA   123.3831
      1967 586.39   NA    NA    NA   121.9876
      1968 586.59   NA    NA    NA   122.2513
      1969 586.78   NA    NA    NA   124.1852
      1970 586.98   NA    NA    NA   121.6770
      1971 587.17   NA    NA    NA   123.1345
      1972 587.37   NA    NA    NA   122.7504
      1973 587.56   NA    NA    NA   123.2344
      1974 587.76   NA    NA    NA   123.9763
      1975 587.95   NA    NA    NA   123.1418
      1976 588.15   NA    NA    NA   122.4945
      1977 588.34   NA    NA    NA   123.4838
      1978 588.54   NA    NA    NA   122.8564
      1979 588.74   NA    NA    NA   122.5341
      1980 588.93   NA    NA    NA   121.9043
      1981 589.13   NA    NA    NA   123.1838
      1982 589.32   NA    NA    NA   123.0383
      1983 589.52   NA    NA    NA   122.3420
      1984 589.71   NA    NA    NA   123.9697
      1985 589.91   NA    NA    NA   122.6080
      1986 590.10   NA    NA    NA   124.1211
      1987 590.30   NA    NA    NA   122.1801
      1988 590.49   NA    NA    NA   121.4178
      1989 590.69   NA    NA    NA   122.6400
      1990 590.88   NA    NA    NA   124.2302
      1991 591.08   NA    NA    NA   123.6994
      1992 591.27   NA    NA    NA   123.6614
      1993 591.47   NA    NA    NA   121.5812
      1994 591.66   NA    NA    NA   122.4261
      1995 591.85   NA    NA    NA   121.9091
      1996 592.05   NA    NA    NA   123.9140
      1997 592.24   NA    NA    NA   124.8058
      1998 592.44   NA    NA    NA   125.1108
      1999 592.63   NA    NA    NA   124.2553
      2000 592.83   NA    NA    NA   123.7837
      2001 593.02   NA    NA    NA   121.8426
      2002 593.22   NA    NA    NA   123.4698
      2003 593.41   NA    NA    NA   123.3249
      2004 593.61   NA    NA    NA   123.9529
      2005 593.80   NA    NA    NA   122.2927
      2006 594.00   NA    NA    NA   124.1809
      2007 594.19   NA    NA    NA   122.7296
      2008 594.39   NA    NA    NA   122.4044
      2009 594.58   NA    NA    NA   123.0587
      2010 594.78   NA    NA    NA   122.8391
      2011 594.97   NA    NA    NA   125.1691
      2012 595.17   NA    NA    NA   123.8990
      2013 595.36   NA    NA    NA   123.6742
      2014 595.55   NA    NA    NA   124.0427
      2015 595.75   NA    NA    NA   122.5508
      2016 595.94   NA    NA    NA   122.2413
      2017 596.14   NA    NA    NA   122.4708
      2018 596.33   NA    NA    NA   123.5872
      2019 596.53   NA    NA    NA   123.0344
      2020 596.72   NA    NA    NA   124.0910
      2021 596.92   NA    NA    NA   122.3919
      2022 597.11   NA    NA    NA   122.5687
      2023 597.31   NA    NA    NA   122.7336
      2024 597.50   NA    NA    NA   122.9418
      2025 597.69   NA    NA    NA   122.8818
      2026 597.89   NA    NA    NA   124.9125
      2027 598.08   NA    NA    NA   125.4451
      2028 598.28   NA    NA    NA   123.1516
      2029 598.47   NA    NA    NA   124.5419
      2030 598.67   NA    NA    NA   124.4361
      2031 598.86   NA    NA    NA   121.5258
      2032 599.06   NA    NA    NA   123.3616
      2033 599.25   NA    NA    NA   123.4556
      2034 599.44   NA    NA    NA   124.5973
      2035 599.64   NA    NA    NA   124.8910
      2036 599.83   NA    NA    NA   122.8635
      2037 600.03   NA    NA    NA   122.7304
      2038 600.22   NA    NA    NA   123.7216
      2039 600.42   NA    NA    NA   123.8131
      2040 600.61   NA    NA    NA   124.8273
      2041 600.80   NA    NA    NA   122.2674
      2042 601.00   NA    NA    NA   123.4859
      2043 601.19   NA    NA    NA   121.5062
      2044 601.39   NA    NA    NA   123.8909
      2045 601.58   NA    NA    NA   123.1262
      2046 601.78   NA    NA    NA   122.5711
      2047 601.97   NA    NA    NA   124.4158
      2048 602.16   NA    NA    NA   122.5410
      2049 602.36   NA    NA    NA   123.1809
      2050 602.55   NA    NA    NA   123.6348
      2051 602.75   NA    NA    NA   123.0412
      2052 602.94   NA    NA    NA   122.4653
      2053 603.13   NA    NA    NA   122.9375
      2054 603.33   NA    NA    NA   125.2048
      2055 603.52   NA    NA    NA   123.3945
      2056 603.72   NA    NA    NA   123.1686
      2057 603.91   NA    NA    NA   123.8167
      2058 604.10   NA    NA    NA   122.8580
      2059 604.30   NA    NA    NA   124.7883
      2060 604.49   NA    NA    NA   122.7095
      2061 604.69   NA    NA    NA   122.7801
      2062 604.88   NA    NA    NA   123.1938
      2063 605.07   NA    NA    NA   123.6968
      2064 605.27   NA    NA    NA   122.6879
      2065 605.46   NA    NA    NA   123.7579
      2066 605.66   NA    NA    NA   124.2786
      2067 605.85   NA    NA    NA   121.9797
      2068 606.04   NA    NA    NA   122.1634
      2069 606.24   NA    NA    NA   123.3348
      2070 606.43   NA    NA    NA   123.1298
      2071 606.62   NA    NA    NA   123.3360
      2072 606.82   NA    NA    NA   122.4606
      2073 607.01   NA    NA    NA   124.1922
      2074 607.21   NA    NA    NA   123.0861
      2075 607.40   NA    NA    NA   122.9563
      2076 607.59   NA    NA    NA   122.4351
      2077 607.79   NA    NA    NA   121.2888
      2078 607.98   NA    NA    NA   121.6026
      2079 608.17   NA    NA    NA   122.2343
      2080 608.37   NA    NA    NA   121.8663
      2081 608.56   NA    NA    NA   124.1984
      2082 608.76   NA    NA    NA   122.2437
      2083 608.95   NA    NA    NA   123.1315
      2084 609.14   NA    NA    NA   119.8169
      2085 609.34   NA    NA    NA   123.7049
      2086 609.53   NA    NA    NA   122.3577
      2087 609.72   NA    NA    NA   122.3808
      2088 609.92   NA    NA    NA   121.1941
      2089 610.11   NA    NA    NA   121.3555
      2090 610.30   NA    NA    NA   120.5476
      2091 610.50   NA    NA    NA   120.9549
      2092 610.69   NA    NA    NA   122.6534
      2093 610.88   NA    NA    NA   122.0403
      2094 611.08   NA    NA    NA   122.8100
      2095 611.27   NA    NA    NA   123.2957
      2096 611.46   NA    NA    NA   122.5559
      2097 611.66   NA    NA    NA   121.9741
      2098 611.85   NA    NA    NA   123.0689
      2099 612.04   NA    NA    NA   122.9957
      2100 612.24   NA    NA    NA   123.3030
      2101 612.43   NA    NA    NA   123.6418
      2102 612.62   NA    NA    NA   122.7913
      2103 612.82   NA    NA    NA   122.3485
      2104 613.01   NA    NA    NA   121.1612
      2105 613.20   NA    NA    NA   121.0067
      2106 613.40   NA    NA    NA   124.0581
      2107 613.59   NA    NA    NA   120.8381
      2108 613.78   NA    NA    NA   120.6941
      2109 613.98   NA    NA    NA   124.2688
      2110 614.17   NA    NA    NA   123.5560
      2111 614.36   NA    NA    NA   121.8228
      2112 614.56   NA    NA    NA   122.9973
      2113 614.75   NA    NA    NA   123.9768
      2114 614.94   NA    NA    NA   125.8205
      2115 615.14   NA    NA    NA   123.0963
      2116 615.33   NA    NA    NA   123.4996
      2117 615.52   NA    NA    NA   123.0544
      2118 615.72   NA    NA    NA   121.2471
      2119 615.91   NA    NA    NA   121.9514
      2120 616.10   NA    NA    NA   123.5162
      2121 616.30   NA    NA    NA   122.0937
      2122 616.49   NA    NA    NA   121.0727
      2123 616.68   NA    NA    NA   123.9353
      2124 616.88   NA    NA    NA   122.0226
      2125 617.07   NA    NA    NA   123.4230
      2126 617.26   NA    NA    NA   122.9238
      2127 617.45   NA    NA    NA   121.3515
      2128 617.65   NA    NA    NA   121.4758
      2129 617.84   NA    NA    NA   122.1865
      2130 618.03   NA    NA    NA   123.0408
      2131 618.23   NA    NA    NA   122.7320
      2132 618.42   NA    NA    NA   123.3390
      2133 618.61   NA    NA    NA   122.5501
      2134 618.80   NA    NA    NA   121.6753
      2135 619.00   NA    NA    NA   123.8611
      2136 619.19   NA    NA    NA   124.7558
      2137 619.38   NA    NA    NA   122.9131
      2138 619.58   NA    NA    NA   122.5068
      2139 619.77   NA    NA    NA   122.6500
      2140 619.96   NA    NA    NA   124.0174
      2141 620.15   NA    NA    NA   123.4351
      2142 620.35   NA    NA    NA   124.0578
      2143 620.54   NA    NA    NA   120.8054
      2144 620.73   NA    NA    NA   122.8752
      2145 620.93   NA    NA    NA   122.1558
      2146 621.12   NA    NA    NA   122.3034
      2147 621.31   NA    NA    NA   121.0026
      2148 621.50   NA    NA    NA   122.0014
      2149 621.70   NA    NA    NA   120.8196
      2150 621.89   NA    NA    NA   122.4372
      2151 622.08   NA    NA    NA   120.7202
      2152 622.27   NA    NA    NA   123.0583
      2153 622.47   NA    NA    NA   122.8776
      2154 622.66   NA    NA    NA   123.0845
      2155 622.85   NA    NA    NA   121.6164
      2156 623.04   NA    NA    NA   122.3493
      2157 623.24   NA    NA    NA   120.7893
      2158 623.43   NA    NA    NA   121.6899
      2159 623.62   NA    NA    NA   122.5859
      2160 623.81   NA    NA    NA   120.4853
      2161 624.01   NA    NA    NA   122.7314
      2162 624.20   NA    NA    NA   121.1449
      2163 624.39   NA    NA    NA   123.7231
      2164 624.58   NA    NA    NA   121.6234
      2165 624.78   NA    NA    NA   120.9184
      2166 624.97   NA    NA    NA   120.9824
      2167 625.16   NA    NA    NA   122.4045
      2168 625.35   NA    NA    NA   120.1689
      2169 625.55   NA    NA    NA   121.3280
      2170 625.74   NA    NA    NA   122.2809
      2171 625.93   NA    NA    NA   121.4046
      2172 626.12   NA    NA    NA   122.7396
      2173 626.32   NA    NA    NA   121.4602
      2174 626.51   NA    NA    NA   121.0187
      2175 626.70   NA    NA    NA   120.3758
      2176 626.89   NA    NA    NA   122.4057
      2177 627.09   NA    NA    NA   122.7399
      2178 627.28   NA    NA    NA   125.2913
      2179 627.47   NA    NA    NA   121.3718
      2180 627.66   NA    NA    NA   122.7908
      2181 627.85   NA    NA    NA   123.1358
      2182 628.05   NA    NA    NA   122.6522
      2183 628.24   NA    NA    NA   120.7322
      2184 628.43   NA    NA    NA   122.5294
      2185 628.62   NA    NA    NA   123.4040
      2186 628.82   NA    NA    NA   121.9400
      2187 629.01   NA    NA    NA   124.5537
      2188 629.20   NA    NA    NA   122.7021
      2189 629.39   NA    NA    NA   119.6554
      2190 629.58   NA    NA    NA   121.7310
      2191 629.78   NA    NA    NA   121.9222
      2192 629.97   NA    NA    NA   122.3482
      2193 630.16   NA    NA    NA   123.0904
      2194 630.35   NA    NA    NA   124.9708
      2195 630.54   NA    NA    NA   122.8558
      2196 630.74   NA    NA    NA   123.4221
      2197 630.93   NA    NA    NA   119.1663
      2198 631.12   NA    NA    NA   122.1411
      2199 631.31   NA    NA    NA   120.4395
      2200 631.50   NA    NA    NA   122.5604
      2201 631.70   NA    NA    NA   122.8972
      2202 631.89   NA    NA    NA   122.2112
      2203 632.08   NA    NA    NA   122.6946
      2204 632.27   NA    NA    NA   121.9822
      2205 632.46   NA    NA    NA   124.1044
      2206 632.65   NA    NA    NA   120.1464
      2207 632.85   NA    NA    NA   123.2165
      2208 633.04   NA    NA    NA   123.4371
      2209 633.23   NA    NA    NA   121.4972
      2210 633.42   NA    NA    NA   121.0980
      2211 633.61   NA    NA    NA   120.9003
      2212 633.81   NA    NA    NA   121.0586
      2213 634.00   NA    NA    NA   121.3961
      2214 634.19   NA    NA    NA   121.2661
      2215 634.38   NA    NA    NA   122.7249
      2216 634.57   NA    NA    NA   123.1488
      2217 634.76   NA    NA    NA   123.0064
      2218 634.96   NA    NA    NA   121.2932
      2219 635.15   NA    NA    NA   122.1860
      2220 635.34   NA    NA    NA   119.4957
      2221 635.53   NA    NA    NA   122.3250
      2222 635.72   NA    NA    NA   123.2220
      2223 635.91   NA    NA    NA   119.8191
      2224 636.11   NA    NA    NA   118.4170
      2225 636.30   NA    NA    NA   120.8058
      2226 636.49   NA    NA    NA   121.7295
      2227 636.68   NA    NA    NA   122.3465
      2228 636.87   NA    NA    NA   123.2030
      2229 637.06   NA    NA    NA   123.2669
      2230 637.26   NA    NA    NA   122.5950
      2231 637.45   NA    NA    NA   122.9164
      2232 637.64   NA    NA    NA   122.4383
      2233 637.83   NA    NA    NA   123.9877
      2234 638.02   NA    NA    NA   120.1568
      2235 638.21   NA    NA    NA   122.4268
      2236 638.40   NA    NA    NA   120.4731
      2237 638.60   NA    NA    NA   121.3848
      2238 638.79   NA    NA    NA   123.0853
      2239 638.98   NA    NA    NA   119.5545
      2240 639.17   NA    NA    NA   121.5275
      2241 639.36   NA    NA    NA   119.5890
      2242 639.55   NA    NA    NA   121.8169
      2243 639.74   NA    NA    NA   121.1281
      2244 639.93   NA    NA    NA   121.6593
      2245 640.13   NA    NA    NA   121.8384
      2246 640.32   NA    NA    NA   119.5971
      2247 640.51   NA    NA    NA   123.4095
      2248 640.70   NA    NA    NA   120.7346
      2249 640.89   NA    NA    NA   121.5514
      2250 641.08   NA    NA    NA   123.7884
      2251 641.27   NA    NA    NA   122.1627
      2252 641.46   NA    NA    NA   119.7002
      2253 641.66   NA    NA    NA   122.8709
      2254 641.85   NA    NA    NA   122.3063
      2255 642.04   NA    NA    NA   124.9590
      2256 642.23   NA    NA    NA   122.6073
      2257 642.42   NA    NA    NA   124.0089
      2258 642.61   NA    NA    NA   123.5776
      2259 642.80   NA    NA    NA   121.7738
      2260 642.99   NA    NA    NA   122.9786
      2261 643.18   NA    NA    NA   122.7805
      2262 643.38   NA    NA    NA   121.5587
      2263 643.57   NA    NA    NA   121.4307
      2264 643.76   NA    NA    NA   126.3678
      2265 643.95   NA    NA    NA   118.5691
      2266 644.14   NA    NA    NA   122.6827
      2267 644.33   NA    NA    NA   121.5946
      2268 644.52   NA    NA    NA   124.6716
      2269 644.71   NA    NA    NA   125.4833
      2270 644.90   NA    NA    NA   120.3612
      2271 645.09   NA    NA    NA   120.5561
      2272 645.29   NA    NA    NA   122.6387
      2273 645.48   NA    NA    NA   124.7606
      2274 645.67   NA    NA    NA   122.8576
      2275 645.86   NA    NA    NA   120.4656
      2276 646.05   NA    NA    NA   123.7578
      2277 646.24   NA    NA    NA   122.6485
      2278 646.43   NA    NA    NA   123.6733
      2279 646.62   NA    NA    NA   122.3856
      2280 646.81   NA    NA    NA   120.0551
      2281 647.00   NA    NA    NA   121.2925
      2282 647.19   NA    NA    NA   121.9112
      2283 647.38   NA    NA    NA   121.7645
      2284 647.57   NA    NA    NA   123.4663
      2285 647.77   NA    NA    NA   120.3774
      2286 647.96   NA    NA    NA   121.7366
      2287 648.15   NA    NA    NA   119.5740
      2288 648.34   NA    NA    NA   122.0242
      2289 648.53   NA    NA    NA   120.3672
      2290 648.72   NA    NA    NA   123.2457
      2291 648.91   NA    NA    NA   123.5328
      2292 649.10   NA    NA    NA   119.4417
      2293 649.29   NA    NA    NA   120.8807
      2294 649.48   NA    NA    NA   123.5717
      2295 649.67   NA    NA    NA   123.2477
      2296 649.86   NA    NA    NA   123.4675
      2297 650.05   NA    NA    NA   120.7833
      2298 650.24   NA    NA    NA   122.1693
      2299 650.43   NA    NA    NA   120.8527
      2300 650.62   NA    NA    NA   122.0639
      2301 650.81   NA    NA    NA   122.9230
      2302 651.01   NA    NA    NA   123.8448
      2303 651.20   NA    NA    NA   122.1448
      2304 651.39   NA    NA    NA   117.3309
      2305 651.58   NA    NA    NA   118.6702
      2306 651.77   NA    NA    NA   119.8232
      2307 651.96   NA    NA    NA   121.6477
      2308 652.15   NA    NA    NA   123.7545
      2309 652.34   NA    NA    NA   123.3003
      2310 652.53   NA    NA    NA   125.8052
      2311 652.72   NA    NA    NA   126.6060
      2312 652.91   NA    NA    NA   122.3851
      2313 653.10   NA    NA    NA   123.9369
      2314 653.29   NA    NA    NA   123.6978
      2315 653.48   NA    NA    NA   123.7076
      2316 653.67   NA    NA    NA   122.8016
      2317 653.86   NA    NA    NA   122.9768
      2318 654.05   NA    NA    NA   123.2253
      2319 654.24   NA    NA    NA   123.1401
      2320 654.43   NA    NA    NA   122.7919
      2321 654.62   NA    NA    NA   122.3625
      2322 654.81   NA    NA    NA   123.2885
      2323 655.00   NA    NA    NA   122.0393
      2324 655.19   NA    NA    NA   122.0599
      2325 655.38   NA    NA    NA   122.8884
      2326 655.57   NA    NA    NA   122.4229
      2327 655.76   NA    NA    NA   122.7656
      2328 655.95   NA    NA    NA   122.0440
      2329 656.14   NA    NA    NA   122.1141
      2330 656.33   NA    NA    NA   122.2204
      2331 656.52   NA    NA    NA   122.7073
      2332 656.71   NA    NA    NA   122.0354
      2333 656.90   NA    NA    NA   122.1111
      2334 657.09   NA    NA    NA   121.6813
      2335 657.28   NA    NA    NA   121.4386
      2336 657.47   NA    NA    NA   121.0161
      2337 657.66   NA    NA    NA   120.6768
      2338 657.85   NA    NA    NA   121.3304
      2339 658.04   NA    NA    NA   120.4040
      2340 658.23   NA    NA    NA   121.6245
      2341 658.42   NA    NA    NA   120.5568
      2342 658.61   NA    NA    NA   121.3049
      2343 658.80   NA    NA    NA   122.6354
      2344 658.99   NA    NA    NA   119.6717
      2345 659.18   NA    NA    NA   121.6763
      2346 659.37   NA    NA    NA   120.8356
      2347 659.56   NA    NA    NA   119.3924
      2348 659.75   NA    NA    NA   121.6906
      2349 659.94   NA    NA    NA   121.9211
      2350 660.13   NA    NA    NA   120.4403
      2351 660.32   NA    NA    NA   120.8794
      2352 660.51   NA    NA    NA   120.2160
      2353 660.70   NA    NA    NA   119.8333
      2354 660.89   NA    NA    NA   123.3522
      2355 661.08   NA    NA    NA   121.5739
      2356 661.27   NA    NA    NA   120.5257
      2357 661.46   NA    NA    NA   123.3129
      2358 661.65   NA    NA    NA   120.3708
      2359 661.84   NA    NA    NA   121.8111
      2360 662.03   NA    NA    NA   121.1394
      2361 662.22   NA    NA    NA   120.2897
      2362 662.41   NA    NA    NA   120.0295
      2363 662.60   NA    NA    NA   121.6989
      2364 662.78   NA    NA    NA   121.6751
      2365 662.97   NA    NA    NA   121.0106
      2366 663.16   NA    NA    NA   124.8733
      2367 663.35   NA    NA    NA   122.3479
      2368 663.54   NA    NA    NA   119.8472
      2369 663.73   NA    NA    NA   120.0263
      2370 663.92   NA    NA    NA   120.5874
      2371 664.11   NA    NA    NA   118.8626
      2372 664.30   NA    NA    NA   120.8527
      2373 664.49   NA    NA    NA   122.0158
      2374 664.68   NA    NA    NA   121.0855
      2375 664.87   NA    NA    NA   123.3778
      2376 665.06   NA    NA    NA   122.6486
      2377 665.25   NA    NA    NA   121.6547
      2378 665.44   NA    NA    NA   120.8637
      2379 665.63   NA    NA    NA   123.4680
      2380 665.82   NA    NA    NA   119.9880
      2381 666.01   NA    NA    NA   122.2747
      2382 666.19   NA    NA    NA   119.3212
      2383 666.38   NA    NA    NA   122.3734
      2384 666.57   NA    NA    NA   123.6185
      2385 666.76   NA    NA    NA   122.6049
      2386 666.95   NA    NA    NA   121.2148
      2387 667.14   NA    NA    NA   121.8475
      2388 667.33   NA    NA    NA   119.3180
      2389 667.52   NA    NA    NA   123.4745
      2390 667.71   NA    NA    NA   125.7869
      2391 667.90   NA    NA    NA   120.3305
      2392 668.09   NA    NA    NA   119.8770
      2393 668.28   NA    NA    NA   122.2865
      2394 668.46   NA    NA    NA   121.6168
      2395 668.65   NA    NA    NA   123.1900
      2396 668.84   NA    NA    NA   121.0936
      2397 669.03   NA    NA    NA   119.9707
      2398 669.22   NA    NA    NA   123.4255
      2399 669.41   NA    NA    NA   122.2774
      2400 669.60   NA    NA    NA   123.7153
      2401 669.79   NA    NA    NA   124.4715
      2402 669.98   NA    NA    NA   123.9012
      2403 670.17   NA    NA    NA   124.5356
      2404 670.35   NA    NA    NA   121.9776
      2405 670.54   NA    NA    NA   123.3786
      2406 670.73   NA    NA    NA   122.3705
      2407 670.92   NA    NA    NA   123.5437
      2408 671.11   NA    NA    NA   123.6289
      2409 671.30   NA    NA    NA   120.9493
      2410 671.49   NA    NA    NA   122.5648
      2411 671.68   NA    NA    NA   124.1575
      2412 671.87   NA    NA    NA   120.8747
      2413 672.05   NA    NA    NA   126.7888
      2414 672.24   NA    NA    NA   120.9871
      2415 672.43   NA    NA    NA   122.4442
      2416 672.62   NA    NA    NA   123.9072
      2417 672.81   NA    NA    NA   122.1987
      2418 673.00   NA    NA    NA   124.9358
      2419 673.19   NA    NA    NA   122.0952
      2420 673.38   NA    NA    NA   122.0511
      2421 673.57   NA    NA    NA   122.0406
      2422 673.75   NA    NA    NA   124.9784
      2423 673.94   NA    NA    NA   120.2305
      2424 674.13   NA    NA    NA   124.2839
      2425 674.32   NA    NA    NA   121.9062
      2426 674.51   NA    NA    NA   120.2117
      2427 674.70   NA    NA    NA   119.9887
      2428 674.89   NA    NA    NA   123.1876
      2429 675.07   NA    NA    NA   122.7560
      2430 675.26   NA    NA    NA   122.1368
      2431 675.45   NA    NA    NA   117.8480
      2432 675.64   NA    NA    NA   121.9755
      2433 675.83   NA    NA    NA   122.9256
      2434 676.02   NA    NA    NA   120.5249
      2435 676.21   NA    NA    NA   123.1839
      2436 676.39   NA    NA    NA   120.3490
      2437 676.58   NA    NA    NA   122.4496
      2438 676.77   NA    NA    NA   121.9680
      2439 676.96   NA    NA    NA   124.6023
      2440 677.15   NA    NA    NA   122.3883
      2441 677.34   NA    NA    NA   123.5064
      2442 677.52   NA    NA    NA   122.8397
      2443 677.71   NA    NA    NA   120.8113
      2444 677.90   NA    NA    NA   121.6091
      2445 678.09   NA    NA    NA   121.9251
      2446 678.28   NA    NA    NA   121.1774
      2447 678.47   NA    NA    NA   120.0136
      2448 678.65   NA    NA    NA   120.0562
      2449 678.84   NA    NA    NA   120.5429
      2450 679.03   NA    NA    NA   121.4372
      2451 679.22   NA    NA    NA   121.0126
      2452 679.41   NA    NA    NA   120.6503
      2453 679.60   NA    NA    NA   121.8861
      2454 679.78   NA    NA    NA   122.5362
      2455 679.97   NA    NA    NA   121.4044
      2456 680.16   NA    NA    NA   120.5604
      2457 680.35   NA    NA    NA   125.2764
      2458 680.54   NA    NA    NA   124.3462
      2459 680.73   NA    NA    NA   123.6938
      2460 680.91   NA    NA    NA   121.7380
      2461 681.10   NA    NA    NA   122.3034
      2462 681.29   NA    NA    NA   125.4752
      2463 681.48   NA    NA    NA   122.4323
      2464 681.67   NA    NA    NA   121.6863
      2465 681.85   NA    NA    NA   121.0331
      2466 682.04   NA    NA    NA   122.7450
      2467 682.23   NA    NA    NA   121.9959
      2468 682.42   NA    NA    NA   124.6371
      2469 682.61   NA    NA    NA   121.3263
      2470 682.79   NA    NA    NA   124.2013
      2471 682.98   NA    NA    NA   122.2460
      2472 683.17   NA    NA    NA   124.1074
      2473 683.36   NA    NA    NA   123.2272
      2474 683.55   NA    NA    NA   123.2769
      2475 683.73   NA    NA    NA   119.7564
      2476 683.92   NA    NA    NA   125.3023
      2477 684.11   NA    NA    NA   119.9227
      2478 684.30   NA    NA    NA   122.1879
      2479 684.49   NA    NA    NA   122.1763
      2480 684.67   NA    NA    NA   120.1769
      2481 684.86   NA    NA    NA   121.6404
      2482 685.05   NA    NA    NA   119.5886
      2483 685.24   NA    NA    NA   123.2273
      2484 685.42   NA    NA    NA   122.1881
      2485 685.61   NA    NA    NA   122.7970
      2486 685.80   NA    NA    NA   124.8627
      2487 685.99   NA    NA    NA   119.7981
      2488 686.18   NA    NA    NA   123.2868
      2489 686.36   NA    NA    NA   122.6545
      2490 686.55   NA    NA    NA   123.3242
      2491 686.74   NA    NA    NA   123.1350
      2492 686.93   NA    NA    NA   120.1244
      2493 687.11   NA    NA    NA   122.7881
      2494 687.30   NA    NA    NA   121.6728
      2495 687.49   NA    NA    NA   120.5269
      2496 687.68   NA    NA    NA   120.8872
      2497 687.86   NA    NA    NA   124.6999
      2498 688.05   NA    NA    NA   124.6806
      2499 688.24   NA    NA    NA   121.4007
      2500 688.43   NA    NA    NA   120.4433
      2501 688.61   NA    NA    NA   122.2399
      2502 688.80   NA    NA    NA   122.8323
      2503 688.99   NA    NA    NA   121.4257
      2504 689.18   NA    NA    NA   125.0706
      2505 689.36   NA    NA    NA   120.3123
      2506 689.55   NA    NA    NA   123.3324
      2507 689.74   NA    NA    NA   121.1220
      2508 689.93   NA    NA    NA   118.3999
      2509 690.11   NA    NA    NA   122.4286
      2510 690.30   NA    NA    NA   121.5885
      2511 690.49   NA    NA    NA   119.6267
      2512 690.68   NA    NA    NA   121.1356
      2513 690.86   NA    NA    NA   123.4571
      2514 691.05   NA    NA    NA   121.9939
      2515 691.24   NA    NA    NA   119.3557
      2516 691.43   NA    NA    NA   123.8303
      2517 691.61   NA    NA    NA   120.0824
      2518 691.80   NA    NA    NA   123.5127
      2519 691.99   NA    NA    NA   121.3432
      2520 692.17   NA    NA    NA   124.4550
      2521 692.36   NA    NA    NA   124.4148
      2522 692.55   NA    NA    NA   121.3110
      2523 692.74   NA    NA    NA   122.7160
      2524 692.92   NA    NA    NA   120.9925
      2525 693.11   NA    NA    NA   121.8286
      2526 693.30   NA    NA    NA   123.6997
      2527 693.48   NA    NA    NA   121.7533
      2528 693.67   NA    NA    NA   118.3237
      2529 693.86   NA    NA    NA   119.2949
      2530 694.05   NA    NA    NA   122.2853
      2531 694.23   NA    NA    NA   119.2722
      2532 694.42   NA    NA    NA   124.5053
      2533 694.61   NA    NA    NA   123.0705
      2534 694.79   NA    NA    NA   124.0236
      2535 694.98   NA    NA    NA   121.6488
      2536 695.17   NA    NA    NA   121.1946
      2537 695.36   NA    NA    NA   121.3005
      2538 695.54   NA    NA    NA   124.1672
      2539 695.73   NA    NA    NA   121.5702
      2540 695.92   NA    NA    NA   124.8292
      2541 696.10   NA    NA    NA   122.3420
      2542 696.29   NA    NA    NA   120.4797
      2543 696.48   NA    NA    NA   120.8815
      2544 696.66   NA    NA    NA   119.4790
      2545 696.85   NA    NA    NA   122.3919
      2546 697.04   NA    NA    NA   121.7526
      2547 697.22   NA    NA    NA   122.4196
      2548 697.41   NA    NA    NA   120.3937
      2549 697.60   NA    NA    NA   120.4198
      2550 697.79   NA    NA    NA   123.2015
      2551 697.97   NA    NA    NA   123.7861
      2552 698.16   NA    NA    NA   123.6904
      2553 698.35   NA    NA    NA   121.8810
      2554 698.53   NA    NA    NA   123.5565
      2555 698.72   NA    NA    NA   119.9528
      2556 698.91   NA    NA    NA   122.7354
      2557 699.09   NA    NA    NA   123.8442
      2558 699.28   NA    NA    NA   123.0332
      2559 699.47   NA    NA    NA   120.9574
      2560 699.65   NA    NA    NA   124.8126
      2561 699.84   NA    NA    NA   120.6839
      2562 700.03   NA    NA    NA   121.9533
      2563 700.21   NA    NA    NA   124.2354
      2564 700.40   NA    NA    NA   121.3843
      2565 700.59   NA    NA    NA   119.2341
      2566 700.77   NA    NA    NA   119.1332
      2567 700.96   NA    NA    NA   123.0496
      2568 701.15   NA    NA    NA   122.1194
      2569 701.33   NA    NA    NA   121.7604
      2570 701.52   NA    NA    NA   121.3271
      2571 701.70   NA    NA    NA   121.9466
      2572 701.89   NA    NA    NA   123.0937
      2573 702.08   NA    NA    NA   120.4076
      2574 702.26   NA    NA    NA   120.8775
      2575 702.45   NA    NA    NA   121.7928
      2576 702.64   NA    NA    NA   121.2825
      2577 702.82   NA    NA    NA   122.3827
      2578 703.01   NA    NA    NA   120.7299
      2579 703.20   NA    NA    NA   124.0389
      2580 703.38   NA    NA    NA   122.3034
      2581 703.57   NA    NA    NA   120.0439
      2582 703.76   NA    NA    NA   120.9383
      2583 703.94   NA    NA    NA   124.0197
      2584 704.13   NA    NA    NA   121.4934
      2585 704.31   NA    NA    NA   124.4998
      2586 704.50   NA    NA    NA   122.6721
      2587 704.69   NA    NA    NA   121.1370
      2588 704.87   NA    NA    NA   122.3164
      2589 705.06   NA    NA    NA   121.4650
      2590 705.25   NA    NA    NA   120.8269
      2591 705.43   NA    NA    NA   124.3789
      2592 705.62   NA    NA    NA   121.9684
      2593 705.80   NA    NA    NA   120.0807
      2594 705.99   NA    NA    NA   123.6151
      2595 706.18   NA    NA    NA   121.6438
      2596 706.36   NA    NA    NA   121.7440
      2597 706.55   NA    NA    NA   122.3905
      2598 706.73   NA    NA    NA   122.2268
      2599 706.92   NA    NA    NA   121.5501
      2600 707.11   NA    NA    NA   119.9135
      2601 707.29   NA    NA    NA   121.4004
      2602 707.48   NA    NA    NA   121.7745
      2603 707.66   NA    NA    NA   123.2470
      2604 707.85   NA    NA    NA   121.7593
      2605 708.04   NA    NA    NA   120.9062
      2606 708.22   NA    NA    NA   121.5774
      2607 708.41   NA    NA    NA   121.7075
      2608 708.59   NA    NA    NA   120.2571
      2609 708.78   NA    NA    NA   121.5246
      2610 708.97   NA    NA    NA   120.3951
      2611 709.15   NA    NA    NA   124.0567
      2612 709.34   NA    NA    NA   118.4094
      2613 709.52   NA    NA    NA   121.4434
      2614 709.71   NA    NA    NA   122.9946
      2615 709.90   NA    NA    NA   123.4261
      2616 710.08   NA    NA    NA   125.2974
      2617 710.27   NA    NA    NA   120.8390
      2618 710.45   NA    NA    NA   123.3569
      2619 710.64   NA    NA    NA   123.2706
      2620 710.82   NA    NA    NA   123.3399
      2621 711.01   NA    NA    NA   122.1382
      2622 711.20   NA    NA    NA   122.0265
      2623 711.38   NA    NA    NA   121.6091
      2624 711.57   NA    NA    NA   121.9352
      2625 711.75   NA    NA    NA   124.4584
      2626 711.94   NA    NA    NA   120.4839
      2627 712.12   NA    NA    NA   123.4840
      2628 712.31   NA    NA    NA   119.5211
      2629 712.50   NA    NA    NA   121.2205
      2630 712.68   NA    NA    NA   121.3444
      2631 712.87   NA    NA    NA   120.6387
      2632 713.05   NA    NA    NA   122.7713
      2633 713.24   NA    NA    NA   124.7585
      2634 713.42   NA    NA    NA   123.8297
      2635 713.61   NA    NA    NA   123.4233
      2636 713.79   NA    NA    NA   122.5129
      2637 713.98   NA    NA    NA   121.4669
      2638 714.17   NA    NA    NA   121.3069
      2639 714.35   NA    NA    NA   125.0579
      2640 714.54   NA    NA    NA   123.7742
      2641 714.72   NA    NA    NA   122.1205
      2642 714.91   NA    NA    NA   122.9228
      2643 715.09   NA    NA    NA   123.5905
      2644 715.28   NA    NA    NA   122.5797
      2645 715.46   NA    NA    NA   121.5972
      2646 715.65   NA    NA    NA   120.1400
      2647 715.83   NA    NA    NA   122.7253
      2648 716.02   NA    NA    NA   121.4553
      2649 716.21   NA    NA    NA   121.9397
      2650 716.39   NA    NA    NA   120.9146
      2651 716.58   NA    NA    NA   121.1403
      2652 716.76   NA    NA    NA   122.7353
      2653 716.95   NA    NA    NA   122.2965
      2654 717.13   NA    NA    NA   120.2768
      2655 717.32   NA    NA    NA   123.3590
      2656 717.50   NA    NA    NA   122.8500
      2657 717.69   NA    NA    NA   120.4566
      2658 717.87   NA    NA    NA   119.9797
      2659 718.06   NA    NA    NA   120.9701
      2660 718.24   NA    NA    NA   121.1558
      2661 718.43   NA    NA    NA   120.8917
      2662 718.61   NA    NA    NA   121.4064
      2663 718.80   NA    NA    NA   120.9295
      2664 718.98   NA    NA    NA   121.2995
      2665 719.17   NA    NA    NA   122.7012
      2666 719.35   NA    NA    NA   123.3788
      2667 719.54   NA    NA    NA   123.2638
      2668 719.72   NA    NA    NA   121.4051
      2669 719.91   NA    NA    NA   122.7794
      2670 720.09   NA    NA    NA   125.3356
      2671 720.28   NA    NA    NA   118.6053
      2672 720.46   NA    NA    NA   120.3819
      2673 720.65   NA    NA    NA   122.7747
      2674 720.83   NA    NA    NA   119.0085
      2675 721.02   NA    NA    NA   124.2985
      2676 721.20   NA    NA    NA   120.8615
      2677 721.39   NA    NA    NA   121.4784
      2678 721.57   NA    NA    NA   124.6384
      2679 721.76   NA    NA    NA   123.4719
      2680 721.94   NA    NA    NA   121.4884
      2681 722.13   NA    NA    NA   123.0675
      2682 722.31   NA    NA    NA   122.2985
      2683 722.50   NA    NA    NA   124.2091
      2684 722.68   NA    NA    NA   123.4936
      2685 722.87   NA    NA    NA   123.9034
      2686 723.05   NA    NA    NA   120.8808
      2687 723.24   NA    NA    NA   121.9698
      2688 723.42   NA    NA    NA   120.7430
      2689 723.61   NA    NA    NA   121.8481
      2690 723.79   NA    NA    NA   124.1973
      2691 723.98   NA    NA    NA   120.7135
      2692 724.16   NA    NA    NA   121.7831
      2693 724.34   NA    NA    NA   123.9193
      2694 724.53   NA    NA    NA   119.0934
      2695 724.71   NA    NA    NA   118.7021
      2696 724.90   NA    NA    NA   122.4122
      2697 725.08   NA    NA    NA   123.5562
      2698 725.27   NA    NA    NA   121.7930
      2699 725.45   NA    NA    NA   121.1424
      2700 725.64   NA    NA    NA   121.9205
      2701 725.82   NA    NA    NA   122.2467
      2702 726.01   NA    NA    NA   124.6958
      2703 726.19   NA    NA    NA   122.4508
      2704 726.38   NA    NA    NA   120.6661
      2705 726.56   NA    NA    NA   122.3471
      2706 726.74   NA    NA    NA   121.8644
      2707 726.93   NA    NA    NA   120.7843
      2708 727.11   NA    NA    NA   126.4816
      2709 727.30   NA    NA    NA   119.6771
      2710 727.48   NA    NA    NA   122.2337
      2711 727.67   NA    NA    NA   124.2519
      2712 727.85   NA    NA    NA   122.4843
      2713 728.04   NA    NA    NA   118.1792
      2714 728.22   NA    NA    NA   121.4074
      2715 728.40   NA    NA    NA   123.7891
      2716 728.59   NA    NA    NA   121.6454
      2717 728.77   NA    NA    NA   123.4465
      2718 728.96   NA    NA    NA   121.6434
      2719 729.14   NA    NA    NA   120.6796
      2720 729.33   NA    NA    NA   123.3877
      2721 729.51   NA    NA    NA   123.5410
      2722 729.69   NA    NA    NA   124.3338
      2723 729.88   NA    NA    NA   124.1502
      2724 730.06   NA    NA    NA   121.8419
      2725 730.25   NA    NA    NA   120.5794
      2726 730.43   NA    NA    NA   122.3416
      2727 730.61   NA    NA    NA   123.5848
      2728 730.80   NA    NA    NA   120.0081
      2729 730.98   NA    NA    NA   123.0894
      2730 731.17   NA    NA    NA   120.1529
      2731 731.35   NA    NA    NA   121.3473
      2732 731.54   NA    NA    NA   122.8610
      2733 731.72   NA    NA    NA   118.3978
      2734 731.90   NA    NA    NA   121.4324
      2735 732.09   NA    NA    NA   121.6608
      2736 732.27   NA    NA    NA   124.9498
      2737 732.46   NA    NA    NA   121.8440
      2738 732.64   NA    NA    NA   123.2236
      2739 732.82   NA    NA    NA   122.4282
      2740 733.01   NA    NA    NA   124.0674
      2741 733.19   NA    NA    NA   121.0408
      2742 733.38   NA    NA    NA   123.9634
      2743 733.56   NA    NA    NA   122.3712
      2744 733.74   NA    NA    NA   120.2401
      2745 733.93   NA    NA    NA   119.9191
      2746 734.11   NA    NA    NA   123.3877
      2747 734.29   NA    NA    NA   124.4320
      2748 734.48   NA    NA    NA   122.9821
      2749 734.66   NA    NA    NA   122.9145
      2750 734.85   NA    NA    NA   120.2478
      2751 735.03   NA    NA    NA   122.0192
      2752 735.21   NA    NA    NA   124.1125
      2753 735.40   NA    NA    NA   124.1375
      2754 735.58   NA    NA    NA   121.9424
      2755 735.77   NA    NA    NA   121.9021
      2756 735.95   NA    NA    NA   123.5413
      2757 736.13   NA    NA    NA   119.7346
      2758 736.32   NA    NA    NA   123.0986
      2759 736.50   NA    NA    NA   123.0436
      2760 736.68   NA    NA    NA   122.0339
      2761 736.87   NA    NA    NA   122.3728
      2762 737.05   NA    NA    NA   123.5405
      2763 737.23   NA    NA    NA   121.6954
      2764 737.42   NA    NA    NA   123.0305
      2765 737.60   NA    NA    NA   123.1860
      2766 737.79   NA    NA    NA   125.3825
      2767 737.97   NA    NA    NA   123.9700
      2768 738.15   NA    NA    NA   123.2202
      2769 738.34   NA    NA    NA   119.8344
      2770 738.52   NA    NA    NA   124.2946
      2771 738.70   NA    NA    NA   122.3181
      2772 738.89   NA    NA    NA   122.2532
      2773 739.07   NA    NA    NA   124.0011
      2774 739.25   NA    NA    NA   121.4466
      2775 739.44   NA    NA    NA   124.9024
      2776 739.62   NA    NA    NA   119.9510
      2777 739.80   NA    NA    NA   123.7870
      2778 739.99   NA    NA    NA   122.1186
      2779 740.17   NA    NA    NA   124.0224
      2780 740.35   NA    NA    NA   121.7592
      2781 740.54   NA    NA    NA   120.4202
      2782 740.72   NA    NA    NA   124.2108
      2783 740.90   NA    NA    NA   123.3377
      2784 741.09   NA    NA    NA   123.5477
      2785 741.27   NA    NA    NA   123.1921
      2786 741.45   NA    NA    NA   119.5684
      2787 741.64   NA    NA    NA   122.0773
      2788 741.82   NA    NA    NA   121.4737
      2789 742.00   NA    NA    NA   121.6335
      2790 742.19   NA    NA    NA   122.4185
      2791 742.37   NA    NA    NA   124.0932
      2792 742.55   NA    NA    NA   121.9193
      2793 742.74   NA    NA    NA   122.5723
      2794 742.92   NA    NA    NA   122.7252
      2795 743.10   NA    NA    NA   119.2804
      2796 743.29   NA    NA    NA   119.8815
      2797 743.47   NA    NA    NA   124.6764
      2798 743.65   NA    NA    NA   123.7856
      2799 743.83   NA    NA    NA   121.0648
      2800 744.02   NA    NA    NA   119.2789
      2801 744.20   NA    NA    NA   121.8073
      2802 744.38   NA    NA    NA   121.1298
      2803 744.57   NA    NA    NA   119.9938
      2804 744.75   NA    NA    NA   120.8657
      2805 744.93   NA    NA    NA   122.0256
      2806 745.12   NA    NA    NA   123.4973
      2807 745.30   NA    NA    NA   124.5221
      2808 745.48   NA    NA    NA   120.7963
      2809 745.66   NA    NA    NA   122.5031
      2810 745.85   NA    NA    NA   124.8506
      2811 746.03   NA    NA    NA   119.7755
      2812 746.21   NA    NA    NA   120.8754
      2813 746.40   NA    NA    NA   119.6846
      2814 746.58   NA    NA    NA   121.3663
      2815 746.76   NA    NA    NA   122.8633
      2816 746.94   NA    NA    NA   121.4736
      2817 747.13   NA    NA    NA   123.4528
      2818 747.31   NA    NA    NA   121.2472
      2819 747.49   NA    NA    NA   120.2244
      2820 747.68   NA    NA    NA   124.3040
      2821 747.86   NA    NA    NA   122.1456
      2822 748.04   NA    NA    NA   123.8219
      2823 748.22   NA    NA    NA   119.3662
      2824 748.41   NA    NA    NA   121.9174
      2825 748.59   NA    NA    NA   122.4493
      2826 748.77   NA    NA    NA   119.6819
      2827 748.95   NA    NA    NA   122.4078
      2828 749.14   NA    NA    NA   121.8578
      2829 749.32   NA    NA    NA   122.6138
      2830 749.50   NA    NA    NA   121.5205
      2831 749.68   NA    NA    NA   122.6689
      2832 749.87   NA    NA    NA   120.1077
      2833 750.05   NA    NA    NA   123.6091
      2834 750.23   NA    NA    NA   120.0966
      2835 750.42   NA    NA    NA   121.5454
      2836 750.60   NA    NA    NA   120.6577
      2837 750.78   NA    NA    NA   122.7511
      2838 750.96   NA    NA    NA   122.9680
      2839 751.15   NA    NA    NA   123.4749
      2840 751.33   NA    NA    NA   122.8290
      2841 751.51   NA    NA    NA   122.3132
      2842 751.69   NA    NA    NA   128.1745
      2843 751.87   NA    NA    NA   122.7902
      2844 752.06   NA    NA    NA   122.9376
      2845 752.24   NA    NA    NA   122.9295
      2846 752.42   NA    NA    NA   123.4441
      2847 752.60   NA    NA    NA   118.1728
      2848 752.79   NA    NA    NA   121.2817
      2849 752.97   NA    NA    NA   121.0815
      2850 753.15   NA    NA    NA   123.4182
      2851 753.33   NA    NA    NA   124.2585
      2852 753.52   NA    NA    NA   122.8687
      2853 753.70   NA    NA    NA   122.0324
      2854 753.88   NA    NA    NA   123.1568
      2855 754.06   NA    NA    NA   123.9461
      2856 754.24   NA    NA    NA   120.8437
      2857 754.43   NA    NA    NA   121.9050
      2858 754.61   NA    NA    NA   121.2789
      2859 754.79   NA    NA    NA   123.1029
      2860 754.97   NA    NA    NA   120.8965
      2861 755.16   NA    NA    NA   122.2061
      2862 755.34   NA    NA    NA   121.0843
      2863 755.52   NA    NA    NA   122.1758
      2864 755.70   NA    NA    NA   123.2136
      2865 755.88   NA    NA    NA   123.2706
      2866 756.07   NA    NA    NA   121.5330
      2867 756.25   NA    NA    NA   120.9788
      2868 756.43   NA    NA    NA   122.7807
      2869 756.61   NA    NA    NA   122.2940
      2870 756.79   NA    NA    NA   120.3383
      2871 756.98   NA    NA    NA   122.7261
      2872 757.16   NA    NA    NA   119.8307
      2873 757.34   NA    NA    NA   125.3333
      2874 757.52   NA    NA    NA   123.2979
      2875 757.70   NA    NA    NA   122.2918
      2876 757.89   NA    NA    NA   120.5728
      2877 758.07   NA    NA    NA   125.1876
      2878 758.25   NA    NA    NA   122.3435
      2879 758.43   NA    NA    NA   122.4552
      2880 758.61   NA    NA    NA   124.7369
      2881 758.80   NA    NA    NA   122.9933
      2882 758.98   NA    NA    NA   122.2209
      2883 759.16   NA    NA    NA   121.6588
      2884 759.34   NA    NA    NA   123.6508
      2885 759.52   NA    NA    NA   121.0459
      2886 759.70   NA    NA    NA   120.5511
      2887 759.89   NA    NA    NA   121.0440
      2888 760.07   NA    NA    NA   121.9816
      2889 760.25   NA    NA    NA   121.4104
      2890 760.43   NA    NA    NA   123.1004
      2891 760.61   NA    NA    NA   121.1727
      2892 760.79   NA    NA    NA   118.8200
      2893 760.98   NA    NA    NA   122.9516
      2894 761.16   NA    NA    NA   120.7914
      2895 761.34   NA    NA    NA   123.3896
      2896 761.52   NA    NA    NA   122.4306
      2897 761.70   NA    NA    NA   120.0070
      2898 761.88   NA    NA    NA   123.4444
      2899 762.07   NA    NA    NA   121.6223
      2900 762.25   NA    NA    NA   121.9530
      2901 762.43   NA    NA    NA   122.0988
      2902 762.61   NA    NA    NA   124.7238
      2903 762.79   NA    NA    NA   122.8910
      2904 762.97   NA    NA    NA   120.4136
      2905 763.15   NA    NA    NA   122.0761
      2906 763.34   NA    NA    NA   122.2300
      2907 763.52   NA    NA    NA   124.7276
      2908 763.70   NA    NA    NA   123.8391
      2909 763.88   NA    NA    NA   121.1842
      2910 764.06   NA    NA    NA   120.8584
      2911 764.24   NA    NA    NA   120.9618
      2912 764.42   NA    NA    NA   120.5666
      2913 764.61   NA    NA    NA   122.3901
      2914 764.79   NA    NA    NA   122.6479
      2915 764.97   NA    NA    NA   120.9124
      2916 765.15   NA    NA    NA   124.6403
      2917 765.33   NA    NA    NA   121.3886
      2918 765.51   NA    NA    NA   123.4139
      2919 765.69   NA    NA    NA   123.5812
      2920 765.87   NA    NA    NA   120.5651
      2921 766.06   NA    NA    NA   121.9831
      2922 766.24   NA    NA    NA   121.1039
      2923 766.42   NA    NA    NA   122.4711
      2924 766.60   NA    NA    NA   123.0937
      2925 766.78   NA    NA    NA   119.9237
      2926 766.96   NA    NA    NA   123.4827
      2927 767.14   NA    NA    NA   121.3526
      2928 767.32   NA    NA    NA   121.9486
      2929 767.50   NA    NA    NA   120.8389
      2930 767.69   NA    NA    NA   122.9989
      2931 767.87   NA    NA    NA   120.9398
      2932 768.05   NA    NA    NA   121.7610
      2933 768.23   NA    NA    NA   124.2082
      2934 768.41   NA    NA    NA   123.5819
      2935 768.59   NA    NA    NA   123.5068
      2936 768.77   NA    NA    NA   122.2727
      2937 768.95   NA    NA    NA   121.7257
      2938 769.13   NA    NA    NA   123.1242
      2939 769.32   NA    NA    NA   121.4778
      2940 769.50   NA    NA    NA   121.8042
      2941 769.68   NA    NA    NA   123.3062
      2942 769.86   NA    NA    NA   123.1083
      2943 770.04   NA    NA    NA   123.1282
      2944 770.22   NA    NA    NA   121.9147
      2945 770.40   NA    NA    NA   121.7360
      2946 770.58   NA    NA    NA   122.2059
      2947 770.76   NA    NA    NA   119.8547
      2948 770.94   NA    NA    NA   121.5915
      2949 771.12   NA    NA    NA   122.5401
      2950 771.30   NA    NA    NA   119.1853
      2951 771.49   NA    NA    NA   120.1435
      2952 771.67   NA    NA    NA   121.3159
      2953 771.85   NA    NA    NA   124.7375
      2954 772.03   NA    NA    NA   121.7897
      2955 772.21   NA    NA    NA   119.1770
      2956 772.39   NA    NA    NA   123.2164
      2957 772.57   NA    NA    NA   122.4550
      2958 772.75   NA    NA    NA   121.7651
      2959 772.93   NA    NA    NA   123.3560
      2960 773.11   NA    NA    NA   122.6543
      2961 773.29   NA    NA    NA   123.8291
      2962 773.47   NA    NA    NA   120.0000
      2963 773.65   NA    NA    NA   120.7178
      2964 773.83   NA    NA    NA   124.2481
      2965 774.01   NA    NA    NA   120.1489
      2966 774.19   NA    NA    NA   124.9889
      2967 774.38   NA    NA    NA   124.4559
      2968 774.56   NA    NA    NA   122.0859
      2969 774.74   NA    NA    NA   121.0235
      2970 774.92   NA    NA    NA   121.4979
      2971 775.10   NA    NA    NA   122.3988
      2972 775.28   NA    NA    NA   121.1535
      2973 775.46   NA    NA    NA   124.1298
      2974 775.64   NA    NA    NA   122.2049
      2975 775.82   NA    NA    NA   121.5062
      2976 776.00   NA    NA    NA   124.3453
      2977 776.18   NA    NA    NA   124.8524
      2978 776.36   NA    NA    NA   121.3727
      2979 776.54   NA    NA    NA   121.4131
      2980 776.72   NA    NA    NA   120.8463
      2981 776.90   NA    NA    NA   120.8378
      2982 777.08   NA    NA    NA   123.9428
      2983 777.26   NA    NA    NA   120.6999
      2984 777.44   NA    NA    NA   122.5277
      2985 777.62   NA    NA    NA   120.6227
      2986 777.80   NA    NA    NA   121.4891
      2987 777.98   NA    NA    NA   122.9503
      2988 778.16   NA    NA    NA   125.2822
      2989 778.34   NA    NA    NA   120.4817
      2990 778.52   NA    NA    NA   119.4161
      2991 778.70   NA    NA    NA   122.9434
      2992 778.88   NA    NA    NA   122.9882
      2993 779.06   NA    NA    NA   124.8282
      2994 779.24   NA    NA    NA   118.6756
      2995 779.42   NA    NA    NA   122.6421
      2996 779.60   NA    NA    NA   122.2066
      2997 779.78   NA    NA    NA   123.9017
      2998 779.96   NA    NA    NA   123.0745
      2999 780.14   NA    NA    NA   121.1723
      3000 780.32   NA    NA    NA   124.5849
      3001 780.50   NA    NA    NA   121.1718
      3002 780.68   NA    NA    NA   122.0231
      3003 780.86   NA    NA    NA   124.6634
      3004 781.04   NA    NA    NA   123.3108
      3005 781.22   NA    NA    NA   121.0967
      3006 781.40   NA    NA    NA   119.4247
      3007 781.58   NA    NA    NA   121.0300
      3008 781.76   NA    NA    NA   118.8222
      3009 781.94   NA    NA    NA   124.2790
      3010 782.12   NA    NA    NA   121.3723
      3011 782.30   NA    NA    NA   122.0521
      3012 782.48   NA    NA    NA   122.6715
      3013 782.66   NA    NA    NA   125.6158
      3014 782.84   NA    NA    NA   125.1754
      3015 783.02   NA    NA    NA   124.4770
      3016 783.20   NA    NA    NA   124.3977
      3017 783.38   NA    NA    NA   124.3239
      3018 783.56   NA    NA    NA   121.7796
      3019 783.74   NA    NA    NA   123.1157
      3020 783.92   NA    NA    NA   125.2728
      3021 784.10   NA    NA    NA   124.4252
      3022 784.28   NA    NA    NA   122.2514
      3023 784.46   NA    NA    NA   126.0180
      3024 784.64   NA    NA    NA   120.5856
      3025 784.82   NA    NA    NA   122.5771
      3026 785.00   NA    NA    NA   121.6300
      3027 785.18   NA    NA    NA   121.0792
      3028 785.36   NA    NA    NA   122.8466
      3029 785.54   NA    NA    NA   123.6600
      3030 785.72   NA    NA    NA   124.2720
      3031 785.90   NA    NA    NA   122.8721
      3032 786.08   NA    NA    NA   123.1451
      3033 786.26   NA    NA    NA   122.7744
      3034 786.43   NA    NA    NA   121.0922
      3035 786.61   NA    NA    NA   121.6631
      3036 786.79   NA    NA    NA   121.0372
      3037 786.97   NA    NA    NA   122.1632
      3038 787.15   NA    NA    NA   121.9638
      3039 787.33   NA    NA    NA   123.8695
      3040 787.51   NA    NA    NA   121.1035
      3041 787.69   NA    NA    NA   123.4303
      3042 787.87   NA    NA    NA   121.4917
      3043 788.05   NA    NA    NA   124.0097
      3044 788.23   NA    NA    NA   125.9245
      3045 788.41   NA    NA    NA   123.5012
      3046 788.59   NA    NA    NA   124.8510
      3047 788.77   NA    NA    NA   122.5483
      3048 788.95   NA    NA    NA   123.0271
      3049 789.13   NA    NA    NA   124.4001
      3050 789.30   NA    NA    NA   123.6414
      3051 789.48   NA    NA    NA   122.7132
      3052 789.66   NA    NA    NA   126.3908
      3053 789.84   NA    NA    NA   121.1523
      3054 790.02   NA    NA    NA   120.8822
      3055 790.20   NA    NA    NA   124.9246
      3056 790.38   NA    NA    NA   120.4144
      3057 790.56   NA    NA    NA   122.3706
      3058 790.74   NA    NA    NA   122.7932
      3059 790.92   NA    NA    NA   120.5180
      3060 791.10   NA    NA    NA   122.0798
      3061 791.28   NA    NA    NA   123.3374
      3062 791.45   NA    NA    NA   118.7084
      3063 791.63   NA    NA    NA   127.0586
      3064 791.81   NA    NA    NA   127.4169
      3065 791.99   NA    NA    NA   123.6386
      3066 792.17   NA    NA    NA   127.3029
      3067 792.35   NA    NA    NA   122.9272
      3068 792.53   NA    NA    NA   118.5171
      3069 792.71   NA    NA    NA   125.5255
      3070 792.89   NA    NA    NA   120.6765
      3071 793.07   NA    NA    NA   123.7605
      3072 793.24   NA    NA    NA   122.7160
      3073 793.42   NA    NA    NA   123.6669
      3074 793.60   NA    NA    NA   124.8181
      3075 793.78   NA    NA    NA   121.4970
      3076 793.96   NA    NA    NA   124.0839
      3077 794.14   NA    NA    NA   123.3454
      3078 794.32   NA    NA    NA   123.7425
      3079 794.50   NA    NA    NA   122.0988
      3080 794.67   NA    NA    NA   123.8584
      3081 794.85   NA    NA    NA   121.4801
      3082 795.03   NA    NA    NA   123.3690
      3083 795.21   NA    NA    NA   125.4534
      3084 795.39   NA    NA    NA   121.5410
      3085 795.57   NA    NA    NA   125.8287
      3086 795.75   NA    NA    NA   122.5910
      3087 795.93   NA    NA    NA   120.2680
      3088 796.10   NA    NA    NA   125.0602
      3089 796.28   NA    NA    NA   121.4083
      3090 796.46   NA    NA    NA   120.6789
      3091 796.64   NA    NA    NA   121.3757
      3092 796.82   NA    NA    NA   124.2800
      3093 797.00   NA    NA    NA   128.1747
      3094 797.18   NA    NA    NA   124.5984
      3095 797.35   NA    NA    NA   118.9299
      3096 797.53   NA    NA    NA   122.0685
      3097 797.71   NA    NA    NA   124.0342
      3098 797.89   NA    NA    NA   122.8531
      3099 798.07   NA    NA    NA   125.8438
      3100 798.25   NA    NA    NA   122.3402
      3101 798.43   NA    NA    NA   122.2609
      3102 798.60   NA    NA    NA   119.0052
      3103 798.78   NA    NA    NA   126.8405
      3104 798.96   NA    NA    NA   123.9779
      3105 799.14   NA    NA    NA   122.8238
      3106 799.32   NA    NA    NA   121.0651
      3107 799.50   NA    NA    NA   119.4019
      3108 799.67   NA    NA    NA   123.4188
      3109 799.85   NA    NA    NA   121.7192
      3110 800.03   NA    NA    NA   122.1068
      3111 800.21   NA    NA    NA   121.8833
      3112 800.39   NA    NA    NA   123.3094
      3113 800.57   NA    NA    NA   120.9138
      3114 800.74   NA    NA    NA   120.0943
      3115 800.92   NA    NA    NA   116.7029
      3116 801.10   NA    NA    NA   121.0903
      3117 801.28   NA    NA    NA   125.4986
      3118 801.46   NA    NA    NA   123.7082
      3119 801.64   NA    NA    NA   120.4597
      3120 801.81   NA    NA    NA   122.7557
      3121 801.99   NA    NA    NA   124.4450
      3122 802.17   NA    NA    NA   126.3778
      3123 802.35   NA    NA    NA   125.3374
      3124 802.53   NA    NA    NA   123.8059
      3125 802.70   NA    NA    NA   123.4906
      3126 802.88   NA    NA    NA   125.4846
      3127 803.06   NA    NA    NA   122.1508
      3128 803.24   NA    NA    NA   121.7279
      3129 803.42   NA    NA    NA   121.0961
      3130 803.59   NA    NA    NA   125.8673
      3131 803.77   NA    NA    NA   125.7694
      3132 803.95   NA    NA    NA   128.5036
      3133 804.13   NA    NA    NA   119.5309
      3134 804.31   NA    NA    NA   121.9038
      3135 804.48   NA    NA    NA   125.2047
      3136 804.66   NA    NA    NA   125.2284
      3137 804.84   NA    NA    NA   121.0926
      3138 805.02   NA    NA    NA   120.8176
      3139 805.20   NA    NA    NA   125.0801
      3140 805.37   NA    NA    NA   121.8517
      3141 805.55   NA    NA    NA   121.7598
      3142 805.73   NA    NA    NA   127.5265
      3143 805.91   NA    NA    NA   121.6600
      3144 806.08   NA    NA    NA   123.7310
      3145 806.26   NA    NA    NA   121.9165
      3146 806.44   NA    NA    NA   122.7239
      3147 806.62   NA    NA    NA   122.3510
      3148 806.80   NA    NA    NA   122.7306
      3149 806.97   NA    NA    NA   122.6492
      3150 807.15   NA    NA    NA   121.6347
      3151 807.33   NA    NA    NA   129.3957
      3152 807.51   NA    NA    NA   124.2164
      3153 807.68   NA    NA    NA   123.3196
      3154 807.86   NA    NA    NA   128.9899
      3155 808.04   NA    NA    NA   125.2822
      3156 808.22   NA    NA    NA   124.8981
      3157 808.39   NA    NA    NA   118.7062
      3158 808.57   NA    NA    NA   122.7186
      3159 808.75   NA    NA    NA   121.4192
      3160 808.93   NA    NA    NA   128.1444
      3161 809.10   NA    NA    NA   119.6277
      3162 809.28   NA    NA    NA   125.7308
      3163 809.46   NA    NA    NA   126.1599
      3164 809.64   NA    NA    NA   124.8665
      3165 809.81   NA    NA    NA   122.1814
      3166 809.99   NA    NA    NA   122.4640
      3167 810.17   NA    NA    NA   124.3847
      3168 810.35   NA    NA    NA   128.6555
      3169 810.52   NA    NA    NA   124.2820
      3170 810.70   NA    NA    NA   124.1973
      3171 810.88   NA    NA    NA   121.8320
      3172 811.06   NA    NA    NA   121.5014
      3173 811.23   NA    NA    NA   125.0143
      3174 811.41   NA    NA    NA   123.9977
      3175 811.59   NA    NA    NA   126.6303
      3176 811.77   NA    NA    NA   123.2398
      3177 811.94   NA    NA    NA   122.9068
      3178 812.12   NA    NA    NA   126.1809
      3179 812.30   NA    NA    NA   121.6130
      3180 812.47   NA    NA    NA   130.4482
      3181 812.65   NA    NA    NA   129.9020
      3182 812.83   NA    NA    NA   122.6906
      3183 813.01   NA    NA    NA   119.8822
      3184 813.18   NA    NA    NA   120.1829
      3185 813.36   NA    NA    NA   123.9674
      3186 813.54   NA    NA    NA   126.5288
      3187 813.71   NA    NA    NA   122.2857
      3188 813.89   NA    NA    NA   125.4967
      3189 814.07   NA    NA    NA   120.6704
      3190 814.25   NA    NA    NA   125.3858
      3191 814.42   NA    NA    NA   120.9702
      3192 814.60   NA    NA    NA   126.2037
      3193 814.78   NA    NA    NA   124.1268
      3194 814.95   NA    NA    NA   125.6434
      3195 815.13   NA    NA    NA   127.4219
      3196 815.31   NA    NA    NA   122.2855
      3197 815.48   NA    NA    NA   121.1898
      3198 815.66   NA    NA    NA   125.6136
      3199 815.84   NA    NA    NA   124.6571
      3200 816.02   NA    NA    NA   123.7829
      3201 816.19   NA    NA    NA   120.6813
      3202 816.37   NA    NA    NA   123.8518
      3203 816.55   NA    NA    NA   124.9445
      3204 816.72   NA    NA    NA   126.1407
      3205 816.90   NA    NA    NA   122.6671
      3206 817.08   NA    NA    NA   116.4989
      3207 817.25   NA    NA    NA   120.5073
      3208 817.43   NA    NA    NA   125.9720
      3209 817.61   NA    NA    NA   125.8044
      3210 817.78   NA    NA    NA   119.7612
      3211 817.96   NA    NA    NA   120.9280
      3212 818.14   NA    NA    NA   118.8788
      3213 818.31   NA    NA    NA   124.5086
      3214 818.49   NA    NA    NA   120.2351
      3215 818.67   NA    NA    NA   123.6404
      3216 818.84   NA    NA    NA   121.2827
      3217 819.02   NA    NA    NA   124.4977
      3218 819.20   NA    NA    NA   124.6110
      3219 819.37   NA    NA    NA   122.1767
      3220 819.55   NA    NA    NA   125.3846
      3221 819.73   NA    NA    NA   128.5281
      3222 819.90   NA    NA    NA   125.5585
      3223 820.08   NA    NA    NA   123.8335
      3224 820.26   NA    NA    NA   124.3027
      3225 820.43   NA    NA    NA   123.3736
      3226 820.61   NA    NA    NA   125.2901
      3227 820.79   NA    NA    NA   126.6511
      3228 820.96   NA    NA    NA   119.3996
      3229 821.14   NA    NA    NA   121.9769
      3230 821.32   NA    NA    NA   122.8888
      3231 821.49   NA    NA    NA   125.5929
      3232 821.67   NA    NA    NA   126.6302
      3233 821.85   NA    NA    NA   129.4624
      3234 822.02   NA    NA    NA   124.7091
      3235 822.20   NA    NA    NA   122.1287
      3236 822.37   NA    NA    NA   122.3670
      3237 822.55   NA    NA    NA   121.9858
      3238 822.73   NA    NA    NA   128.1894
      3239 822.90   NA    NA    NA   129.3220
      3240 823.08   NA    NA    NA   123.6281
      3241 823.26   NA    NA    NA   121.9107
      3242 823.43   NA    NA    NA   123.8552
      3243 823.61   NA    NA    NA   128.7593
      3244 823.78   NA    NA    NA   128.1911
      3245 823.96   NA    NA    NA   123.0270
      3246 824.14   NA    NA    NA   120.4181
      3247 824.31   NA    NA    NA   120.8991
      3248 824.49   NA    NA    NA   123.3658
      3249 824.67   NA    NA    NA   121.7361
      3250 824.84   NA    NA    NA   122.0557
      3251 825.02   NA    NA    NA   127.8347
      3252 825.19   NA    NA    NA   128.2963
      3253 825.37   NA    NA    NA   124.6609
      3254 825.55   NA    NA    NA   130.0992
      3255 825.72   NA    NA    NA   127.1802
      3256 825.90   NA    NA    NA   125.2575
      3257 826.07   NA    NA    NA   117.7505
      3258 826.25   NA    NA    NA   121.7659
      3259 826.43   NA    NA    NA   124.2987
      3260 826.60   NA    NA    NA   125.5765
      3261 826.78   NA    NA    NA   120.0979
      3262 826.95   NA    NA    NA   120.2157
      3263 827.13   NA    NA    NA   127.2461
      3264 827.31   NA    NA    NA   128.7968
      3265 827.48   NA    NA    NA   121.5194
      3266 827.66   NA    NA    NA   117.7793
      3267 827.83   NA    NA    NA   120.5252
      3268 828.01   NA    NA    NA   126.1717
      3269 828.19   NA    NA    NA   128.8799
      3270 828.36   NA    NA    NA   123.4155
      3271 828.54   NA    NA    NA   134.6836
      3272 828.71   NA    NA    NA   122.0719
      3273 828.89   NA    NA    NA   126.8557
      3274 829.06   NA    NA    NA   128.6142
      3275 829.24   NA    NA    NA   124.3439
      3276 829.42   NA    NA    NA   125.8219
      3277 829.59   NA    NA    NA   123.6116
      3278 829.77   NA    NA    NA   125.0464
      3279 829.94   NA    NA    NA   122.1597
      3280 830.12   NA    NA    NA   125.6556
      3281 830.29   NA    NA    NA   123.5782
      3282 830.47   NA    NA    NA   123.5994
      3283 830.65   NA    NA    NA   132.5714
      3284 830.82   NA    NA    NA   122.5744
      3285 831.00   NA    NA    NA   128.5997
      3286 831.17   NA    NA    NA   122.2880
      3287 831.35   NA    NA    NA   122.9289
      3288 831.52   NA    NA    NA   129.4166
      3289 831.70   NA    NA    NA   119.2412
      3290 831.87   NA    NA    NA   119.4942
      3291 832.05   NA    NA    NA   120.4405
      3292 832.23   NA    NA    NA   126.4540
      3293 832.40   NA    NA    NA   123.6948
      3294 832.58   NA    NA    NA   127.3425
      3295 832.75   NA    NA    NA   119.5685
      3296 832.93   NA    NA    NA   121.0767
      3297 833.10   NA    NA    NA   125.0683
      3298 833.28   NA    NA    NA   125.8231
      3299 833.45   NA    NA    NA   120.7214
      3300 833.63   NA    NA    NA   129.8681
      3301 833.80   NA    NA    NA   122.1947
      3302 833.98   NA    NA    NA   127.2095
      3303 834.15   NA    NA    NA   125.5966
      3304 834.33   NA    NA    NA   123.4682
      3305 834.51   NA    NA    NA   122.8974
      3306 834.68   NA    NA    NA   121.7256
      3307 834.86   NA    NA    NA   127.6409
      3308 835.03   NA    NA    NA   129.5619
      3309 835.21   NA    NA    NA   121.2867
      3310 835.38   NA    NA    NA   124.2734
      3311 835.56   NA    NA    NA   123.1349
      3312 835.73   NA    NA    NA   125.8174
      3313 835.91   NA    NA    NA   121.5243
      3314 836.08   NA    NA    NA   124.3558
      3315 836.26   NA    NA    NA   124.8007
      3316 836.43   NA    NA    NA   118.9065
      3317 836.61   NA    NA    NA   119.8213
      3318 836.78   NA    NA    NA   131.9487
      3319 836.96   NA    NA    NA   122.8682
      3320 837.13   NA    NA    NA   127.5591
      3321 837.31   NA    NA    NA   123.8837
      3322 837.48   NA    NA    NA   126.6437
      3323 837.66   NA    NA    NA   128.7025
      3324 837.83   NA    NA    NA   118.7838
      3325 838.01   NA    NA    NA   122.8547
      3326 838.18   NA    NA    NA   126.5049
      3327 838.36   NA    NA    NA   116.6225
      3328 838.53   NA    NA    NA   128.4269
      3329 838.71   NA    NA    NA   127.4374
      3330 838.88   NA    NA    NA   120.4738
      3331 839.06   NA    NA    NA   126.8392
      3332 839.23   NA    NA    NA   123.9256
      3333 839.41   NA    NA    NA   126.7398
      3334 839.58   NA    NA    NA   125.7453
      3335 839.76   NA    NA    NA   119.7788
      3336 839.93   NA    NA    NA   123.7074
      3337 840.11   NA    NA    NA   116.5693
      3338 840.28   NA    NA    NA   120.0870
      3339 840.46   NA    NA    NA   121.8421
      3340 840.63   NA    NA    NA   120.7273
      3341 840.81   NA    NA    NA   125.0810
      3342 840.98   NA    NA    NA   127.7024
      3343 841.15   NA    NA    NA   119.6429
      3344 841.33   NA    NA    NA   123.9929
      3345 841.50   NA    NA    NA   124.2397
      3346 841.68   NA    NA    NA   122.4823
      3347 841.85   NA    NA    NA   121.5969
      3348 842.03   NA    NA    NA   121.8919
      3349 842.20   NA    NA    NA   125.8411
      3350 842.38   NA    NA    NA   122.0856
      3351 842.55   NA    NA    NA   124.7907
      3352 842.73   NA    NA    NA   126.6514
      3353 842.90   NA    NA    NA   124.8518
      3354 843.08   NA    NA    NA   124.6140
      3355 843.25   NA    NA    NA   122.9340
      3356 843.42   NA    NA    NA   121.6408
      3357 843.60   NA    NA    NA   116.9670
      3358 843.77   NA    NA    NA   129.6188
      3359 843.95   NA    NA    NA   124.9161
      3360 844.12   NA    NA    NA   120.4325
      3361 844.30   NA    NA    NA   130.1431
      3362 844.47   NA    NA    NA   118.9048
      3363 844.64   NA    NA    NA   122.6107
      3364 844.82   NA    NA    NA   125.2009
      3365 844.99   NA    NA    NA   119.5190
      3366 845.17   NA    NA    NA   122.6379
      3367 845.34   NA    NA    NA   125.9980
      3368 845.52   NA    NA    NA   132.2348
      3369 845.69   NA    NA    NA   124.2380
      3370 845.87   NA    NA    NA   112.5701
      3371 846.04   NA    NA    NA   124.3867
      3372 846.21   NA    NA    NA   126.9154
      3373 846.39   NA    NA    NA   119.2455
      3374 846.56   NA    NA    NA   124.4186
      3375 846.74   NA    NA    NA   126.9118
      3376 846.91   NA    NA    NA   119.3595
      3377 847.08   NA    NA    NA   123.3235
      3378 847.26   NA    NA    NA   122.1191
      3379 847.43   NA    NA    NA   124.0506
      3380 847.61   NA    NA    NA   119.8537
      3381 847.78   NA    NA    NA   129.7163
      3382 847.95   NA    NA    NA   126.5277
      3383 848.13   NA    NA    NA   127.4027
      3384 848.30   NA    NA    NA   121.2107
      3385 848.48   NA    NA    NA   126.5347
      3386 848.65   NA    NA    NA   125.4070
      3387 848.83   NA    NA    NA   128.5042
      3388 849.00   NA    NA    NA   119.4161
      3389 849.17   NA    NA    NA   120.5737
      3390 849.35   NA    NA    NA   132.0844
      3391 849.52   NA    NA    NA   119.5146
      3392 849.69   NA    NA    NA   119.4499
      3393 849.87   NA    NA    NA   126.1952
      3394 850.04   NA    NA    NA   125.7825
      3395 850.22   NA    NA    NA   121.4736
      3396 850.39   NA    NA    NA   125.6272
      3397 850.56   NA    NA    NA   126.6432
      3398 850.74   NA    NA    NA   120.8559
      3399 850.91   NA    NA    NA   125.5222
      3400 851.09   NA    NA    NA   123.2605
      3401 851.26   NA    NA    NA   123.1884
      3402 851.43   NA    NA    NA   116.4978
      3403 851.61   NA    NA    NA   122.5230
      3404 851.78   NA    NA    NA   117.2947
      3405 851.95   NA    NA    NA   125.7540
      3406 852.13   NA    NA    NA   120.6688
      3407 852.30   NA    NA    NA   122.9723
      3408 852.48   NA    NA    NA   121.5875
      3409 852.65   NA    NA    NA   126.4851
      3410 852.82   NA    NA    NA   129.6495
      3411 853.00   NA    NA    NA   121.9340
      3412 853.17   NA    NA    NA   128.7250
      3413 853.34   NA    NA    NA   126.8384
      3414 853.52   NA    NA    NA   122.0020
      3415 853.69   NA    NA    NA   128.6761
      3416 853.86   NA    NA    NA   123.2328
      3417 854.04   NA    NA    NA   116.6235
      3418 854.21   NA    NA    NA   118.9019
      3419 854.38   NA    NA    NA   118.8386
      3420 854.56   NA    NA    NA   125.4187
      3421 854.73   NA    NA    NA   125.0369
      3422 854.90   NA    NA    NA   121.6844
      3423 855.08   NA    NA    NA   121.3012
      3424 855.25   NA    NA    NA   126.8775
      3425 855.42   NA    NA    NA   128.9377
      3426 855.60   NA    NA    NA   124.9625
      3427 855.77   NA    NA    NA   125.8081
      3428 855.95   NA    NA    NA   125.6256
      3429 856.12   NA    NA    NA   123.3195
      3430 856.29   NA    NA    NA   120.5989
      3431 856.46   NA    NA    NA   116.1621
      3432 856.64   NA    NA    NA   116.0994
      3433 856.81   NA    NA    NA   116.9239
      3434 856.98   NA    NA    NA   127.6800
      3435 857.16   NA    NA    NA   117.8338
      3436 857.33   NA    NA    NA   125.9299
      3437 857.50   NA    NA    NA   116.5339
      3438 857.68   NA    NA    NA   121.9709
      3439 857.85   NA    NA    NA   122.7993
      3440 858.02   NA    NA    NA   132.2468
      3441 858.20   NA    NA    NA   118.8592
      3442 858.37   NA    NA    NA   130.2473
      3443 858.54   NA    NA    NA   127.8296
      3444 858.72   NA    NA    NA   121.8234
      3445 858.89   NA    NA    NA   124.0471
      3446 859.06   NA    NA    NA   117.4163
      3447 859.24   NA    NA    NA   129.9304
      3448 859.41   NA    NA    NA   121.2209
      3449 859.58   NA    NA    NA   122.7039
      3450 859.75   NA    NA    NA   125.7496
      3451 859.93   NA    NA    NA   125.6217
      3452 860.10   NA    NA    NA   118.3544
      3453 860.27   NA    NA    NA   122.5751
      3454 860.45   NA    NA    NA   120.6936
      3455 860.62   NA    NA    NA   123.7801
      3456 860.79   NA    NA    NA   123.2399
      3457 860.97   NA    NA    NA   118.7571
      3458 861.14   NA    NA    NA   126.8503
      3459 861.31   NA    NA    NA   127.8450
      3460 861.48   NA    NA    NA   130.9366
      3461 861.66   NA    NA    NA   117.4504
      3462 861.83   NA    NA    NA   123.4884
      3463 862.00   NA    NA    NA   121.8978
      3464 862.17   NA    NA    NA   127.0833
      3465 862.35   NA    NA    NA   124.3337
      3466 862.52   NA    NA    NA   128.2383
      3467 862.69   NA    NA    NA   125.3565
      3468 862.87   NA    NA    NA   123.7896
      3469 863.04   NA    NA    NA   120.0240
      3470 863.21   NA    NA    NA   113.4153
      3471 863.38   NA    NA    NA   123.0817
      3472 863.56   NA    NA    NA   121.9963
      3473 863.73   NA    NA    NA   128.9571
      3474 863.90   NA    NA    NA   126.3631
      3475 864.07   NA    NA    NA   127.7641
      3476 864.25   NA    NA    NA   117.1566
      3477 864.42   NA    NA    NA   116.8732
      3478 864.59   NA    NA    NA   128.9118
      3479 864.76   NA    NA    NA   132.9325
      3480 864.94   NA    NA    NA   122.8365
      3481 865.11   NA    NA    NA   122.5412
      3482 865.28   NA    NA    NA   121.7337
      3483 865.45   NA    NA    NA   127.0235
      3484 865.63   NA    NA    NA   128.3388
      3485 865.80   NA    NA    NA   121.8078
      3486 865.97   NA    NA    NA   112.4079
      3487 866.14   NA    NA    NA   125.1584
      3488 866.32   NA    NA    NA   133.5215
      3489 866.49   NA    NA    NA   118.1479
      3490 866.66   NA    NA    NA   118.5390
      3491 866.83   NA    NA    NA   123.2073
      3492 867.01   NA    NA    NA   117.6160
      3493 867.18   NA    NA    NA   127.1353
      3494 867.35   NA    NA    NA   115.9847
      3495 867.52   NA    NA    NA   128.3485
      3496 867.70   NA    NA    NA   124.1130
      3497 867.87   NA    NA    NA   131.7471
      3498 868.04   NA    NA    NA   141.3589
      3499 868.21   NA    NA    NA   125.5029
      3500 868.38   NA    NA    NA   130.2326
      3501 868.56   NA    NA    NA   120.9688
      3502 868.73   NA    NA    NA   112.4151
      3503 868.90   NA    NA    NA   128.0054
      3504 869.07   NA    NA    NA   131.2453
      3505 869.24   NA    NA    NA   118.2625
      3506 869.42   NA    NA    NA   123.9187
      3507 869.59   NA    NA    NA   128.3775
      3508 869.76   NA    NA    NA   127.2858
      3509 869.93   NA    NA    NA   124.8663
      3510 870.11   NA    NA    NA   120.9795
      3511 870.28   NA    NA    NA   127.7778
      3512 870.45   NA    NA    NA   118.1395
      3513 870.62   NA    NA    NA   129.3033
      3514 870.79   NA    NA    NA   127.1656
      3515 870.97   NA    NA    NA   130.4196
      3516 871.14   NA    NA    NA   134.7639
      3517 871.31   NA    NA    NA   127.0987
      3518 871.48   NA    NA    NA   123.1926
      3519 871.65   NA    NA    NA   118.2344
      3520 871.82   NA    NA    NA   121.6273
      3521 872.00   NA    NA    NA   127.2663
      3522 872.17   NA    NA    NA   133.3073
      3523 872.34   NA    NA    NA   129.3866
      3524 872.51   NA    NA    NA   117.2813
      3525 872.68   NA    NA    NA   127.4964
      3526 872.86   NA    NA    NA   130.4284
      3527 873.03   NA    NA    NA   118.3536
      3528 873.20   NA    NA    NA   128.8636
      3529 873.37   NA    NA    NA   124.0642
      3530 873.54   NA    NA    NA   139.0337
      3531 873.71   NA    NA    NA   120.6003
      3532 873.89   NA    NA    NA   121.2956
      3533 874.06   NA    NA    NA   121.4234
      3534 874.23   NA    NA    NA   112.5941
      3535 874.40   NA    NA    NA   118.8227
      3536 874.57   NA    NA    NA   123.2540
      3537 874.74   NA    NA    NA   121.4286
      3538 874.92   NA    NA    NA   130.3906
      3539 875.09   NA    NA    NA   128.6585
      3540 875.26   NA    NA    NA   123.1461
      3541 875.43   NA    NA    NA   121.1852
      3542 875.60   NA    NA    NA   121.7829
      3543 875.77   NA    NA    NA   124.6743
      3544 875.95   NA    NA    NA   118.8361
      3545 876.12   NA    NA    NA   126.1014
      3546 876.29   NA    NA    NA   123.8468
      3547 876.46   NA    NA    NA   121.7893
      3548 876.63   NA    NA    NA   114.6429
      3549 876.80   NA    NA    NA   120.3466
      3550 876.97   NA    NA    NA   128.5362
      3551 877.15   NA    NA    NA   128.6163
      3552 877.32   NA    NA    NA   118.0241
      3553 877.49   NA    NA    NA   121.6339
      3554 877.66   NA    NA    NA   124.3140
      3555 877.83   NA    NA    NA   125.6659
      3556 878.00   NA    NA    NA   124.6423
      3557 878.17   NA    NA    NA   113.9385
      3558 878.34   NA    NA    NA   116.4134
      3559 878.52   NA    NA    NA   134.6586
      3560 878.69   NA    NA    NA   120.9398
      3561 878.86   NA    NA    NA   132.5062
      3562 879.03   NA    NA    NA   120.8527
      3563 879.20   NA    NA    NA   128.2293
      3564 879.37   NA    NA    NA   120.7849
      3565 879.54   NA    NA    NA   117.4110
      3566 879.71   NA    NA    NA   118.4127
      3567 879.89   NA    NA    NA   129.3046
      3568 880.06   NA    NA    NA   136.7381
      3569 880.23   NA    NA    NA   127.3624
      3570 880.40   NA    NA    NA   136.4452
      3571 880.57   NA    NA    NA   135.6282
      3572 880.74   NA    NA    NA   129.6888
      3573 880.91   NA    NA    NA   137.6229
      3574 881.08   NA    NA    NA   133.0205
      3575 881.25   NA    NA    NA   129.2500
      3576 881.42   NA    NA    NA   117.2859
      3577 881.60   NA    NA    NA   112.4523
      3578 881.77   NA    NA    NA   129.3088
      3579 881.94   NA    NA    NA   122.6038
      3580 882.11   NA    NA    NA   130.4688
      3581 882.28   NA    NA    NA   123.8606
      3582 882.45   NA    NA    NA   129.6693
      3583 882.62   NA    NA    NA   121.0091
      3584 882.79   NA    NA    NA   127.7052
      3585 882.96   NA    NA    NA   118.2410
      3586 883.13   NA    NA    NA   117.3323
      3587 883.30   NA    NA    NA   116.6526
      3588 883.48   NA    NA    NA   116.5168
      3589 883.65   NA    NA    NA   120.5656
      3590 883.82   NA    NA    NA   125.6386
      3591 883.99   NA    NA    NA   120.5209
      3592 884.16   NA    NA    NA   124.2599
      3593 884.33   NA    NA    NA   127.8195
      3594 884.50   NA    NA    NA   117.4061
      3595 884.67   NA    NA    NA   129.3666
      3596 884.84   NA    NA    NA   120.3445
      3597 885.01   NA    NA    NA   129.5684
      3598 885.18   NA    NA    NA   129.4708
      3599 885.35   NA    NA    NA   122.5466
      3600 885.52   NA    NA    NA   125.0241
      3601 885.69   NA    NA    NA   128.9474
      3602 885.87   NA    NA    NA   125.9418
      3603 886.04   NA    NA    NA   115.4582
      3604 886.21   NA    NA    NA   121.5827
      3605 886.38   NA    NA    NA   129.9543
      3606 886.55   NA    NA    NA   120.5080
      3607 886.72   NA    NA    NA   119.5633
      3608 886.89   NA    NA    NA   125.8438
      3609 887.06   NA    NA    NA   121.5315
      3610 887.23   NA    NA    NA   112.2468
      3611 887.40   NA    NA    NA   129.9625
      3612 887.57   NA    NA    NA   112.2083
      3613 887.74   NA    NA    NA   128.1365
      3614 887.91   NA    NA    NA   136.6829
      3615 888.08   NA    NA    NA   125.7976
      3616 888.25   NA    NA    NA   117.9856
      3617 888.42   NA    NA    NA   116.0667
      3618 888.59   NA    NA    NA   125.4335
      3619 888.76   NA    NA    NA   128.5852
      3620 888.93   NA    NA    NA   129.5455
      3621 889.10   NA    NA    NA   135.4492
      3622 889.27   NA    NA    NA   123.2106
      3623 889.44   NA    NA    NA   131.1975
      3624 889.61   NA    NA    NA   116.4684
      3625 889.78   NA    NA    NA   127.2349
      3626 889.95   NA    NA    NA   124.6485
      3627 890.12   NA    NA    NA   118.4328
      3628 890.29   NA    NA    NA   135.0333
      3629 890.46   NA    NA    NA   123.4455
      3630 890.63   NA    NA    NA   121.0472
      3631 890.80   NA    NA    NA   131.2684
      3632 890.97   NA    NA    NA   118.9320
      3633 891.15   NA    NA    NA   122.8492
      3634 891.32   NA    NA    NA   123.8947
      3635 891.49   NA    NA    NA   118.7500
      3636 891.66   NA    NA    NA   131.2306
      3637 891.83   NA    NA    NA   122.0227
      3638 892.00   NA    NA    NA   125.7928
      3639 892.17   NA    NA    NA   135.5532
      3640 892.34   NA    NA    NA   120.7198
      3641 892.51   NA    NA    NA   125.6825
      3642 892.68   NA    NA    NA   125.3493
      3643 892.84   NA    NA    NA   123.9024
      3644 893.01   NA    NA    NA   143.3369
      3645 893.18   NA    NA    NA   126.0733
      3646 893.35   NA    NA    NA   123.6205
      3647 893.52   NA    NA    NA   131.3266
      3648 893.69   NA    NA    NA   119.4252
      
      $metadata
       [1] NA                    "2016-02-16 14:23:00" NA                   
       [4] NA                    NA                    NA                   
       [7] NA                    NA                    NA                   
      [10] NA                    NA                    NA                   
      [13] NA                   
      

---

    Code
      lr_parse_jaz(test.file("jazspec.jaz"))
    Output
      $data
               wl   dark   white   scope   processed
      1    190.85    0.0     0.0     0.0     0.00000
      2    191.23    0.0     0.0     0.0     0.00000
      3    191.61 1079.0  1156.2  1064.9   -18.18182
      4    191.99 1182.0  1184.3  1062.6 -5099.91113
      5    192.37 1149.2  1165.6  1074.3  -457.14148
      6    192.75 1151.5  1179.6  1116.4  -125.00000
      7    193.12 1226.4  1149.2  1151.5    96.96964
      8    193.50 1167.9  1121.1  1109.4   124.99993
      9    193.88 1189.0  1165.6  1086.0   440.00134
      10   194.26 1163.2  1163.2  1160.9     0.00000
      11   194.64 1219.4  1233.5  1174.9  -316.66696
      12   195.01 1196.0  1212.4  1151.5  -271.42740
      13   195.39 1200.7  1221.8  1174.9  -122.22261
      14   195.77 1163.2  1259.2  1149.2   -14.63415
      15   196.15 1210.1  1212.4  1149.2 -2599.95312
      16   196.53 1170.3  1235.8  1128.1   -64.28567
      17   196.90 1212.4  1261.5  1207.7    -9.52373
      18   197.28 1196.0  1226.4  1128.1  -223.07649
      19   197.66 1207.7  1214.7  1095.4 -1600.00000
      20   198.04 1212.4  1177.3  1158.6   153.33322
      21   198.42 1228.8  1210.1  1186.7   224.99902
      22   198.79 1163.2  1210.1  1177.3    30.00003
      23   199.17 1163.2  1189.0  1139.8   -90.90939
      24   199.55 1167.9  1139.8  1184.3   -58.33348
      25   199.93 1170.3  1231.1  1139.8   -50.00010
      26   200.30 1184.3  1217.1  1212.4    85.71439
      27   200.68 1172.6  1292.0  1179.6     5.88235
      28   201.06 1151.5  1275.6  1104.7   -37.73593
      29   201.44 1163.2  1240.5  1149.2   -18.18182
      30   201.82 1179.6  1296.7  1135.2   -38.00005
      31   202.19 1254.5  1231.1  1198.4   239.99959
      32   202.57 1217.1  1273.3  1191.3   -45.83326
      33   202.95 1203.0  1317.7  1156.2   -40.81628
      34   203.33 1245.2  1345.8  1163.2   -81.39528
      35   203.70 1156.2  1285.0  1182.0    19.99996
      36   204.08 1100.1  1249.8  1109.4     6.25002
      37   204.46 1132.8  1313.0  1172.6    22.07796
      38   204.83 1177.3  1292.0  1107.1   -61.22447
      39   205.21 1177.3  1256.9  1111.8   -82.35295
      40   205.59 1212.4  1292.0  1146.9   -82.35295
      41   205.97 1196.0  1301.3  1137.5   -55.55548
      42   206.34 1163.2  1287.3  1116.4   -37.73583
      43   206.72 1212.4  1268.6  1198.4   -25.00000
      44   207.10 1198.4  1380.9  1153.9   -24.35900
      45   207.48 1156.2  1247.5  1221.8    71.79491
      46   207.85 1144.5  1294.3  1153.9     6.24995
      47   208.23 1191.3  1249.8  1142.2   -83.99994
      48   208.61 1149.2  1324.7  1135.2    -8.00000
      49   208.98 1210.1  1292.0  1139.8   -85.71420
      50   209.36 1107.1  1285.0  1177.3    39.47368
      51   209.74 1156.2  1266.2  1111.8   -40.42558
      52   210.11 1231.1  1327.1  1186.7   -46.34134
      53   210.49 1125.8  1345.8  1100.1   -11.70211
      54   210.87 1144.5  1289.6  1107.1   -25.80649
      55   211.25 1137.5  1306.0  1158.6    12.50000
      56   211.62 1191.3  1308.4  1153.9   -32.00005
      57   212.00 1207.7  1292.0  1170.3   -44.44449
      58   212.38 1228.8  1397.3  1182.0   -27.77783
      59   212.75 1217.1  1282.6  1191.3   -39.28563
      60   213.13 1121.1  1263.9  1198.4    54.09835
      61   213.51 1273.3  1329.4  1116.4  -279.16653
      62   213.88 1184.3  1334.1  1153.9   -20.31252
      63   214.26 1158.6  1392.6  1160.9     0.99997
      64   214.64 1160.9  1259.2  1165.6     4.76199
      65   215.01 1156.2  1301.3  1153.9    -1.61293
      66   215.39 1153.9  1322.4  1165.6     6.94449
      67   215.76 1163.2  1383.3  1158.6    -2.12764
      68   216.14 1125.8  1277.9  1135.2     6.15387
      69   216.52 1200.7  1376.2  1182.0   -10.66671
      70   216.89 1132.8  1327.1  1207.7    38.55424
      71   217.27 1167.9  1390.3  1189.0     9.47368
      72   217.65 1170.3  1380.9  1086.0   -40.00000
      73   218.02 1165.6  1303.7  1165.6     0.00000
      74   218.40 1132.8  1324.7  1114.1    -9.75607
      75   218.78 1186.7  1350.5  1217.1    18.57139
      76   219.15 1163.2  1371.6  1142.2   -10.11236
      77   219.53 1153.9  1411.3  1130.5    -9.09088
      78   219.90 1149.2  1364.5  1130.5    -8.69563
      79   220.28 1095.4  1418.4  1165.6    21.73913
      80   220.66 1193.7  1465.2  1163.2   -11.20691
      81   221.03 1165.6  1420.7  1226.4    23.85320
      82   221.41 1235.8  1448.8  1130.5   -49.45057
      83   221.78 1153.9  1572.8  1135.2    -4.46926
      84   222.16 1203.0  1570.5  1158.6   -12.10189
      85   222.54 1203.0  1610.3  1210.1     1.72414
      86   222.91 1212.4  1589.2  1221.8     2.48448
      87   223.29 1167.9  1640.7  1233.5    13.86139
      88   223.66 1172.6  1593.9  1233.5    14.44444
      89   224.04 1158.6  1668.8  1233.5    14.67889
      90   224.41 1179.6  1640.7  1151.5    -6.09137
      91   224.79 1191.3  1715.6  1198.4     1.33929
      92   225.17 1163.2  1708.6  1212.4     9.01287
      93   225.54 1151.5  1851.4  1207.7     8.02676
      94   225.92 1193.7  1837.3  1285.0    14.18182
      95   226.29 1163.2  1980.1  1285.0    14.89972
      96   226.67 1186.7  1996.5  1231.1     5.49132
      97   227.04 1184.3  2106.5  1233.5     5.32995
      98   227.42 1207.7  2282.0  1322.4    10.67537
      99   227.79 1182.0  2431.8  1303.7     9.73783
      100  228.17 1163.2  2684.6  1350.5    12.30769
      101  228.55 1167.9  3031.0  1416.0    13.31658
      102  228.92 1189.0  3447.6  1423.0    10.36270
      103  229.30 1170.3  3925.1  1600.9    15.63297
      104  229.67 1221.8  4519.6  1528.4     9.29737
      105  230.05 1174.9  4629.6  1624.3    13.00813
      106  230.42 1067.3  4669.4  1631.4    15.65952
      107  230.80 1174.9  4379.1  1549.4    11.68736
      108  231.17 1128.1  4117.0  1514.3    12.92091
      109  231.55 1153.9  3850.2  1423.0     9.98264
      110  231.92 1252.2  3452.3  1387.9     6.17021
      111  232.30 1146.9  3480.4  1423.0    11.83551
      112  232.67 1207.7  3337.6  1411.3     9.56044
      113  233.05 1149.2  3309.5  1357.5     9.64247
      114  233.42 1189.0