% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equiv_premium.R
\name{equiv_premium}
\alias{equiv_premium}
\title{Equivalence Premium}
\usage{
equiv_premium(s, t, Lambda, R, dR, mu, r, n)
}
\arguments{
\item{s}{Initial timepoint}

\item{t}{End timepoint}

\item{Lambda}{Intensity matrix}

\item{R}{Reward matrix}

\item{dR}{Differential of reward matrix}

\item{mu}{Equivalence premium guess}

\item{r}{Constant rate as a scalar}

\item{n}{Number of steps for the Runge-Kutta algorithm}
}
\value{
A scalar
}
\description{
This function calculates the equivalence premium for an insurance contract.
}
\examples{
Lambda <- function(x) matrix(c(-0.1, 0.1, 0.05, -0.05), nrow = 2)
R <- function(x, mu) matrix(c(mu, 0, 0, mu), nrow = 2) # Corrected
dR <- function(x, mu) matrix(c(0.1, 0, 0, 0.1), nrow = 2)
equiv_premium(0, 80, Lambda, R, dR, 0.05, 0.03, 100)
}
