% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-create_model-likelihood.R
\name{create_model.likelihood}
\alias{create_model.likelihood}
\title{Parse the response variable and its likelihood model}
\usage{
create_model.likelihood(
  data,
  likelihood,
  c_hat,
  num_trials,
  y_name,
  sample_f,
  verbose
)
}
\arguments{
\item{data}{A \code{data.frame} where each column corresponds to one
variable, and each row is one observation. Continuous covariates and the
response variable must have type \code{"numeric"} and categorical covariates
must have type \code{"factor"}. Missing values should be indicated with
\code{NaN} or \code{NA}. The response variable cannot contain missing
values. Column names should not contain trailing or leading underscores.}

\item{likelihood}{Determines the observation model. Must be either
\code{"gaussian"} (default), \code{"poisson"}, \code{"nb"} (negative
binomial), \code{"binomial"} or \code{"bb"} (beta binomial).}

\item{c_hat}{The GP mean. This should only be given if \code{sample_f} is
\code{TRUE}, otherwise the GP will always have zero mean. If \code{sample_f}
is \code{TRUE}, the given \code{c_hat} can be a vector of length
\code{dim(data)[1]}, or a real number defining a constant GP mean. If not
specified and \code{sample_f} is \code{TRUE}, \code{c_hat} is set to
 \itemize{
   \item \code{c_hat = mean(y)}, if \code{likelihood} is \code{"gaussian"},
   \item \code{c_hat = } \code{log(mean(y))} if \code{likelihood} is
   \code{"poisson"} or \code{"nb"},
   \item \code{c_hat = } \code{log(p/(1-p))}, where
   \code{p = mean(y/num_trials)} if \code{likelihood} is \code{"binomial"}
   or \code{"bb"},
 }
where \code{y} denotes the response variable measurements.}

\item{num_trials}{This argument (number of trials) is only needed when
likelihood is \code{"binomial"} or \code{"bb"}. Must have length one or
equal to the number of data points. Setting \code{num_trials=1} and
\code{likelihood="binomial"} corresponds to Bernoulli observation model.}

\item{y_name}{Name of response variable}

\item{sample_f}{Determines if the latent function values are sampled
(must be \code{TRUE} if likelihood is not \code{"gaussian"}). If this is
\code{TRUE}, the response variable will be normalized to have zero mean
and unit variance.}

\item{verbose}{Should some informative messages be printed?}
}
\value{
a list of parsed options
}
\description{
Parse the response variable and its likelihood model
}
\seealso{
Other internal model creation functions: 
\code{\link{create_model.covs_and_comps}()},
\code{\link{create_model.formula}()},
\code{\link{create_model.prior}()}
}
\concept{internal model creation functions}
