% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-legend-group.R
\name{guide_legend_group}
\alias{guide_legend_group}
\title{Grouped legend}
\usage{
guide_legend_group(
  key = "group_split",
  title = waiver(),
  override.aes = list(),
  nrow = NULL,
  ncol = NULL,
  theme = NULL,
  position = NULL,
  direction = NULL,
  order = 0
)
}
\arguments{
\item{key}{A \link[=key_group]{group key} specification. Defaults to
\code{key_group_split()} to split labels to find groups.}

\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{override.aes}{A named \verb{<list>} specifying aesthetic parameters of the
key glyphs. See details and examples in
\code{\link[ggplot2:guide_legend]{guide_legend()}}.}

\item{nrow, ncol}{A positive \verb{<integer[1]>} setting the desired dimensions of
the legend layout. Either \code{nrow} or \code{ncol} can be set, but not both,}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}

\item{direction}{A \verb{<character[1]>} indicating the direction of the guide. Can be on of
\code{"horizontal"} or \code{"vertical"}.}

\item{order}{A positive \verb{<integer[1]>} that specifies the order of this guide among
multiple guides. This controls in which order guides are merged if there
are multiple guides for the same position. If \code{0} (default), the order is
determined by a hashing indicative settings of a guide.}
}
\value{
A \verb{<GuideLegend>} object.
}
\description{
This legend resembles \code{ggplot2::guide_legend()}, but has the ability to
keep groups in blocks with their own titles.
}
\examples{
# Standard plot for selection of `msleep`
df <- msleep[c(9, 28, 11, 5, 34, 54, 64, 24, 53), ]

p <- ggplot(df) +
  aes(bodywt, awake, colour = paste(order, name)) +
  geom_point()

# By default, groups are inferred from the name
p + guides(colour = "legend_group")

# You can also use a look-up table for groups
# The lookup table can be more expansive than just the data:
# We're using the full 'msleep' data here instead of the subset
lut <- key_group_lut(msleep$name, msleep$order)

p + aes(colour = name) +
  guides(colour = guide_legend_group(key = lut))

# `nrow` and `ncol` apply within groups
p + guides(colour = guide_legend_group(nrow = 1))

# Groups are arranged according to `direction`
p + guides(colour = guide_legend_group(ncol = 1, direction = "horizontal")) +
  theme(legend.title.position = "top")

# Customising the group titles
p + guides(colour = "legend_group") +
  theme(
    legendry.legend.subtitle.position = "left",
    legendry.legend.subtitle = element_text(
      hjust = 1, vjust = 1, size = rel(0.9),
      margin = margin(t = 5.5, r = 5.5)
    )
  )

# Changing the spacing between groups
p + guides(colour = "legend_group") +
  theme(legendry.group.spacing = unit(0, "cm"))
}
\seealso{
Other standalone guides: 
\code{\link{guide_axis_base}()},
\code{\link{guide_axis_dendro}()},
\code{\link{guide_axis_nested}()},
\code{\link{guide_circles}()},
\code{\link{guide_colbar}()},
\code{\link{guide_colring}()},
\code{\link{guide_colsteps}()},
\code{\link{guide_legend_base}()},
\code{\link{guide_legend_cross}()}

Other legend guides: 
\code{\link{guide_legend_base}()},
\code{\link{guide_legend_cross}()}
}
\concept{legend guides}
\concept{standalone guides}
