% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glify-lines.R, R/glify-points.R,
%   R/glify-polygons.R
\name{addGlPolylines}
\alias{addGlPolylines}
\alias{addGlPoints}
\alias{addGlPolygons}
\title{add polylines to a leaflet map using Leaflet.glify}
\usage{
addGlPolylines(
  map,
  data,
  color = cbind(0, 0.2, 1),
  opacity = 0.6,
  group = "glpolylines",
  popup = NULL,
  label = NULL,
  weight = 1,
  layerId = NULL,
  src = FALSE,
  pane = "overlayPane",
  ...
)

addGlPoints(
  map,
  data,
  fillColor = "#0033ff",
  fillOpacity = 0.8,
  radius = 10,
  group = "glpoints",
  popup = NULL,
  label = NULL,
  layerId = NULL,
  src = FALSE,
  pane = "overlayPane",
  ...
)

addGlPolygons(
  map,
  data,
  color = cbind(0, 0.2, 1),
  fillColor = color,
  fillOpacity = 0.8,
  group = "glpolygons",
  popup = NULL,
  label = NULL,
  layerId = NULL,
  src = FALSE,
  pane = "overlayPane",
  ...
)
}
\arguments{
\item{map}{a leaflet map to add points/polygons to.}

\item{data}{sf/sp point/polygon data to add to the map.}

\item{color}{Object representing the color. Can be of class integer, character with
color names, HEX codes or random characters, factor, matrix, data.frame, list, json or formula.
See the examples or \link{makeColorMatrix} for more information.}

\item{opacity}{feature opacity. Numeric between 0 and 1.
Note: expect funny results if you set this to < 1.}

\item{group}{a group name for the feature layer.}

\item{popup}{Object representing the popup. Can be of type character with column names,
formula, logical, data.frame or matrix, Spatial, list or JSON. If the length does not
match the number of rows in the dataset, the popup vector is repeated to match the dimension.}

\item{label}{either a column name (currently only supported for polygons and polylines)
or a character vector to be used as label.}

\item{weight}{line width/thicknes in pixels for \code{addGlPolylines}.}

\item{layerId}{the layer id}

\item{src}{whether to pass data to the widget via file attachments.}

\item{pane}{A string which defines the pane of the layer. The default is \code{"overlayPane"}.}

\item{...}{Used to pass additional named arguments to \code{\link[jsonify]{to_json}}
& to pass additional arguments to the underlying JavaScript functions. Typical
use-cases include setting 'digits' to round the point coordinates or to pass
a different 'fragmentShaderSource' to control the shape of the points. Use
'point' (default) to render circles with a thin black outline,
'simpleCircle' for circles without outline or
'sqaure' for squares (without outline).}

\item{fillColor}{fill color.}

\item{fillOpacity}{fill opacity.}

\item{radius}{point size in pixels.}
}
\description{
Leaflet.glify is a web gl renderer plugin for leaflet. See
  \url{https://github.com/robertleeplummerjr/Leaflet.glify} for details
  and documentation.
}
\details{
MULTILINESTRINGs are currently not supported! Make sure you cast your data
  to LINETSRING first (e.g. using \code{sf::st_cast(data, "LINESTRING")}.

MULTIPOLYGONs are currently not supported! Make sure you cast your data
  to POLYGON first (e.g. using \code{sf::st_cast(data, "POLYGON")}.
}
\section{Functions}{
\itemize{
\item \code{addGlPolylines()}: add polylines to a leaflet map using Leaflet.glify

\item \code{addGlPoints()}: add points to a leaflet map using Leaflet.glify

\item \code{addGlPolygons()}: add polygons to a leaflet map using Leaflet.glify

}}
\examples{
if (interactive()) {
library(leaflet)
library(leafgl)
library(sf)

storms = st_as_sf(atlStorms2005)

cols = heat.colors(nrow(storms))

leaflet() \%>\%
  addProviderTiles(provider = providers$CartoDB.Positron) \%>\%
  addGlPolylines(data = storms, color = cols, popup = TRUE, opacity = 1)
}

if (interactive()) {
library(leaflet)
library(leafgl)
library(sf)

n = 1e5

df1 = data.frame(id = 1:n,
                 x = rnorm(n, 10, 1),
                 y = rnorm(n, 49, 0.8))
pts = st_as_sf(df1, coords = c("x", "y"), crs = 4326)

cols = topo.colors(nrow(pts))

leaflet() \%>\%
  addProviderTiles(provider = providers$CartoDB.DarkMatter) \%>\%
  addGlPoints(data = pts, fillColor = cols, popup = TRUE)

}

if (interactive()) {
library(leaflet)
library(leafgl)
library(sf)

gadm = st_as_sf(gadmCHE)
gadm = st_cast(gadm, "POLYGON")
cols = grey.colors(nrow(gadm))

leaflet() \%>\%
  addProviderTiles(provider = providers$CartoDB.DarkMatter) \%>\%
  addGlPolygons(data = gadm, color = cols, popup = TRUE)
}

}
