% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{pad_sequences}
\alias{pad_sequences}
\title{Pads sequences to the same length}
\usage{
pad_sequences(
  sequences,
  maxlen = NULL,
  dtype = "int32",
  padding = "pre",
  truncating = "pre",
  value = 0
)
}
\arguments{
\item{sequences}{List of lists where each element is a sequence}

\item{maxlen}{int, maximum length of all sequences}

\item{dtype}{type of the output sequences}

\item{padding}{'pre' or 'post', pad either before or after each sequence.}

\item{truncating}{'pre' or 'post', remove values from sequences larger than
maxlen either in the beginning or in the end of the sequence}

\item{value}{float, padding value}
}
\value{
Matrix with dimensions (number_of_sequences, maxlen)
}
\description{
Pads sequences to the same length
}
\details{
This function transforms a list of \code{num_samples} sequences (lists
of integers) into a matrix of shape \verb{(num_samples, num_timesteps)}.
\code{num_timesteps} is either the \code{maxlen} argument if provided, or the length
of the longest sequence otherwise.

Sequences that are shorter than \code{num_timesteps} are padded with \code{value} at
the end.

Sequences longer than \code{num_timesteps} are truncated so that they fit the
desired length. The position where padding or truncation happens is
determined by the arguments \code{padding} and \code{truncating}, respectively.

Pre-padding is the default.
}
\seealso{
Other text preprocessing: 
\code{\link{make_sampling_table}()},
\code{\link{skipgrams}()},
\code{\link{text_hashing_trick}()},
\code{\link{text_one_hot}()},
\code{\link{text_to_word_sequence}()}
}
\concept{text preprocessing}
