% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_random_seed}
\alias{set_random_seed}
\title{Sets all random seeds (Python, NumPy, and backend framework, e.g. TF).}
\usage{
set_random_seed(seed)
}
\arguments{
\item{seed}{Integer, the random seed to use.}
}
\value{
No return value, called for side effects.
}
\description{
You can use this utility to make almost any Keras program fully
deterministic. Some limitations apply in cases where network communications
are involved (e.g. parameter server distribution), which creates additional
sources of randomness, or when certain non-deterministic cuDNN ops are
involved.

This sets:
\itemize{
\item the R session seed: \code{\link[=set.seed]{set.seed()}}
\item the Python session seed: \verb{import random; random.seed(seed)}
\item the Python NumPy seed: \verb{import numpy; numpy.random.seed(seed)}
\item the TensorFlow seed: \code{tf$random$set_seed(seed)} (only if TF is installed)
\item The Torch seed: \code{import("torch")$manual_seed(seed)} (only if the backend is torch)
\item and disables Python hash randomization.
}

Note that the TensorFlow seed is set even if you're not using TensorFlow
as your backend framework, since many workflows leverage \code{tf$data}
pipelines (which feature random shuffling). Likewise many workflows
might leverage NumPy APIs.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/utils/python_utils#setrandomseed-function}
}

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{zip_lists}()} \cr
}
\concept{utils}
