% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularizers.R
\name{regularizer_l2}
\alias{regularizer_l2}
\title{A regularizer that applies a L2 regularization penalty.}
\usage{
regularizer_l2(l2 = 0.01)
}
\arguments{
\item{l2}{float, L2 regularization factor.}
}
\value{
A \code{Regularizer} instance that can be passed to layer constructors or
used as a standalone object.
}
\description{
The L2 regularization penalty is computed as:
\code{loss = l2 * reduce_sum(square(x))}

L2 may be passed to a layer as a string identifier:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dense <- layer_dense(units = 3, kernel_regularizer='l2')
}\if{html}{\out{</div>}}

In this case, the default value used is \code{l2=0.01}.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/layers/regularizers#l2-class}
}

Other regularizers: \cr
\code{\link{regularizer_l1}()} \cr
\code{\link{regularizer_l1_l2}()} \cr
\code{\link{regularizer_orthogonal}()} \cr
}
\concept{regularizers}
