% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-preprocessing.R
\name{layer_pipeline}
\alias{layer_pipeline}
\title{Applies a series of layers to an input.}
\usage{
layer_pipeline(layers, name = NULL)
}
\arguments{
\item{layers}{A list of layers.}

\item{name}{String, name for the object}
}
\description{
This class is useful to build a preprocessing pipeline,
in particular an image data augmentation pipeline.
Compared to a \code{Sequential} model, \code{Pipeline} features
a few important differences:
\itemize{
\item It's not a \code{Model}, just a plain layer.
\item When the layers in the pipeline are compatible
with \code{tf.data}, the pipeline will also
remain \code{tf.data} compatible. That is to say,
the pipeline will not attempt to convert
its inputs to backend-native tensors
when in a tf.data context (unlike a \code{Sequential}
model).
}
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{preprocessing_pipeline <- layer_pipeline(c(
  layer_auto_contrast(, ),
  layer_random_zoom(, 0.2),
  layer_random_rotation(, 0.2)
))

# `ds` is a tf.data.Dataset of images
ds <- tfdatasets::tensor_slices_dataset(1:100) |>
  tfdatasets::dataset_map(\\(.x) \{
    random_normal(c(28, 28))
  \}) |>
  tfdatasets::dataset_batch(32)
  #|>
  # tfdatasets::dataset_take(4) |>
  # iterate() |> str()

preprocessed_ds <- ds |>
  tfdatasets::dataset_map(preprocessing_pipeline, num_parallel_calls = 4)
}\if{html}{\out{</div>}}
}

