% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/event_date.R
\docType{methods}
\name{density_event}
\alias{density_event}
\alias{density_event-method}
\alias{density_accumulation}
\alias{density_accumulation-method}
\alias{density_event,EventDate-method}
\alias{density_accumulation,EventDate-method}
\title{Density of Event and Accumulation Dates}
\usage{
density_event(object, ...)

density_accumulation(object, ...)

\S4method{density_event}{EventDate}(object, dates = NULL, calendar = NULL, n = 500, ...)

\S4method{density_accumulation}{EventDate}(
  object,
  dates = NULL,
  calendar = NULL,
  type = c("activity", "tempo"),
  n = 500,
  ...
)
}
\arguments{
\item{object}{An \code{\linkS4class{EventDate}} object.}

\item{...}{Currently not used.}

\item{dates}{A \code{\link{numeric}} vector of dates expressed as \code{calendar} years or
\emph{rata die} (if \code{calendar} is \code{NULL}).}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the calendar
of \code{dates} (see \code{\link[aion:calendar]{aion::calendar()}}). If \code{NULL} (the default), \emph{rata die} are
expected.}

\item{n}{A length-one non-negative \code{\link{numeric}} vector giving the desired
length of the vector of quantiles for density computation.}

\item{type}{A \code{\link{character}} string indicating the type of plot.
It must be one of "\code{activity}" (default) or "\code{tempo}" (see details).
Any unambiguous substring can be given.}
}
\value{
An \code{\link[aion:TimeSeries-class]{aion::TimeSeries}} object.
}
\description{
Estimates the event and accumulation density.
}
\examples{
## Data from Peeples and Schachner 2012
data("zuni", package = "folio")

## Assume that some assemblages are reliably dated (this is NOT a real example)
zuni_dates <- c(
  LZ0569 = 1097, LZ0279 = 1119, CS16 = 1328, LZ0066 = 1111,
  LZ0852 = 1216, LZ1209 = 1251, CS144 = 1262, LZ0563 = 1206,
  LZ0329 = 1076, LZ0005Q = 859, LZ0322 = 1109, LZ0067 = 863,
  LZ0578 = 1180, LZ0227 = 1104, LZ0610 = 1074
)

## Model the event and accumulation date for each assemblage
model <- event(zuni, zuni_dates, rank = 10)
plot(model, select = 1:10, event = TRUE, flip = TRUE)
}
\seealso{
Other event date tools: 
\code{\link{event}()},
\code{\link{model_event}},
\code{\link{predict_event}()}
}
\author{
N. Frerebeau
}
\concept{event date tools}
