% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_tools.R
\name{isit}
\alias{isit}
\alias{is_whole}
\alias{is_atvec}
\alias{is_numatvec}
\alias{is_nummat}
\alias{is_numarray}
\alias{is_symmetric}
\alias{is_pd}
\alias{is_pos}
\alias{is_integer}
\alias{is_natural}
\title{Is it?}
\usage{
is_whole(x, tol = .Machine$double.eps^0.5)

is_atvec(x)

is_numatvec(x)

is_nummat(x)

is_numarray(x)

is_symmetric(x)

is_pd(x)

is_pos(x)

is_integer(x)

is_natural(x)
}
\arguments{
\item{x}{numeric vector or matrix.}

\item{tol}{numeric. The tolerance for a numeric to be considered a whole
number.}
}
\value{
logical. TRUE or FALSE, depending on whether the object satisfies
the checks that define the characteristic.
}
\description{
A set of functions that check whether an object has the desired
characteristics.
}
\section{Functions}{
\itemize{
\item \code{is_whole()}: Is the object an integer in the mathematical sense?

\item \code{is_atvec()}: Is the object an atomic vector (not matrix or array)?

\item \code{is_numatvec()}: Is the object a numeric atomic vector?

\item \code{is_nummat()}: Is the object a numeric atomic matrix?

\item \code{is_numarray()}: Is the object a numeric atomic array?

\item \code{is_symmetric()}: Is the object a symmetric matrix?

\item \code{is_pd()}: Is the object a positive definite matrix?

\item \code{is_pos()}: Are all the elements finite and positive?

\item \code{is_integer()}: Is the object an integer in the mathematical sense?

\item \code{is_natural()}: Is the object a natural number in the mathematical sense?

}}
\keyword{internal}
