% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Stud.R
\name{Stud}
\alias{Stud}
\alias{d,Stud,numeric-method}
\alias{p,Stud,numeric-method}
\alias{qn,Stud,numeric-method}
\alias{r,Stud,numeric-method}
\alias{mean,Stud-method}
\alias{median,Stud-method}
\alias{mode,Stud-method}
\alias{var,Stud-method}
\alias{sd,Stud-method}
\alias{skew,Stud-method}
\alias{kurt,Stud-method}
\alias{entro,Stud-method}
\alias{llt}
\alias{ll,Stud,numeric-method}
\title{Student Distribution}
\usage{
Stud(df = 1)

\S4method{d}{Stud,numeric}(distr, x, log = FALSE)

\S4method{p}{Stud,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Stud,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Stud,numeric}(distr, n)

\S4method{mean}{Stud}(x)

\S4method{median}{Stud}(x)

\S4method{mode}{Stud}(x)

\S4method{var}{Stud}(x)

\S4method{sd}{Stud}(x)

\S4method{skew}{Stud}(x)

\S4method{kurt}{Stud}(x)

\S4method{entro}{Stud}(x)

llt(x, df)

\S4method{ll}{Stud,numeric}(distr, x)
}
\arguments{
\item{df}{numeric. The distribution degrees of freedom parameter.}

\item{distr}{an object of class \code{Stud}.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Stud}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Student's t-distribution is a continuous probability distribution used
primarily in hypothesis testing and in constructing confidence intervals for
small sample sizes. It is defined by one parameter: the degrees of freedom
\eqn{\nu > 0}.
}
\details{
The probability density function (PDF) of the Student's t-distribution is:
\deqn{ f(x; \nu) = \frac{\Gamma\left(\frac{\nu + 1}{2}\right)}{\sqrt{\nu\pi}\
\Gamma\left(\frac{\nu}{2}\right)}\left(1 + \frac{x^2}{\nu}\right)^{-\frac{\nu
+ 1}{2}} .}
}
\examples{
# -----------------------------------------------------
# Student Distribution Example
# -----------------------------------------------------

# Create the distribution
df <- 12
D <- Stud(df)

# ------------------
# dpqr Functions
# ------------------

d(D, c(-3, 0, 3)) # density function
p(D, c(-3, 0, 3)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
d1 <- d(D) ; d1(x) # d1 is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
median(D) # Median
mode(D) # Mode
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llt(x, df)

}
\seealso{
Functions from the \code{stats} package: \code{\link[=dt]{dt()}}, \code{\link[=pt]{pt()}}, \code{\link[=qt]{qt()}}, \code{\link[=rt]{rt()}}
}
