% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Multigam.R
\name{Multigam}
\alias{Multigam}
\alias{dmultigam}
\alias{rmultigam}
\alias{d,Multigam,numeric-method}
\alias{d,Multigam,matrix-method}
\alias{r,Multigam,numeric-method}
\alias{mean,Multigam-method}
\alias{var,Multigam-method}
\alias{finf,Multigam-method}
\alias{llmultigam}
\alias{ll,Multigam,matrix-method}
\alias{emultigam}
\alias{mle,Multigam,matrix-method}
\alias{me,Multigam,matrix-method}
\alias{same,Multigam,matrix-method}
\alias{vmultigam}
\alias{avar_mle,Multigam-method}
\alias{avar_me,Multigam-method}
\alias{avar_same,Multigam-method}
\title{Multivariate Gamma Distribution}
\usage{
Multigam(shape = 1, scale = 1)

dmultigam(x, shape, scale, log = FALSE)

rmultigam(n, shape, scale)

\S4method{d}{Multigam,numeric}(distr, x, log = FALSE)

\S4method{d}{Multigam,matrix}(distr, x, log = FALSE)

\S4method{r}{Multigam,numeric}(distr, n)

\S4method{mean}{Multigam}(x)

\S4method{var}{Multigam}(x)

\S4method{finf}{Multigam}(x)

llmultigam(x, shape, scale)

\S4method{ll}{Multigam,matrix}(distr, x)

emultigam(x, type = "mle", ...)

\S4method{mle}{Multigam,matrix}(
  distr,
  x,
  par0 = "same",
  method = "L-BFGS-B",
  lower = 1e-05,
  upper = Inf,
  na.rm = FALSE
)

\S4method{me}{Multigam,matrix}(distr, x, na.rm = FALSE)

\S4method{same}{Multigam,matrix}(distr, x, na.rm = FALSE)

vmultigam(shape, scale, type = "mle")

\S4method{avar_mle}{Multigam}(distr)

\S4method{avar_me}{Multigam}(distr)

\S4method{avar_same}{Multigam}(distr)
}
\arguments{
\item{shape, scale}{numeric. The non-negative distribution parameters.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Multigam}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log}{logical. Should the logarithm of the probability be
returned?}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{distr}{an object of class \code{Multigam}.}

\item{type}{character, case ignored. The estimator type (mle, me, or same).}

\item{...}{extra arguments.}

\item{par0, method, lower, upper}{arguments passed to optim for the mle
optimization. See Details.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The multivariate gamma distribution is a multivariate absolute continuous
probability distribution, defined as the cumulative sum of independent
gamma random variables with possibly different shape parameters
\eqn{\alpha_i > 0, i\in\{1, \dots, k\}} and the same scale \eqn{\beta > 0}.
}
\details{
The probability density function (PDF) of the multivariate gamma distribution
is given by:
\deqn{ f(x; \alpha, \beta) =
\frac{\beta^{-\alpha_0}}{\prod_{i=1}^k\Gamma(\alpha_i)}, e^{-x_k/\beta}
x_1^{\alpha_1-1}\prod_{i=1}^k (x_i - x_{i-1})^{(\alpha_i-1)} \quad x > 0. }

The MLE of the multigamma distribution parameters is not available in closed
form and has to be approximated numerically. This is done with \code{optim()}.
Specifically, instead of solving a \eqn{(k+1)} optimization problem w.r.t
\eqn{\alpha, \beta}, the optimization can be performed on the shape parameter
sum \eqn{\alpha_0:=\sum_{i=1}^k\alpha \in(0,+\infty)^k}. The default method
used is the L-BFGS-B method with lower bound \code{1e-5} and upper bound \code{Inf}.
The \code{par0} argument can either be a numeric (satisfying
\verb{lower <= par0 <= upper}) or a character specifying the closed-form estimator
to be used as initialization for the algorithm (\code{"me"} or \code{"same"} - the
default value).
}
\examples{
# -----------------------------------------------------
# Multivariate Gamma Distribution Example
# -----------------------------------------------------

# Create the distribution
a <- c(0.5, 3, 5) ; b <- 5
D <- Multigam(a, b)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0.3, 2, 10)) # density function

# alternative way to use the function
df <- d(D) ; df(c(0.3, 2, 10)) # df is a function itself

x <- r(D, 100) # random generator function

# ------------------
# Moments
# ------------------

mean(D) # Expectation
var(D) # Variance
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llmultigam(x, a, b)

emultigam(x, type = "mle")
emultigam(x, type = "me")
emultigam(x, type = "same")

mle(D, x)
me(D, x)
same(D, x)
e(D, x, type = "mle")

mle("multigam", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vmultigam(a, b, type = "mle")
vmultigam(a, b, type = "me")
vmultigam(a, b, type = "same")

avar_mle(D)
avar_me(D)
avar_same(D)

v(D, type = "mle")
}
\references{
\itemize{
\item Mathal, A. M., & Moschopoulos, P. G. (1992). A form of multivariate gamma
distribution. Annals of the Institute of Statistical Mathematics, 44, 97-106.
\item Oikonomidis, I. & Trevezas, S. (2025), Moment-Type Estimators for the
Dirichlet and the Multivariate Gamma Distributions, arXiv,
https://arxiv.org/abs/2311.15025
}
}
