% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Lnorm.R
\name{Lnorm}
\alias{Lnorm}
\alias{d,Lnorm,numeric-method}
\alias{p,Lnorm,numeric-method}
\alias{qn,Lnorm,numeric-method}
\alias{r,Lnorm,numeric-method}
\alias{mean,Lnorm-method}
\alias{median,Lnorm-method}
\alias{mode,Lnorm-method}
\alias{var,Lnorm-method}
\alias{sd,Lnorm-method}
\alias{skew,Lnorm-method}
\alias{kurt,Lnorm-method}
\alias{entro,Lnorm-method}
\alias{finf,Lnorm-method}
\alias{lllnorm}
\alias{ll,Lnorm,numeric-method}
\alias{elnorm}
\alias{mle,Lnorm,numeric-method}
\alias{me,Lnorm,numeric-method}
\alias{vlnorm}
\alias{avar_mle,Lnorm-method}
\alias{avar_me,Lnorm-method}
\title{Log-Normal Distribution}
\usage{
Lnorm(meanlog = 0, sdlog = 1)

\S4method{d}{Lnorm,numeric}(distr, x, log = FALSE)

\S4method{p}{Lnorm,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Lnorm,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Lnorm,numeric}(distr, n)

\S4method{mean}{Lnorm}(x)

\S4method{median}{Lnorm}(x)

\S4method{mode}{Lnorm}(x)

\S4method{var}{Lnorm}(x)

\S4method{sd}{Lnorm}(x)

\S4method{skew}{Lnorm}(x)

\S4method{kurt}{Lnorm}(x)

\S4method{entro}{Lnorm}(x)

\S4method{finf}{Lnorm}(x)

lllnorm(x, meanlog, sdlog)

\S4method{ll}{Lnorm,numeric}(distr, x)

elnorm(x, type = "mle", ...)

\S4method{mle}{Lnorm,numeric}(distr, x, na.rm = FALSE)

\S4method{me}{Lnorm,numeric}(distr, x, na.rm = FALSE)

vlnorm(meanlog, sdlog, type = "mle")

\S4method{avar_mle}{Lnorm}(distr)

\S4method{avar_me}{Lnorm}(distr)
}
\arguments{
\item{meanlog, sdlog}{numeric. The distribution parameters.}

\item{distr}{an object of class \code{Lnorm}.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Lnorm}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Lognormal distribution is an absolute continuous probability distribution
of a random variable whose logarithm is normally distributed. It is defined
by parameters \eqn{\mu} and \eqn{\sigma > 0}, which are the mean and standard
deviation of the underlying normal distribution.
}
\details{
The probability density function (PDF) of the Lognormal distribution is:
\deqn{ f(x; \mu, \sigma) = \frac{1}{x \sigma \sqrt{2\pi}} e^{-\frac{(\log x -
\mu)^2}{2 \sigma^2}}, \quad x > 0 .}
}
\examples{
# -----------------------------------------------------
# Lnorm Distribution Example
# -----------------------------------------------------

# Create the distribution
m <- 3 ; s <- 5
D <- Lnorm(m, s)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0.3, 2, 10)) # density function
p(D, c(0.3, 2, 10)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
median(D) # Median
mode(D) # Mode
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

elnorm(x, type = "mle")
elnorm(x, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

mle("lnorm", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vlnorm(m, s, type = "mle")
vlnorm(m, s, type = "me")

avar_mle(D)
avar_me(D)

v(D, type = "mle")
}
\seealso{
Functions from the \code{stats} package: \code{\link[=dlnorm]{dlnorm()}}, \code{\link[=plnorm]{plnorm()}}, \code{\link[=qlnorm]{qlnorm()}},
\code{\link[=rlnorm]{rlnorm()}}
}
