% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_metrics.R
\name{LargeMetrics}
\alias{LargeMetrics}
\alias{large_metrics}
\title{Large Sample Metrics}
\usage{
LargeMetrics(D, est, df)

large_metrics(D, prm, est = c("same", "me", "mle"), ...)
}
\arguments{
\item{D}{A subclass of \code{Distribution}. The distribution family of interest.}

\item{est}{character. The estimator of interest. Can be a vector.}

\item{df}{data.frame. a data.frame with columns named "Row", "Col",
"Parameter", "Estimator", and "Value".}

\item{prm}{A list containing three elements (name, pos, val). See Details.}

\item{...}{extra arguments.}
}
\value{
An object of class \code{LargeMetrics} with slots \code{D}, \code{est}, and \code{df}.
}
\description{
This function calculates the asymptotic variance - covariance matrix
characterizing the large sample (asymptotic) behavior of an estimator. The
function evaluates the metrics as a function of a single parameter, keeping
the other ones constant. See Details.
}
\details{
The distribution \code{D} is used to specify an initial distribution. The list
\code{prm} contains details concerning a single parameter that is allowed to
change values. The quantity of interest is evaluated as a function of this
parameter.

The \code{prm} list includes two elements named "name" and "val". The first one
specifies the parameter that changes, and the second one is a numeric vector
holding the values it takes.

In case the parameter of interest is a vector, a third element named "pos"
can be specified to indicate the exact parameter that changes. In the example
shown below, the evaluation will be performed for the Dirichlet distributions
with shape parameters \verb{(0.5, 1)}, \verb{(0.6, 1)}, ..., \verb{(2, 1)}. Notice that the
initial shape parameter value (\code{1}) is not utilized in the function.
}
\examples{
\donttest{
# -----------------------------------------------------
# Beta Distribution Example
# -----------------------------------------------------

D <- Beta(shape1 = 1, shape2 = 2)

prm <- list(name = "shape1",
            val = seq(0.5, 2, by = 0.1))

x <- large_metrics(D, prm,
                   est = c("mle", "me", "same"))

plot(x)

# -----------------------------------------------------
# Dirichlet Distribution Example
# -----------------------------------------------------

D <- Dir(alpha = 1:2)

prm <- list(name = "alpha",
            pos = 1,
            val = seq(0.5, 2, by = 0.1))

x <- large_metrics(D, prm,
                   est = c("mle", "me", "same"))

plot(x)
}
}
\seealso{
\link{SmallMetrics}, \link{PlotMetrics}
}
