% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Bern.R
\name{Bern}
\alias{Bern}
\alias{dbern}
\alias{pbern}
\alias{qbern}
\alias{rbern}
\alias{d,Bern,numeric-method}
\alias{p,Bern,numeric-method}
\alias{qn,Bern,numeric-method}
\alias{r,Bern,numeric-method}
\alias{mean,Bern-method}
\alias{median,Bern-method}
\alias{mode,Bern-method}
\alias{var,Bern-method}
\alias{sd,Bern-method}
\alias{skew,Bern-method}
\alias{kurt,Bern-method}
\alias{entro,Bern-method}
\alias{finf,Bern-method}
\alias{llbern}
\alias{ll,Bern,numeric-method}
\alias{ebern}
\alias{mle,Bern,numeric-method}
\alias{me,Bern,numeric-method}
\alias{vbern}
\alias{avar_mle,Bern-method}
\alias{avar_me,Bern-method}
\title{Bern Distribution}
\usage{
Bern(prob = 0.5)

dbern(x, prob, log = FALSE)

pbern(q, prob, lower.tail = TRUE, log.p = FALSE)

qbern(p, prob, lower.tail = TRUE, log.p = FALSE)

rbern(n, prob)

\S4method{d}{Bern,numeric}(distr, x, log = FALSE)

\S4method{p}{Bern,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Bern,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Bern,numeric}(distr, n)

\S4method{mean}{Bern}(x)

\S4method{median}{Bern}(x)

\S4method{mode}{Bern}(x)

\S4method{var}{Bern}(x)

\S4method{sd}{Bern}(x)

\S4method{skew}{Bern}(x)

\S4method{kurt}{Bern}(x)

\S4method{entro}{Bern}(x)

\S4method{finf}{Bern}(x)

llbern(x, prob)

\S4method{ll}{Bern,numeric}(distr, x)

ebern(x, type = "mle", ...)

\S4method{mle}{Bern,numeric}(distr, x, na.rm = FALSE)

\S4method{me}{Bern,numeric}(distr, x, na.rm = FALSE)

vbern(prob, type = "mle")

\S4method{avar_mle}{Bern}(distr)

\S4method{avar_me}{Bern}(distr)
}
\arguments{
\item{prob}{numeric. Probability of success.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Bern}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{distr}{an object of class \code{Bern}.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Bernoulli distribution is a discrete probability distribution which takes
the value 1 with probability \eqn{p} and the value 0 with probability
\eqn{1 - p}, where \eqn{0 \leq p \leq 1}.
}
\details{
The probability mass function (PMF) of the Bernoulli distribution is given
by: \deqn{ f(x; p) = p^x (1 - p)^{1 - x}, \quad p \in (0, 1), \quad x \in
\{0, 1\}.}
}
\examples{
# -----------------------------------------------------
# Bernoulli Distribution Example
# -----------------------------------------------------

# Create the distribution
p <- 0.7
D <- Bern(p)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0, 1)) # density function
p(D, c(0, 1)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
median(D) # Median
mode(D) # Mode
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llbern(x, p)

ebern(x, type = "mle")
ebern(x, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

mle("bern", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vbern(p, type = "mle")
vbern(p, type = "me")

avar_mle(D)
avar_me(D)

v(D, type = "mle")
}
\seealso{
Functions from the \code{stats} package: \code{\link[=dbinom]{dbinom()}}, \code{\link[=pbinom]{pbinom()}}, \code{\link[=qbinom]{qbinom()}},
\code{\link[=rbinom]{rbinom()}}
}
